/*
 * Decompiled with CFR 0.152.
 */
package android.telephony.ims.feature;

import android.annotation.SystemApi;
import android.content.Context;
import android.net.Uri;
import android.os.RemoteException;
import android.telephony.ims.aidl.CapabilityExchangeAidlWrapper;
import android.telephony.ims.aidl.ICapabilityExchangeEventListener;
import android.telephony.ims.aidl.IImsCapabilityCallback;
import android.telephony.ims.aidl.IImsRcsFeature;
import android.telephony.ims.aidl.IOptionsResponseCallback;
import android.telephony.ims.aidl.IPublishResponseCallback;
import android.telephony.ims.aidl.ISubscribeResponseCallback;
import android.telephony.ims.aidl.RcsOptionsResponseAidlWrapper;
import android.telephony.ims.aidl.RcsPublishResponseAidlWrapper;
import android.telephony.ims.aidl.RcsSubscribeResponseAidlWrapper;
import android.telephony.ims.feature.CapabilityChangeRequest;
import android.telephony.ims.feature.ImsFeature;
import android.telephony.ims.stub.CapabilityExchangeEventListener;
import android.telephony.ims.stub.RcsCapabilityExchangeImplBase;
import android.util.Log;
import com.android.internal.telephony.util.TelephonyUtils;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.function.Supplier;

@SystemApi
public class RcsFeature
extends ImsFeature {
    private static final String LOG_TAG = "RcsFeature";
    private final Executor mExecutor;
    private final RcsFeatureBinder mImsRcsBinder;
    private RcsCapabilityExchangeImplBase mCapabilityExchangeImpl;
    private CapabilityExchangeEventListener mCapExchangeEventListener;

    @Deprecated
    public RcsFeature() {
        this.mExecutor = Runnable::run;
        this.mImsRcsBinder = new RcsFeatureBinder(this, this.mExecutor);
    }

    public RcsFeature(Executor executor) {
        if (executor == null) {
            throw new IllegalArgumentException("executor can not be null.");
        }
        this.mExecutor = executor;
        this.mImsRcsBinder = new RcsFeatureBinder(this, this.mExecutor);
    }

    @Override
    public void initialize(Context context, int slotId) {
        super.initialize(context, slotId);
        this.mExecutor.execute(() -> this.onFeatureReady());
    }

    @Override
    public RcsImsCapabilities queryCapabilityStatus() {
        return new RcsImsCapabilities(super.queryCapabilityStatus());
    }

    public void notifyCapabilitiesStatusChanged(RcsImsCapabilities capabilities) {
        if (capabilities == null) {
            throw new IllegalArgumentException("RcsImsCapabilities must be non-null!");
        }
        super.notifyCapabilitiesStatusChanged(capabilities);
    }

    @Override
    public boolean queryCapabilityConfiguration(int capability, int radioTech) {
        return false;
    }

    @Override
    public void changeEnabledCapabilities(CapabilityChangeRequest request, ImsFeature.CapabilityCallbackProxy callback2) {
    }

    public RcsCapabilityExchangeImplBase createCapabilityExchangeImpl(CapabilityExchangeEventListener listener2) {
        return new RcsCapabilityExchangeImplBase();
    }

    public void destroyCapabilityExchangeImpl(RcsCapabilityExchangeImplBase capExchangeImpl) {
    }

    @Override
    public void onFeatureRemoved() {
    }

    @Override
    public void onFeatureReady() {
    }

    @Override
    public IImsRcsFeature getBinder() {
        return this.mImsRcsBinder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setCapabilityExchangeEventListener(CapabilityExchangeEventListener listener2) {
        Object object = this.mLock;
        synchronized (object) {
            this.mCapExchangeEventListener = listener2;
            if (this.mCapExchangeEventListener != null) {
                this.initRcsCapabilityExchangeImplBase(this.mCapExchangeEventListener);
            } else {
                if (this.mCapabilityExchangeImpl != null) {
                    this.destroyCapabilityExchangeImpl(this.mCapabilityExchangeImpl);
                }
                this.mCapabilityExchangeImpl = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initRcsCapabilityExchangeImplBase(CapabilityExchangeEventListener listener2) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mCapabilityExchangeImpl != null) {
                this.destroyCapabilityExchangeImpl(this.mCapabilityExchangeImpl);
            }
            this.mCapabilityExchangeImpl = this.createCapabilityExchangeImpl(listener2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RcsCapabilityExchangeImplBase getCapabilityExchangeImplBaseInternal() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mCapabilityExchangeImpl == null) {
                throw new IllegalStateException("Session is not available.");
            }
            return this.mCapabilityExchangeImpl;
        }
    }

    public static class RcsImsCapabilities
    extends ImsFeature.Capabilities {
        public static final int CAPABILITY_TYPE_NONE = 0;
        public static final int CAPABILITY_TYPE_OPTIONS_UCE = 1;
        public static final int CAPABILITY_TYPE_PRESENCE_UCE = 2;

        public RcsImsCapabilities(int capabilities) {
            super(capabilities);
        }

        private RcsImsCapabilities(ImsFeature.Capabilities capabilities) {
            super(capabilities.getMask());
        }

        @Override
        public void addCapabilities(int capabilities) {
            super.addCapabilities(capabilities);
        }

        @Override
        public void removeCapabilities(int capabilities) {
            super.removeCapabilities(capabilities);
        }

        @Override
        public boolean isCapable(int capabilities) {
            return super.isCapable(capabilities);
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface RcsImsCapabilityFlag {
        }
    }

    private static class RcsFeatureBinder
    extends IImsRcsFeature.Stub {
        private final RcsFeature mReference;
        private final Executor mExecutor;

        RcsFeatureBinder(RcsFeature classRef, Executor executor) {
            this.mReference = classRef;
            this.mExecutor = executor;
        }

        @Override
        public int queryCapabilityStatus() throws RemoteException {
            return this.executeMethodAsyncForResult(() -> this.mReference.queryCapabilityStatus().mCapabilities, "queryCapabilityStatus");
        }

        @Override
        public void addCapabilityCallback(IImsCapabilityCallback c) throws RemoteException {
            this.executeMethodAsync(() -> this.mReference.addCapabilityCallback(c), "addCapabilityCallback");
        }

        @Override
        public void removeCapabilityCallback(IImsCapabilityCallback c) throws RemoteException {
            this.executeMethodAsync(() -> this.mReference.removeCapabilityCallback(c), "removeCapabilityCallback");
        }

        @Override
        public void changeCapabilitiesConfiguration(CapabilityChangeRequest r, IImsCapabilityCallback c) throws RemoteException {
            this.executeMethodAsync(() -> this.mReference.requestChangeEnabledCapabilities(r, c), "changeCapabilitiesConfiguration");
        }

        @Override
        public void queryCapabilityConfiguration(int capability, int radioTech, IImsCapabilityCallback c) throws RemoteException {
            this.executeMethodAsync(() -> this.mReference.queryCapabilityConfigurationInternal(capability, radioTech, c), "queryCapabilityConfiguration");
        }

        @Override
        public int getFeatureState() throws RemoteException {
            return this.executeMethodAsyncForResult(this.mReference::getFeatureState, "getFeatureState");
        }

        @Override
        public void setCapabilityExchangeEventListener(ICapabilityExchangeEventListener listener2) throws RemoteException {
            CapabilityExchangeAidlWrapper listenerWrapper = new CapabilityExchangeAidlWrapper(listener2);
            this.executeMethodAsync(() -> this.mReference.setCapabilityExchangeEventListener(listenerWrapper), "setCapabilityExchangeEventListener");
        }

        @Override
        public void publishCapabilities(String pidfXml, IPublishResponseCallback callback2) throws RemoteException {
            RcsPublishResponseAidlWrapper callbackWrapper = new RcsPublishResponseAidlWrapper(callback2);
            this.executeMethodAsync(() -> this.mReference.getCapabilityExchangeImplBaseInternal().publishCapabilities(pidfXml, callbackWrapper), "publishCapabilities");
        }

        @Override
        public void subscribeForCapabilities(List<Uri> uris, ISubscribeResponseCallback callback2) throws RemoteException {
            RcsSubscribeResponseAidlWrapper wrapper = new RcsSubscribeResponseAidlWrapper(callback2);
            this.executeMethodAsync(() -> this.mReference.getCapabilityExchangeImplBaseInternal().subscribeForCapabilities(uris, wrapper), "subscribeForCapabilities");
        }

        @Override
        public void sendOptionsCapabilityRequest(Uri contactUri, List<String> myCapabilities, IOptionsResponseCallback callback2) throws RemoteException {
            RcsOptionsResponseAidlWrapper callbackWrapper = new RcsOptionsResponseAidlWrapper(callback2);
            this.executeMethodAsync(() -> this.mReference.getCapabilityExchangeImplBaseInternal().sendOptionsCapabilityRequest(contactUri, new HashSet<String>(myCapabilities), callbackWrapper), "sendOptionsCapabilityRequest");
        }

        private void executeMethodAsync(Runnable r, String errorLogName) throws RemoteException {
            try {
                CompletableFuture.runAsync(() -> TelephonyUtils.runWithCleanCallingIdentity(r), this.mExecutor).join();
            }
            catch (CancellationException | CompletionException e) {
                Log.w(RcsFeature.LOG_TAG, "RcsFeatureBinder - " + errorLogName + " exception: " + e.getMessage());
                throw new RemoteException(e.getMessage());
            }
        }

        private <T> T executeMethodAsyncForResult(Supplier<T> r, String errorLogName) throws RemoteException {
            CompletableFuture<Object> future2 = CompletableFuture.supplyAsync(() -> TelephonyUtils.runWithCleanCallingIdentity(r), this.mExecutor);
            try {
                return (T)future2.get();
            }
            catch (InterruptedException | ExecutionException e) {
                Log.w(RcsFeature.LOG_TAG, "RcsFeatureBinder - " + errorLogName + " exception: " + e.getMessage());
                throw new RemoteException(e.getMessage());
            }
        }
    }
}

