/*
 * Decompiled with CFR 0.152.
 */
package android.telephony.ims.aidl;

import android.net.Uri;
import android.os.Binder;
import android.os.RemoteException;
import android.telephony.ims.ImsException;
import android.telephony.ims.RcsContactUceCapability;
import android.telephony.ims.aidl.ICapabilityExchangeEventListener;
import android.telephony.ims.aidl.IOptionsRequestCallback;
import android.telephony.ims.stub.CapabilityExchangeEventListener;
import android.util.Log;
import java.util.ArrayList;
import java.util.Set;

public class CapabilityExchangeAidlWrapper
implements CapabilityExchangeEventListener {
    private static final String LOG_TAG = "CapExchangeListener";
    private final ICapabilityExchangeEventListener mListenerBinder;

    public CapabilityExchangeAidlWrapper(ICapabilityExchangeEventListener listener2) {
        this.mListenerBinder = listener2;
    }

    @Override
    public void onRequestPublishCapabilities(int publishTriggerType) throws ImsException {
        ICapabilityExchangeEventListener listener2 = this.mListenerBinder;
        if (listener2 == null) {
            return;
        }
        try {
            listener2.onRequestPublishCapabilities(publishTriggerType);
        }
        catch (RemoteException e) {
            Log.w(LOG_TAG, "request publish capabilities exception: " + e);
            throw new ImsException("Remote is not available", 1);
        }
    }

    @Override
    public void onUnpublish() throws ImsException {
        ICapabilityExchangeEventListener listener2 = this.mListenerBinder;
        if (listener2 == null) {
            return;
        }
        try {
            listener2.onUnpublish();
        }
        catch (RemoteException e) {
            Log.w(LOG_TAG, "Unpublish exception: " + e);
            throw new ImsException("Remote is not available", 1);
        }
    }

    @Override
    public void onRemoteCapabilityRequest(Uri contactUri, Set<String> remoteCapabilities, final CapabilityExchangeEventListener.OptionsRequestCallback callback2) throws ImsException {
        ICapabilityExchangeEventListener listener2 = this.mListenerBinder;
        if (listener2 == null) {
            return;
        }
        IOptionsRequestCallback.Stub internalCallback = new IOptionsRequestCallback.Stub(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void respondToCapabilityRequest(RcsContactUceCapability ownCapabilities, boolean isBlocked) {
                long callingIdentity = Binder.clearCallingIdentity();
                try {
                    callback2.onRespondToCapabilityRequest(ownCapabilities, isBlocked);
                }
                finally {
                    1.restoreCallingIdentity(callingIdentity);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void respondToCapabilityRequestWithError(int code, String reason) {
                long callingIdentity = Binder.clearCallingIdentity();
                try {
                    callback2.onRespondToCapabilityRequestWithError(code, reason);
                }
                finally {
                    1.restoreCallingIdentity(callingIdentity);
                }
            }
        };
        try {
            listener2.onRemoteCapabilityRequest(contactUri, new ArrayList<String>(remoteCapabilities), internalCallback);
        }
        catch (RemoteException e) {
            Log.w(LOG_TAG, "Remote capability request exception: " + e);
            throw new ImsException("Remote is not available", 1);
        }
    }
}

