/*
 * Decompiled with CFR 0.152.
 */
package android.telephony.ims;

import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.content.Context;
import android.net.Uri;
import android.os.Binder;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.ServiceSpecificException;
import android.telephony.TelephonyFrameworkInitializer;
import android.telephony.ims.ImsException;
import android.telephony.ims.RcsContactUceCapability;
import android.telephony.ims.aidl.IImsRcsController;
import android.telephony.ims.aidl.IRcsUceControllerCallback;
import android.telephony.ims.aidl.IRcsUcePublishStateCallback;
import android.util.Log;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;

public class RcsUceAdapter {
    private static final String TAG = "RcsUceAdapter";
    public static final int CAPABILITY_TYPE_OPTIONS_UCE = 1;
    @SystemApi
    public static final int CAPABILITY_TYPE_PRESENCE_UCE = 2;
    @SystemApi
    public static final int ERROR_GENERIC_FAILURE = 1;
    @SystemApi
    public static final int ERROR_NOT_ENABLED = 2;
    @SystemApi
    public static final int ERROR_NOT_AVAILABLE = 3;
    @SystemApi
    public static final int ERROR_NOT_REGISTERED = 4;
    @SystemApi
    public static final int ERROR_NOT_AUTHORIZED = 5;
    @SystemApi
    public static final int ERROR_FORBIDDEN = 6;
    @SystemApi
    public static final int ERROR_NOT_FOUND = 7;
    @SystemApi
    public static final int ERROR_REQUEST_TOO_LARGE = 8;
    @SystemApi
    public static final int ERROR_REQUEST_TIMEOUT = 9;
    @SystemApi
    public static final int ERROR_INSUFFICIENT_MEMORY = 10;
    @SystemApi
    public static final int ERROR_LOST_NETWORK = 11;
    @SystemApi
    public static final int ERROR_SERVER_UNAVAILABLE = 12;
    @SystemApi
    public static final int CAPABILITY_UPDATE_TRIGGER_UNKNOWN = 0;
    @SystemApi
    public static final int CAPABILITY_UPDATE_TRIGGER_ETAG_EXPIRED = 1;
    @SystemApi
    public static final int CAPABILITY_UPDATE_TRIGGER_MOVE_TO_LTE_VOPS_DISABLED = 2;
    @SystemApi
    public static final int CAPABILITY_UPDATE_TRIGGER_MOVE_TO_LTE_VOPS_ENABLED = 3;
    @SystemApi
    public static final int CAPABILITY_UPDATE_TRIGGER_MOVE_TO_EHRPD = 4;
    @SystemApi
    public static final int CAPABILITY_UPDATE_TRIGGER_MOVE_TO_HSPAPLUS = 5;
    @SystemApi
    public static final int CAPABILITY_UPDATE_TRIGGER_MOVE_TO_3G = 6;
    @SystemApi
    public static final int CAPABILITY_UPDATE_TRIGGER_MOVE_TO_2G = 7;
    @SystemApi
    public static final int CAPABILITY_UPDATE_TRIGGER_MOVE_TO_WLAN = 8;
    @SystemApi
    public static final int CAPABILITY_UPDATE_TRIGGER_MOVE_TO_IWLAN = 9;
    @SystemApi
    public static final int CAPABILITY_UPDATE_TRIGGER_MOVE_TO_NR5G_VOPS_DISABLED = 10;
    @SystemApi
    public static final int CAPABILITY_UPDATE_TRIGGER_MOVE_TO_NR5G_VOPS_ENABLED = 11;
    @SystemApi
    public static final int PUBLISH_STATE_OK = 1;
    @SystemApi
    public static final int PUBLISH_STATE_NOT_PUBLISHED = 2;
    @SystemApi
    public static final int PUBLISH_STATE_VOICE_PROVISION_ERROR = 3;
    @SystemApi
    public static final int PUBLISH_STATE_RCS_PROVISION_ERROR = 4;
    @SystemApi
    public static final int PUBLISH_STATE_REQUEST_TIMEOUT = 5;
    @SystemApi
    public static final int PUBLISH_STATE_OTHER_ERROR = 6;
    private final Context mContext;
    private final int mSubId;
    private final Map<OnPublishStateChangedListener, PublishStateCallbackAdapter> mPublishStateCallbacks;

    RcsUceAdapter(Context context, int subId) {
        this.mContext = context;
        this.mSubId = subId;
        this.mPublishStateCallbacks = new HashMap<OnPublishStateChangedListener, PublishStateCallbackAdapter>();
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.ACCESS_RCS_USER_CAPABILITY_EXCHANGE", "android.permission.READ_CONTACTS"})
    public void requestCapabilities(Collection<Uri> contactNumbers, final Executor executor, final CapabilitiesCallback c) throws ImsException {
        if (c == null) {
            throw new IllegalArgumentException("Must include a non-null CapabilitiesCallback.");
        }
        if (executor == null) {
            throw new IllegalArgumentException("Must include a non-null Executor.");
        }
        if (contactNumbers == null) {
            throw new IllegalArgumentException("Must include non-null contact number list.");
        }
        IImsRcsController imsRcsController = this.getIImsRcsController();
        if (imsRcsController == null) {
            Log.e(TAG, "requestCapabilities: IImsRcsController is null");
            throw new ImsException("Can not find remote IMS service", 1);
        }
        IRcsUceControllerCallback.Stub internalCallback = new IRcsUceControllerCallback.Stub(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCapabilitiesReceived(List<RcsContactUceCapability> contactCapabilities) {
                long callingIdentity = Binder.clearCallingIdentity();
                try {
                    executor.execute(() -> c.onCapabilitiesReceived(contactCapabilities));
                }
                finally {
                    1.restoreCallingIdentity(callingIdentity);
                }
            }

            @Override
            public void onComplete() {
                long callingIdentity = Binder.clearCallingIdentity();
                try {
                    executor.execute(() -> c.onComplete());
                }
                finally {
                    1.restoreCallingIdentity(callingIdentity);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onError(int errorCode, long retryAfterMilliseconds) {
                long callingIdentity = Binder.clearCallingIdentity();
                try {
                    executor.execute(() -> c.onError(errorCode, retryAfterMilliseconds));
                }
                finally {
                    1.restoreCallingIdentity(callingIdentity);
                }
            }
        };
        try {
            imsRcsController.requestCapabilities(this.mSubId, this.mContext.getOpPackageName(), this.mContext.getAttributionTag(), new ArrayList<Uri>(contactNumbers), internalCallback);
        }
        catch (ServiceSpecificException e) {
            throw new ImsException(e.toString(), e.errorCode);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling IImsRcsController#requestCapabilities", e);
            throw new ImsException("Remote IMS Service is not available", 1);
        }
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.ACCESS_RCS_USER_CAPABILITY_EXCHANGE", "android.permission.READ_CONTACTS"})
    public void requestAvailability(Uri contactNumber, final Executor executor, final CapabilitiesCallback c) throws ImsException {
        if (executor == null) {
            throw new IllegalArgumentException("Must include a non-null Executor.");
        }
        if (contactNumber == null) {
            throw new IllegalArgumentException("Must include non-null contact number.");
        }
        if (c == null) {
            throw new IllegalArgumentException("Must include a non-null CapabilitiesCallback.");
        }
        IImsRcsController imsRcsController = this.getIImsRcsController();
        if (imsRcsController == null) {
            Log.e(TAG, "requestAvailability: IImsRcsController is null");
            throw new ImsException("Cannot find remote IMS service", 1);
        }
        IRcsUceControllerCallback.Stub internalCallback = new IRcsUceControllerCallback.Stub(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCapabilitiesReceived(List<RcsContactUceCapability> contactCapabilities) {
                long callingIdentity = Binder.clearCallingIdentity();
                try {
                    executor.execute(() -> c.onCapabilitiesReceived(contactCapabilities));
                }
                finally {
                    2.restoreCallingIdentity(callingIdentity);
                }
            }

            @Override
            public void onComplete() {
                long callingIdentity = Binder.clearCallingIdentity();
                try {
                    executor.execute(() -> c.onComplete());
                }
                finally {
                    2.restoreCallingIdentity(callingIdentity);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onError(int errorCode, long retryAfterMilliseconds) {
                long callingIdentity = Binder.clearCallingIdentity();
                try {
                    executor.execute(() -> c.onError(errorCode, retryAfterMilliseconds));
                }
                finally {
                    2.restoreCallingIdentity(callingIdentity);
                }
            }
        };
        try {
            imsRcsController.requestAvailability(this.mSubId, this.mContext.getOpPackageName(), this.mContext.getAttributionTag(), contactNumber, internalCallback);
        }
        catch (ServiceSpecificException e) {
            throw new ImsException(e.toString(), e.errorCode);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling IImsRcsController#requestAvailability", e);
            throw new ImsException("Remote IMS Service is not available", 1);
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.READ_PRIVILEGED_PHONE_STATE")
    public int getUcePublishState() throws ImsException {
        IImsRcsController imsRcsController = this.getIImsRcsController();
        if (imsRcsController == null) {
            Log.e(TAG, "getUcePublishState: IImsRcsController is null");
            throw new ImsException("Can not find remote IMS service", 1);
        }
        try {
            return imsRcsController.getUcePublishState(this.mSubId);
        }
        catch (ServiceSpecificException e) {
            throw new ImsException(e.getMessage(), e.errorCode);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling IImsRcsController#getUcePublishState", e);
            throw new ImsException("Remote IMS Service is not available", 1);
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.READ_PRIVILEGED_PHONE_STATE")
    public void addOnPublishStateChangedListener(Executor executor, OnPublishStateChangedListener listener2) throws ImsException {
        if (executor == null) {
            throw new IllegalArgumentException("Must include a non-null Executor.");
        }
        if (listener2 == null) {
            throw new IllegalArgumentException("Must include a non-null OnPublishStateChangedListener.");
        }
        IImsRcsController imsRcsController = this.getIImsRcsController();
        if (imsRcsController == null) {
            Log.e(TAG, "addOnPublishStateChangedListener : IImsRcsController is null");
            throw new ImsException("Cannot find remote IMS service", 1);
        }
        PublishStateCallbackAdapter stateCallback = this.addPublishStateCallback(executor, listener2);
        try {
            imsRcsController.registerUcePublishStateCallback(this.mSubId, stateCallback.getBinder());
        }
        catch (ServiceSpecificException e) {
            throw new ImsException(e.getMessage(), e.errorCode);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling IImsRcsController#registerUcePublishStateCallback", e);
            throw new ImsException("Remote IMS Service is not available", 1);
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.READ_PRIVILEGED_PHONE_STATE")
    public void removeOnPublishStateChangedListener(OnPublishStateChangedListener listener2) throws ImsException {
        if (listener2 == null) {
            throw new IllegalArgumentException("Must include a non-null OnPublishStateChangedListener.");
        }
        IImsRcsController imsRcsController = this.getIImsRcsController();
        if (imsRcsController == null) {
            Log.e(TAG, "removeOnPublishStateChangedListener: IImsRcsController is null");
            throw new ImsException("Cannot find remote IMS service", 1);
        }
        PublishStateCallbackAdapter callback2 = this.removePublishStateCallback(listener2);
        if (callback2 == null) {
            return;
        }
        try {
            imsRcsController.unregisterUcePublishStateCallback(this.mSubId, callback2.getBinder());
        }
        catch (ServiceSpecificException e) {
            throw new ImsException(e.getMessage(), e.errorCode);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling IImsRcsController#unregisterUcePublishStateCallback", e);
            throw new ImsException("Remote IMS Service is not available", 1);
        }
    }

    @RequiresPermission(value="android.permission.READ_PHONE_STATE")
    public boolean isUceSettingEnabled() throws ImsException {
        IImsRcsController imsRcsController = this.getIImsRcsController();
        if (imsRcsController == null) {
            Log.e(TAG, "isUceSettingEnabled: IImsRcsController is null");
            throw new ImsException("Can not find remote IMS service", 1);
        }
        try {
            return imsRcsController.isUceSettingEnabled(this.mSubId, this.mContext.getOpPackageName(), this.mContext.getAttributionTag());
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling IImsRcsController#isUceSettingEnabled", e);
            throw new ImsException("Remote IMS Service is not available", 1);
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MODIFY_PHONE_STATE")
    public void setUceSettingEnabled(boolean isEnabled) throws ImsException {
        IImsRcsController imsRcsController = this.getIImsRcsController();
        if (imsRcsController == null) {
            Log.e(TAG, "setUceSettingEnabled: IImsRcsController is null");
            throw new ImsException("Can not find remote IMS service", 1);
        }
        try {
            imsRcsController.setUceSettingEnabled(this.mSubId, isEnabled);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling IImsRcsController#setUceSettingEnabled", e);
            throw new ImsException("Remote IMS Service is not available", 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PublishStateCallbackAdapter addPublishStateCallback(Executor executor, OnPublishStateChangedListener listener2) {
        PublishStateCallbackAdapter adapter = new PublishStateCallbackAdapter(executor, listener2);
        Map<OnPublishStateChangedListener, PublishStateCallbackAdapter> map2 = this.mPublishStateCallbacks;
        synchronized (map2) {
            this.mPublishStateCallbacks.put(listener2, adapter);
        }
        return adapter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PublishStateCallbackAdapter removePublishStateCallback(OnPublishStateChangedListener listener2) {
        Map<OnPublishStateChangedListener, PublishStateCallbackAdapter> map2 = this.mPublishStateCallbacks;
        synchronized (map2) {
            return this.mPublishStateCallbacks.remove(listener2);
        }
    }

    private IImsRcsController getIImsRcsController() {
        IBinder binder = TelephonyFrameworkInitializer.getTelephonyServiceManager().getTelephonyImsServiceRegisterer().get();
        return IImsRcsController.Stub.asInterface(binder);
    }

    @SystemApi
    public static interface CapabilitiesCallback {
        public void onCapabilitiesReceived(List<RcsContactUceCapability> var1);

        public void onComplete();

        public void onError(int var1, long var2);
    }

    public static class PublishStateCallbackAdapter {
        private final PublishStateBinder mBinder;

        public PublishStateCallbackAdapter(Executor executor, OnPublishStateChangedListener listener2) {
            this.mBinder = new PublishStateBinder(executor, listener2);
        }

        public IRcsUcePublishStateCallback getBinder() {
            return this.mBinder;
        }

        private static class PublishStateBinder
        extends IRcsUcePublishStateCallback.Stub {
            private final OnPublishStateChangedListener mPublishStateChangeListener;
            private final Executor mExecutor;

            PublishStateBinder(Executor executor, OnPublishStateChangedListener listener2) {
                this.mExecutor = executor;
                this.mPublishStateChangeListener = listener2;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onPublishStateChanged(int publishState) {
                if (this.mPublishStateChangeListener == null) {
                    return;
                }
                long callingIdentity = Binder.clearCallingIdentity();
                try {
                    this.mExecutor.execute(() -> this.mPublishStateChangeListener.onPublishStateChange(publishState));
                }
                finally {
                    PublishStateBinder.restoreCallingIdentity(callingIdentity);
                }
            }
        }
    }

    @SystemApi
    public static interface OnPublishStateChangedListener {
        public void onPublishStateChange(int var1);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface PublishState {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface StackPublishTriggerType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ErrorCode {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface RcsImsCapabilityFlag {
    }
}

