/*
 * Decompiled with CFR 0.152.
 */
package android.telephony.ims;

import android.annotation.SystemApi;
import android.compat.annotation.UnsupportedAppUsage;
import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.telecom.VideoProfile;
import android.view.Surface;
import com.android.ims.internal.IImsVideoCallCallback;
import com.android.ims.internal.IImsVideoCallProvider;
import com.android.internal.os.SomeArgs;

@SystemApi
public abstract class ImsVideoCallProvider {
    private static final int MSG_SET_CALLBACK = 1;
    private static final int MSG_SET_CAMERA = 2;
    private static final int MSG_SET_PREVIEW_SURFACE = 3;
    private static final int MSG_SET_DISPLAY_SURFACE = 4;
    private static final int MSG_SET_DEVICE_ORIENTATION = 5;
    private static final int MSG_SET_ZOOM = 6;
    private static final int MSG_SEND_SESSION_MODIFY_REQUEST = 7;
    private static final int MSG_SEND_SESSION_MODIFY_RESPONSE = 8;
    private static final int MSG_REQUEST_CAMERA_CAPABILITIES = 9;
    private static final int MSG_REQUEST_CALL_DATA_USAGE = 10;
    private static final int MSG_SET_PAUSE_IMAGE = 11;
    private final ImsVideoCallProviderBinder mBinder;
    private IImsVideoCallCallback mCallback;
    private final Handler mProviderHandler = new Handler(Looper.getMainLooper()){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    ImsVideoCallProvider.this.mCallback = (IImsVideoCallCallback)msg.obj;
                    break;
                }
                case 2: {
                    SomeArgs args = (SomeArgs)msg.obj;
                    try {
                        ImsVideoCallProvider.this.onSetCamera((String)args.arg1);
                        ImsVideoCallProvider.this.onSetCamera((String)args.arg1, args.argi1);
                        break;
                    }
                    finally {
                        args.recycle();
                    }
                }
                case 3: {
                    ImsVideoCallProvider.this.onSetPreviewSurface((Surface)msg.obj);
                    break;
                }
                case 4: {
                    ImsVideoCallProvider.this.onSetDisplaySurface((Surface)msg.obj);
                    break;
                }
                case 5: {
                    ImsVideoCallProvider.this.onSetDeviceOrientation(msg.arg1);
                    break;
                }
                case 6: {
                    ImsVideoCallProvider.this.onSetZoom(((Float)msg.obj).floatValue());
                    break;
                }
                case 7: {
                    SomeArgs args = (SomeArgs)msg.obj;
                    try {
                        VideoProfile fromProfile = (VideoProfile)args.arg1;
                        VideoProfile toProfile = (VideoProfile)args.arg2;
                        ImsVideoCallProvider.this.onSendSessionModifyRequest(fromProfile, toProfile);
                        break;
                    }
                    finally {
                        args.recycle();
                    }
                }
                case 8: {
                    ImsVideoCallProvider.this.onSendSessionModifyResponse((VideoProfile)msg.obj);
                    break;
                }
                case 9: {
                    ImsVideoCallProvider.this.onRequestCameraCapabilities();
                    break;
                }
                case 10: {
                    ImsVideoCallProvider.this.onRequestCallDataUsage();
                    break;
                }
                case 11: {
                    ImsVideoCallProvider.this.onSetPauseImage((Uri)msg.obj);
                    break;
                }
            }
        }
    };

    public ImsVideoCallProvider() {
        this.mBinder = new ImsVideoCallProviderBinder();
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public IImsVideoCallProvider getInterface() {
        return this.mBinder;
    }

    public abstract void onSetCamera(String var1);

    public void onSetCamera(String cameraId, int uid) {
    }

    public abstract void onSetPreviewSurface(Surface var1);

    public abstract void onSetDisplaySurface(Surface var1);

    public abstract void onSetDeviceOrientation(int var1);

    public abstract void onSetZoom(float var1);

    public abstract void onSendSessionModifyRequest(VideoProfile var1, VideoProfile var2);

    public abstract void onSendSessionModifyResponse(VideoProfile var1);

    public abstract void onRequestCameraCapabilities();

    public abstract void onRequestCallDataUsage();

    public abstract void onSetPauseImage(Uri var1);

    public void receiveSessionModifyRequest(VideoProfile VideoProfile2) {
        if (this.mCallback != null) {
            try {
                this.mCallback.receiveSessionModifyRequest(VideoProfile2);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    public void receiveSessionModifyResponse(int status, VideoProfile requestedProfile, VideoProfile responseProfile) {
        if (this.mCallback != null) {
            try {
                this.mCallback.receiveSessionModifyResponse(status, requestedProfile, responseProfile);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    public void handleCallSessionEvent(int event) {
        if (this.mCallback != null) {
            try {
                this.mCallback.handleCallSessionEvent(event);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    public void changePeerDimensions(int width, int height) {
        if (this.mCallback != null) {
            try {
                this.mCallback.changePeerDimensions(width, height);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    public void changeCallDataUsage(long dataUsage) {
        if (this.mCallback != null) {
            try {
                this.mCallback.changeCallDataUsage(dataUsage);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    public void changeCameraCapabilities(VideoProfile.CameraCapabilities CameraCapabilities2) {
        if (this.mCallback != null) {
            try {
                this.mCallback.changeCameraCapabilities(CameraCapabilities2);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    public void changeVideoQuality(int videoQuality) {
        if (this.mCallback != null) {
            try {
                this.mCallback.changeVideoQuality(videoQuality);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    private class ImsVideoCallProviderBinder
    extends IImsVideoCallProvider.Stub {
        private ImsVideoCallProviderBinder() {
        }

        @Override
        public void setCallback(IImsVideoCallCallback callback2) {
            ImsVideoCallProvider.this.mProviderHandler.obtainMessage(1, callback2).sendToTarget();
        }

        @Override
        public void setCamera(String cameraId, int uid) {
            SomeArgs args = SomeArgs.obtain();
            args.arg1 = cameraId;
            args.argi1 = uid;
            ImsVideoCallProvider.this.mProviderHandler.obtainMessage(2, args).sendToTarget();
        }

        @Override
        public void setPreviewSurface(Surface surface2) {
            ImsVideoCallProvider.this.mProviderHandler.obtainMessage(3, surface2).sendToTarget();
        }

        @Override
        public void setDisplaySurface(Surface surface2) {
            ImsVideoCallProvider.this.mProviderHandler.obtainMessage(4, surface2).sendToTarget();
        }

        @Override
        public void setDeviceOrientation(int rotation) {
            ImsVideoCallProvider.this.mProviderHandler.obtainMessage(5, rotation, 0).sendToTarget();
        }

        @Override
        public void setZoom(float value2) {
            ImsVideoCallProvider.this.mProviderHandler.obtainMessage(6, Float.valueOf(value2)).sendToTarget();
        }

        @Override
        public void sendSessionModifyRequest(VideoProfile fromProfile, VideoProfile toProfile) {
            SomeArgs args = SomeArgs.obtain();
            args.arg1 = fromProfile;
            args.arg2 = toProfile;
            ImsVideoCallProvider.this.mProviderHandler.obtainMessage(7, args).sendToTarget();
        }

        @Override
        public void sendSessionModifyResponse(VideoProfile responseProfile) {
            ImsVideoCallProvider.this.mProviderHandler.obtainMessage(8, responseProfile).sendToTarget();
        }

        @Override
        public void requestCameraCapabilities() {
            ImsVideoCallProvider.this.mProviderHandler.obtainMessage(9).sendToTarget();
        }

        @Override
        public void requestCallDataUsage() {
            ImsVideoCallProvider.this.mProviderHandler.obtainMessage(10).sendToTarget();
        }

        @Override
        public void setPauseImage(Uri uri) {
            ImsVideoCallProvider.this.mProviderHandler.obtainMessage(11, uri).sendToTarget();
        }
    }
}

