/*
 * Decompiled with CFR 0.152.
 */
package android.telephony.ims;

import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.app.Service;
import android.content.Intent;
import android.os.IBinder;
import android.os.RemoteException;
import android.telephony.ims.aidl.IImsConfig;
import android.telephony.ims.aidl.IImsMmTelFeature;
import android.telephony.ims.aidl.IImsRcsFeature;
import android.telephony.ims.aidl.IImsRegistration;
import android.telephony.ims.aidl.IImsServiceController;
import android.telephony.ims.aidl.IImsServiceControllerListener;
import android.telephony.ims.aidl.ISipTransport;
import android.telephony.ims.feature.ImsFeature;
import android.telephony.ims.feature.MmTelFeature;
import android.telephony.ims.feature.RcsFeature;
import android.telephony.ims.stub.ImsConfigImplBase;
import android.telephony.ims.stub.ImsFeatureConfiguration;
import android.telephony.ims.stub.ImsRegistrationImplBase;
import android.telephony.ims.stub.SipTransportImplBase;
import android.util.Log;
import android.util.SparseArray;
import com.android.ims.internal.IImsFeatureStatusCallback;
import com.android.internal.annotations.VisibleForTesting;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.HashMap;
import java.util.Map;

@SystemApi
public class ImsService
extends Service {
    private static final String LOG_TAG = "ImsService";
    public static final long CAPABILITY_EMERGENCY_OVER_MMTEL = 1L;
    public static final long CAPABILITY_SIP_DELEGATE_CREATION = 2L;
    public static final long CAPABILITY_MAX_INDEX = Long.numberOfTrailingZeros(2L);
    private static final Map<Long, String> CAPABILITIES_LOG_MAP = new HashMap<Long, String>(){
        {
            this.put(1L, "EMERGENCY_OVER_MMTEL");
            this.put(2L, "SIP_DELEGATE_CREATION");
        }
    };
    public static final String SERVICE_INTERFACE = "android.telephony.ims.ImsService";
    private final SparseArray<SparseArray<ImsFeature>> mFeaturesBySlot = new SparseArray();
    private IImsServiceControllerListener mListener;
    protected final IBinder mImsServiceController = new IImsServiceController.Stub(){

        @Override
        public void setListener(IImsServiceControllerListener l) {
            ImsService.this.mListener = l;
        }

        @Override
        public IImsMmTelFeature createMmTelFeature(int slotId) {
            return ImsService.this.createMmTelFeatureInternal(slotId);
        }

        @Override
        public IImsRcsFeature createRcsFeature(int slotId) {
            return ImsService.this.createRcsFeatureInternal(slotId);
        }

        @Override
        public void addFeatureStatusCallback(int slotId, int featureType, IImsFeatureStatusCallback c) {
            ImsService.this.addImsFeatureStatusCallback(slotId, featureType, c);
        }

        @Override
        public void removeFeatureStatusCallback(int slotId, int featureType, IImsFeatureStatusCallback c) {
            ImsService.this.removeImsFeatureStatusCallback(slotId, featureType, c);
        }

        @Override
        public void removeImsFeature(int slotId, int featureType) {
            ImsService.this.removeImsFeature(slotId, featureType);
        }

        @Override
        public ImsFeatureConfiguration querySupportedImsFeatures() {
            return ImsService.this.querySupportedImsFeatures();
        }

        @Override
        public long getImsServiceCapabilities() {
            long sanitizedCaps;
            long caps = ImsService.this.getImsServiceCapabilities();
            if (caps != (sanitizedCaps = ImsService.sanitizeCapabilities(caps))) {
                Log.w(ImsService.LOG_TAG, "removing invalid bits from field: 0x" + Long.toHexString(caps ^ sanitizedCaps));
            }
            return sanitizedCaps;
        }

        @Override
        public void notifyImsServiceReadyForFeatureCreation() {
            ImsService.this.readyForFeatureCreation();
        }

        @Override
        public IImsConfig getConfig(int slotId) {
            ImsConfigImplBase c = ImsService.this.getConfig(slotId);
            return c != null ? c.getIImsConfig() : null;
        }

        @Override
        public IImsRegistration getRegistration(int slotId) {
            ImsRegistrationImplBase r = ImsService.this.getRegistration(slotId);
            return r != null ? r.getBinder() : null;
        }

        @Override
        public ISipTransport getSipTransport(int slotId) {
            SipTransportImplBase s = ImsService.this.getSipTransport(slotId);
            return s != null ? s.getBinder() : null;
        }

        @Override
        public void enableIms(int slotId) {
            ImsService.this.enableIms(slotId);
        }

        @Override
        public void disableIms(int slotId) {
            ImsService.this.disableIms(slotId);
        }
    };

    @Override
    public IBinder onBind(Intent intent) {
        if (SERVICE_INTERFACE.equals(intent.getAction())) {
            Log.i(LOG_TAG, "ImsService Bound.");
            return this.mImsServiceController;
        }
        return null;
    }

    @VisibleForTesting
    public SparseArray<ImsFeature> getFeatures(int slotId) {
        return this.mFeaturesBySlot.get(slotId);
    }

    private IImsMmTelFeature createMmTelFeatureInternal(int slotId) {
        MmTelFeature f = this.createMmTelFeature(slotId);
        if (f != null) {
            this.setupFeature(f, slotId, 1);
            return f.getBinder();
        }
        Log.e(LOG_TAG, "createMmTelFeatureInternal: null feature returned.");
        return null;
    }

    private IImsRcsFeature createRcsFeatureInternal(int slotId) {
        RcsFeature f = this.createRcsFeature(slotId);
        if (f != null) {
            this.setupFeature(f, slotId, 2);
            return f.getBinder();
        }
        Log.e(LOG_TAG, "createRcsFeatureInternal: null feature returned.");
        return null;
    }

    private void setupFeature(ImsFeature f, int slotId, int featureType) {
        f.initialize(this, slotId);
        this.addImsFeature(slotId, featureType, f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addImsFeatureStatusCallback(int slotId, int featureType, IImsFeatureStatusCallback c) {
        SparseArray<SparseArray<ImsFeature>> sparseArray = this.mFeaturesBySlot;
        synchronized (sparseArray) {
            SparseArray<ImsFeature> features = this.mFeaturesBySlot.get(slotId);
            if (features == null) {
                Log.w(LOG_TAG, "Can not add ImsFeatureStatusCallback - no features on slot " + slotId);
                return;
            }
            ImsFeature f = features.get(featureType);
            if (f != null) {
                f.addImsFeatureStatusCallback(c);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeImsFeatureStatusCallback(int slotId, int featureType, IImsFeatureStatusCallback c) {
        SparseArray<SparseArray<ImsFeature>> sparseArray = this.mFeaturesBySlot;
        synchronized (sparseArray) {
            SparseArray<ImsFeature> features = this.mFeaturesBySlot.get(slotId);
            if (features == null) {
                Log.w(LOG_TAG, "Can not remove ImsFeatureStatusCallback - no features on slot " + slotId);
                return;
            }
            ImsFeature f = features.get(featureType);
            if (f != null) {
                f.removeImsFeatureStatusCallback(c);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addImsFeature(int slotId, int featureType, ImsFeature f) {
        SparseArray<SparseArray<ImsFeature>> sparseArray = this.mFeaturesBySlot;
        synchronized (sparseArray) {
            SparseArray<ImsFeature> features = this.mFeaturesBySlot.get(slotId);
            if (features == null) {
                features = new SparseArray();
                this.mFeaturesBySlot.put(slotId, features);
            }
            features.put(featureType, f);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeImsFeature(int slotId, int featureType) {
        SparseArray<SparseArray<ImsFeature>> sparseArray = this.mFeaturesBySlot;
        synchronized (sparseArray) {
            SparseArray<ImsFeature> features = this.mFeaturesBySlot.get(slotId);
            if (features == null) {
                Log.w(LOG_TAG, "Can not remove ImsFeature. No ImsFeatures exist on slot " + slotId);
                return;
            }
            ImsFeature f = features.get(featureType);
            if (f == null) {
                Log.w(LOG_TAG, "Can not remove ImsFeature. No feature with type " + featureType + " exists on slot " + slotId);
                return;
            }
            f.onFeatureRemoved();
            features.remove(featureType);
        }
    }

    public ImsFeatureConfiguration querySupportedImsFeatures() {
        return new ImsFeatureConfiguration();
    }

    public void onUpdateSupportedImsFeatures(ImsFeatureConfiguration c) throws RemoteException {
        if (this.mListener == null) {
            throw new IllegalStateException("Framework is not ready");
        }
        this.mListener.onUpdateSupportedImsFeatures(c);
    }

    @SuppressLint(value={"OnNameExpected"})
    public long getImsServiceCapabilities() {
        return 0L;
    }

    public void readyForFeatureCreation() {
    }

    public void enableIms(int slotId) {
    }

    public void disableIms(int slotId) {
    }

    public MmTelFeature createMmTelFeature(int slotId) {
        return null;
    }

    public RcsFeature createRcsFeature(int slotId) {
        return null;
    }

    public ImsConfigImplBase getConfig(int slotId) {
        return new ImsConfigImplBase();
    }

    public ImsRegistrationImplBase getRegistration(int slotId) {
        return new ImsRegistrationImplBase();
    }

    @SuppressLint(value={"OnNameExpected"})
    public SipTransportImplBase getSipTransport(int slotId) {
        return null;
    }

    private static long sanitizeCapabilities(long caps) {
        long filter2 = -1L;
        caps &= (filter2 <<= (int)(CAPABILITY_MAX_INDEX + 1L)) ^ 0xFFFFFFFFFFFFFFFFL;
        return caps &= 0xFFFFFFFFFFFFFFFEL;
    }

    public static String getCapabilitiesString(long caps) {
        StringBuffer result = new StringBuffer();
        result.append("capabilities={ ");
        long filter2 = -1L;
        for (long i = 0L; (caps & filter2) != 0L && i <= 63L; ++i) {
            long bitToCheck = 1L << (int)i;
            if ((caps & bitToCheck) != 0L) {
                result.append(CAPABILITIES_LOG_MAP.getOrDefault(bitToCheck, bitToCheck + "?"));
                result.append(" ");
            }
            filter2 <<= 1;
        }
        result.append("}");
        return result.toString();
    }

    public static class Listener
    extends IImsServiceControllerListener.Stub {
        @Override
        public void onUpdateSupportedImsFeatures(ImsFeatureConfiguration c) {
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ImsServiceCapability {
    }
}

