/*
 * Decompiled with CFR 0.152.
 */
package android.telephony.ims;

import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.content.Context;
import android.os.Binder;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.ServiceSpecificException;
import android.telephony.BinderCacheManager;
import android.telephony.TelephonyFrameworkInitializer;
import android.telephony.ims.ImsException;
import android.telephony.ims.RcsUceAdapter;
import android.telephony.ims.RegistrationManager;
import android.telephony.ims.aidl.IImsCapabilityCallback;
import android.telephony.ims.aidl.IImsRcsController;
import android.util.Log;
import com.android.internal.telephony.IIntegerConsumer;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.function.Consumer;

public class ImsRcsManager {
    private static final String TAG = "ImsRcsManager";
    public static final String ACTION_SHOW_CAPABILITY_DISCOVERY_OPT_IN = "android.telephony.ims.action.SHOW_CAPABILITY_DISCOVERY_OPT_IN";
    private final int mSubId;
    private final Context mContext;
    private final BinderCacheManager<IImsRcsController> mBinderCache;
    private final Map<OnAvailabilityChangedListener, AvailabilityCallbackAdapter> mAvailabilityChangedCallbacks;

    public ImsRcsManager(Context context, int subId, BinderCacheManager<IImsRcsController> binderCache) {
        this.mSubId = subId;
        this.mContext = context;
        this.mBinderCache = binderCache;
        this.mAvailabilityChangedCallbacks = new HashMap<OnAvailabilityChangedListener, AvailabilityCallbackAdapter>();
    }

    public RcsUceAdapter getUceAdapter() {
        return new RcsUceAdapter(this.mContext, this.mSubId);
    }

    @RequiresPermission(value="android.permission.READ_PRECISE_PHONE_STATE")
    public void registerImsRegistrationCallback(Executor executor, RegistrationManager.RegistrationCallback c) throws ImsException {
        if (c == null) {
            throw new IllegalArgumentException("Must include a non-null RegistrationCallback.");
        }
        if (executor == null) {
            throw new IllegalArgumentException("Must include a non-null Executor.");
        }
        IImsRcsController imsRcsController = this.getIImsRcsController();
        if (imsRcsController == null) {
            Log.w(TAG, "Register registration callback: IImsRcsController is null");
            throw new ImsException("Cannot find remote IMS service", 1);
        }
        c.setExecutor(executor);
        try {
            imsRcsController.registerImsRegistrationCallback(this.mSubId, c.getBinder());
        }
        catch (ServiceSpecificException e) {
            throw new ImsException(e.toString(), e.errorCode);
        }
        catch (RemoteException | IllegalStateException e) {
            throw new ImsException(e.getMessage(), 1);
        }
    }

    @RequiresPermission(value="android.permission.READ_PRECISE_PHONE_STATE")
    public void unregisterImsRegistrationCallback(RegistrationManager.RegistrationCallback c) {
        if (c == null) {
            throw new IllegalArgumentException("Must include a non-null RegistrationCallback.");
        }
        IImsRcsController imsRcsController = this.getIImsRcsController();
        if (imsRcsController == null) {
            Log.w(TAG, "Unregister registration callback: IImsRcsController is null");
            throw new IllegalStateException("Cannot find remote IMS service");
        }
        try {
            imsRcsController.unregisterImsRegistrationCallback(this.mSubId, c.getBinder());
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
    }

    @RequiresPermission(value="android.permission.READ_PRECISE_PHONE_STATE")
    public void getRegistrationState(final Executor executor, final Consumer<Integer> stateCallback) {
        if (stateCallback == null) {
            throw new IllegalArgumentException("Must include a non-null stateCallback.");
        }
        if (executor == null) {
            throw new IllegalArgumentException("Must include a non-null Executor.");
        }
        IImsRcsController imsRcsController = this.getIImsRcsController();
        if (imsRcsController == null) {
            Log.w(TAG, "Get registration state error: IImsRcsController is null");
            throw new IllegalStateException("Cannot find remote IMS service");
        }
        try {
            imsRcsController.getImsRcsRegistrationState(this.mSubId, new IIntegerConsumer.Stub(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void accept(int result) {
                    long identity = Binder.clearCallingIdentity();
                    try {
                        executor.execute(() -> stateCallback.accept(result));
                    }
                    finally {
                        Binder.restoreCallingIdentity(identity);
                    }
                }
            });
        }
        catch (RemoteException | ServiceSpecificException e) {
            Log.w(TAG, "Get registration state error: " + e);
            executor.execute(() -> stateCallback.accept(0));
        }
    }

    @RequiresPermission(value="android.permission.READ_PRECISE_PHONE_STATE")
    public void getRegistrationTransportType(final Executor executor, final Consumer<Integer> transportTypeCallback) {
        if (transportTypeCallback == null) {
            throw new IllegalArgumentException("Must include a non-null transportTypeCallback.");
        }
        if (executor == null) {
            throw new IllegalArgumentException("Must include a non-null Executor.");
        }
        IImsRcsController imsRcsController = this.getIImsRcsController();
        if (imsRcsController == null) {
            Log.w(TAG, "Get registration transport type error: IImsRcsController is null");
            throw new IllegalStateException("Cannot find remote IMS service");
        }
        try {
            imsRcsController.getImsRcsRegistrationTransportType(this.mSubId, new IIntegerConsumer.Stub(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void accept(int result) {
                    long identity = Binder.clearCallingIdentity();
                    try {
                        executor.execute(() -> transportTypeCallback.accept(result));
                    }
                    finally {
                        Binder.restoreCallingIdentity(identity);
                    }
                }
            });
        }
        catch (RemoteException | ServiceSpecificException e) {
            Log.w(TAG, "Get registration transport type error: " + e);
            executor.execute(() -> transportTypeCallback.accept(-1));
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.READ_PRIVILEGED_PHONE_STATE")
    public void addOnAvailabilityChangedListener(Executor executor, OnAvailabilityChangedListener listener2) throws ImsException {
        if (listener2 == null) {
            throw new IllegalArgumentException("Must include a non-nullOnAvailabilityChangedListener.");
        }
        if (executor == null) {
            throw new IllegalArgumentException("Must include a non-null Executor.");
        }
        IImsRcsController imsRcsController = this.getIImsRcsController();
        if (imsRcsController == null) {
            Log.w(TAG, "Add availability changed listener: IImsRcsController is null");
            throw new ImsException("Cannot find remote IMS service", 1);
        }
        AvailabilityCallbackAdapter adapter = this.addAvailabilityChangedListenerToCollection(executor, listener2);
        try {
            imsRcsController.registerRcsAvailabilityCallback(this.mSubId, adapter.getBinder());
        }
        catch (ServiceSpecificException e) {
            throw new ImsException(e.toString(), e.errorCode);
        }
        catch (RemoteException e) {
            Log.w(TAG, "Error calling IImsRcsController#registerRcsAvailabilityCallback", e);
            throw new ImsException("Remote IMS Service is not available", 1);
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.READ_PRIVILEGED_PHONE_STATE")
    public void removeOnAvailabilityChangedListener(OnAvailabilityChangedListener listener2) {
        if (listener2 == null) {
            throw new IllegalArgumentException("Must include a non-nullOnAvailabilityChangedListener.");
        }
        IImsRcsController imsRcsController = this.getIImsRcsController();
        if (imsRcsController == null) {
            Log.w(TAG, "Remove availability changed listener: IImsRcsController is null");
            return;
        }
        AvailabilityCallbackAdapter callback2 = this.removeAvailabilityChangedListenerFromCollection(listener2);
        if (callback2 == null) {
            return;
        }
        try {
            imsRcsController.unregisterRcsAvailabilityCallback(this.mSubId, callback2.getBinder());
        }
        catch (RemoteException e) {
            Log.w(TAG, "Error calling IImsRcsController#unregisterRcsAvailabilityCallback", e);
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.READ_PRIVILEGED_PHONE_STATE")
    public boolean isCapable(int capability, int radioTech) throws ImsException {
        IImsRcsController imsRcsController = this.getIImsRcsController();
        if (imsRcsController == null) {
            Log.w(TAG, "isCapable: IImsRcsController is null");
            throw new ImsException("Cannot find remote IMS service", 1);
        }
        try {
            return imsRcsController.isCapable(this.mSubId, capability, radioTech);
        }
        catch (RemoteException e) {
            Log.w(TAG, "Error calling IImsRcsController#isCapable", e);
            throw new ImsException("Remote IMS Service is not available", 1);
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.READ_PRIVILEGED_PHONE_STATE")
    public boolean isAvailable(int capability, int radioTech) throws ImsException {
        IImsRcsController imsRcsController = this.getIImsRcsController();
        if (imsRcsController == null) {
            Log.w(TAG, "isAvailable: IImsRcsController is null");
            throw new ImsException("Cannot find remote IMS service", 1);
        }
        try {
            return imsRcsController.isAvailable(this.mSubId, capability, radioTech);
        }
        catch (RemoteException e) {
            Log.w(TAG, "Error calling IImsRcsController#isAvailable", e);
            throw new ImsException("Remote IMS Service is not available", 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AvailabilityCallbackAdapter addAvailabilityChangedListenerToCollection(Executor executor, OnAvailabilityChangedListener listener2) {
        AvailabilityCallbackAdapter adapter = new AvailabilityCallbackAdapter(executor, listener2);
        Map<OnAvailabilityChangedListener, AvailabilityCallbackAdapter> map2 = this.mAvailabilityChangedCallbacks;
        synchronized (map2) {
            this.mAvailabilityChangedCallbacks.put(listener2, adapter);
        }
        return adapter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AvailabilityCallbackAdapter removeAvailabilityChangedListenerFromCollection(OnAvailabilityChangedListener listener2) {
        Map<OnAvailabilityChangedListener, AvailabilityCallbackAdapter> map2 = this.mAvailabilityChangedCallbacks;
        synchronized (map2) {
            return this.mAvailabilityChangedCallbacks.remove(listener2);
        }
    }

    private IImsRcsController getIImsRcsController() {
        IBinder binder = TelephonyFrameworkInitializer.getTelephonyServiceManager().getTelephonyImsServiceRegisterer().get();
        return IImsRcsController.Stub.asInterface(binder);
    }

    private static class AvailabilityCallbackAdapter {
        private final CapabilityBinder mBinder;

        AvailabilityCallbackAdapter(Executor executor, OnAvailabilityChangedListener listener2) {
            this.mBinder = new CapabilityBinder(listener2, executor);
        }

        public IImsCapabilityCallback getBinder() {
            return this.mBinder;
        }

        private static class CapabilityBinder
        extends IImsCapabilityCallback.Stub {
            private final OnAvailabilityChangedListener mOnAvailabilityChangedListener;
            private final Executor mExecutor;

            CapabilityBinder(OnAvailabilityChangedListener listener2, Executor executor) {
                this.mExecutor = executor;
                this.mOnAvailabilityChangedListener = listener2;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCapabilitiesStatusChanged(int config) {
                if (this.mOnAvailabilityChangedListener == null) {
                    return;
                }
                long callingIdentity = Binder.clearCallingIdentity();
                try {
                    this.mExecutor.execute(() -> this.mOnAvailabilityChangedListener.onAvailabilityChanged(config));
                }
                finally {
                    CapabilityBinder.restoreCallingIdentity(callingIdentity);
                }
            }

            @Override
            public void onQueryCapabilityConfiguration(int capability, int radioTech, boolean isEnabled) {
            }

            @Override
            public void onChangeCapabilityConfigurationError(int capability, int radioTech, int reason) {
            }
        }
    }

    @SystemApi
    public static interface OnAvailabilityChangedListener {
        public void onAvailabilityChanged(int var1);
    }
}

