/*
 * Decompiled with CFR 0.152.
 */
package android.telephony.data;

import android.os.Parcel;
import android.os.Parcelable;
import android.telephony.data.RouteSelectionDescriptor;
import android.telephony.data.TrafficDescriptor;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class UrspRule
implements Parcelable {
    public static final int MIN_URSP_PRECEDENCE = 0;
    public static final int MAX_URSP_PRECEDENCE = 255;
    private final int mPrecedence;
    private final List<TrafficDescriptor> mTrafficDescriptors;
    private final List<RouteSelectionDescriptor> mRouteSelectionDescriptor;
    public static final Parcelable.Creator<UrspRule> CREATOR = new Parcelable.Creator<UrspRule>(){

        @Override
        public UrspRule createFromParcel(Parcel source) {
            return new UrspRule(source);
        }

        public UrspRule[] newArray(int size) {
            return new UrspRule[size];
        }
    };

    UrspRule(android.hardware.radio.V1_6.UrspRule ur) {
        this(ur.precedence, ur.trafficDescriptors, ur.routeSelectionDescriptor);
    }

    public UrspRule(int precedence, List<android.hardware.radio.V1_6.TrafficDescriptor> trafficDescriptors, List<android.hardware.radio.V1_6.RouteSelectionDescriptor> routeSelectionDescriptor) {
        this.mPrecedence = precedence;
        this.mTrafficDescriptors = new ArrayList<TrafficDescriptor>();
        for (android.hardware.radio.V1_6.TrafficDescriptor td : trafficDescriptors) {
            this.mTrafficDescriptors.add(this.convertToTrafficDescriptor(td));
        }
        this.mRouteSelectionDescriptor = new ArrayList<RouteSelectionDescriptor>();
        for (android.hardware.radio.V1_6.RouteSelectionDescriptor rsd : routeSelectionDescriptor) {
            this.mRouteSelectionDescriptor.add(new RouteSelectionDescriptor(rsd));
        }
    }

    private byte[] arrayListToPrimitiveArray(ArrayList<Byte> bytes) {
        byte[] ret = new byte[bytes.size()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = bytes.get(i);
        }
        return ret;
    }

    private TrafficDescriptor convertToTrafficDescriptor(android.hardware.radio.V1_6.TrafficDescriptor td) {
        String dnn = td.dnn.getDiscriminator() == 0 ? null : td.dnn.value();
        byte[] osAppId = td.osAppId.getDiscriminator() == 0 ? null : this.arrayListToPrimitiveArray(td.osAppId.value().osAppId);
        TrafficDescriptor.Builder builder2 = new TrafficDescriptor.Builder();
        if (dnn != null) {
            builder2.setDataNetworkName(dnn);
        }
        if (osAppId != null) {
            builder2.setOsAppId(osAppId);
        }
        return builder2.build();
    }

    private UrspRule(Parcel p) {
        this.mPrecedence = p.readInt();
        this.mTrafficDescriptors = p.createTypedArrayList(TrafficDescriptor.CREATOR);
        this.mRouteSelectionDescriptor = p.createTypedArrayList(RouteSelectionDescriptor.CREATOR);
    }

    public int getPrecedence() {
        return this.mPrecedence;
    }

    public List<TrafficDescriptor> getTrafficDescriptors() {
        return this.mTrafficDescriptors;
    }

    public List<RouteSelectionDescriptor> getRouteSelectionDescriptor() {
        return this.mRouteSelectionDescriptor;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mPrecedence);
        dest.writeTypedList(this.mTrafficDescriptors, flags);
        dest.writeTypedList(this.mRouteSelectionDescriptor, flags);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UrspRule that = (UrspRule)o;
        return this.mPrecedence == that.mPrecedence && this.mTrafficDescriptors.size() == that.mTrafficDescriptors.size() && this.mTrafficDescriptors.containsAll(that.mTrafficDescriptors) && this.mRouteSelectionDescriptor.size() == that.mRouteSelectionDescriptor.size() && this.mRouteSelectionDescriptor.containsAll(that.mRouteSelectionDescriptor);
    }

    public int hashCode() {
        return Objects.hash(this.mPrecedence, this.mTrafficDescriptors, this.mRouteSelectionDescriptor);
    }

    public String toString() {
        return "{.precedence = " + this.mPrecedence + ", .trafficDescriptors = " + this.mTrafficDescriptors + ", .routeSelectionDescriptor = " + this.mRouteSelectionDescriptor + "}";
    }
}

