/*
 * Decompiled with CFR 0.152.
 */
package android.telephony;

import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.app.PendingIntent;
import android.compat.Compatibility;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.Context;
import android.database.CursorWindow;
import android.net.Uri;
import android.os.Bundle;
import android.os.RemoteException;
import android.telephony.MmsManager;
import android.telephony.SmsMessage;
import android.telephony.SubscriptionManager;
import android.telephony.TelephonyFrameworkInitializer;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.Log;
import android.util.Pair;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.telephony.IIntegerConsumer;
import com.android.internal.telephony.ISms;
import com.android.internal.telephony.ITelephony;
import com.android.internal.telephony.SmsRawData;
import com.android.telephony.Rlog;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;

public class SmsManager {
    private static final String TAG = "SmsManager";
    private static final Object sLockObject = new Object();
    @GuardedBy(value={"sLockObject"})
    private static final Map<Pair<Context, Integer>, SmsManager> sSubInstances = new ArrayMap<Pair<Context, Integer>, SmsManager>();
    private static final SmsManager DEFAULT_INSTANCE = SmsManager.getSmsManagerForContextAndSubscriptionId(null, Integer.MAX_VALUE);
    public static final int SMS_RECORD_LENGTH = 176;
    public static final int CDMA_SMS_RECORD_LENGTH = 255;
    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    private int mSubId;
    private final Context mContext;
    public static final String MMS_CONFIG_APPEND_TRANSACTION_ID = "enabledTransID";
    public static final String MMS_CONFIG_MMS_ENABLED = "enabledMMS";
    public static final String MMS_CONFIG_GROUP_MMS_ENABLED = "enableGroupMms";
    public static final String MMS_CONFIG_NOTIFY_WAP_MMSC_ENABLED = "enabledNotifyWapMMSC";
    public static final String MMS_CONFIG_ALIAS_ENABLED = "aliasEnabled";
    public static final String MMS_CONFIG_ALLOW_ATTACH_AUDIO = "allowAttachAudio";
    public static final String MMS_CONFIG_MULTIPART_SMS_ENABLED = "enableMultipartSMS";
    public static final String MMS_CONFIG_SMS_DELIVERY_REPORT_ENABLED = "enableSMSDeliveryReports";
    public static final String MMS_CONFIG_SUPPORT_MMS_CONTENT_DISPOSITION = "supportMmsContentDisposition";
    public static final String MMS_CONFIG_SEND_MULTIPART_SMS_AS_SEPARATE_MESSAGES = "sendMultipartSmsAsSeparateMessages";
    public static final String MMS_CONFIG_MMS_READ_REPORT_ENABLED = "enableMMSReadReports";
    public static final String MMS_CONFIG_MMS_DELIVERY_REPORT_ENABLED = "enableMMSDeliveryReports";
    public static final String MMS_CONFIG_MAX_MESSAGE_SIZE = "maxMessageSize";
    public static final String MMS_CONFIG_MAX_IMAGE_WIDTH = "maxImageWidth";
    public static final String MMS_CONFIG_MAX_IMAGE_HEIGHT = "maxImageHeight";
    public static final String MMS_CONFIG_RECIPIENT_LIMIT = "recipientLimit";
    public static final String MMS_CONFIG_ALIAS_MIN_CHARS = "aliasMinChars";
    public static final String MMS_CONFIG_ALIAS_MAX_CHARS = "aliasMaxChars";
    public static final String MMS_CONFIG_SMS_TO_MMS_TEXT_THRESHOLD = "smsToMmsTextThreshold";
    public static final String MMS_CONFIG_SMS_TO_MMS_TEXT_LENGTH_THRESHOLD = "smsToMmsTextLengthThreshold";
    public static final String MMS_CONFIG_MESSAGE_TEXT_MAX_SIZE = "maxMessageTextSize";
    public static final String MMS_CONFIG_SUBJECT_MAX_LENGTH = "maxSubjectLength";
    public static final String MMS_CONFIG_HTTP_SOCKET_TIMEOUT = "httpSocketTimeout";
    public static final String MMS_CONFIG_UA_PROF_TAG_NAME = "uaProfTagName";
    public static final String MMS_CONFIG_USER_AGENT = "userAgent";
    public static final String MMS_CONFIG_UA_PROF_URL = "uaProfUrl";
    public static final String MMS_CONFIG_HTTP_PARAMS = "httpParams";
    public static final String MMS_CONFIG_EMAIL_GATEWAY_NUMBER = "emailGatewayNumber";
    public static final String MMS_CONFIG_NAI_SUFFIX = "naiSuffix";
    public static final String MMS_CONFIG_SHOW_CELL_BROADCAST_APP_LINKS = "config_cellBroadcastAppLinks";
    public static final String MMS_CONFIG_SUPPORT_HTTP_CHARSET_HEADER = "supportHttpCharsetHeader";
    public static final String MMS_CONFIG_CLOSE_CONNECTION = "mmsCloseConnection";
    public static final int SMS_MESSAGE_PRIORITY_NOT_SPECIFIED = -1;
    public static final int SMS_MESSAGE_PERIOD_NOT_SPECIFIED = -1;
    @SystemApi
    public static final int PREMIUM_SMS_CONSENT_UNKNOWN = 0;
    @SystemApi
    public static final int PREMIUM_SMS_CONSENT_ASK_USER = 1;
    @SystemApi
    public static final int PREMIUM_SMS_CONSENT_NEVER_ALLOW = 2;
    @SystemApi
    public static final int PREMIUM_SMS_CONSENT_ALWAYS_ALLOW = 3;
    private static final long GET_TARGET_SDK_VERSION_CODE_CHANGE = 145147528L;
    public static final int STATUS_ON_ICC_FREE = 0;
    public static final int STATUS_ON_ICC_READ = 1;
    public static final int STATUS_ON_ICC_UNREAD = 3;
    public static final int STATUS_ON_ICC_SENT = 5;
    public static final int STATUS_ON_ICC_UNSENT = 7;
    public static final int RESULT_ERROR_NONE = 0;
    public static final int RESULT_ERROR_GENERIC_FAILURE = 1;
    public static final int RESULT_ERROR_RADIO_OFF = 2;
    public static final int RESULT_ERROR_NULL_PDU = 3;
    public static final int RESULT_ERROR_NO_SERVICE = 4;
    public static final int RESULT_ERROR_LIMIT_EXCEEDED = 5;
    public static final int RESULT_ERROR_FDN_CHECK_FAILURE = 6;
    public static final int RESULT_ERROR_SHORT_CODE_NOT_ALLOWED = 7;
    public static final int RESULT_ERROR_SHORT_CODE_NEVER_ALLOWED = 8;
    public static final int RESULT_RADIO_NOT_AVAILABLE = 9;
    public static final int RESULT_NETWORK_REJECT = 10;
    public static final int RESULT_INVALID_ARGUMENTS = 11;
    public static final int RESULT_INVALID_STATE = 12;
    public static final int RESULT_NO_MEMORY = 13;
    public static final int RESULT_INVALID_SMS_FORMAT = 14;
    public static final int RESULT_SYSTEM_ERROR = 15;
    public static final int RESULT_MODEM_ERROR = 16;
    public static final int RESULT_NETWORK_ERROR = 17;
    public static final int RESULT_ENCODING_ERROR = 18;
    public static final int RESULT_INVALID_SMSC_ADDRESS = 19;
    public static final int RESULT_OPERATION_NOT_ALLOWED = 20;
    public static final int RESULT_INTERNAL_ERROR = 21;
    public static final int RESULT_NO_RESOURCES = 22;
    public static final int RESULT_CANCELLED = 23;
    public static final int RESULT_REQUEST_NOT_SUPPORTED = 24;
    public static final int RESULT_NO_BLUETOOTH_SERVICE = 25;
    public static final int RESULT_INVALID_BLUETOOTH_ADDRESS = 26;
    public static final int RESULT_BLUETOOTH_DISCONNECTED = 27;
    public static final int RESULT_UNEXPECTED_EVENT_STOP_SENDING = 28;
    public static final int RESULT_SMS_BLOCKED_DURING_EMERGENCY = 29;
    public static final int RESULT_SMS_SEND_RETRY_FAILED = 30;
    public static final int RESULT_REMOTE_EXCEPTION = 31;
    public static final int RESULT_NO_DEFAULT_SMS_APP = 32;
    public static final int RESULT_RIL_RADIO_NOT_AVAILABLE = 100;
    public static final int RESULT_RIL_SMS_SEND_FAIL_RETRY = 101;
    public static final int RESULT_RIL_NETWORK_REJECT = 102;
    public static final int RESULT_RIL_INVALID_STATE = 103;
    public static final int RESULT_RIL_INVALID_ARGUMENTS = 104;
    public static final int RESULT_RIL_NO_MEMORY = 105;
    public static final int RESULT_RIL_REQUEST_RATE_LIMITED = 106;
    public static final int RESULT_RIL_INVALID_SMS_FORMAT = 107;
    public static final int RESULT_RIL_SYSTEM_ERR = 108;
    public static final int RESULT_RIL_ENCODING_ERR = 109;
    public static final int RESULT_RIL_INVALID_SMSC_ADDRESS = 110;
    public static final int RESULT_RIL_MODEM_ERR = 111;
    public static final int RESULT_RIL_NETWORK_ERR = 112;
    public static final int RESULT_RIL_INTERNAL_ERR = 113;
    public static final int RESULT_RIL_REQUEST_NOT_SUPPORTED = 114;
    public static final int RESULT_RIL_INVALID_MODEM_STATE = 115;
    public static final int RESULT_RIL_NETWORK_NOT_READY = 116;
    public static final int RESULT_RIL_OPERATION_NOT_ALLOWED = 117;
    public static final int RESULT_RIL_NO_RESOURCES = 118;
    public static final int RESULT_RIL_CANCELLED = 119;
    public static final int RESULT_RIL_SIM_ABSENT = 120;
    public static final int RESULT_RIL_SIMULTANEOUS_SMS_AND_CALL_NOT_ALLOWED = 121;
    public static final int RESULT_RIL_ACCESS_BARRED = 122;
    public static final int RESULT_RIL_BLOCKED_DUE_TO_CALL = 123;
    public static final int RESULT_RECEIVE_DISPATCH_FAILURE = 500;
    public static final int RESULT_RECEIVE_INJECTED_NULL_PDU = 501;
    public static final int RESULT_RECEIVE_RUNTIME_EXCEPTION = 502;
    public static final int RESULT_RECEIVE_NULL_MESSAGE_FROM_RIL = 503;
    public static final int RESULT_RECEIVE_WHILE_ENCRYPTED = 504;
    public static final int RESULT_RECEIVE_SQL_EXCEPTION = 505;
    public static final int RESULT_RECEIVE_URI_EXCEPTION = 506;
    public static final int MMS_ERROR_UNSPECIFIED = 1;
    public static final int MMS_ERROR_INVALID_APN = 2;
    public static final int MMS_ERROR_UNABLE_CONNECT_MMS = 3;
    public static final int MMS_ERROR_HTTP_FAILURE = 4;
    public static final int MMS_ERROR_IO_ERROR = 5;
    public static final int MMS_ERROR_RETRY = 6;
    public static final int MMS_ERROR_CONFIGURATION_ERROR = 7;
    public static final int MMS_ERROR_NO_DATA_NETWORK = 8;
    public static final String EXTRA_MMS_DATA = "android.telephony.extra.MMS_DATA";
    public static final String EXTRA_MMS_HTTP_STATUS = "android.telephony.extra.MMS_HTTP_STATUS";
    public static final String REGEX_PREFIX_DELIMITER = ",";
    public static final int RESULT_STATUS_SUCCESS = 0;
    public static final int RESULT_STATUS_TIMEOUT = 1;
    public static final String EXTRA_SMS_MESSAGE = "android.telephony.extra.SMS_MESSAGE";
    public static final String EXTRA_STATUS = "android.telephony.extra.STATUS";
    public static final String EXTRA_SIM_SUBSCRIPTION_ID = "android.telephony.extra.SIM_SUBSCRIPTION_ID";
    public static final int SMS_CATEGORY_NOT_SHORT_CODE = 0;
    public static final int SMS_CATEGORY_FREE_SHORT_CODE = 1;
    public static final int SMS_CATEGORY_STANDARD_SHORT_CODE = 2;
    public static final int SMS_CATEGORY_POSSIBLE_PREMIUM_SHORT_CODE = 3;
    public static final int SMS_CATEGORY_PREMIUM_SHORT_CODE = 4;

    private String getOpPackageName() {
        if (this.mContext == null) {
            return null;
        }
        return this.mContext.getOpPackageName();
    }

    private String getAttributionTag() {
        if (this.mContext == null) {
            return null;
        }
        return this.mContext.getAttributionTag();
    }

    public void sendTextMessage(String destinationAddress, String scAddress, String text, PendingIntent sentIntent, PendingIntent deliveryIntent) {
        this.sendTextMessageInternal(destinationAddress, scAddress, text, sentIntent, deliveryIntent, true, this.getOpPackageName(), this.getAttributionTag(), 0L);
    }

    public void sendTextMessage(String destinationAddress, String scAddress, String text, PendingIntent sentIntent, PendingIntent deliveryIntent, long messageId) {
        this.sendTextMessageInternal(destinationAddress, scAddress, text, sentIntent, deliveryIntent, true, this.getOpPackageName(), this.getAttributionTag(), messageId);
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public void sendTextMessage(String destinationAddress, String scAddress, String text, PendingIntent sentIntent, PendingIntent deliveryIntent, int priority, boolean expectMore, int validityPeriod) {
        this.sendTextMessageInternal(destinationAddress, scAddress, text, sentIntent, deliveryIntent, true, priority, expectMore, validityPeriod);
    }

    private void sendTextMessageInternal(final String destinationAddress, final String scAddress, final String text, final PendingIntent sentIntent, final PendingIntent deliveryIntent, final boolean persistMessage, final String packageName, final String attributionTag, final long messageId) {
        if (TextUtils.isEmpty(destinationAddress)) {
            throw new IllegalArgumentException("Invalid destinationAddress");
        }
        if (TextUtils.isEmpty(text)) {
            throw new IllegalArgumentException("Invalid message body");
        }
        if (persistMessage) {
            this.resolveSubscriptionForOperation(new SubscriptionResolverResult(){

                @Override
                public void onSuccess(int subId) {
                    ISms iSms = SmsManager.getISmsServiceOrThrow();
                    try {
                        iSms.sendTextForSubscriber(subId, packageName, attributionTag, destinationAddress, scAddress, text, sentIntent, deliveryIntent, persistMessage, messageId);
                    }
                    catch (RemoteException e) {
                        Log.e(SmsManager.TAG, "sendTextMessageInternal: Couldn't send SMS, exception - " + e.getMessage() + " " + SmsManager.formatCrossStackMessageId(messageId));
                        SmsManager.notifySmsError(sentIntent, 31);
                    }
                }

                @Override
                public void onFailure() {
                    SmsManager.notifySmsError(sentIntent, 32);
                }
            });
        } else {
            ISms iSms = SmsManager.getISmsServiceOrThrow();
            try {
                iSms.sendTextForSubscriber(this.getSubscriptionId(), packageName, attributionTag, destinationAddress, scAddress, text, sentIntent, deliveryIntent, persistMessage, messageId);
            }
            catch (RemoteException e) {
                Log.e(TAG, "sendTextMessageInternal (no persist): Couldn't send SMS, exception - " + e.getMessage() + " " + SmsManager.formatCrossStackMessageId(messageId));
                SmsManager.notifySmsError(sentIntent, 31);
            }
        }
    }

    @RequiresPermission(allOf={"android.permission.MODIFY_PHONE_STATE", "android.permission.SEND_SMS"})
    public void sendTextMessageWithoutPersisting(String destinationAddress, String scAddress, String text, PendingIntent sentIntent, PendingIntent deliveryIntent) {
        this.sendTextMessageInternal(destinationAddress, scAddress, text, sentIntent, deliveryIntent, false, this.getOpPackageName(), this.getAttributionTag(), 0L);
    }

    private void sendTextMessageInternal(final String destinationAddress, final String scAddress, final String text, final PendingIntent sentIntent, final PendingIntent deliveryIntent, final boolean persistMessage, int priority, final boolean expectMore, int validityPeriod) {
        if (TextUtils.isEmpty(destinationAddress)) {
            throw new IllegalArgumentException("Invalid destinationAddress");
        }
        if (TextUtils.isEmpty(text)) {
            throw new IllegalArgumentException("Invalid message body");
        }
        if (priority < 0 || priority > 3) {
            Log.e(TAG, "Invalid Priority " + priority);
            priority = -1;
        }
        if (validityPeriod < 5 || validityPeriod > 635040) {
            Log.e(TAG, "Invalid Validity Period " + validityPeriod);
            validityPeriod = -1;
        }
        final int finalPriority = priority;
        final int finalValidity = validityPeriod;
        if (persistMessage) {
            this.resolveSubscriptionForOperation(new SubscriptionResolverResult(){

                @Override
                public void onSuccess(int subId) {
                    try {
                        ISms iSms = SmsManager.getISmsServiceOrThrow();
                        if (iSms != null) {
                            iSms.sendTextForSubscriberWithOptions(subId, null, null, destinationAddress, scAddress, text, sentIntent, deliveryIntent, persistMessage, finalPriority, expectMore, finalValidity);
                        }
                    }
                    catch (RemoteException e) {
                        Log.e(SmsManager.TAG, "sendTextMessageInternal: Couldn't send SMS, exception - " + e.getMessage());
                        SmsManager.notifySmsError(sentIntent, 31);
                    }
                }

                @Override
                public void onFailure() {
                    SmsManager.notifySmsError(sentIntent, 32);
                }
            });
        } else {
            try {
                ISms iSms = SmsManager.getISmsServiceOrThrow();
                if (iSms != null) {
                    iSms.sendTextForSubscriberWithOptions(this.getSubscriptionId(), null, null, destinationAddress, scAddress, text, sentIntent, deliveryIntent, persistMessage, finalPriority, expectMore, finalValidity);
                }
            }
            catch (RemoteException e) {
                Log.e(TAG, "sendTextMessageInternal(no persist): Couldn't send SMS, exception - " + e.getMessage());
                SmsManager.notifySmsError(sentIntent, 31);
            }
        }
    }

    @UnsupportedAppUsage
    public void sendTextMessageWithoutPersisting(String destinationAddress, String scAddress, String text, PendingIntent sentIntent, PendingIntent deliveryIntent, int priority, boolean expectMore, int validityPeriod) {
        this.sendTextMessageInternal(destinationAddress, scAddress, text, sentIntent, deliveryIntent, false, priority, expectMore, validityPeriod);
    }

    public void injectSmsPdu(byte[] pdu, String format, PendingIntent receivedIntent) {
        if (!format.equals("3gpp") && !format.equals("3gpp2")) {
            throw new IllegalArgumentException("Invalid pdu format. format must be either 3gpp or 3gpp2");
        }
        try {
            ISms iSms = TelephonyManager.getSmsService();
            if (iSms != null) {
                iSms.injectSmsPduForSubscriber(this.getSubscriptionId(), pdu, format, receivedIntent);
            }
        }
        catch (RemoteException ex) {
            try {
                if (receivedIntent != null) {
                    receivedIntent.send(31);
                }
            }
            catch (PendingIntent.CanceledException canceledException) {
                // empty catch block
            }
        }
    }

    public ArrayList<String> divideMessage(String text) {
        if (null == text) {
            throw new IllegalArgumentException("text is null");
        }
        return SmsMessage.fragmentText(text, this.getSubscriptionId());
    }

    public void sendMultipartTextMessage(String destinationAddress, String scAddress, ArrayList<String> parts, ArrayList<PendingIntent> sentIntents, ArrayList<PendingIntent> deliveryIntents) {
        this.sendMultipartTextMessageInternal(destinationAddress, scAddress, parts, sentIntents, deliveryIntents, true, this.getOpPackageName(), this.getAttributionTag(), 0L);
    }

    public void sendMultipartTextMessage(String destinationAddress, String scAddress, List<String> parts, List<PendingIntent> sentIntents, List<PendingIntent> deliveryIntents, long messageId) {
        this.sendMultipartTextMessageInternal(destinationAddress, scAddress, parts, sentIntents, deliveryIntents, true, this.getOpPackageName(), this.getAttributionTag(), messageId);
    }

    public void sendMultipartTextMessage(String destinationAddress, String scAddress, List<String> parts, List<PendingIntent> sentIntents, List<PendingIntent> deliveryIntents, String packageName, String attributionTag) {
        this.sendMultipartTextMessageInternal(destinationAddress, scAddress, parts, sentIntents, deliveryIntents, true, packageName, attributionTag, 0L);
    }

    private void sendMultipartTextMessageInternal(final String destinationAddress, final String scAddress, final List<String> parts, final List<PendingIntent> sentIntents, final List<PendingIntent> deliveryIntents, final boolean persistMessage, final String packageName, final String attributionTag, final long messageId) {
        if (TextUtils.isEmpty(destinationAddress)) {
            throw new IllegalArgumentException("Invalid destinationAddress");
        }
        if (parts == null || parts.size() < 1) {
            throw new IllegalArgumentException("Invalid message body");
        }
        if (parts.size() > 1) {
            if (persistMessage) {
                this.resolveSubscriptionForOperation(new SubscriptionResolverResult(){

                    @Override
                    public void onSuccess(int subId) {
                        try {
                            ISms iSms = SmsManager.getISmsServiceOrThrow();
                            iSms.sendMultipartTextForSubscriber(subId, packageName, attributionTag, destinationAddress, scAddress, parts, sentIntents, deliveryIntents, persistMessage, messageId);
                        }
                        catch (RemoteException e) {
                            Log.e(SmsManager.TAG, "sendMultipartTextMessageInternal: Couldn't send SMS - " + e.getMessage() + " " + SmsManager.formatCrossStackMessageId(messageId));
                            SmsManager.notifySmsError(sentIntents, 31);
                        }
                    }

                    @Override
                    public void onFailure() {
                        SmsManager.notifySmsError(sentIntents, 32);
                    }
                });
            } else {
                try {
                    ISms iSms = SmsManager.getISmsServiceOrThrow();
                    if (iSms != null) {
                        iSms.sendMultipartTextForSubscriber(this.getSubscriptionId(), packageName, attributionTag, destinationAddress, scAddress, parts, sentIntents, deliveryIntents, persistMessage, messageId);
                    }
                }
                catch (RemoteException e) {
                    Log.e(TAG, "sendMultipartTextMessageInternal: Couldn't send SMS - " + e.getMessage() + " " + SmsManager.formatCrossStackMessageId(messageId));
                    SmsManager.notifySmsError(sentIntents, 31);
                }
            }
        } else {
            PendingIntent sentIntent = null;
            PendingIntent deliveryIntent = null;
            if (sentIntents != null && sentIntents.size() > 0) {
                sentIntent = sentIntents.get(0);
            }
            if (deliveryIntents != null && deliveryIntents.size() > 0) {
                deliveryIntent = deliveryIntents.get(0);
            }
            this.sendTextMessageInternal(destinationAddress, scAddress, parts.get(0), sentIntent, deliveryIntent, true, packageName, attributionTag, messageId);
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MODIFY_PHONE_STATE")
    public void sendMultipartTextMessageWithoutPersisting(String destinationAddress, String scAddress, List<String> parts, List<PendingIntent> sentIntents, List<PendingIntent> deliveryIntents) {
        this.sendMultipartTextMessageInternal(destinationAddress, scAddress, parts, sentIntents, deliveryIntents, false, this.getOpPackageName(), this.getAttributionTag(), 0L);
    }

    @UnsupportedAppUsage
    public void sendMultipartTextMessage(String destinationAddress, String scAddress, ArrayList<String> parts, ArrayList<PendingIntent> sentIntents, ArrayList<PendingIntent> deliveryIntents, int priority, boolean expectMore, int validityPeriod) {
        this.sendMultipartTextMessageInternal(destinationAddress, scAddress, parts, sentIntents, deliveryIntents, true, priority, expectMore, validityPeriod);
    }

    private void sendMultipartTextMessageInternal(final String destinationAddress, final String scAddress, final List<String> parts, final List<PendingIntent> sentIntents, final List<PendingIntent> deliveryIntents, final boolean persistMessage, int priority, final boolean expectMore, int validityPeriod) {
        if (TextUtils.isEmpty(destinationAddress)) {
            throw new IllegalArgumentException("Invalid destinationAddress");
        }
        if (parts == null || parts.size() < 1) {
            throw new IllegalArgumentException("Invalid message body");
        }
        if (priority < 0 || priority > 3) {
            Log.e(TAG, "Invalid Priority " + priority);
            priority = -1;
        }
        if (validityPeriod < 5 || validityPeriod > 635040) {
            Log.e(TAG, "Invalid Validity Period " + validityPeriod);
            validityPeriod = -1;
        }
        if (parts.size() > 1) {
            final int finalPriority = priority;
            final int finalValidity = validityPeriod;
            if (persistMessage) {
                this.resolveSubscriptionForOperation(new SubscriptionResolverResult(){

                    @Override
                    public void onSuccess(int subId) {
                        try {
                            ISms iSms = SmsManager.getISmsServiceOrThrow();
                            if (iSms != null) {
                                iSms.sendMultipartTextForSubscriberWithOptions(subId, null, null, destinationAddress, scAddress, parts, sentIntents, deliveryIntents, persistMessage, finalPriority, expectMore, finalValidity);
                            }
                        }
                        catch (RemoteException e) {
                            Log.e(SmsManager.TAG, "sendMultipartTextMessageInternal: Couldn't send SMS - " + e.getMessage());
                            SmsManager.notifySmsError(sentIntents, 31);
                        }
                    }

                    @Override
                    public void onFailure() {
                        SmsManager.notifySmsError(sentIntents, 32);
                    }
                });
            } else {
                try {
                    ISms iSms = SmsManager.getISmsServiceOrThrow();
                    if (iSms != null) {
                        iSms.sendMultipartTextForSubscriberWithOptions(this.getSubscriptionId(), null, null, destinationAddress, scAddress, parts, sentIntents, deliveryIntents, persistMessage, finalPriority, expectMore, finalValidity);
                    }
                }
                catch (RemoteException e) {
                    Log.e(TAG, "sendMultipartTextMessageInternal (no persist): Couldn't send SMS - " + e.getMessage());
                    SmsManager.notifySmsError(sentIntents, 31);
                }
            }
        } else {
            PendingIntent sentIntent = null;
            PendingIntent deliveryIntent = null;
            if (sentIntents != null && sentIntents.size() > 0) {
                sentIntent = sentIntents.get(0);
            }
            if (deliveryIntents != null && deliveryIntents.size() > 0) {
                deliveryIntent = deliveryIntents.get(0);
            }
            this.sendTextMessageInternal(destinationAddress, scAddress, parts.get(0), sentIntent, deliveryIntent, persistMessage, priority, expectMore, validityPeriod);
        }
    }

    public void sendDataMessage(final String destinationAddress, final String scAddress, final short destinationPort, final byte[] data, final PendingIntent sentIntent, final PendingIntent deliveryIntent) {
        if (TextUtils.isEmpty(destinationAddress)) {
            throw new IllegalArgumentException("Invalid destinationAddress");
        }
        if (data == null || data.length == 0) {
            throw new IllegalArgumentException("Invalid message data");
        }
        this.resolveSubscriptionForOperation(new SubscriptionResolverResult(){

            @Override
            public void onSuccess(int subId) {
                try {
                    ISms iSms = SmsManager.getISmsServiceOrThrow();
                    iSms.sendDataForSubscriber(subId, null, null, destinationAddress, scAddress, destinationPort & 0xFFFF, data, sentIntent, deliveryIntent);
                }
                catch (RemoteException e) {
                    Log.e(SmsManager.TAG, "sendDataMessage: Couldn't send SMS - Exception: " + e.getMessage());
                    SmsManager.notifySmsError(sentIntent, 31);
                }
            }

            @Override
            public void onFailure() {
                SmsManager.notifySmsError(sentIntent, 32);
            }
        });
    }

    @Deprecated
    public static SmsManager getDefault() {
        return DEFAULT_INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SmsManager getSmsManagerForContextAndSubscriptionId(Context context, int subId) {
        Object object = sLockObject;
        synchronized (object) {
            Pair<Context, Integer> key = new Pair<Context, Integer>(context, subId);
            SmsManager smsManager = sSubInstances.get(key);
            if (smsManager == null) {
                smsManager = new SmsManager(context, subId);
                sSubInstances.put(key, smsManager);
            }
            return smsManager;
        }
    }

    @Deprecated
    public static SmsManager getSmsManagerForSubscriptionId(int subId) {
        return SmsManager.getSmsManagerForContextAndSubscriptionId(null, subId);
    }

    public SmsManager createForSubscriptionId(int subId) {
        return SmsManager.getSmsManagerForContextAndSubscriptionId(this.mContext, subId);
    }

    private SmsManager(Context context, int subId) {
        this.mContext = context;
        this.mSubId = subId;
    }

    public int getSubscriptionId() {
        try {
            return this.mSubId == Integer.MAX_VALUE ? SmsManager.getISmsServiceOrThrow().getPreferredSmsSubscription() : this.mSubId;
        }
        catch (RemoteException e) {
            return -1;
        }
    }

    private void resolveSubscriptionForOperation(final SubscriptionResolverResult resolverResult) {
        int subId = this.getSubscriptionId();
        boolean isSmsSimPickActivityNeeded = false;
        try {
            ISms iSms = SmsManager.getISmsService();
            if (iSms != null) {
                isSmsSimPickActivityNeeded = iSms.isSmsSimPickActivityNeeded(subId);
            }
        }
        catch (RemoteException ex) {
            Log.e(TAG, "resolveSubscriptionForOperation", ex);
        }
        if (!isSmsSimPickActivityNeeded) {
            this.sendResolverResult(resolverResult, subId, false);
            return;
        }
        Log.d(TAG, "resolveSubscriptionForOperation isSmsSimPickActivityNeeded is true for calling package. ");
        try {
            SmsManager.getITelephony().enqueueSmsPickResult(null, null, new IIntegerConsumer.Stub(){

                @Override
                public void accept(int subId) {
                    SmsManager.this.sendResolverResult(resolverResult, subId, true);
                }
            });
        }
        catch (RemoteException ex) {
            Log.e(TAG, "Unable to launch activity", ex);
            this.sendResolverResult(resolverResult, subId, true);
        }
    }

    private void sendResolverResult(SubscriptionResolverResult resolverResult, int subId, boolean pickActivityShown) {
        if (SubscriptionManager.isValidSubscriptionId(subId)) {
            resolverResult.onSuccess(subId);
            return;
        }
        if (!Compatibility.isChangeEnabled(145147528L) && !pickActivityShown) {
            resolverResult.onSuccess(subId);
        } else {
            resolverResult.onFailure();
        }
    }

    private static ITelephony getITelephony() {
        ITelephony binder = ITelephony.Stub.asInterface(TelephonyFrameworkInitializer.getTelephonyServiceManager().getTelephonyServiceRegisterer().get());
        if (binder == null) {
            throw new RuntimeException("Could not find Telephony Service.");
        }
        return binder;
    }

    private static void notifySmsError(PendingIntent pendingIntent, int error) {
        if (pendingIntent != null) {
            try {
                pendingIntent.send(error);
            }
            catch (PendingIntent.CanceledException canceledException) {
                // empty catch block
            }
        }
    }

    private static void notifySmsError(List<PendingIntent> pendingIntents, int error) {
        if (pendingIntents != null) {
            for (PendingIntent pendingIntent : pendingIntents) {
                SmsManager.notifySmsError(pendingIntent, error);
            }
        }
    }

    private static ISms getISmsServiceOrThrow() {
        ISms iSms = TelephonyManager.getSmsService();
        if (iSms == null) {
            throw new UnsupportedOperationException("Sms is not supported");
        }
        return iSms;
    }

    private static ISms getISmsService() {
        return TelephonyManager.getSmsService();
    }

    @RequiresPermission(value="android.permission.ACCESS_MESSAGES_ON_ICC")
    public boolean copyMessageToIcc(byte[] smsc, byte[] pdu, int status) {
        boolean success = false;
        if (pdu == null) {
            throw new IllegalArgumentException("pdu is null");
        }
        try {
            ISms iSms = SmsManager.getISmsService();
            if (iSms != null) {
                success = iSms.copyMessageToIccEfForSubscriber(this.getSubscriptionId(), null, status, pdu, smsc);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return success;
    }

    @UnsupportedAppUsage
    @RequiresPermission(value="android.permission.ACCESS_MESSAGES_ON_ICC")
    public boolean deleteMessageFromIcc(int messageIndex) {
        boolean success = false;
        try {
            ISms iSms = SmsManager.getISmsService();
            if (iSms != null) {
                success = iSms.updateMessageOnIccEfForSubscriber(this.getSubscriptionId(), null, messageIndex, 0, null);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return success;
    }

    @UnsupportedAppUsage
    @RequiresPermission(value="android.permission.ACCESS_MESSAGES_ON_ICC")
    public boolean updateMessageOnIcc(int messageIndex, int newStatus, byte[] pdu) {
        boolean success = false;
        try {
            ISms iSms = SmsManager.getISmsService();
            if (iSms != null) {
                success = iSms.updateMessageOnIccEfForSubscriber(this.getSubscriptionId(), null, messageIndex, newStatus, pdu);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return success;
    }

    @RequiresPermission(value="android.permission.ACCESS_MESSAGES_ON_ICC")
    public List<SmsMessage> getMessagesFromIcc() {
        return this.getAllMessagesFromIcc();
    }

    @UnsupportedAppUsage
    public ArrayList<SmsMessage> getAllMessagesFromIcc() {
        List<SmsRawData> records = null;
        try {
            ISms iSms = SmsManager.getISmsService();
            if (iSms != null) {
                records = iSms.getAllMessagesFromIccEfForSubscriber(this.getSubscriptionId(), null);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return this.createMessageListFromRawRecords(records);
    }

    @SystemApi
    public boolean enableCellBroadcastRange(int startMessageId, int endMessageId, int ranType) {
        boolean success = false;
        if (endMessageId < startMessageId) {
            throw new IllegalArgumentException("endMessageId < startMessageId");
        }
        try {
            ISms iSms = SmsManager.getISmsService();
            if (iSms != null) {
                int subId = this.getSubscriptionId();
                success = iSms.enableCellBroadcastRangeForSubscriber(subId, startMessageId, endMessageId, ranType);
                Rlog.d(TAG, "enableCellBroadcastRange: " + (success ? "succeeded" : "failed") + " at calling enableCellBroadcastRangeForSubscriber. subId = " + subId);
            }
        }
        catch (RemoteException ex) {
            Rlog.d(TAG, "enableCellBroadcastRange: " + ex.getStackTrace());
        }
        return success;
    }

    @SystemApi
    public boolean disableCellBroadcastRange(int startMessageId, int endMessageId, int ranType) {
        boolean success = false;
        if (endMessageId < startMessageId) {
            throw new IllegalArgumentException("endMessageId < startMessageId");
        }
        try {
            ISms iSms = SmsManager.getISmsService();
            if (iSms != null) {
                int subId = this.getSubscriptionId();
                success = iSms.disableCellBroadcastRangeForSubscriber(subId, startMessageId, endMessageId, ranType);
                Rlog.d(TAG, "disableCellBroadcastRange: " + (success ? "succeeded" : "failed") + " at calling disableCellBroadcastRangeForSubscriber. subId = " + subId);
            }
        }
        catch (RemoteException ex) {
            Rlog.d(TAG, "disableCellBroadcastRange: " + ex.getStackTrace());
        }
        return success;
    }

    private ArrayList<SmsMessage> createMessageListFromRawRecords(List<SmsRawData> records) {
        ArrayList<SmsMessage> messages = new ArrayList<SmsMessage>();
        if (records != null) {
            int count = records.size();
            for (int i = 0; i < count; ++i) {
                SmsMessage sms;
                SmsRawData data = records.get(i);
                if (data == null || (sms = SmsMessage.createFromEfRecord(i + 1, data.getBytes(), this.getSubscriptionId())) == null) continue;
                messages.add(sms);
            }
        }
        return messages;
    }

    public boolean isImsSmsSupported() {
        boolean boSupported = false;
        try {
            ISms iSms = SmsManager.getISmsService();
            if (iSms != null) {
                boSupported = iSms.isImsSmsSupportedForSubscriber(this.getSubscriptionId());
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return boSupported;
    }

    public String getImsSmsFormat() {
        String format = "unknown";
        try {
            ISms iSms = SmsManager.getISmsService();
            if (iSms != null) {
                format = iSms.getImsSmsFormatForSubscriber(this.getSubscriptionId());
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return format;
    }

    public static int getDefaultSmsSubscriptionId() {
        try {
            return SmsManager.getISmsService().getPreferredSmsSubscription();
        }
        catch (RemoteException e) {
            return -1;
        }
        catch (NullPointerException e) {
            return -1;
        }
    }

    @UnsupportedAppUsage
    public boolean isSMSPromptEnabled() {
        ISms iSms = null;
        try {
            iSms = TelephonyManager.getSmsService();
            return iSms.isSMSPromptEnabled();
        }
        catch (RemoteException ex) {
            return false;
        }
        catch (NullPointerException ex) {
            return false;
        }
    }

    @RequiresPermission(anyOf={"android.permission.READ_PHONE_STATE", "android.permission.READ_PRIVILEGED_PHONE_STATE"})
    public int getSmsCapacityOnIcc() {
        int ret = 0;
        try {
            ISms iccISms = SmsManager.getISmsService();
            if (iccISms != null) {
                ret = iccISms.getSmsCapacityOnIccForSubscriber(this.getSubscriptionId());
            }
        }
        catch (RemoteException ex) {
            Log.e(TAG, "getSmsCapacityOnIcc() RemoteException", ex);
        }
        return ret;
    }

    public void sendMultimediaMessage(Context context, Uri contentUri, String locationUrl, Bundle configOverrides, PendingIntent sentIntent) {
        this.sendMultimediaMessage(context, contentUri, locationUrl, configOverrides, sentIntent, 0L);
    }

    public void sendMultimediaMessage(Context context, final Uri contentUri, final String locationUrl, final Bundle configOverrides, final PendingIntent sentIntent, final long messageId) {
        if (contentUri == null) {
            throw new IllegalArgumentException("Uri contentUri null");
        }
        final MmsManager m = (MmsManager)context.getSystemService("mms");
        if (m != null) {
            this.resolveSubscriptionForOperation(new SubscriptionResolverResult(){

                @Override
                public void onSuccess(int subId) {
                    m.sendMultimediaMessage(subId, contentUri, locationUrl, configOverrides, sentIntent, messageId);
                }

                @Override
                public void onFailure() {
                    SmsManager.notifySmsError(sentIntent, 32);
                }
            });
        }
    }

    public void downloadMultimediaMessage(Context context, String locationUrl, Uri contentUri, Bundle configOverrides, PendingIntent downloadedIntent) {
        this.downloadMultimediaMessage(context, locationUrl, contentUri, configOverrides, downloadedIntent, 0L);
    }

    public void downloadMultimediaMessage(Context context, final String locationUrl, final Uri contentUri, final Bundle configOverrides, final PendingIntent downloadedIntent, final long messageId) {
        if (TextUtils.isEmpty(locationUrl)) {
            throw new IllegalArgumentException("Empty MMS location URL");
        }
        if (contentUri == null) {
            throw new IllegalArgumentException("Uri contentUri null");
        }
        final MmsManager m = (MmsManager)context.getSystemService("mms");
        if (m != null) {
            this.resolveSubscriptionForOperation(new SubscriptionResolverResult(){

                @Override
                public void onSuccess(int subId) {
                    m.downloadMultimediaMessage(subId, locationUrl, contentUri, configOverrides, downloadedIntent, messageId);
                }

                @Override
                public void onFailure() {
                    SmsManager.notifySmsError(downloadedIntent, 32);
                }
            });
        }
    }

    public Bundle getCarrierConfigValues() {
        try {
            ISms iSms = SmsManager.getISmsService();
            if (iSms != null) {
                return iSms.getCarrierConfigValuesForSubscriber(this.getSubscriptionId());
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return new Bundle();
    }

    public String createAppSpecificSmsToken(PendingIntent intent) {
        try {
            ISms iccSms = SmsManager.getISmsServiceOrThrow();
            return iccSms.createAppSpecificSmsToken(this.getSubscriptionId(), null, intent);
        }
        catch (RemoteException ex) {
            ex.rethrowFromSystemServer();
            return null;
        }
    }

    @RequiresPermission(value="android.permission.SMS_FINANCIAL_TRANSACTIONS")
    public void getSmsMessagesForFinancialApp(Bundle params, Executor executor, FinancialSmsCallback callback2) {
    }

    public String createAppSpecificSmsTokenWithPackageInfo(String prefixes, PendingIntent intent) {
        try {
            ISms iccSms = SmsManager.getISmsServiceOrThrow();
            return iccSms.createAppSpecificSmsTokenWithPackageInfo(this.getSubscriptionId(), null, prefixes, intent);
        }
        catch (RemoteException ex) {
            ex.rethrowFromSystemServer();
            return null;
        }
    }

    @RequiresPermission(value="android.permission.READ_PHONE_STATE")
    public int checkSmsShortCodeDestination(String destAddress, String countryIso) {
        try {
            ISms iccISms = SmsManager.getISmsServiceOrThrow();
            if (iccISms != null) {
                return iccISms.checkSmsShortCodeDestination(this.getSubscriptionId(), null, null, destAddress, countryIso);
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "checkSmsShortCodeDestination() RemoteException", e);
        }
        return 0;
    }

    @RequiresPermission(value="android.permission.READ_PRIVILEGED_PHONE_STATE")
    public String getSmscAddress() {
        String smsc = null;
        try {
            ISms iSms = SmsManager.getISmsService();
            if (iSms != null) {
                smsc = iSms.getSmscAddressFromIccEfForSubscriber(this.getSubscriptionId(), null);
            }
        }
        catch (RemoteException ex) {
            throw new RuntimeException(ex);
        }
        return smsc;
    }

    @RequiresPermission(value="android.permission.MODIFY_PHONE_STATE")
    public boolean setSmscAddress(String smsc) {
        try {
            ISms iSms = SmsManager.getISmsService();
            if (iSms != null) {
                return iSms.setSmscAddressOnIccEfForSubscriber(smsc, this.getSubscriptionId(), null);
            }
        }
        catch (RemoteException ex) {
            throw new RuntimeException(ex);
        }
        return false;
    }

    @SystemApi
    @RequiresPermission(value="android.permission.READ_PRIVILEGED_PHONE_STATE")
    public int getPremiumSmsConsent(String packageName) {
        int permission2 = 0;
        try {
            ISms iSms = SmsManager.getISmsService();
            if (iSms != null) {
                permission2 = iSms.getPremiumSmsPermission(packageName);
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "getPremiumSmsPermission() RemoteException", e);
        }
        return permission2;
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MODIFY_PHONE_STATE")
    public void setPremiumSmsConsent(String packageName, int permission2) {
        try {
            ISms iSms = SmsManager.getISmsService();
            if (iSms != null) {
                iSms.setPremiumSmsPermission(packageName, permission2);
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "setPremiumSmsPermission() RemoteException", e);
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MODIFY_CELL_BROADCASTS")
    public void resetAllCellBroadcastRanges() {
        try {
            ISms iSms = SmsManager.getISmsService();
            if (iSms != null) {
                iSms.resetAllCellBroadcastRanges(this.getSubscriptionId());
            }
        }
        catch (RemoteException ex) {
            ex.rethrowFromSystemServer();
        }
    }

    private static String formatCrossStackMessageId(long id2) {
        return "{x-message-id:" + id2 + "}";
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SmsShortCodeCategory {
    }

    public static abstract class FinancialSmsCallback {
        public abstract void onFinancialSmsMessages(CursorWindow var1);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Result {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface StatusOnIcc {
    }

    private static interface SubscriptionResolverResult {
        public void onSuccess(int var1);

        public void onFailure();
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface PremiumSmsConsent {
    }
}

