/*
 * Decompiled with CFR 0.152.
 */
package android.telephony;

import android.annotation.SystemApi;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.database.Cursor;
import android.net.Uri;
import android.os.PersistableBundle;
import android.sysprop.TelephonyProperties;
import android.telephony.CarrierConfigManager;
import android.telephony.JapanesePhoneNumberFormatter;
import android.telephony.SubscriptionManager;
import android.telephony.TelephonyManager;
import android.text.Editable;
import android.text.Spannable;
import android.text.SpannableStringBuilder;
import android.text.TextUtils;
import android.text.style.TtsSpan;
import android.util.SparseIntArray;
import com.android.i18n.phonenumbers.NumberParseException;
import com.android.i18n.phonenumbers.PhoneNumberUtil;
import com.android.i18n.phonenumbers.Phonenumber;
import com.android.layoutlib.bridge.android.AndroidLocale;
import com.android.telephony.Rlog;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PhoneNumberUtils {
    public static final int BCD_EXTENDED_TYPE_EF_ADN = 1;
    public static final int BCD_EXTENDED_TYPE_CALLED_PARTY = 2;
    public static final char PAUSE = ',';
    public static final char WAIT = ';';
    public static final char WILD = 'N';
    private static final String CLIR_ON = "*31#";
    private static final String CLIR_OFF = "#31#";
    public static final int TOA_International = 145;
    public static final int TOA_Unknown = 129;
    static final String LOG_TAG = "PhoneNumberUtils";
    private static final boolean DBG = false;
    private static final String BCD_EF_ADN_EXTENDED = "*#,N;";
    private static final String BCD_CALLED_PARTY_EXTENDED = "*#abc";
    private static final Pattern GLOBAL_PHONE_NUMBER_PATTERN = Pattern.compile("[\\+]?[0-9.-]+");
    private static int sMinMatch = 0;
    public static final int FORMAT_UNKNOWN = 0;
    public static final int FORMAT_NANP = 1;
    public static final int FORMAT_JAPAN = 2;
    private static final String[] NANP_COUNTRIES = new String[]{"US", "CA", "AS", "AI", "AG", "BS", "BB", "BM", "VG", "KY", "DM", "DO", "GD", "GU", "JM", "PR", "MS", "MP", "KN", "LC", "VC", "TT", "TC", "VI"};
    private static final String KOREA_ISO_COUNTRY_CODE = "KR";
    private static final String JAPAN_ISO_COUNTRY_CODE = "JP";
    private static final int NANP_STATE_DIGIT = 1;
    private static final int NANP_STATE_PLUS = 2;
    private static final int NANP_STATE_ONE = 3;
    private static final int NANP_STATE_DASH = 4;
    private static final SparseIntArray KEYPAD_MAP = new SparseIntArray();
    private static final char PLUS_SIGN_CHAR = '+';
    private static final String PLUS_SIGN_STRING = "+";
    private static final String NANP_IDP_STRING = "011";
    private static final int NANP_LENGTH = 10;
    private static final boolean[] COUNTRY_CALLING_CALL;
    private static final int CCC_LENGTH;
    private static String[] sConvertToEmergencyMap;

    public static boolean isISODigit(char c) {
        return c >= '0' && c <= '9';
    }

    public static boolean is12Key(char c) {
        return c >= '0' && c <= '9' || c == '*' || c == '#';
    }

    public static boolean isDialable(char c) {
        return c >= '0' && c <= '9' || c == '*' || c == '#' || c == '+' || c == 'N';
    }

    public static boolean isReallyDialable(char c) {
        return c >= '0' && c <= '9' || c == '*' || c == '#' || c == '+';
    }

    public static boolean isNonSeparator(char c) {
        return c >= '0' && c <= '9' || c == '*' || c == '#' || c == '+' || c == 'N' || c == ';' || c == ',';
    }

    public static boolean isStartsPostDial(char c) {
        return c == ',' || c == ';';
    }

    private static boolean isPause(char c) {
        return c == 'p' || c == 'P';
    }

    private static boolean isToneWait(char c) {
        return c == 'w' || c == 'W';
    }

    private static int getMinMatch() {
        if (sMinMatch == 0) {
            sMinMatch = Resources.getSystem().getInteger(17694891);
        }
        return sMinMatch;
    }

    public static int getMinMatchForTest() {
        return PhoneNumberUtils.getMinMatch();
    }

    public static void setMinMatchForTest(int minMatch) {
        sMinMatch = minMatch;
    }

    private static boolean isSeparator(char ch) {
        return !(PhoneNumberUtils.isDialable(ch) || 'a' <= ch && ch <= 'z' || 'A' <= ch && ch <= 'Z');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getNumberFromIntent(Intent intent, Context context) {
        String number = null;
        Uri uri = intent.getData();
        if (uri == null) {
            return null;
        }
        String scheme = uri.getScheme();
        if (scheme == null) {
            return null;
        }
        if (scheme.equals("tel") || scheme.equals("sip")) {
            return uri.getSchemeSpecificPart();
        }
        if (context == null) {
            return null;
        }
        String type = intent.resolveType(context);
        String phoneColumn = null;
        String authority = uri.getAuthority();
        if ("contacts".equals(authority)) {
            phoneColumn = "number";
        } else if ("com.android.contacts".equals(authority)) {
            phoneColumn = "data1";
        }
        try (Cursor c = null;){
            c = context.getContentResolver().query(uri, new String[]{phoneColumn}, null, null, null);
            if (c != null && c.moveToFirst()) {
                number = c.getString(c.getColumnIndex(phoneColumn));
            }
        }
        return number;
    }

    public static String extractNetworkPortion(String phoneNumber) {
        if (phoneNumber == null) {
            return null;
        }
        int len = phoneNumber.length();
        StringBuilder ret = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            char c = phoneNumber.charAt(i);
            int digit = Character.digit(c, 10);
            if (digit != -1) {
                ret.append(digit);
                continue;
            }
            if (c == '+') {
                String prefix = ret.toString();
                if (prefix.length() != 0 && !prefix.equals(CLIR_ON) && !prefix.equals(CLIR_OFF)) continue;
                ret.append(c);
                continue;
            }
            if (PhoneNumberUtils.isDialable(c)) {
                ret.append(c);
                continue;
            }
            if (PhoneNumberUtils.isStartsPostDial(c)) break;
        }
        return ret.toString();
    }

    @UnsupportedAppUsage
    public static String extractNetworkPortionAlt(String phoneNumber) {
        if (phoneNumber == null) {
            return null;
        }
        int len = phoneNumber.length();
        StringBuilder ret = new StringBuilder(len);
        boolean haveSeenPlus = false;
        for (int i = 0; i < len; ++i) {
            char c = phoneNumber.charAt(i);
            if (c == '+') {
                if (haveSeenPlus) continue;
                haveSeenPlus = true;
            }
            if (PhoneNumberUtils.isDialable(c)) {
                ret.append(c);
                continue;
            }
            if (PhoneNumberUtils.isStartsPostDial(c)) break;
        }
        return ret.toString();
    }

    public static String stripSeparators(String phoneNumber) {
        if (phoneNumber == null) {
            return null;
        }
        int len = phoneNumber.length();
        StringBuilder ret = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            char c = phoneNumber.charAt(i);
            int digit = Character.digit(c, 10);
            if (digit != -1) {
                ret.append(digit);
                continue;
            }
            if (!PhoneNumberUtils.isNonSeparator(c)) continue;
            ret.append(c);
        }
        return ret.toString();
    }

    public static String convertAndStrip(String phoneNumber) {
        return PhoneNumberUtils.stripSeparators(PhoneNumberUtils.convertKeypadLettersToDigits(phoneNumber));
    }

    @UnsupportedAppUsage
    public static String convertPreDial(String phoneNumber) {
        if (phoneNumber == null) {
            return null;
        }
        int len = phoneNumber.length();
        StringBuilder ret = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            char c = phoneNumber.charAt(i);
            if (PhoneNumberUtils.isPause(c)) {
                c = ',';
            } else if (PhoneNumberUtils.isToneWait(c)) {
                c = ';';
            }
            ret.append(c);
        }
        return ret.toString();
    }

    private static int minPositive(int a, int b) {
        if (a >= 0 && b >= 0) {
            return a < b ? a : b;
        }
        if (a >= 0) {
            return a;
        }
        if (b >= 0) {
            return b;
        }
        return -1;
    }

    private static void log(String msg) {
        Rlog.d(LOG_TAG, msg);
    }

    private static int indexOfLastNetworkChar(String a) {
        int wIndex;
        int origLength = a.length();
        int pIndex = a.indexOf(44);
        int trimIndex = PhoneNumberUtils.minPositive(pIndex, wIndex = a.indexOf(59));
        if (trimIndex < 0) {
            return origLength - 1;
        }
        return trimIndex - 1;
    }

    public static String extractPostDialPortion(String phoneNumber) {
        if (phoneNumber == null) {
            return null;
        }
        StringBuilder ret = new StringBuilder();
        int trimIndex = PhoneNumberUtils.indexOfLastNetworkChar(phoneNumber);
        int s = phoneNumber.length();
        for (int i = trimIndex + 1; i < s; ++i) {
            char c = phoneNumber.charAt(i);
            if (!PhoneNumberUtils.isNonSeparator(c)) continue;
            ret.append(c);
        }
        return ret.toString();
    }

    @Deprecated
    public static boolean compare(String a, String b) {
        return PhoneNumberUtils.compare(a, b, false);
    }

    @Deprecated
    public static boolean compare(Context context, String a, String b) {
        boolean useStrict = context.getResources().getBoolean(17891692);
        return PhoneNumberUtils.compare(a, b, useStrict);
    }

    @UnsupportedAppUsage
    public static boolean compare(String a, String b, boolean useStrictComparation) {
        return useStrictComparation ? PhoneNumberUtils.compareStrictly(a, b) : PhoneNumberUtils.compareLoosely(a, b);
    }

    @UnsupportedAppUsage
    public static boolean compareLoosely(String a, String b) {
        int numNonDialableCharsInA = 0;
        int numNonDialableCharsInB = 0;
        int minMatch = PhoneNumberUtils.getMinMatch();
        if (a == null || b == null) {
            return a == b;
        }
        if (a.length() == 0 || b.length() == 0) {
            return false;
        }
        int ia = PhoneNumberUtils.indexOfLastNetworkChar(a);
        int ib = PhoneNumberUtils.indexOfLastNetworkChar(b);
        int matched = 0;
        while (ia >= 0 && ib >= 0) {
            char cb;
            boolean skipCmp = false;
            char ca = a.charAt(ia);
            if (!PhoneNumberUtils.isDialable(ca)) {
                --ia;
                skipCmp = true;
                ++numNonDialableCharsInA;
            }
            if (!PhoneNumberUtils.isDialable(cb = b.charAt(ib))) {
                --ib;
                skipCmp = true;
                ++numNonDialableCharsInB;
            }
            if (skipCmp) continue;
            if (cb != ca && ca != 'N' && cb != 'N') break;
            --ia;
            --ib;
            ++matched;
        }
        if (matched < minMatch) {
            int effectiveBLen;
            int effectiveALen = a.length() - numNonDialableCharsInA;
            return effectiveALen == (effectiveBLen = b.length() - numNonDialableCharsInB) && effectiveALen == matched;
        }
        if (matched >= minMatch && (ia < 0 || ib < 0)) {
            return true;
        }
        if (PhoneNumberUtils.matchIntlPrefix(a, ia + 1) && PhoneNumberUtils.matchIntlPrefix(b, ib + 1)) {
            return true;
        }
        if (PhoneNumberUtils.matchTrunkPrefix(a, ia + 1) && PhoneNumberUtils.matchIntlPrefixAndCC(b, ib + 1)) {
            return true;
        }
        return PhoneNumberUtils.matchTrunkPrefix(b, ib + 1) && PhoneNumberUtils.matchIntlPrefixAndCC(a, ia + 1);
    }

    @UnsupportedAppUsage
    public static boolean compareStrictly(String a, String b) {
        return PhoneNumberUtils.compareStrictly(a, b, true);
    }

    @UnsupportedAppUsage
    public static boolean compareStrictly(String a, String b, boolean acceptInvalidCCCPrefix) {
        char chA;
        if (a == null || b == null) {
            return a == b;
        }
        if (a.length() == 0 && b.length() == 0) {
            return false;
        }
        int forwardIndexA = 0;
        int forwardIndexB = 0;
        CountryCallingCodeAndNewIndex cccA = PhoneNumberUtils.tryGetCountryCallingCodeAndNewIndex(a, acceptInvalidCCCPrefix);
        CountryCallingCodeAndNewIndex cccB = PhoneNumberUtils.tryGetCountryCallingCodeAndNewIndex(b, acceptInvalidCCCPrefix);
        boolean bothHasCountryCallingCode = false;
        boolean okToIgnorePrefix = true;
        boolean trunkPrefixIsOmittedA = false;
        boolean trunkPrefixIsOmittedB = false;
        if (cccA != null && cccB != null) {
            if (cccA.countryCallingCode != cccB.countryCallingCode) {
                return false;
            }
            okToIgnorePrefix = false;
            bothHasCountryCallingCode = true;
            forwardIndexA = cccA.newIndex;
            forwardIndexB = cccB.newIndex;
        } else if (cccA == null && cccB == null) {
            okToIgnorePrefix = false;
        } else {
            int tmp;
            if (cccA != null) {
                forwardIndexA = cccA.newIndex;
            } else {
                tmp = PhoneNumberUtils.tryGetTrunkPrefixOmittedIndex(b, 0);
                if (tmp >= 0) {
                    forwardIndexA = tmp;
                    trunkPrefixIsOmittedA = true;
                }
            }
            if (cccB != null) {
                forwardIndexB = cccB.newIndex;
            } else {
                tmp = PhoneNumberUtils.tryGetTrunkPrefixOmittedIndex(b, 0);
                if (tmp >= 0) {
                    forwardIndexB = tmp;
                    trunkPrefixIsOmittedB = true;
                }
            }
        }
        int backwardIndexA = a.length() - 1;
        int backwardIndexB = b.length() - 1;
        while (backwardIndexA >= forwardIndexA && backwardIndexB >= forwardIndexB) {
            boolean skip_compare = false;
            chA = a.charAt(backwardIndexA);
            char chB = b.charAt(backwardIndexB);
            if (PhoneNumberUtils.isSeparator(chA)) {
                --backwardIndexA;
                skip_compare = true;
            }
            if (PhoneNumberUtils.isSeparator(chB)) {
                --backwardIndexB;
                skip_compare = true;
            }
            if (skip_compare) continue;
            if (chA != chB) {
                return false;
            }
            --backwardIndexA;
            --backwardIndexB;
        }
        if (okToIgnorePrefix) {
            if (trunkPrefixIsOmittedA && forwardIndexA <= backwardIndexA || !PhoneNumberUtils.checkPrefixIsIgnorable(a, forwardIndexA, backwardIndexA)) {
                if (acceptInvalidCCCPrefix) {
                    return PhoneNumberUtils.compare(a, b, false);
                }
                return false;
            }
            if (trunkPrefixIsOmittedB && forwardIndexB <= backwardIndexB || !PhoneNumberUtils.checkPrefixIsIgnorable(b, forwardIndexA, backwardIndexB)) {
                if (acceptInvalidCCCPrefix) {
                    return PhoneNumberUtils.compare(a, b, false);
                }
                return false;
            }
        } else {
            boolean maybeNamp;
            boolean bl = maybeNamp = !bothHasCountryCallingCode;
            while (backwardIndexA >= forwardIndexA) {
                chA = a.charAt(backwardIndexA);
                if (PhoneNumberUtils.isDialable(chA)) {
                    if (maybeNamp && PhoneNumberUtils.tryGetISODigit(chA) == 1) {
                        maybeNamp = false;
                    } else {
                        return false;
                    }
                }
                --backwardIndexA;
            }
            while (backwardIndexB >= forwardIndexB) {
                char chB = b.charAt(backwardIndexB);
                if (PhoneNumberUtils.isDialable(chB)) {
                    if (maybeNamp && PhoneNumberUtils.tryGetISODigit(chB) == 1) {
                        maybeNamp = false;
                    } else {
                        return false;
                    }
                }
                --backwardIndexB;
            }
        }
        return true;
    }

    public static String toCallerIDMinMatch(String phoneNumber) {
        String np = PhoneNumberUtils.extractNetworkPortionAlt(phoneNumber);
        return PhoneNumberUtils.internalGetStrippedReversed(np, PhoneNumberUtils.getMinMatch());
    }

    public static String getStrippedReversed(String phoneNumber) {
        String np = PhoneNumberUtils.extractNetworkPortionAlt(phoneNumber);
        if (np == null) {
            return null;
        }
        return PhoneNumberUtils.internalGetStrippedReversed(np, np.length());
    }

    private static String internalGetStrippedReversed(String np, int numDigits) {
        if (np == null) {
            return null;
        }
        StringBuilder ret = new StringBuilder(numDigits);
        int length = np.length();
        int s = length;
        for (int i = length - 1; i >= 0 && s - i <= numDigits; --i) {
            char c = np.charAt(i);
            ret.append(c);
        }
        return ret.toString();
    }

    public static String stringFromStringAndTOA(String s, int TOA) {
        if (s == null) {
            return null;
        }
        if (TOA == 145 && s.length() > 0 && s.charAt(0) != '+') {
            return PLUS_SIGN_STRING + s;
        }
        return s;
    }

    public static int toaFromString(String s) {
        if (s != null && s.length() > 0 && s.charAt(0) == '+') {
            return 145;
        }
        return 129;
    }

    @Deprecated
    public static String calledPartyBCDToString(byte[] bytes, int offset2, int length) {
        return PhoneNumberUtils.calledPartyBCDToString(bytes, offset2, length, 1);
    }

    public static String calledPartyBCDToString(byte[] bytes, int offset2, int length, int bcdExtType) {
        boolean prependPlus = false;
        StringBuilder ret = new StringBuilder(1 + length * 2);
        if (length < 2) {
            return "";
        }
        if ((bytes[offset2] & 0xF0) == 144) {
            prependPlus = true;
        }
        PhoneNumberUtils.internalCalledPartyBCDFragmentToString(ret, bytes, offset2 + 1, length - 1, bcdExtType);
        if (prependPlus && ret.length() == 0) {
            return "";
        }
        if (prependPlus) {
            String retString = ret.toString();
            Pattern p = Pattern.compile("(^[#*])(.*)([#*])(.*)(#)$");
            Matcher m = p.matcher(retString);
            if (m.matches()) {
                if ("".equals(m.group(2))) {
                    ret = new StringBuilder();
                    ret.append(m.group(1));
                    ret.append(m.group(3));
                    ret.append(m.group(4));
                    ret.append(m.group(5));
                    ret.append(PLUS_SIGN_STRING);
                } else {
                    ret = new StringBuilder();
                    ret.append(m.group(1));
                    ret.append(m.group(2));
                    ret.append(m.group(3));
                    ret.append(PLUS_SIGN_STRING);
                    ret.append(m.group(4));
                    ret.append(m.group(5));
                }
            } else {
                p = Pattern.compile("(^[#*])(.*)([#*])(.*)");
                m = p.matcher(retString);
                if (m.matches()) {
                    ret = new StringBuilder();
                    ret.append(m.group(1));
                    ret.append(m.group(2));
                    ret.append(m.group(3));
                    ret.append(PLUS_SIGN_STRING);
                    ret.append(m.group(4));
                } else {
                    ret = new StringBuilder();
                    ret.append('+');
                    ret.append(retString);
                }
            }
        }
        return ret.toString();
    }

    private static void internalCalledPartyBCDFragmentToString(StringBuilder sb, byte[] bytes, int offset2, int length, int bcdExtType) {
        for (int i = offset2; i < length + offset2; ++i) {
            char c = PhoneNumberUtils.bcdToChar((byte)(bytes[i] & 0xF), bcdExtType);
            if (c == '\u0000') {
                return;
            }
            sb.append(c);
            byte b = (byte)(bytes[i] >> 4 & 0xF);
            if (b == 15 && i + 1 == length + offset2) break;
            c = PhoneNumberUtils.bcdToChar(b, bcdExtType);
            if (c == '\u0000') {
                return;
            }
            sb.append(c);
        }
    }

    @Deprecated
    public static String calledPartyBCDFragmentToString(byte[] bytes, int offset2, int length) {
        return PhoneNumberUtils.calledPartyBCDFragmentToString(bytes, offset2, length, 1);
    }

    public static String calledPartyBCDFragmentToString(byte[] bytes, int offset2, int length, int bcdExtType) {
        StringBuilder ret = new StringBuilder(length * 2);
        PhoneNumberUtils.internalCalledPartyBCDFragmentToString(ret, bytes, offset2, length, bcdExtType);
        return ret.toString();
    }

    private static char bcdToChar(byte b, int bcdExtType) {
        if (b < 10) {
            return (char)(48 + b);
        }
        String extended = null;
        if (1 == bcdExtType) {
            extended = BCD_EF_ADN_EXTENDED;
        } else if (2 == bcdExtType) {
            extended = BCD_CALLED_PARTY_EXTENDED;
        }
        if (extended == null || b - 10 >= extended.length()) {
            return '\u0000';
        }
        return extended.charAt(b - 10);
    }

    private static int charToBCD(char c, int bcdExtType) {
        if ('0' <= c && c <= '9') {
            return c - 48;
        }
        String extended = null;
        if (1 == bcdExtType) {
            extended = BCD_EF_ADN_EXTENDED;
        } else if (2 == bcdExtType) {
            extended = BCD_CALLED_PARTY_EXTENDED;
        }
        if (extended == null || extended.indexOf(c) == -1) {
            throw new RuntimeException("invalid char for BCD " + c);
        }
        return 10 + extended.indexOf(c);
    }

    public static boolean isWellFormedSmsAddress(String address) {
        String networkPortion = PhoneNumberUtils.extractNetworkPortion(address);
        return !networkPortion.equals(PLUS_SIGN_STRING) && !TextUtils.isEmpty(networkPortion) && PhoneNumberUtils.isDialable(networkPortion);
    }

    public static boolean isGlobalPhoneNumber(String phoneNumber) {
        if (TextUtils.isEmpty(phoneNumber)) {
            return false;
        }
        Matcher match = GLOBAL_PHONE_NUMBER_PATTERN.matcher(phoneNumber);
        return match.matches();
    }

    private static boolean isDialable(String address) {
        int count = address.length();
        for (int i = 0; i < count; ++i) {
            if (PhoneNumberUtils.isDialable(address.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean isNonSeparator(String address) {
        int count = address.length();
        for (int i = 0; i < count; ++i) {
            if (PhoneNumberUtils.isNonSeparator(address.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static byte[] networkPortionToCalledPartyBCD(String s) {
        String networkPortion = PhoneNumberUtils.extractNetworkPortion(s);
        return PhoneNumberUtils.numberToCalledPartyBCDHelper(networkPortion, false, 1);
    }

    public static byte[] networkPortionToCalledPartyBCDWithLength(String s) {
        String networkPortion = PhoneNumberUtils.extractNetworkPortion(s);
        return PhoneNumberUtils.numberToCalledPartyBCDHelper(networkPortion, true, 1);
    }

    @Deprecated
    public static byte[] numberToCalledPartyBCD(String number) {
        return PhoneNumberUtils.numberToCalledPartyBCD(number, 1);
    }

    public static byte[] numberToCalledPartyBCD(String number, int bcdExtType) {
        return PhoneNumberUtils.numberToCalledPartyBCDHelper(number, false, bcdExtType);
    }

    private static byte[] numberToCalledPartyBCDHelper(String number, boolean includeLength, int bcdExtType) {
        boolean hasPlus;
        int numberLenReal;
        int numberLenEffective = numberLenReal = number.length();
        boolean bl = hasPlus = number.indexOf(43) != -1;
        if (hasPlus) {
            --numberLenEffective;
        }
        if (numberLenEffective == 0) {
            return null;
        }
        int resultLen = (numberLenEffective + 1) / 2;
        int extraBytes = 1;
        if (includeLength) {
            ++extraBytes;
        }
        byte[] result = new byte[resultLen += extraBytes];
        int digitCount = 0;
        for (int i = 0; i < numberLenReal; ++i) {
            char c = number.charAt(i);
            if (c == '+') continue;
            int shift = digitCount & true ? 4 : 0;
            int n = extraBytes + (digitCount >> 1);
            result[n] = (byte)(result[n] | (byte)((PhoneNumberUtils.charToBCD(c, bcdExtType) & 0xF) << shift));
            ++digitCount;
        }
        if (digitCount & true) {
            int n = extraBytes + (digitCount >> 1);
            result[n] = (byte)(result[n] | 0xF0);
        }
        int offset2 = 0;
        if (includeLength) {
            result[offset2++] = (byte)(resultLen - 1);
        }
        result[offset2] = (byte)(hasPlus ? 145 : 129);
        return result;
    }

    @Deprecated
    public static String formatNumber(String source) {
        SpannableStringBuilder text = new SpannableStringBuilder(source);
        PhoneNumberUtils.formatNumber(text, PhoneNumberUtils.getFormatTypeForLocale(AndroidLocale.getDefault()));
        return text.toString();
    }

    @Deprecated
    @UnsupportedAppUsage
    public static String formatNumber(String source, int defaultFormattingType) {
        SpannableStringBuilder text = new SpannableStringBuilder(source);
        PhoneNumberUtils.formatNumber(text, defaultFormattingType);
        return text.toString();
    }

    @Deprecated
    public static int getFormatTypeForLocale(Locale locale) {
        String country = locale.getCountry();
        return PhoneNumberUtils.getFormatTypeFromCountryCode(country);
    }

    @Deprecated
    public static void formatNumber(Editable text, int defaultFormattingType) {
        int formatType = defaultFormattingType;
        if (text.length() > 2 && text.charAt(0) == '+') {
            formatType = text.charAt(1) == '1' ? 1 : (text.length() >= 3 && text.charAt(1) == '8' && text.charAt(2) == '1' ? 2 : 0);
        }
        switch (formatType) {
            case 1: {
                PhoneNumberUtils.formatNanpNumber(text);
                return;
            }
            case 2: {
                PhoneNumberUtils.formatJapaneseNumber(text);
                return;
            }
            case 0: {
                PhoneNumberUtils.removeDashes(text);
                return;
            }
        }
    }

    @Deprecated
    public static void formatNanpNumber(Editable text) {
        int i;
        int length = text.length();
        if (length > "+1-nnn-nnn-nnnn".length()) {
            return;
        }
        if (length <= 5) {
            return;
        }
        CharSequence saved = text.subSequence(0, length);
        PhoneNumberUtils.removeDashes(text);
        length = text.length();
        int[] dashPositions = new int[3];
        int numDashes = 0;
        int state = 1;
        int numDigits = 0;
        block6: for (i = 0; i < length; ++i) {
            char c = text.charAt(i);
            switch (c) {
                case '1': {
                    if (numDigits == 0 || state == 2) {
                        state = 3;
                        continue block6;
                    }
                }
                case '0': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    if (state == 2) {
                        text.replace(0, length, saved);
                        return;
                    }
                    if (state == 3) {
                        dashPositions[numDashes++] = i;
                    } else if (state != 4 && (numDigits == 3 || numDigits == 6)) {
                        dashPositions[numDashes++] = i;
                    }
                    state = 1;
                    ++numDigits;
                    continue block6;
                }
                case '-': {
                    state = 4;
                    continue block6;
                }
                case '+': {
                    if (i == 0) {
                        state = 2;
                        continue block6;
                    }
                }
                default: {
                    text.replace(0, length, saved);
                    return;
                }
            }
        }
        if (numDigits == 7) {
            --numDashes;
        }
        for (i = 0; i < numDashes; ++i) {
            int pos = dashPositions[i];
            text.replace(pos + i, pos + i, "-");
        }
        for (int len = text.length(); len > 0 && text.charAt(len - 1) == '-'; --len) {
            text.delete(len - 1, len);
        }
    }

    @Deprecated
    public static void formatJapaneseNumber(Editable text) {
        JapanesePhoneNumberFormatter.format(text);
    }

    private static void removeDashes(Editable text) {
        int p = 0;
        while (p < text.length()) {
            if (text.charAt(p) == '-') {
                text.delete(p, p + 1);
                continue;
            }
            ++p;
        }
    }

    public static String formatNumberToE164(String phoneNumber, String defaultCountryIso) {
        return PhoneNumberUtils.formatNumberInternal(phoneNumber, defaultCountryIso, PhoneNumberUtil.PhoneNumberFormat.E164);
    }

    public static String formatNumberToRFC3966(String phoneNumber, String defaultCountryIso) {
        return PhoneNumberUtils.formatNumberInternal(phoneNumber, defaultCountryIso, PhoneNumberUtil.PhoneNumberFormat.RFC3966);
    }

    private static String formatNumberInternal(String rawPhoneNumber, String defaultCountryIso, PhoneNumberUtil.PhoneNumberFormat formatIdentifier) {
        PhoneNumberUtil util = PhoneNumberUtil.getInstance();
        try {
            Phonenumber.PhoneNumber phoneNumber = util.parse(rawPhoneNumber, defaultCountryIso);
            if (util.isValidNumber(phoneNumber)) {
                return util.format(phoneNumber, formatIdentifier);
            }
        }
        catch (NumberParseException numberParseException) {
            // empty catch block
        }
        return null;
    }

    public static boolean isInternationalNumber(String phoneNumber, String defaultCountryIso) {
        if (TextUtils.isEmpty(phoneNumber)) {
            return false;
        }
        if (phoneNumber.startsWith("#") || phoneNumber.startsWith("*")) {
            return false;
        }
        PhoneNumberUtil util = PhoneNumberUtil.getInstance();
        try {
            Phonenumber.PhoneNumber pn = util.parseAndKeepRawInput(phoneNumber, defaultCountryIso);
            return pn.getCountryCode() != util.getCountryCodeForRegion(defaultCountryIso);
        }
        catch (NumberParseException e) {
            return false;
        }
    }

    public static String formatNumber(String phoneNumber, String defaultCountryIso) {
        if (phoneNumber.startsWith("#") || phoneNumber.startsWith("*")) {
            return phoneNumber;
        }
        PhoneNumberUtil util = PhoneNumberUtil.getInstance();
        String result = null;
        try {
            Phonenumber.PhoneNumber pn = util.parseAndKeepRawInput(phoneNumber, defaultCountryIso);
            result = KOREA_ISO_COUNTRY_CODE.equalsIgnoreCase(defaultCountryIso) && pn.getCountryCode() == util.getCountryCodeForRegion(KOREA_ISO_COUNTRY_CODE) && pn.getCountryCodeSource() == Phonenumber.PhoneNumber.CountryCodeSource.FROM_NUMBER_WITH_PLUS_SIGN ? util.format(pn, PhoneNumberUtil.PhoneNumberFormat.NATIONAL) : (JAPAN_ISO_COUNTRY_CODE.equalsIgnoreCase(defaultCountryIso) && pn.getCountryCode() == util.getCountryCodeForRegion(JAPAN_ISO_COUNTRY_CODE) && pn.getCountryCodeSource() == Phonenumber.PhoneNumber.CountryCodeSource.FROM_NUMBER_WITH_PLUS_SIGN ? util.format(pn, PhoneNumberUtil.PhoneNumberFormat.NATIONAL) : util.formatInOriginalFormat(pn, defaultCountryIso));
        }
        catch (NumberParseException numberParseException) {
            // empty catch block
        }
        return result;
    }

    public static String formatNumber(String phoneNumber, String phoneNumberE164, String defaultCountryIso) {
        String result;
        int len = phoneNumber.length();
        for (int i = 0; i < len; ++i) {
            if (PhoneNumberUtils.isDialable(phoneNumber.charAt(i))) continue;
            return phoneNumber;
        }
        PhoneNumberUtil util = PhoneNumberUtil.getInstance();
        if (phoneNumberE164 != null && phoneNumberE164.length() >= 2 && phoneNumberE164.charAt(0) == '+') {
            try {
                Phonenumber.PhoneNumber pn = util.parse(phoneNumberE164, "ZZ");
                String regionCode = util.getRegionCodeForNumber(pn);
                if (!TextUtils.isEmpty(regionCode) && PhoneNumberUtils.normalizeNumber(phoneNumber).indexOf(phoneNumberE164.substring(1)) <= 0) {
                    defaultCountryIso = regionCode;
                }
            }
            catch (NumberParseException pn) {
                // empty catch block
            }
        }
        return (result = PhoneNumberUtils.formatNumber(phoneNumber, defaultCountryIso)) != null ? result : phoneNumber;
    }

    public static String normalizeNumber(String phoneNumber) {
        if (TextUtils.isEmpty(phoneNumber)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        int len = phoneNumber.length();
        for (int i = 0; i < len; ++i) {
            char c = phoneNumber.charAt(i);
            int digit = Character.digit(c, 10);
            if (digit != -1) {
                sb.append(digit);
                continue;
            }
            if (sb.length() == 0 && c == '+') {
                sb.append(c);
                continue;
            }
            if ((c < 'a' || c > 'z') && (c < 'A' || c > 'Z')) continue;
            return PhoneNumberUtils.normalizeNumber(PhoneNumberUtils.convertKeypadLettersToDigits(phoneNumber));
        }
        return sb.toString();
    }

    public static String replaceUnicodeDigits(String number) {
        StringBuilder normalizedDigits = new StringBuilder(number.length());
        for (char c : number.toCharArray()) {
            int digit = Character.digit(c, 10);
            if (digit != -1) {
                normalizedDigits.append(digit);
                continue;
            }
            normalizedDigits.append(c);
        }
        return normalizedDigits.toString();
    }

    @Deprecated
    public static boolean isEmergencyNumber(String number) {
        return PhoneNumberUtils.isEmergencyNumber(PhoneNumberUtils.getDefaultVoiceSubId(), number);
    }

    @Deprecated
    @UnsupportedAppUsage
    public static boolean isEmergencyNumber(int subId, String number) {
        return PhoneNumberUtils.isEmergencyNumberInternal(subId, number, true);
    }

    @Deprecated
    public static boolean isPotentialEmergencyNumber(String number) {
        return PhoneNumberUtils.isPotentialEmergencyNumber(PhoneNumberUtils.getDefaultVoiceSubId(), number);
    }

    @Deprecated
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public static boolean isPotentialEmergencyNumber(int subId, String number) {
        return PhoneNumberUtils.isEmergencyNumberInternal(subId, number, false);
    }

    private static boolean isEmergencyNumberInternal(String number, boolean useExactMatch) {
        return PhoneNumberUtils.isEmergencyNumberInternal(PhoneNumberUtils.getDefaultVoiceSubId(), number, useExactMatch);
    }

    private static boolean isEmergencyNumberInternal(int subId, String number, boolean useExactMatch) {
        return PhoneNumberUtils.isEmergencyNumberInternal(subId, number, null, useExactMatch);
    }

    @Deprecated
    @UnsupportedAppUsage
    public static boolean isEmergencyNumber(String number, String defaultCountryIso) {
        return PhoneNumberUtils.isEmergencyNumber(PhoneNumberUtils.getDefaultVoiceSubId(), number, defaultCountryIso);
    }

    @Deprecated
    public static boolean isEmergencyNumber(int subId, String number, String defaultCountryIso) {
        return PhoneNumberUtils.isEmergencyNumberInternal(subId, number, defaultCountryIso, true);
    }

    @Deprecated
    public static boolean isPotentialEmergencyNumber(String number, String defaultCountryIso) {
        return PhoneNumberUtils.isPotentialEmergencyNumber(PhoneNumberUtils.getDefaultVoiceSubId(), number, defaultCountryIso);
    }

    @Deprecated
    public static boolean isPotentialEmergencyNumber(int subId, String number, String defaultCountryIso) {
        return PhoneNumberUtils.isEmergencyNumberInternal(subId, number, defaultCountryIso, false);
    }

    private static boolean isEmergencyNumberInternal(String number, String defaultCountryIso, boolean useExactMatch) {
        return PhoneNumberUtils.isEmergencyNumberInternal(PhoneNumberUtils.getDefaultVoiceSubId(), number, defaultCountryIso, useExactMatch);
    }

    private static boolean isEmergencyNumberInternal(int subId, String number, String defaultCountryIso, boolean useExactMatch) {
        try {
            if (useExactMatch) {
                return TelephonyManager.getDefault().isEmergencyNumber(number);
            }
            return TelephonyManager.getDefault().isPotentialEmergencyNumber(number);
        }
        catch (RuntimeException ex) {
            Rlog.e(LOG_TAG, "isEmergencyNumberInternal: RuntimeException: " + ex);
            return false;
        }
    }

    @Deprecated
    public static boolean isLocalEmergencyNumber(Context context, String number) {
        return PhoneNumberUtils.isLocalEmergencyNumber(context, PhoneNumberUtils.getDefaultVoiceSubId(), number);
    }

    @Deprecated
    @UnsupportedAppUsage
    public static boolean isLocalEmergencyNumber(Context context, int subId, String number) {
        return PhoneNumberUtils.isLocalEmergencyNumberInternal(subId, number, context, true);
    }

    @Deprecated
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public static boolean isPotentialLocalEmergencyNumber(Context context, String number) {
        return PhoneNumberUtils.isPotentialLocalEmergencyNumber(context, PhoneNumberUtils.getDefaultVoiceSubId(), number);
    }

    @Deprecated
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public static boolean isPotentialLocalEmergencyNumber(Context context, int subId, String number) {
        return PhoneNumberUtils.isLocalEmergencyNumberInternal(subId, number, context, false);
    }

    private static boolean isLocalEmergencyNumberInternal(String number, Context context, boolean useExactMatch) {
        return PhoneNumberUtils.isLocalEmergencyNumberInternal(PhoneNumberUtils.getDefaultVoiceSubId(), number, context, useExactMatch);
    }

    private static boolean isLocalEmergencyNumberInternal(int subId, String number, Context context, boolean useExactMatch) {
        return PhoneNumberUtils.isEmergencyNumberInternal(subId, number, null, useExactMatch);
    }

    public static boolean isVoiceMailNumber(String number) {
        return PhoneNumberUtils.isVoiceMailNumber(SubscriptionManager.getDefaultSubscriptionId(), number);
    }

    public static boolean isVoiceMailNumber(int subId, String number) {
        return PhoneNumberUtils.isVoiceMailNumber(null, subId, number);
    }

    @SystemApi
    public static boolean isVoiceMailNumber(Context context, int subId, String number) {
        PersistableBundle b;
        CarrierConfigManager configManager;
        String mdn;
        String vmNumber;
        try {
            TelephonyManager tm = context == null ? TelephonyManager.getDefault() : TelephonyManager.from(context);
            vmNumber = tm.getVoiceMailNumber(subId);
            mdn = tm.getLine1Number(subId);
        }
        catch (SecurityException ex) {
            return false;
        }
        number = PhoneNumberUtils.extractNetworkPortionAlt(number);
        if (TextUtils.isEmpty(number)) {
            return false;
        }
        boolean compareWithMdn = false;
        if (context != null && (configManager = (CarrierConfigManager)context.getSystemService("carrier_config")) != null && (b = configManager.getConfigForSubId(subId)) != null) {
            compareWithMdn = b.getBoolean("mdn_is_additional_voicemail_number_bool");
        }
        if (compareWithMdn) {
            return PhoneNumberUtils.compare(number, vmNumber) || PhoneNumberUtils.compare(number, mdn);
        }
        return PhoneNumberUtils.compare(number, vmNumber);
    }

    public static String convertKeypadLettersToDigits(String input) {
        if (input == null) {
            return input;
        }
        int len = input.length();
        if (len == 0) {
            return input;
        }
        char[] out = input.toCharArray();
        for (int i = 0; i < len; ++i) {
            char c = out[i];
            out[i] = (char)KEYPAD_MAP.get(c, c);
        }
        return new String(out);
    }

    @UnsupportedAppUsage
    public static String cdmaCheckAndProcessPlusCode(String dialStr) {
        if (!TextUtils.isEmpty(dialStr) && PhoneNumberUtils.isReallyDialable(dialStr.charAt(0)) && PhoneNumberUtils.isNonSeparator(dialStr)) {
            String currIso = TelephonyManager.getDefault().getNetworkCountryIso();
            String defaultIso = TelephonyManager.getDefault().getSimCountryIso();
            if (!TextUtils.isEmpty(currIso) && !TextUtils.isEmpty(defaultIso)) {
                return PhoneNumberUtils.cdmaCheckAndProcessPlusCodeByNumberFormat(dialStr, PhoneNumberUtils.getFormatTypeFromCountryCode(currIso), PhoneNumberUtils.getFormatTypeFromCountryCode(defaultIso));
            }
        }
        return dialStr;
    }

    public static String cdmaCheckAndProcessPlusCodeForSms(String dialStr) {
        String defaultIso;
        if (!TextUtils.isEmpty(dialStr) && PhoneNumberUtils.isReallyDialable(dialStr.charAt(0)) && PhoneNumberUtils.isNonSeparator(dialStr) && !TextUtils.isEmpty(defaultIso = TelephonyManager.getDefault().getSimCountryIso())) {
            int format = PhoneNumberUtils.getFormatTypeFromCountryCode(defaultIso);
            return PhoneNumberUtils.cdmaCheckAndProcessPlusCodeByNumberFormat(dialStr, format, format);
        }
        return dialStr;
    }

    public static String cdmaCheckAndProcessPlusCodeByNumberFormat(String dialStr, int currFormat, int defaultFormat) {
        boolean useNanp;
        String retStr = dialStr;
        boolean bl = useNanp = currFormat == defaultFormat && currFormat == 1;
        if (dialStr != null && dialStr.lastIndexOf(PLUS_SIGN_STRING) != -1) {
            String postDialStr = null;
            String tempDialStr = dialStr;
            retStr = null;
            do {
                String networkDialStr = useNanp ? PhoneNumberUtils.extractNetworkPortion(tempDialStr) : PhoneNumberUtils.extractNetworkPortionAlt(tempDialStr);
                if (!TextUtils.isEmpty(networkDialStr = PhoneNumberUtils.processPlusCode(networkDialStr, useNanp))) {
                    retStr = retStr == null ? networkDialStr : retStr.concat(networkDialStr);
                } else {
                    Rlog.e("checkAndProcessPlusCode: null newDialStr", networkDialStr);
                    return dialStr;
                }
                postDialStr = PhoneNumberUtils.extractPostDialPortion(tempDialStr);
                if (TextUtils.isEmpty(postDialStr)) continue;
                int dialableIndex = PhoneNumberUtils.findDialableIndexFromPostDialStr(postDialStr);
                if (dialableIndex >= 1) {
                    retStr = PhoneNumberUtils.appendPwCharBackToOrigDialStr(dialableIndex, retStr, postDialStr);
                    tempDialStr = postDialStr.substring(dialableIndex);
                    continue;
                }
                if (dialableIndex < 0) {
                    postDialStr = "";
                }
                Rlog.e("wrong postDialStr=", postDialStr);
            } while (!TextUtils.isEmpty(postDialStr) && !TextUtils.isEmpty(tempDialStr));
        }
        return retStr;
    }

    public static CharSequence createTtsSpannable(CharSequence phoneNumber) {
        if (phoneNumber == null) {
            return null;
        }
        Spannable spannable = Spannable.Factory.getInstance().newSpannable(phoneNumber);
        PhoneNumberUtils.addTtsSpan(spannable, 0, spannable.length());
        return spannable;
    }

    public static void addTtsSpan(Spannable s, int start, int endExclusive) {
        s.setSpan(PhoneNumberUtils.createTtsSpan(s.subSequence(start, endExclusive).toString()), start, endExclusive, 33);
    }

    @Deprecated
    @UnsupportedAppUsage
    public static CharSequence ttsSpanAsPhoneNumber(CharSequence phoneNumber) {
        return PhoneNumberUtils.createTtsSpannable(phoneNumber);
    }

    @Deprecated
    public static void ttsSpanAsPhoneNumber(Spannable s, int start, int end) {
        PhoneNumberUtils.addTtsSpan(s, start, end);
    }

    public static TtsSpan createTtsSpan(String phoneNumberString) {
        if (phoneNumberString == null) {
            return null;
        }
        PhoneNumberUtil phoneNumberUtil = PhoneNumberUtil.getInstance();
        Phonenumber.PhoneNumber phoneNumber = null;
        try {
            phoneNumber = phoneNumberUtil.parse(phoneNumberString, null);
        }
        catch (NumberParseException numberParseException) {
            // empty catch block
        }
        TtsSpan.TelephoneBuilder builder2 = new TtsSpan.TelephoneBuilder();
        if (phoneNumber == null) {
            builder2.setNumberParts(PhoneNumberUtils.splitAtNonNumerics(phoneNumberString));
        } else {
            if (phoneNumber.hasCountryCode()) {
                builder2.setCountryCode(Integer.toString(phoneNumber.getCountryCode()));
            }
            builder2.setNumberParts(Long.toString(phoneNumber.getNationalNumber()));
        }
        return builder2.build();
    }

    private static String splitAtNonNumerics(CharSequence number) {
        StringBuilder sb = new StringBuilder(number.length());
        for (int i = 0; i < number.length(); ++i) {
            sb.append(PhoneNumberUtils.is12Key(number.charAt(i)) ? Character.valueOf(number.charAt(i)) : " ");
        }
        return sb.toString().replaceAll(" +", " ").trim();
    }

    private static String getCurrentIdp(boolean useNanp) {
        String ps = null;
        ps = useNanp ? NANP_IDP_STRING : TelephonyProperties.operator_idp_string().orElse(PLUS_SIGN_STRING);
        return ps;
    }

    private static boolean isTwoToNine(char c) {
        return c >= '2' && c <= '9';
    }

    private static int getFormatTypeFromCountryCode(String country) {
        int length = NANP_COUNTRIES.length;
        for (int i = 0; i < length; ++i) {
            if (NANP_COUNTRIES[i].compareToIgnoreCase(country) != 0) continue;
            return 1;
        }
        if ("jp".compareToIgnoreCase(country) == 0) {
            return 2;
        }
        return 0;
    }

    @UnsupportedAppUsage
    public static boolean isNanp(String dialStr) {
        boolean retVal = false;
        if (dialStr != null) {
            if (dialStr.length() == 10 && PhoneNumberUtils.isTwoToNine(dialStr.charAt(0)) && PhoneNumberUtils.isTwoToNine(dialStr.charAt(3))) {
                retVal = true;
                for (int i = 1; i < 10; ++i) {
                    char c = dialStr.charAt(i);
                    if (PhoneNumberUtils.isISODigit(c)) continue;
                    retVal = false;
                    break;
                }
            }
        } else {
            Rlog.e("isNanp: null dialStr passed in", dialStr);
        }
        return retVal;
    }

    private static boolean isOneNanp(String dialStr) {
        boolean retVal = false;
        if (dialStr != null) {
            String newDialStr = dialStr.substring(1);
            if (dialStr.charAt(0) == '1' && PhoneNumberUtils.isNanp(newDialStr)) {
                retVal = true;
            }
        } else {
            Rlog.e("isOneNanp: null dialStr passed in", dialStr);
        }
        return retVal;
    }

    @SystemApi
    public static boolean isUriNumber(String number) {
        return number != null && (number.contains("@") || number.contains("%40"));
    }

    @SystemApi
    public static String getUsernameFromUriNumber(String number) {
        int delimiterIndex = number.indexOf(64);
        if (delimiterIndex < 0) {
            delimiterIndex = number.indexOf("%40");
        }
        if (delimiterIndex < 0) {
            Rlog.w(LOG_TAG, "getUsernameFromUriNumber: no delimiter found in SIP addr '" + number + "'");
            delimiterIndex = number.length();
        }
        return number.substring(0, delimiterIndex);
    }

    public static Uri convertSipUriToTelUri(Uri source) {
        String scheme = source.getScheme();
        if (!"sip".equals(scheme)) {
            return source;
        }
        String number = source.getSchemeSpecificPart();
        String[] numberParts = number.split("[@;:]");
        if (numberParts.length == 0) {
            return source;
        }
        number = numberParts[0];
        return Uri.fromParts("tel", number, null);
    }

    private static String processPlusCode(String networkDialStr, boolean useNanp) {
        String retStr = networkDialStr;
        if (networkDialStr != null && networkDialStr.charAt(0) == '+' && networkDialStr.length() > 1) {
            String newStr = networkDialStr.substring(1);
            retStr = useNanp && PhoneNumberUtils.isOneNanp(newStr) ? newStr : networkDialStr.replaceFirst("[+]", PhoneNumberUtils.getCurrentIdp(useNanp));
        }
        return retStr;
    }

    private static int findDialableIndexFromPostDialStr(String postDialStr) {
        for (int index = 0; index < postDialStr.length(); ++index) {
            char c = postDialStr.charAt(index);
            if (!PhoneNumberUtils.isReallyDialable(c)) continue;
            return index;
        }
        return -1;
    }

    private static String appendPwCharBackToOrigDialStr(int dialableIndex, String origStr, String dialStr) {
        String retStr;
        if (dialableIndex == 1) {
            StringBuilder ret = new StringBuilder(origStr);
            ret = ret.append(dialStr.charAt(0));
            retStr = ret.toString();
        } else {
            String nonDigitStr = dialStr.substring(0, dialableIndex);
            retStr = origStr.concat(nonDigitStr);
        }
        return retStr;
    }

    private static boolean matchIntlPrefix(String a, int len) {
        int state = 0;
        block5: for (int i = 0; i < len; ++i) {
            char c = a.charAt(i);
            switch (state) {
                case 0: {
                    if (c == '+') {
                        state = 1;
                        continue block5;
                    }
                    if (c == '0') {
                        state = 2;
                        continue block5;
                    }
                    if (!PhoneNumberUtils.isNonSeparator(c)) continue block5;
                    return false;
                }
                case 2: {
                    if (c == '0') {
                        state = 3;
                        continue block5;
                    }
                    if (c == '1') {
                        state = 4;
                        continue block5;
                    }
                    if (!PhoneNumberUtils.isNonSeparator(c)) continue block5;
                    return false;
                }
                case 4: {
                    if (c == '1') {
                        state = 5;
                        continue block5;
                    }
                    if (!PhoneNumberUtils.isNonSeparator(c)) continue block5;
                    return false;
                }
                default: {
                    if (!PhoneNumberUtils.isNonSeparator(c)) continue block5;
                    return false;
                }
            }
        }
        return state == 1 || state == 3 || state == 5;
    }

    private static boolean matchIntlPrefixAndCC(String a, int len) {
        int state = 0;
        block7: for (int i = 0; i < len; ++i) {
            char c = a.charAt(i);
            switch (state) {
                case 0: {
                    if (c == '+') {
                        state = 1;
                        continue block7;
                    }
                    if (c == '0') {
                        state = 2;
                        continue block7;
                    }
                    if (!PhoneNumberUtils.isNonSeparator(c)) continue block7;
                    return false;
                }
                case 2: {
                    if (c == '0') {
                        state = 3;
                        continue block7;
                    }
                    if (c == '1') {
                        state = 4;
                        continue block7;
                    }
                    if (!PhoneNumberUtils.isNonSeparator(c)) continue block7;
                    return false;
                }
                case 4: {
                    if (c == '1') {
                        state = 5;
                        continue block7;
                    }
                    if (!PhoneNumberUtils.isNonSeparator(c)) continue block7;
                    return false;
                }
                case 1: 
                case 3: 
                case 5: {
                    if (PhoneNumberUtils.isISODigit(c)) {
                        state = 6;
                        continue block7;
                    }
                    if (!PhoneNumberUtils.isNonSeparator(c)) continue block7;
                    return false;
                }
                case 6: 
                case 7: {
                    if (PhoneNumberUtils.isISODigit(c)) {
                        ++state;
                        continue block7;
                    }
                    if (!PhoneNumberUtils.isNonSeparator(c)) continue block7;
                    return false;
                }
                default: {
                    if (!PhoneNumberUtils.isNonSeparator(c)) continue block7;
                    return false;
                }
            }
        }
        return state == 6 || state == 7 || state == 8;
    }

    private static boolean matchTrunkPrefix(String a, int len) {
        boolean found = false;
        for (int i = 0; i < len; ++i) {
            char c = a.charAt(i);
            if (c == '0' && !found) {
                found = true;
                continue;
            }
            if (!PhoneNumberUtils.isNonSeparator(c)) continue;
            return false;
        }
        return found;
    }

    private static boolean isCountryCallingCode(int countryCallingCodeCandidate) {
        return countryCallingCodeCandidate > 0 && countryCallingCodeCandidate < CCC_LENGTH && COUNTRY_CALLING_CALL[countryCallingCodeCandidate];
    }

    private static int tryGetISODigit(char ch) {
        if ('0' <= ch && ch <= '9') {
            return ch - 48;
        }
        return -1;
    }

    private static CountryCallingCodeAndNewIndex tryGetCountryCallingCodeAndNewIndex(String str, boolean acceptThailandCase) {
        int state = 0;
        int ccc = 0;
        int length = str.length();
        block8: for (int i = 0; i < length; ++i) {
            char ch = str.charAt(i);
            switch (state) {
                case 0: {
                    if (ch == '+') {
                        state = 1;
                        continue block8;
                    }
                    if (ch == '0') {
                        state = 2;
                        continue block8;
                    }
                    if (ch == '1') {
                        if (acceptThailandCase) {
                            state = 8;
                            continue block8;
                        }
                        return null;
                    }
                    if (!PhoneNumberUtils.isDialable(ch)) continue block8;
                    return null;
                }
                case 2: {
                    if (ch == '0') {
                        state = 3;
                        continue block8;
                    }
                    if (ch == '1') {
                        state = 4;
                        continue block8;
                    }
                    if (!PhoneNumberUtils.isDialable(ch)) continue block8;
                    return null;
                }
                case 4: {
                    if (ch == '1') {
                        state = 5;
                        continue block8;
                    }
                    if (!PhoneNumberUtils.isDialable(ch)) continue block8;
                    return null;
                }
                case 1: 
                case 3: 
                case 5: 
                case 6: 
                case 7: {
                    int ret = PhoneNumberUtils.tryGetISODigit(ch);
                    if (ret > 0) {
                        if ((ccc = ccc * 10 + ret) >= 100 || PhoneNumberUtils.isCountryCallingCode(ccc)) {
                            return new CountryCallingCodeAndNewIndex(ccc, i + 1);
                        }
                        if (state == 1 || state == 3 || state == 5) {
                            state = 6;
                            continue block8;
                        }
                        ++state;
                        continue block8;
                    }
                    if (!PhoneNumberUtils.isDialable(ch)) continue block8;
                    return null;
                }
                case 8: {
                    if (ch == '6') {
                        state = 9;
                        continue block8;
                    }
                    if (!PhoneNumberUtils.isDialable(ch)) continue block8;
                    return null;
                }
                case 9: {
                    if (ch == '6') {
                        return new CountryCallingCodeAndNewIndex(66, i + 1);
                    }
                    return null;
                }
                default: {
                    return null;
                }
            }
        }
        return null;
    }

    private static int tryGetTrunkPrefixOmittedIndex(String str, int currentIndex) {
        int length = str.length();
        for (int i = currentIndex; i < length; ++i) {
            char ch = str.charAt(i);
            if (PhoneNumberUtils.tryGetISODigit(ch) >= 0) {
                return i + 1;
            }
            if (!PhoneNumberUtils.isDialable(ch)) continue;
            return -1;
        }
        return -1;
    }

    private static boolean checkPrefixIsIgnorable(String str, int forwardIndex, int backwardIndex) {
        boolean trunk_prefix_was_read = false;
        while (backwardIndex >= forwardIndex) {
            if (PhoneNumberUtils.tryGetISODigit(str.charAt(backwardIndex)) >= 0) {
                if (trunk_prefix_was_read) {
                    return false;
                }
                trunk_prefix_was_read = true;
            } else if (PhoneNumberUtils.isDialable(str.charAt(backwardIndex))) {
                return false;
            }
            --backwardIndex;
        }
        return true;
    }

    private static int getDefaultVoiceSubId() {
        return SubscriptionManager.getDefaultVoiceSubscriptionId();
    }

    public static String convertToEmergencyNumber(Context context, String number) {
        if (context == null || TextUtils.isEmpty(number)) {
            return number;
        }
        String normalizedNumber = PhoneNumberUtils.normalizeNumber(number);
        if (PhoneNumberUtils.isEmergencyNumber(normalizedNumber)) {
            return number;
        }
        if (sConvertToEmergencyMap == null) {
            sConvertToEmergencyMap = context.getResources().getStringArray(17236008);
        }
        if (sConvertToEmergencyMap == null || sConvertToEmergencyMap.length == 0) {
            return number;
        }
        for (String convertMap : sConvertToEmergencyMap) {
            String[] entry = null;
            String[] filterNumbers = null;
            String convertedNumber = null;
            if (!TextUtils.isEmpty(convertMap)) {
                entry = convertMap.split(":");
            }
            if (entry != null && entry.length == 2) {
                convertedNumber = entry[1];
                if (!TextUtils.isEmpty(entry[0])) {
                    filterNumbers = entry[0].split(",");
                }
            }
            if (TextUtils.isEmpty(convertedNumber) || filterNumbers == null || filterNumbers.length == 0) continue;
            for (String filterNumber : filterNumbers) {
                if (TextUtils.isEmpty(filterNumber) || !filterNumber.equals(normalizedNumber)) continue;
                return convertedNumber;
            }
        }
        return number;
    }

    public static boolean areSamePhoneNumber(String number1, String number2, String defaultCountryIso) {
        Phonenumber.PhoneNumber n2;
        Phonenumber.PhoneNumber n1;
        PhoneNumberUtil util = PhoneNumberUtil.getInstance();
        defaultCountryIso = defaultCountryIso.toUpperCase();
        try {
            n1 = util.parseAndKeepRawInput(number1, defaultCountryIso);
            n2 = util.parseAndKeepRawInput(number2, defaultCountryIso);
        }
        catch (NumberParseException e) {
            return false;
        }
        PhoneNumberUtil.MatchType matchType = util.isNumberMatch(n1, n2);
        if (matchType == PhoneNumberUtil.MatchType.EXACT_MATCH || matchType == PhoneNumberUtil.MatchType.NSN_MATCH) {
            return true;
        }
        if (matchType == PhoneNumberUtil.MatchType.SHORT_NSN_MATCH) {
            return n1.getNationalNumber() == n2.getNationalNumber() && n1.getCountryCode() == n2.getCountryCode();
        }
        return false;
    }

    static {
        KEYPAD_MAP.put(97, 50);
        KEYPAD_MAP.put(98, 50);
        KEYPAD_MAP.put(99, 50);
        KEYPAD_MAP.put(65, 50);
        KEYPAD_MAP.put(66, 50);
        KEYPAD_MAP.put(67, 50);
        KEYPAD_MAP.put(100, 51);
        KEYPAD_MAP.put(101, 51);
        KEYPAD_MAP.put(102, 51);
        KEYPAD_MAP.put(68, 51);
        KEYPAD_MAP.put(69, 51);
        KEYPAD_MAP.put(70, 51);
        KEYPAD_MAP.put(103, 52);
        KEYPAD_MAP.put(104, 52);
        KEYPAD_MAP.put(105, 52);
        KEYPAD_MAP.put(71, 52);
        KEYPAD_MAP.put(72, 52);
        KEYPAD_MAP.put(73, 52);
        KEYPAD_MAP.put(106, 53);
        KEYPAD_MAP.put(107, 53);
        KEYPAD_MAP.put(108, 53);
        KEYPAD_MAP.put(74, 53);
        KEYPAD_MAP.put(75, 53);
        KEYPAD_MAP.put(76, 53);
        KEYPAD_MAP.put(109, 54);
        KEYPAD_MAP.put(110, 54);
        KEYPAD_MAP.put(111, 54);
        KEYPAD_MAP.put(77, 54);
        KEYPAD_MAP.put(78, 54);
        KEYPAD_MAP.put(79, 54);
        KEYPAD_MAP.put(112, 55);
        KEYPAD_MAP.put(113, 55);
        KEYPAD_MAP.put(114, 55);
        KEYPAD_MAP.put(115, 55);
        KEYPAD_MAP.put(80, 55);
        KEYPAD_MAP.put(81, 55);
        KEYPAD_MAP.put(82, 55);
        KEYPAD_MAP.put(83, 55);
        KEYPAD_MAP.put(116, 56);
        KEYPAD_MAP.put(117, 56);
        KEYPAD_MAP.put(118, 56);
        KEYPAD_MAP.put(84, 56);
        KEYPAD_MAP.put(85, 56);
        KEYPAD_MAP.put(86, 56);
        KEYPAD_MAP.put(119, 57);
        KEYPAD_MAP.put(120, 57);
        KEYPAD_MAP.put(121, 57);
        KEYPAD_MAP.put(122, 57);
        KEYPAD_MAP.put(87, 57);
        KEYPAD_MAP.put(88, 57);
        KEYPAD_MAP.put(89, 57);
        KEYPAD_MAP.put(90, 57);
        COUNTRY_CALLING_CALL = new boolean[]{true, true, false, false, false, false, false, true, false, false, false, false, false, false, false, false, false, false, false, false, true, false, false, false, false, false, false, true, true, false, true, true, true, true, true, false, true, false, false, true, true, false, false, true, true, true, true, true, true, true, false, true, true, true, true, true, true, true, true, false, true, true, true, true, true, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, true, true, false, true, false, false, true, true, true, true, true, true, true, false, false, true, false};
        CCC_LENGTH = COUNTRY_CALLING_CALL.length;
        sConvertToEmergencyMap = null;
    }

    private static class CountryCallingCodeAndNewIndex {
        public final int countryCallingCode;
        public final int newIndex;

        public CountryCallingCodeAndNewIndex(int countryCode, int newIndex) {
            this.countryCallingCode = countryCode;
            this.newIndex = newIndex;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface BcdExtendType {
    }
}

