/*
 * Decompiled with CFR 0.152.
 */
package android.telephony;

import android.os.Parcel;
import android.os.Parcelable;
import android.telephony.CellIdentity;
import android.telephony.CellLocation;
import android.telephony.gsm.GsmCellLocation;
import android.text.TextUtils;
import android.util.ArraySet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;

public class CellIdentityNr
extends CellIdentity {
    private static final String TAG = "CellIdentityNr";
    private static final int MAX_PCI = 1007;
    private static final int MAX_TAC = 0xFFFFFF;
    private static final int MAX_NRARFCN = 3279165;
    private static final long MAX_NCI = 0xFFFFFFFFFL;
    private final int mNrArfcn;
    private final int mPci;
    private final int mTac;
    private final long mNci;
    private final int[] mBands;
    private final ArraySet<String> mAdditionalPlmns;
    public static final Parcelable.Creator<CellIdentityNr> CREATOR = new Parcelable.Creator<CellIdentityNr>(){

        @Override
        public CellIdentityNr createFromParcel(Parcel in) {
            in.readInt();
            return CellIdentityNr.createFromParcelBody(in);
        }

        public CellIdentityNr[] newArray(int size) {
            return new CellIdentityNr[size];
        }
    };

    public CellIdentityNr() {
        super(TAG, 6, null, null, null, null);
        this.mNrArfcn = Integer.MAX_VALUE;
        this.mPci = Integer.MAX_VALUE;
        this.mTac = Integer.MAX_VALUE;
        this.mNci = Integer.MAX_VALUE;
        this.mBands = new int[0];
        this.mAdditionalPlmns = new ArraySet();
        this.mGlobalCellId = null;
    }

    public CellIdentityNr(int pci, int tac, int nrArfcn, int[] bands, String mccStr, String mncStr, long nci, String alphal, String alphas, Collection<String> additionalPlmns) {
        super(TAG, 6, mccStr, mncStr, alphal, alphas);
        this.mPci = CellIdentityNr.inRangeOrUnavailable(pci, 0, 1007);
        this.mTac = CellIdentityNr.inRangeOrUnavailable(tac, 0, 0xFFFFFF);
        this.mNrArfcn = CellIdentityNr.inRangeOrUnavailable(nrArfcn, 0, 3279165);
        this.mBands = bands;
        this.mNci = CellIdentityNr.inRangeOrUnavailable(nci, 0L, 0xFFFFFFFFFL);
        this.mAdditionalPlmns = new ArraySet(additionalPlmns.size());
        for (String plmn : additionalPlmns) {
            if (!CellIdentityNr.isValidPlmn(plmn)) continue;
            this.mAdditionalPlmns.add(plmn);
        }
        this.updateGlobalCellId();
    }

    public CellIdentityNr(android.hardware.radio.V1_4.CellIdentityNr cid) {
        this(cid.pci, cid.tac, cid.nrarfcn, new int[0], cid.mcc, cid.mnc, cid.nci, cid.operatorNames.alphaLong, cid.operatorNames.alphaShort, new ArraySet<String>());
    }

    public CellIdentityNr(android.hardware.radio.V1_5.CellIdentityNr cid) {
        this(cid.base.pci, cid.base.tac, cid.base.nrarfcn, cid.bands.stream().mapToInt(Integer::intValue).toArray(), cid.base.mcc, cid.base.mnc, cid.base.nci, cid.base.operatorNames.alphaLong, cid.base.operatorNames.alphaShort, cid.additionalPlmns);
    }

    @Override
    public CellIdentityNr sanitizeLocationInfo() {
        return new CellIdentityNr(Integer.MAX_VALUE, Integer.MAX_VALUE, this.mNrArfcn, this.mBands, this.mMccStr, this.mMncStr, Long.MAX_VALUE, this.mAlphaLong, this.mAlphaShort, this.mAdditionalPlmns);
    }

    @Override
    protected void updateGlobalCellId() {
        this.mGlobalCellId = null;
        String plmn = this.getPlmn();
        if (plmn == null) {
            return;
        }
        if (this.mNci == Long.MAX_VALUE) {
            return;
        }
        this.mGlobalCellId = plmn + TextUtils.formatSimple("%09x", this.mNci);
    }

    @Override
    public CellLocation asCellLocation() {
        GsmCellLocation cl = new GsmCellLocation();
        int tac = this.mTac != Integer.MAX_VALUE ? this.mTac : -1;
        cl.setLacAndCid(tac, -1);
        cl.setPsc(0);
        return cl;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.mPci, this.mTac, this.mNrArfcn, Arrays.hashCode(this.mBands), this.mNci, this.mAdditionalPlmns.hashCode());
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CellIdentityNr)) {
            return false;
        }
        CellIdentityNr o = (CellIdentityNr)other;
        return super.equals(o) && this.mPci == o.mPci && this.mTac == o.mTac && this.mNrArfcn == o.mNrArfcn && Arrays.equals(this.mBands, o.mBands) && this.mNci == o.mNci && this.mAdditionalPlmns.equals(o.mAdditionalPlmns);
    }

    public long getNci() {
        return this.mNci;
    }

    public int getNrarfcn() {
        return this.mNrArfcn;
    }

    public int[] getBands() {
        return Arrays.copyOf(this.mBands, this.mBands.length);
    }

    public int getPci() {
        return this.mPci;
    }

    public int getTac() {
        return this.mTac;
    }

    @Override
    public String getMccString() {
        return this.mMccStr;
    }

    @Override
    public String getMncString() {
        return this.mMncStr;
    }

    @Override
    public int getChannelNumber() {
        return this.mNrArfcn;
    }

    public Set<String> getAdditionalPlmns() {
        return Collections.unmodifiableSet(this.mAdditionalPlmns);
    }

    public String toString() {
        return "CellIdentityNr:{" + " mPci = " + this.mPci + " mTac = " + this.mTac + " mNrArfcn = " + this.mNrArfcn + " mBands = " + Arrays.toString(this.mBands) + " mMcc = " + this.mMccStr + " mMnc = " + this.mMncStr + " mNci = " + this.mNci + " mAlphaLong = " + this.mAlphaLong + " mAlphaShort = " + this.mAlphaShort + " mAdditionalPlmns = " + this.mAdditionalPlmns + " }";
    }

    @Override
    public void writeToParcel(Parcel dest, int type) {
        super.writeToParcel(dest, 6);
        dest.writeInt(this.mPci);
        dest.writeInt(this.mTac);
        dest.writeInt(this.mNrArfcn);
        dest.writeIntArray(this.mBands);
        dest.writeLong(this.mNci);
        dest.writeArraySet(this.mAdditionalPlmns);
    }

    private CellIdentityNr(Parcel in) {
        super(TAG, 6, in);
        this.mPci = in.readInt();
        this.mTac = in.readInt();
        this.mNrArfcn = in.readInt();
        this.mBands = in.createIntArray();
        this.mNci = in.readLong();
        this.mAdditionalPlmns = in.readArraySet(null);
        this.updateGlobalCellId();
    }

    protected static CellIdentityNr createFromParcelBody(Parcel in) {
        return new CellIdentityNr(in);
    }
}

