/*
 * Decompiled with CFR 0.152.
 */
package android.system.keystore2;

import android.hardware.security.keymint.KeyParameter;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.system.keystore2.AuthenticatorSpec;
import android.system.keystore2.CreateOperationResponse;
import android.system.keystore2.EphemeralStorageKeyResponse;
import android.system.keystore2.KeyDescriptor;
import android.system.keystore2.KeyMetadata;

public interface IKeystoreSecurityLevel
extends IInterface {
    public static final int VERSION = 1;
    public static final String HASH = "19e8b65277839bad0ab335c781e3c652324920ce";
    public static final String DESCRIPTOR = "android$system$keystore2$IKeystoreSecurityLevel".replace('$', '.');
    public static final int KEY_FLAG_AUTH_BOUND_WITHOUT_CRYPTOGRAPHIC_LSKF_BINDING = 1;

    public CreateOperationResponse createOperation(KeyDescriptor var1, KeyParameter[] var2, boolean var3) throws RemoteException;

    public KeyMetadata generateKey(KeyDescriptor var1, KeyDescriptor var2, KeyParameter[] var3, int var4, byte[] var5) throws RemoteException;

    public KeyMetadata importKey(KeyDescriptor var1, KeyDescriptor var2, KeyParameter[] var3, int var4, byte[] var5) throws RemoteException;

    public KeyMetadata importWrappedKey(KeyDescriptor var1, KeyDescriptor var2, byte[] var3, KeyParameter[] var4, AuthenticatorSpec[] var5) throws RemoteException;

    public EphemeralStorageKeyResponse convertStorageKeyToEphemeral(KeyDescriptor var1) throws RemoteException;

    public void deleteKey(KeyDescriptor var1) throws RemoteException;

    public int getInterfaceVersion() throws RemoteException;

    public String getInterfaceHash() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IKeystoreSecurityLevel {
        static final int TRANSACTION_createOperation = 1;
        static final int TRANSACTION_generateKey = 2;
        static final int TRANSACTION_importKey = 3;
        static final int TRANSACTION_importWrappedKey = 4;
        static final int TRANSACTION_convertStorageKeyToEphemeral = 5;
        static final int TRANSACTION_deleteKey = 6;
        static final int TRANSACTION_getInterfaceVersion = 0xFFFFFF;
        static final int TRANSACTION_getInterfaceHash = 0xFFFFFE;

        public Stub() {
            this.markVintfStability();
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IKeystoreSecurityLevel asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IKeystoreSecurityLevel) {
                return (IKeystoreSecurityLevel)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
                case 0xFFFFFF: {
                    data.enforceInterface(descriptor);
                    reply.writeNoException();
                    reply.writeInt(this.getInterfaceVersion());
                    return true;
                }
                case 0xFFFFFE: {
                    data.enforceInterface(descriptor);
                    reply.writeNoException();
                    reply.writeString(this.getInterfaceHash());
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    data.enforceInterface(descriptor);
                    KeyDescriptor _arg0 = 0 != data.readInt() ? KeyDescriptor.CREATOR.createFromParcel(data) : null;
                    KeyParameter[] _arg1 = data.createTypedArray(KeyParameter.CREATOR);
                    boolean _arg2 = 0 != data.readInt();
                    CreateOperationResponse _result = this.createOperation(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 2: {
                    data.enforceInterface(descriptor);
                    KeyDescriptor _arg0 = 0 != data.readInt() ? KeyDescriptor.CREATOR.createFromParcel(data) : null;
                    KeyDescriptor _arg1 = 0 != data.readInt() ? KeyDescriptor.CREATOR.createFromParcel(data) : null;
                    KeyParameter[] _arg2 = data.createTypedArray(KeyParameter.CREATOR);
                    int _arg3 = data.readInt();
                    byte[] _arg4 = data.createByteArray();
                    KeyMetadata _result = this.generateKey(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 3: {
                    data.enforceInterface(descriptor);
                    KeyDescriptor _arg0 = 0 != data.readInt() ? KeyDescriptor.CREATOR.createFromParcel(data) : null;
                    KeyDescriptor _arg1 = 0 != data.readInt() ? KeyDescriptor.CREATOR.createFromParcel(data) : null;
                    KeyParameter[] _arg2 = data.createTypedArray(KeyParameter.CREATOR);
                    int _arg3 = data.readInt();
                    byte[] _arg4 = data.createByteArray();
                    KeyMetadata _result = this.importKey(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 4: {
                    data.enforceInterface(descriptor);
                    KeyDescriptor _arg0 = 0 != data.readInt() ? KeyDescriptor.CREATOR.createFromParcel(data) : null;
                    KeyDescriptor _arg1 = 0 != data.readInt() ? KeyDescriptor.CREATOR.createFromParcel(data) : null;
                    byte[] _arg2 = data.createByteArray();
                    KeyParameter[] _arg3 = data.createTypedArray(KeyParameter.CREATOR);
                    AuthenticatorSpec[] _arg4 = data.createTypedArray(AuthenticatorSpec.CREATOR);
                    KeyMetadata _result = this.importWrappedKey(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 5: {
                    data.enforceInterface(descriptor);
                    KeyDescriptor _arg0 = 0 != data.readInt() ? KeyDescriptor.CREATOR.createFromParcel(data) : null;
                    EphemeralStorageKeyResponse _result = this.convertStorageKeyToEphemeral(_arg0);
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 6: {
                    data.enforceInterface(descriptor);
                    KeyDescriptor _arg0 = 0 != data.readInt() ? KeyDescriptor.CREATOR.createFromParcel(data) : null;
                    this.deleteKey(_arg0);
                    reply.writeNoException();
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        public static boolean setDefaultImpl(IKeystoreSecurityLevel impl) {
            if (Proxy.sDefaultImpl != null) {
                throw new IllegalStateException("setDefaultImpl() called twice");
            }
            if (impl != null) {
                Proxy.sDefaultImpl = impl;
                return true;
            }
            return false;
        }

        public static IKeystoreSecurityLevel getDefaultImpl() {
            return Proxy.sDefaultImpl;
        }

        private static class Proxy
        implements IKeystoreSecurityLevel {
            private IBinder mRemote;
            private int mCachedVersion = -1;
            private String mCachedHash = "-1";
            public static IKeystoreSecurityLevel sDefaultImpl;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public CreateOperationResponse createOperation(KeyDescriptor key, KeyParameter[] operationParameters, boolean forced) throws RemoteException {
                CreateOperationResponse _result;
                Parcel _data = Parcel.obtain();
                _data.markSensitive();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    if (key != null) {
                        _data.writeInt(1);
                        key.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeTypedArray(operationParameters, 0);
                    _data.writeInt(forced ? 1 : 0);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 32);
                    if (!_status) {
                        if (Stub.getDefaultImpl() != null) {
                            CreateOperationResponse createOperationResponse = Stub.getDefaultImpl().createOperation(key, operationParameters, forced);
                            return createOperationResponse;
                        }
                        throw new RemoteException("Method createOperation is unimplemented.");
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? CreateOperationResponse.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public KeyMetadata generateKey(KeyDescriptor key, KeyDescriptor attestationKey, KeyParameter[] params, int flags, byte[] entropy) throws RemoteException {
                KeyMetadata _result;
                Parcel _data = Parcel.obtain();
                _data.markSensitive();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    if (key != null) {
                        _data.writeInt(1);
                        key.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (attestationKey != null) {
                        _data.writeInt(1);
                        attestationKey.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeTypedArray(params, 0);
                    _data.writeInt(flags);
                    _data.writeByteArray(entropy);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 32);
                    if (!_status) {
                        if (Stub.getDefaultImpl() != null) {
                            KeyMetadata keyMetadata = Stub.getDefaultImpl().generateKey(key, attestationKey, params, flags, entropy);
                            return keyMetadata;
                        }
                        throw new RemoteException("Method generateKey is unimplemented.");
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? KeyMetadata.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public KeyMetadata importKey(KeyDescriptor key, KeyDescriptor attestationKey, KeyParameter[] params, int flags, byte[] keyData) throws RemoteException {
                KeyMetadata _result;
                Parcel _data = Parcel.obtain();
                _data.markSensitive();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    if (key != null) {
                        _data.writeInt(1);
                        key.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (attestationKey != null) {
                        _data.writeInt(1);
                        attestationKey.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeTypedArray(params, 0);
                    _data.writeInt(flags);
                    _data.writeByteArray(keyData);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 32);
                    if (!_status) {
                        if (Stub.getDefaultImpl() != null) {
                            KeyMetadata keyMetadata = Stub.getDefaultImpl().importKey(key, attestationKey, params, flags, keyData);
                            return keyMetadata;
                        }
                        throw new RemoteException("Method importKey is unimplemented.");
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? KeyMetadata.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public KeyMetadata importWrappedKey(KeyDescriptor key, KeyDescriptor wrappingKey, byte[] maskingKey, KeyParameter[] params, AuthenticatorSpec[] authenticators) throws RemoteException {
                KeyMetadata _result;
                Parcel _data = Parcel.obtain();
                _data.markSensitive();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    if (key != null) {
                        _data.writeInt(1);
                        key.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (wrappingKey != null) {
                        _data.writeInt(1);
                        wrappingKey.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeByteArray(maskingKey);
                    _data.writeTypedArray(params, 0);
                    _data.writeTypedArray(authenticators, 0);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 32);
                    if (!_status) {
                        if (Stub.getDefaultImpl() != null) {
                            KeyMetadata keyMetadata = Stub.getDefaultImpl().importWrappedKey(key, wrappingKey, maskingKey, params, authenticators);
                            return keyMetadata;
                        }
                        throw new RemoteException("Method importWrappedKey is unimplemented.");
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? KeyMetadata.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public EphemeralStorageKeyResponse convertStorageKeyToEphemeral(KeyDescriptor storageKey) throws RemoteException {
                EphemeralStorageKeyResponse _result;
                Parcel _data = Parcel.obtain();
                _data.markSensitive();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    if (storageKey != null) {
                        _data.writeInt(1);
                        storageKey.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(5, _data, _reply, 32);
                    if (!_status) {
                        if (Stub.getDefaultImpl() != null) {
                            EphemeralStorageKeyResponse ephemeralStorageKeyResponse = Stub.getDefaultImpl().convertStorageKeyToEphemeral(storageKey);
                            return ephemeralStorageKeyResponse;
                        }
                        throw new RemoteException("Method convertStorageKeyToEphemeral is unimplemented.");
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? EphemeralStorageKeyResponse.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void deleteKey(KeyDescriptor key) throws RemoteException {
                Parcel _data = Parcel.obtain();
                _data.markSensitive();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    if (key != null) {
                        _data.writeInt(1);
                        key.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(6, _data, _reply, 32);
                    if (!_status) {
                        if (Stub.getDefaultImpl() != null) {
                            Stub.getDefaultImpl().deleteKey(key);
                            return;
                        }
                        throw new RemoteException("Method deleteKey is unimplemented.");
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getInterfaceVersion() throws RemoteException {
                if (this.mCachedVersion == -1) {
                    Parcel data = Parcel.obtain();
                    Parcel reply = Parcel.obtain();
                    try {
                        data.writeInterfaceToken(DESCRIPTOR);
                        boolean _status = this.mRemote.transact(0xFFFFFF, data, reply, 0);
                        if (!_status && Stub.getDefaultImpl() != null) {
                            int n = Stub.getDefaultImpl().getInterfaceVersion();
                            return n;
                        }
                        reply.readException();
                        this.mCachedVersion = reply.readInt();
                    }
                    finally {
                        reply.recycle();
                        data.recycle();
                    }
                }
                return this.mCachedVersion;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public synchronized String getInterfaceHash() throws RemoteException {
                if ("-1".equals(this.mCachedHash)) {
                    Parcel data = Parcel.obtain();
                    Parcel reply = Parcel.obtain();
                    try {
                        data.writeInterfaceToken(DESCRIPTOR);
                        boolean _status = this.mRemote.transact(0xFFFFFE, data, reply, 0);
                        if (!_status && Stub.getDefaultImpl() != null) {
                            String string2 = Stub.getDefaultImpl().getInterfaceHash();
                            return string2;
                        }
                        reply.readException();
                        this.mCachedHash = reply.readString();
                    }
                    finally {
                        reply.recycle();
                        data.recycle();
                    }
                }
                return this.mCachedHash;
            }
        }
    }

    public static class Default
    implements IKeystoreSecurityLevel {
        @Override
        public CreateOperationResponse createOperation(KeyDescriptor key, KeyParameter[] operationParameters, boolean forced) throws RemoteException {
            return null;
        }

        @Override
        public KeyMetadata generateKey(KeyDescriptor key, KeyDescriptor attestationKey, KeyParameter[] params, int flags, byte[] entropy) throws RemoteException {
            return null;
        }

        @Override
        public KeyMetadata importKey(KeyDescriptor key, KeyDescriptor attestationKey, KeyParameter[] params, int flags, byte[] keyData) throws RemoteException {
            return null;
        }

        @Override
        public KeyMetadata importWrappedKey(KeyDescriptor key, KeyDescriptor wrappingKey, byte[] maskingKey, KeyParameter[] params, AuthenticatorSpec[] authenticators) throws RemoteException {
            return null;
        }

        @Override
        public EphemeralStorageKeyResponse convertStorageKeyToEphemeral(KeyDescriptor storageKey) throws RemoteException {
            return null;
        }

        @Override
        public void deleteKey(KeyDescriptor key) throws RemoteException {
        }

        @Override
        public int getInterfaceVersion() {
            return 0;
        }

        @Override
        public String getInterfaceHash() {
            return "";
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

