/*
 * Decompiled with CFR 0.152.
 */
package android.system.keystore2;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface IKeystoreOperation
extends IInterface {
    public static final int VERSION = 1;
    public static final String HASH = "19e8b65277839bad0ab335c781e3c652324920ce";
    public static final String DESCRIPTOR = "android$system$keystore2$IKeystoreOperation".replace('$', '.');

    public void updateAad(byte[] var1) throws RemoteException;

    public byte[] update(byte[] var1) throws RemoteException;

    public byte[] finish(byte[] var1, byte[] var2) throws RemoteException;

    public void abort() throws RemoteException;

    public int getInterfaceVersion() throws RemoteException;

    public String getInterfaceHash() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IKeystoreOperation {
        static final int TRANSACTION_updateAad = 1;
        static final int TRANSACTION_update = 2;
        static final int TRANSACTION_finish = 3;
        static final int TRANSACTION_abort = 4;
        static final int TRANSACTION_getInterfaceVersion = 0xFFFFFF;
        static final int TRANSACTION_getInterfaceHash = 0xFFFFFE;

        public Stub() {
            this.markVintfStability();
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IKeystoreOperation asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IKeystoreOperation) {
                return (IKeystoreOperation)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
                case 0xFFFFFF: {
                    data.enforceInterface(descriptor);
                    reply.writeNoException();
                    reply.writeInt(this.getInterfaceVersion());
                    return true;
                }
                case 0xFFFFFE: {
                    data.enforceInterface(descriptor);
                    reply.writeNoException();
                    reply.writeString(this.getInterfaceHash());
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    data.enforceInterface(descriptor);
                    byte[] _arg0 = data.createByteArray();
                    this.updateAad(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 2: {
                    data.enforceInterface(descriptor);
                    byte[] _arg0 = data.createByteArray();
                    byte[] _result = this.update(_arg0);
                    reply.writeNoException();
                    reply.writeByteArray(_result);
                    return true;
                }
                case 3: {
                    data.enforceInterface(descriptor);
                    byte[] _arg0 = data.createByteArray();
                    byte[] _arg1 = data.createByteArray();
                    byte[] _result = this.finish(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeByteArray(_result);
                    return true;
                }
                case 4: {
                    data.enforceInterface(descriptor);
                    this.abort();
                    reply.writeNoException();
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        public static boolean setDefaultImpl(IKeystoreOperation impl) {
            if (Proxy.sDefaultImpl != null) {
                throw new IllegalStateException("setDefaultImpl() called twice");
            }
            if (impl != null) {
                Proxy.sDefaultImpl = impl;
                return true;
            }
            return false;
        }

        public static IKeystoreOperation getDefaultImpl() {
            return Proxy.sDefaultImpl;
        }

        private static class Proxy
        implements IKeystoreOperation {
            private IBinder mRemote;
            private int mCachedVersion = -1;
            private String mCachedHash = "-1";
            public static IKeystoreOperation sDefaultImpl;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void updateAad(byte[] aadInput) throws RemoteException {
                Parcel _data = Parcel.obtain();
                _data.markSensitive();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    _data.writeByteArray(aadInput);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 32);
                    if (!_status) {
                        if (Stub.getDefaultImpl() != null) {
                            Stub.getDefaultImpl().updateAad(aadInput);
                            return;
                        }
                        throw new RemoteException("Method updateAad is unimplemented.");
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public byte[] update(byte[] input) throws RemoteException {
                byte[] _result;
                Parcel _data = Parcel.obtain();
                _data.markSensitive();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    _data.writeByteArray(input);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 32);
                    if (!_status) {
                        if (Stub.getDefaultImpl() != null) {
                            byte[] byArray = Stub.getDefaultImpl().update(input);
                            return byArray;
                        }
                        throw new RemoteException("Method update is unimplemented.");
                    }
                    _reply.readException();
                    _result = _reply.createByteArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public byte[] finish(byte[] input, byte[] signature) throws RemoteException {
                byte[] _result;
                Parcel _data = Parcel.obtain();
                _data.markSensitive();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    _data.writeByteArray(input);
                    _data.writeByteArray(signature);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 32);
                    if (!_status) {
                        if (Stub.getDefaultImpl() != null) {
                            byte[] byArray = Stub.getDefaultImpl().finish(input, signature);
                            return byArray;
                        }
                        throw new RemoteException("Method finish is unimplemented.");
                    }
                    _reply.readException();
                    _result = _reply.createByteArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void abort() throws RemoteException {
                Parcel _data = Parcel.obtain();
                _data.markSensitive();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 32);
                    if (!_status) {
                        if (Stub.getDefaultImpl() != null) {
                            Stub.getDefaultImpl().abort();
                            return;
                        }
                        throw new RemoteException("Method abort is unimplemented.");
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getInterfaceVersion() throws RemoteException {
                if (this.mCachedVersion == -1) {
                    Parcel data = Parcel.obtain();
                    Parcel reply = Parcel.obtain();
                    try {
                        data.writeInterfaceToken(DESCRIPTOR);
                        boolean _status = this.mRemote.transact(0xFFFFFF, data, reply, 0);
                        if (!_status && Stub.getDefaultImpl() != null) {
                            int n = Stub.getDefaultImpl().getInterfaceVersion();
                            return n;
                        }
                        reply.readException();
                        this.mCachedVersion = reply.readInt();
                    }
                    finally {
                        reply.recycle();
                        data.recycle();
                    }
                }
                return this.mCachedVersion;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public synchronized String getInterfaceHash() throws RemoteException {
                if ("-1".equals(this.mCachedHash)) {
                    Parcel data = Parcel.obtain();
                    Parcel reply = Parcel.obtain();
                    try {
                        data.writeInterfaceToken(DESCRIPTOR);
                        boolean _status = this.mRemote.transact(0xFFFFFE, data, reply, 0);
                        if (!_status && Stub.getDefaultImpl() != null) {
                            String string2 = Stub.getDefaultImpl().getInterfaceHash();
                            return string2;
                        }
                        reply.readException();
                        this.mCachedHash = reply.readString();
                    }
                    finally {
                        reply.recycle();
                        data.recycle();
                    }
                }
                return this.mCachedHash;
            }
        }
    }

    public static class Default
    implements IKeystoreOperation {
        @Override
        public void updateAad(byte[] aadInput) throws RemoteException {
        }

        @Override
        public byte[] update(byte[] input) throws RemoteException {
            return null;
        }

        @Override
        public byte[] finish(byte[] input, byte[] signature) throws RemoteException {
            return null;
        }

        @Override
        public void abort() throws RemoteException {
        }

        @Override
        public int getInterfaceVersion() {
            return 0;
        }

        @Override
        public String getInterfaceHash() {
            return "";
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

