/*
 * Decompiled with CFR 0.152.
 */
package android.sysprop;

import android.os.SystemProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.function.Function;

public class TelephonyProperties {
    private TelephonyProperties() {
    }

    private static Boolean tryParseBoolean(String str) {
        switch (str.toLowerCase(Locale.US)) {
            case "1": 
            case "true": {
                return Boolean.TRUE;
            }
            case "0": 
            case "false": {
                return Boolean.FALSE;
            }
        }
        return null;
    }

    private static Integer tryParseInteger(String str) {
        try {
            return Integer.valueOf(str);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private static Integer tryParseUInt(String str) {
        try {
            return Integer.parseUnsignedInt(str);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private static Long tryParseLong(String str) {
        try {
            return Long.valueOf(str);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private static Long tryParseULong(String str) {
        try {
            return Long.parseUnsignedLong(str);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private static Double tryParseDouble(String str) {
        try {
            return Double.valueOf(str);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private static String tryParseString(String str) {
        return "".equals(str) ? null : str;
    }

    private static <T extends Enum<T>> T tryParseEnum(Class<T> enumType, String str) {
        try {
            return Enum.valueOf(enumType, str.toUpperCase(Locale.US));
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    private static <T> List<T> tryParseList(Function<String, T> elementParser, String str) {
        if ("".equals(str)) {
            return new ArrayList();
        }
        ArrayList<T> ret = new ArrayList<T>();
        int p = 0;
        while (true) {
            StringBuilder sb = new StringBuilder();
            while (p < str.length() && str.charAt(p) != ',') {
                if (str.charAt(p) == '\\') {
                    ++p;
                }
                if (p == str.length()) break;
                sb.append(str.charAt(p++));
            }
            ret.add(elementParser.apply(sb.toString()));
            if (p == str.length()) break;
            ++p;
        }
        return ret;
    }

    private static <T extends Enum<T>> List<T> tryParseEnumList(Class<T> enumType, String str) {
        if ("".equals(str)) {
            return new ArrayList();
        }
        ArrayList<T> ret = new ArrayList<T>();
        for (String element : str.split(",")) {
            ret.add(TelephonyProperties.tryParseEnum(enumType, element));
        }
        return ret;
    }

    private static String escape(String str) {
        return str.replaceAll("([\\\\,])", "\\\\$1");
    }

    private static <T> String formatList(List<T> list) {
        StringJoiner joiner = new StringJoiner(",");
        for (T element : list) {
            joiner.add(element == null ? "" : TelephonyProperties.escape(element.toString()));
        }
        return joiner.toString();
    }

    private static String formatUIntList(List<Integer> list) {
        StringJoiner joiner = new StringJoiner(",");
        for (Integer element : list) {
            joiner.add(element == null ? "" : TelephonyProperties.escape(Integer.toUnsignedString(element)));
        }
        return joiner.toString();
    }

    private static String formatULongList(List<Long> list) {
        StringJoiner joiner = new StringJoiner(",");
        for (Long element : list) {
            joiner.add(element == null ? "" : TelephonyProperties.escape(Long.toUnsignedString(element)));
        }
        return joiner.toString();
    }

    private static <T extends Enum<T>> String formatEnumList(List<T> list, Function<T, String> elementFormatter) {
        StringJoiner joiner = new StringJoiner(",");
        for (Enum element : list) {
            joiner.add(element == null ? "" : (CharSequence)elementFormatter.apply(element));
        }
        return joiner.toString();
    }

    public static Optional<Boolean> airplane_mode_on() {
        String value2 = SystemProperties.get("persist.radio.airplane_mode_on");
        return Optional.ofNullable(TelephonyProperties.tryParseBoolean(value2));
    }

    public static void airplane_mode_on(Boolean value2) {
        SystemProperties.set("persist.radio.airplane_mode_on", value2 == null ? "" : (value2 != false ? "1" : "0"));
    }

    public static List<String> baseband_version() {
        String value2 = SystemProperties.get("gsm.version.baseband");
        return TelephonyProperties.tryParseList(v -> TelephonyProperties.tryParseString(v), value2);
    }

    public static void baseband_version(List<String> value2) {
        SystemProperties.set("gsm.version.baseband", value2 == null ? "" : TelephonyProperties.formatList(value2));
    }

    public static Optional<String> ril_impl() {
        String value2 = SystemProperties.get("gsm.version.ril-impl");
        return Optional.ofNullable(TelephonyProperties.tryParseString(value2));
    }

    public static List<String> operator_alpha() {
        String value2 = SystemProperties.get("gsm.operator.alpha");
        return TelephonyProperties.tryParseList(v -> TelephonyProperties.tryParseString(v), value2);
    }

    public static void operator_alpha(List<String> value2) {
        SystemProperties.set("gsm.operator.alpha", value2 == null ? "" : TelephonyProperties.formatList(value2));
    }

    public static List<String> operator_numeric() {
        String value2 = SystemProperties.get("gsm.operator.numeric");
        return TelephonyProperties.tryParseList(v -> TelephonyProperties.tryParseString(v), value2);
    }

    public static void operator_numeric(List<String> value2) {
        SystemProperties.set("gsm.operator.numeric", value2 == null ? "" : TelephonyProperties.formatList(value2));
    }

    public static Optional<Boolean> operator_is_manual() {
        String value2 = SystemProperties.get("operator.ismanual");
        return Optional.ofNullable(TelephonyProperties.tryParseBoolean(value2));
    }

    public static List<Boolean> operator_is_roaming() {
        String value2 = SystemProperties.get("gsm.operator.isroaming");
        return TelephonyProperties.tryParseList(v -> TelephonyProperties.tryParseBoolean(v), value2);
    }

    public static void operator_is_roaming(List<Boolean> value2) {
        SystemProperties.set("gsm.operator.isroaming", value2 == null ? "" : TelephonyProperties.formatList(value2));
    }

    public static List<String> operator_iso_country() {
        String value2 = SystemProperties.get("gsm.operator.iso-country");
        return TelephonyProperties.tryParseList(v -> TelephonyProperties.tryParseString(v), value2);
    }

    public static void operator_iso_country(List<String> value2) {
        SystemProperties.set("gsm.operator.iso-country", value2 == null ? "" : TelephonyProperties.formatList(value2));
    }

    public static Optional<String> lte_on_cdma_product_type() {
        String value2 = SystemProperties.get("telephony.lteOnCdmaProductType");
        return Optional.ofNullable(TelephonyProperties.tryParseString(value2));
    }

    public static Optional<Integer> lte_on_cdma_device() {
        String value2 = SystemProperties.get("telephony.lteOnCdmaDevice");
        return Optional.ofNullable(TelephonyProperties.tryParseInteger(value2));
    }

    public static List<Integer> current_active_phone() {
        String value2 = SystemProperties.get("gsm.current.phone-type");
        return TelephonyProperties.tryParseList(v -> TelephonyProperties.tryParseInteger(v), value2);
    }

    public static void current_active_phone(List<Integer> value2) {
        SystemProperties.set("gsm.current.phone-type", value2 == null ? "" : TelephonyProperties.formatList(value2));
    }

    public static List<String> sim_state() {
        String value2 = SystemProperties.get("gsm.sim.state");
        return TelephonyProperties.tryParseList(v -> TelephonyProperties.tryParseString(v), value2);
    }

    public static void sim_state(List<String> value2) {
        SystemProperties.set("gsm.sim.state", value2 == null ? "" : TelephonyProperties.formatList(value2));
    }

    public static List<String> icc_operator_numeric() {
        String value2 = SystemProperties.get("gsm.sim.operator.numeric");
        return TelephonyProperties.tryParseList(v -> TelephonyProperties.tryParseString(v), value2);
    }

    public static void icc_operator_numeric(List<String> value2) {
        SystemProperties.set("gsm.sim.operator.numeric", value2 == null ? "" : TelephonyProperties.formatList(value2));
    }

    public static List<String> icc_operator_alpha() {
        String value2 = SystemProperties.get("gsm.sim.operator.alpha");
        return TelephonyProperties.tryParseList(v -> TelephonyProperties.tryParseString(v), value2);
    }

    public static void icc_operator_alpha(List<String> value2) {
        SystemProperties.set("gsm.sim.operator.alpha", value2 == null ? "" : TelephonyProperties.formatList(value2));
    }

    public static List<String> icc_operator_iso_country() {
        String value2 = SystemProperties.get("gsm.sim.operator.iso-country");
        return TelephonyProperties.tryParseList(v -> TelephonyProperties.tryParseString(v), value2);
    }

    public static void icc_operator_iso_country(List<String> value2) {
        SystemProperties.set("gsm.sim.operator.iso-country", value2 == null ? "" : TelephonyProperties.formatList(value2));
    }

    public static List<String> data_network_type() {
        String value2 = SystemProperties.get("gsm.network.type");
        return TelephonyProperties.tryParseList(v -> TelephonyProperties.tryParseString(v), value2);
    }

    public static void data_network_type(List<String> value2) {
        SystemProperties.set("gsm.network.type", value2 == null ? "" : TelephonyProperties.formatList(value2));
    }

    public static Optional<Boolean> in_ecm_mode() {
        String value2 = SystemProperties.get("ril.cdma.inecmmode");
        return Optional.ofNullable(TelephonyProperties.tryParseBoolean(value2));
    }

    public static void in_ecm_mode(Boolean value2) {
        SystemProperties.set("ril.cdma.inecmmode", value2 == null ? "" : value2.toString());
    }

    public static Optional<Long> ecm_exit_timer() {
        String value2 = SystemProperties.get("ro.cdma.ecmexittimer");
        return Optional.ofNullable(TelephonyProperties.tryParseLong(value2));
    }

    public static Optional<String> operator_idp_string() {
        String value2 = SystemProperties.get("gsm.operator.idpstring");
        return Optional.ofNullable(TelephonyProperties.tryParseString(value2));
    }

    public static void operator_idp_string(String value2) {
        SystemProperties.set("gsm.operator.idpstring", value2 == null ? "" : value2.toString());
    }

    public static List<String> otasp_num_schema() {
        String value2 = SystemProperties.get("ro.cdma.otaspnumschema");
        return TelephonyProperties.tryParseList(v -> TelephonyProperties.tryParseString(v), value2);
    }

    public static Optional<Boolean> disable_call() {
        String value2 = SystemProperties.get("ro.telephony.disable-call");
        return Optional.ofNullable(TelephonyProperties.tryParseBoolean(value2));
    }

    public static Optional<Boolean> ril_sends_multiple_call_ring() {
        String value2 = SystemProperties.get("ro.telephony.call_ring.multiple");
        return Optional.ofNullable(TelephonyProperties.tryParseBoolean(value2));
    }

    public static Optional<Integer> call_ring_delay() {
        String value2 = SystemProperties.get("ro.telephony.call_ring.delay");
        return Optional.ofNullable(TelephonyProperties.tryParseInteger(value2));
    }

    public static Optional<Integer> cdma_msg_id() {
        String value2 = SystemProperties.get("persist.radio.cdma.msgid");
        return Optional.ofNullable(TelephonyProperties.tryParseInteger(value2));
    }

    public static void cdma_msg_id(Integer value2) {
        SystemProperties.set("persist.radio.cdma.msgid", value2 == null ? "" : value2.toString());
    }

    public static Optional<Integer> wake_lock_timeout() {
        String value2 = SystemProperties.get("ro.ril.wake_lock_timeout");
        return Optional.ofNullable(TelephonyProperties.tryParseInteger(value2));
    }

    public static Optional<Boolean> reset_on_radio_tech_change() {
        String value2 = SystemProperties.get("persist.radio.reset_on_switch");
        return Optional.ofNullable(TelephonyProperties.tryParseBoolean(value2));
    }

    public static List<Boolean> sms_receive() {
        String value2 = SystemProperties.get("telephony.sms.receive");
        return TelephonyProperties.tryParseList(v -> TelephonyProperties.tryParseBoolean(v), value2);
    }

    public static List<Boolean> sms_send() {
        String value2 = SystemProperties.get("telephony.sms.send");
        return TelephonyProperties.tryParseList(v -> TelephonyProperties.tryParseBoolean(v), value2);
    }

    public static Optional<Boolean> test_csim() {
        String value2 = SystemProperties.get("persist.radio.test-csim");
        return Optional.ofNullable(TelephonyProperties.tryParseBoolean(value2));
    }

    public static Optional<Boolean> ignore_nitz() {
        String value2 = SystemProperties.get("telephony.test.ignore.nitz");
        return Optional.ofNullable(TelephonyProperties.tryParseBoolean(value2));
    }

    public static Optional<String> multi_sim_config() {
        String value2 = SystemProperties.get("persist.radio.multisim.config");
        return Optional.ofNullable(TelephonyProperties.tryParseString(value2));
    }

    public static void multi_sim_config(String value2) {
        SystemProperties.set("persist.radio.multisim.config", value2 == null ? "" : value2.toString());
    }

    public static Optional<Boolean> reboot_on_modem_change() {
        String value2 = SystemProperties.get("persist.radio.reboot_on_modem_change");
        return Optional.ofNullable(TelephonyProperties.tryParseBoolean(value2));
    }

    public static Optional<Integer> videocall_audio_output() {
        String value2 = SystemProperties.get("persist.radio.call.audio.output");
        return Optional.ofNullable(TelephonyProperties.tryParseInteger(value2));
    }

    public static Optional<Boolean> enable_esim_ui_by_default() {
        String value2 = SystemProperties.get("esim.enable_esim_system_ui_by_default");
        return Optional.ofNullable(TelephonyProperties.tryParseBoolean(value2));
    }

    public static List<Integer> default_network() {
        String value2 = SystemProperties.get("ro.telephony.default_network");
        return TelephonyProperties.tryParseList(v -> TelephonyProperties.tryParseInteger(v), value2);
    }

    public static Optional<Boolean> data_roaming() {
        String value2 = SystemProperties.get("ro.com.android.dataroaming");
        return Optional.ofNullable(TelephonyProperties.tryParseBoolean(value2));
    }

    public static Optional<Boolean> mobile_data() {
        String value2 = SystemProperties.get("ro.com.android.mobiledata");
        return Optional.ofNullable(TelephonyProperties.tryParseBoolean(value2));
    }

    public static Optional<Integer> wps_info() {
        String value2 = SystemProperties.get("wifidirect.wps");
        return Optional.ofNullable(TelephonyProperties.tryParseInteger(value2));
    }

    public static Optional<Integer> max_active_modems() {
        String value2 = SystemProperties.get("telephony.active_modems.max_count");
        return Optional.ofNullable(TelephonyProperties.tryParseInteger(value2));
    }

    public static Optional<Integer> sim_slots_count() {
        String value2 = SystemProperties.get("ro.telephony.sim_slots.count");
        return Optional.ofNullable(TelephonyProperties.tryParseInteger(value2));
    }
}

