/*
 * Decompiled with CFR 0.152.
 */
package android.service.wallpaper;

import android.annotation.SystemApi;
import android.app.Service;
import android.app.WallpaperColors;
import android.app.WallpaperManager;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.content.res.TypedArray;
import android.graphics.BLASTBufferQueue;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.RectF;
import android.hardware.display.DisplayManager;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.os.Trace;
import android.service.wallpaper.EngineWindowPage;
import android.service.wallpaper.IWallpaperConnection;
import android.service.wallpaper.IWallpaperEngine;
import android.service.wallpaper.IWallpaperService;
import android.util.ArraySet;
import android.util.Log;
import android.util.MergedConfiguration;
import android.view.Display;
import android.view.DisplayCutout;
import android.view.IWindowSession;
import android.view.InputChannel;
import android.view.InputEvent;
import android.view.InputEventReceiver;
import android.view.InsetsSourceControl;
import android.view.InsetsState;
import android.view.MotionEvent;
import android.view.PixelCopy;
import android.view.Surface;
import android.view.SurfaceControl;
import android.view.SurfaceHolder;
import android.view.WindowInsets;
import android.view.WindowManager;
import android.view.WindowManagerGlobal;
import android.window.ClientWindowFrames;
import com.android.internal.R;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.os.HandlerCaller;
import com.android.internal.view.BaseIWindow;
import com.android.internal.view.BaseSurfaceHolder;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;

public abstract class WallpaperService
extends Service {
    public static final String SERVICE_INTERFACE = "android.service.wallpaper.WallpaperService";
    public static final String SERVICE_META_DATA = "android.service.wallpaper";
    static final String TAG = "WallpaperService";
    static final boolean DEBUG = false;
    static final float MIN_PAGE_ALLOWED_MARGIN = 0.05f;
    private static final int MIN_BITMAP_SCREENSHOT_WIDTH = 64;
    private static final long DEFAULT_UPDATE_SCREENSHOT_DURATION = 60000L;
    private static final RectF LOCAL_COLOR_BOUNDS = new RectF(0.0f, 0.0f, 1.0f, 1.0f);
    private static final int DO_ATTACH = 10;
    private static final int DO_DETACH = 20;
    private static final int DO_SET_DESIRED_SIZE = 30;
    private static final int DO_SET_DISPLAY_PADDING = 40;
    private static final int DO_IN_AMBIENT_MODE = 50;
    private static final int MSG_UPDATE_SURFACE = 10000;
    private static final int MSG_VISIBILITY_CHANGED = 10010;
    private static final int MSG_WALLPAPER_OFFSETS = 10020;
    private static final int MSG_WALLPAPER_COMMAND = 10025;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    private static final int MSG_WINDOW_RESIZED = 10030;
    private static final int MSG_WINDOW_MOVED = 10035;
    private static final int MSG_TOUCH_EVENT = 10040;
    private static final int MSG_REQUEST_WALLPAPER_COLORS = 10050;
    private static final int MSG_ZOOM = 10100;
    private static final int MSG_SCALE_PREVIEW = 10110;
    private static final List<Float> PROHIBITED_STEPS = Arrays.asList(Float.valueOf(0.0f), Float.valueOf(Float.POSITIVE_INFINITY), Float.valueOf(Float.NEGATIVE_INFINITY));
    private static final int NOTIFY_COLORS_RATE_LIMIT_MS = 1000;
    private static final boolean ENABLE_WALLPAPER_DIMMING = SystemProperties.getBoolean("persist.debug.enable_wallpaper_dimming", true);
    private final ArrayList<Engine> mActiveEngines = new ArrayList();

    private boolean isValid(RectF area) {
        if (area == null) {
            return false;
        }
        boolean valid = area.bottom > area.top && area.left < area.right && LOCAL_COLOR_BOUNDS.contains(area);
        return valid;
    }

    private boolean inRectFRange(float number) {
        return number >= 0.0f && number <= 1.0f;
    }

    @Override
    public void onCreate() {
        super.onCreate();
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        for (int i = 0; i < this.mActiveEngines.size(); ++i) {
            this.mActiveEngines.get(i).detach();
        }
        this.mActiveEngines.clear();
    }

    @Override
    public IBinder onBind(Intent intent) {
        return new IWallpaperServiceWrapper(this);
    }

    public abstract Engine onCreateEngine();

    @Override
    protected void dump(FileDescriptor fd, PrintWriter out, String[] args) {
        out.print("State of wallpaper ");
        out.print(this);
        out.println(":");
        for (int i = 0; i < this.mActiveEngines.size(); ++i) {
            Engine engine = this.mActiveEngines.get(i);
            out.print("  Engine ");
            out.print(engine);
            out.println(":");
            engine.dump("    ", fd, out, args);
        }
    }

    class IWallpaperServiceWrapper
    extends IWallpaperService.Stub {
        private final WallpaperService mTarget;
        private IWallpaperEngineWrapper mEngineWrapper;

        public IWallpaperServiceWrapper(WallpaperService context) {
            this.mTarget = context;
        }

        @Override
        public void attach(IWallpaperConnection conn, IBinder windowToken, int windowType, boolean isPreview, int reqWidth, int reqHeight, Rect padding, int displayId) {
            this.mEngineWrapper = new IWallpaperEngineWrapper(this.mTarget, conn, windowToken, windowType, isPreview, reqWidth, reqHeight, padding, displayId);
        }

        @Override
        public void detach() {
            this.mEngineWrapper.detach();
        }
    }

    class IWallpaperEngineWrapper
    extends IWallpaperEngine.Stub
    implements HandlerCaller.Callback {
        private final HandlerCaller mCaller;
        final IWallpaperConnection mConnection;
        final IBinder mWindowToken;
        final int mWindowType;
        final boolean mIsPreview;
        boolean mShownReported;
        int mReqWidth;
        int mReqHeight;
        final Rect mDisplayPadding = new Rect();
        final int mDisplayId;
        final DisplayManager mDisplayManager;
        final Display mDisplay;
        final WallpaperManager mWallpaperManager;
        private final AtomicBoolean mDetached = new AtomicBoolean();
        Engine mEngine;

        IWallpaperEngineWrapper(WallpaperService context, IWallpaperConnection conn, IBinder windowToken, int windowType, boolean isPreview, int reqWidth, int reqHeight, Rect padding, int displayId) {
            this.mWallpaperManager = WallpaperService.this.getSystemService(WallpaperManager.class);
            this.mCaller = new HandlerCaller(context, context.getMainLooper(), this, true);
            this.mConnection = conn;
            this.mWindowToken = windowToken;
            this.mWindowType = windowType;
            this.mIsPreview = isPreview;
            this.mReqWidth = reqWidth;
            this.mReqHeight = reqHeight;
            this.mDisplayPadding.set(padding);
            this.mDisplayId = displayId;
            this.mDisplayManager = WallpaperService.this.getSystemService(DisplayManager.class);
            this.mDisplay = this.mDisplayManager.getDisplay(this.mDisplayId);
            if (this.mDisplay == null) {
                throw new IllegalArgumentException("Cannot find display with id" + this.mDisplayId);
            }
            Message msg = this.mCaller.obtainMessage(10);
            this.mCaller.sendMessage(msg);
        }

        @Override
        public void setDesiredSize(int width, int height) {
            Message msg = this.mCaller.obtainMessageII(30, width, height);
            this.mCaller.sendMessage(msg);
        }

        @Override
        public void setDisplayPadding(Rect padding) {
            Message msg = this.mCaller.obtainMessageO(40, padding);
            this.mCaller.sendMessage(msg);
        }

        @Override
        public void setVisibility(boolean visible) {
            Message msg = this.mCaller.obtainMessageI(10010, visible ? 1 : 0);
            this.mCaller.sendMessage(msg);
        }

        @Override
        public void setInAmbientMode(boolean inAmbientDisplay, long animationDuration) throws RemoteException {
            Message msg = this.mCaller.obtainMessageIO(50, inAmbientDisplay ? 1 : 0, animationDuration);
            this.mCaller.sendMessage(msg);
        }

        @Override
        public void dispatchPointer(MotionEvent event) {
            if (this.mEngine != null) {
                this.mEngine.dispatchPointer(event);
            } else {
                event.recycle();
            }
        }

        @Override
        public void dispatchWallpaperCommand(String action2, int x, int y, int z, Bundle extras) {
            if (this.mEngine != null) {
                this.mEngine.mWindow.dispatchWallpaperCommand(action2, x, y, z, extras, false);
            }
        }

        @Override
        public void setZoomOut(float scale) {
            Message msg = this.mCaller.obtainMessageI(10100, Float.floatToIntBits(scale));
            this.mCaller.sendMessage(msg);
        }

        public void reportShown() {
            if (!this.mShownReported) {
                this.mShownReported = true;
                try {
                    this.mConnection.engineShown(this);
                }
                catch (RemoteException e) {
                    Log.w(WallpaperService.TAG, "Wallpaper host disappeared", e);
                    return;
                }
            }
        }

        @Override
        public void requestWallpaperColors() {
            Message msg = this.mCaller.obtainMessage(10050);
            this.mCaller.sendMessage(msg);
        }

        @Override
        public void addLocalColorsAreas(List<RectF> regions) {
            this.mEngine.addLocalColorsAreas(regions);
        }

        @Override
        public void removeLocalColorsAreas(List<RectF> regions) {
            this.mEngine.removeLocalColorsAreas(regions);
        }

        @Override
        public void destroy() {
            Message msg = this.mCaller.obtainMessage(20);
            this.mCaller.sendMessage(msg);
        }

        public void detach() {
            this.mDetached.set(true);
        }

        @Override
        public void scalePreview(Rect position) {
            Message msg = this.mCaller.obtainMessageO(10110, position);
            this.mCaller.sendMessage(msg);
        }

        @Override
        public SurfaceControl mirrorSurfaceControl() {
            return this.mEngine == null ? null : SurfaceControl.mirrorSurface(this.mEngine.mSurfaceControl);
        }

        private void doDetachEngine() {
            WallpaperService.this.mActiveEngines.remove(this.mEngine);
            this.mEngine.detach();
            if (!this.mDetached.get()) {
                for (Engine eng : WallpaperService.this.mActiveEngines) {
                    if (!eng.mVisible) continue;
                    eng.doVisibilityChanged(false);
                    eng.doVisibilityChanged(true);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void executeMessage(Message message) {
            if (this.mDetached.get()) {
                if (WallpaperService.this.mActiveEngines.contains(this.mEngine)) {
                    this.doDetachEngine();
                }
                return;
            }
            switch (message.what) {
                case 10: {
                    Engine engine;
                    this.mEngine = engine = WallpaperService.this.onCreateEngine();
                    try {
                        this.mConnection.attachEngine(this, this.mDisplayId);
                    }
                    catch (RemoteException e) {
                        engine.detach();
                        Log.w(WallpaperService.TAG, "Wallpaper host disappeared", e);
                        return;
                    }
                    WallpaperService.this.mActiveEngines.add(engine);
                    engine.attach(this);
                    return;
                }
                case 20: {
                    this.doDetachEngine();
                    return;
                }
                case 30: {
                    this.mEngine.doDesiredSizeChanged(message.arg1, message.arg2);
                    return;
                }
                case 40: {
                    this.mEngine.doDisplayPaddingChanged((Rect)message.obj);
                    return;
                }
                case 50: {
                    this.mEngine.doAmbientModeChanged(message.arg1 != 0, (Long)message.obj);
                    return;
                }
                case 10000: {
                    this.mEngine.updateSurface(true, false, false);
                    break;
                }
                case 10100: {
                    this.mEngine.setZoom(Float.intBitsToFloat(message.arg1));
                    break;
                }
                case 10110: {
                    this.mEngine.scalePreview((Rect)message.obj);
                    break;
                }
                case 10010: {
                    this.mEngine.doVisibilityChanged(message.arg1 != 0);
                    break;
                }
                case 10020: {
                    this.mEngine.doOffsetsChanged(true);
                    break;
                }
                case 10025: {
                    WallpaperCommand cmd = (WallpaperCommand)message.obj;
                    this.mEngine.doCommand(cmd);
                    break;
                }
                case 10030: {
                    boolean reportDraw = message.arg1 != 0;
                    this.mEngine.updateSurface(true, false, reportDraw);
                    this.mEngine.doOffsetsChanged(true);
                    break;
                }
                case 10035: {
                    break;
                }
                case 10040: {
                    boolean skip = false;
                    MotionEvent ev = (MotionEvent)message.obj;
                    if (ev.getAction() == 2) {
                        Object object = this.mEngine.mLock;
                        synchronized (object) {
                            if (this.mEngine.mPendingMove == ev) {
                                this.mEngine.mPendingMove = null;
                            } else {
                                skip = true;
                            }
                        }
                    }
                    if (!skip) {
                        this.mEngine.onTouchEvent(ev);
                    }
                    ev.recycle();
                    break;
                }
                case 10050: {
                    if (this.mConnection == null) break;
                    try {
                        WallpaperColors colors = this.mEngine.onComputeColors();
                        this.mEngine.setPrimaryWallpaperColors(colors);
                        this.mConnection.onWallpaperColorsChanged(colors, this.mDisplayId);
                    }
                    catch (RemoteException remoteException) {}
                    break;
                }
                default: {
                    Log.w(WallpaperService.TAG, "Unknown message type " + message.what);
                }
            }
        }
    }

    public class Engine {
        IWallpaperEngineWrapper mIWallpaperEngine;
        final ArraySet<RectF> mLocalColorAreas = new ArraySet(4);
        final ArraySet<RectF> mLocalColorsToAdd = new ArraySet(4);
        EngineWindowPage[] mWindowPages = new EngineWindowPage[1];
        Bitmap mLastScreenshot;
        int mLastWindowPage = -1;
        float mLastPageOffset = 0.0f;
        HandlerCaller mCaller;
        IWallpaperConnection mConnection;
        IBinder mWindowToken;
        boolean mInitializing = true;
        boolean mVisible;
        boolean mReportedVisible;
        boolean mDestroyed;
        boolean mCreated;
        boolean mSurfaceCreated;
        boolean mIsCreating;
        boolean mDrawingAllowed;
        boolean mOffsetsChanged;
        boolean mFixedSizeAllowed;
        boolean mShouldDim;
        int mWidth;
        int mHeight;
        int mFormat;
        int mType;
        int mCurWidth;
        int mCurHeight;
        float mZoom = 0.0f;
        int mWindowFlags = 16;
        int mWindowPrivateFlags = 0x2000004;
        int mCurWindowFlags = this.mWindowFlags;
        int mCurWindowPrivateFlags = this.mWindowPrivateFlags;
        Rect mPreviewSurfacePosition;
        final ClientWindowFrames mWinFrames = new ClientWindowFrames();
        final Rect mDispatchedContentInsets = new Rect();
        final Rect mDispatchedStableInsets = new Rect();
        final Rect mFinalSystemInsets = new Rect();
        final Rect mFinalStableInsets = new Rect();
        DisplayCutout mDispatchedDisplayCutout = DisplayCutout.NO_CUTOUT;
        final InsetsState mInsetsState = new InsetsState();
        final InsetsSourceControl[] mTempControls = new InsetsSourceControl[0];
        final MergedConfiguration mMergedConfiguration = new MergedConfiguration();
        private final Point mSurfaceSize = new Point();
        private final Point mLastSurfaceSize = new Point();
        private final Matrix mTmpMatrix = new Matrix();
        private final float[] mTmpValues = new float[9];
        final WindowManager.LayoutParams mLayout = new WindowManager.LayoutParams();
        IWindowSession mSession;
        final Object mLock = new Object();
        boolean mOffsetMessageEnqueued;
        @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
        float mPendingXOffset;
        float mPendingYOffset;
        float mPendingXOffsetStep;
        float mPendingYOffsetStep;
        boolean mPendingSync;
        MotionEvent mPendingMove;
        boolean mIsInAmbientMode;
        private long mLastColorInvalidation;
        private final Runnable mNotifyColorsChanged = this::notifyColorsChanged;
        private final Supplier<Long> mClockFunction;
        private final Handler mHandler;
        private Display mDisplay;
        private Context mDisplayContext;
        private int mDisplayState;
        private float mWallpaperDimAmount = 0.05f;
        SurfaceControl mSurfaceControl = new SurfaceControl();
        SurfaceControl mBbqSurfaceControl;
        BLASTBufferQueue mBlastBufferQueue;
        final BaseSurfaceHolder mSurfaceHolder = new BaseSurfaceHolder(){
            {
                this.mRequestedFormat = 2;
            }

            @Override
            public boolean onAllowLockCanvas() {
                return Engine.this.mDrawingAllowed;
            }

            @Override
            public void onRelayoutContainer() {
                Message msg = Engine.this.mCaller.obtainMessage(10000);
                Engine.this.mCaller.sendMessage(msg);
            }

            @Override
            public void onUpdateSurface() {
                Message msg = Engine.this.mCaller.obtainMessage(10000);
                Engine.this.mCaller.sendMessage(msg);
            }

            @Override
            public boolean isCreating() {
                return Engine.this.mIsCreating;
            }

            @Override
            public void setFixedSize(int width, int height) {
                if (!Engine.this.mFixedSizeAllowed) {
                    throw new UnsupportedOperationException("Wallpapers currently only support sizing from layout");
                }
                super.setFixedSize(width, height);
            }

            @Override
            public void setKeepScreenOn(boolean screenOn) {
                throw new UnsupportedOperationException("Wallpapers do not support keep screen on");
            }

            private void prepareToDraw() {
                if (Engine.this.mDisplayState == 3 || Engine.this.mDisplayState == 4) {
                    try {
                        Engine.this.mSession.pokeDrawLock(Engine.this.mWindow);
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                }
            }

            @Override
            public Canvas lockCanvas() {
                this.prepareToDraw();
                return super.lockCanvas();
            }

            @Override
            public Canvas lockCanvas(Rect dirty) {
                this.prepareToDraw();
                return super.lockCanvas(dirty);
            }

            @Override
            public Canvas lockHardwareCanvas() {
                this.prepareToDraw();
                return super.lockHardwareCanvas();
            }
        };
        WallpaperInputEventReceiver mInputEventReceiver;
        final BaseIWindow mWindow = new BaseIWindow(){

            @Override
            public void resized(ClientWindowFrames frames, boolean reportDraw, MergedConfiguration mergedConfiguration, boolean forceLayout, boolean alwaysConsumeSystemBars, int displayId) {
                Message msg = Engine.this.mCaller.obtainMessageI(10030, reportDraw ? 1 : 0);
                Engine.this.mCaller.sendMessage(msg);
            }

            @Override
            public void moved(int newX, int newY) {
                Message msg = Engine.this.mCaller.obtainMessageII(10035, newX, newY);
                Engine.this.mCaller.sendMessage(msg);
            }

            @Override
            public void dispatchAppVisibility(boolean visible) {
                if (!Engine.this.mIWallpaperEngine.mIsPreview) {
                    Message msg = Engine.this.mCaller.obtainMessageI(10010, visible ? 1 : 0);
                    Engine.this.mCaller.sendMessage(msg);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void dispatchWallpaperOffsets(float x, float y, float xStep, float yStep, float zoom, boolean sync) {
                Object object = Engine.this.mLock;
                synchronized (object) {
                    Message msg;
                    Engine.this.mPendingXOffset = x;
                    Engine.this.mPendingYOffset = y;
                    Engine.this.mPendingXOffsetStep = xStep;
                    Engine.this.mPendingYOffsetStep = yStep;
                    if (sync) {
                        Engine.this.mPendingSync = true;
                    }
                    if (!Engine.this.mOffsetMessageEnqueued) {
                        Engine.this.mOffsetMessageEnqueued = true;
                        msg = Engine.this.mCaller.obtainMessage(10020);
                        Engine.this.mCaller.sendMessage(msg);
                    }
                    msg = Engine.this.mCaller.obtainMessageI(10100, Float.floatToIntBits(zoom));
                    Engine.this.mCaller.sendMessage(msg);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void dispatchWallpaperCommand(String action2, int x, int y, int z, Bundle extras, boolean sync) {
                Object object = Engine.this.mLock;
                synchronized (object) {
                    WallpaperCommand cmd = new WallpaperCommand();
                    cmd.action = action2;
                    cmd.x = x;
                    cmd.y = y;
                    cmd.z = z;
                    cmd.extras = extras;
                    cmd.sync = sync;
                    Message msg = Engine.this.mCaller.obtainMessage(10025);
                    msg.obj = cmd;
                    Engine.this.mCaller.sendMessage(msg);
                }
            }
        };
        private final DisplayManager.DisplayListener mDisplayListener = new DisplayManager.DisplayListener(){

            @Override
            public void onDisplayChanged(int displayId) {
                if (Engine.this.mDisplay.getDisplayId() == displayId) {
                    Engine.this.reportVisibility();
                }
            }

            @Override
            public void onDisplayRemoved(int displayId) {
            }

            @Override
            public void onDisplayAdded(int displayId) {
            }
        };

        public Engine() {
            this(SystemClock::elapsedRealtime, Handler.getMain());
        }

        @VisibleForTesting
        public Engine(Supplier<Long> clockFunction, Handler handler) {
            this.mClockFunction = clockFunction;
            this.mHandler = handler;
        }

        public SurfaceHolder getSurfaceHolder() {
            return this.mSurfaceHolder;
        }

        public int getDesiredMinimumWidth() {
            return this.mIWallpaperEngine.mReqWidth;
        }

        public int getDesiredMinimumHeight() {
            return this.mIWallpaperEngine.mReqHeight;
        }

        public boolean isVisible() {
            return this.mReportedVisible;
        }

        public boolean supportsLocalColorExtraction() {
            return false;
        }

        public boolean isPreview() {
            return this.mIWallpaperEngine.mIsPreview;
        }

        @SystemApi
        public boolean isInAmbientMode() {
            return this.mIsInAmbientMode;
        }

        public boolean shouldZoomOutWallpaper() {
            return false;
        }

        public void setTouchEventsEnabled(boolean enabled) {
            int n = this.mWindowFlags = enabled ? this.mWindowFlags & 0xFFFFFFEF : this.mWindowFlags | 0x10;
            if (this.mCreated) {
                this.updateSurface(false, false, false);
            }
        }

        public void setOffsetNotificationsEnabled(boolean enabled) {
            int n = this.mWindowPrivateFlags = enabled ? this.mWindowPrivateFlags | 4 : this.mWindowPrivateFlags & 0xFFFFFFFB;
            if (this.mCreated) {
                this.updateSurface(false, false, false);
            }
        }

        @UnsupportedAppUsage
        public void setFixedSizeAllowed(boolean allowed) {
            this.mFixedSizeAllowed = allowed;
        }

        @VisibleForTesting
        public float getZoom() {
            return this.mZoom;
        }

        public void onCreate(SurfaceHolder surfaceHolder) {
        }

        public void onDestroy() {
        }

        public void onVisibilityChanged(boolean visible) {
        }

        public void onApplyWindowInsets(WindowInsets insets) {
        }

        public void onTouchEvent(MotionEvent event) {
        }

        public void onOffsetsChanged(float xOffset, float yOffset, float xOffsetStep, float yOffsetStep, int xPixelOffset, int yPixelOffset) {
        }

        public Bundle onCommand(String action2, int x, int y, int z, Bundle extras, boolean resultRequested) {
            return null;
        }

        @SystemApi
        public void onAmbientModeChanged(boolean inAmbientMode, long animationDuration) {
        }

        public void onDesiredSizeChanged(int desiredWidth, int desiredHeight) {
        }

        public void onSurfaceChanged(SurfaceHolder holder, int format, int width, int height) {
        }

        public void onSurfaceRedrawNeeded(SurfaceHolder holder) {
        }

        public void onSurfaceCreated(SurfaceHolder holder) {
        }

        public void onSurfaceDestroyed(SurfaceHolder holder) {
        }

        public void onZoomChanged(float zoom) {
        }

        public void notifyColorsChanged() {
            long now = this.mClockFunction.get();
            if (now - this.mLastColorInvalidation < 1000L) {
                Log.w(WallpaperService.TAG, "This call has been deferred. You should only call notifyColorsChanged() once every 1.0 seconds.");
                if (!this.mHandler.hasCallbacks(this.mNotifyColorsChanged)) {
                    this.mHandler.postDelayed(this.mNotifyColorsChanged, 1000L);
                }
                return;
            }
            this.mLastColorInvalidation = now;
            this.mHandler.removeCallbacks(this.mNotifyColorsChanged);
            try {
                WallpaperColors newColors = this.onComputeColors();
                if (this.mConnection != null) {
                    this.mConnection.onWallpaperColorsChanged(newColors, this.mDisplay.getDisplayId());
                } else {
                    Log.w(WallpaperService.TAG, "Can't notify system because wallpaper connection was not established.");
                }
                this.resetWindowPages();
                this.processLocalColors(this.mPendingXOffset, this.mPendingXOffsetStep);
            }
            catch (RemoteException e) {
                Log.w(WallpaperService.TAG, "Can't notify system because wallpaper connection was lost.", e);
            }
        }

        public WallpaperColors onComputeColors() {
            return null;
        }

        public void notifyLocalColorsChanged(List<RectF> regions, List<WallpaperColors> colors) throws RuntimeException {
            for (int i = 0; i < regions.size() && i < colors.size(); ++i) {
                WallpaperColors color2 = colors.get(i);
                RectF area = regions.get(i);
                if (color2 == null || area == null) continue;
                try {
                    this.mConnection.onLocalWallpaperColorsChanged(area, color2, this.mDisplayContext.getDisplayId());
                    continue;
                }
                catch (RemoteException e) {
                    throw new RuntimeException(e);
                }
            }
            WallpaperColors primaryColors = this.mIWallpaperEngine.mWallpaperManager.getWallpaperColors(1);
            this.setPrimaryWallpaperColors(primaryColors);
        }

        private void setPrimaryWallpaperColors(WallpaperColors colors) {
            boolean shouldDim;
            if (colors == null) {
                return;
            }
            int colorHints = colors.getColorHints();
            boolean bl = shouldDim = (colorHints & 1) == 0 && (colorHints & 2) == 0;
            if (shouldDim != this.mShouldDim) {
                this.mShouldDim = shouldDim;
                this.updateSurfaceDimming();
                this.updateSurface(false, false, true);
            }
        }

        private void updateSurfaceDimming() {
            if (!ENABLE_WALLPAPER_DIMMING || this.mBbqSurfaceControl == null) {
                return;
            }
            if (!this.isPreview() && this.mShouldDim) {
                Log.v(WallpaperService.TAG, "Setting wallpaper dimming: " + this.mWallpaperDimAmount);
                new SurfaceControl.Transaction().setAlpha(this.mBbqSurfaceControl, 1.0f - this.mWallpaperDimAmount).apply();
            } else {
                Log.v(WallpaperService.TAG, "Setting wallpaper dimming: 0");
                new SurfaceControl.Transaction().setAlpha(this.mBbqSurfaceControl, 1.0f).apply();
            }
        }

        @VisibleForTesting
        public void setCreated(boolean created) {
            this.mCreated = created;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void dump(String prefix, FileDescriptor fd, PrintWriter out, String[] args) {
            out.print(prefix);
            out.print("mInitializing=");
            out.print(this.mInitializing);
            out.print(" mDestroyed=");
            out.println(this.mDestroyed);
            out.print(prefix);
            out.print("mVisible=");
            out.print(this.mVisible);
            out.print(" mReportedVisible=");
            out.println(this.mReportedVisible);
            out.print(prefix);
            out.print("mDisplay=");
            out.println(this.mDisplay);
            out.print(prefix);
            out.print("mCreated=");
            out.print(this.mCreated);
            out.print(" mSurfaceCreated=");
            out.print(this.mSurfaceCreated);
            out.print(" mIsCreating=");
            out.print(this.mIsCreating);
            out.print(" mDrawingAllowed=");
            out.println(this.mDrawingAllowed);
            out.print(prefix);
            out.print("mWidth=");
            out.print(this.mWidth);
            out.print(" mCurWidth=");
            out.print(this.mCurWidth);
            out.print(" mHeight=");
            out.print(this.mHeight);
            out.print(" mCurHeight=");
            out.println(this.mCurHeight);
            out.print(prefix);
            out.print("mType=");
            out.print(this.mType);
            out.print(" mWindowFlags=");
            out.print(this.mWindowFlags);
            out.print(" mCurWindowFlags=");
            out.println(this.mCurWindowFlags);
            out.print(prefix);
            out.print("mWindowPrivateFlags=");
            out.print(this.mWindowPrivateFlags);
            out.print(" mCurWindowPrivateFlags=");
            out.println(this.mCurWindowPrivateFlags);
            out.print(prefix);
            out.println("mWinFrames=");
            out.println(this.mWinFrames);
            out.print(prefix);
            out.print("mConfiguration=");
            out.println(this.mMergedConfiguration.getMergedConfiguration());
            out.print(prefix);
            out.print("mLayout=");
            out.println(this.mLayout);
            out.print(prefix);
            out.print("mZoom=");
            out.println(this.mZoom);
            out.print(prefix);
            out.print("mPreviewSurfacePosition=");
            out.println(this.mPreviewSurfacePosition);
            Object object = this.mLock;
            synchronized (object) {
                out.print(prefix);
                out.print("mPendingXOffset=");
                out.print(this.mPendingXOffset);
                out.print(" mPendingXOffset=");
                out.println(this.mPendingXOffset);
                out.print(prefix);
                out.print("mPendingXOffsetStep=");
                out.print(this.mPendingXOffsetStep);
                out.print(" mPendingXOffsetStep=");
                out.println(this.mPendingXOffsetStep);
                out.print(prefix);
                out.print("mOffsetMessageEnqueued=");
                out.print(this.mOffsetMessageEnqueued);
                out.print(" mPendingSync=");
                out.println(this.mPendingSync);
                if (this.mPendingMove != null) {
                    out.print(prefix);
                    out.print("mPendingMove=");
                    out.println(this.mPendingMove);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @VisibleForTesting
        public void setZoom(float zoom) {
            boolean updated = false;
            Object object = this.mLock;
            synchronized (object) {
                if (this.mIsInAmbientMode) {
                    this.mZoom = 0.0f;
                }
                if (Float.compare(zoom, this.mZoom) != 0) {
                    this.mZoom = zoom;
                    updated = true;
                }
            }
            if (updated && !this.mDestroyed) {
                this.onZoomChanged(this.mZoom);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void dispatchPointer(MotionEvent event) {
            if (event.isTouchEvent()) {
                Object object = this.mLock;
                synchronized (object) {
                    this.mPendingMove = event.getAction() == 2 ? event : null;
                }
                Message msg = this.mCaller.obtainMessageO(10040, event);
                this.mCaller.sendMessage(msg);
            } else {
                event.recycle();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void updateSurface(boolean forceRelayout, boolean forceReport, boolean redrawNeeded) {
            boolean flagsChanged;
            if (this.mDestroyed) {
                Log.w(WallpaperService.TAG, "Ignoring updateSurface: destroyed");
            }
            boolean fixedSize = false;
            int myWidth = this.mSurfaceHolder.getRequestedWidth();
            if (myWidth <= 0) {
                myWidth = -1;
            } else {
                fixedSize = true;
            }
            int myHeight = this.mSurfaceHolder.getRequestedHeight();
            if (myHeight <= 0) {
                myHeight = -1;
            } else {
                fixedSize = true;
            }
            boolean creating = !this.mCreated;
            boolean surfaceCreating = !this.mSurfaceCreated;
            boolean formatChanged = this.mFormat != this.mSurfaceHolder.getRequestedFormat();
            boolean sizeChanged = this.mWidth != myWidth || this.mHeight != myHeight;
            boolean insetsChanged = !this.mCreated;
            boolean typeChanged = this.mType != this.mSurfaceHolder.getRequestedType();
            boolean bl = flagsChanged = this.mCurWindowFlags != this.mWindowFlags || this.mCurWindowPrivateFlags != this.mWindowPrivateFlags;
            if (forceRelayout || creating || surfaceCreating || formatChanged || sizeChanged || typeChanged || flagsChanged || redrawNeeded || !this.mIWallpaperEngine.mShownReported) {
                try {
                    this.mWidth = myWidth;
                    this.mHeight = myHeight;
                    this.mFormat = this.mSurfaceHolder.getRequestedFormat();
                    this.mType = this.mSurfaceHolder.getRequestedType();
                    this.mLayout.x = 0;
                    this.mLayout.y = 0;
                    this.mLayout.width = myWidth;
                    this.mLayout.height = myHeight;
                    this.mLayout.format = this.mFormat;
                    this.mCurWindowFlags = this.mWindowFlags;
                    this.mLayout.flags = this.mWindowFlags | 0x200 | 0x10000 | 0x100 | 8;
                    this.mCurWindowPrivateFlags = this.mWindowPrivateFlags;
                    this.mLayout.privateFlags = this.mWindowPrivateFlags;
                    this.mLayout.memoryType = this.mType;
                    this.mLayout.token = this.mWindowToken;
                    if (!this.mCreated) {
                        TypedArray windowStyle = WallpaperService.this.obtainStyledAttributes(R.styleable.Window);
                        windowStyle.recycle();
                        this.mLayout.type = this.mIWallpaperEngine.mWindowType;
                        this.mLayout.gravity = 0x800033;
                        this.mLayout.setFitInsetsTypes(0);
                        this.mLayout.setTitle(WallpaperService.this.getClass().getName());
                        this.mLayout.windowAnimations = 16974606;
                        InputChannel inputChannel = new InputChannel();
                        if (this.mSession.addToDisplay(this.mWindow, this.mLayout, 0, this.mDisplay.getDisplayId(), this.mInsetsState, inputChannel, this.mInsetsState, this.mTempControls) < 0) {
                            Log.w(WallpaperService.TAG, "Failed to add window while updating wallpaper surface.");
                            return;
                        }
                        this.mSession.setShouldZoomOutWallpaper(this.mWindow, this.shouldZoomOutWallpaper());
                        this.mCreated = true;
                        this.mInputEventReceiver = new WallpaperInputEventReceiver(inputChannel, Looper.myLooper());
                    }
                    this.mSurfaceHolder.mSurfaceLock.lock();
                    this.mDrawingAllowed = true;
                    if (!fixedSize) {
                        this.mLayout.surfaceInsets.set(this.mIWallpaperEngine.mDisplayPadding);
                    } else {
                        this.mLayout.surfaceInsets.set(0, 0, 0, 0);
                    }
                    int relayoutResult = this.mSession.relayout(this.mWindow, this.mLayout, this.mWidth, this.mHeight, 0, 0, -1L, this.mWinFrames, this.mMergedConfiguration, this.mSurfaceControl, this.mInsetsState, this.mTempControls, this.mSurfaceSize);
                    if (this.mSurfaceControl.isValid()) {
                        if (this.mBbqSurfaceControl == null) {
                            this.mBbqSurfaceControl = new SurfaceControl.Builder().setName("Wallpaper BBQ wrapper").setHidden(false).setMetadata(2, 2013).setBLASTLayer().setParent(this.mSurfaceControl).setCallsite("Wallpaper#relayout").build();
                            this.updateSurfaceDimming();
                        }
                        this.mBbqSurfaceControl.setTransformHint(this.mSurfaceControl.getTransformHint());
                        Surface blastSurface = this.getOrCreateBLASTSurface(this.mSurfaceSize.x, this.mSurfaceSize.y, this.mFormat);
                        if (blastSurface != null) {
                            this.mSurfaceHolder.mSurface.transferFrom(blastSurface);
                        }
                    }
                    if (!this.mLastSurfaceSize.equals(this.mSurfaceSize)) {
                        this.mLastSurfaceSize.set(this.mSurfaceSize.x, this.mSurfaceSize.y);
                    }
                    int w = this.mWinFrames.frame.width();
                    int h = this.mWinFrames.frame.height();
                    DisplayCutout rawCutout = this.mInsetsState.getDisplayCutout();
                    Configuration config = WallpaperService.this.getResources().getConfiguration();
                    Rect visibleFrame = new Rect(this.mWinFrames.frame);
                    visibleFrame.intersect(this.mInsetsState.getDisplayFrame());
                    WindowInsets windowInsets = this.mInsetsState.calculateInsets(visibleFrame, null, config.isScreenRound(), false, this.mLayout.softInputMode, this.mLayout.flags, 0, this.mLayout.type, config.windowConfiguration.getWindowingMode(), null);
                    if (!fixedSize) {
                        Rect padding = this.mIWallpaperEngine.mDisplayPadding;
                        w += padding.left + padding.right;
                        h += padding.top + padding.bottom;
                        windowInsets = windowInsets.insetUnchecked(-padding.left, -padding.top, -padding.right, -padding.bottom);
                    } else {
                        w = myWidth;
                        h = myHeight;
                    }
                    if (this.mCurWidth != w) {
                        sizeChanged = true;
                        this.mCurWidth = w;
                    }
                    if (this.mCurHeight != h) {
                        sizeChanged = true;
                        this.mCurHeight = h;
                    }
                    Rect contentInsets = windowInsets.getSystemWindowInsets().toRect();
                    Rect stableInsets = windowInsets.getStableInsets().toRect();
                    DisplayCutout displayCutout = windowInsets.getDisplayCutout() != null ? windowInsets.getDisplayCutout() : rawCutout;
                    insetsChanged |= !this.mDispatchedContentInsets.equals(contentInsets);
                    insetsChanged |= !this.mDispatchedStableInsets.equals(stableInsets);
                    insetsChanged |= !this.mDispatchedDisplayCutout.equals(displayCutout);
                    this.mSurfaceHolder.setSurfaceFrameSize(w, h);
                    this.mSurfaceHolder.mSurfaceLock.unlock();
                    if (!this.mSurfaceHolder.mSurface.isValid()) {
                        this.reportSurfaceDestroyed();
                        return;
                    }
                    boolean didSurface = false;
                    try {
                        SurfaceHolder.Callback[] callbacks;
                        this.mSurfaceHolder.ungetCallbacks();
                        if (surfaceCreating) {
                            this.mIsCreating = true;
                            didSurface = true;
                            this.onSurfaceCreated(this.mSurfaceHolder);
                            callbacks = this.mSurfaceHolder.getCallbacks();
                            if (callbacks != null) {
                                for (SurfaceHolder.Callback c : callbacks) {
                                    c.surfaceCreated(this.mSurfaceHolder);
                                }
                            }
                        }
                        redrawNeeded |= creating || (relayoutResult & 2) != 0;
                        if (forceReport || creating || surfaceCreating || formatChanged || sizeChanged) {
                            didSurface = true;
                            this.onSurfaceChanged(this.mSurfaceHolder, this.mFormat, this.mCurWidth, this.mCurHeight);
                            callbacks = this.mSurfaceHolder.getCallbacks();
                            if (callbacks != null) {
                                for (SurfaceHolder.Callback c : callbacks) {
                                    c.surfaceChanged(this.mSurfaceHolder, this.mFormat, this.mCurWidth, this.mCurHeight);
                                }
                            }
                        }
                        if (insetsChanged) {
                            this.mDispatchedContentInsets.set(contentInsets);
                            this.mDispatchedStableInsets.set(stableInsets);
                            this.mDispatchedDisplayCutout = displayCutout;
                            this.onApplyWindowInsets(windowInsets);
                        }
                        if (redrawNeeded) {
                            this.onSurfaceRedrawNeeded(this.mSurfaceHolder);
                            callbacks = this.mSurfaceHolder.getCallbacks();
                            if (callbacks != null) {
                                for (SurfaceHolder.Callback c : callbacks) {
                                    if (!(c instanceof SurfaceHolder.Callback2)) continue;
                                    ((SurfaceHolder.Callback2)c).surfaceRedrawNeeded(this.mSurfaceHolder);
                                }
                            }
                        }
                        if (didSurface && !this.mReportedVisible) {
                            if (this.mIsCreating) {
                                this.onVisibilityChanged(true);
                            }
                            this.onVisibilityChanged(false);
                        }
                    }
                    finally {
                        this.mIsCreating = false;
                        this.mSurfaceCreated = true;
                        if (redrawNeeded) {
                            this.resetWindowPages();
                            this.mSession.finishDrawing(this.mWindow, null);
                            this.processLocalColors(this.mPendingXOffset, this.mPendingXOffsetStep);
                        }
                        this.reposition();
                        this.mIWallpaperEngine.reportShown();
                    }
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
        }

        private void scalePreview(Rect position) {
            if (this.isPreview() && this.mPreviewSurfacePosition == null && position != null || this.mPreviewSurfacePosition != null && !this.mPreviewSurfacePosition.equals(position)) {
                this.mPreviewSurfacePosition = position;
                if (this.mSurfaceControl.isValid()) {
                    this.reposition();
                } else {
                    this.updateSurface(false, false, false);
                }
            }
        }

        private void reposition() {
            if (this.mPreviewSurfacePosition == null) {
                return;
            }
            this.mTmpMatrix.setTranslate(this.mPreviewSurfacePosition.left, this.mPreviewSurfacePosition.top);
            this.mTmpMatrix.postScale((float)this.mPreviewSurfacePosition.width() / (float)this.mCurWidth, (float)this.mPreviewSurfacePosition.height() / (float)this.mCurHeight);
            this.mTmpMatrix.getValues(this.mTmpValues);
            SurfaceControl.Transaction t = new SurfaceControl.Transaction();
            t.setPosition(this.mSurfaceControl, this.mPreviewSurfacePosition.left, this.mPreviewSurfacePosition.top);
            t.setMatrix(this.mSurfaceControl, this.mTmpValues[0], this.mTmpValues[3], this.mTmpValues[1], this.mTmpValues[4]);
            t.apply();
        }

        void attach(IWallpaperEngineWrapper wrapper) {
            if (this.mDestroyed) {
                return;
            }
            this.mIWallpaperEngine = wrapper;
            this.mCaller = wrapper.mCaller;
            this.mConnection = wrapper.mConnection;
            this.mWindowToken = wrapper.mWindowToken;
            this.mSurfaceHolder.setSizeFromLayout();
            this.mInitializing = true;
            this.mSession = WindowManagerGlobal.getWindowSession();
            this.mWindow.setSession(this.mSession);
            this.mLayout.packageName = WallpaperService.this.getPackageName();
            this.mIWallpaperEngine.mDisplayManager.registerDisplayListener(this.mDisplayListener, this.mCaller.getHandler());
            this.mDisplay = this.mIWallpaperEngine.mDisplay;
            this.mDisplayContext = WallpaperService.this.createDisplayContext(this.mDisplay).createWindowContext(2013, null);
            this.mWallpaperDimAmount = this.mDisplayContext.getResources().getFloat(17105115);
            this.mDisplayState = this.mDisplay.getState();
            this.onCreate(this.mSurfaceHolder);
            this.mInitializing = false;
            this.mReportedVisible = false;
            this.updateSurface(false, false, false);
        }

        public Context getDisplayContext() {
            return this.mDisplayContext;
        }

        @VisibleForTesting
        public void doAmbientModeChanged(boolean inAmbientMode, long animationDuration) {
            if (!this.mDestroyed) {
                this.mIsInAmbientMode = inAmbientMode;
                if (this.mCreated) {
                    this.onAmbientModeChanged(inAmbientMode, animationDuration);
                }
            }
        }

        void doDesiredSizeChanged(int desiredWidth, int desiredHeight) {
            if (!this.mDestroyed) {
                this.mIWallpaperEngine.mReqWidth = desiredWidth;
                this.mIWallpaperEngine.mReqHeight = desiredHeight;
                this.onDesiredSizeChanged(desiredWidth, desiredHeight);
                this.doOffsetsChanged(true);
            }
        }

        void doDisplayPaddingChanged(Rect padding) {
            if (!this.mDestroyed && !this.mIWallpaperEngine.mDisplayPadding.equals(padding)) {
                this.mIWallpaperEngine.mDisplayPadding.set(padding);
                this.updateSurface(true, false, false);
            }
        }

        void doVisibilityChanged(boolean visible) {
            if (!this.mDestroyed) {
                this.mVisible = visible;
                this.reportVisibility();
                if (visible) {
                    this.processLocalColors(this.mPendingXOffset, this.mPendingXOffsetStep);
                }
            }
        }

        void reportVisibility() {
            if (!this.mDestroyed) {
                boolean visible;
                this.mDisplayState = this.mDisplay == null ? 0 : this.mDisplay.getState();
                boolean bl = visible = this.mVisible && this.mDisplayState != 1;
                if (this.mReportedVisible != visible) {
                    this.mReportedVisible = visible;
                    if (visible) {
                        this.doOffsetsChanged(false);
                        this.updateSurface(true, false, false);
                    }
                    this.onVisibilityChanged(visible);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void doOffsetsChanged(boolean always) {
            boolean sync;
            float yOffsetStep;
            float xOffsetStep;
            float yOffset;
            float xOffset;
            if (this.mDestroyed) {
                return;
            }
            if (!always && !this.mOffsetsChanged) {
                return;
            }
            Object object = this.mLock;
            synchronized (object) {
                xOffset = this.mPendingXOffset;
                yOffset = this.mPendingYOffset;
                xOffsetStep = this.mPendingXOffsetStep;
                yOffsetStep = this.mPendingYOffsetStep;
                sync = this.mPendingSync;
                this.mPendingSync = false;
                this.mOffsetMessageEnqueued = false;
            }
            if (this.mSurfaceCreated) {
                if (this.mReportedVisible) {
                    int availw = this.mIWallpaperEngine.mReqWidth - this.mCurWidth;
                    int xPixels = availw > 0 ? -((int)((float)availw * xOffset + 0.5f)) : 0;
                    int availh = this.mIWallpaperEngine.mReqHeight - this.mCurHeight;
                    int yPixels = availh > 0 ? -((int)((float)availh * yOffset + 0.5f)) : 0;
                    this.onOffsetsChanged(xOffset, yOffset, xOffsetStep, yOffsetStep, xPixels, yPixels);
                } else {
                    this.mOffsetsChanged = true;
                }
            }
            if (sync) {
                try {
                    this.mSession.wallpaperOffsetsComplete(this.mWindow.asBinder());
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
            this.processLocalColors(xOffset, xOffsetStep);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processLocalColors(float xOffset, float xOffsetStep) {
            EngineWindowPage current;
            int xPages;
            int xPage;
            if (this.supportsLocalColorExtraction()) {
                return;
            }
            if (xOffset % xOffsetStep > 0.05f || !this.mSurfaceHolder.getSurface().isValid()) {
                return;
            }
            if (!this.validStep(xOffsetStep)) {
                xOffset = 0.0f;
                xOffsetStep = 1.0f;
                xPage = 0;
                xPages = 1;
            } else {
                xPages = Math.round(1.0f / xOffsetStep) + 1;
                xOffsetStep = 1.0f / (float)xPages;
                float shrink = (float)(xPages - 1) / (float)xPages;
                xPage = Math.round((xOffset *= shrink) / xOffsetStep);
            }
            Object object = this.mLock;
            synchronized (object) {
                if (this.mWindowPages.length == 0 || this.mWindowPages.length != xPages) {
                    this.mWindowPages = new EngineWindowPage[xPages];
                    this.initWindowPages(this.mWindowPages, xOffsetStep);
                }
                if (this.mLocalColorsToAdd.size() != 0) {
                    for (RectF colorArea : this.mLocalColorsToAdd) {
                        if (!WallpaperService.this.isValid(colorArea)) continue;
                        this.mLocalColorAreas.add(colorArea);
                        int colorPage = this.getRectFPage(colorArea, xOffsetStep);
                        EngineWindowPage currentPage = this.mWindowPages[colorPage];
                        if (currentPage == null) {
                            currentPage = new EngineWindowPage();
                            currentPage.addArea(colorArea);
                            this.mWindowPages[colorPage] = currentPage;
                            continue;
                        }
                        currentPage.setLastUpdateTime(0L);
                        currentPage.removeColor(colorArea);
                    }
                    this.mLocalColorsToAdd.clear();
                }
                if (xPage >= this.mWindowPages.length) {
                    xPage = this.mWindowPages.length - 1;
                }
                if ((current = this.mWindowPages[xPage]) == null) {
                    this.mWindowPages[xPage] = current = new EngineWindowPage();
                }
            }
            this.updatePage(current, xPage, xPages, xOffsetStep);
        }

        private void initWindowPages(EngineWindowPage[] windowPages, float step) {
            for (int i = 0; i < windowPages.length; ++i) {
                windowPages[i] = new EngineWindowPage();
            }
            this.mLocalColorAreas.addAll(this.mLocalColorsToAdd);
            this.mLocalColorsToAdd.clear();
            for (RectF area : this.mLocalColorAreas) {
                if (!WallpaperService.this.isValid(area)) {
                    this.mLocalColorAreas.remove(area);
                    continue;
                }
                int pageNum = this.getRectFPage(area, step);
                windowPages[pageNum].addArea(area);
            }
        }

        void updatePage(EngineWindowPage currentPage, int pageIndx, int numPages, float xOffsetStep) {
            Bitmap screenShot;
            long current = SystemClock.elapsedRealtime();
            long lapsed = current - currentPage.getLastUpdateTime();
            if (lapsed < 60000L && currentPage.getLastUpdateTime() > 0L) {
                return;
            }
            Surface surface2 = this.mSurfaceHolder.getSurface();
            boolean widthIsLarger = this.mSurfaceSize.x > this.mSurfaceSize.y;
            int smaller = widthIsLarger ? this.mSurfaceSize.x : this.mSurfaceSize.y;
            float ratio = 64.0f / (float)smaller;
            int width = (int)(ratio * (float)this.mSurfaceSize.x);
            int height = (int)(ratio * (float)this.mSurfaceSize.y);
            if (width <= 0 || height <= 0) {
                Log.e(WallpaperService.TAG, "wrong width and height values of bitmap " + width + " " + height);
                return;
            }
            Bitmap finalScreenShot = screenShot = Bitmap.createBitmap(width, height, Bitmap.Config.ARGB_8888);
            Trace.beginSection("WallpaperService#pixelCopy");
            PixelCopy.request(surface2, screenShot, res -> {
                Trace.endSection();
                if (res != 0) {
                    Bitmap lastBitmap = currentPage.getBitmap();
                    currentPage.execSync(p -> p.setBitmap(this.mLastScreenshot));
                    Bitmap lastScreenshot = this.mLastScreenshot;
                    if (lastScreenshot != null && !lastScreenshot.isRecycled() && !Objects.equals(lastBitmap, lastScreenshot)) {
                        this.updatePageColors(currentPage, pageIndx, numPages, xOffsetStep);
                    }
                } else {
                    this.mLastScreenshot = finalScreenShot;
                    currentPage.execSync(p -> {
                        p.setBitmap(finalScreenShot);
                        p.setLastUpdateTime(current);
                    });
                    this.updatePageColors(currentPage, pageIndx, numPages, xOffsetStep);
                }
            }, this.mHandler);
        }

        private void updatePageColors(EngineWindowPage page, int pageIndx, int numPages, float xOffsetStep) {
            if (page.getBitmap() == null) {
                return;
            }
            for (RectF area : page.getAreas()) {
                Bitmap target;
                if (area == null) continue;
                RectF subArea = this.generateSubRect(area, pageIndx, numPages);
                Bitmap b = page.getBitmap();
                int x = Math.round((float)b.getWidth() * subArea.left);
                int y = Math.round((float)b.getHeight() * subArea.top);
                int width = Math.round((float)b.getWidth() * subArea.width());
                int height = Math.round((float)b.getHeight() * subArea.height());
                try {
                    target = Bitmap.createBitmap(page.getBitmap(), x, y, width, height);
                }
                catch (Exception e) {
                    Log.e(WallpaperService.TAG, "Error creating page local color bitmap", e);
                    continue;
                }
                WallpaperColors color2 = WallpaperColors.fromBitmap(target);
                target.recycle();
                WallpaperColors currentColor = page.getColors(area);
                if (currentColor != null && color2.equals(currentColor)) continue;
                page.addWallpaperColors(area, color2);
                try {
                    this.mConnection.onLocalWallpaperColorsChanged(area, color2, this.mDisplayContext.getDisplayId());
                }
                catch (RemoteException e) {
                    Log.e(WallpaperService.TAG, "Error calling Connection.onLocalWallpaperColorsChanged", e);
                }
            }
        }

        private RectF generateSubRect(RectF in, int pageInx, int numPages) {
            float minLeft = (float)pageInx / (float)numPages;
            float maxRight = (float)(pageInx + 1) / (float)numPages;
            float left = in.left;
            float right2 = in.right;
            if (left < minLeft) {
                left = minLeft;
            }
            if (right2 > maxRight) {
                right2 = maxRight;
            }
            left = left * (float)numPages % 1.0f;
            if ((right2 = right2 * (float)numPages % 1.0f) == 0.0f) {
                right2 = 1.0f;
            }
            return new RectF(left, in.top, right2, in.bottom);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void resetWindowPages() {
            if (this.supportsLocalColorExtraction()) {
                return;
            }
            this.mLastWindowPage = -1;
            Object object = this.mLock;
            synchronized (object) {
                for (int i = 0; i < this.mWindowPages.length; ++i) {
                    EngineWindowPage page = this.mWindowPages[i];
                    if (page == null) continue;
                    page.execSync(p -> p.setLastUpdateTime(0L));
                }
            }
        }

        private int getRectFPage(RectF area, float step) {
            if (!WallpaperService.this.isValid(area)) {
                return 0;
            }
            if (!this.validStep(step)) {
                return 0;
            }
            int pages = Math.round(1.0f / step);
            int page = Math.round(area.centerX() * (float)pages);
            if (page == pages) {
                return pages - 1;
            }
            if (page == this.mWindowPages.length) {
                page = this.mWindowPages.length - 1;
            }
            return page;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addLocalColorsAreas(List<RectF> regions) {
            if (this.supportsLocalColorExtraction()) {
                return;
            }
            float step = this.mPendingXOffsetStep;
            List<WallpaperColors> colors = this.getLocalWallpaperColors(regions);
            Object object = this.mLock;
            synchronized (object) {
                if (!this.validStep(step)) {
                    step = 0.0f;
                }
                for (int i = 0; i < regions.size(); ++i) {
                    RectF area = regions.get(i);
                    if (!WallpaperService.this.isValid(area)) continue;
                    int pageInx = this.getRectFPage(area, step);
                    EngineWindowPage page = this.mWindowPages[pageInx];
                    if (page != null) {
                        this.mLocalColorAreas.add(area);
                        page.addArea(area);
                        WallpaperColors color2 = colors.get(i);
                        if (color2 == null || color2.equals(page.getColors(area))) continue;
                        page.execSync(p -> p.addWallpaperColors(area, color2));
                        continue;
                    }
                    this.mLocalColorsToAdd.add(area);
                }
            }
            for (int i = 0; i < colors.size() && colors.get(i) != null; ++i) {
                try {
                    this.mConnection.onLocalWallpaperColorsChanged(regions.get(i), colors.get(i), this.mDisplayContext.getDisplayId());
                    continue;
                }
                catch (RemoteException e) {
                    Log.e(WallpaperService.TAG, "Error calling Connection.onLocalWallpaperColorsChanged", e);
                    return;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeLocalColorsAreas(List<RectF> regions) {
            if (this.supportsLocalColorExtraction()) {
                return;
            }
            Object object = this.mLock;
            synchronized (object) {
                float step = this.mPendingXOffsetStep;
                this.mLocalColorsToAdd.removeAll(regions);
                this.mLocalColorAreas.removeAll(regions);
                if (!this.validStep(step)) {
                    return;
                }
                for (int i = 0; i < regions.size(); ++i) {
                    int pageInx;
                    EngineWindowPage page;
                    RectF area = regions.get(i);
                    if (!WallpaperService.this.isValid(area) || (page = this.mWindowPages[pageInx = this.getRectFPage(area, step)]) == null) continue;
                    page.execSync(p -> p.removeArea(area));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private List<WallpaperColors> getLocalWallpaperColors(List<RectF> areas) {
            ArrayList<WallpaperColors> colors = new ArrayList<WallpaperColors>(areas.size());
            float step = this.mPendingXOffsetStep;
            if (!this.validStep(step)) {
                step = 1.0f;
            }
            for (int i = 0; i < areas.size(); ++i) {
                EngineWindowPage page;
                RectF area;
                int pageIndx;
                RectF currentArea = areas.get(i);
                if (currentArea == null || !WallpaperService.this.isValid(currentArea)) {
                    Log.wtf(WallpaperService.TAG, "invalid local area " + currentArea);
                    continue;
                }
                Object object = this.mLock;
                synchronized (object) {
                    pageIndx = this.getRectFPage(currentArea, step);
                    if (this.mWindowPages.length == 0 || pageIndx < 0 || pageIndx > this.mWindowPages.length || !WallpaperService.this.isValid(currentArea)) {
                        colors.add(null);
                        continue;
                    }
                    area = this.generateSubRect(currentArea, pageIndx, this.mWindowPages.length);
                    page = this.mWindowPages[pageIndx];
                }
                if (page == null) {
                    colors.add(null);
                    continue;
                }
                float finalStep = step;
                int finalPageIndx = pageIndx;
                Bitmap screenShot = page.getBitmap();
                if (screenShot == null) {
                    screenShot = this.mLastScreenshot;
                }
                if (screenShot == null || screenShot.isRecycled()) {
                    page.setLastUpdateTime(0L);
                    colors.add(null);
                    continue;
                }
                Bitmap b = screenShot;
                Rect subImage = new Rect(Math.round(area.left * (float)b.getWidth() / finalStep), Math.round(area.top * (float)b.getHeight()), Math.round(area.right * (float)b.getWidth() / finalStep), Math.round(area.bottom * (float)b.getHeight()));
                subImage = this.fixRect(b, subImage);
                Bitmap colorImg = Bitmap.createBitmap(screenShot, subImage.left, subImage.top, subImage.width(), subImage.height());
                WallpaperColors color2 = WallpaperColors.fromBitmap(colorImg);
                colors.add(color2);
            }
            return colors;
        }

        private Rect fixRect(Bitmap b, Rect r) {
            r.left = r.left >= r.right || r.left >= b.getWidth() || r.left > 0 ? 0 : r.left;
            r.right = r.left >= r.right || r.right > b.getWidth() ? b.getWidth() : r.right;
            return r;
        }

        private boolean validStep(float step) {
            return !PROHIBITED_STEPS.contains(Float.valueOf(step)) && (double)step > 0.0 && (double)step <= 1.0;
        }

        void doCommand(WallpaperCommand cmd) {
            Bundle result = !this.mDestroyed ? this.onCommand(cmd.action, cmd.x, cmd.y, cmd.z, cmd.extras, cmd.sync) : null;
            if (cmd.sync) {
                try {
                    this.mSession.wallpaperCommandComplete(this.mWindow.asBinder(), result);
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
        }

        void reportSurfaceDestroyed() {
            if (this.mSurfaceCreated) {
                this.mSurfaceCreated = false;
                this.mSurfaceHolder.ungetCallbacks();
                SurfaceHolder.Callback[] callbacks = this.mSurfaceHolder.getCallbacks();
                if (callbacks != null) {
                    for (SurfaceHolder.Callback c : callbacks) {
                        c.surfaceDestroyed(this.mSurfaceHolder);
                    }
                }
                this.onSurfaceDestroyed(this.mSurfaceHolder);
            }
        }

        void detach() {
            if (this.mDestroyed) {
                return;
            }
            this.mDestroyed = true;
            if (this.mIWallpaperEngine.mDisplayManager != null) {
                this.mIWallpaperEngine.mDisplayManager.unregisterDisplayListener(this.mDisplayListener);
            }
            if (this.mVisible) {
                this.mVisible = false;
                this.onVisibilityChanged(false);
            }
            this.reportSurfaceDestroyed();
            this.onDestroy();
            if (this.mCreated) {
                try {
                    if (this.mInputEventReceiver != null) {
                        this.mInputEventReceiver.dispose();
                        this.mInputEventReceiver = null;
                    }
                    this.mSession.remove(this.mWindow);
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
                this.mSurfaceHolder.mSurface.release();
                if (this.mBlastBufferQueue != null) {
                    this.mBlastBufferQueue.destroy();
                    this.mBlastBufferQueue = null;
                }
                if (this.mBbqSurfaceControl != null) {
                    new SurfaceControl.Transaction().remove(this.mBbqSurfaceControl).apply();
                    this.mBbqSurfaceControl = null;
                }
                this.mCreated = false;
            }
        }

        private Surface getOrCreateBLASTSurface(int width, int height, int format) {
            Surface ret = null;
            if (this.mBlastBufferQueue == null) {
                this.mBlastBufferQueue = new BLASTBufferQueue("Wallpaper", this.mBbqSurfaceControl, width, height, format);
                ret = this.mBlastBufferQueue.createSurface();
            } else {
                this.mBlastBufferQueue.update(this.mBbqSurfaceControl, width, height, format);
            }
            return ret;
        }

        class WallpaperInputEventReceiver
        extends InputEventReceiver {
            public WallpaperInputEventReceiver(InputChannel inputChannel, Looper looper) {
                super(inputChannel, looper);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onInputEvent(InputEvent event) {
                boolean handled = false;
                try {
                    if (event instanceof MotionEvent && (event.getSource() & 2) != 0) {
                        MotionEvent dup = MotionEvent.obtainNoHistory((MotionEvent)event);
                        Engine.this.dispatchPointer(dup);
                        handled = true;
                    }
                }
                finally {
                    this.finishInputEvent(event, handled);
                }
            }
        }
    }

    static class WallpaperCommand {
        String action;
        int x;
        int y;
        int z;
        Bundle extras;
        boolean sync;

        WallpaperCommand() {
        }
    }
}

