/*
 * Decompiled with CFR 0.152.
 */
package android.security.keystore2;

import android.security.KeyStoreSecurityLevel;
import android.system.keystore2.Authorization;
import android.system.keystore2.KeyDescriptor;
import java.security.Key;

public class AndroidKeyStoreKey
implements Key {
    private final KeyDescriptor mDescriptor;
    private final long mKeyId;
    private final Authorization[] mAuthorizations;
    private final String mAlgorithm;
    private final KeyStoreSecurityLevel mSecurityLevel;

    AndroidKeyStoreKey(KeyDescriptor descriptor, long keyId, Authorization[] authorizations, String algorithm, KeyStoreSecurityLevel securityLevel) {
        this.mDescriptor = descriptor;
        this.mKeyId = keyId;
        this.mAuthorizations = authorizations;
        this.mAlgorithm = algorithm;
        this.mSecurityLevel = securityLevel;
    }

    KeyDescriptor getUserKeyDescriptor() {
        return this.mDescriptor;
    }

    KeyDescriptor getKeyIdDescriptor() {
        KeyDescriptor descriptor = new KeyDescriptor();
        descriptor.nspace = this.mKeyId;
        descriptor.domain = 4;
        descriptor.alias = null;
        descriptor.blob = null;
        return descriptor;
    }

    Authorization[] getAuthorizations() {
        return this.mAuthorizations;
    }

    KeyStoreSecurityLevel getSecurityLevel() {
        return this.mSecurityLevel;
    }

    @Override
    public String getAlgorithm() {
        return this.mAlgorithm;
    }

    @Override
    public String getFormat() {
        return null;
    }

    @Override
    public byte[] getEncoded() {
        return null;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.mDescriptor == null ? 0 : this.mDescriptor.hashCode());
        result = 31 * result + (int)(this.mKeyId >>> 32);
        result = 31 * result + (int)(this.mKeyId & 0xFFFFFFFFFFFFFFFFL);
        result = 31 * result + (this.mAuthorizations == null ? 0 : this.mAuthorizations.hashCode());
        result = 31 * result + (this.mAlgorithm == null ? 0 : this.mAlgorithm.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AndroidKeyStoreKey other = (AndroidKeyStoreKey)obj;
        return this.mKeyId == other.mKeyId;
    }
}

