/*
 * Decompiled with CFR 0.152.
 */
package android.scheduling;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.scheduling.IRequestRebootReadinessStatusListener;

public interface IRebootReadinessManager
extends IInterface {
    public static final String DESCRIPTOR = "android.scheduling.IRebootReadinessManager";

    public void markRebootPending(String var1) throws RemoteException;

    public void cancelPendingReboot(String var1) throws RemoteException;

    public boolean isReadyToReboot() throws RemoteException;

    public void addRequestRebootReadinessStatusListener(IRequestRebootReadinessStatusListener var1) throws RemoteException;

    public void removeRequestRebootReadinessStatusListener(IRequestRebootReadinessStatusListener var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IRebootReadinessManager {
        static final int TRANSACTION_markRebootPending = 1;
        static final int TRANSACTION_cancelPendingReboot = 2;
        static final int TRANSACTION_isReadyToReboot = 3;
        static final int TRANSACTION_addRequestRebootReadinessStatusListener = 4;
        static final int TRANSACTION_removeRequestRebootReadinessStatusListener = 5;

        public Stub() {
            this.attachInterface(this, IRebootReadinessManager.DESCRIPTOR);
        }

        public static IRebootReadinessManager asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IRebootReadinessManager.DESCRIPTOR);
            if (iin != null && iin instanceof IRebootReadinessManager) {
                return (IRebootReadinessManager)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IRebootReadinessManager.DESCRIPTOR;
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    this.markRebootPending(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 2: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    this.cancelPendingReboot(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 3: {
                    data.enforceInterface(descriptor);
                    boolean _result = this.isReadyToReboot();
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 4: {
                    data.enforceInterface(descriptor);
                    IRequestRebootReadinessStatusListener _arg0 = IRequestRebootReadinessStatusListener.Stub.asInterface(data.readStrongBinder());
                    this.addRequestRebootReadinessStatusListener(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 5: {
                    data.enforceInterface(descriptor);
                    IRequestRebootReadinessStatusListener _arg0 = IRequestRebootReadinessStatusListener.Stub.asInterface(data.readStrongBinder());
                    this.removeRequestRebootReadinessStatusListener(_arg0);
                    reply.writeNoException();
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        public static boolean setDefaultImpl(IRebootReadinessManager impl) {
            if (Proxy.sDefaultImpl != null) {
                throw new IllegalStateException("setDefaultImpl() called twice");
            }
            if (impl != null) {
                Proxy.sDefaultImpl = impl;
                return true;
            }
            return false;
        }

        public static IRebootReadinessManager getDefaultImpl() {
            return Proxy.sDefaultImpl;
        }

        private static class Proxy
        implements IRebootReadinessManager {
            private IBinder mRemote;
            public static IRebootReadinessManager sDefaultImpl;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IRebootReadinessManager.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void markRebootPending(String callingPackage) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IRebootReadinessManager.DESCRIPTOR);
                    _data.writeString(callingPackage);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().markRebootPending(callingPackage);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void cancelPendingReboot(String callingPackage) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IRebootReadinessManager.DESCRIPTOR);
                    _data.writeString(callingPackage);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().cancelPendingReboot(callingPackage);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isReadyToReboot() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IRebootReadinessManager.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().isReadyToReboot();
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addRequestRebootReadinessStatusListener(IRequestRebootReadinessStatusListener listener2) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IRebootReadinessManager.DESCRIPTOR);
                    _data.writeStrongBinder(listener2 != null ? listener2.asBinder() : null);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().addRequestRebootReadinessStatusListener(listener2);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeRequestRebootReadinessStatusListener(IRequestRebootReadinessStatusListener listener2) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IRebootReadinessManager.DESCRIPTOR);
                    _data.writeStrongBinder(listener2 != null ? listener2.asBinder() : null);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().removeRequestRebootReadinessStatusListener(listener2);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IRebootReadinessManager {
        @Override
        public void markRebootPending(String callingPackage) throws RemoteException {
        }

        @Override
        public void cancelPendingReboot(String callingPackage) throws RemoteException {
        }

        @Override
        public boolean isReadyToReboot() throws RemoteException {
            return false;
        }

        @Override
        public void addRequestRebootReadinessStatusListener(IRequestRebootReadinessStatusListener listener2) throws RemoteException {
        }

        @Override
        public void removeRequestRebootReadinessStatusListener(IRequestRebootReadinessStatusListener listener2) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

