/*
 * Decompiled with CFR 0.152.
 */
package android.print;

import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.app.Activity;
import android.app.Application;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.ComponentName;
import android.content.Context;
import android.content.IntentSender;
import android.graphics.drawable.Icon;
import android.os.Bundle;
import android.os.CancellationSignal;
import android.os.Handler;
import android.os.ICancellationSignal;
import android.os.Looper;
import android.os.Message;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.print.ILayoutResultCallback;
import android.print.IPrintDocumentAdapter;
import android.print.IPrintDocumentAdapterObserver;
import android.print.IPrintJobStateChangeListener;
import android.print.IPrintManager;
import android.print.IPrintServicesChangeListener;
import android.print.IWriteResultCallback;
import android.print.PageRange;
import android.print.PrintAttributes;
import android.print.PrintDocumentAdapter;
import android.print.PrintDocumentInfo;
import android.print.PrintJob;
import android.print.PrintJobId;
import android.print.PrintJobInfo;
import android.print.PrinterDiscoverySession;
import android.print.PrinterId;
import android.printservice.PrintServiceInfo;
import android.printservice.recommendation.IRecommendationsChangeListener;
import android.printservice.recommendation.RecommendationInfo;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.Log;
import com.android.internal.os.SomeArgs;
import com.android.internal.util.Preconditions;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import libcore.io.IoUtils;

public class PrintManager {
    private static final String LOG_TAG = "PrintManager";
    private static final boolean DEBUG = false;
    private static final int MSG_NOTIFY_PRINT_JOB_STATE_CHANGED = 1;
    public static final String PRINT_SPOOLER_PACKAGE_NAME = "com.android.printspooler";
    @SystemApi
    public static final int ENABLED_SERVICES = 1;
    public static final int DISABLED_SERVICES = 2;
    public static final int ALL_SERVICES = 3;
    public static final String ACTION_PRINT_DIALOG = "android.print.PRINT_DIALOG";
    public static final String EXTRA_PRINT_DIALOG_INTENT = "android.print.intent.extra.EXTRA_PRINT_DIALOG_INTENT";
    public static final String EXTRA_PRINT_JOB = "android.print.intent.extra.EXTRA_PRINT_JOB";
    public static final String EXTRA_PRINT_DOCUMENT_ADAPTER = "android.print.intent.extra.EXTRA_PRINT_DOCUMENT_ADAPTER";
    public static final int APP_ID_ANY = -2;
    private final Context mContext;
    private final IPrintManager mService;
    private final int mUserId;
    private final int mAppId;
    private final Handler mHandler;
    private Map<PrintJobStateChangeListener, PrintJobStateChangeListenerWrapper> mPrintJobStateChangeListeners;
    private Map<PrintServicesChangeListener, PrintServicesChangeListenerWrapper> mPrintServicesChangeListeners;
    private Map<PrintServiceRecommendationsChangeListener, PrintServiceRecommendationsChangeListenerWrapper> mPrintServiceRecommendationsChangeListeners;

    public PrintManager(Context context, IPrintManager service, int userId, int appId) {
        this.mContext = context;
        this.mService = service;
        this.mUserId = userId;
        this.mAppId = appId;
        this.mHandler = new Handler(context.getMainLooper(), null, false){

            @Override
            public void handleMessage(Message message) {
                switch (message.what) {
                    case 1: {
                        SomeArgs args = (SomeArgs)message.obj;
                        PrintJobStateChangeListenerWrapper wrapper = (PrintJobStateChangeListenerWrapper)args.arg1;
                        PrintJobStateChangeListener listener2 = wrapper.getListener();
                        if (listener2 != null) {
                            PrintJobId printJobId = (PrintJobId)args.arg2;
                            listener2.onPrintJobStateChanged(printJobId);
                        }
                        args.recycle();
                    }
                }
            }
        };
    }

    public PrintManager getGlobalPrintManagerForUser(int userId) {
        if (this.mService == null) {
            Log.w(LOG_TAG, "Feature android.software.print not available");
            return null;
        }
        return new PrintManager(this.mContext, this.mService, userId, -2);
    }

    PrintJobInfo getPrintJobInfo(PrintJobId printJobId) {
        try {
            return this.mService.getPrintJobInfo(printJobId, this.mAppId, this.mUserId);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @UnsupportedAppUsage
    public void addPrintJobStateChangeListener(PrintJobStateChangeListener listener2) {
        if (this.mService == null) {
            Log.w(LOG_TAG, "Feature android.software.print not available");
            return;
        }
        if (this.mPrintJobStateChangeListeners == null) {
            this.mPrintJobStateChangeListeners = new ArrayMap<PrintJobStateChangeListener, PrintJobStateChangeListenerWrapper>();
        }
        PrintJobStateChangeListenerWrapper wrappedListener = new PrintJobStateChangeListenerWrapper(listener2, this.mHandler);
        try {
            this.mService.addPrintJobStateChangeListener(wrappedListener, this.mAppId, this.mUserId);
            this.mPrintJobStateChangeListeners.put(listener2, wrappedListener);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    public void removePrintJobStateChangeListener(PrintJobStateChangeListener listener2) {
        if (this.mService == null) {
            Log.w(LOG_TAG, "Feature android.software.print not available");
            return;
        }
        if (this.mPrintJobStateChangeListeners == null) {
            return;
        }
        PrintJobStateChangeListenerWrapper wrappedListener = this.mPrintJobStateChangeListeners.remove(listener2);
        if (wrappedListener == null) {
            return;
        }
        if (this.mPrintJobStateChangeListeners.isEmpty()) {
            this.mPrintJobStateChangeListeners = null;
        }
        wrappedListener.destroy();
        try {
            this.mService.removePrintJobStateChangeListener(wrappedListener, this.mUserId);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    public PrintJob getPrintJob(PrintJobId printJobId) {
        if (this.mService == null) {
            Log.w(LOG_TAG, "Feature android.software.print not available");
            return null;
        }
        try {
            PrintJobInfo printJob = this.mService.getPrintJobInfo(printJobId, this.mAppId, this.mUserId);
            if (printJob != null) {
                return new PrintJob(printJob, this);
            }
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
        return null;
    }

    public Icon getCustomPrinterIcon(PrinterId printerId) {
        if (this.mService == null) {
            Log.w(LOG_TAG, "Feature android.software.print not available");
            return null;
        }
        try {
            return this.mService.getCustomPrinterIcon(printerId, this.mUserId);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    public List<PrintJob> getPrintJobs() {
        if (this.mService == null) {
            Log.w(LOG_TAG, "Feature android.software.print not available");
            return Collections.emptyList();
        }
        try {
            List<PrintJobInfo> printJobInfos = this.mService.getPrintJobInfos(this.mAppId, this.mUserId);
            if (printJobInfos == null) {
                return Collections.emptyList();
            }
            int printJobCount = printJobInfos.size();
            ArrayList<PrintJob> printJobs = new ArrayList<PrintJob>(printJobCount);
            for (int i = 0; i < printJobCount; ++i) {
                printJobs.add(new PrintJob(printJobInfos.get(i), this));
            }
            return printJobs;
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    void cancelPrintJob(PrintJobId printJobId) {
        if (this.mService == null) {
            Log.w(LOG_TAG, "Feature android.software.print not available");
            return;
        }
        try {
            this.mService.cancelPrintJob(printJobId, this.mAppId, this.mUserId);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    void restartPrintJob(PrintJobId printJobId) {
        if (this.mService == null) {
            Log.w(LOG_TAG, "Feature android.software.print not available");
            return;
        }
        try {
            this.mService.restartPrintJob(printJobId, this.mAppId, this.mUserId);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    public PrintJob print(String printJobName, PrintDocumentAdapter documentAdapter, PrintAttributes attributes) {
        if (this.mService == null) {
            Log.w(LOG_TAG, "Feature android.software.print not available");
            return null;
        }
        if (!(this.mContext instanceof Activity)) {
            throw new IllegalStateException("Can print only from an activity");
        }
        if (TextUtils.isEmpty(printJobName)) {
            throw new IllegalArgumentException("printJobName cannot be empty");
        }
        if (documentAdapter == null) {
            throw new IllegalArgumentException("documentAdapter cannot be null");
        }
        PrintDocumentAdapterDelegate delegate = new PrintDocumentAdapterDelegate((Activity)this.mContext, documentAdapter);
        try {
            Bundle result = this.mService.print(printJobName, delegate, attributes, this.mContext.getPackageName(), this.mAppId, this.mUserId);
            if (result != null) {
                PrintJobInfo printJob = (PrintJobInfo)result.getParcelable(EXTRA_PRINT_JOB);
                IntentSender intent = (IntentSender)result.getParcelable(EXTRA_PRINT_DIALOG_INTENT);
                if (printJob == null || intent == null) {
                    return null;
                }
                try {
                    this.mContext.startIntentSender(intent, null, 0, 0, 0);
                    return new PrintJob(printJob, this);
                }
                catch (IntentSender.SendIntentException sie) {
                    Log.e(LOG_TAG, "Couldn't start print job config activity.", sie);
                }
            }
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
        return null;
    }

    @SystemApi
    @RequiresPermission(value="android.permission.READ_PRINT_SERVICES")
    public void addPrintServicesChangeListener(PrintServicesChangeListener listener2, Handler handler) {
        Preconditions.checkNotNull(listener2);
        if (handler == null) {
            handler = this.mHandler;
        }
        if (this.mService == null) {
            Log.w(LOG_TAG, "Feature android.software.print not available");
            return;
        }
        if (this.mPrintServicesChangeListeners == null) {
            this.mPrintServicesChangeListeners = new ArrayMap<PrintServicesChangeListener, PrintServicesChangeListenerWrapper>();
        }
        PrintServicesChangeListenerWrapper wrappedListener = new PrintServicesChangeListenerWrapper(listener2, handler);
        try {
            this.mService.addPrintServicesChangeListener(wrappedListener, this.mUserId);
            this.mPrintServicesChangeListeners.put(listener2, wrappedListener);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.READ_PRINT_SERVICES")
    public void removePrintServicesChangeListener(PrintServicesChangeListener listener2) {
        Preconditions.checkNotNull(listener2);
        if (this.mService == null) {
            Log.w(LOG_TAG, "Feature android.software.print not available");
            return;
        }
        if (this.mPrintServicesChangeListeners == null) {
            return;
        }
        PrintServicesChangeListenerWrapper wrappedListener = this.mPrintServicesChangeListeners.remove(listener2);
        if (wrappedListener == null) {
            return;
        }
        if (this.mPrintServicesChangeListeners.isEmpty()) {
            this.mPrintServicesChangeListeners = null;
        }
        wrappedListener.destroy();
        try {
            this.mService.removePrintServicesChangeListener(wrappedListener, this.mUserId);
        }
        catch (RemoteException re) {
            Log.e(LOG_TAG, "Error removing print services change listener", re);
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.READ_PRINT_SERVICES")
    public List<PrintServiceInfo> getPrintServices(int selectionFlags) {
        Preconditions.checkFlagsArgument(selectionFlags, 3);
        try {
            List<PrintServiceInfo> services = this.mService.getPrintServices(selectionFlags, this.mUserId);
            if (services != null) {
                return services;
            }
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
        return Collections.emptyList();
    }

    @SystemApi
    @RequiresPermission(value="android.permission.READ_PRINT_SERVICE_RECOMMENDATIONS")
    public void addPrintServiceRecommendationsChangeListener(PrintServiceRecommendationsChangeListener listener2, Handler handler) {
        Preconditions.checkNotNull(listener2);
        if (handler == null) {
            handler = this.mHandler;
        }
        if (this.mService == null) {
            Log.w(LOG_TAG, "Feature android.software.print not available");
            return;
        }
        if (this.mPrintServiceRecommendationsChangeListeners == null) {
            this.mPrintServiceRecommendationsChangeListeners = new ArrayMap<PrintServiceRecommendationsChangeListener, PrintServiceRecommendationsChangeListenerWrapper>();
        }
        PrintServiceRecommendationsChangeListenerWrapper wrappedListener = new PrintServiceRecommendationsChangeListenerWrapper(listener2, handler);
        try {
            this.mService.addPrintServiceRecommendationsChangeListener(wrappedListener, this.mUserId);
            this.mPrintServiceRecommendationsChangeListeners.put(listener2, wrappedListener);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.READ_PRINT_SERVICE_RECOMMENDATIONS")
    public void removePrintServiceRecommendationsChangeListener(PrintServiceRecommendationsChangeListener listener2) {
        Preconditions.checkNotNull(listener2);
        if (this.mService == null) {
            Log.w(LOG_TAG, "Feature android.software.print not available");
            return;
        }
        if (this.mPrintServiceRecommendationsChangeListeners == null) {
            return;
        }
        PrintServiceRecommendationsChangeListenerWrapper wrappedListener = this.mPrintServiceRecommendationsChangeListeners.remove(listener2);
        if (wrappedListener == null) {
            return;
        }
        if (this.mPrintServiceRecommendationsChangeListeners.isEmpty()) {
            this.mPrintServiceRecommendationsChangeListeners = null;
        }
        wrappedListener.destroy();
        try {
            this.mService.removePrintServiceRecommendationsChangeListener(wrappedListener, this.mUserId);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.READ_PRINT_SERVICE_RECOMMENDATIONS")
    public List<RecommendationInfo> getPrintServiceRecommendations() {
        try {
            List<RecommendationInfo> recommendations = this.mService.getPrintServiceRecommendations(this.mUserId);
            if (recommendations != null) {
                return recommendations;
            }
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
        return Collections.emptyList();
    }

    public PrinterDiscoverySession createPrinterDiscoverySession() {
        if (this.mService == null) {
            Log.w(LOG_TAG, "Feature android.software.print not available");
            return null;
        }
        return new PrinterDiscoverySession(this.mService, this.mContext, this.mUserId);
    }

    public void setPrintServiceEnabled(ComponentName service, boolean isEnabled) {
        if (this.mService == null) {
            Log.w(LOG_TAG, "Feature android.software.print not available");
            return;
        }
        try {
            this.mService.setPrintServiceEnabled(service, isEnabled, this.mUserId);
        }
        catch (RemoteException re) {
            Log.e(LOG_TAG, "Error enabling or disabling " + service, re);
        }
    }

    public static class PrintServiceRecommendationsChangeListenerWrapper
    extends IRecommendationsChangeListener.Stub {
        private final WeakReference<PrintServiceRecommendationsChangeListener> mWeakListener;
        private final WeakReference<Handler> mWeakHandler;

        public PrintServiceRecommendationsChangeListenerWrapper(PrintServiceRecommendationsChangeListener listener2, Handler handler) {
            this.mWeakListener = new WeakReference<PrintServiceRecommendationsChangeListener>(listener2);
            this.mWeakHandler = new WeakReference<Handler>(handler);
        }

        @Override
        public void onRecommendationsChanged() {
            Handler handler = (Handler)this.mWeakHandler.get();
            PrintServiceRecommendationsChangeListener listener2 = (PrintServiceRecommendationsChangeListener)this.mWeakListener.get();
            if (handler != null && listener2 != null) {
                handler.post(listener2::onPrintServiceRecommendationsChanged);
            }
        }

        public void destroy() {
            this.mWeakListener.clear();
        }
    }

    public static class PrintServicesChangeListenerWrapper
    extends IPrintServicesChangeListener.Stub {
        private final WeakReference<PrintServicesChangeListener> mWeakListener;
        private final WeakReference<Handler> mWeakHandler;

        public PrintServicesChangeListenerWrapper(PrintServicesChangeListener listener2, Handler handler) {
            this.mWeakListener = new WeakReference<PrintServicesChangeListener>(listener2);
            this.mWeakHandler = new WeakReference<Handler>(handler);
        }

        @Override
        public void onPrintServicesChanged() {
            Handler handler = (Handler)this.mWeakHandler.get();
            PrintServicesChangeListener listener2 = (PrintServicesChangeListener)this.mWeakListener.get();
            if (handler != null && listener2 != null) {
                handler.post(listener2::onPrintServicesChanged);
            }
        }

        public void destroy() {
            this.mWeakListener.clear();
        }
    }

    public static class PrintJobStateChangeListenerWrapper
    extends IPrintJobStateChangeListener.Stub {
        private final WeakReference<PrintJobStateChangeListener> mWeakListener;
        private final WeakReference<Handler> mWeakHandler;

        public PrintJobStateChangeListenerWrapper(PrintJobStateChangeListener listener2, Handler handler) {
            this.mWeakListener = new WeakReference<PrintJobStateChangeListener>(listener2);
            this.mWeakHandler = new WeakReference<Handler>(handler);
        }

        @Override
        public void onPrintJobStateChanged(PrintJobId printJobId) {
            Handler handler = (Handler)this.mWeakHandler.get();
            PrintJobStateChangeListener listener2 = (PrintJobStateChangeListener)this.mWeakListener.get();
            if (handler != null && listener2 != null) {
                SomeArgs args = SomeArgs.obtain();
                args.arg1 = this;
                args.arg2 = printJobId;
                handler.obtainMessage(1, args).sendToTarget();
            }
        }

        public void destroy() {
            this.mWeakListener.clear();
        }

        public PrintJobStateChangeListener getListener() {
            return (PrintJobStateChangeListener)this.mWeakListener.get();
        }
    }

    public static class PrintDocumentAdapterDelegate
    extends IPrintDocumentAdapter.Stub
    implements Application.ActivityLifecycleCallbacks {
        private final Object mLock = new Object();
        private Activity mActivity;
        private PrintDocumentAdapter mDocumentAdapter;
        private Handler mHandler;
        private IPrintDocumentAdapterObserver mObserver;
        private DestroyableCallback mPendingCallback;

        public PrintDocumentAdapterDelegate(Activity activity, PrintDocumentAdapter documentAdapter) {
            if (activity.isFinishing()) {
                throw new IllegalStateException("Cannot start printing for finishing activity");
            }
            this.mActivity = activity;
            this.mDocumentAdapter = documentAdapter;
            this.mHandler = new MyHandler(this.mActivity.getMainLooper());
            this.mActivity.getApplication().registerActivityLifecycleCallbacks(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setObserver(IPrintDocumentAdapterObserver observer) {
            boolean destroyed;
            Object object = this.mLock;
            synchronized (object) {
                this.mObserver = observer;
                destroyed = this.isDestroyedLocked();
            }
            if (destroyed && observer != null) {
                try {
                    observer.onDestroy();
                }
                catch (RemoteException re) {
                    Log.e(PrintManager.LOG_TAG, "Error announcing destroyed state", re);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void start() {
            Object object = this.mLock;
            synchronized (object) {
                if (!this.isDestroyedLocked()) {
                    this.mHandler.obtainMessage(1, this.mDocumentAdapter).sendToTarget();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void layout(PrintAttributes oldAttributes, PrintAttributes newAttributes, ILayoutResultCallback callback2, Bundle metadata, int sequence) {
            ICancellationSignal cancellationTransport = CancellationSignal.createTransport();
            try {
                callback2.onLayoutStarted(cancellationTransport, sequence);
            }
            catch (RemoteException re) {
                Log.e(PrintManager.LOG_TAG, "Error notifying for layout start", re);
                return;
            }
            Object object = this.mLock;
            synchronized (object) {
                if (this.isDestroyedLocked()) {
                    return;
                }
                CancellationSignal cancellationSignal = CancellationSignal.fromTransport(cancellationTransport);
                SomeArgs args = SomeArgs.obtain();
                args.arg1 = this.mDocumentAdapter;
                args.arg2 = oldAttributes;
                args.arg3 = newAttributes;
                args.arg4 = cancellationSignal;
                args.arg5 = new MyLayoutResultCallback(callback2, sequence);
                args.arg6 = metadata;
                this.mHandler.obtainMessage(2, args).sendToTarget();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(PageRange[] pages, ParcelFileDescriptor fd, IWriteResultCallback callback2, int sequence) {
            ICancellationSignal cancellationTransport = CancellationSignal.createTransport();
            try {
                callback2.onWriteStarted(cancellationTransport, sequence);
            }
            catch (RemoteException re) {
                Log.e(PrintManager.LOG_TAG, "Error notifying for write start", re);
                return;
            }
            Object object = this.mLock;
            synchronized (object) {
                if (this.isDestroyedLocked()) {
                    return;
                }
                CancellationSignal cancellationSignal = CancellationSignal.fromTransport(cancellationTransport);
                SomeArgs args = SomeArgs.obtain();
                args.arg1 = this.mDocumentAdapter;
                args.arg2 = pages;
                args.arg3 = fd;
                args.arg4 = cancellationSignal;
                args.arg5 = new MyWriteResultCallback(callback2, fd, sequence);
                this.mHandler.obtainMessage(3, args).sendToTarget();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void finish() {
            Object object = this.mLock;
            synchronized (object) {
                if (!this.isDestroyedLocked()) {
                    this.mHandler.obtainMessage(4, this.mDocumentAdapter).sendToTarget();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void kill(String reason) {
            Object object = this.mLock;
            synchronized (object) {
                if (!this.isDestroyedLocked()) {
                    this.mHandler.obtainMessage(5, reason).sendToTarget();
                }
            }
        }

        @Override
        public void onActivityPaused(Activity activity) {
        }

        @Override
        public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
        }

        @Override
        public void onActivityStarted(Activity activity) {
        }

        @Override
        public void onActivityResumed(Activity activity) {
        }

        @Override
        public void onActivityStopped(Activity activity) {
        }

        @Override
        public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onActivityDestroyed(Activity activity) {
            IPrintDocumentAdapterObserver observer = null;
            Object object = this.mLock;
            synchronized (object) {
                if (activity == this.mActivity) {
                    observer = this.mObserver;
                    this.destroyLocked();
                }
            }
            if (observer != null) {
                try {
                    observer.onDestroy();
                }
                catch (RemoteException re) {
                    Log.e(PrintManager.LOG_TAG, "Error announcing destroyed state", re);
                }
            }
        }

        private boolean isDestroyedLocked() {
            return this.mActivity == null;
        }

        private void destroyLocked() {
            this.mActivity.getApplication().unregisterActivityLifecycleCallbacks(this);
            this.mActivity = null;
            this.mDocumentAdapter = null;
            this.mHandler.removeMessages(1);
            this.mHandler.removeMessages(2);
            this.mHandler.removeMessages(3);
            this.mHandler.removeMessages(4);
            this.mHandler = null;
            this.mObserver = null;
            if (this.mPendingCallback != null) {
                this.mPendingCallback.destroy();
                this.mPendingCallback = null;
            }
        }

        private class MyWriteResultCallback
        extends PrintDocumentAdapter.WriteResultCallback
        implements DestroyableCallback {
            private ParcelFileDescriptor mFd;
            private IWriteResultCallback mCallback;
            private final int mSequence;

            public MyWriteResultCallback(IWriteResultCallback callback2, ParcelFileDescriptor fd, int sequence) {
                this.mFd = fd;
                this.mSequence = sequence;
                this.mCallback = callback2;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onWriteFinished(PageRange[] pages) {
                IWriteResultCallback callback2;
                Object object = PrintDocumentAdapterDelegate.this.mLock;
                synchronized (object) {
                    callback2 = this.mCallback;
                }
                if (callback2 == null) {
                    Log.e(PrintManager.LOG_TAG, "PrintDocumentAdapter is destroyed. Did you finish the printing activity before print completion or did you invoke a callback after finish?");
                    return;
                }
                try {
                    if (pages == null) {
                        throw new IllegalArgumentException("pages cannot be null");
                    }
                    if (pages.length == 0) {
                        throw new IllegalArgumentException("pages cannot be empty");
                    }
                    try {
                        callback2.onWriteFinished(pages, this.mSequence);
                    }
                    catch (RemoteException re) {
                        Log.e(PrintManager.LOG_TAG, "Error calling onWriteFinished", re);
                    }
                }
                finally {
                    this.destroy();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onWriteFailed(CharSequence error) {
                IWriteResultCallback callback2;
                Object object = PrintDocumentAdapterDelegate.this.mLock;
                synchronized (object) {
                    callback2 = this.mCallback;
                }
                if (callback2 == null) {
                    Log.e(PrintManager.LOG_TAG, "PrintDocumentAdapter is destroyed. Did you finish the printing activity before print completion or did you invoke a callback after finish?");
                    return;
                }
                try {
                    callback2.onWriteFailed(error, this.mSequence);
                }
                catch (RemoteException re) {
                    Log.e(PrintManager.LOG_TAG, "Error calling onWriteFailed", re);
                }
                finally {
                    this.destroy();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onWriteCancelled() {
                IWriteResultCallback callback2;
                Object object = PrintDocumentAdapterDelegate.this.mLock;
                synchronized (object) {
                    callback2 = this.mCallback;
                }
                if (callback2 == null) {
                    Log.e(PrintManager.LOG_TAG, "PrintDocumentAdapter is destroyed. Did you finish the printing activity before print completion or did you invoke a callback after finish?");
                    return;
                }
                try {
                    callback2.onWriteCanceled(this.mSequence);
                }
                catch (RemoteException re) {
                    Log.e(PrintManager.LOG_TAG, "Error calling onWriteCanceled", re);
                }
                finally {
                    this.destroy();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void destroy() {
                Object object = PrintDocumentAdapterDelegate.this.mLock;
                synchronized (object) {
                    IoUtils.closeQuietly(this.mFd);
                    this.mCallback = null;
                    this.mFd = null;
                    PrintDocumentAdapterDelegate.this.mPendingCallback = null;
                }
            }
        }

        private class MyLayoutResultCallback
        extends PrintDocumentAdapter.LayoutResultCallback
        implements DestroyableCallback {
            private ILayoutResultCallback mCallback;
            private final int mSequence;

            public MyLayoutResultCallback(ILayoutResultCallback callback2, int sequence) {
                this.mCallback = callback2;
                this.mSequence = sequence;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onLayoutFinished(PrintDocumentInfo info, boolean changed) {
                ILayoutResultCallback callback2;
                Object object = PrintDocumentAdapterDelegate.this.mLock;
                synchronized (object) {
                    callback2 = this.mCallback;
                }
                if (callback2 == null) {
                    Log.e(PrintManager.LOG_TAG, "PrintDocumentAdapter is destroyed. Did you finish the printing activity before print completion or did you invoke a callback after finish?");
                    return;
                }
                try {
                    if (info == null) {
                        throw new NullPointerException("document info cannot be null");
                    }
                    try {
                        callback2.onLayoutFinished(info, changed, this.mSequence);
                    }
                    catch (RemoteException re) {
                        Log.e(PrintManager.LOG_TAG, "Error calling onLayoutFinished", re);
                    }
                }
                finally {
                    this.destroy();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onLayoutFailed(CharSequence error) {
                ILayoutResultCallback callback2;
                Object object = PrintDocumentAdapterDelegate.this.mLock;
                synchronized (object) {
                    callback2 = this.mCallback;
                }
                if (callback2 == null) {
                    Log.e(PrintManager.LOG_TAG, "PrintDocumentAdapter is destroyed. Did you finish the printing activity before print completion or did you invoke a callback after finish?");
                    return;
                }
                try {
                    callback2.onLayoutFailed(error, this.mSequence);
                }
                catch (RemoteException re) {
                    Log.e(PrintManager.LOG_TAG, "Error calling onLayoutFailed", re);
                }
                finally {
                    this.destroy();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onLayoutCancelled() {
                ILayoutResultCallback callback2;
                Object object = PrintDocumentAdapterDelegate.this.mLock;
                synchronized (object) {
                    callback2 = this.mCallback;
                }
                if (callback2 == null) {
                    Log.e(PrintManager.LOG_TAG, "PrintDocumentAdapter is destroyed. Did you finish the printing activity before print completion or did you invoke a callback after finish?");
                    return;
                }
                try {
                    callback2.onLayoutCanceled(this.mSequence);
                }
                catch (RemoteException re) {
                    Log.e(PrintManager.LOG_TAG, "Error calling onLayoutFailed", re);
                }
                finally {
                    this.destroy();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void destroy() {
                Object object = PrintDocumentAdapterDelegate.this.mLock;
                synchronized (object) {
                    this.mCallback = null;
                    PrintDocumentAdapterDelegate.this.mPendingCallback = null;
                }
            }
        }

        private static interface DestroyableCallback {
            public void destroy();
        }

        private class MyHandler
        extends Handler {
            public static final int MSG_ON_START = 1;
            public static final int MSG_ON_LAYOUT = 2;
            public static final int MSG_ON_WRITE = 3;
            public static final int MSG_ON_FINISH = 4;
            public static final int MSG_ON_KILL = 5;

            public MyHandler(Looper looper) {
                super(looper, null, true);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void handleMessage(Message message) {
                switch (message.what) {
                    case 1: {
                        ((PrintDocumentAdapter)message.obj).onStart();
                        break;
                    }
                    case 2: {
                        SomeArgs args = (SomeArgs)message.obj;
                        PrintDocumentAdapter adapter = (PrintDocumentAdapter)args.arg1;
                        PrintAttributes oldAttributes = (PrintAttributes)args.arg2;
                        PrintAttributes newAttributes = (PrintAttributes)args.arg3;
                        CancellationSignal cancellation = (CancellationSignal)args.arg4;
                        PrintDocumentAdapter.LayoutResultCallback callback2 = (PrintDocumentAdapter.LayoutResultCallback)args.arg5;
                        Bundle metadata = (Bundle)args.arg6;
                        args.recycle();
                        adapter.onLayout(oldAttributes, newAttributes, cancellation, callback2, metadata);
                        break;
                    }
                    case 3: {
                        SomeArgs args = (SomeArgs)message.obj;
                        PrintDocumentAdapter adapter = (PrintDocumentAdapter)args.arg1;
                        PageRange[] pages = (PageRange[])args.arg2;
                        ParcelFileDescriptor fd = (ParcelFileDescriptor)args.arg3;
                        CancellationSignal cancellation = (CancellationSignal)args.arg4;
                        PrintDocumentAdapter.WriteResultCallback callback3 = (PrintDocumentAdapter.WriteResultCallback)args.arg5;
                        args.recycle();
                        adapter.onWrite(pages, fd, cancellation, callback3);
                        break;
                    }
                    case 4: {
                        ((PrintDocumentAdapter)message.obj).onFinish();
                        Object args = PrintDocumentAdapterDelegate.this.mLock;
                        synchronized (args) {
                            PrintDocumentAdapterDelegate.this.destroyLocked();
                            break;
                        }
                    }
                    case 5: {
                        String reason = (String)message.obj;
                        throw new RuntimeException(reason);
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown message: " + message.what);
                    }
                }
            }
        }
    }

    @SystemApi
    public static interface PrintServiceRecommendationsChangeListener {
        public void onPrintServiceRecommendationsChanged();
    }

    @SystemApi
    public static interface PrintServicesChangeListener {
        public void onPrintServicesChanged();
    }

    public static interface PrintJobStateChangeListener {
        public void onPrintJobStateChanged(PrintJobId var1);
    }
}

