/*
 * Decompiled with CFR 0.152.
 */
package android.print;

import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.print.ILayoutResultCallback;
import android.print.IPrintDocumentAdapterObserver;
import android.print.IWriteResultCallback;
import android.print.PageRange;
import android.print.PrintAttributes;

public interface IPrintDocumentAdapter
extends IInterface {
    public void setObserver(IPrintDocumentAdapterObserver var1) throws RemoteException;

    public void start() throws RemoteException;

    public void layout(PrintAttributes var1, PrintAttributes var2, ILayoutResultCallback var3, Bundle var4, int var5) throws RemoteException;

    public void write(PageRange[] var1, ParcelFileDescriptor var2, IWriteResultCallback var3, int var4) throws RemoteException;

    public void finish() throws RemoteException;

    public void kill(String var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IPrintDocumentAdapter {
        public static final String DESCRIPTOR = "android.print.IPrintDocumentAdapter";
        static final int TRANSACTION_setObserver = 1;
        static final int TRANSACTION_start = 2;
        static final int TRANSACTION_layout = 3;
        static final int TRANSACTION_write = 4;
        static final int TRANSACTION_finish = 5;
        static final int TRANSACTION_kill = 6;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IPrintDocumentAdapter asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IPrintDocumentAdapter) {
                return (IPrintDocumentAdapter)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "setObserver";
                }
                case 2: {
                    return "start";
                }
                case 3: {
                    return "layout";
                }
                case 4: {
                    return "write";
                }
                case 5: {
                    return "finish";
                }
                case 6: {
                    return "kill";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    data.enforceInterface(descriptor);
                    IPrintDocumentAdapterObserver _arg0 = IPrintDocumentAdapterObserver.Stub.asInterface(data.readStrongBinder());
                    this.setObserver(_arg0);
                    return true;
                }
                case 2: {
                    data.enforceInterface(descriptor);
                    this.start();
                    return true;
                }
                case 3: {
                    data.enforceInterface(descriptor);
                    PrintAttributes _arg0 = 0 != data.readInt() ? PrintAttributes.CREATOR.createFromParcel(data) : null;
                    PrintAttributes _arg1 = 0 != data.readInt() ? PrintAttributes.CREATOR.createFromParcel(data) : null;
                    ILayoutResultCallback _arg2 = ILayoutResultCallback.Stub.asInterface(data.readStrongBinder());
                    Bundle _arg3 = 0 != data.readInt() ? Bundle.CREATOR.createFromParcel(data) : null;
                    int _arg4 = data.readInt();
                    this.layout(_arg0, _arg1, _arg2, _arg3, _arg4);
                    return true;
                }
                case 4: {
                    data.enforceInterface(descriptor);
                    PageRange[] _arg0 = data.createTypedArray(PageRange.CREATOR);
                    ParcelFileDescriptor _arg1 = 0 != data.readInt() ? ParcelFileDescriptor.CREATOR.createFromParcel(data) : null;
                    IWriteResultCallback _arg2 = IWriteResultCallback.Stub.asInterface(data.readStrongBinder());
                    int _arg3 = data.readInt();
                    this.write(_arg0, _arg1, _arg2, _arg3);
                    return true;
                }
                case 5: {
                    data.enforceInterface(descriptor);
                    this.finish();
                    return true;
                }
                case 6: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    this.kill(_arg0);
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        public static boolean setDefaultImpl(IPrintDocumentAdapter impl) {
            if (Proxy.sDefaultImpl != null) {
                throw new IllegalStateException("setDefaultImpl() called twice");
            }
            if (impl != null) {
                Proxy.sDefaultImpl = impl;
                return true;
            }
            return false;
        }

        public static IPrintDocumentAdapter getDefaultImpl() {
            return Proxy.sDefaultImpl;
        }

        private static class Proxy
        implements IPrintDocumentAdapter {
            private IBinder mRemote;
            public static IPrintDocumentAdapter sDefaultImpl;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setObserver(IPrintDocumentAdapterObserver observer) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(observer != null ? observer.asBinder() : null);
                    boolean _status = this.mRemote.transact(1, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setObserver(observer);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void start() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(2, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().start();
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void layout(PrintAttributes oldAttributes, PrintAttributes newAttributes, ILayoutResultCallback callback2, Bundle metadata, int sequence) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (oldAttributes != null) {
                        _data.writeInt(1);
                        oldAttributes.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (newAttributes != null) {
                        _data.writeInt(1);
                        newAttributes.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeStrongBinder(callback2 != null ? callback2.asBinder() : null);
                    if (metadata != null) {
                        _data.writeInt(1);
                        metadata.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(sequence);
                    boolean _status = this.mRemote.transact(3, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().layout(oldAttributes, newAttributes, callback2, metadata, sequence);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void write(PageRange[] pages, ParcelFileDescriptor fd, IWriteResultCallback callback2, int sequence) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedArray(pages, 0);
                    if (fd != null) {
                        _data.writeInt(1);
                        fd.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeStrongBinder(callback2 != null ? callback2.asBinder() : null);
                    _data.writeInt(sequence);
                    boolean _status = this.mRemote.transact(4, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().write(pages, fd, callback2, sequence);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void finish() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(5, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().finish();
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void kill(String reason) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(reason);
                    boolean _status = this.mRemote.transact(6, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().kill(reason);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IPrintDocumentAdapter {
        @Override
        public void setObserver(IPrintDocumentAdapterObserver observer) throws RemoteException {
        }

        @Override
        public void start() throws RemoteException {
        }

        @Override
        public void layout(PrintAttributes oldAttributes, PrintAttributes newAttributes, ILayoutResultCallback callback2, Bundle metadata, int sequence) throws RemoteException {
        }

        @Override
        public void write(PageRange[] pages, ParcelFileDescriptor fd, IWriteResultCallback callback2, int sequence) throws RemoteException {
        }

        @Override
        public void finish() throws RemoteException {
        }

        @Override
        public void kill(String reason) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

