/*
 * Decompiled with CFR 0.152.
 */
package android.permission;

import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.app.ActivityThread;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.os.Binder;
import android.os.Bundle;
import android.os.Handler;
import android.os.ParcelFileDescriptor;
import android.os.UserHandle;
import android.permission.AdminPermissionControlParams;
import android.permission.IPermissionController;
import android.permission.RuntimePermissionPresentationInfo;
import android.permission.RuntimePermissionUsageInfo;
import android.util.ArrayMap;
import android.util.Log;
import android.util.Pair;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.infra.AndroidFuture;
import com.android.internal.infra.RemoteStream;
import com.android.internal.infra.ServiceConnector;
import com.android.internal.os.BackgroundThread;
import com.android.internal.util.CollectionUtils;
import com.android.internal.util.FunctionalUtils;
import com.android.internal.util.Preconditions;
import java.io.FileDescriptor;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import libcore.util.EmptyArray;

@SystemApi
public class PermissionControllerManager {
    private static final String TAG = PermissionControllerManager.class.getSimpleName();
    private static final long REQUEST_TIMEOUT_MILLIS = 60000L;
    private static final long UNBIND_TIMEOUT_MILLIS = 10000L;
    private static final int CHUNK_SIZE = 4096;
    private static final Object sLock = new Object();
    @GuardedBy(value={"sLock"})
    private static ArrayMap<Pair<Integer, Thread>, ServiceConnector<IPermissionController>> sRemoteServices = new ArrayMap(1);
    public static final int REASON_MALWARE = 1;
    public static final int REASON_INSTALLER_POLICY_VIOLATION = 2;
    public static final int COUNT_ONLY_WHEN_GRANTED = 1;
    public static final int COUNT_WHEN_SYSTEM = 2;
    private final Context mContext;
    private final ServiceConnector<IPermissionController> mRemoteService;
    private final Handler mHandler;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PermissionControllerManager(Context context, final Handler handler) {
        Object object = sLock;
        synchronized (object) {
            Pair<Integer, Thread> key = new Pair<Integer, Thread>(context.getUserId(), handler.getLooper().getThread());
            ServiceConnector.Impl<IPermissionController> remoteService = sRemoteServices.get(key);
            if (remoteService == null) {
                Intent intent = new Intent("android.permission.PermissionControllerService");
                String pkgName = context.getPackageManager().getPermissionControllerPackageName();
                intent.setPackage(pkgName);
                ResolveInfo serviceInfo = context.getPackageManager().resolveService(intent, 0);
                if (serviceInfo == null) {
                    String errorMsg = "No PermissionController package (" + pkgName + ") for user " + context.getUserId();
                    Log.wtf(TAG, errorMsg);
                    throw new IllegalStateException(errorMsg);
                }
                remoteService = new ServiceConnector.Impl<IPermissionController>((Context)ActivityThread.currentApplication(), new Intent("android.permission.PermissionControllerService").setComponent(serviceInfo.getComponentInfo().getComponentName()), 0, context.getUserId(), IPermissionController.Stub::asInterface){

                    @Override
                    protected Handler getJobHandler() {
                        return handler;
                    }

                    @Override
                    protected long getRequestTimeoutMs() {
                        return 60000L;
                    }

                    @Override
                    protected long getAutoDisconnectTimeoutMs() {
                        return 10000L;
                    }
                };
                sRemoteServices.put(key, (ServiceConnector<IPermissionController>)remoteService);
            }
            this.mRemoteService = remoteService;
        }
        this.mContext = context;
        this.mHandler = handler;
    }

    private void enforceSomePermissionsGrantedToSelf(String ... requiredPermissions) {
        for (String requiredPermission : requiredPermissions) {
            if (this.mContext.checkSelfPermission(requiredPermission) != 0) continue;
            return;
        }
        throw new SecurityException("At lest one of the following permissions is required: " + Arrays.toString(requiredPermissions));
    }

    @RequiresPermission(value="android.permission.REVOKE_RUNTIME_PERMISSIONS")
    public void revokeRuntimePermissions(Map<String, List<String>> request, boolean doDryRun, int reason, Executor executor, OnRevokeRuntimePermissionsCallback callback2) {
        Preconditions.checkNotNull(executor);
        Preconditions.checkNotNull(callback2);
        Preconditions.checkNotNull(request);
        for (Map.Entry<String, List<String>> appRequest : request.entrySet()) {
            Preconditions.checkNotNull(appRequest.getKey());
            Preconditions.checkCollectionElementsNotNull(appRequest.getValue(), "permissions");
        }
        this.enforceSomePermissionsGrantedToSelf("android.permission.REVOKE_RUNTIME_PERMISSIONS");
        this.mRemoteService.postAsync(service -> {
            Bundle bundledizedRequest = new Bundle();
            for (Map.Entry appRequest : request.entrySet()) {
                bundledizedRequest.putStringArrayList((String)appRequest.getKey(), new ArrayList<String>((Collection)appRequest.getValue()));
            }
            AndroidFuture revokeRuntimePermissionsResult = new AndroidFuture();
            service.revokeRuntimePermissions(bundledizedRequest, doDryRun, reason, this.mContext.getPackageName(), revokeRuntimePermissionsResult);
            return revokeRuntimePermissionsResult;
        }).whenCompleteAsync((revoked, err) -> {
            long token = Binder.clearCallingIdentity();
            try {
                if (err != null) {
                    Log.e(TAG, "Failure when revoking runtime permissions " + revoked, err);
                    callback2.onRevokeRuntimePermissions(Collections.emptyMap());
                } else {
                    callback2.onRevokeRuntimePermissions((Map<String, List<String>>)revoked);
                }
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }, executor);
    }

    @RequiresPermission(allOf={"android.permission.GRANT_RUNTIME_PERMISSIONS", "android.permission.REVOKE_RUNTIME_PERMISSIONS", "android.permission.ADJUST_RUNTIME_PERMISSIONS_POLICY"}, conditional=true)
    public void setRuntimePermissionGrantStateByDeviceAdmin(String callerPackageName, AdminPermissionControlParams params, Executor executor, Consumer<Boolean> callback2) {
        Preconditions.checkStringNotEmpty(callerPackageName);
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback2);
        Objects.requireNonNull(params, "Admin control params must not be null.");
        this.mRemoteService.postAsync(service -> {
            AndroidFuture setRuntimePermissionGrantStateResult = new AndroidFuture();
            service.setRuntimePermissionGrantStateByDeviceAdminFromParams(callerPackageName, params, setRuntimePermissionGrantStateResult);
            return setRuntimePermissionGrantStateResult;
        }).whenCompleteAsync((setRuntimePermissionGrantStateResult, err) -> {
            long token = Binder.clearCallingIdentity();
            try {
                if (err != null) {
                    Log.e(TAG, "Error setting permissions state for device admin " + callerPackageName, err);
                    callback2.accept(false);
                } else {
                    callback2.accept(Boolean.TRUE.equals(setRuntimePermissionGrantStateResult));
                }
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }, executor);
    }

    @RequiresPermission(value="android.permission.GET_RUNTIME_PERMISSIONS")
    public void getRuntimePermissionBackup(UserHandle user, Executor executor, Consumer<byte[]> callback2) {
        Preconditions.checkNotNull(user);
        Preconditions.checkNotNull(executor);
        Preconditions.checkNotNull(callback2);
        this.enforceSomePermissionsGrantedToSelf("android.permission.GET_RUNTIME_PERMISSIONS");
        this.mRemoteService.postAsync(service -> RemoteStream.receiveBytes(remotePipe -> service.getRuntimePermissionBackup(user, (ParcelFileDescriptor)remotePipe))).whenCompleteAsync((bytes, err) -> {
            if (err != null) {
                Log.e(TAG, "Error getting permission backup", err);
                callback2.accept(EmptyArray.BYTE);
            } else {
                callback2.accept((byte[])bytes);
            }
        }, executor);
    }

    @RequiresPermission(anyOf={"android.permission.GRANT_RUNTIME_PERMISSIONS", "android.permission.RESTORE_RUNTIME_PERMISSIONS"})
    public void stageAndApplyRuntimePermissionsBackup(byte[] backup, UserHandle user) {
        Preconditions.checkNotNull(backup);
        Preconditions.checkNotNull(user);
        this.enforceSomePermissionsGrantedToSelf("android.permission.GRANT_RUNTIME_PERMISSIONS", "android.permission.RESTORE_RUNTIME_PERMISSIONS");
        this.mRemoteService.postAsync(service -> RemoteStream.sendBytes(remotePipe -> service.stageAndApplyRuntimePermissionsBackup(user, (ParcelFileDescriptor)remotePipe), backup)).whenComplete((nullResult, err) -> {
            if (err != null) {
                Log.e(TAG, "Error sending permission backup", err);
            }
        });
    }

    @RequiresPermission(anyOf={"android.permission.GRANT_RUNTIME_PERMISSIONS", "android.permission.RESTORE_RUNTIME_PERMISSIONS"})
    public void applyStagedRuntimePermissionBackup(String packageName, UserHandle user, Executor executor, Consumer<Boolean> callback2) {
        Preconditions.checkNotNull(packageName);
        Preconditions.checkNotNull(user);
        Preconditions.checkNotNull(executor);
        Preconditions.checkNotNull(callback2);
        this.enforceSomePermissionsGrantedToSelf("android.permission.GRANT_RUNTIME_PERMISSIONS", "android.permission.RESTORE_RUNTIME_PERMISSIONS");
        this.mRemoteService.postAsync(service -> {
            AndroidFuture applyStagedRuntimePermissionBackupResult = new AndroidFuture();
            service.applyStagedRuntimePermissionBackup(packageName, user, applyStagedRuntimePermissionBackupResult);
            return applyStagedRuntimePermissionBackupResult;
        }).whenCompleteAsync((applyStagedRuntimePermissionBackupResult, err) -> {
            long token = Binder.clearCallingIdentity();
            try {
                if (err != null) {
                    Log.e(TAG, "Error restoring delayed permissions for " + packageName, err);
                    callback2.accept(true);
                } else {
                    callback2.accept(Boolean.TRUE.equals(applyStagedRuntimePermissionBackupResult));
                }
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }, executor);
    }

    public void dump(FileDescriptor fd, String[] args) {
        try {
            this.mRemoteService.postAsync(service -> AndroidFuture.runAsync(FunctionalUtils.uncheckExceptions(() -> service.asBinder().dump(fd, args)), BackgroundThread.getExecutor())).get(60000L, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            Log.e(TAG, "Could not get dump", e);
        }
    }

    @RequiresPermission(value="android.permission.GET_RUNTIME_PERMISSIONS")
    public void getAppPermissions(String packageName, OnGetAppPermissionResultCallback callback2, Handler handler) {
        Preconditions.checkNotNull(packageName);
        Preconditions.checkNotNull(callback2);
        Handler finalHandler = handler != null ? handler : this.mHandler;
        this.mRemoteService.postAsync(service -> {
            AndroidFuture getAppPermissionsResult = new AndroidFuture();
            service.getAppPermissions(packageName, getAppPermissionsResult);
            return getAppPermissionsResult;
        }).whenComplete((getAppPermissionsResult, err) -> finalHandler.post(() -> {
            if (err != null) {
                Log.e(TAG, "Error getting app permission", err);
                callback2.onGetAppPermissions(Collections.emptyList());
            } else {
                callback2.onGetAppPermissions(CollectionUtils.emptyIfNull(getAppPermissionsResult));
            }
        }));
    }

    @RequiresPermission(value="android.permission.REVOKE_RUNTIME_PERMISSIONS")
    public void revokeRuntimePermission(String packageName, String permissionName) {
        Preconditions.checkNotNull(packageName);
        Preconditions.checkNotNull(permissionName);
        this.mRemoteService.run(service -> service.revokeRuntimePermission(packageName, permissionName));
    }

    @RequiresPermission(value="android.permission.GET_RUNTIME_PERMISSIONS")
    public void countPermissionApps(List<String> permissionNames, int flags, OnCountPermissionAppsResultCallback callback2, Handler handler) {
        Preconditions.checkCollectionElementsNotNull(permissionNames, "permissionNames");
        Preconditions.checkFlagsArgument(flags, 3);
        Preconditions.checkNotNull(callback2);
        Handler finalHandler = handler != null ? handler : this.mHandler;
        this.mRemoteService.postAsync(service -> {
            AndroidFuture countPermissionAppsResult = new AndroidFuture();
            service.countPermissionApps(permissionNames, flags, countPermissionAppsResult);
            return countPermissionAppsResult;
        }).whenComplete((countPermissionAppsResult, err) -> finalHandler.post(() -> {
            if (err != null) {
                Log.e(TAG, "Error counting permission apps", err);
                callback2.onCountPermissionApps(0);
            } else {
                callback2.onCountPermissionApps((int)countPermissionAppsResult);
            }
        }));
    }

    @RequiresPermission(value="android.permission.GET_RUNTIME_PERMISSIONS")
    public void getPermissionUsages(boolean countSystem, long numMillis, Executor executor, OnPermissionUsageResultCallback callback2) {
        Preconditions.checkArgumentNonnegative(numMillis);
        Preconditions.checkNotNull(executor);
        Preconditions.checkNotNull(callback2);
        this.mRemoteService.postAsync(service -> {
            AndroidFuture getPermissionUsagesResult = new AndroidFuture();
            service.getPermissionUsages(countSystem, numMillis, getPermissionUsagesResult);
            return getPermissionUsagesResult;
        }).whenCompleteAsync((getPermissionUsagesResult, err) -> {
            if (err != null) {
                Log.e(TAG, "Error getting permission usages", err);
                callback2.onPermissionUsageResult(Collections.emptyList());
            } else {
                long token = Binder.clearCallingIdentity();
                try {
                    callback2.onPermissionUsageResult(CollectionUtils.emptyIfNull(getPermissionUsagesResult));
                }
                finally {
                    Binder.restoreCallingIdentity(token);
                }
            }
        }, executor);
    }

    @RequiresPermission(value="android.permission.ADJUST_RUNTIME_PERMISSIONS_POLICY")
    public void grantOrUpgradeDefaultRuntimePermissions(Executor executor, Consumer<Boolean> callback2) {
        this.mRemoteService.postAsync(service -> {
            AndroidFuture grantOrUpgradeDefaultRuntimePermissionsResult = new AndroidFuture();
            service.grantOrUpgradeDefaultRuntimePermissions(grantOrUpgradeDefaultRuntimePermissionsResult);
            return grantOrUpgradeDefaultRuntimePermissionsResult;
        }).whenCompleteAsync((grantOrUpgradeDefaultRuntimePermissionsResult, err) -> {
            if (err != null) {
                Log.e(TAG, "Error granting or upgrading runtime permissions", err);
                callback2.accept(false);
            } else {
                callback2.accept(Boolean.TRUE.equals(grantOrUpgradeDefaultRuntimePermissionsResult));
            }
        }, executor);
    }

    @RequiresPermission(value="android.permission.MANAGE_COMPANION_DEVICES")
    public void getPrivilegesDescriptionStringForProfile(String profileName, Executor executor, Consumer<CharSequence> callback2) {
        this.mRemoteService.postAsync(service -> {
            AndroidFuture<String> future2 = new AndroidFuture<String>();
            service.getPrivilegesDescriptionStringForProfile(profileName, future2);
            return future2;
        }).whenCompleteAsync((description, err) -> {
            if (err != null) {
                Log.e(TAG, "Error from getPrivilegesDescriptionStringForProfile", err);
                callback2.accept(null);
            } else {
                callback2.accept((CharSequence)description);
            }
        }, executor);
    }

    public void updateUserSensitive() {
        this.updateUserSensitiveForApp(-1);
    }

    public void updateUserSensitiveForApp(int uid) {
        this.mRemoteService.postAsync(service -> {
            AndroidFuture future2 = new AndroidFuture();
            service.updateUserSensitiveForApp(uid, future2);
            return future2;
        }).whenComplete((res, err) -> {
            if (err != null) {
                Log.e(TAG, "Error updating user_sensitive flags for uid " + uid, err);
            }
        });
    }

    @RequiresPermission(value="android.permission.REVOKE_RUNTIME_PERMISSIONS")
    public void notifyOneTimePermissionSessionTimeout(String packageName) {
        this.mRemoteService.run(service -> service.notifyOneTimePermissionSessionTimeout(packageName));
    }

    public void getPlatformPermissionsForGroup(String permissionGroupName, Executor executor, Consumer<List<String>> callback2) {
        this.mRemoteService.postAsync(service -> {
            AndroidFuture<List<String>> future2 = new AndroidFuture<List<String>>();
            service.getPlatformPermissionsForGroup(permissionGroupName, future2);
            return future2;
        }).whenCompleteAsync((result, err) -> {
            long token = Binder.clearCallingIdentity();
            try {
                if (err != null) {
                    Log.e(TAG, "Failed to get permissions of " + permissionGroupName, err);
                    callback2.accept(new ArrayList());
                } else {
                    callback2.accept((List<String>)result);
                }
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }, executor);
    }

    public void getGroupOfPlatformPermission(String permissionName, Executor executor, Consumer<String> callback2) {
        this.mRemoteService.postAsync(service -> {
            AndroidFuture<String> future2 = new AndroidFuture<String>();
            service.getGroupOfPlatformPermission(permissionName, future2);
            return future2;
        }).whenCompleteAsync((result, err) -> {
            long token = Binder.clearCallingIdentity();
            try {
                if (err != null) {
                    Log.e(TAG, "Failed to get group of " + permissionName, err);
                    callback2.accept(null);
                } else {
                    callback2.accept((String)result);
                }
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }, executor);
    }

    public static interface OnPermissionUsageResultCallback {
        public void onPermissionUsageResult(List<RuntimePermissionUsageInfo> var1);
    }

    public static interface OnCountPermissionAppsResultCallback {
        public void onCountPermissionApps(int var1);
    }

    public static interface OnGetAppPermissionResultCallback {
        public void onGetAppPermissions(List<RuntimePermissionPresentationInfo> var1);
    }

    public static abstract class OnRevokeRuntimePermissionsCallback {
        public abstract void onRevokeRuntimePermissions(Map<String, List<String>> var1);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface CountPermissionAppsFlag {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Reason {
    }
}

