/*
 * Decompiled with CFR 0.152.
 */
package android.os.health;

import android.os.Parcel;
import android.os.Parcelable;
import android.os.health.HealthKeys;
import android.os.health.TimerStat;
import android.util.ArrayMap;

public class HealthStatsWriter {
    private final HealthKeys.Constants mConstants;
    private final boolean[] mTimerFields;
    private final int[] mTimerCounts;
    private final long[] mTimerTimes;
    private final boolean[] mMeasurementFields;
    private final long[] mMeasurementValues;
    private final ArrayMap<String, HealthStatsWriter>[] mStatsValues;
    private final ArrayMap<String, TimerStat>[] mTimersValues;
    private final ArrayMap<String, Long>[] mMeasurementsValues;

    public HealthStatsWriter(HealthKeys.Constants constants) {
        this.mConstants = constants;
        int timerCount = constants.getSize(0);
        this.mTimerFields = new boolean[timerCount];
        this.mTimerCounts = new int[timerCount];
        this.mTimerTimes = new long[timerCount];
        int measurementCount = constants.getSize(1);
        this.mMeasurementFields = new boolean[measurementCount];
        this.mMeasurementValues = new long[measurementCount];
        int statsCount = constants.getSize(2);
        this.mStatsValues = new ArrayMap[statsCount];
        int timersCount = constants.getSize(3);
        this.mTimersValues = new ArrayMap[timersCount];
        int measurementsCount = constants.getSize(4);
        this.mMeasurementsValues = new ArrayMap[measurementsCount];
    }

    public void addTimer(int timerId, int count, long time) {
        int index = this.mConstants.getIndex(0, timerId);
        this.mTimerFields[index] = true;
        this.mTimerCounts[index] = count;
        this.mTimerTimes[index] = time;
    }

    public void addMeasurement(int measurementId, long value2) {
        int index = this.mConstants.getIndex(1, measurementId);
        this.mMeasurementFields[index] = true;
        this.mMeasurementValues[index] = value2;
    }

    public void addStats(int key, String name, HealthStatsWriter value2) {
        int index = this.mConstants.getIndex(2, key);
        ArrayMap<String, HealthStatsWriter> map2 = this.mStatsValues[index];
        if (map2 == null) {
            map2 = this.mStatsValues[index] = new ArrayMap(1);
        }
        map2.put(name, value2);
    }

    public void addTimers(int key, String name, TimerStat value2) {
        int index = this.mConstants.getIndex(3, key);
        ArrayMap<String, TimerStat> map2 = this.mTimersValues[index];
        if (map2 == null) {
            map2 = this.mTimersValues[index] = new ArrayMap(1);
        }
        map2.put(name, value2);
    }

    public void addMeasurements(int key, String name, long value2) {
        int index = this.mConstants.getIndex(4, key);
        ArrayMap<String, Long> map2 = this.mMeasurementsValues[index];
        if (map2 == null) {
            map2 = this.mMeasurementsValues[index] = new ArrayMap(1);
        }
        map2.put(name, value2);
    }

    public void flattenToParcel(Parcel out) {
        int i;
        out.writeString(this.mConstants.getDataType());
        out.writeInt(HealthStatsWriter.countBooleanArray(this.mTimerFields));
        int[] keys = this.mConstants.getKeys(0);
        for (i = 0; i < keys.length; ++i) {
            if (!this.mTimerFields[i]) continue;
            out.writeInt(keys[i]);
            out.writeInt(this.mTimerCounts[i]);
            out.writeLong(this.mTimerTimes[i]);
        }
        out.writeInt(HealthStatsWriter.countBooleanArray(this.mMeasurementFields));
        keys = this.mConstants.getKeys(1);
        for (i = 0; i < keys.length; ++i) {
            if (!this.mMeasurementFields[i]) continue;
            out.writeInt(keys[i]);
            out.writeLong(this.mMeasurementValues[i]);
        }
        out.writeInt(HealthStatsWriter.countObjectArray(this.mStatsValues));
        keys = this.mConstants.getKeys(2);
        for (i = 0; i < keys.length; ++i) {
            if (this.mStatsValues[i] == null) continue;
            out.writeInt(keys[i]);
            HealthStatsWriter.writeHealthStatsWriterMap(out, this.mStatsValues[i]);
        }
        out.writeInt(HealthStatsWriter.countObjectArray(this.mTimersValues));
        keys = this.mConstants.getKeys(3);
        for (i = 0; i < keys.length; ++i) {
            if (this.mTimersValues[i] == null) continue;
            out.writeInt(keys[i]);
            HealthStatsWriter.writeParcelableMap(out, this.mTimersValues[i]);
        }
        out.writeInt(HealthStatsWriter.countObjectArray(this.mMeasurementsValues));
        keys = this.mConstants.getKeys(4);
        for (i = 0; i < keys.length; ++i) {
            if (this.mMeasurementsValues[i] == null) continue;
            out.writeInt(keys[i]);
            HealthStatsWriter.writeLongsMap(out, this.mMeasurementsValues[i]);
        }
    }

    private static int countBooleanArray(boolean[] fields) {
        int count = 0;
        int N = fields.length;
        for (int i = 0; i < N; ++i) {
            if (!fields[i]) continue;
            ++count;
        }
        return count;
    }

    private static <T> int countObjectArray(T[] fields) {
        int count = 0;
        int N = fields.length;
        for (int i = 0; i < N; ++i) {
            if (fields[i] == null) continue;
            ++count;
        }
        return count;
    }

    private static void writeHealthStatsWriterMap(Parcel out, ArrayMap<String, HealthStatsWriter> map2) {
        int N = map2.size();
        out.writeInt(N);
        for (int i = 0; i < N; ++i) {
            out.writeString(map2.keyAt(i));
            map2.valueAt(i).flattenToParcel(out);
        }
    }

    private static <T extends Parcelable> void writeParcelableMap(Parcel out, ArrayMap<String, T> map2) {
        int N = map2.size();
        out.writeInt(N);
        for (int i = 0; i < N; ++i) {
            out.writeString(map2.keyAt(i));
            ((Parcelable)map2.valueAt(i)).writeToParcel(out, 0);
        }
    }

    private static void writeLongsMap(Parcel out, ArrayMap<String, Long> map2) {
        int N = map2.size();
        out.writeInt(N);
        for (int i = 0; i < N; ++i) {
            out.writeString(map2.keyAt(i));
            out.writeLong(map2.valueAt(i));
        }
    }
}

