/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.app.ActivityThread;
import android.app.ContextImpl;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.Context;
import android.media.AudioAttributes;
import android.os.Process;
import android.os.VibrationAttributes;
import android.os.VibrationEffect;
import android.os.VibratorInfo;
import android.util.Log;
import android.util.Range;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.concurrent.Executor;

public abstract class Vibrator {
    private static final String TAG = "Vibrator";
    public static final int VIBRATION_INTENSITY_OFF = 0;
    public static final int VIBRATION_INTENSITY_LOW = 1;
    public static final int VIBRATION_INTENSITY_MEDIUM = 2;
    public static final int VIBRATION_INTENSITY_HIGH = 3;
    public static final int VIBRATION_EFFECT_SUPPORT_UNKNOWN = 0;
    public static final int VIBRATION_EFFECT_SUPPORT_YES = 1;
    public static final int VIBRATION_EFFECT_SUPPORT_NO = 2;
    private final String mPackageName;
    private int mDefaultHapticFeedbackIntensity;
    private int mDefaultNotificationVibrationIntensity;
    private int mDefaultRingVibrationIntensity;
    private float mHapticChannelMaxVibrationAmplitude;

    @UnsupportedAppUsage
    public Vibrator() {
        this.mPackageName = ActivityThread.currentPackageName();
        ContextImpl ctx = ActivityThread.currentActivityThread().getSystemContext();
        this.loadVibrationConfig(ctx);
    }

    protected Vibrator(Context context) {
        this.mPackageName = context.getOpPackageName();
        this.loadVibrationConfig(context);
    }

    private void loadVibrationConfig(Context context) {
        this.mDefaultHapticFeedbackIntensity = this.loadDefaultIntensity(context, 17694777);
        this.mDefaultNotificationVibrationIntensity = this.loadDefaultIntensity(context, 17694784);
        this.mDefaultRingVibrationIntensity = this.loadDefaultIntensity(context, 17694791);
        this.mHapticChannelMaxVibrationAmplitude = this.loadFloat(context, 17105073, 0.0f);
    }

    private int loadDefaultIntensity(Context ctx, int resId) {
        return ctx != null ? ctx.getResources().getInteger(resId) : 2;
    }

    private float loadFloat(Context ctx, int resId, float defaultValue2) {
        return ctx != null ? ctx.getResources().getFloat(resId) : defaultValue2;
    }

    protected VibratorInfo getInfo() {
        return VibratorInfo.EMPTY_VIBRATOR_INFO;
    }

    public int getDefaultHapticFeedbackIntensity() {
        return this.mDefaultHapticFeedbackIntensity;
    }

    public int getDefaultNotificationVibrationIntensity() {
        return this.mDefaultNotificationVibrationIntensity;
    }

    public int getDefaultRingVibrationIntensity() {
        return this.mDefaultRingVibrationIntensity;
    }

    public int getId() {
        return this.getInfo().getId();
    }

    public abstract boolean hasVibrator();

    public abstract boolean hasAmplitudeControl();

    public boolean hasFrequencyControl() {
        return this.getInfo().hasCapability(1536L);
    }

    public boolean hasExternalControl() {
        return this.getInfo().hasCapability(8L);
    }

    public float getResonantFrequency() {
        return this.getInfo().getResonantFrequency();
    }

    public float getQFactor() {
        return this.getInfo().getQFactor();
    }

    public Range<Float> getRelativeFrequencyRange() {
        return this.getInfo().getFrequencyRange();
    }

    public float getMaximumAmplitude(float relativeFrequency) {
        return this.getInfo().getMaxAmplitude(relativeFrequency);
    }

    public float getHapticChannelMaximumAmplitude() {
        if (this.mHapticChannelMaxVibrationAmplitude <= 0.0f) {
            return Float.NaN;
        }
        return this.mHapticChannelMaxVibrationAmplitude;
    }

    @RequiresPermission(value="android.permission.VIBRATE_ALWAYS_ON")
    public boolean setAlwaysOnEffect(int alwaysOnId, VibrationEffect effect, AudioAttributes attributes) {
        return this.setAlwaysOnEffect(Process.myUid(), this.mPackageName, alwaysOnId, effect, attributes);
    }

    @RequiresPermission(value="android.permission.VIBRATE_ALWAYS_ON")
    public boolean setAlwaysOnEffect(int uid, String opPkg, int alwaysOnId, VibrationEffect effect, AudioAttributes attributes) {
        Log.w(TAG, "Always-on effects aren't supported");
        return false;
    }

    @Deprecated
    @RequiresPermission(value="android.permission.VIBRATE")
    public void vibrate(long milliseconds) {
        this.vibrate(milliseconds, null);
    }

    @Deprecated
    @RequiresPermission(value="android.permission.VIBRATE")
    public void vibrate(long milliseconds, AudioAttributes attributes) {
        try {
            VibrationEffect effect = VibrationEffect.createOneShot(milliseconds, -1);
            this.vibrate(effect, attributes);
        }
        catch (IllegalArgumentException iae) {
            Log.e(TAG, "Failed to create VibrationEffect", iae);
        }
    }

    @Deprecated
    @RequiresPermission(value="android.permission.VIBRATE")
    public void vibrate(long[] pattern, int repeat) {
        this.vibrate(pattern, repeat, null);
    }

    @Deprecated
    @RequiresPermission(value="android.permission.VIBRATE")
    public void vibrate(long[] pattern, int repeat, AudioAttributes attributes) {
        if (repeat < -1 || repeat >= pattern.length) {
            Log.e(TAG, "vibrate called with repeat index out of bounds (pattern.length=" + pattern.length + ", index=" + repeat + ")");
            throw new ArrayIndexOutOfBoundsException();
        }
        try {
            this.vibrate(VibrationEffect.createWaveform(pattern, repeat), attributes);
        }
        catch (IllegalArgumentException iae) {
            Log.e(TAG, "Failed to create VibrationEffect", iae);
        }
    }

    @RequiresPermission(value="android.permission.VIBRATE")
    public void vibrate(VibrationEffect vibe) {
        this.vibrate(vibe, null);
    }

    @RequiresPermission(value="android.permission.VIBRATE")
    public void vibrate(VibrationEffect vibe, AudioAttributes attributes) {
        this.vibrate(Process.myUid(), this.mPackageName, vibe, null, attributes);
    }

    @RequiresPermission(value="android.permission.VIBRATE")
    public void vibrate(int uid, String opPkg, VibrationEffect vibe, String reason, AudioAttributes attributes) {
        if (attributes == null) {
            attributes = new AudioAttributes.Builder().build();
        }
        VibrationAttributes attr2 = new VibrationAttributes.Builder(attributes, vibe).build();
        this.vibrate(uid, opPkg, vibe, reason, attr2);
    }

    @RequiresPermission(value="android.permission.VIBRATE")
    public abstract void vibrate(int var1, String var2, VibrationEffect var3, String var4, VibrationAttributes var5);

    public int[] areEffectsSupported(int ... effectIds) {
        VibratorInfo info = this.getInfo();
        int[] supported = new int[effectIds.length];
        for (int i = 0; i < effectIds.length; ++i) {
            supported[i] = info.isEffectSupported(effectIds[i]);
        }
        return supported;
    }

    public int areAllEffectsSupported(int ... effectIds) {
        int support = 1;
        for (int supported : this.areEffectsSupported(effectIds)) {
            if (supported == 2) {
                return 2;
            }
            if (supported != 0) continue;
            support = 0;
        }
        return support;
    }

    public boolean[] arePrimitivesSupported(int ... primitiveIds) {
        VibratorInfo info = this.getInfo();
        boolean[] supported = new boolean[primitiveIds.length];
        for (int i = 0; i < primitiveIds.length; ++i) {
            supported[i] = info.isPrimitiveSupported(primitiveIds[i]);
        }
        return supported;
    }

    public boolean areAllPrimitivesSupported(int ... primitiveIds) {
        for (boolean supported : this.arePrimitivesSupported(primitiveIds)) {
            if (supported) continue;
            return false;
        }
        return true;
    }

    public int[] getPrimitiveDurations(int ... primitiveIds) {
        VibratorInfo info = this.getInfo();
        int[] durations = new int[primitiveIds.length];
        for (int i = 0; i < primitiveIds.length; ++i) {
            durations[i] = info.getPrimitiveDuration(primitiveIds[i]);
        }
        return durations;
    }

    @RequiresPermission(value="android.permission.VIBRATE")
    public abstract void cancel();

    @RequiresPermission(value="android.permission.VIBRATE")
    public abstract void cancel(int var1);

    @SystemApi
    @RequiresPermission(value="android.permission.ACCESS_VIBRATOR_STATE")
    public boolean isVibrating() {
        return false;
    }

    @SystemApi
    @RequiresPermission(value="android.permission.ACCESS_VIBRATOR_STATE")
    public void addVibratorStateListener(OnVibratorStateChangedListener listener2) {
    }

    @SystemApi
    @RequiresPermission(value="android.permission.ACCESS_VIBRATOR_STATE")
    public void addVibratorStateListener(Executor executor, OnVibratorStateChangedListener listener2) {
    }

    @SystemApi
    @RequiresPermission(value="android.permission.ACCESS_VIBRATOR_STATE")
    public void removeVibratorStateListener(OnVibratorStateChangedListener listener2) {
    }

    @SystemApi
    public static interface OnVibratorStateChangedListener {
        public void onVibratorStateChanged(boolean var1);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface VibrationIntensity {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface VibrationEffectSupport {
    }
}

