/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.accounts.AccountManager;
import android.annotation.RequiresPermission;
import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.app.ActivityManager;
import android.app.PropertyInvalidatedCache;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.Context;
import android.content.Intent;
import android.content.IntentSender;
import android.content.pm.UserInfo;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.IUserManager;
import android.os.IUserRestrictionsListener;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.os.PersistableBundle;
import android.os.Process;
import android.os.RemoteException;
import android.os.ServiceSpecificException;
import android.os.SystemProperties;
import android.os.UserHandle;
import android.os._Original_Build;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import android.util.AndroidException;
import android.util.ArraySet;
import com.android.internal.os.RoSystemProperties;
import java.io.IOException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class UserManager {
    private static final String TAG = "UserManager";
    @UnsupportedAppUsage
    private final IUserManager mService;
    private final Context mContext;
    private final int mUserId;
    private Boolean mIsManagedProfileCached;
    private Boolean mIsProfileCached;
    @SystemApi
    public static final String USER_TYPE_FULL_SYSTEM = "android.os.usertype.full.SYSTEM";
    @SystemApi
    public static final String USER_TYPE_FULL_SECONDARY = "android.os.usertype.full.SECONDARY";
    public static final String USER_TYPE_FULL_GUEST = "android.os.usertype.full.GUEST";
    public static final String USER_TYPE_FULL_DEMO = "android.os.usertype.full.DEMO";
    public static final String USER_TYPE_FULL_RESTRICTED = "android.os.usertype.full.RESTRICTED";
    @SystemApi
    public static final String USER_TYPE_PROFILE_MANAGED = "android.os.usertype.profile.MANAGED";
    @SystemApi
    public static final String USER_TYPE_PROFILE_CLONE = "android.os.usertype.profile.CLONE";
    public static final String USER_TYPE_PROFILE_TEST = "android.os.usertype.profile.TEST";
    @SystemApi
    public static final String USER_TYPE_SYSTEM_HEADLESS = "android.os.usertype.system.HEADLESS";
    public static final int QUIET_MODE_DISABLE_ONLY_IF_CREDENTIAL_NOT_REQUIRED = 1;
    public static final int QUIET_MODE_DISABLE_DONT_ASK_CREDENTIAL = 2;
    @SystemApi
    public static final int RESTRICTION_NOT_SET = 0;
    @SystemApi
    public static final int RESTRICTION_SOURCE_SYSTEM = 1;
    @SystemApi
    public static final int RESTRICTION_SOURCE_DEVICE_OWNER = 2;
    @SystemApi
    public static final int RESTRICTION_SOURCE_PROFILE_OWNER = 4;
    public static final String DISALLOW_MODIFY_ACCOUNTS = "no_modify_accounts";
    public static final String DISALLOW_CONFIG_WIFI = "no_config_wifi";
    public static final String DISALLOW_CONFIG_LOCALE = "no_config_locale";
    public static final String DISALLOW_INSTALL_APPS = "no_install_apps";
    public static final String DISALLOW_UNINSTALL_APPS = "no_uninstall_apps";
    public static final String DISALLOW_SHARE_LOCATION = "no_share_location";
    public static final String DISALLOW_AIRPLANE_MODE = "no_airplane_mode";
    public static final String DISALLOW_CONFIG_BRIGHTNESS = "no_config_brightness";
    public static final String DISALLOW_AMBIENT_DISPLAY = "no_ambient_display";
    public static final String DISALLOW_CONFIG_SCREEN_TIMEOUT = "no_config_screen_timeout";
    public static final String DISALLOW_INSTALL_UNKNOWN_SOURCES = "no_install_unknown_sources";
    public static final String DISALLOW_INSTALL_UNKNOWN_SOURCES_GLOBALLY = "no_install_unknown_sources_globally";
    public static final String DISALLOW_CONFIG_BLUETOOTH = "no_config_bluetooth";
    public static final String DISALLOW_BLUETOOTH = "no_bluetooth";
    public static final String DISALLOW_BLUETOOTH_SHARING = "no_bluetooth_sharing";
    public static final String DISALLOW_USB_FILE_TRANSFER = "no_usb_file_transfer";
    public static final String DISALLOW_CONFIG_CREDENTIALS = "no_config_credentials";
    public static final String DISALLOW_REMOVE_USER = "no_remove_user";
    @Deprecated
    public static final String DISALLOW_REMOVE_MANAGED_PROFILE = "no_remove_managed_profile";
    public static final String DISALLOW_DEBUGGING_FEATURES = "no_debugging_features";
    public static final String DISALLOW_CONFIG_VPN = "no_config_vpn";
    public static final String DISALLOW_CONFIG_LOCATION = "no_config_location";
    public static final String DISALLOW_CONFIG_DATE_TIME = "no_config_date_time";
    public static final String DISALLOW_CONFIG_TETHERING = "no_config_tethering";
    public static final String DISALLOW_NETWORK_RESET = "no_network_reset";
    public static final String DISALLOW_FACTORY_RESET = "no_factory_reset";
    public static final String DISALLOW_ADD_USER = "no_add_user";
    @Deprecated
    public static final String DISALLOW_ADD_MANAGED_PROFILE = "no_add_managed_profile";
    public static final String ENSURE_VERIFY_APPS = "ensure_verify_apps";
    public static final String DISALLOW_CONFIG_CELL_BROADCASTS = "no_config_cell_broadcasts";
    public static final String DISALLOW_CONFIG_MOBILE_NETWORKS = "no_config_mobile_networks";
    public static final String DISALLOW_APPS_CONTROL = "no_control_apps";
    public static final String DISALLOW_MOUNT_PHYSICAL_MEDIA = "no_physical_media";
    public static final String DISALLOW_UNMUTE_MICROPHONE = "no_unmute_microphone";
    public static final String DISALLOW_ADJUST_VOLUME = "no_adjust_volume";
    public static final String DISALLOW_OUTGOING_CALLS = "no_outgoing_calls";
    public static final String DISALLOW_SMS = "no_sms";
    public static final String DISALLOW_FUN = "no_fun";
    public static final String DISALLOW_CREATE_WINDOWS = "no_create_windows";
    public static final String DISALLOW_SYSTEM_ERROR_DIALOGS = "no_system_error_dialogs";
    public static final String DISALLOW_CROSS_PROFILE_COPY_PASTE = "no_cross_profile_copy_paste";
    public static final String DISALLOW_OUTGOING_BEAM = "no_outgoing_beam";
    public static final String DISALLOW_WALLPAPER = "no_wallpaper";
    public static final String DISALLOW_SET_WALLPAPER = "no_set_wallpaper";
    public static final String DISALLOW_SAFE_BOOT = "no_safe_boot";
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public static final String DISALLOW_RECORD_AUDIO = "no_record_audio";
    @SystemApi
    public static final String DISALLOW_RUN_IN_BACKGROUND = "no_run_in_background";
    public static final String DISALLOW_CAMERA = "no_camera";
    public static final String DISALLOW_UNMUTE_DEVICE = "disallow_unmute_device";
    public static final String DISALLOW_DATA_ROAMING = "no_data_roaming";
    public static final String DISALLOW_SET_USER_ICON = "no_set_user_icon";
    @Deprecated
    @SystemApi
    public static final String DISALLOW_OEM_UNLOCK = "no_oem_unlock";
    public static final String DISALLOW_UNIFIED_PASSWORD = "no_unified_password";
    public static final String ALLOW_PARENT_PROFILE_APP_LINKING = "allow_parent_profile_app_linking";
    public static final String DISALLOW_AUTOFILL = "no_autofill";
    public static final String DISALLOW_CONTENT_CAPTURE = "no_content_capture";
    public static final String DISALLOW_CONTENT_SUGGESTIONS = "no_content_suggestions";
    public static final String DISALLOW_USER_SWITCH = "no_user_switch";
    public static final String DISALLOW_SHARE_INTO_MANAGED_PROFILE = "no_sharing_into_profile";
    public static final String DISALLOW_PRINTING = "no_printing";
    public static final String DISALLOW_CONFIG_PRIVATE_DNS = "disallow_config_private_dns";
    public static final String DISALLOW_MICROPHONE_TOGGLE = "disallow_microphone_toggle";
    public static final String DISALLOW_CAMERA_TOGGLE = "disallow_camera_toggle";
    public static final String DISALLOW_BIOMETRIC = "disallow_biometric";
    public static final String KEY_RESTRICTIONS_PENDING = "restrictions_pending";
    private static final String ACTION_CREATE_USER = "android.os.action.CREATE_USER";
    public static final String EXTRA_USER_NAME = "android.os.extra.USER_NAME";
    public static final String EXTRA_USER_ACCOUNT_NAME = "android.os.extra.USER_ACCOUNT_NAME";
    public static final String EXTRA_USER_ACCOUNT_TYPE = "android.os.extra.USER_ACCOUNT_TYPE";
    public static final String EXTRA_USER_ACCOUNT_OPTIONS = "android.os.extra.USER_ACCOUNT_OPTIONS";
    public static final int PIN_VERIFICATION_FAILED_INCORRECT = -3;
    public static final int PIN_VERIFICATION_FAILED_NOT_SET = -2;
    public static final int PIN_VERIFICATION_SUCCESS = -1;
    @SystemApi
    public static final String ACTION_USER_RESTRICTIONS_CHANGED = "android.os.action.USER_RESTRICTIONS_CHANGED";
    public static final int USER_CREATION_FAILED_NOT_PERMITTED = 1;
    public static final int USER_CREATION_FAILED_NO_MORE_USERS = 2;
    @SystemApi
    public static final int SWITCHABILITY_STATUS_OK = 0;
    @SystemApi
    public static final int SWITCHABILITY_STATUS_USER_IN_CALL = 1;
    @SystemApi
    public static final int SWITCHABILITY_STATUS_USER_SWITCH_DISALLOWED = 2;
    @SystemApi
    public static final int SWITCHABILITY_STATUS_SYSTEM_USER_LOCKED = 4;
    public static final int REMOVE_RESULT_REMOVED = 0;
    public static final int REMOVE_RESULT_SET_EPHEMERAL = 1;
    public static final int REMOVE_RESULT_ALREADY_BEING_REMOVED = 2;
    public static final int REMOVE_RESULT_ERROR = 3;
    public static final int USER_OPERATION_SUCCESS = 0;
    public static final int USER_OPERATION_ERROR_UNKNOWN = 1;
    public static final int USER_OPERATION_ERROR_MANAGED_PROFILE = 2;
    public static final int USER_OPERATION_ERROR_MAX_RUNNING_USERS = 3;
    public static final int USER_OPERATION_ERROR_CURRENT_USER = 4;
    public static final int USER_OPERATION_ERROR_LOW_STORAGE = 5;
    public static final int USER_OPERATION_ERROR_MAX_USERS = 6;
    private static final String CACHE_KEY_IS_USER_UNLOCKED_PROPERTY = "cache_key.is_user_unlocked";
    private final PropertyInvalidatedCache<Integer, Boolean> mIsUserUnlockedCache = new PropertyInvalidatedCache<Integer, Boolean>(32, "cache_key.is_user_unlocked"){

        @Override
        protected Boolean recompute(Integer query) {
            try {
                return UserManager.this.mService.isUserUnlocked(query);
            }
            catch (RemoteException re) {
                throw re.rethrowFromSystemServer();
            }
        }
    };
    private final PropertyInvalidatedCache<Integer, Boolean> mIsUserUnlockingOrUnlockedCache = new PropertyInvalidatedCache<Integer, Boolean>(32, "cache_key.is_user_unlocked"){

        @Override
        protected Boolean recompute(Integer query) {
            try {
                return UserManager.this.mService.isUserUnlockingOrUnlocked(query);
            }
            catch (RemoteException re) {
                throw re.rethrowFromSystemServer();
            }
        }
    };

    private <T> T returnNullOrThrowUserOperationException(ServiceSpecificException exception, boolean throwInsteadOfNull) throws UserOperationException {
        if (throwInsteadOfNull) {
            throw UserOperationException.from(exception);
        }
        return null;
    }

    @UnsupportedAppUsage
    public static UserManager get(Context context) {
        return (UserManager)context.getSystemService("user");
    }

    public UserManager(Context context, IUserManager service) {
        this.mService = service;
        this.mContext = context.getApplicationContext();
        this.mUserId = context.getUserId();
    }

    public static boolean supportsMultipleUsers() {
        return UserManager.getMaxSupportedUsers() > 1 && SystemProperties.getBoolean("fw.show_multiuserui", Resources.getSystem().getBoolean(17891541));
    }

    public static boolean isSplitSystemUser() {
        return RoSystemProperties.FW_SYSTEM_USER_SPLIT;
    }

    public static boolean isGuestUserEphemeral() {
        return Resources.getSystem().getBoolean(0x11100F0);
    }

    public static boolean isHeadlessSystemUserMode() {
        return RoSystemProperties.MULTIUSER_HEADLESS_SYSTEM_USER;
    }

    @Deprecated
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public boolean canSwitchUsers() {
        boolean allowUserSwitchingWhenSystemUserLocked = Settings.Global.getInt(this.mContext.getContentResolver(), "allow_user_switching_when_system_user_locked", 0) != 0;
        boolean isSystemUserUnlocked = this.isUserUnlocked(UserHandle.SYSTEM);
        boolean inCall = false;
        TelephonyManager telephonyManager = this.mContext.getSystemService(TelephonyManager.class);
        if (telephonyManager != null) {
            inCall = telephonyManager.getCallState() != 0;
        }
        boolean isUserSwitchDisallowed = this.hasUserRestriction(DISALLOW_USER_SWITCH);
        return (allowUserSwitchingWhenSystemUserLocked || isSystemUserUnlocked) && !inCall && !isUserSwitchDisallowed;
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.READ_PHONE_STATE", "android.permission.MANAGE_USERS", "android.permission.INTERACT_ACROSS_USERS"}, conditional=true)
    public int getUserSwitchability() {
        return this.getUserSwitchability(Process.myUserHandle());
    }

    @RequiresPermission(allOf={"android.permission.READ_PHONE_STATE", "android.permission.MANAGE_USERS", "android.permission.INTERACT_ACROSS_USERS"}, conditional=true)
    public int getUserSwitchability(UserHandle userHandle) {
        TelephonyManager tm = (TelephonyManager)this.mContext.getSystemService("phone");
        int flags = 0;
        if (tm.getCallState() != 0) {
            flags |= 1;
        }
        if (this.hasUserRestriction(DISALLOW_USER_SWITCH, userHandle)) {
            flags |= 2;
        }
        if (!UserManager.isHeadlessSystemUserMode()) {
            boolean allowUserSwitchingWhenSystemUserLocked = Settings.Global.getInt(this.mContext.getContentResolver(), "allow_user_switching_when_system_user_locked", 0) != 0;
            boolean systemUserUnlocked = this.isUserUnlocked(UserHandle.SYSTEM);
            if (!allowUserSwitchingWhenSystemUserLocked && !systemUserUnlocked) {
                flags |= 4;
            }
        }
        return flags;
    }

    @UnsupportedAppUsage
    public int getUserHandle() {
        return UserHandle.myUserId();
    }

    @RequiresPermission(anyOf={"android.permission.MANAGE_USERS", "android.permission.CREATE_USERS"})
    public String getUserType() {
        UserInfo userInfo = this.getUserInfo(this.mUserId);
        return userInfo == null ? "" : userInfo.userType;
    }

    @RequiresPermission(anyOf={"android.permission.MANAGE_USERS", "android.permission.GET_ACCOUNTS_PRIVILEGED", "android.permission.CREATE_USERS"}, conditional=true)
    public String getUserName() {
        if (UserHandle.myUserId() == this.mUserId) {
            try {
                return this.mService.getUserName();
            }
            catch (RemoteException re) {
                throw re.rethrowFromSystemServer();
            }
        }
        UserInfo userInfo = this.getUserInfo(this.mUserId);
        return userInfo == null ? "" : userInfo.name;
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.MANAGE_USERS", "android.permission.GET_ACCOUNTS_PRIVILEGED"})
    public boolean isUserNameSet() {
        try {
            return this.mService.isUserNameSet(this.getUserHandle());
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    public boolean isUserAGoat() {
        if (this.mContext.getApplicationInfo().targetSdkVersion >= 30) {
            return false;
        }
        return this.mContext.getPackageManager().isPackageAvailable("com.coffeestainstudios.goatsimulator");
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.MANAGE_USERS", "android.permission.CREATE_USERS"})
    public boolean isPrimaryUser() {
        UserInfo user = this.getUserInfo(UserHandle.myUserId());
        return user != null && user.isPrimary();
    }

    public boolean isSystemUser() {
        return UserHandle.myUserId() == 0;
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_USERS")
    public boolean isAdminUser() {
        return this.isUserAdmin(UserHandle.myUserId());
    }

    @UnsupportedAppUsage
    @RequiresPermission(anyOf={"android.permission.MANAGE_USERS", "android.permission.CREATE_USERS"})
    public boolean isUserAdmin(int userId) {
        UserInfo user = this.getUserInfo(userId);
        return user != null && user.isAdmin();
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_USERS")
    public boolean isUserOfType(String userType) {
        try {
            return this.mService.isUserOfType(this.mUserId, userType);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    public static boolean isUserTypeManagedProfile(String userType) {
        return USER_TYPE_PROFILE_MANAGED.equals(userType);
    }

    public static boolean isUserTypeGuest(String userType) {
        return USER_TYPE_FULL_GUEST.equals(userType);
    }

    public static boolean isUserTypeRestricted(String userType) {
        return USER_TYPE_FULL_RESTRICTED.equals(userType);
    }

    public static boolean isUserTypeDemo(String userType) {
        return USER_TYPE_FULL_DEMO.equals(userType);
    }

    public static boolean isUserTypeCloneProfile(String userType) {
        return USER_TYPE_PROFILE_CLONE.equals(userType);
    }

    public static int getUserTypeForStatsd(String userType) {
        switch (userType) {
            case "android.os.usertype.full.SYSTEM": {
                return 1;
            }
            case "android.os.usertype.full.SECONDARY": {
                return 2;
            }
            case "android.os.usertype.full.GUEST": {
                return 3;
            }
            case "android.os.usertype.full.DEMO": {
                return 4;
            }
            case "android.os.usertype.full.RESTRICTED": {
                return 5;
            }
            case "android.os.usertype.profile.MANAGED": {
                return 6;
            }
            case "android.os.usertype.system.HEADLESS": {
                return 7;
            }
            case "android.os.usertype.profile.CLONE": {
                return 8;
            }
        }
        return 0;
    }

    @Deprecated
    @UnsupportedAppUsage
    public boolean isLinkedUser() {
        return this.isRestrictedProfile();
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_USERS")
    public boolean isRestrictedProfile() {
        try {
            return this.mService.isRestricted();
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.MANAGE_USERS", "android.permission.CREATE_USERS"})
    public boolean isRestrictedProfile(UserHandle user) {
        try {
            return this.mService.getUserInfo(user.getIdentifier()).isRestricted();
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_USERS")
    public boolean canHaveRestrictedProfile() {
        try {
            return this.mService.canHaveRestrictedProfile(this.mUserId);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_USERS")
    public boolean hasRestrictedProfiles() {
        try {
            return this.mService.hasRestrictedProfiles();
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.MANAGE_USERS", "android.permission.CREATE_USERS"})
    public UserHandle getRestrictedProfileParent() {
        UserInfo info = this.getUserInfo(this.mUserId);
        if (info == null) {
            return null;
        }
        if (!info.isRestricted()) {
            return null;
        }
        int parent = info.restrictedProfileParentId;
        if (parent == -10000) {
            return null;
        }
        return UserHandle.of(parent);
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    @RequiresPermission(anyOf={"android.permission.MANAGE_USERS", "android.permission.CREATE_USERS"})
    public boolean isGuestUser(int userId) {
        UserInfo user = this.getUserInfo(userId);
        return user != null && user.isGuest();
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.MANAGE_USERS", "android.permission.CREATE_USERS"})
    public boolean isGuestUser() {
        UserInfo user = this.getUserInfo(UserHandle.myUserId());
        return user != null && user.isGuest();
    }

    public boolean isDemoUser() {
        try {
            return this.mService.isDemoUser(UserHandle.myUserId());
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.MANAGE_USERS", "android.permission.INTERACT_ACROSS_USERS"}, conditional=true)
    public boolean isProfile() {
        return this.isProfile(this.mUserId);
    }

    private boolean isProfile(int userId) {
        if (userId == UserHandle.myUserId()) {
            if (this.mIsProfileCached != null) {
                return this.mIsProfileCached;
            }
            try {
                this.mIsProfileCached = this.mService.isProfile(userId);
                return this.mIsProfileCached;
            }
            catch (RemoteException re) {
                throw re.rethrowFromSystemServer();
            }
        }
        try {
            return this.mService.isProfile(userId);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    public boolean isManagedProfile() {
        if (this.mIsManagedProfileCached != null) {
            return this.mIsManagedProfileCached;
        }
        try {
            this.mIsManagedProfileCached = this.mService.isManagedProfile(UserHandle.myUserId());
            return this.mIsManagedProfileCached;
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.MANAGE_USERS", "android.permission.INTERACT_ACROSS_USERS"}, conditional=true)
    public boolean isManagedProfile(int userId) {
        if (userId == UserHandle.myUserId()) {
            return this.isManagedProfile();
        }
        try {
            return this.mService.isManagedProfile(userId);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.MANAGE_USERS", "android.permission.INTERACT_ACROSS_USERS"}, conditional=true)
    public boolean isCloneProfile() {
        try {
            return this.mService.isCloneProfile(this.mUserId);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(anyOf={"android.permission.MANAGE_USERS", "android.permission.CREATE_USERS"})
    public boolean isEphemeralUser() {
        return this.isUserEphemeral(UserHandle.myUserId());
    }

    @RequiresPermission(anyOf={"android.permission.MANAGE_USERS", "android.permission.CREATE_USERS"})
    public boolean isUserEphemeral(int userId) {
        UserInfo user = this.getUserInfo(userId);
        return user != null && user.isEphemeral();
    }

    @RequiresPermission(anyOf={"android.permission.MANAGE_USERS", "android.permission.INTERACT_ACROSS_USERS"}, conditional=true)
    public boolean isUserRunning(UserHandle user) {
        return this.isUserRunning(user.getIdentifier());
    }

    @RequiresPermission(anyOf={"android.permission.MANAGE_USERS", "android.permission.INTERACT_ACROSS_USERS"}, conditional=true)
    public boolean isUserRunning(int userId) {
        try {
            return this.mService.isUserRunning(userId);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(anyOf={"android.permission.MANAGE_USERS", "android.permission.INTERACT_ACROSS_USERS"}, conditional=true)
    public boolean isUserRunningOrStopping(UserHandle user) {
        try {
            return ActivityManager.getService().isUserRunning(user.getIdentifier(), 1);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    public boolean isUserForeground() {
        try {
            return this.mService.isUserForeground(this.mUserId);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    public boolean isUserUnlocked() {
        return this.isUserUnlocked(Process.myUserHandle());
    }

    @RequiresPermission(anyOf={"android.permission.MANAGE_USERS", "android.permission.INTERACT_ACROSS_USERS"}, conditional=true)
    public boolean isUserUnlocked(UserHandle user) {
        return this.isUserUnlocked(user.getIdentifier());
    }

    @UnsupportedAppUsage
    @RequiresPermission(anyOf={"android.permission.MANAGE_USERS", "android.permission.INTERACT_ACROSS_USERS"}, conditional=true)
    public boolean isUserUnlocked(int userId) {
        return this.mIsUserUnlockedCache.query(userId);
    }

    public void disableIsUserUnlockedCache() {
        this.mIsUserUnlockedCache.disableLocal();
        this.mIsUserUnlockingOrUnlockedCache.disableLocal();
    }

    public static void invalidateIsUserUnlockedCache() {
        PropertyInvalidatedCache.invalidateCache(CACHE_KEY_IS_USER_UNLOCKED_PROPERTY);
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.MANAGE_USERS", "android.permission.INTERACT_ACROSS_USERS"}, conditional=true)
    public boolean isUserUnlockingOrUnlocked(UserHandle user) {
        return this.isUserUnlockingOrUnlocked(user.getIdentifier());
    }

    @RequiresPermission(anyOf={"android.permission.MANAGE_USERS", "android.permission.INTERACT_ACROSS_USERS"}, conditional=true)
    public boolean isUserUnlockingOrUnlocked(int userId) {
        return this.mIsUserUnlockingOrUnlockedCache.query(userId);
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public long getUserStartRealtime() {
        try {
            return this.mService.getUserStartRealtime();
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public long getUserUnlockRealtime() {
        try {
            return this.mService.getUserUnlockRealtime();
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @UnsupportedAppUsage
    @RequiresPermission(anyOf={"android.permission.MANAGE_USERS", "android.permission.CREATE_USERS"})
    public UserInfo getUserInfo(int userId) {
        try {
            return this.mService.getUserInfo(userId);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @Deprecated
    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_USERS")
    public int getUserRestrictionSource(String restrictionKey, UserHandle userHandle) {
        try {
            return this.mService.getUserRestrictionSource(restrictionKey, userHandle.getIdentifier());
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_USERS")
    public List<EnforcingUser> getUserRestrictionSources(String restrictionKey, UserHandle userHandle) {
        try {
            return this.mService.getUserRestrictionSources(restrictionKey, userHandle.getIdentifier());
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    public Bundle getUserRestrictions() {
        return this.getUserRestrictions(Process.myUserHandle());
    }

    @RequiresPermission(anyOf={"android.permission.MANAGE_USERS", "android.permission.INTERACT_ACROSS_USERS"}, conditional=true)
    public Bundle getUserRestrictions(UserHandle userHandle) {
        try {
            return this.mService.getUserRestrictions(userHandle.getIdentifier());
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @UnsupportedAppUsage
    @RequiresPermission(anyOf={"android.permission.MANAGE_USERS", "android.permission.CREATE_USERS"})
    public boolean hasBaseUserRestriction(String restrictionKey, UserHandle userHandle) {
        try {
            return this.mService.hasBaseUserRestriction(restrictionKey, userHandle.getIdentifier());
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @Deprecated
    public void setUserRestrictions(Bundle restrictions) {
        throw new UnsupportedOperationException("This method is no longer supported");
    }

    @Deprecated
    public void setUserRestrictions(Bundle restrictions, UserHandle userHandle) {
        throw new UnsupportedOperationException("This method is no longer supported");
    }

    @Deprecated
    @RequiresPermission(value="android.permission.MANAGE_USERS")
    public void setUserRestriction(String key, boolean value2) {
        this.setUserRestriction(key, value2, Process.myUserHandle());
    }

    @Deprecated
    @RequiresPermission(value="android.permission.MANAGE_USERS")
    public void setUserRestriction(String key, boolean value2, UserHandle userHandle) {
        try {
            this.mService.setUserRestriction(key, value2, userHandle.getIdentifier());
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    public boolean hasUserRestriction(String restrictionKey) {
        return this.hasUserRestrictionForUser(restrictionKey, Process.myUserHandle());
    }

    @UnsupportedAppUsage
    public boolean hasUserRestriction(String restrictionKey, UserHandle userHandle) {
        return this.hasUserRestrictionForUser(restrictionKey, userHandle);
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.MANAGE_USERS", "android.permission.INTERACT_ACROSS_USERS"}, conditional=true)
    public boolean hasUserRestrictionForUser(String restrictionKey, UserHandle userHandle) {
        try {
            return this.mService.hasUserRestriction(restrictionKey, userHandle.getIdentifier());
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    public boolean hasUserRestrictionOnAnyUser(String restrictionKey) {
        try {
            return this.mService.hasUserRestrictionOnAnyUser(restrictionKey);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    public boolean isSettingRestrictedForUser(String setting, int userId, String value2, int callingUid) {
        try {
            return this.mService.isSettingRestrictedForUser(setting, userId, value2, callingUid);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    public void addUserRestrictionsListener(IUserRestrictionsListener listener2) {
        try {
            this.mService.addUserRestrictionsListener(listener2);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    public long getSerialNumberForUser(UserHandle user) {
        return this.getUserSerialNumber(user.getIdentifier());
    }

    public UserHandle getUserForSerialNumber(long serialNumber) {
        int ident = this.getUserHandle((int)serialNumber);
        return ident >= 0 ? new UserHandle(ident) : null;
    }

    @Deprecated
    @UnsupportedAppUsage
    public UserInfo createUser(String name, int flags) {
        return this.createUser(name, UserInfo.getDefaultUserType(flags), flags);
    }

    @RequiresPermission(anyOf={"android.permission.MANAGE_USERS", "android.permission.CREATE_USERS"})
    public UserInfo createUser(String name, String userType, int flags) {
        try {
            return this.mService.createUserWithThrow(name, userType, flags);
        }
        catch (ServiceSpecificException e) {
            return null;
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(anyOf={"android.permission.MANAGE_USERS", "android.permission.CREATE_USERS"})
    public UserInfo preCreateUser(String userType) throws UserOperationException {
        try {
            return this.mService.preCreateUserWithThrow(userType);
        }
        catch (ServiceSpecificException e) {
            throw UserOperationException.from(e);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(anyOf={"android.permission.MANAGE_USERS", "android.permission.CREATE_USERS"})
    public UserInfo createGuest(Context context, String name) {
        UserInfo guest = null;
        try {
            guest = this.mService.createUserWithThrow(name, USER_TYPE_FULL_GUEST, 0);
            if (guest != null) {
                Settings.Secure.putStringForUser(context.getContentResolver(), "skip_first_use_hints", "1", guest.id);
            }
        }
        catch (ServiceSpecificException e) {
            return null;
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
        return guest;
    }

    @RequiresPermission(value="android.permission.MANAGE_USERS")
    public UserInfo findCurrentGuestUser() {
        try {
            return this.mService.findCurrentGuestUser();
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.MANAGE_USERS", "android.permission.CREATE_USERS"})
    public UserHandle createProfile(String name, String userType, Set<String> disallowedPackages) throws UserOperationException {
        try {
            return this.mService.createProfileForUserWithThrow(name, userType, 0, this.mUserId, disallowedPackages.toArray(new String[disallowedPackages.size()])).getUserHandle();
        }
        catch (ServiceSpecificException e) {
            return (UserHandle)this.returnNullOrThrowUserOperationException(e, this.mContext.getApplicationInfo().targetSdkVersion >= 30);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @Deprecated
    @UnsupportedAppUsage
    @RequiresPermission(anyOf={"android.permission.MANAGE_USERS", "android.permission.CREATE_USERS"})
    public UserInfo createProfileForUser(String name, int flags, int userId) {
        return this.createProfileForUser(name, UserInfo.getDefaultUserType(flags), flags, userId, null);
    }

    @RequiresPermission(anyOf={"android.permission.MANAGE_USERS", "android.permission.CREATE_USERS"})
    public UserInfo createProfileForUser(String name, String userType, int flags, int userId) {
        return this.createProfileForUser(name, userType, flags, userId, null);
    }

    @RequiresPermission(anyOf={"android.permission.MANAGE_USERS", "android.permission.CREATE_USERS"})
    public UserInfo createProfileForUser(String name, String userType, int flags, int userId, String[] disallowedPackages) {
        try {
            return this.mService.createProfileForUserWithThrow(name, userType, flags, userId, disallowedPackages);
        }
        catch (ServiceSpecificException e) {
            return null;
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(anyOf={"android.permission.MANAGE_USERS", "android.permission.CREATE_USERS"})
    public UserInfo createProfileForUserEvenWhenDisallowed(String name, String userType, int flags, int userId, String[] disallowedPackages) {
        try {
            return this.mService.createProfileForUserEvenWhenDisallowedWithThrow(name, userType, flags, userId, disallowedPackages);
        }
        catch (ServiceSpecificException e) {
            return null;
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(anyOf={"android.permission.MANAGE_USERS", "android.permission.CREATE_USERS"})
    public UserInfo createRestrictedProfile(String name) {
        try {
            UserHandle parentUserHandle = Process.myUserHandle();
            UserInfo user = this.mService.createRestrictedProfileWithThrow(name, parentUserHandle.getIdentifier());
            if (user != null) {
                AccountManager.get(this.mContext).addSharedAccountsFromParentUser(parentUserHandle, UserHandle.of(user.id));
            }
            return user;
        }
        catch (ServiceSpecificException e) {
            return null;
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    public static Intent createUserCreationIntent(String userName, String accountName, String accountType, PersistableBundle accountOptions) {
        Intent intent = new Intent(ACTION_CREATE_USER);
        if (userName != null) {
            intent.putExtra(EXTRA_USER_NAME, userName);
        }
        if (accountName != null && accountType == null) {
            throw new IllegalArgumentException("accountType must be specified if accountName is specified");
        }
        if (accountName != null) {
            intent.putExtra(EXTRA_USER_ACCOUNT_NAME, accountName);
        }
        if (accountType != null) {
            intent.putExtra(EXTRA_USER_ACCOUNT_TYPE, accountType);
        }
        if (accountOptions != null) {
            intent.putExtra(EXTRA_USER_ACCOUNT_OPTIONS, accountOptions);
        }
        return intent;
    }

    @SuppressLint(value={"NullableCollection"})
    @RequiresPermission(anyOf={"android.permission.MANAGE_USERS", "android.permission.CREATE_USERS"})
    public Set<String> getPreInstallableSystemPackages(String userType) {
        try {
            String[] installableSystemPackages = this.mService.getPreInstallableSystemPackages(userType);
            if (installableSystemPackages == null) {
                return null;
            }
            return new ArraySet<String>(installableSystemPackages);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_USERS")
    public String getSeedAccountName() {
        try {
            return this.mService.getSeedAccountName();
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_USERS")
    public String getSeedAccountType() {
        try {
            return this.mService.getSeedAccountType();
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_USERS")
    public PersistableBundle getSeedAccountOptions() {
        try {
            return this.mService.getSeedAccountOptions();
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_USERS")
    public void setSeedAccountData(int userId, String accountName, String accountType, PersistableBundle accountOptions) {
        try {
            this.mService.setSeedAccountData(userId, accountName, accountType, accountOptions, true);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_USERS")
    public void clearSeedAccountData() {
        try {
            this.mService.clearSeedAccountData();
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_USERS")
    public boolean markGuestForDeletion(int userId) {
        try {
            return this.mService.markGuestForDeletion(userId);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_USERS")
    public void setUserEnabled(int userId) {
        try {
            this.mService.setUserEnabled(userId);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(allOf={"android.permission.INTERACT_ACROSS_USERS_FULL", "android.permission.MANAGE_USERS"})
    public void setUserAdmin(int userId) {
        try {
            this.mService.setUserAdmin(userId);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_USERS")
    public void evictCredentialEncryptionKey(int userId) {
        try {
            this.mService.evictCredentialEncryptionKey(userId);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(anyOf={"android.permission.MANAGE_USERS", "android.permission.CREATE_USERS"})
    public int getUserCount() {
        List<UserInfo> users = this.getUsers();
        return users != null ? users.size() : 1;
    }

    @UnsupportedAppUsage
    @RequiresPermission(anyOf={"android.permission.MANAGE_USERS", "android.permission.CREATE_USERS"})
    public List<UserInfo> getUsers() {
        return this.getUsers(true, false, true);
    }

    @RequiresPermission(anyOf={"android.permission.MANAGE_USERS", "android.permission.CREATE_USERS"})
    public List<UserInfo> getAliveUsers() {
        return this.getUsers(true, true, true);
    }

    @Deprecated
    @UnsupportedAppUsage
    @RequiresPermission(anyOf={"android.permission.MANAGE_USERS", "android.permission.CREATE_USERS"})
    public List<UserInfo> getUsers(boolean excludeDying) {
        return this.getUsers(true, excludeDying, true);
    }

    @RequiresPermission(anyOf={"android.permission.MANAGE_USERS", "android.permission.CREATE_USERS"})
    public List<UserInfo> getUsers(boolean excludePartial, boolean excludeDying, boolean excludePreCreated) {
        try {
            return this.mService.getUsers(excludePartial, excludeDying, excludePreCreated);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.MANAGE_USERS", "android.permission.CREATE_USERS"})
    public List<UserHandle> getUserHandles(boolean excludeDying) {
        List<UserInfo> users = this.getUsers(true, excludeDying, true);
        ArrayList<UserHandle> result = new ArrayList<UserHandle>(users.size());
        for (UserInfo user : users) {
            result.add(user.getUserHandle());
        }
        return result;
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.MANAGE_USERS", "android.permission.CREATE_USERS"})
    public long[] getSerialNumbersOfUsers(boolean excludeDying) {
        List<UserInfo> users = this.getUsers(true, excludeDying, true);
        long[] result = new long[users.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = users.get((int)i).serialNumber;
        }
        return result;
    }

    @RequiresPermission(allOf={"android.permission.INTERACT_ACROSS_USERS_FULL", "android.permission.MANAGE_USERS"})
    public String getUserAccount(int userId) {
        try {
            return this.mService.getUserAccount(userId);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(allOf={"android.permission.INTERACT_ACROSS_USERS_FULL", "android.permission.MANAGE_USERS"})
    public void setUserAccount(int userId, String accountName) {
        try {
            this.mService.setUserAccount(userId, accountName);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_USERS")
    public UserInfo getPrimaryUser() {
        try {
            return this.mService.getPrimaryUser();
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_USERS")
    public boolean canAddMoreUsers() {
        List<UserInfo> users = this.getAliveUsers();
        int totalUserCount = users.size();
        int aliveUserCount = 0;
        for (int i = 0; i < totalUserCount; ++i) {
            UserInfo user = users.get(i);
            if (user.isGuest()) continue;
            ++aliveUserCount;
        }
        return aliveUserCount < UserManager.getMaxSupportedUsers();
    }

    @RequiresPermission(value="android.permission.MANAGE_USERS")
    public boolean canAddMoreManagedProfiles(int userId, boolean allowedToRemoveOne) {
        try {
            return this.mService.canAddMoreManagedProfiles(userId, allowedToRemoveOne);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_USERS")
    public boolean canAddMoreProfilesToUser(String userType, int userId) {
        try {
            return this.mService.canAddMoreProfilesToUser(userType, userId, false);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @UnsupportedAppUsage
    @RequiresPermission(anyOf={"android.permission.MANAGE_USERS", "android.permission.CREATE_USERS"}, conditional=true)
    public List<UserInfo> getProfiles(int userId) {
        try {
            return this.mService.getProfiles(userId, false);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_USERS")
    public boolean isSameProfileGroup(UserHandle user, UserHandle otherUser) {
        return this.isSameProfileGroup(user.getIdentifier(), otherUser.getIdentifier());
    }

    @RequiresPermission(value="android.permission.MANAGE_USERS")
    public boolean isSameProfileGroup(int userId, int otherUserId) {
        try {
            return this.mService.isSameProfileGroup(userId, otherUserId);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @UnsupportedAppUsage
    @RequiresPermission(anyOf={"android.permission.MANAGE_USERS", "android.permission.CREATE_USERS"}, conditional=true)
    public List<UserInfo> getEnabledProfiles(int userId) {
        try {
            return this.mService.getProfiles(userId, true);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    public List<UserHandle> getUserProfiles() {
        int[] userIds = this.getProfileIds(UserHandle.myUserId(), true);
        ArrayList<UserHandle> result = new ArrayList<UserHandle>(userIds.length);
        for (int userId : userIds) {
            result.add(UserHandle.of(userId));
        }
        return result;
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.MANAGE_USERS", "android.permission.CREATE_USERS"}, conditional=true)
    public List<UserHandle> getEnabledProfiles() {
        return this.getProfiles(true);
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.MANAGE_USERS", "android.permission.CREATE_USERS"}, conditional=true)
    public List<UserHandle> getAllProfiles() {
        return this.getProfiles(false);
    }

    @RequiresPermission(anyOf={"android.permission.MANAGE_USERS", "android.permission.CREATE_USERS"}, conditional=true)
    private List<UserHandle> getProfiles(boolean enabledOnly) {
        int[] userIds = this.getProfileIds(this.mUserId, enabledOnly);
        ArrayList<UserHandle> result = new ArrayList<UserHandle>(userIds.length);
        for (int userId : userIds) {
            result.add(UserHandle.of(userId));
        }
        return result;
    }

    @RequiresPermission(anyOf={"android.permission.MANAGE_USERS", "android.permission.CREATE_USERS"}, conditional=true)
    public int[] getProfileIds(int userId, boolean enabledOnly) {
        try {
            return this.mService.getProfileIds(userId, enabledOnly);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @UnsupportedAppUsage
    @RequiresPermission(anyOf={"android.permission.MANAGE_USERS", "android.permission.CREATE_USERS"}, conditional=true)
    public int[] getProfileIdsWithDisabled(int userId) {
        return this.getProfileIds(userId, false);
    }

    @RequiresPermission(anyOf={"android.permission.MANAGE_USERS", "android.permission.CREATE_USERS"}, conditional=true)
    public int[] getEnabledProfileIds(int userId) {
        return this.getProfileIds(userId, true);
    }

    @RequiresPermission(value="android.permission.MANAGE_USERS")
    public int getCredentialOwnerProfile(int userId) {
        try {
            return this.mService.getCredentialOwnerProfile(userId);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @UnsupportedAppUsage
    @RequiresPermission(anyOf={"android.permission.MANAGE_USERS", "android.permission.INTERACT_ACROSS_USERS"})
    public UserInfo getProfileParent(int userId) {
        try {
            return this.mService.getProfileParent(userId);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.MANAGE_USERS", "android.permission.INTERACT_ACROSS_USERS"})
    public UserHandle getProfileParent(UserHandle user) {
        UserInfo info = this.getProfileParent(user.getIdentifier());
        if (info == null) {
            return null;
        }
        return UserHandle.of(info.id);
    }

    @RequiresPermission(anyOf={"android.permission.MANAGE_USERS", "android.permission.MODIFY_QUIET_MODE"}, conditional=true)
    public boolean requestQuietModeEnabled(boolean enableQuietMode, UserHandle userHandle) {
        return this.requestQuietModeEnabled(enableQuietMode, userHandle, null);
    }

    public boolean requestQuietModeEnabled(boolean enableQuietMode, UserHandle userHandle, int flags) {
        return this.requestQuietModeEnabled(enableQuietMode, userHandle, null, flags);
    }

    @RequiresPermission(value="android.permission.MANAGE_USERS")
    public boolean requestQuietModeEnabled(boolean enableQuietMode, UserHandle userHandle, IntentSender target) {
        return this.requestQuietModeEnabled(enableQuietMode, userHandle, target, 0);
    }

    public boolean requestQuietModeEnabled(boolean enableQuietMode, UserHandle userHandle, IntentSender target, int flags) {
        try {
            return this.mService.requestQuietModeEnabled(this.mContext.getPackageName(), enableQuietMode, userHandle.getIdentifier(), target, flags);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    public boolean isQuietModeEnabled(UserHandle userHandle) {
        try {
            return this.mService.isQuietModeEnabled(userHandle.getIdentifier());
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    public boolean hasBadge(int userId) {
        if (!this.isProfile(userId)) {
            return false;
        }
        try {
            return this.mService.hasBadge(userId);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    public boolean hasBadge() {
        return this.hasBadge(this.mUserId);
    }

    public int getUserBadgeColor(int userId) {
        try {
            int resourceId = this.mService.getUserBadgeColorResId(userId);
            return Resources.getSystem().getColor(resourceId, null);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    public int getUserBadgeDarkColor(int userId) {
        try {
            int resourceId = this.mService.getUserBadgeDarkColorResId(userId);
            return Resources.getSystem().getColor(resourceId, null);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    public int getUserIconBadgeResId(int userId) {
        try {
            return this.mService.getUserIconBadgeResId(userId);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    public int getUserBadgeResId(int userId) {
        try {
            return this.mService.getUserBadgeResId(userId);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    public int getUserBadgeNoBackgroundResId(int userId) {
        try {
            return this.mService.getUserBadgeNoBackgroundResId(userId);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    public Drawable getBadgedIconForUser(Drawable icon2, UserHandle user) {
        return this.mContext.getPackageManager().getUserBadgedIcon(icon2, user);
    }

    public Drawable getBadgedDrawableForUser(Drawable badgedDrawable, UserHandle user, Rect badgeLocation, int badgeDensity) {
        return this.mContext.getPackageManager().getUserBadgedDrawableForDensity(badgedDrawable, user, badgeLocation, badgeDensity);
    }

    public CharSequence getBadgedLabelForUser(CharSequence label, UserHandle user) {
        int userId = user.getIdentifier();
        if (!this.hasBadge(userId)) {
            return label;
        }
        try {
            int resourceId = this.mService.getUserBadgeLabelResId(userId);
            return Resources.getSystem().getString(resourceId, label);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.MANAGE_USERS", "android.permission.INTERACT_ACROSS_USERS"}, conditional=true)
    public boolean isMediaSharedWithParent() {
        try {
            return this.mService.isMediaSharedWithParent(this.mUserId);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @UnsupportedAppUsage
    @RequiresPermission(anyOf={"android.permission.MANAGE_USERS", "android.permission.CREATE_USERS"})
    public boolean removeUser(int userId) {
        try {
            return this.mService.removeUser(userId);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.MANAGE_USERS", "android.permission.CREATE_USERS"})
    public boolean removeUser(UserHandle user) {
        if (user == null) {
            throw new IllegalArgumentException("user cannot be null");
        }
        return this.removeUser(user.getIdentifier());
    }

    @RequiresPermission(anyOf={"android.permission.MANAGE_USERS", "android.permission.CREATE_USERS"})
    public boolean removeUserEvenWhenDisallowed(int userId) {
        try {
            return this.mService.removeUserEvenWhenDisallowed(userId);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(anyOf={"android.permission.MANAGE_USERS", "android.permission.CREATE_USERS"})
    public int removeUserOrSetEphemeral(int userId, boolean evenWhenDisallowed) {
        try {
            return this.mService.removeUserOrSetEphemeral(userId, evenWhenDisallowed);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_USERS")
    public void setUserName(int userId, String name) {
        try {
            this.mService.setUserName(userId, name);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_USERS")
    public void setUserName(String name) {
        this.setUserName(this.mUserId, name);
    }

    @RequiresPermission(value="android.permission.MANAGE_USERS")
    public void setUserIcon(int userId, Bitmap icon2) {
        try {
            this.mService.setUserIcon(userId, icon2);
        }
        catch (ServiceSpecificException e) {
            return;
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_USERS")
    public void setUserIcon(Bitmap icon2) throws UserOperationException {
        this.setUserIcon(this.mUserId, icon2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    @RequiresPermission(anyOf={"android.permission.MANAGE_USERS", "android.permission.GET_ACCOUNTS_PRIVILEGED"})
    public Bitmap getUserIcon(int userId) {
        block9: {
            Bitmap bitmap;
            ParcelFileDescriptor fd = this.mService.getUserIcon(userId);
            if (fd == null) break block9;
            try {
                bitmap = BitmapFactory.decodeFileDescriptor(fd.getFileDescriptor());
            }
            catch (Throwable throwable) {
                try {
                    try {
                        fd.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    throw throwable;
                }
                catch (RemoteException re) {
                    throw re.rethrowFromSystemServer();
                }
            }
            try {
                fd.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return bitmap;
        }
        return null;
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.MANAGE_USERS", "android.permission.GET_ACCOUNTS_PRIVILEGED"})
    public Bitmap getUserIcon() {
        return this.getUserIcon(this.mUserId);
    }

    @UnsupportedAppUsage
    public static int getMaxSupportedUsers() {
        if (_Original_Build.ID.startsWith("JVP")) {
            return 1;
        }
        return SystemProperties.getInt("fw.max_users", Resources.getSystem().getInteger(17694863));
    }

    public boolean isUserSwitcherEnabled() {
        return this.isUserSwitcherEnabled(true);
    }

    public boolean isUserSwitcherEnabled(boolean showEvenIfNotActionable) {
        boolean userSwitcherSettingOn;
        if (!UserManager.supportsMultipleUsers()) {
            return false;
        }
        if (this.hasUserRestriction(DISALLOW_USER_SWITCH)) {
            return false;
        }
        if (UserManager.isDeviceInDemoMode(this.mContext)) {
            return false;
        }
        boolean bl = userSwitcherSettingOn = Settings.Global.getInt(this.mContext.getContentResolver(), "user_switcher_enabled", Resources.getSystem().getBoolean(0x1110130) ? 1 : 0) != 0;
        if (!userSwitcherSettingOn) {
            return false;
        }
        return showEvenIfNotActionable || this.areThereUsersToWhichToSwitch() || !this.hasUserRestriction(DISALLOW_ADD_USER);
    }

    private boolean areThereUsersToWhichToSwitch() {
        List<UserInfo> users = this.getAliveUsers();
        if (users == null) {
            return false;
        }
        int switchableUserCount = 0;
        for (UserInfo user : users) {
            if (!user.supportsSwitchToByUser()) continue;
            ++switchableUserCount;
        }
        return switchableUserCount > 1;
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public static boolean isDeviceInDemoMode(Context context) {
        return Settings.Global.getInt(context.getContentResolver(), "device_demo_mode", 0) > 0;
    }

    @UnsupportedAppUsage
    public int getUserSerialNumber(int userId) {
        try {
            return this.mService.getUserSerialNumber(userId);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @UnsupportedAppUsage
    public int getUserHandle(int userSerialNumber) {
        try {
            return this.mService.getUserHandle(userSerialNumber);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    public Bundle getApplicationRestrictions(String packageName) {
        try {
            return this.mService.getApplicationRestrictions(packageName);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    public Bundle getApplicationRestrictions(String packageName, UserHandle user) {
        try {
            return this.mService.getApplicationRestrictionsForUser(packageName, user.getIdentifier());
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    public void setApplicationRestrictions(String packageName, Bundle restrictions, UserHandle user) {
        try {
            this.mService.setApplicationRestrictions(packageName, restrictions, user.getIdentifier());
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @Deprecated
    public boolean setRestrictionsChallenge(String newPin) {
        return false;
    }

    @RequiresPermission(value="android.permission.MANAGE_USERS")
    public void setDefaultGuestRestrictions(Bundle restrictions) {
        try {
            this.mService.setDefaultGuestRestrictions(restrictions);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_USERS")
    public Bundle getDefaultGuestRestrictions() {
        try {
            return this.mService.getDefaultGuestRestrictions();
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    public long getUserCreationTime(UserHandle userHandle) {
        try {
            return this.mService.getUserCreationTime(userHandle.getIdentifier());
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_USERS")
    public boolean someUserHasSeedAccount(String accountName, String accountType) {
        try {
            return this.mService.someUserHasSeedAccount(accountName, accountType);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @SystemApi
    public static class EnforcingUser
    implements Parcelable {
        private final int userId;
        private final int userRestrictionSource;
        public static final Parcelable.Creator<EnforcingUser> CREATOR = new Parcelable.Creator<EnforcingUser>(){

            @Override
            public EnforcingUser createFromParcel(Parcel in) {
                return new EnforcingUser(in);
            }

            public EnforcingUser[] newArray(int size) {
                return new EnforcingUser[size];
            }
        };

        public EnforcingUser(int userId, int userRestrictionSource) {
            this.userId = userId;
            this.userRestrictionSource = userRestrictionSource;
        }

        private EnforcingUser(Parcel in) {
            this.userId = in.readInt();
            this.userRestrictionSource = in.readInt();
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.userId);
            dest.writeInt(this.userRestrictionSource);
        }

        public UserHandle getUserHandle() {
            return UserHandle.of(this.userId);
        }

        public int getUserRestrictionSource() {
            return this.userRestrictionSource;
        }
    }

    public static class CheckedUserOperationException
    extends AndroidException {
        private final int mUserOperationResult;

        public CheckedUserOperationException(String message, int userOperationResult) {
            super(message);
            this.mUserOperationResult = userOperationResult;
        }

        public int getUserOperationResult() {
            return this.mUserOperationResult;
        }

        public ServiceSpecificException toServiceSpecificException() {
            return new ServiceSpecificException(this.mUserOperationResult, this.getMessage());
        }
    }

    public static class UserOperationException
    extends RuntimeException {
        private final int mUserOperationResult;

        public UserOperationException(String message, int userOperationResult) {
            super(message);
            this.mUserOperationResult = userOperationResult;
        }

        public int getUserOperationResult() {
            return this.mUserOperationResult;
        }

        public static UserOperationException from(ServiceSpecificException exception) {
            return new UserOperationException(exception.getMessage(), exception.errorCode);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface UserOperationResult {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface RemoveResult {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface UserSwitchabilityResult {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface UserRestrictionKey {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @SystemApi
    public static @interface UserRestrictionSource {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface QuietModeFlag {
    }
}

