/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.BatteryConsumer;
import android.os.BatteryStats;
import android.os.BatteryUsageStats;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.PowerComponents;
import android.os.UserHandle;
import android.text.TextUtils;
import android.util.TypedXmlPullParser;
import android.util.TypedXmlSerializer;
import com.android.internal.os.PowerCalculator;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import org.xmlpull.v1.XmlPullParserException;

public class UidBatteryConsumer
extends BatteryConsumer
implements Parcelable {
    public static final int STATE_FOREGROUND = 0;
    public static final int STATE_BACKGROUND = 1;
    private final int mUid;
    private final String mPackageWithHighestDrain;
    private final long mTimeInForegroundMs;
    private final long mTimeInBackgroundMs;
    public static final Parcelable.Creator<UidBatteryConsumer> CREATOR = new Parcelable.Creator<UidBatteryConsumer>(){

        @Override
        public UidBatteryConsumer createFromParcel(Parcel source) {
            return new UidBatteryConsumer(source);
        }

        public UidBatteryConsumer[] newArray(int size) {
            return new UidBatteryConsumer[size];
        }
    };

    public int getUid() {
        return this.mUid;
    }

    public String getPackageWithHighestDrain() {
        return this.mPackageWithHighestDrain;
    }

    public long getTimeInStateMs(int state) {
        switch (state) {
            case 1: {
                return this.mTimeInBackgroundMs;
            }
            case 0: {
                return this.mTimeInForegroundMs;
            }
        }
        return 0L;
    }

    private UidBatteryConsumer(Builder builder2) {
        super(builder2.mPowerComponentsBuilder.build());
        this.mUid = builder2.mUid;
        this.mPackageWithHighestDrain = builder2.mPackageWithHighestDrain;
        this.mTimeInForegroundMs = builder2.mTimeInForegroundMs;
        this.mTimeInBackgroundMs = builder2.mTimeInBackgroundMs;
    }

    private UidBatteryConsumer(Parcel source) {
        super(new PowerComponents(source));
        this.mUid = source.readInt();
        this.mPackageWithHighestDrain = source.readString();
        this.mTimeInForegroundMs = source.readLong();
        this.mTimeInBackgroundMs = source.readLong();
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
        dest.writeInt(this.mUid);
        dest.writeString(this.mPackageWithHighestDrain);
        dest.writeLong(this.mTimeInForegroundMs);
        dest.writeLong(this.mTimeInBackgroundMs);
    }

    @Override
    public void dump(PrintWriter pw, boolean skipEmptyComponents) {
        double consumedPower = this.getConsumedPower();
        pw.print("UID ");
        UserHandle.formatUid(pw, this.getUid());
        pw.print(": ");
        PowerCalculator.printPowerMah(pw, consumedPower);
        pw.print(" ( ");
        this.mPowerComponents.dump(pw, skipEmptyComponents);
        pw.print(" ) ");
    }

    @Override
    public int describeContents() {
        return 0;
    }

    void writeToXml(TypedXmlSerializer serializer) throws IOException {
        if (this.getConsumedPower() == 0.0) {
            return;
        }
        serializer.startTag(null, "uid");
        serializer.attributeInt(null, "uid", this.getUid());
        if (!TextUtils.isEmpty(this.mPackageWithHighestDrain)) {
            serializer.attribute(null, "highest_drain_package", this.mPackageWithHighestDrain);
        }
        serializer.attributeLong(null, "time_in_foreground", this.mTimeInForegroundMs);
        serializer.attributeLong(null, "time_in_background", this.mTimeInBackgroundMs);
        this.mPowerComponents.writeToXml(serializer);
        serializer.endTag(null, "uid");
    }

    static void createFromXml(TypedXmlPullParser parser, BatteryUsageStats.Builder builder2) throws XmlPullParserException, IOException {
        int uid = parser.getAttributeInt(null, "uid");
        Builder consumerBuilder = builder2.getOrCreateUidBatteryConsumerBuilder(uid);
        int eventType = parser.getEventType();
        if (eventType != 2 || !parser.getName().equals("uid")) {
            throw new XmlPullParserException("Invalid XML parser state");
        }
        consumerBuilder.setPackageWithHighestDrain(parser.getAttributeValue(null, "highest_drain_package"));
        consumerBuilder.setTimeInStateMs(0, parser.getAttributeLong(null, "time_in_foreground"));
        consumerBuilder.setTimeInStateMs(1, parser.getAttributeLong(null, "time_in_background"));
        while (!(eventType == 3 && parser.getName().equals("uid") || eventType == 1)) {
            if (eventType == 2 && parser.getName().equals("power_components")) {
                PowerComponents.parseXml(parser, consumerBuilder.mPowerComponentsBuilder);
            }
            eventType = parser.next();
        }
    }

    public static class Builder
    extends BatteryConsumer.BaseBuilder<Builder> {
        private static final String PACKAGE_NAME_UNINITIALIZED = "";
        private final BatteryStats.Uid mBatteryStatsUid;
        private final int mUid;
        private String mPackageWithHighestDrain = "";
        public long mTimeInForegroundMs;
        public long mTimeInBackgroundMs;
        private boolean mExcludeFromBatteryUsageStats;

        public Builder(String[] customPowerComponentNames, boolean includePowerModels, BatteryStats.Uid batteryStatsUid) {
            super(customPowerComponentNames, includePowerModels);
            this.mBatteryStatsUid = batteryStatsUid;
            this.mUid = batteryStatsUid.getUid();
        }

        public Builder(String[] customPowerComponentNames, boolean includePowerModels, int uid) {
            super(customPowerComponentNames, includePowerModels);
            this.mBatteryStatsUid = null;
            this.mUid = uid;
        }

        public BatteryStats.Uid getBatteryStatsUid() {
            if (this.mBatteryStatsUid == null) {
                throw new IllegalStateException("UidBatteryConsumer.Builder was initialized without a BatteryStats.Uid");
            }
            return this.mBatteryStatsUid;
        }

        public int getUid() {
            return this.mUid;
        }

        public Builder setPackageWithHighestDrain(String packageName) {
            this.mPackageWithHighestDrain = TextUtils.nullIfEmpty(packageName);
            return this;
        }

        public Builder setTimeInStateMs(int state, long timeInStateMs) {
            switch (state) {
                case 0: {
                    this.mTimeInForegroundMs = timeInStateMs;
                    break;
                }
                case 1: {
                    this.mTimeInBackgroundMs = timeInStateMs;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported state: " + state);
                }
            }
            return this;
        }

        public Builder excludeFromBatteryUsageStats() {
            this.mExcludeFromBatteryUsageStats = true;
            return this;
        }

        public Builder add(UidBatteryConsumer consumer) {
            this.mPowerComponentsBuilder.addPowerAndDuration(consumer.mPowerComponents);
            this.mTimeInBackgroundMs += consumer.mTimeInBackgroundMs;
            this.mTimeInForegroundMs += consumer.mTimeInForegroundMs;
            if (this.mPackageWithHighestDrain == PACKAGE_NAME_UNINITIALIZED) {
                this.mPackageWithHighestDrain = consumer.mPackageWithHighestDrain;
            } else if (!TextUtils.equals(this.mPackageWithHighestDrain, consumer.mPackageWithHighestDrain)) {
                this.mPackageWithHighestDrain = null;
            }
            return this;
        }

        public boolean isExcludedFromBatteryUsageStats() {
            return this.mExcludeFromBatteryUsageStats;
        }

        public UidBatteryConsumer build() {
            if (this.mPackageWithHighestDrain == PACKAGE_NAME_UNINITIALIZED) {
                this.mPackageWithHighestDrain = null;
            }
            return new UidBatteryConsumer(this);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface State {
    }
}

