/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.MessageQueue;
import android.util.ArraySet;
import java.util.concurrent.LinkedBlockingQueue;

public class TestLooperManager {
    private static final ArraySet<Looper> sHeldLoopers = new ArraySet();
    private final MessageQueue mQueue;
    private final Looper mLooper;
    private final LinkedBlockingQueue<MessageExecution> mExecuteQueue = new LinkedBlockingQueue();
    private boolean mReleased;
    private boolean mLooperBlocked;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TestLooperManager(Looper looper) {
        ArraySet<Looper> arraySet = sHeldLoopers;
        synchronized (arraySet) {
            if (sHeldLoopers.contains(looper)) {
                throw new RuntimeException("TestLooperManager already held for this looper");
            }
            sHeldLoopers.add(looper);
        }
        this.mLooper = looper;
        this.mQueue = this.mLooper.getQueue();
        new Handler(looper).post(new LooperHolder());
    }

    public MessageQueue getMessageQueue() {
        this.checkReleased();
        return this.mQueue;
    }

    @Deprecated
    public MessageQueue getQueue() {
        return this.getMessageQueue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message next() {
        while (!this.mLooperBlocked) {
            TestLooperManager testLooperManager = this;
            synchronized (testLooperManager) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        this.checkReleased();
        return this.mQueue.next();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        ArraySet<Looper> arraySet = sHeldLoopers;
        synchronized (arraySet) {
            sHeldLoopers.remove(this.mLooper);
        }
        this.checkReleased();
        this.mReleased = true;
        this.mExecuteQueue.add(new MessageExecution());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Message message) {
        this.checkReleased();
        if (Looper.myLooper() == this.mLooper) {
            message.target.dispatchMessage(message);
        } else {
            MessageExecution execution2 = new MessageExecution();
            execution2.m = message;
            MessageExecution messageExecution = execution2;
            synchronized (messageExecution) {
                this.mExecuteQueue.add(execution2);
                try {
                    execution2.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (execution2.response != null) {
                    throw new RuntimeException(execution2.response);
                }
            }
        }
    }

    public void recycle(Message msg) {
        this.checkReleased();
        msg.recycleUnchecked();
    }

    public boolean hasMessages(Handler h, Object object, int what) {
        this.checkReleased();
        return this.mQueue.hasMessages(h, what, object);
    }

    public boolean hasMessages(Handler h, Object object, Runnable r) {
        this.checkReleased();
        return this.mQueue.hasMessages(h, r, object);
    }

    private void checkReleased() {
        if (this.mReleased) {
            throw new RuntimeException("release() has already be called");
        }
    }

    private static class MessageExecution {
        private Message m;
        private Throwable response;

        private MessageExecution() {
        }
    }

    private class LooperHolder
    implements Runnable {
        private LooperHolder() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            TestLooperManager testLooperManager = TestLooperManager.this;
            synchronized (testLooperManager) {
                TestLooperManager.this.mLooperBlocked = true;
                TestLooperManager.this.notify();
            }
            while (!TestLooperManager.this.mReleased) {
                try {
                    MessageExecution take = (MessageExecution)TestLooperManager.this.mExecuteQueue.take();
                    if (take.m == null) continue;
                    this.processMessage(take);
                }
                catch (InterruptedException interruptedException) {}
            }
            testLooperManager = TestLooperManager.this;
            synchronized (testLooperManager) {
                TestLooperManager.this.mLooperBlocked = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processMessage(MessageExecution mex) {
            MessageExecution messageExecution = mex;
            synchronized (messageExecution) {
                try {
                    ((MessageExecution)mex).m.target.dispatchMessage(mex.m);
                    mex.response = null;
                }
                catch (Throwable t) {
                    mex.response = t;
                }
                mex.notifyAll();
            }
        }
    }
}

