/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.annotation.SystemApi;
import android.compat.annotation.UnsupportedAppUsage;
import android.os.Binder;
import android.util.Log;
import android.util.MutableInt;
import com.android.internal.annotations.GuardedBy;
import dalvik.annotation.optimization.CriticalNative;
import dalvik.annotation.optimization.FastNative;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import libcore.util.HexEncoding;

@SystemApi
public class SystemProperties {
    private static final String TAG = "SystemProperties";
    private static final boolean TRACK_KEY_ACCESS = false;
    @UnsupportedAppUsage(trackingBug=172649311L)
    public static final int PROP_NAME_MAX = Integer.MAX_VALUE;
    public static final int PROP_VALUE_MAX = 91;
    @UnsupportedAppUsage
    @GuardedBy(value={"sChangeCallbacks"})
    private static final ArrayList<Runnable> sChangeCallbacks = new ArrayList();
    @GuardedBy(value={"sRoReads"})
    private static final HashMap<String, MutableInt> sRoReads = null;

    private static void onKeyAccess(String key) {
    }

    @UnsupportedAppUsage
    private static String native_get(String key) {
        return SystemProperties.native_get(key, "");
    }

    @FastNative
    @UnsupportedAppUsage(maxTargetSdk=28)
    private static native String native_get(String var0, String var1);

    @FastNative
    @UnsupportedAppUsage(maxTargetSdk=28)
    private static native int native_get_int(String var0, int var1);

    @FastNative
    @UnsupportedAppUsage
    private static native long native_get_long(String var0, long var1);

    @FastNative
    @UnsupportedAppUsage(maxTargetSdk=28)
    private static native boolean native_get_boolean(String var0, boolean var1);

    @FastNative
    private static native long native_find(String var0);

    @FastNative
    private static native String native_get(long var0);

    @CriticalNative
    private static native int native_get_int(long var0, int var2);

    @CriticalNative
    private static native long native_get_long(long var0, long var2);

    @CriticalNative
    private static native boolean native_get_boolean(long var0, boolean var2);

    @UnsupportedAppUsage(maxTargetSdk=28)
    private static native void native_set(String var0, String var1);

    @UnsupportedAppUsage(maxTargetSdk=28)
    private static native void native_add_change_callback();

    private static native void native_report_sysprop_change();

    @SystemApi
    public static String get(String key) {
        return SystemProperties.native_get(key);
    }

    @SystemApi
    public static String get(String key, String def) {
        return SystemProperties.native_get(key, def);
    }

    @SystemApi
    public static int getInt(String key, int def) {
        return SystemProperties.native_get_int(key, def);
    }

    @SystemApi
    public static long getLong(String key, long def) {
        return SystemProperties.native_get_long(key, def);
    }

    @SystemApi
    public static boolean getBoolean(String key, boolean def) {
        return SystemProperties.native_get_boolean(key, def);
    }

    @UnsupportedAppUsage
    public static void set(String key, String val) {
        if (val != null && !val.startsWith("ro.") && val.length() > 91) {
            throw new IllegalArgumentException("value of system property '" + key + "' is longer than " + 91 + " characters: " + val);
        }
        SystemProperties.native_set(key, val);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    public static void addChangeCallback(Runnable callback2) {
        ArrayList<Runnable> arrayList = sChangeCallbacks;
        synchronized (arrayList) {
            if (sChangeCallbacks.size() == 0) {
                SystemProperties.native_add_change_callback();
            }
            sChangeCallbacks.add(callback2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public static void removeChangeCallback(Runnable callback2) {
        ArrayList<Runnable> arrayList = sChangeCallbacks;
        synchronized (arrayList) {
            if (sChangeCallbacks.contains(callback2)) {
                sChangeCallbacks.remove(callback2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void callChangeCallbacks() {
        ArrayList<Runnable> callbacks = null;
        ArrayList<Runnable> arrayList = sChangeCallbacks;
        synchronized (arrayList) {
            if (sChangeCallbacks.size() == 0) {
                return;
            }
            callbacks = new ArrayList<Runnable>(sChangeCallbacks);
        }
        long token = Binder.clearCallingIdentity();
        try {
            for (int i = 0; i < callbacks.size(); ++i) {
                try {
                    callbacks.get(i).run();
                    continue;
                }
                catch (Throwable t) {
                    Log.e(TAG, "Exception in SystemProperties change callback", t);
                }
            }
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    @UnsupportedAppUsage
    public static void reportSyspropChanged() {
        SystemProperties.native_report_sysprop_change();
    }

    public static String digestOf(String ... keys) {
        Arrays.sort(keys);
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            for (String key : keys) {
                String item = key + "=" + SystemProperties.get(key) + "\n";
                digest.update(item.getBytes(StandardCharsets.UTF_8));
            }
            return HexEncoding.encodeToString(digest.digest()).toLowerCase();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    @UnsupportedAppUsage
    private SystemProperties() {
    }

    public static Handle find(String name) {
        long nativeHandle = SystemProperties.native_find(name);
        if (nativeHandle == 0L) {
            return null;
        }
        return new Handle(nativeHandle);
    }

    public static class Handle {
        private final long mNativeHandle;

        public String get() {
            return SystemProperties.native_get(this.mNativeHandle);
        }

        public int getInt(int def) {
            return SystemProperties.native_get_int(this.mNativeHandle, def);
        }

        public long getLong(long def) {
            return SystemProperties.native_get_long(this.mNativeHandle, def);
        }

        public boolean getBoolean(boolean def) {
            return SystemProperties.native_get_boolean(this.mNativeHandle, def);
        }

        private Handle(long nativeHandle) {
            this.mNativeHandle = nativeHandle;
        }
    }
}

