/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import java.time.Clock;
import java.time.Instant;
import java.time.ZoneId;

public abstract class SimpleClock
extends Clock {
    private final ZoneId zone;

    public SimpleClock(ZoneId zone) {
        this.zone = zone;
    }

    @Override
    public ZoneId getZone() {
        return this.zone;
    }

    @Override
    public Clock withZone(ZoneId zone) {
        return new SimpleClock(zone){

            @Override
            public long millis() {
                return SimpleClock.this.millis();
            }
        };
    }

    @Override
    public abstract long millis();

    @Override
    public Instant instant() {
        return Instant.ofEpochMilli(this.millis());
    }
}

