/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.content.Context;
import android.os.FileUtils;
import android.os.ParcelFileDescriptor;
import android.os.ProxyFileDescriptorCallback;
import android.os.storage.StorageManager;
import android.system.ErrnoException;
import android.system.Os;
import android.util.Slog;
import com.android.internal.annotations.VisibleForTesting;
import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.Arrays;
import libcore.io.IoUtils;
import libcore.util.EmptyArray;

public class RedactingFileDescriptor {
    private static final String TAG = "RedactingFileDescriptor";
    private static final boolean DEBUG = true;
    private volatile long[] mRedactRanges;
    private volatile long[] mFreeOffsets;
    private FileDescriptor mInner = null;
    private ParcelFileDescriptor mOuter = null;
    private final ProxyFileDescriptorCallback mCallback = new ProxyFileDescriptorCallback(){

        @Override
        public long onGetSize() throws ErrnoException {
            return Os.fstat((FileDescriptor)((RedactingFileDescriptor)RedactingFileDescriptor.this).mInner).st_size;
        }

        @Override
        public int onRead(long offset2, int size, byte[] data) throws ErrnoException {
            int n = 0;
            while (n < size) {
                try {
                    int res = Os.pread(RedactingFileDescriptor.this.mInner, data, n, size - n, offset2 + (long)n);
                    if (res == 0) break;
                    n += res;
                }
                catch (InterruptedIOException e) {
                    n += e.bytesTransferred;
                }
            }
            long[] ranges = RedactingFileDescriptor.this.mRedactRanges;
            for (int i = 0; i < ranges.length; i += 2) {
                long start = Math.max(offset2, ranges[i]);
                long end = Math.min(offset2 + (long)size, ranges[i + 1]);
                for (long j = start; j < end; ++j) {
                    data[(int)(j - offset2)] = 0;
                }
                for (long freeOffset : RedactingFileDescriptor.this.mFreeOffsets) {
                    long freeEnd = freeOffset + 4L;
                    long redactFreeStart = Math.max(freeOffset, start);
                    long redactFreeEnd = Math.min(freeEnd, end);
                    for (long j = redactFreeStart; j < redactFreeEnd; ++j) {
                        data[(int)(j - offset2)] = (byte)"free".charAt((int)(j - freeOffset));
                    }
                }
            }
            return n;
        }

        @Override
        public int onWrite(long offset2, int size, byte[] data) throws ErrnoException {
            int n = 0;
            while (n < size) {
                try {
                    int res = Os.pwrite(RedactingFileDescriptor.this.mInner, data, n, size - n, offset2 + (long)n);
                    if (res == 0) break;
                    n += res;
                }
                catch (InterruptedIOException e) {
                    n += e.bytesTransferred;
                }
            }
            RedactingFileDescriptor.access$102(RedactingFileDescriptor.this, RedactingFileDescriptor.removeRange(RedactingFileDescriptor.this.mRedactRanges, offset2, offset2 + (long)n));
            return n;
        }

        @Override
        public void onFsync() throws ErrnoException {
            Os.fsync(RedactingFileDescriptor.this.mInner);
        }

        @Override
        public void onRelease() {
            Slog.v(RedactingFileDescriptor.TAG, "onRelease()");
            IoUtils.closeQuietly(RedactingFileDescriptor.this.mInner);
        }
    };

    private RedactingFileDescriptor(Context context, File file2, int mode, long[] redactRanges, long[] freeOffsets) throws IOException {
        this.mRedactRanges = RedactingFileDescriptor.checkRangesArgument(redactRanges);
        this.mFreeOffsets = freeOffsets;
        try {
            try {
                this.mInner = Os.open(file2.getAbsolutePath(), FileUtils.translateModePfdToPosix(mode), 0);
                this.mOuter = context.getSystemService(StorageManager.class).openProxyFileDescriptor(mode, this.mCallback);
            }
            catch (ErrnoException e) {
                throw e.rethrowAsIOException();
            }
        }
        catch (IOException e) {
            IoUtils.closeQuietly(this.mInner);
            IoUtils.closeQuietly(this.mOuter);
            throw e;
        }
    }

    private static long[] checkRangesArgument(long[] ranges) {
        if (ranges.length % 2 != 0) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < ranges.length - 1; i += 2) {
            if (ranges[i] <= ranges[i + 1]) continue;
            throw new IllegalArgumentException();
        }
        return ranges;
    }

    public static ParcelFileDescriptor open(Context context, File file2, int mode, long[] redactRanges, long[] freePositions) throws IOException {
        return new RedactingFileDescriptor((Context)context, (File)file2, (int)mode, (long[])redactRanges, (long[])freePositions).mOuter;
    }

    @VisibleForTesting
    public static long[] removeRange(long[] ranges, long start, long end) {
        if (start == end) {
            return ranges;
        }
        if (start > end) {
            throw new IllegalArgumentException();
        }
        long[] res = EmptyArray.LONG;
        for (int i = 0; i < ranges.length; i += 2) {
            if (start <= ranges[i] && end >= ranges[i + 1]) continue;
            if (start >= ranges[i] && end <= ranges[i + 1]) {
                res = Arrays.copyOf(res, res.length + 4);
                res[res.length - 4] = ranges[i];
                res[res.length - 3] = start;
                res[res.length - 2] = end;
                res[res.length - 1] = ranges[i + 1];
                continue;
            }
            res = Arrays.copyOf(res, res.length + 2);
            res[res.length - 2] = end >= ranges[i] && end <= ranges[i + 1] ? Math.max(ranges[i], end) : ranges[i];
            res[res.length - 1] = start >= ranges[i] && start <= ranges[i + 1] ? Math.min(ranges[i + 1], start) : ranges[i + 1];
        }
        return res;
    }

    static /* synthetic */ long[] access$102(RedactingFileDescriptor x0, long[] x1) {
        x0.mRedactRanges = x1;
        return x1;
    }
}

