/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.BatteryConsumer;
import android.os.Parcel;
import android.util.TypedXmlPullParser;
import android.util.TypedXmlSerializer;
import android.util.proto.ProtoOutputStream;
import com.android.internal.os.PowerCalculator;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import org.xmlpull.v1.XmlPullParserException;

class PowerComponents {
    private static final int CUSTOM_POWER_COMPONENT_OFFSET = -982;
    private final double mConsumedPowerMah;
    private final double[] mPowerComponentsMah;
    private final long[] mUsageDurationsMs;
    private final int mCustomPowerComponentCount;
    private final byte[] mPowerModels;
    private String[] mCustomPowerComponentNames;

    PowerComponents(Builder builder2) {
        this.mCustomPowerComponentNames = builder2.mCustomPowerComponentNames;
        this.mCustomPowerComponentCount = this.mCustomPowerComponentNames.length;
        this.mPowerComponentsMah = builder2.mPowerComponentsMah;
        this.mUsageDurationsMs = builder2.mUsageDurationsMs;
        this.mConsumedPowerMah = builder2.getTotalPower();
        this.mPowerModels = builder2.getPowerModels();
    }

    PowerComponents(Parcel source) {
        this.mConsumedPowerMah = source.readDouble();
        this.mCustomPowerComponentCount = source.readInt();
        this.mPowerComponentsMah = source.createDoubleArray();
        this.mUsageDurationsMs = source.createLongArray();
        if (source.readBoolean()) {
            this.mPowerModels = new byte[18];
            source.readByteArray(this.mPowerModels);
        } else {
            this.mPowerModels = null;
        }
    }

    void writeToParcel(Parcel dest, int flags) {
        dest.writeDouble(this.mConsumedPowerMah);
        dest.writeInt(this.mCustomPowerComponentCount);
        dest.writeDoubleArray(this.mPowerComponentsMah);
        dest.writeLongArray(this.mUsageDurationsMs);
        if (this.mPowerModels != null) {
            dest.writeBoolean(true);
            dest.writeByteArray(this.mPowerModels);
        } else {
            dest.writeBoolean(false);
        }
    }

    public double getConsumedPower() {
        return this.mConsumedPowerMah;
    }

    public double getConsumedPower(int componentId) {
        if (componentId >= 18) {
            throw new IllegalArgumentException("Unsupported power component ID: " + componentId);
        }
        try {
            return this.mPowerComponentsMah[componentId];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IllegalArgumentException("Unsupported power component ID: " + componentId);
        }
    }

    public double getConsumedPowerForCustomComponent(int componentId) {
        if (componentId >= 1000 && componentId < 9999) {
            try {
                return this.mPowerComponentsMah[-982 + componentId];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new IllegalArgumentException("Unsupported custom power component ID: " + componentId);
            }
        }
        throw new IllegalArgumentException("Unsupported custom power component ID: " + componentId);
    }

    void setCustomPowerComponentNames(String[] customPowerComponentNames) {
        this.mCustomPowerComponentNames = customPowerComponentNames;
    }

    public String getCustomPowerComponentName(int componentId) {
        if (componentId >= 1000 && componentId < 9999) {
            try {
                return this.mCustomPowerComponentNames[componentId - 1000];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new IllegalArgumentException("Unsupported custom power component ID: " + componentId);
            }
        }
        throw new IllegalArgumentException("Unsupported custom power component ID: " + componentId);
    }

    public boolean hasPowerModels() {
        return this.mPowerModels != null;
    }

    int getPowerModel(int component) {
        if (!this.hasPowerModels()) {
            throw new IllegalStateException("Power model IDs were not requested in the BatteryUsageStatsQuery");
        }
        return this.mPowerModels[component];
    }

    public long getUsageDurationMillis(int componentId) {
        if (componentId >= 18) {
            throw new IllegalArgumentException("Unsupported power component ID: " + componentId);
        }
        try {
            return this.mUsageDurationsMs[componentId];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IllegalArgumentException("Unsupported power component ID: " + componentId);
        }
    }

    public long getUsageDurationForCustomComponentMillis(int componentId) {
        if (componentId < 1000) {
            throw new IllegalArgumentException("Unsupported custom power component ID: " + componentId);
        }
        try {
            return this.mUsageDurationsMs[-982 + componentId];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IllegalArgumentException("Unsupported custom power component ID: " + componentId);
        }
    }

    public int getCustomPowerComponentCount() {
        return this.mCustomPowerComponentCount;
    }

    public long getMaxComponentUsageDurationMillis() {
        long max = 0L;
        for (int i = this.mUsageDurationsMs.length - 1; i >= 0; --i) {
            if (this.mUsageDurationsMs[i] <= max) continue;
            max = this.mUsageDurationsMs[i];
        }
        return max;
    }

    public void dump(PrintWriter pw, boolean skipEmptyComponents) {
        String separator = "";
        for (int componentId = 0; componentId < 18; ++componentId) {
            double componentPower = this.getConsumedPower(componentId);
            if (skipEmptyComponents && componentPower == 0.0) continue;
            pw.print(separator);
            separator = " ";
            pw.print(BatteryConsumer.powerComponentIdToString(componentId));
            pw.print("=");
            PowerCalculator.printPowerMah(pw, componentPower);
        }
        int customComponentCount = this.getCustomPowerComponentCount();
        for (int customComponentId = 1000; customComponentId < 1000 + customComponentCount; ++customComponentId) {
            double customComponentPower = this.getConsumedPowerForCustomComponent(customComponentId);
            if (skipEmptyComponents && customComponentPower == 0.0) continue;
            pw.print(separator);
            separator = " ";
            pw.print(this.getCustomPowerComponentName(customComponentId));
            pw.print("=");
            PowerCalculator.printPowerMah(pw, customComponentPower);
        }
    }

    boolean hasStatsProtoData() {
        return this.writeStatsProtoImpl(null);
    }

    void writeStatsProto(ProtoOutputStream proto) {
        this.writeStatsProtoImpl(proto);
    }

    private boolean writeStatsProtoImpl(ProtoOutputStream proto) {
        boolean interestingData = false;
        for (int idx = 0; idx < this.mPowerComponentsMah.length; ++idx) {
            int componentId = idx < 18 ? idx : idx - -982;
            long powerDeciCoulombs = BatteryConsumer.convertMahToDeciCoulombs(this.mPowerComponentsMah[idx]);
            long durationMs = this.mUsageDurationsMs[idx];
            if (powerDeciCoulombs == 0L && durationMs == 0L) continue;
            interestingData = true;
            if (proto == null) {
                return true;
            }
            long token = proto.start(0x20B00000002L);
            proto.write(0x10500000001L, componentId);
            proto.write(1112396529666L, powerDeciCoulombs);
            proto.write(0x10300000003L, durationMs);
            proto.end(token);
        }
        return interestingData;
    }

    void writeToXml(TypedXmlSerializer serializer) throws IOException {
        serializer.startTag(null, "power_components");
        for (int componentId = 0; componentId < 18; ++componentId) {
            double powerMah = this.getConsumedPower(componentId);
            long durationMs = this.getUsageDurationMillis(componentId);
            if (powerMah == 0.0 && durationMs == 0L) continue;
            serializer.startTag(null, "component");
            serializer.attributeInt(null, "id", componentId);
            if (powerMah != 0.0) {
                serializer.attributeDouble(null, "power", powerMah);
            }
            if (durationMs != 0L) {
                serializer.attributeLong(null, "duration", durationMs);
            }
            if (this.mPowerModels != null) {
                serializer.attributeInt(null, "model", this.mPowerModels[componentId]);
            }
            serializer.endTag(null, "component");
        }
        int customComponentEnd = 1000 + this.mCustomPowerComponentCount;
        for (int componentId = 1000; componentId < customComponentEnd; ++componentId) {
            double powerMah = this.getConsumedPowerForCustomComponent(componentId);
            long durationMs = this.getUsageDurationForCustomComponentMillis(componentId);
            if (powerMah == 0.0 && durationMs == 0L) continue;
            serializer.startTag(null, "custom_component");
            serializer.attributeInt(null, "id", componentId);
            if (powerMah != 0.0) {
                serializer.attributeDouble(null, "power", powerMah);
            }
            if (durationMs != 0L) {
                serializer.attributeLong(null, "duration", durationMs);
            }
            serializer.endTag(null, "custom_component");
        }
        serializer.endTag(null, "power_components");
    }

    static void parseXml(TypedXmlPullParser parser, Builder builder2) throws XmlPullParserException, IOException {
        int eventType = parser.getEventType();
        if (eventType != 2 || !parser.getName().equals("power_components")) {
            throw new XmlPullParserException("Invalid XML parser state");
        }
        while (!(eventType == 3 && parser.getName().equals("power_components") || eventType == 1)) {
            if (eventType == 2) {
                switch (parser.getName()) {
                    case "component": {
                        int componentId = -1;
                        double powerMah = 0.0;
                        long durationMs = 0L;
                        int model2 = 0;
                        block31: for (int i = 0; i < parser.getAttributeCount(); ++i) {
                            switch (parser.getAttributeName(i)) {
                                case "id": {
                                    componentId = parser.getAttributeInt(i);
                                    continue block31;
                                }
                                case "power": {
                                    powerMah = parser.getAttributeDouble(i);
                                    continue block31;
                                }
                                case "duration": {
                                    durationMs = parser.getAttributeLong(i);
                                    continue block31;
                                }
                                case "model": {
                                    model2 = parser.getAttributeInt(i);
                                }
                            }
                        }
                        builder2.setConsumedPower(componentId, powerMah, model2);
                        builder2.setUsageDurationMillis(componentId, durationMs);
                        break;
                    }
                    case "custom_component": {
                        int componentId = -1;
                        double powerMah = 0.0;
                        long durationMs = 0L;
                        block32: for (int i = 0; i < parser.getAttributeCount(); ++i) {
                            switch (parser.getAttributeName(i)) {
                                case "id": {
                                    componentId = parser.getAttributeInt(i);
                                    continue block32;
                                }
                                case "power": {
                                    powerMah = parser.getAttributeDouble(i);
                                    continue block32;
                                }
                                case "duration": {
                                    durationMs = parser.getAttributeLong(i);
                                }
                            }
                        }
                        builder2.setConsumedPowerForCustomComponent(componentId, powerMah);
                        builder2.setUsageDurationForCustomComponentMillis(componentId, durationMs);
                        break;
                    }
                }
            }
            eventType = parser.next();
        }
    }

    static class Builder {
        private static final byte POWER_MODEL_UNINITIALIZED = -1;
        private final double[] mPowerComponentsMah;
        private final String[] mCustomPowerComponentNames;
        private final long[] mUsageDurationsMs;
        private final byte[] mPowerModels;

        Builder(String[] customPowerComponentNames, boolean includePowerModels) {
            this.mCustomPowerComponentNames = customPowerComponentNames;
            int powerComponentCount = 18 + this.mCustomPowerComponentNames.length;
            this.mPowerComponentsMah = new double[powerComponentCount];
            this.mUsageDurationsMs = new long[powerComponentCount];
            if (includePowerModels) {
                this.mPowerModels = new byte[18];
                Arrays.fill(this.mPowerModels, (byte)-1);
            } else {
                this.mPowerModels = null;
            }
        }

        public Builder setConsumedPower(int componentId, double componentPower, int powerModel) {
            if (componentId >= 18) {
                throw new IllegalArgumentException("Unsupported power component ID: " + componentId);
            }
            try {
                this.mPowerComponentsMah[componentId] = componentPower;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new IllegalArgumentException("Unsupported power component ID: " + componentId);
            }
            if (this.mPowerModels != null) {
                this.mPowerModels[componentId] = (byte)powerModel;
            }
            return this;
        }

        public Builder setConsumedPowerForCustomComponent(int componentId, double componentPower) {
            if (componentId >= 1000 && componentId < 9999) {
                try {
                    this.mPowerComponentsMah[-982 + componentId] = componentPower;
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    throw new IllegalArgumentException("Unsupported custom power component ID: " + componentId);
                }
            } else {
                throw new IllegalArgumentException("Unsupported custom power component ID: " + componentId);
            }
            return this;
        }

        public Builder setUsageDurationMillis(int componentId, long componentUsageDurationMillis) {
            if (componentId >= 18) {
                throw new IllegalArgumentException("Unsupported power component ID: " + componentId);
            }
            try {
                this.mUsageDurationsMs[componentId] = componentUsageDurationMillis;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new IllegalArgumentException("Unsupported power component ID: " + componentId);
            }
            return this;
        }

        public Builder setUsageDurationForCustomComponentMillis(int componentId, long componentUsageDurationMillis) {
            if (componentId < 1000) {
                throw new IllegalArgumentException("Unsupported custom power component ID: " + componentId);
            }
            try {
                this.mUsageDurationsMs[-982 + componentId] = componentUsageDurationMillis;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new IllegalArgumentException("Unsupported custom power component ID: " + componentId);
            }
            return this;
        }

        public void addPowerAndDuration(Builder other) {
            this.addPowerAndDuration(other.mPowerComponentsMah, other.mUsageDurationsMs, other.mPowerModels);
        }

        public void addPowerAndDuration(PowerComponents other) {
            this.addPowerAndDuration(other.mPowerComponentsMah, other.mUsageDurationsMs, other.mPowerModels);
        }

        private void addPowerAndDuration(double[] powerComponentsMah, long[] usageDurationsMs, byte[] powerModels) {
            int i;
            if (this.mPowerComponentsMah.length != powerComponentsMah.length) {
                throw new IllegalArgumentException("Number of power components does not match: " + powerComponentsMah.length + ", expected: " + this.mPowerComponentsMah.length);
            }
            for (i = this.mPowerComponentsMah.length - 1; i >= 0; --i) {
                int n = i;
                this.mPowerComponentsMah[n] = this.mPowerComponentsMah[n] + powerComponentsMah[i];
            }
            for (i = this.mUsageDurationsMs.length - 1; i >= 0; --i) {
                int n = i;
                this.mUsageDurationsMs[n] = this.mUsageDurationsMs[n] + usageDurationsMs[i];
            }
            if (this.mPowerModels != null && powerModels != null) {
                for (i = this.mPowerModels.length - 1; i >= 0; --i) {
                    if (this.mPowerModels[i] == -1) {
                        this.mPowerModels[i] = powerModels[i];
                        continue;
                    }
                    if (this.mPowerModels[i] == powerModels[i] || powerModels[i] == -1) continue;
                    this.mPowerModels[i] = 0;
                }
            }
        }

        public double getTotalPower() {
            double totalPowerMah = 0.0;
            for (int i = this.mPowerComponentsMah.length - 1; i >= 0; --i) {
                totalPowerMah += this.mPowerComponentsMah[i];
            }
            return totalPowerMah;
        }

        private byte[] getPowerModels() {
            if (this.mPowerModels == null) {
                return null;
            }
            byte[] powerModels = new byte[this.mPowerModels.length];
            for (int i = this.mPowerModels.length - 1; i >= 0; --i) {
                powerModels[i] = this.mPowerModels[i] != -1 ? this.mPowerModels[i] : (byte)0;
            }
            return powerModels;
        }

        public PowerComponents build() {
            return new PowerComponents(this);
        }
    }
}

