/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.BaseBundle;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.ArrayMap;
import android.util.TypedXmlPullParser;
import android.util.TypedXmlSerializer;
import android.util.Xml;
import android.util.proto.ProtoOutputStream;
import com.android.internal.util.XmlUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

public class PersistableBundle
extends BaseBundle
implements Cloneable,
Parcelable,
XmlUtils.WriteMapCallback {
    private static final String TAG_PERSISTABLEMAP = "pbundle_as_map";
    public static final PersistableBundle EMPTY = new PersistableBundle();
    public static final Parcelable.Creator<PersistableBundle> CREATOR;

    public static boolean isValidType(Object value2) {
        return value2 instanceof Integer || value2 instanceof Long || value2 instanceof Double || value2 instanceof String || value2 instanceof int[] || value2 instanceof long[] || value2 instanceof double[] || value2 instanceof String[] || value2 instanceof PersistableBundle || value2 == null || value2 instanceof Boolean || value2 instanceof boolean[];
    }

    public PersistableBundle() {
        this.mFlags = 1;
    }

    public PersistableBundle(int capacity) {
        super(capacity);
        this.mFlags = 1;
    }

    public PersistableBundle(PersistableBundle b) {
        super(b);
        this.mFlags = b.mFlags;
    }

    public PersistableBundle(Bundle b) {
        this(b.getMap());
    }

    private PersistableBundle(ArrayMap<String, Object> map2) {
        this.mFlags = 1;
        this.putAll(map2);
        int N = this.mMap.size();
        for (int i = 0; i < N; ++i) {
            Object value2 = this.mMap.valueAt(i);
            if (value2 instanceof ArrayMap) {
                this.mMap.setValueAt(i, new PersistableBundle((ArrayMap)value2));
                continue;
            }
            if (value2 instanceof Bundle) {
                this.mMap.setValueAt(i, new PersistableBundle((Bundle)value2));
                continue;
            }
            if (PersistableBundle.isValidType(value2)) continue;
            throw new IllegalArgumentException("Bad value in PersistableBundle key=" + (String)this.mMap.keyAt(i) + " value=" + value2);
        }
    }

    PersistableBundle(Parcel parcelledData, int length) {
        super(parcelledData, length);
        this.mFlags = 1;
    }

    PersistableBundle(boolean doInit) {
        super(doInit);
    }

    public static PersistableBundle forPair(String key, String value2) {
        PersistableBundle b = new PersistableBundle(1);
        b.putString(key, value2);
        return b;
    }

    public Object clone() {
        return new PersistableBundle(this);
    }

    public PersistableBundle deepCopy() {
        PersistableBundle b = new PersistableBundle(false);
        b.copyInternal(this, true);
        return b;
    }

    public void putPersistableBundle(String key, PersistableBundle value2) {
        this.unparcel();
        this.mMap.put(key, value2);
    }

    public PersistableBundle getPersistableBundle(String key) {
        this.unparcel();
        Object o = this.mMap.get(key);
        if (o == null) {
            return null;
        }
        try {
            return (PersistableBundle)o;
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "Bundle", e);
            return null;
        }
    }

    @Override
    public void writeUnknownObject(Object v, String name, TypedXmlSerializer out) throws XmlPullParserException, IOException {
        if (!(v instanceof PersistableBundle)) {
            throw new XmlPullParserException("Unknown Object o=" + v);
        }
        out.startTag(null, TAG_PERSISTABLEMAP);
        out.attribute(null, "name", name);
        ((PersistableBundle)v).saveToXml(out);
        out.endTag(null, TAG_PERSISTABLEMAP);
    }

    public void saveToXml(XmlSerializer out) throws IOException, XmlPullParserException {
        this.saveToXml(XmlUtils.makeTyped(out));
    }

    public void saveToXml(TypedXmlSerializer out) throws IOException, XmlPullParserException {
        this.unparcel();
        XmlUtils.writeMapXml((Map)this.mMap, out, this);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeToParcel(Parcel parcel, int flags) {
        boolean oldAllowFds = parcel.pushAllowFds(false);
        try {
            this.writeToParcelInner(parcel, flags);
        }
        finally {
            parcel.restoreAllowFds(oldAllowFds);
        }
    }

    public static PersistableBundle restoreFromXml(XmlPullParser in) throws IOException, XmlPullParserException {
        return PersistableBundle.restoreFromXml(XmlUtils.makeTyped(in));
    }

    public static PersistableBundle restoreFromXml(TypedXmlPullParser in) throws IOException, XmlPullParserException {
        int event;
        int outerDepth = in.getDepth();
        String startTag = in.getName();
        String[] tagName = new String[1];
        while ((event = in.next()) != 1 && (event != 3 || in.getDepth() < outerDepth)) {
            if (event != 2) continue;
            return new PersistableBundle(XmlUtils.readThisArrayMapXml(in, startTag, tagName, new MyReadMapCallback()));
        }
        return EMPTY;
    }

    public synchronized String toString() {
        if (this.mParcelledData != null) {
            if (this.isEmptyParcel()) {
                return "PersistableBundle[EMPTY_PARCEL]";
            }
            return "PersistableBundle[mParcelledData.dataSize=" + this.mParcelledData.dataSize() + "]";
        }
        return "PersistableBundle[" + this.mMap.toString() + "]";
    }

    public synchronized String toShortString() {
        if (this.mParcelledData != null) {
            if (this.isEmptyParcel()) {
                return "EMPTY_PARCEL";
            }
            return "mParcelledData.dataSize=" + this.mParcelledData.dataSize();
        }
        return this.mMap.toString();
    }

    public void dumpDebug(ProtoOutputStream proto, long fieldId) {
        long token = proto.start(fieldId);
        if (this.mParcelledData != null) {
            if (this.isEmptyParcel()) {
                proto.write(0x10500000001L, 0);
            } else {
                proto.write(0x10500000001L, this.mParcelledData.dataSize());
            }
        } else {
            proto.write(1138166333442L, this.mMap.toString());
        }
        proto.end(token);
    }

    public void writeToStream(OutputStream outputStream) throws IOException {
        TypedXmlSerializer serializer = Xml.newFastSerializer();
        serializer.setOutput(outputStream, StandardCharsets.UTF_8.name());
        serializer.startTag(null, "bundle");
        try {
            this.saveToXml(serializer);
        }
        catch (XmlPullParserException e) {
            throw new IOException(e);
        }
        serializer.endTag(null, "bundle");
        serializer.flush();
    }

    public static PersistableBundle readFromStream(InputStream inputStream) throws IOException {
        try {
            TypedXmlPullParser parser = Xml.newFastPullParser();
            parser.setInput(inputStream, StandardCharsets.UTF_8.name());
            parser.next();
            return PersistableBundle.restoreFromXml(parser);
        }
        catch (XmlPullParserException e) {
            throw new IOException(e);
        }
    }

    static {
        PersistableBundle.EMPTY.mMap = ArrayMap.EMPTY;
        CREATOR = new Parcelable.Creator<PersistableBundle>(){

            @Override
            public PersistableBundle createFromParcel(Parcel in) {
                return in.readPersistableBundle();
            }

            public PersistableBundle[] newArray(int size) {
                return new PersistableBundle[size];
            }
        };
    }

    static class MyReadMapCallback
    implements XmlUtils.ReadMapCallback {
        MyReadMapCallback() {
        }

        @Override
        public Object readThisUnknownObjectXml(TypedXmlPullParser in, String tag) throws XmlPullParserException, IOException {
            if (PersistableBundle.TAG_PERSISTABLEMAP.equals(tag)) {
                return PersistableBundle.restoreFromXml(in);
            }
            throw new XmlPullParserException("Unknown tag=" + tag);
        }
    }
}

