/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.app.AppOpsManager;
import android.compat.annotation.UnsupportedAppUsage;
import android.os.BadParcelableException;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.NetworkOnMainThreadException;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.os.PersistableBundle;
import android.os.RemoteException;
import android.os.ServiceSpecificException;
import android.os.StrictMode;
import android.os.SystemClock;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.ExceptionUtils;
import android.util.Log;
import android.util.Size;
import android.util.SizeF;
import android.util.Slog;
import android.util.SparseArray;
import android.util.SparseBooleanArray;
import android.util.SparseIntArray;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.util.ArrayUtils;
import com.android.tools.layoutlib.create.OverrideMethod;
import dalvik.annotation.optimization.CriticalNative;
import dalvik.annotation.optimization.FastNative;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import libcore.util.SneakyThrow;

public class Parcel {
    private static final boolean DEBUG_RECYCLE = false;
    private static final boolean DEBUG_ARRAY_MAP = false;
    private static final String TAG = "Parcel";
    @UnsupportedAppUsage
    private long mNativePtr;
    private boolean mOwnsNativeParcelObject;
    private long mNativeSize;
    private ArrayMap<Class, Object> mClassCookies;
    private RuntimeException mStack;
    private static boolean sParcelExceptionStackTrace;
    private static final Object sPoolSync;
    @GuardedBy(value={"sPoolSync"})
    private Parcel mPoolNext;
    @GuardedBy(value={"sPoolSync"})
    private static Parcel sOwnedPool;
    @GuardedBy(value={"sPoolSync"})
    private static Parcel sHolderPool;
    @GuardedBy(value={"sPoolSync"})
    private static int sOwnedPoolSize;
    @GuardedBy(value={"sPoolSync"})
    private static int sHolderPoolSize;
    private static final int POOL_SIZE = 32;
    private static final int VAL_NULL = -1;
    private static final int VAL_STRING = 0;
    private static final int VAL_INTEGER = 1;
    private static final int VAL_MAP = 2;
    private static final int VAL_BUNDLE = 3;
    private static final int VAL_PARCELABLE = 4;
    private static final int VAL_SHORT = 5;
    private static final int VAL_LONG = 6;
    private static final int VAL_FLOAT = 7;
    private static final int VAL_DOUBLE = 8;
    private static final int VAL_BOOLEAN = 9;
    private static final int VAL_CHARSEQUENCE = 10;
    private static final int VAL_LIST = 11;
    private static final int VAL_SPARSEARRAY = 12;
    private static final int VAL_BYTEARRAY = 13;
    private static final int VAL_STRINGARRAY = 14;
    private static final int VAL_IBINDER = 15;
    private static final int VAL_PARCELABLEARRAY = 16;
    private static final int VAL_OBJECTARRAY = 17;
    private static final int VAL_INTARRAY = 18;
    private static final int VAL_LONGARRAY = 19;
    private static final int VAL_BYTE = 20;
    private static final int VAL_SERIALIZABLE = 21;
    private static final int VAL_SPARSEBOOLEANARRAY = 22;
    private static final int VAL_BOOLEANARRAY = 23;
    private static final int VAL_CHARSEQUENCEARRAY = 24;
    private static final int VAL_PERSISTABLEBUNDLE = 25;
    private static final int VAL_SIZE = 26;
    private static final int VAL_SIZEF = 27;
    private static final int VAL_DOUBLEARRAY = 28;
    private static final int EX_SECURITY = -1;
    private static final int EX_BAD_PARCELABLE = -2;
    private static final int EX_ILLEGAL_ARGUMENT = -3;
    private static final int EX_NULL_POINTER = -4;
    private static final int EX_ILLEGAL_STATE = -5;
    private static final int EX_NETWORK_MAIN_THREAD = -6;
    private static final int EX_UNSUPPORTED_OPERATION = -7;
    private static final int EX_SERVICE_SPECIFIC = -8;
    private static final int EX_PARCELABLE = -9;
    public static final int EX_HAS_NOTED_APPOPS_REPLY_HEADER = -127;
    private static final int EX_HAS_STRICTMODE_REPLY_HEADER = -128;
    private static final int EX_TRANSACTION_FAILED = -129;
    private static volatile long sLastWriteExceptionStackTrace;
    private static final int WRITE_EXCEPTION_STACK_TRACE_THRESHOLD_MS = 1000;
    public static final Parcelable.Creator<String> STRING_CREATOR;
    private ReadWriteHelper mReadWriteHelper = ReadWriteHelper.DEFAULT;
    private static final int OK = 0;
    private ArrayMap<Parcelable, Integer> mWrittenSquashableParcelables;
    private boolean mAllowSquashing = false;
    private SparseArray<Parcelable> mReadSquashableParcelables;
    @UnsupportedAppUsage(maxTargetSdk=28)
    private static final HashMap<ClassLoader, HashMap<String, Parcelable.Creator<?>>> mCreators;

    @CriticalNative
    private static void nativeMarkSensitive(long l) {
        OverrideMethod.invokeV("android.os.Parcel#nativeMarkSensitive(J)V", true, null);
    }

    @CriticalNative
    private static int nativeDataSize(long l) {
        return OverrideMethod.invokeI("android.os.Parcel#nativeDataSize(J)I", true, null);
    }

    @CriticalNative
    private static int nativeDataAvail(long l) {
        return OverrideMethod.invokeI("android.os.Parcel#nativeDataAvail(J)I", true, null);
    }

    @CriticalNative
    private static int nativeDataPosition(long l) {
        return OverrideMethod.invokeI("android.os.Parcel#nativeDataPosition(J)I", true, null);
    }

    @CriticalNative
    private static int nativeDataCapacity(long l) {
        return OverrideMethod.invokeI("android.os.Parcel#nativeDataCapacity(J)I", true, null);
    }

    @FastNative
    private static void nativeSetDataSize(long l, int n) {
        OverrideMethod.invokeV("android.os.Parcel#nativeSetDataSize(JI)V", true, null);
    }

    @CriticalNative
    private static void nativeSetDataPosition(long l, int n) {
        OverrideMethod.invokeV("android.os.Parcel#nativeSetDataPosition(JI)V", true, null);
    }

    @FastNative
    private static void nativeSetDataCapacity(long l, int n) {
        OverrideMethod.invokeV("android.os.Parcel#nativeSetDataCapacity(JI)V", true, null);
    }

    @CriticalNative
    private static boolean nativePushAllowFds(long l, boolean bl) {
        return OverrideMethod.invokeI("android.os.Parcel#nativePushAllowFds(JZ)Z", true, null) != 0;
    }

    @CriticalNative
    private static void nativeRestoreAllowFds(long l, boolean bl) {
        OverrideMethod.invokeV("android.os.Parcel#nativeRestoreAllowFds(JZ)V", true, null);
    }

    private static void nativeWriteByteArray(long l, byte[] byArray, int n, int n2) {
        OverrideMethod.invokeV("android.os.Parcel#nativeWriteByteArray(J[BII)V", true, null);
    }

    private static void nativeWriteBlob(long l, byte[] byArray, int n, int n2) {
        OverrideMethod.invokeV("android.os.Parcel#nativeWriteBlob(J[BII)V", true, null);
    }

    @CriticalNative
    private static int nativeWriteInt(long l, int n) {
        return OverrideMethod.invokeI("android.os.Parcel#nativeWriteInt(JI)I", true, null);
    }

    @CriticalNative
    private static int nativeWriteLong(long l, long l2) {
        return OverrideMethod.invokeI("android.os.Parcel#nativeWriteLong(JJ)I", true, null);
    }

    @CriticalNative
    private static int nativeWriteFloat(long l, float f) {
        return OverrideMethod.invokeI("android.os.Parcel#nativeWriteFloat(JF)I", true, null);
    }

    @CriticalNative
    private static int nativeWriteDouble(long l, double d) {
        return OverrideMethod.invokeI("android.os.Parcel#nativeWriteDouble(JD)I", true, null);
    }

    private static void nativeSignalExceptionForError(int n) {
        OverrideMethod.invokeV("android.os.Parcel#nativeSignalExceptionForError(I)V", true, null);
    }

    @FastNative
    private static void nativeWriteString8(long l, String string2) {
        OverrideMethod.invokeV("android.os.Parcel#nativeWriteString8(JLjava/lang/String;)V", true, null);
    }

    @FastNative
    private static void nativeWriteString16(long l, String string2) {
        OverrideMethod.invokeV("android.os.Parcel#nativeWriteString16(JLjava/lang/String;)V", true, null);
    }

    @FastNative
    private static void nativeWriteStrongBinder(long l, IBinder iBinder) {
        OverrideMethod.invokeV("android.os.Parcel#nativeWriteStrongBinder(JLandroid/os/IBinder;)V", true, null);
    }

    @FastNative
    private static void nativeWriteFileDescriptor(long l, FileDescriptor fileDescriptor) {
        OverrideMethod.invokeV("android.os.Parcel#nativeWriteFileDescriptor(JLjava/io/FileDescriptor;)V", true, null);
    }

    private static byte[] nativeCreateByteArray(long l) {
        return (byte[])OverrideMethod.invokeA("android.os.Parcel#nativeCreateByteArray(J)[B", true, null);
    }

    private static boolean nativeReadByteArray(long l, byte[] byArray, int n) {
        return OverrideMethod.invokeI("android.os.Parcel#nativeReadByteArray(J[BI)Z", true, null) != 0;
    }

    private static byte[] nativeReadBlob(long l) {
        return (byte[])OverrideMethod.invokeA("android.os.Parcel#nativeReadBlob(J)[B", true, null);
    }

    @CriticalNative
    private static int nativeReadInt(long l) {
        return OverrideMethod.invokeI("android.os.Parcel#nativeReadInt(J)I", true, null);
    }

    @CriticalNative
    private static long nativeReadLong(long l) {
        return OverrideMethod.invokeL("android.os.Parcel#nativeReadLong(J)J", true, null);
    }

    @CriticalNative
    private static float nativeReadFloat(long l) {
        return OverrideMethod.invokeF("android.os.Parcel#nativeReadFloat(J)F", true, null);
    }

    @CriticalNative
    private static double nativeReadDouble(long l) {
        return OverrideMethod.invokeD("android.os.Parcel#nativeReadDouble(J)D", true, null);
    }

    @FastNative
    private static String nativeReadString8(long l) {
        return (String)OverrideMethod.invokeA("android.os.Parcel#nativeReadString8(J)Ljava/lang/String;", true, null);
    }

    @FastNative
    private static String nativeReadString16(long l) {
        return (String)OverrideMethod.invokeA("android.os.Parcel#nativeReadString16(J)Ljava/lang/String;", true, null);
    }

    @FastNative
    private static IBinder nativeReadStrongBinder(long l) {
        return (IBinder)OverrideMethod.invokeA("android.os.Parcel#nativeReadStrongBinder(J)Landroid/os/IBinder;", true, null);
    }

    @FastNative
    private static FileDescriptor nativeReadFileDescriptor(long l) {
        return (FileDescriptor)OverrideMethod.invokeA("android.os.Parcel#nativeReadFileDescriptor(J)Ljava/io/FileDescriptor;", true, null);
    }

    private static long nativeCreate() {
        return OverrideMethod.invokeL("android.os.Parcel#nativeCreate()J", true, null);
    }

    private static void nativeFreeBuffer(long l) {
        OverrideMethod.invokeV("android.os.Parcel#nativeFreeBuffer(J)V", true, null);
    }

    private static void nativeDestroy(long l) {
        OverrideMethod.invokeV("android.os.Parcel#nativeDestroy(J)V", true, null);
    }

    private static byte[] nativeMarshall(long l) {
        return (byte[])OverrideMethod.invokeA("android.os.Parcel#nativeMarshall(J)[B", true, null);
    }

    private static void nativeUnmarshall(long l, byte[] byArray, int n, int n2) {
        OverrideMethod.invokeV("android.os.Parcel#nativeUnmarshall(J[BII)V", true, null);
    }

    private static int nativeCompareData(long l, long l2) {
        return OverrideMethod.invokeI("android.os.Parcel#nativeCompareData(JJ)I", true, null);
    }

    private static void nativeAppendFrom(long l, long l2, int n, int n2) {
        OverrideMethod.invokeV("android.os.Parcel#nativeAppendFrom(JJII)V", true, null);
    }

    @CriticalNative
    private static boolean nativeHasFileDescriptors(long l) {
        return OverrideMethod.invokeI("android.os.Parcel#nativeHasFileDescriptors(J)Z", true, null) != 0;
    }

    private static void nativeWriteInterfaceToken(long l, String string2) {
        OverrideMethod.invokeV("android.os.Parcel#nativeWriteInterfaceToken(JLjava/lang/String;)V", true, null);
    }

    private static void nativeEnforceInterface(long l, String string2) {
        OverrideMethod.invokeV("android.os.Parcel#nativeEnforceInterface(JLjava/lang/String;)V", true, null);
    }

    @CriticalNative
    private static boolean nativeReplaceCallingWorkSourceUid(long l, int n) {
        return OverrideMethod.invokeI("android.os.Parcel#nativeReplaceCallingWorkSourceUid(JI)Z", true, null) != 0;
    }

    @CriticalNative
    private static int nativeReadCallingWorkSourceUid(long l) {
        return OverrideMethod.invokeI("android.os.Parcel#nativeReadCallingWorkSourceUid(J)I", true, null);
    }

    @CriticalNative
    private static long nativeGetBlobAshmemSize(long l) {
        return OverrideMethod.invokeL("android.os.Parcel#nativeGetBlobAshmemSize(J)J", true, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Parcel obtain() {
        Parcel res = null;
        Object object = sPoolSync;
        synchronized (object) {
            if (sOwnedPool != null) {
                res = sOwnedPool;
                sOwnedPool = res.mPoolNext;
                res.mPoolNext = null;
                --sOwnedPoolSize;
            }
        }
        if (res == null) {
            res = new Parcel(0L);
        } else {
            res.mReadWriteHelper = ReadWriteHelper.DEFAULT;
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recycle() {
        this.freeBuffer();
        if (this.mOwnsNativeParcelObject) {
            Object object = sPoolSync;
            synchronized (object) {
                if (sOwnedPoolSize < 32) {
                    this.mPoolNext = sOwnedPool;
                    sOwnedPool = this;
                    ++sOwnedPoolSize;
                }
            }
        }
        this.mNativePtr = 0L;
        Object object = sPoolSync;
        synchronized (object) {
            if (sHolderPoolSize < 32) {
                this.mPoolNext = sHolderPool;
                sHolderPool = this;
                ++sHolderPoolSize;
            }
        }
    }

    public void setReadWriteHelper(ReadWriteHelper helper) {
        this.mReadWriteHelper = helper != null ? helper : ReadWriteHelper.DEFAULT;
    }

    public boolean hasReadWriteHelper() {
        return this.mReadWriteHelper != null && this.mReadWriteHelper != ReadWriteHelper.DEFAULT;
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public static long getGlobalAllocSize() {
        return OverrideMethod.invokeL("android.os.Parcel#getGlobalAllocSize()J", true, null);
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public static long getGlobalAllocCount() {
        return OverrideMethod.invokeL("android.os.Parcel#getGlobalAllocCount()J", true, null);
    }

    public void markSensitive() {
        Parcel.nativeMarkSensitive(this.mNativePtr);
    }

    public int dataSize() {
        return Parcel.nativeDataSize(this.mNativePtr);
    }

    public int dataAvail() {
        return Parcel.nativeDataAvail(this.mNativePtr);
    }

    public int dataPosition() {
        return Parcel.nativeDataPosition(this.mNativePtr);
    }

    public int dataCapacity() {
        return Parcel.nativeDataCapacity(this.mNativePtr);
    }

    public void setDataSize(int size) {
        Parcel.nativeSetDataSize(this.mNativePtr, size);
    }

    public void setDataPosition(int pos) {
        Parcel.nativeSetDataPosition(this.mNativePtr, pos);
    }

    public void setDataCapacity(int size) {
        Parcel.nativeSetDataCapacity(this.mNativePtr, size);
    }

    public boolean pushAllowFds(boolean allowFds) {
        return Parcel.nativePushAllowFds(this.mNativePtr, allowFds);
    }

    public void restoreAllowFds(boolean lastValue) {
        Parcel.nativeRestoreAllowFds(this.mNativePtr, lastValue);
    }

    public byte[] marshall() {
        return Parcel.nativeMarshall(this.mNativePtr);
    }

    public void unmarshall(byte[] data, int offset2, int length) {
        Parcel.nativeUnmarshall(this.mNativePtr, data, offset2, length);
    }

    public void appendFrom(Parcel parcel, int offset2, int length) {
        Parcel.nativeAppendFrom(this.mNativePtr, parcel.mNativePtr, offset2, length);
    }

    public int compareData(Parcel other) {
        return Parcel.nativeCompareData(this.mNativePtr, other.mNativePtr);
    }

    public void setClassCookie(Class clz, Object cookie) {
        if (this.mClassCookies == null) {
            this.mClassCookies = new ArrayMap();
        }
        this.mClassCookies.put(clz, cookie);
    }

    public Object getClassCookie(Class clz) {
        return this.mClassCookies != null ? this.mClassCookies.get(clz) : null;
    }

    public void adoptClassCookies(Parcel from) {
        this.mClassCookies = from.mClassCookies;
    }

    public Map<Class, Object> copyClassCookies() {
        return new ArrayMap<Class, Object>(this.mClassCookies);
    }

    public void putClassCookies(Map<Class, Object> cookies) {
        if (cookies == null) {
            return;
        }
        if (this.mClassCookies == null) {
            this.mClassCookies = new ArrayMap();
        }
        this.mClassCookies.putAll(cookies);
    }

    public boolean hasFileDescriptors() {
        return Parcel.nativeHasFileDescriptors(this.mNativePtr);
    }

    public void writeInterfaceToken(String interfaceName) {
        Parcel.nativeWriteInterfaceToken(this.mNativePtr, interfaceName);
    }

    public void enforceInterface(String interfaceName) {
        Parcel.nativeEnforceInterface(this.mNativePtr, interfaceName);
    }

    public boolean replaceCallingWorkSourceUid(int workSourceUid) {
        return Parcel.nativeReplaceCallingWorkSourceUid(this.mNativePtr, workSourceUid);
    }

    public int readCallingWorkSourceUid() {
        return Parcel.nativeReadCallingWorkSourceUid(this.mNativePtr);
    }

    public void writeByteArray(byte[] b) {
        this.writeByteArray(b, 0, b != null ? b.length : 0);
    }

    public void writeByteArray(byte[] b, int offset2, int len) {
        if (b == null) {
            this.writeInt(-1);
            return;
        }
        ArrayUtils.throwsIfOutOfBounds(b.length, offset2, len);
        Parcel.nativeWriteByteArray(this.mNativePtr, b, offset2, len);
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public void writeBlob(byte[] b) {
        this.writeBlob(b, 0, b != null ? b.length : 0);
    }

    public void writeBlob(byte[] b, int offset2, int len) {
        if (b == null) {
            this.writeInt(-1);
            return;
        }
        ArrayUtils.throwsIfOutOfBounds(b.length, offset2, len);
        Parcel.nativeWriteBlob(this.mNativePtr, b, offset2, len);
    }

    public void writeInt(int val) {
        int err = Parcel.nativeWriteInt(this.mNativePtr, val);
        if (err != 0) {
            Parcel.nativeSignalExceptionForError(err);
        }
    }

    public void writeLong(long val) {
        int err = Parcel.nativeWriteLong(this.mNativePtr, val);
        if (err != 0) {
            Parcel.nativeSignalExceptionForError(err);
        }
    }

    public void writeFloat(float val) {
        int err = Parcel.nativeWriteFloat(this.mNativePtr, val);
        if (err != 0) {
            Parcel.nativeSignalExceptionForError(err);
        }
    }

    public void writeDouble(double val) {
        int err = Parcel.nativeWriteDouble(this.mNativePtr, val);
        if (err != 0) {
            Parcel.nativeSignalExceptionForError(err);
        }
    }

    public void writeString(String val) {
        this.writeString16(val);
    }

    public void writeString8(String val) {
        this.mReadWriteHelper.writeString8(this, val);
    }

    public void writeString16(String val) {
        this.mReadWriteHelper.writeString16(this, val);
    }

    public void writeStringNoHelper(String val) {
        this.writeString16NoHelper(val);
    }

    public void writeString8NoHelper(String val) {
        Parcel.nativeWriteString8(this.mNativePtr, val);
    }

    public void writeString16NoHelper(String val) {
        Parcel.nativeWriteString16(this.mNativePtr, val);
    }

    public void writeBoolean(boolean val) {
        this.writeInt(val ? 1 : 0);
    }

    @UnsupportedAppUsage
    public void writeCharSequence(CharSequence val) {
        TextUtils.writeToParcel(val, this, 0);
    }

    public void writeStrongBinder(IBinder val) {
        Parcel.nativeWriteStrongBinder(this.mNativePtr, val);
    }

    public void writeStrongInterface(IInterface val) {
        this.writeStrongBinder(val == null ? null : val.asBinder());
    }

    public void writeFileDescriptor(FileDescriptor val) {
        Parcel.nativeWriteFileDescriptor(this.mNativePtr, val);
    }

    public void writeRawFileDescriptor(FileDescriptor val) {
        Parcel.nativeWriteFileDescriptor(this.mNativePtr, val);
    }

    public void writeRawFileDescriptorArray(FileDescriptor[] value2) {
        if (value2 != null) {
            int N = value2.length;
            this.writeInt(N);
            for (int i = 0; i < N; ++i) {
                this.writeRawFileDescriptor(value2[i]);
            }
        } else {
            this.writeInt(-1);
        }
    }

    public void writeByte(byte val) {
        this.writeInt(val);
    }

    public void writeMap(Map val) {
        this.writeMapInternal(val);
    }

    void writeMapInternal(Map<String, Object> val) {
        if (val == null) {
            this.writeInt(-1);
            return;
        }
        Set<Map.Entry<String, Object>> entries = val.entrySet();
        int size = entries.size();
        this.writeInt(size);
        for (Map.Entry<String, Object> e : entries) {
            this.writeValue(e.getKey());
            this.writeValue(e.getValue());
            --size;
        }
        if (size != 0) {
            throw new BadParcelableException("Map size does not match number of entries!");
        }
    }

    void writeArrayMapInternal(ArrayMap<String, Object> val) {
        if (val == null) {
            this.writeInt(-1);
            return;
        }
        int N = val.size();
        this.writeInt(N);
        for (int i = 0; i < N; ++i) {
            this.writeString(val.keyAt(i));
            this.writeValue(val.valueAt(i));
        }
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public void writeArrayMap(ArrayMap<String, Object> val) {
        this.writeArrayMapInternal(val);
    }

    public <T extends Parcelable> void writeTypedArrayMap(ArrayMap<String, T> val, int parcelableFlags) {
        if (val == null) {
            this.writeInt(-1);
            return;
        }
        int count = val.size();
        this.writeInt(count);
        for (int i = 0; i < count; ++i) {
            this.writeString(val.keyAt(i));
            this.writeTypedObject((Parcelable)val.valueAt(i), parcelableFlags);
        }
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public void writeArraySet(ArraySet<? extends Object> val) {
        int size = val != null ? val.size() : -1;
        this.writeInt(size);
        for (int i = 0; i < size; ++i) {
            this.writeValue(val.valueAt(i));
        }
    }

    public void writeBundle(Bundle val) {
        if (val == null) {
            this.writeInt(-1);
            return;
        }
        val.writeToParcel(this, 0);
    }

    public void writePersistableBundle(PersistableBundle val) {
        if (val == null) {
            this.writeInt(-1);
            return;
        }
        val.writeToParcel(this, 0);
    }

    public void writeSize(Size val) {
        this.writeInt(val.getWidth());
        this.writeInt(val.getHeight());
    }

    public void writeSizeF(SizeF val) {
        this.writeFloat(val.getWidth());
        this.writeFloat(val.getHeight());
    }

    public void writeList(List val) {
        if (val == null) {
            this.writeInt(-1);
            return;
        }
        int N = val.size();
        this.writeInt(N);
        for (int i = 0; i < N; ++i) {
            this.writeValue(val.get(i));
        }
    }

    public void writeArray(Object[] val) {
        if (val == null) {
            this.writeInt(-1);
            return;
        }
        int N = val.length;
        this.writeInt(N);
        for (int i = 0; i < N; ++i) {
            this.writeValue(val[i]);
        }
    }

    public <T> void writeSparseArray(SparseArray<T> val) {
        if (val == null) {
            this.writeInt(-1);
            return;
        }
        int N = val.size();
        this.writeInt(N);
        for (int i = 0; i < N; ++i) {
            this.writeInt(val.keyAt(i));
            this.writeValue(val.valueAt(i));
        }
    }

    public void writeSparseBooleanArray(SparseBooleanArray val) {
        if (val == null) {
            this.writeInt(-1);
            return;
        }
        int N = val.size();
        this.writeInt(N);
        for (int i = 0; i < N; ++i) {
            this.writeInt(val.keyAt(i));
            this.writeByte((byte)(val.valueAt(i) ? 1 : 0));
        }
    }

    public void writeSparseIntArray(SparseIntArray val) {
        if (val == null) {
            this.writeInt(-1);
            return;
        }
        int N = val.size();
        this.writeInt(N);
        for (int i = 0; i < N; ++i) {
            this.writeInt(val.keyAt(i));
            this.writeInt(val.valueAt(i));
        }
    }

    public void writeBooleanArray(boolean[] val) {
        if (val != null) {
            int N = val.length;
            this.writeInt(N);
            for (int i = 0; i < N; ++i) {
                this.writeInt(val[i] ? 1 : 0);
            }
        } else {
            this.writeInt(-1);
        }
    }

    public boolean[] createBooleanArray() {
        int N = this.readInt();
        if (N >= 0 && N <= this.dataAvail() >> 2) {
            boolean[] val = new boolean[N];
            for (int i = 0; i < N; ++i) {
                val[i] = this.readInt() != 0;
            }
            return val;
        }
        return null;
    }

    public void readBooleanArray(boolean[] val) {
        int N = this.readInt();
        if (N == val.length) {
            for (int i = 0; i < N; ++i) {
                val[i] = this.readInt() != 0;
            }
        } else {
            throw new RuntimeException("bad array lengths");
        }
    }

    public void writeCharArray(char[] val) {
        if (val != null) {
            int N = val.length;
            this.writeInt(N);
            for (int i = 0; i < N; ++i) {
                this.writeInt(val[i]);
            }
        } else {
            this.writeInt(-1);
        }
    }

    public char[] createCharArray() {
        int N = this.readInt();
        if (N >= 0 && N <= this.dataAvail() >> 2) {
            char[] val = new char[N];
            for (int i = 0; i < N; ++i) {
                val[i] = (char)this.readInt();
            }
            return val;
        }
        return null;
    }

    public void readCharArray(char[] val) {
        int N = this.readInt();
        if (N == val.length) {
            for (int i = 0; i < N; ++i) {
                val[i] = (char)this.readInt();
            }
        } else {
            throw new RuntimeException("bad array lengths");
        }
    }

    public void writeIntArray(int[] val) {
        if (val != null) {
            int N = val.length;
            this.writeInt(N);
            for (int i = 0; i < N; ++i) {
                this.writeInt(val[i]);
            }
        } else {
            this.writeInt(-1);
        }
    }

    public int[] createIntArray() {
        int N = this.readInt();
        if (N >= 0 && N <= this.dataAvail() >> 2) {
            int[] val = new int[N];
            for (int i = 0; i < N; ++i) {
                val[i] = this.readInt();
            }
            return val;
        }
        return null;
    }

    public void readIntArray(int[] val) {
        int N = this.readInt();
        if (N == val.length) {
            for (int i = 0; i < N; ++i) {
                val[i] = this.readInt();
            }
        } else {
            throw new RuntimeException("bad array lengths");
        }
    }

    public void writeLongArray(long[] val) {
        if (val != null) {
            int N = val.length;
            this.writeInt(N);
            for (int i = 0; i < N; ++i) {
                this.writeLong(val[i]);
            }
        } else {
            this.writeInt(-1);
        }
    }

    public long[] createLongArray() {
        int N = this.readInt();
        if (N >= 0 && N <= this.dataAvail() >> 3) {
            long[] val = new long[N];
            for (int i = 0; i < N; ++i) {
                val[i] = this.readLong();
            }
            return val;
        }
        return null;
    }

    public void readLongArray(long[] val) {
        int N = this.readInt();
        if (N == val.length) {
            for (int i = 0; i < N; ++i) {
                val[i] = this.readLong();
            }
        } else {
            throw new RuntimeException("bad array lengths");
        }
    }

    public void writeFloatArray(float[] val) {
        if (val != null) {
            int N = val.length;
            this.writeInt(N);
            for (int i = 0; i < N; ++i) {
                this.writeFloat(val[i]);
            }
        } else {
            this.writeInt(-1);
        }
    }

    public float[] createFloatArray() {
        int N = this.readInt();
        if (N >= 0 && N <= this.dataAvail() >> 2) {
            float[] val = new float[N];
            for (int i = 0; i < N; ++i) {
                val[i] = this.readFloat();
            }
            return val;
        }
        return null;
    }

    public void readFloatArray(float[] val) {
        int N = this.readInt();
        if (N == val.length) {
            for (int i = 0; i < N; ++i) {
                val[i] = this.readFloat();
            }
        } else {
            throw new RuntimeException("bad array lengths");
        }
    }

    public void writeDoubleArray(double[] val) {
        if (val != null) {
            int N = val.length;
            this.writeInt(N);
            for (int i = 0; i < N; ++i) {
                this.writeDouble(val[i]);
            }
        } else {
            this.writeInt(-1);
        }
    }

    public double[] createDoubleArray() {
        int N = this.readInt();
        if (N >= 0 && N <= this.dataAvail() >> 3) {
            double[] val = new double[N];
            for (int i = 0; i < N; ++i) {
                val[i] = this.readDouble();
            }
            return val;
        }
        return null;
    }

    public void readDoubleArray(double[] val) {
        int N = this.readInt();
        if (N == val.length) {
            for (int i = 0; i < N; ++i) {
                val[i] = this.readDouble();
            }
        } else {
            throw new RuntimeException("bad array lengths");
        }
    }

    public void writeStringArray(String[] val) {
        this.writeString16Array(val);
    }

    public String[] createStringArray() {
        return this.createString16Array();
    }

    public void readStringArray(String[] val) {
        this.readString16Array(val);
    }

    public void writeString8Array(String[] val) {
        if (val != null) {
            int N = val.length;
            this.writeInt(N);
            for (int i = 0; i < N; ++i) {
                this.writeString8(val[i]);
            }
        } else {
            this.writeInt(-1);
        }
    }

    public String[] createString8Array() {
        int N = this.readInt();
        if (N >= 0) {
            String[] val = new String[N];
            for (int i = 0; i < N; ++i) {
                val[i] = this.readString8();
            }
            return val;
        }
        return null;
    }

    public void readString8Array(String[] val) {
        int N = this.readInt();
        if (N == val.length) {
            for (int i = 0; i < N; ++i) {
                val[i] = this.readString8();
            }
        } else {
            throw new RuntimeException("bad array lengths");
        }
    }

    public void writeString16Array(String[] val) {
        if (val != null) {
            int N = val.length;
            this.writeInt(N);
            for (int i = 0; i < N; ++i) {
                this.writeString16(val[i]);
            }
        } else {
            this.writeInt(-1);
        }
    }

    public String[] createString16Array() {
        int N = this.readInt();
        if (N >= 0) {
            String[] val = new String[N];
            for (int i = 0; i < N; ++i) {
                val[i] = this.readString16();
            }
            return val;
        }
        return null;
    }

    public void readString16Array(String[] val) {
        int N = this.readInt();
        if (N == val.length) {
            for (int i = 0; i < N; ++i) {
                val[i] = this.readString16();
            }
        } else {
            throw new RuntimeException("bad array lengths");
        }
    }

    public void writeBinderArray(IBinder[] val) {
        if (val != null) {
            int N = val.length;
            this.writeInt(N);
            for (int i = 0; i < N; ++i) {
                this.writeStrongBinder(val[i]);
            }
        } else {
            this.writeInt(-1);
        }
    }

    public void writeCharSequenceArray(CharSequence[] val) {
        if (val != null) {
            int N = val.length;
            this.writeInt(N);
            for (int i = 0; i < N; ++i) {
                this.writeCharSequence(val[i]);
            }
        } else {
            this.writeInt(-1);
        }
    }

    public void writeCharSequenceList(ArrayList<CharSequence> val) {
        if (val != null) {
            int N = val.size();
            this.writeInt(N);
            for (int i = 0; i < N; ++i) {
                this.writeCharSequence(val.get(i));
            }
        } else {
            this.writeInt(-1);
        }
    }

    public IBinder[] createBinderArray() {
        int N = this.readInt();
        if (N >= 0) {
            IBinder[] val = new IBinder[N];
            for (int i = 0; i < N; ++i) {
                val[i] = this.readStrongBinder();
            }
            return val;
        }
        return null;
    }

    public void readBinderArray(IBinder[] val) {
        int N = this.readInt();
        if (N == val.length) {
            for (int i = 0; i < N; ++i) {
                val[i] = this.readStrongBinder();
            }
        } else {
            throw new RuntimeException("bad array lengths");
        }
    }

    public <T extends Parcelable> void writeTypedList(List<T> val) {
        this.writeTypedList(val, 0);
    }

    public <T extends Parcelable> void writeTypedSparseArray(SparseArray<T> val, int parcelableFlags) {
        if (val == null) {
            this.writeInt(-1);
            return;
        }
        int count = val.size();
        this.writeInt(count);
        for (int i = 0; i < count; ++i) {
            this.writeInt(val.keyAt(i));
            this.writeTypedObject((Parcelable)val.valueAt(i), parcelableFlags);
        }
    }

    public <T extends Parcelable> void writeTypedList(List<T> val, int parcelableFlags) {
        if (val == null) {
            this.writeInt(-1);
            return;
        }
        int N = val.size();
        this.writeInt(N);
        for (int i = 0; i < N; ++i) {
            this.writeTypedObject((Parcelable)val.get(i), parcelableFlags);
        }
    }

    public void writeStringList(List<String> val) {
        if (val == null) {
            this.writeInt(-1);
            return;
        }
        int N = val.size();
        this.writeInt(N);
        for (int i = 0; i < N; ++i) {
            this.writeString(val.get(i));
        }
    }

    public void writeBinderList(List<IBinder> val) {
        if (val == null) {
            this.writeInt(-1);
            return;
        }
        int N = val.size();
        this.writeInt(N);
        for (int i = 0; i < N; ++i) {
            this.writeStrongBinder(val.get(i));
        }
    }

    public <T extends Parcelable> void writeParcelableList(List<T> val, int flags) {
        if (val == null) {
            this.writeInt(-1);
            return;
        }
        int N = val.size();
        this.writeInt(N);
        for (int i = 0; i < N; ++i) {
            this.writeParcelable((Parcelable)val.get(i), flags);
        }
    }

    public <T extends Parcelable> void writeTypedArray(T[] val, int parcelableFlags) {
        if (val != null) {
            int N = val.length;
            this.writeInt(N);
            for (int i = 0; i < N; ++i) {
                this.writeTypedObject(val[i], parcelableFlags);
            }
        } else {
            this.writeInt(-1);
        }
    }

    public <T extends Parcelable> void writeTypedObject(T val, int parcelableFlags) {
        if (val != null) {
            this.writeInt(1);
            val.writeToParcel(this, parcelableFlags);
        } else {
            this.writeInt(0);
        }
    }

    public void writeValue(Object v) {
        if (v == null) {
            this.writeInt(-1);
        } else if (v instanceof String) {
            this.writeInt(0);
            this.writeString((String)v);
        } else if (v instanceof Integer) {
            this.writeInt(1);
            this.writeInt((Integer)v);
        } else if (v instanceof Map) {
            this.writeInt(2);
            this.writeMap((Map)v);
        } else if (v instanceof Bundle) {
            this.writeInt(3);
            this.writeBundle((Bundle)v);
        } else if (v instanceof PersistableBundle) {
            this.writeInt(25);
            this.writePersistableBundle((PersistableBundle)v);
        } else if (v instanceof Parcelable) {
            this.writeInt(4);
            this.writeParcelable((Parcelable)v, 0);
        } else if (v instanceof Short) {
            this.writeInt(5);
            this.writeInt(((Short)v).intValue());
        } else if (v instanceof Long) {
            this.writeInt(6);
            this.writeLong((Long)v);
        } else if (v instanceof Float) {
            this.writeInt(7);
            this.writeFloat(((Float)v).floatValue());
        } else if (v instanceof Double) {
            this.writeInt(8);
            this.writeDouble((Double)v);
        } else if (v instanceof Boolean) {
            this.writeInt(9);
            this.writeInt((Boolean)v != false ? 1 : 0);
        } else if (v instanceof CharSequence) {
            this.writeInt(10);
            this.writeCharSequence((CharSequence)v);
        } else if (v instanceof List) {
            this.writeInt(11);
            this.writeList((List)v);
        } else if (v instanceof SparseArray) {
            this.writeInt(12);
            this.writeSparseArray((SparseArray)v);
        } else if (v instanceof boolean[]) {
            this.writeInt(23);
            this.writeBooleanArray((boolean[])v);
        } else if (v instanceof byte[]) {
            this.writeInt(13);
            this.writeByteArray((byte[])v);
        } else if (v instanceof String[]) {
            this.writeInt(14);
            this.writeStringArray((String[])v);
        } else if (v instanceof CharSequence[]) {
            this.writeInt(24);
            this.writeCharSequenceArray((CharSequence[])v);
        } else if (v instanceof IBinder) {
            this.writeInt(15);
            this.writeStrongBinder((IBinder)v);
        } else if (v instanceof Parcelable[]) {
            this.writeInt(16);
            this.writeParcelableArray((Parcelable[])v, 0);
        } else if (v instanceof int[]) {
            this.writeInt(18);
            this.writeIntArray((int[])v);
        } else if (v instanceof long[]) {
            this.writeInt(19);
            this.writeLongArray((long[])v);
        } else if (v instanceof Byte) {
            this.writeInt(20);
            this.writeInt(((Byte)v).byteValue());
        } else if (v instanceof Size) {
            this.writeInt(26);
            this.writeSize((Size)v);
        } else if (v instanceof SizeF) {
            this.writeInt(27);
            this.writeSizeF((SizeF)v);
        } else if (v instanceof double[]) {
            this.writeInt(28);
            this.writeDoubleArray((double[])v);
        } else {
            Class<?> clazz = v.getClass();
            if (clazz.isArray() && clazz.getComponentType() == Object.class) {
                this.writeInt(17);
                this.writeArray((Object[])v);
            } else if (v instanceof Serializable) {
                this.writeInt(21);
                this.writeSerializable((Serializable)v);
            } else {
                throw new RuntimeException("Parcel: unable to marshal value " + v);
            }
        }
    }

    public void writeParcelable(Parcelable p, int parcelableFlags) {
        if (p == null) {
            this.writeString(null);
            return;
        }
        this.writeParcelableCreator(p);
        p.writeToParcel(this, parcelableFlags);
    }

    public void writeParcelableCreator(Parcelable p) {
        String name = p.getClass().getName();
        this.writeString(name);
    }

    private void ensureWrittenSquashableParcelables() {
        if (this.mWrittenSquashableParcelables != null) {
            return;
        }
        this.mWrittenSquashableParcelables = new ArrayMap();
    }

    public boolean allowSquashing() {
        boolean previous = this.mAllowSquashing;
        this.mAllowSquashing = true;
        return previous;
    }

    public void restoreAllowSquashing(boolean previous) {
        this.mAllowSquashing = previous;
        if (!this.mAllowSquashing) {
            this.mWrittenSquashableParcelables = null;
        }
    }

    private void resetSqaushingState() {
        if (this.mAllowSquashing) {
            Slog.wtf(TAG, "allowSquashing wasn't restored.");
        }
        this.mWrittenSquashableParcelables = null;
        this.mReadSquashableParcelables = null;
        this.mAllowSquashing = false;
    }

    private void ensureReadSquashableParcelables() {
        if (this.mReadSquashableParcelables != null) {
            return;
        }
        this.mReadSquashableParcelables = new SparseArray();
    }

    public boolean maybeWriteSquashed(Parcelable p) {
        if (!this.mAllowSquashing) {
            this.writeInt(0);
            return false;
        }
        this.ensureWrittenSquashableParcelables();
        Integer firstPos = this.mWrittenSquashableParcelables.get(p);
        if (firstPos != null) {
            int pos = this.dataPosition();
            this.writeInt(pos - firstPos + 4);
            return true;
        }
        this.writeInt(0);
        int pos = this.dataPosition();
        this.mWrittenSquashableParcelables.put(p, pos);
        return false;
    }

    public <T extends Parcelable> T readSquashed(SquashReadHelper<T> reader) {
        int offset2 = this.readInt();
        int pos = this.dataPosition();
        if (offset2 == 0) {
            Parcelable p = (Parcelable)reader.readRawParceled(this);
            this.ensureReadSquashableParcelables();
            this.mReadSquashableParcelables.put(pos, p);
            return (T)p;
        }
        int firstAbsolutePos = pos - offset2;
        Parcelable p = this.mReadSquashableParcelables.get(firstAbsolutePos);
        if (p == null) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.mReadSquashableParcelables.size(); ++i) {
                sb.append(this.mReadSquashableParcelables.keyAt(i)).append(' ');
            }
            Slog.wtfStack(TAG, "Map doesn't contain offset " + firstAbsolutePos + " : contains=" + sb.toString());
        }
        return (T)p;
    }

    public void writeSerializable(Serializable s) {
        if (s == null) {
            this.writeString(null);
            return;
        }
        String name = s.getClass().getName();
        this.writeString(name);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(s);
            oos.close();
            this.writeByteArray(baos.toByteArray());
        }
        catch (IOException ioe) {
            throw new RuntimeException("Parcelable encountered IOException writing serializable object (name = " + name + ")", ioe);
        }
    }

    public static void setStackTraceParceling(boolean enabled) {
        sParcelExceptionStackTrace = enabled;
    }

    public void writeException(Exception e) {
        long timeNow;
        AppOpsManager.prefixParcelWithAppOpsIfNeeded(this);
        int code = Parcel.getExceptionCode(e);
        this.writeInt(code);
        StrictMode.clearGatheredViolations();
        if (code == 0) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
        this.writeString(e.getMessage());
        long l = timeNow = sParcelExceptionStackTrace ? SystemClock.elapsedRealtime() : 0L;
        if (sParcelExceptionStackTrace && timeNow - sLastWriteExceptionStackTrace > 1000L) {
            sLastWriteExceptionStackTrace = timeNow;
            this.writeStackTrace(e);
        } else {
            this.writeInt(0);
        }
        switch (code) {
            case -8: {
                this.writeInt(((ServiceSpecificException)e).errorCode);
                break;
            }
            case -9: {
                int sizePosition = this.dataPosition();
                this.writeInt(0);
                this.writeParcelable((Parcelable)((Object)e), 1);
                int payloadPosition = this.dataPosition();
                this.setDataPosition(sizePosition);
                this.writeInt(payloadPosition - sizePosition);
                this.setDataPosition(payloadPosition);
            }
        }
    }

    public static int getExceptionCode(Throwable e) {
        int code = 0;
        if (e instanceof Parcelable && e.getClass().getClassLoader() == Parcelable.class.getClassLoader()) {
            code = -9;
        } else if (e instanceof SecurityException) {
            code = -1;
        } else if (e instanceof BadParcelableException) {
            code = -2;
        } else if (e instanceof IllegalArgumentException) {
            code = -3;
        } else if (e instanceof NullPointerException) {
            code = -4;
        } else if (e instanceof IllegalStateException) {
            code = -5;
        } else if (e instanceof NetworkOnMainThreadException) {
            code = -6;
        } else if (e instanceof UnsupportedOperationException) {
            code = -7;
        } else if (e instanceof ServiceSpecificException) {
            code = -8;
        }
        return code;
    }

    public void writeStackTrace(Throwable e) {
        int sizePosition = this.dataPosition();
        this.writeInt(0);
        StackTraceElement[] stackTrace = e.getStackTrace();
        int truncatedSize = Math.min(stackTrace.length, 5);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < truncatedSize; ++i) {
            sb.append("\tat ").append(stackTrace[i]).append('\n');
        }
        this.writeString(sb.toString());
        int payloadPosition = this.dataPosition();
        this.setDataPosition(sizePosition);
        this.writeInt(payloadPosition - sizePosition);
        this.setDataPosition(payloadPosition);
    }

    public void writeNoException() {
        AppOpsManager.prefixParcelWithAppOpsIfNeeded(this);
        if (StrictMode.hasGatheredViolations()) {
            this.writeInt(-128);
            int sizePosition = this.dataPosition();
            this.writeInt(0);
            StrictMode.writeGatheredViolationsToParcel(this);
            int payloadPosition = this.dataPosition();
            this.setDataPosition(sizePosition);
            this.writeInt(payloadPosition - sizePosition);
            this.setDataPosition(payloadPosition);
        } else {
            this.writeInt(0);
        }
    }

    public void readException() {
        int code = this.readExceptionCode();
        if (code != 0) {
            String msg = this.readString();
            this.readException(code, msg);
        }
    }

    @UnsupportedAppUsage
    public int readExceptionCode() {
        int code = this.readInt();
        if (code == -127) {
            AppOpsManager.readAndLogNotedAppops(this);
            code = this.readInt();
        }
        if (code == -128) {
            int headerSize = this.readInt();
            if (headerSize == 0) {
                Log.e(TAG, "Unexpected zero-sized Parcel reply header.");
            } else {
                StrictMode.readAndHandleBinderCallViolations(this);
            }
            return 0;
        }
        return code;
    }

    public void readException(int code, String msg) {
        String remoteStackTrace = null;
        int remoteStackPayloadSize = this.readInt();
        if (remoteStackPayloadSize > 0) {
            remoteStackTrace = this.readString();
        }
        Exception e = this.createException(code, msg);
        if (remoteStackTrace != null) {
            RemoteException cause = new RemoteException("Remote stack trace:\n" + remoteStackTrace, null, false, false);
            ExceptionUtils.appendCause(e, cause);
        }
        SneakyThrow.sneakyThrow(e);
    }

    private Exception createException(int code, String msg) {
        Exception exception = this.createExceptionOrNull(code, msg);
        return exception != null ? exception : new RuntimeException("Unknown exception code: " + code + " msg " + msg);
    }

    public Exception createExceptionOrNull(int code, String msg) {
        switch (code) {
            case -9: {
                if (this.readInt() > 0) {
                    return (Exception)this.readParcelable(Parcelable.class.getClassLoader());
                }
                return new RuntimeException(msg + " [missing Parcelable]");
            }
            case -1: {
                return new SecurityException(msg);
            }
            case -2: {
                return new BadParcelableException(msg);
            }
            case -3: {
                return new IllegalArgumentException(msg);
            }
            case -4: {
                return new NullPointerException(msg);
            }
            case -5: {
                return new IllegalStateException(msg);
            }
            case -6: {
                return new NetworkOnMainThreadException();
            }
            case -7: {
                return new UnsupportedOperationException(msg);
            }
            case -8: {
                return new ServiceSpecificException(this.readInt(), msg);
            }
        }
        return null;
    }

    public int readInt() {
        return Parcel.nativeReadInt(this.mNativePtr);
    }

    public long readLong() {
        return Parcel.nativeReadLong(this.mNativePtr);
    }

    public float readFloat() {
        return Parcel.nativeReadFloat(this.mNativePtr);
    }

    public double readDouble() {
        return Parcel.nativeReadDouble(this.mNativePtr);
    }

    public String readString() {
        return this.readString16();
    }

    public String readString8() {
        return this.mReadWriteHelper.readString8(this);
    }

    public String readString16() {
        return this.mReadWriteHelper.readString16(this);
    }

    public String readStringNoHelper() {
        return this.readString16NoHelper();
    }

    public String readString8NoHelper() {
        return Parcel.nativeReadString8(this.mNativePtr);
    }

    public String readString16NoHelper() {
        return Parcel.nativeReadString16(this.mNativePtr);
    }

    public boolean readBoolean() {
        return this.readInt() != 0;
    }

    @UnsupportedAppUsage
    public CharSequence readCharSequence() {
        return TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(this);
    }

    public IBinder readStrongBinder() {
        return Parcel.nativeReadStrongBinder(this.mNativePtr);
    }

    public ParcelFileDescriptor readFileDescriptor() {
        FileDescriptor fd = Parcel.nativeReadFileDescriptor(this.mNativePtr);
        return fd != null ? new ParcelFileDescriptor(fd) : null;
    }

    @UnsupportedAppUsage
    public FileDescriptor readRawFileDescriptor() {
        return Parcel.nativeReadFileDescriptor(this.mNativePtr);
    }

    public FileDescriptor[] createRawFileDescriptorArray() {
        int N = this.readInt();
        if (N < 0) {
            return null;
        }
        FileDescriptor[] f = new FileDescriptor[N];
        for (int i = 0; i < N; ++i) {
            f[i] = this.readRawFileDescriptor();
        }
        return f;
    }

    public void readRawFileDescriptorArray(FileDescriptor[] val) {
        int N = this.readInt();
        if (N == val.length) {
            for (int i = 0; i < N; ++i) {
                val[i] = this.readRawFileDescriptor();
            }
        } else {
            throw new RuntimeException("bad array lengths");
        }
    }

    public byte readByte() {
        return (byte)(this.readInt() & 0xFF);
    }

    public void readMap(Map outVal, ClassLoader loader) {
        int N = this.readInt();
        this.readMapInternal(outVal, N, loader);
    }

    public void readList(List outVal, ClassLoader loader) {
        int N = this.readInt();
        this.readListInternal(outVal, N, loader);
    }

    public HashMap readHashMap(ClassLoader loader) {
        int N = this.readInt();
        if (N < 0) {
            return null;
        }
        HashMap m = new HashMap(N);
        this.readMapInternal(m, N, loader);
        return m;
    }

    public Bundle readBundle() {
        return this.readBundle(null);
    }

    public Bundle readBundle(ClassLoader loader) {
        int length = this.readInt();
        if (length < 0) {
            return null;
        }
        Bundle bundle = new Bundle(this, length);
        if (loader != null) {
            bundle.setClassLoader(loader);
        }
        return bundle;
    }

    public PersistableBundle readPersistableBundle() {
        return this.readPersistableBundle(null);
    }

    public PersistableBundle readPersistableBundle(ClassLoader loader) {
        int length = this.readInt();
        if (length < 0) {
            return null;
        }
        PersistableBundle bundle = new PersistableBundle(this, length);
        if (loader != null) {
            bundle.setClassLoader(loader);
        }
        return bundle;
    }

    public Size readSize() {
        int width = this.readInt();
        int height = this.readInt();
        return new Size(width, height);
    }

    public SizeF readSizeF() {
        float width = this.readFloat();
        float height = this.readFloat();
        return new SizeF(width, height);
    }

    public byte[] createByteArray() {
        return Parcel.nativeCreateByteArray(this.mNativePtr);
    }

    public void readByteArray(byte[] val) {
        boolean valid = Parcel.nativeReadByteArray(this.mNativePtr, val, val != null ? val.length : 0);
        if (!valid) {
            throw new RuntimeException("bad array lengths");
        }
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public byte[] readBlob() {
        return Parcel.nativeReadBlob(this.mNativePtr);
    }

    @UnsupportedAppUsage
    public String[] readStringArray() {
        return this.createString16Array();
    }

    public CharSequence[] readCharSequenceArray() {
        CharSequence[] array2 = null;
        int length = this.readInt();
        if (length >= 0) {
            array2 = new CharSequence[length];
            for (int i = 0; i < length; ++i) {
                array2[i] = this.readCharSequence();
            }
        }
        return array2;
    }

    public ArrayList<CharSequence> readCharSequenceList() {
        ArrayList<CharSequence> array2 = null;
        int length = this.readInt();
        if (length >= 0) {
            array2 = new ArrayList<CharSequence>(length);
            for (int i = 0; i < length; ++i) {
                array2.add(this.readCharSequence());
            }
        }
        return array2;
    }

    public ArrayList readArrayList(ClassLoader loader) {
        int N = this.readInt();
        if (N < 0) {
            return null;
        }
        ArrayList l = new ArrayList(N);
        this.readListInternal(l, N, loader);
        return l;
    }

    public Object[] readArray(ClassLoader loader) {
        int N = this.readInt();
        if (N < 0) {
            return null;
        }
        Object[] l = new Object[N];
        this.readArrayInternal(l, N, loader);
        return l;
    }

    public <T> SparseArray<T> readSparseArray(ClassLoader loader) {
        int N = this.readInt();
        if (N < 0) {
            return null;
        }
        SparseArray sa = new SparseArray(N);
        this.readSparseArrayInternal(sa, N, loader);
        return sa;
    }

    public SparseBooleanArray readSparseBooleanArray() {
        int N = this.readInt();
        if (N < 0) {
            return null;
        }
        SparseBooleanArray sa = new SparseBooleanArray(N);
        this.readSparseBooleanArrayInternal(sa, N);
        return sa;
    }

    public SparseIntArray readSparseIntArray() {
        int N = this.readInt();
        if (N < 0) {
            return null;
        }
        SparseIntArray sa = new SparseIntArray(N);
        this.readSparseIntArrayInternal(sa, N);
        return sa;
    }

    public <T> ArrayList<T> createTypedArrayList(Parcelable.Creator<T> c) {
        int N = this.readInt();
        if (N < 0) {
            return null;
        }
        ArrayList<T> l = new ArrayList<T>(N);
        while (N > 0) {
            l.add(this.readTypedObject(c));
            --N;
        }
        return l;
    }

    public <T> void readTypedList(List<T> list, Parcelable.Creator<T> c) {
        int i;
        int M = list.size();
        int N = this.readInt();
        for (i = 0; i < M && i < N; ++i) {
            list.set(i, this.readTypedObject(c));
        }
        while (i < N) {
            list.add(this.readTypedObject(c));
            ++i;
        }
        while (i < M) {
            list.remove(N);
            ++i;
        }
    }

    public <T extends Parcelable> SparseArray<T> createTypedSparseArray(Parcelable.Creator<T> creator) {
        int count = this.readInt();
        if (count < 0) {
            return null;
        }
        SparseArray<Parcelable> array2 = new SparseArray<Parcelable>(count);
        for (int i = 0; i < count; ++i) {
            int index = this.readInt();
            Parcelable value2 = (Parcelable)this.readTypedObject(creator);
            array2.append(index, value2);
        }
        return array2;
    }

    public <T extends Parcelable> ArrayMap<String, T> createTypedArrayMap(Parcelable.Creator<T> creator) {
        int count = this.readInt();
        if (count < 0) {
            return null;
        }
        ArrayMap<String, Parcelable> map2 = new ArrayMap<String, Parcelable>(count);
        for (int i = 0; i < count; ++i) {
            String key = this.readString();
            Parcelable value2 = (Parcelable)this.readTypedObject(creator);
            map2.append(key, value2);
        }
        return map2;
    }

    public ArrayList<String> createStringArrayList() {
        int N = this.readInt();
        if (N < 0) {
            return null;
        }
        ArrayList<String> l = new ArrayList<String>(N);
        while (N > 0) {
            l.add(this.readString());
            --N;
        }
        return l;
    }

    public ArrayList<IBinder> createBinderArrayList() {
        int N = this.readInt();
        if (N < 0) {
            return null;
        }
        ArrayList<IBinder> l = new ArrayList<IBinder>(N);
        while (N > 0) {
            l.add(this.readStrongBinder());
            --N;
        }
        return l;
    }

    public void readStringList(List<String> list) {
        int i;
        int M = list.size();
        int N = this.readInt();
        for (i = 0; i < M && i < N; ++i) {
            list.set(i, this.readString());
        }
        while (i < N) {
            list.add(this.readString());
            ++i;
        }
        while (i < M) {
            list.remove(N);
            ++i;
        }
    }

    public void readBinderList(List<IBinder> list) {
        int i;
        int M = list.size();
        int N = this.readInt();
        for (i = 0; i < M && i < N; ++i) {
            list.set(i, this.readStrongBinder());
        }
        while (i < N) {
            list.add(this.readStrongBinder());
            ++i;
        }
        while (i < M) {
            list.remove(N);
            ++i;
        }
    }

    public <T extends Parcelable> List<T> readParcelableList(List<T> list, ClassLoader cl) {
        int i;
        int N = this.readInt();
        if (N == -1) {
            list.clear();
            return list;
        }
        int M = list.size();
        for (i = 0; i < M && i < N; ++i) {
            list.set(i, this.readParcelable(cl));
        }
        while (i < N) {
            list.add(this.readParcelable(cl));
            ++i;
        }
        while (i < M) {
            list.remove(N);
            ++i;
        }
        return list;
    }

    public <T> T[] createTypedArray(Parcelable.Creator<T> c) {
        int N = this.readInt();
        if (N < 0) {
            return null;
        }
        T[] l = c.newArray(N);
        for (int i = 0; i < N; ++i) {
            l[i] = this.readTypedObject(c);
        }
        return l;
    }

    public <T> void readTypedArray(T[] val, Parcelable.Creator<T> c) {
        int N = this.readInt();
        if (N == val.length) {
            for (int i = 0; i < N; ++i) {
                val[i] = this.readTypedObject(c);
            }
        } else {
            throw new RuntimeException("bad array lengths");
        }
    }

    @Deprecated
    public <T> T[] readTypedArray(Parcelable.Creator<T> c) {
        return this.createTypedArray(c);
    }

    public <T> T readTypedObject(Parcelable.Creator<T> c) {
        if (this.readInt() != 0) {
            return c.createFromParcel(this);
        }
        return null;
    }

    public <T extends Parcelable> void writeParcelableArray(T[] value2, int parcelableFlags) {
        if (value2 != null) {
            int N = value2.length;
            this.writeInt(N);
            for (int i = 0; i < N; ++i) {
                this.writeParcelable((Parcelable)value2[i], parcelableFlags);
            }
        } else {
            this.writeInt(-1);
        }
    }

    public Object readValue(ClassLoader loader) {
        int type = this.readInt();
        switch (type) {
            case -1: {
                return null;
            }
            case 0: {
                return this.readString();
            }
            case 1: {
                return this.readInt();
            }
            case 2: {
                return this.readHashMap(loader);
            }
            case 4: {
                return this.readParcelable(loader);
            }
            case 5: {
                return (short)this.readInt();
            }
            case 6: {
                return this.readLong();
            }
            case 7: {
                return Float.valueOf(this.readFloat());
            }
            case 8: {
                return this.readDouble();
            }
            case 9: {
                return this.readInt() == 1;
            }
            case 10: {
                return this.readCharSequence();
            }
            case 11: {
                return this.readArrayList(loader);
            }
            case 23: {
                return this.createBooleanArray();
            }
            case 13: {
                return this.createByteArray();
            }
            case 14: {
                return this.readStringArray();
            }
            case 24: {
                return this.readCharSequenceArray();
            }
            case 15: {
                return this.readStrongBinder();
            }
            case 17: {
                return this.readArray(loader);
            }
            case 18: {
                return this.createIntArray();
            }
            case 19: {
                return this.createLongArray();
            }
            case 20: {
                return this.readByte();
            }
            case 21: {
                return this.readSerializable(loader);
            }
            case 16: {
                return this.readParcelableArray(loader);
            }
            case 12: {
                return this.readSparseArray(loader);
            }
            case 22: {
                return this.readSparseBooleanArray();
            }
            case 3: {
                return this.readBundle(loader);
            }
            case 25: {
                return this.readPersistableBundle(loader);
            }
            case 26: {
                return this.readSize();
            }
            case 27: {
                return this.readSizeF();
            }
            case 28: {
                return this.createDoubleArray();
            }
        }
        int off = this.dataPosition() - 4;
        throw new RuntimeException("Parcel " + this + ": Unmarshalling unknown type code " + type + " at offset " + off);
    }

    public <T extends Parcelable> T readParcelable(ClassLoader loader) {
        Parcelable.Creator<?> creator = this.readParcelableCreator(loader);
        if (creator == null) {
            return null;
        }
        if (creator instanceof Parcelable.ClassLoaderCreator) {
            Parcelable.ClassLoaderCreator classLoaderCreator = (Parcelable.ClassLoaderCreator)creator;
            return (T)((Parcelable)classLoaderCreator.createFromParcel(this, loader));
        }
        return (T)((Parcelable)creator.createFromParcel(this));
    }

    @UnsupportedAppUsage
    public <T extends Parcelable> T readCreator(Parcelable.Creator<?> creator, ClassLoader loader) {
        if (creator instanceof Parcelable.ClassLoaderCreator) {
            Parcelable.ClassLoaderCreator classLoaderCreator = (Parcelable.ClassLoaderCreator)creator;
            return (T)((Parcelable)classLoaderCreator.createFromParcel(this, loader));
        }
        return (T)((Parcelable)creator.createFromParcel(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Parcelable.Creator<?> readParcelableCreator(ClassLoader loader) {
        Parcelable.Creator creator;
        HashMap<String, Parcelable.Creator<Object>> map2;
        String name = this.readString();
        if (name == null) {
            return null;
        }
        HashMap<ClassLoader, HashMap<String, Parcelable.Creator<?>>> hashMap = mCreators;
        synchronized (hashMap) {
            map2 = mCreators.get(loader);
            if (map2 == null) {
                map2 = new HashMap();
                mCreators.put(loader, map2);
            }
            creator = map2.get(name);
        }
        if (creator != null) {
            return creator;
        }
        try {
            ClassLoader parcelableClassLoader = loader == null ? this.getClass().getClassLoader() : loader;
            Class<?> parcelableClass = Class.forName(name, false, parcelableClassLoader);
            if (!Parcelable.class.isAssignableFrom(parcelableClass)) {
                throw new BadParcelableException("Parcelable protocol requires subclassing from Parcelable on class " + name);
            }
            Field f = parcelableClass.getField("CREATOR");
            if ((f.getModifiers() & 8) == 0) {
                throw new BadParcelableException("Parcelable protocol requires the CREATOR object to be static on class " + name);
            }
            Class<?> creatorType = f.getType();
            if (!Parcelable.Creator.class.isAssignableFrom(creatorType)) {
                throw new BadParcelableException("Parcelable protocol requires a Parcelable.Creator object called CREATOR on class " + name);
            }
            creator = (Parcelable.Creator)f.get(null);
        }
        catch (IllegalAccessException e) {
            Log.e(TAG, "Illegal access when unmarshalling: " + name, e);
            throw new BadParcelableException("IllegalAccessException when unmarshalling: " + name, e);
        }
        catch (ClassNotFoundException e) {
            Log.e(TAG, "Class not found when unmarshalling: " + name, e);
            throw new BadParcelableException("ClassNotFoundException when unmarshalling: " + name, e);
        }
        catch (NoSuchFieldException e) {
            throw new BadParcelableException("Parcelable protocol requires a Parcelable.Creator object called CREATOR on class " + name, e);
        }
        if (creator == null) {
            throw new BadParcelableException("Parcelable protocol requires a non-null Parcelable.Creator object called CREATOR on class " + name);
        }
        hashMap = mCreators;
        synchronized (hashMap) {
            map2.put(name, creator);
        }
        return creator;
    }

    public Parcelable[] readParcelableArray(ClassLoader loader) {
        int N = this.readInt();
        if (N < 0) {
            return null;
        }
        Parcelable[] p = new Parcelable[N];
        for (int i = 0; i < N; ++i) {
            p[i] = this.readParcelable(loader);
        }
        return p;
    }

    public <T extends Parcelable> T[] readParcelableArray(ClassLoader loader, Class<T> clazz) {
        int N = this.readInt();
        if (N < 0) {
            return null;
        }
        Parcelable[] p = (Parcelable[])Array.newInstance(clazz, N);
        for (int i = 0; i < N; ++i) {
            p[i] = this.readParcelable(loader);
        }
        return p;
    }

    public Serializable readSerializable() {
        return this.readSerializable(null);
    }

    private Serializable readSerializable(final ClassLoader loader) {
        String name = this.readString();
        if (name == null) {
            return null;
        }
        byte[] serializedData = this.createByteArray();
        ByteArrayInputStream bais = new ByteArrayInputStream(serializedData);
        try {
            ObjectInputStream ois = new ObjectInputStream(bais){

                @Override
                protected Class<?> resolveClass(ObjectStreamClass osClass) throws IOException, ClassNotFoundException {
                    Class<?> c;
                    if (loader != null && (c = Class.forName(osClass.getName(), false, loader)) != null) {
                        return c;
                    }
                    return super.resolveClass(osClass);
                }
            };
            return (Serializable)ois.readObject();
        }
        catch (IOException ioe) {
            throw new RuntimeException("Parcelable encountered IOException reading a Serializable object (name = " + name + ")", ioe);
        }
        catch (ClassNotFoundException cnfe) {
            throw new RuntimeException("Parcelable encountered ClassNotFoundException reading a Serializable object (name = " + name + ")", cnfe);
        }
    }

    protected static Parcel obtain(int obj) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Parcel obtain(long obj) {
        Parcel res = null;
        Object object = sPoolSync;
        synchronized (object) {
            if (sHolderPool != null) {
                res = sHolderPool;
                sHolderPool = res.mPoolNext;
                res.mPoolNext = null;
                --sHolderPoolSize;
            }
        }
        if (res == null) {
            res = new Parcel(obj);
        } else {
            res.init(obj);
        }
        return res;
    }

    private Parcel(long nativePtr) {
        this.init(nativePtr);
    }

    private void init(long nativePtr) {
        if (nativePtr != 0L) {
            this.mNativePtr = nativePtr;
            this.mOwnsNativeParcelObject = false;
        } else {
            this.mNativePtr = Parcel.nativeCreate();
            this.mOwnsNativeParcelObject = true;
        }
    }

    private void freeBuffer() {
        this.resetSqaushingState();
        if (this.mOwnsNativeParcelObject) {
            Parcel.nativeFreeBuffer(this.mNativePtr);
        }
        this.mReadWriteHelper = ReadWriteHelper.DEFAULT;
    }

    private void destroy() {
        this.resetSqaushingState();
        if (this.mNativePtr != 0L) {
            if (this.mOwnsNativeParcelObject) {
                Parcel.nativeDestroy(this.mNativePtr);
            }
            this.mNativePtr = 0L;
        }
    }

    protected void finalize() throws Throwable {
        this.destroy();
    }

    void readMapInternal(Map outVal, int N, ClassLoader loader) {
        while (N > 0) {
            Object key = this.readValue(loader);
            Object value2 = this.readValue(loader);
            outVal.put(key, value2);
            --N;
        }
    }

    void readArrayMapInternal(ArrayMap outVal, int N, ClassLoader loader) {
        while (N > 0) {
            String key = this.readString();
            Object value2 = this.readValue(loader);
            outVal.append(key, value2);
            --N;
        }
        outVal.validate();
    }

    void readArrayMapSafelyInternal(ArrayMap outVal, int N, ClassLoader loader) {
        while (N > 0) {
            String key = this.readString();
            Object value2 = this.readValue(loader);
            outVal.put(key, value2);
            --N;
        }
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public void readArrayMap(ArrayMap outVal, ClassLoader loader) {
        int N = this.readInt();
        if (N < 0) {
            return;
        }
        this.readArrayMapInternal(outVal, N, loader);
    }

    @UnsupportedAppUsage
    public ArraySet<? extends Object> readArraySet(ClassLoader loader) {
        int size = this.readInt();
        if (size < 0) {
            return null;
        }
        ArraySet<Object> result = new ArraySet<Object>(size);
        for (int i = 0; i < size; ++i) {
            Object value2 = this.readValue(loader);
            result.append(value2);
        }
        return result;
    }

    private void readListInternal(List outVal, int N, ClassLoader loader) {
        while (N > 0) {
            Object value2 = this.readValue(loader);
            outVal.add(value2);
            --N;
        }
    }

    private void readArrayInternal(Object[] outVal, int N, ClassLoader loader) {
        for (int i = 0; i < N; ++i) {
            Object value2;
            outVal[i] = value2 = this.readValue(loader);
        }
    }

    private void readSparseArrayInternal(SparseArray outVal, int N, ClassLoader loader) {
        while (N > 0) {
            int key = this.readInt();
            Object value2 = this.readValue(loader);
            outVal.append(key, value2);
            --N;
        }
    }

    private void readSparseBooleanArrayInternal(SparseBooleanArray outVal, int N) {
        while (N > 0) {
            int key = this.readInt();
            boolean value2 = this.readByte() == 1;
            outVal.append(key, value2);
            --N;
        }
    }

    private void readSparseIntArrayInternal(SparseIntArray outVal, int N) {
        while (N > 0) {
            int key = this.readInt();
            int value2 = this.readInt();
            outVal.append(key, value2);
            --N;
        }
    }

    public long getBlobAshmemSize() {
        return Parcel.nativeGetBlobAshmemSize(this.mNativePtr);
    }

    static {
        sPoolSync = new Object();
        sOwnedPoolSize = 0;
        sHolderPoolSize = 0;
        STRING_CREATOR = new Parcelable.Creator<String>(){

            @Override
            public String createFromParcel(Parcel source) {
                return source.readString();
            }

            public String[] newArray(int size) {
                return new String[size];
            }
        };
        mCreators = new HashMap();
    }

    public static interface SquashReadHelper<T> {
        public T readRawParceled(Parcel var1);
    }

    public static class ReadWriteHelper {
        public static final ReadWriteHelper DEFAULT = new ReadWriteHelper();

        @UnsupportedAppUsage
        public ReadWriteHelper() {
        }

        public void writeString8(Parcel p, String s) {
            p.writeString8NoHelper(s);
        }

        public void writeString16(Parcel p, String s) {
            p.writeString16NoHelper(s);
        }

        public String readString8(Parcel p) {
            return p.readString8NoHelper();
        }

        public String readString16(Parcel p) {
            return p.readString16NoHelper();
        }
    }
}

