/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.compat.annotation.UnsupportedAppUsage;
import android.os.Binder;
import android.os.Handler;
import android.os.Message;
import android.os.SystemClock;
import android.util.Log;
import android.util.Printer;
import android.util.SparseArray;
import android.util.proto.ProtoOutputStream;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.io.FileDescriptor;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;

public class MessageQueue {
    private static final String TAG = "MessageQueue";
    private static final boolean DEBUG = false;
    @UnsupportedAppUsage
    private final boolean mQuitAllowed;
    @UnsupportedAppUsage
    private long mPtr;
    @UnsupportedAppUsage
    Message mMessages;
    @UnsupportedAppUsage
    private final ArrayList<IdleHandler> mIdleHandlers = new ArrayList();
    private SparseArray<FileDescriptorRecord> mFileDescriptorRecords;
    private IdleHandler[] mPendingIdleHandlers;
    private boolean mQuitting;
    private boolean mBlocked;
    @UnsupportedAppUsage
    private int mNextBarrierToken;

    private static long nativeInit() {
        return OverrideMethod.invokeL("android.os.MessageQueue#nativeInit()J", true, null);
    }

    private static void nativeDestroy(long l) {
        OverrideMethod.invokeV("android.os.MessageQueue#nativeDestroy(J)V", true, null);
    }

    @UnsupportedAppUsage
    private void nativePollOnce(long l, int n) {
        OverrideMethod.invokeV("android.os.MessageQueue#nativePollOnce(JI)V", true, this);
    }

    private static void nativeWake(long l) {
        OverrideMethod.invokeV("android.os.MessageQueue#nativeWake(J)V", true, null);
    }

    private static boolean nativeIsPolling(long l) {
        return OverrideMethod.invokeI("android.os.MessageQueue#nativeIsPolling(J)Z", true, null) != 0;
    }

    private static void nativeSetFileDescriptorEvents(long l, int n, int n2) {
        OverrideMethod.invokeV("android.os.MessageQueue#nativeSetFileDescriptorEvents(JII)V", true, null);
    }

    MessageQueue(boolean quitAllowed) {
        this.mQuitAllowed = quitAllowed;
        this.mPtr = MessageQueue.nativeInit();
    }

    protected void finalize() throws Throwable {
        try {
            this.dispose();
        }
        finally {
            super.finalize();
        }
    }

    private void dispose() {
        if (this.mPtr != 0L) {
            MessageQueue.nativeDestroy(this.mPtr);
            this.mPtr = 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isIdle() {
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            long now = SystemClock.uptimeMillis();
            return this.mMessages == null || now < this.mMessages.when;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addIdleHandler(IdleHandler handler) {
        if (handler == null) {
            throw new NullPointerException("Can't add a null IdleHandler");
        }
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            this.mIdleHandlers.add(handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeIdleHandler(IdleHandler handler) {
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            this.mIdleHandlers.remove(handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPolling() {
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            return this.isPollingLocked();
        }
    }

    private boolean isPollingLocked() {
        return !this.mQuitting && MessageQueue.nativeIsPolling(this.mPtr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOnFileDescriptorEventListener(FileDescriptor fd, int events, OnFileDescriptorEventListener listener2) {
        if (fd == null) {
            throw new IllegalArgumentException("fd must not be null");
        }
        if (listener2 == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            this.updateOnFileDescriptorEventListenerLocked(fd, events, listener2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeOnFileDescriptorEventListener(FileDescriptor fd) {
        if (fd == null) {
            throw new IllegalArgumentException("fd must not be null");
        }
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            this.updateOnFileDescriptorEventListenerLocked(fd, 0, null);
        }
    }

    private void updateOnFileDescriptorEventListenerLocked(FileDescriptor fd, int events, OnFileDescriptorEventListener listener2) {
        int fdNum = fd.getInt$();
        int index = -1;
        FileDescriptorRecord record = null;
        if (this.mFileDescriptorRecords != null && (index = this.mFileDescriptorRecords.indexOfKey(fdNum)) >= 0 && (record = this.mFileDescriptorRecords.valueAt(index)) != null && record.mEvents == events) {
            return;
        }
        if (events != 0) {
            events |= 4;
            if (record == null) {
                if (this.mFileDescriptorRecords == null) {
                    this.mFileDescriptorRecords = new SparseArray();
                }
                record = new FileDescriptorRecord(fd, events, listener2);
                this.mFileDescriptorRecords.put(fdNum, record);
            } else {
                record.mListener = listener2;
                record.mEvents = events;
                ++record.mSeq;
            }
            MessageQueue.nativeSetFileDescriptorEvents(this.mPtr, fdNum, events);
        } else if (record != null) {
            record.mEvents = 0;
            this.mFileDescriptorRecords.removeAt(index);
            MessageQueue.nativeSetFileDescriptorEvents(this.mPtr, fdNum, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    private int dispatchEvents(int fd, int events) {
        int seq;
        OnFileDescriptorEventListener listener2;
        int oldWatchedEvents;
        FileDescriptorRecord record;
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            record = this.mFileDescriptorRecords.get(fd);
            if (record == null) {
                return 0;
            }
            oldWatchedEvents = record.mEvents;
            if ((events &= oldWatchedEvents) == 0) {
                return oldWatchedEvents;
            }
            listener2 = record.mListener;
            seq = record.mSeq;
        }
        int newWatchedEvents = listener2.onFileDescriptorEvents(record.mDescriptor, events);
        if (newWatchedEvents != 0) {
            newWatchedEvents |= 4;
        }
        if (newWatchedEvents != oldWatchedEvents) {
            MessageQueue messageQueue2 = this;
            synchronized (messageQueue2) {
                int index = this.mFileDescriptorRecords.indexOfKey(fd);
                if (index >= 0 && this.mFileDescriptorRecords.valueAt(index) == record && record.mSeq == seq) {
                    record.mEvents = newWatchedEvents;
                    if (newWatchedEvents == 0) {
                        this.mFileDescriptorRecords.removeAt(index);
                    }
                }
            }
        }
        return newWatchedEvents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @UnsupportedAppUsage
    Message next() {
        long ptr = this.mPtr;
        if (ptr == 0L) {
            return null;
        }
        int pendingIdleHandlerCount = -1;
        int nextPollTimeoutMillis = 0;
        while (true) {
            if (nextPollTimeoutMillis != 0) {
                Binder.flushPendingCommands();
            }
            this.nativePollOnce(ptr, nextPollTimeoutMillis);
            MessageQueue messageQueue = this;
            synchronized (messageQueue) {
                long now;
                block21: {
                    now = SystemClock.uptimeMillis();
                    Message prevMsg = null;
                    Message msg = this.mMessages;
                    if (msg != null && msg.target == null) {
                        do {
                            prevMsg = msg;
                        } while ((msg = msg.next) != null && !msg.isAsynchronous());
                    }
                    if (msg != null) {
                        if (now < msg.when) {
                            nextPollTimeoutMillis = (int)Math.min(msg.when - now, Integer.MAX_VALUE);
                            break block21;
                        } else {
                            this.mBlocked = false;
                            if (prevMsg != null) {
                                prevMsg.next = msg.next;
                            } else {
                                this.mMessages = msg.next;
                            }
                            msg.next = null;
                            msg.markInUse();
                            return msg;
                        }
                    }
                    nextPollTimeoutMillis = -1;
                }
                if (this.mQuitting) {
                    this.dispose();
                    return null;
                }
                if (pendingIdleHandlerCount < 0 && (this.mMessages == null || now < this.mMessages.when)) {
                    pendingIdleHandlerCount = this.mIdleHandlers.size();
                }
                if (pendingIdleHandlerCount <= 0) {
                    this.mBlocked = true;
                    continue;
                }
                if (this.mPendingIdleHandlers == null) {
                    this.mPendingIdleHandlers = new IdleHandler[Math.max(pendingIdleHandlerCount, 4)];
                }
                this.mPendingIdleHandlers = this.mIdleHandlers.toArray(this.mPendingIdleHandlers);
            }
            for (int i = 0; i < pendingIdleHandlerCount; ++i) {
                IdleHandler idler = this.mPendingIdleHandlers[i];
                this.mPendingIdleHandlers[i] = null;
                boolean keep = false;
                try {
                    keep = idler.queueIdle();
                }
                catch (Throwable t) {
                    Log.wtf(TAG, "IdleHandler threw exception", t);
                }
                if (keep) continue;
                MessageQueue messageQueue2 = this;
                synchronized (messageQueue2) {
                    this.mIdleHandlers.remove(idler);
                    continue;
                }
            }
            pendingIdleHandlerCount = 0;
            nextPollTimeoutMillis = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void quit(boolean safe) {
        if (!this.mQuitAllowed) {
            throw new IllegalStateException("Main thread not allowed to quit.");
        }
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            if (this.mQuitting) {
                return;
            }
            this.mQuitting = true;
            if (safe) {
                this.removeAllFutureMessagesLocked();
            } else {
                this.removeAllMessagesLocked();
            }
            MessageQueue.nativeWake(this.mPtr);
        }
    }

    @UnsupportedAppUsage
    public int postSyncBarrier() {
        return this.postSyncBarrier(SystemClock.uptimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int postSyncBarrier(long when) {
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            int token = this.mNextBarrierToken++;
            Message msg = Message.obtain();
            msg.markInUse();
            msg.when = when;
            msg.arg1 = token;
            Message prev = null;
            Message p = this.mMessages;
            if (when != 0L) {
                while (p != null && p.when <= when) {
                    prev = p;
                    p = p.next;
                }
            }
            if (prev != null) {
                msg.next = p;
                prev.next = msg;
            } else {
                msg.next = p;
                this.mMessages = msg;
            }
            return token;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    public void removeSyncBarrier(int token) {
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            boolean needWake;
            Message prev = null;
            Message p = this.mMessages;
            while (p != null && (p.target != null || p.arg1 != token)) {
                prev = p;
                p = p.next;
            }
            if (p == null) {
                throw new IllegalStateException("The specified message queue synchronization  barrier token has not been posted or has already been removed.");
            }
            if (prev != null) {
                prev.next = p.next;
                needWake = false;
            } else {
                this.mMessages = p.next;
                needWake = this.mMessages == null || this.mMessages.target != null;
            }
            p.recycleUnchecked();
            if (needWake && !this.mQuitting) {
                MessageQueue.nativeWake(this.mPtr);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean enqueueMessage(Message msg, long when) {
        if (msg.target == null) {
            throw new IllegalArgumentException("Message must have a target.");
        }
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            boolean needWake;
            if (msg.isInUse()) {
                throw new IllegalStateException(msg + " This message is already in use.");
            }
            if (this.mQuitting) {
                IllegalStateException e = new IllegalStateException(msg.target + " sending message to a Handler on a dead thread");
                Log.w(TAG, e.getMessage(), e);
                msg.recycle();
                return false;
            }
            msg.markInUse();
            msg.when = when;
            Message p = this.mMessages;
            if (p == null || when == 0L || when < p.when) {
                msg.next = p;
                this.mMessages = msg;
                needWake = this.mBlocked;
            } else {
                needWake = this.mBlocked && p.target == null && msg.isAsynchronous();
                while (true) {
                    Message prev = p;
                    p = p.next;
                    if (p == null || when < p.when) break;
                    if (!needWake || !p.isAsynchronous()) continue;
                    needWake = false;
                }
                msg.next = p;
                prev.next = msg;
            }
            if (needWake) {
                MessageQueue.nativeWake(this.mPtr);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean hasMessages(Handler h, int what, Object object) {
        if (h == null) {
            return false;
        }
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            Message p = this.mMessages;
            while (p != null) {
                if (p.target == h && p.what == what && (object == null || p.obj == object)) {
                    return true;
                }
                p = p.next;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean hasEqualMessages(Handler h, int what, Object object) {
        if (h == null) {
            return false;
        }
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            Message p = this.mMessages;
            while (p != null) {
                if (p.target == h && p.what == what && (object == null || object.equals(p.obj))) {
                    return true;
                }
                p = p.next;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    boolean hasMessages(Handler h, Runnable r, Object object) {
        if (h == null) {
            return false;
        }
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            Message p = this.mMessages;
            while (p != null) {
                if (p.target == h && p.callback == r && (object == null || p.obj == object)) {
                    return true;
                }
                p = p.next;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean hasMessages(Handler h) {
        if (h == null) {
            return false;
        }
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            Message p = this.mMessages;
            while (p != null) {
                if (p.target == h) {
                    return true;
                }
                p = p.next;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeMessages(Handler h, int what, Object object) {
        if (h == null) {
            return;
        }
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            Message n;
            Message p = this.mMessages;
            while (p != null && p.target == h && p.what == what && (object == null || p.obj == object)) {
                this.mMessages = n = p.next;
                p.recycleUnchecked();
                p = n;
            }
            while (p != null) {
                n = p.next;
                if (n != null && n.target == h && n.what == what && (object == null || n.obj == object)) {
                    Message nn = n.next;
                    n.recycleUnchecked();
                    p.next = nn;
                    continue;
                }
                p = n;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeEqualMessages(Handler h, int what, Object object) {
        if (h == null) {
            return;
        }
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            Message n;
            Message p = this.mMessages;
            while (p != null && p.target == h && p.what == what && (object == null || object.equals(p.obj))) {
                this.mMessages = n = p.next;
                p.recycleUnchecked();
                p = n;
            }
            while (p != null) {
                n = p.next;
                if (n != null && n.target == h && n.what == what && (object == null || object.equals(n.obj))) {
                    Message nn = n.next;
                    n.recycleUnchecked();
                    p.next = nn;
                    continue;
                }
                p = n;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeMessages(Handler h, Runnable r, Object object) {
        if (h == null || r == null) {
            return;
        }
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            Message n;
            Message p = this.mMessages;
            while (p != null && p.target == h && p.callback == r && (object == null || p.obj == object)) {
                this.mMessages = n = p.next;
                p.recycleUnchecked();
                p = n;
            }
            while (p != null) {
                n = p.next;
                if (n != null && n.target == h && n.callback == r && (object == null || n.obj == object)) {
                    Message nn = n.next;
                    n.recycleUnchecked();
                    p.next = nn;
                    continue;
                }
                p = n;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeEqualMessages(Handler h, Runnable r, Object object) {
        if (h == null || r == null) {
            return;
        }
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            Message n;
            Message p = this.mMessages;
            while (p != null && p.target == h && p.callback == r && (object == null || object.equals(p.obj))) {
                this.mMessages = n = p.next;
                p.recycleUnchecked();
                p = n;
            }
            while (p != null) {
                n = p.next;
                if (n != null && n.target == h && n.callback == r && (object == null || object.equals(n.obj))) {
                    Message nn = n.next;
                    n.recycleUnchecked();
                    p.next = nn;
                    continue;
                }
                p = n;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeCallbacksAndMessages(Handler h, Object object) {
        if (h == null) {
            return;
        }
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            Message n;
            Message p = this.mMessages;
            while (p != null && p.target == h && (object == null || p.obj == object)) {
                this.mMessages = n = p.next;
                p.recycleUnchecked();
                p = n;
            }
            while (p != null) {
                n = p.next;
                if (n != null && n.target == h && (object == null || n.obj == object)) {
                    Message nn = n.next;
                    n.recycleUnchecked();
                    p.next = nn;
                    continue;
                }
                p = n;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeCallbacksAndEqualMessages(Handler h, Object object) {
        if (h == null) {
            return;
        }
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            Message n;
            Message p = this.mMessages;
            while (p != null && p.target == h && (object == null || object.equals(p.obj))) {
                this.mMessages = n = p.next;
                p.recycleUnchecked();
                p = n;
            }
            while (p != null) {
                n = p.next;
                if (n != null && n.target == h && (object == null || object.equals(n.obj))) {
                    Message nn = n.next;
                    n.recycleUnchecked();
                    p.next = nn;
                    continue;
                }
                p = n;
            }
        }
    }

    private void removeAllMessagesLocked() {
        Message p = this.mMessages;
        while (p != null) {
            Message n = p.next;
            p.recycleUnchecked();
            p = n;
        }
        this.mMessages = null;
    }

    private void removeAllFutureMessagesLocked() {
        long now = SystemClock.uptimeMillis();
        Message p = this.mMessages;
        if (p != null) {
            if (p.when > now) {
                this.removeAllMessagesLocked();
            } else {
                Message n;
                while (true) {
                    if ((n = p.next) == null) {
                        return;
                    }
                    if (n.when > now) break;
                    p = n;
                }
                p.next = null;
                do {
                    p = n;
                    n = p.next;
                    p.recycleUnchecked();
                } while (n != null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dump(Printer pw, String prefix, Handler h) {
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            long now = SystemClock.uptimeMillis();
            int n = 0;
            Message msg = this.mMessages;
            while (msg != null) {
                if (h == null || h == msg.target) {
                    pw.println(prefix + "Message " + n + ": " + msg.toString(now));
                }
                ++n;
                msg = msg.next;
            }
            pw.println(prefix + "(Total messages: " + n + ", polling=" + this.isPollingLocked() + ", quitting=" + this.mQuitting + ")");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dumpDebug(ProtoOutputStream proto, long fieldId) {
        long messageQueueToken = proto.start(fieldId);
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            Message msg = this.mMessages;
            while (msg != null) {
                msg.dumpDebug(proto, 2246267895809L);
                msg = msg.next;
            }
            proto.write(1133871366146L, this.isPollingLocked());
            proto.write(1133871366147L, this.mQuitting);
        }
        proto.end(messageQueueToken);
    }

    private static class FileDescriptorRecord {
        public final FileDescriptor mDescriptor;
        public int mEvents;
        public OnFileDescriptorEventListener mListener;
        public int mSeq;

        public FileDescriptorRecord(FileDescriptor descriptor, int events, OnFileDescriptorEventListener listener2) {
            this.mDescriptor = descriptor;
            this.mEvents = events;
            this.mListener = listener2;
        }
    }

    public static interface OnFileDescriptorEventListener {
        public static final int EVENT_INPUT = 1;
        public static final int EVENT_OUTPUT = 2;
        public static final int EVENT_ERROR = 4;

        public int onFileDescriptorEvents(FileDescriptor var1, int var2);

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface Events {
        }
    }

    public static interface IdleHandler {
        public boolean queueIdle();
    }
}

