/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.compat.annotation.UnsupportedAppUsage;
import android.os.Binder;
import android.os.IBinder;
import android.os.IClientCallback;
import android.os.IInterface;
import android.os.IServiceCallback;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.os.ServiceDebugInfo;

public interface IServiceManager
extends IInterface {
    public static final String DESCRIPTOR = "android.os.IServiceManager";
    public static final int DUMP_FLAG_PRIORITY_CRITICAL = 1;
    public static final int DUMP_FLAG_PRIORITY_HIGH = 2;
    public static final int DUMP_FLAG_PRIORITY_NORMAL = 4;
    public static final int DUMP_FLAG_PRIORITY_DEFAULT = 8;
    public static final int DUMP_FLAG_PRIORITY_ALL = 15;
    public static final int DUMP_FLAG_PROTO = 16;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/native/libs/binder/aidl/android/os/IServiceManager.aidl:62:1:62:25")
    public IBinder getService(String var1) throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/native/libs/binder/aidl/android/os/IServiceManager.aidl:70:1:70:25")
    public IBinder checkService(String var1) throws RemoteException;

    public void addService(String var1, IBinder var2, boolean var3, int var4) throws RemoteException;

    public String[] listServices(int var1) throws RemoteException;

    public void registerForNotifications(String var1, IServiceCallback var2) throws RemoteException;

    public void unregisterForNotifications(String var1, IServiceCallback var2) throws RemoteException;

    public boolean isDeclared(String var1) throws RemoteException;

    public String[] getDeclaredInstances(String var1) throws RemoteException;

    public String updatableViaApex(String var1) throws RemoteException;

    public void registerClientCallback(String var1, IBinder var2, IClientCallback var3) throws RemoteException;

    public void tryUnregisterService(String var1, IBinder var2) throws RemoteException;

    public ServiceDebugInfo[] getServiceDebugInfo() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IServiceManager {
        static final int TRANSACTION_getService = 1;
        static final int TRANSACTION_checkService = 2;
        static final int TRANSACTION_addService = 3;
        static final int TRANSACTION_listServices = 4;
        static final int TRANSACTION_registerForNotifications = 5;
        static final int TRANSACTION_unregisterForNotifications = 6;
        static final int TRANSACTION_isDeclared = 7;
        static final int TRANSACTION_getDeclaredInstances = 8;
        static final int TRANSACTION_updatableViaApex = 9;
        static final int TRANSACTION_registerClientCallback = 10;
        static final int TRANSACTION_tryUnregisterService = 11;
        static final int TRANSACTION_getServiceDebugInfo = 12;

        public Stub() {
            this.attachInterface(this, IServiceManager.DESCRIPTOR);
        }

        public static IServiceManager asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IServiceManager.DESCRIPTOR);
            if (iin != null && iin instanceof IServiceManager) {
                return (IServiceManager)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "getService";
                }
                case 2: {
                    return "checkService";
                }
                case 3: {
                    return "addService";
                }
                case 4: {
                    return "listServices";
                }
                case 5: {
                    return "registerForNotifications";
                }
                case 6: {
                    return "unregisterForNotifications";
                }
                case 7: {
                    return "isDeclared";
                }
                case 8: {
                    return "getDeclaredInstances";
                }
                case 9: {
                    return "updatableViaApex";
                }
                case 10: {
                    return "registerClientCallback";
                }
                case 11: {
                    return "tryUnregisterService";
                }
                case 12: {
                    return "getServiceDebugInfo";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IServiceManager.DESCRIPTOR;
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    IBinder _result = this.getService(_arg0);
                    reply.writeNoException();
                    reply.writeStrongBinder(_result);
                    return true;
                }
                case 2: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    IBinder _result = this.checkService(_arg0);
                    reply.writeNoException();
                    reply.writeStrongBinder(_result);
                    return true;
                }
                case 3: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    IBinder _arg1 = data.readStrongBinder();
                    boolean _arg2 = 0 != data.readInt();
                    int _arg3 = data.readInt();
                    this.addService(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    return true;
                }
                case 4: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    String[] _result = this.listServices(_arg0);
                    reply.writeNoException();
                    reply.writeStringArray(_result);
                    return true;
                }
                case 5: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    IServiceCallback _arg1 = IServiceCallback.Stub.asInterface(data.readStrongBinder());
                    this.registerForNotifications(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 6: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    IServiceCallback _arg1 = IServiceCallback.Stub.asInterface(data.readStrongBinder());
                    this.unregisterForNotifications(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 7: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    boolean _result = this.isDeclared(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 8: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    String[] _result = this.getDeclaredInstances(_arg0);
                    reply.writeNoException();
                    reply.writeStringArray(_result);
                    return true;
                }
                case 9: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    String _result = this.updatableViaApex(_arg0);
                    reply.writeNoException();
                    reply.writeString(_result);
                    return true;
                }
                case 10: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    IBinder _arg1 = data.readStrongBinder();
                    IClientCallback _arg2 = IClientCallback.Stub.asInterface(data.readStrongBinder());
                    this.registerClientCallback(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    return true;
                }
                case 11: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    IBinder _arg1 = data.readStrongBinder();
                    this.tryUnregisterService(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 12: {
                    data.enforceInterface(descriptor);
                    Parcelable[] _result = this.getServiceDebugInfo();
                    reply.writeNoException();
                    reply.writeTypedArray(_result, 1);
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        public static boolean setDefaultImpl(IServiceManager impl) {
            if (Proxy.sDefaultImpl != null) {
                throw new IllegalStateException("setDefaultImpl() called twice");
            }
            if (impl != null) {
                Proxy.sDefaultImpl = impl;
                return true;
            }
            return false;
        }

        public static IServiceManager getDefaultImpl() {
            return Proxy.sDefaultImpl;
        }

        private static class Proxy
        implements IServiceManager {
            private IBinder mRemote;
            public static IServiceManager sDefaultImpl;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IServiceManager.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IBinder getService(String name) throws RemoteException {
                IBinder _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IServiceManager.DESCRIPTOR);
                    _data.writeString(name);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        IBinder iBinder = Stub.getDefaultImpl().getService(name);
                        return iBinder;
                    }
                    _reply.readException();
                    _result = _reply.readStrongBinder();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IBinder checkService(String name) throws RemoteException {
                IBinder _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IServiceManager.DESCRIPTOR);
                    _data.writeString(name);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        IBinder iBinder = Stub.getDefaultImpl().checkService(name);
                        return iBinder;
                    }
                    _reply.readException();
                    _result = _reply.readStrongBinder();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addService(String name, IBinder service, boolean allowIsolated, int dumpPriority) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IServiceManager.DESCRIPTOR);
                    _data.writeString(name);
                    _data.writeStrongBinder(service);
                    _data.writeInt(allowIsolated ? 1 : 0);
                    _data.writeInt(dumpPriority);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().addService(name, service, allowIsolated, dumpPriority);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String[] listServices(int dumpPriority) throws RemoteException {
                String[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IServiceManager.DESCRIPTOR);
                    _data.writeInt(dumpPriority);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        String[] stringArray = Stub.getDefaultImpl().listServices(dumpPriority);
                        return stringArray;
                    }
                    _reply.readException();
                    _result = _reply.createStringArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerForNotifications(String name, IServiceCallback callback2) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IServiceManager.DESCRIPTOR);
                    _data.writeString(name);
                    _data.writeStrongBinder(callback2 != null ? callback2.asBinder() : null);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().registerForNotifications(name, callback2);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterForNotifications(String name, IServiceCallback callback2) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IServiceManager.DESCRIPTOR);
                    _data.writeString(name);
                    _data.writeStrongBinder(callback2 != null ? callback2.asBinder() : null);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().unregisterForNotifications(name, callback2);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isDeclared(String name) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IServiceManager.DESCRIPTOR);
                    _data.writeString(name);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().isDeclared(name);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String[] getDeclaredInstances(String iface) throws RemoteException {
                String[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IServiceManager.DESCRIPTOR);
                    _data.writeString(iface);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        String[] stringArray = Stub.getDefaultImpl().getDeclaredInstances(iface);
                        return stringArray;
                    }
                    _reply.readException();
                    _result = _reply.createStringArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String updatableViaApex(String name) throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IServiceManager.DESCRIPTOR);
                    _data.writeString(name);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        String string2 = Stub.getDefaultImpl().updatableViaApex(name);
                        return string2;
                    }
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerClientCallback(String name, IBinder service, IClientCallback callback2) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IServiceManager.DESCRIPTOR);
                    _data.writeString(name);
                    _data.writeStrongBinder(service);
                    _data.writeStrongBinder(callback2 != null ? callback2.asBinder() : null);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().registerClientCallback(name, service, callback2);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void tryUnregisterService(String name, IBinder service) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IServiceManager.DESCRIPTOR);
                    _data.writeString(name);
                    _data.writeStrongBinder(service);
                    boolean _status = this.mRemote.transact(11, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().tryUnregisterService(name, service);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ServiceDebugInfo[] getServiceDebugInfo() throws RemoteException {
                ServiceDebugInfo[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IServiceManager.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(12, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        ServiceDebugInfo[] serviceDebugInfoArray = Stub.getDefaultImpl().getServiceDebugInfo();
                        return serviceDebugInfoArray;
                    }
                    _reply.readException();
                    _result = _reply.createTypedArray(ServiceDebugInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }
        }
    }

    public static class Default
    implements IServiceManager {
        @Override
        public IBinder getService(String name) throws RemoteException {
            return null;
        }

        @Override
        public IBinder checkService(String name) throws RemoteException {
            return null;
        }

        @Override
        public void addService(String name, IBinder service, boolean allowIsolated, int dumpPriority) throws RemoteException {
        }

        @Override
        public String[] listServices(int dumpPriority) throws RemoteException {
            return null;
        }

        @Override
        public void registerForNotifications(String name, IServiceCallback callback2) throws RemoteException {
        }

        @Override
        public void unregisterForNotifications(String name, IServiceCallback callback2) throws RemoteException {
        }

        @Override
        public boolean isDeclared(String name) throws RemoteException {
            return false;
        }

        @Override
        public String[] getDeclaredInstances(String iface) throws RemoteException {
            return null;
        }

        @Override
        public String updatableViaApex(String name) throws RemoteException {
            return null;
        }

        @Override
        public void registerClientCallback(String name, IBinder service, IClientCallback callback2) throws RemoteException {
        }

        @Override
        public void tryUnregisterService(String name, IBinder service) throws RemoteException {
        }

        @Override
        public ServiceDebugInfo[] getServiceDebugInfo() throws RemoteException {
            return null;
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

