/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.app.AppGlobals;
import android.app.Application;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.Context;
import android.content.pm.PackageManager;
import android.content.pm.ProviderInfo;
import android.os.CancellationSignal;
import android.os.ParcelFileDescriptor;
import android.os.Process;
import android.os.StrictMode;
import android.os.SystemClock;
import android.os.UserHandle;
import android.provider.MediaStore;
import android.system.ErrnoException;
import android.system.Os;
import android.system.OsConstants;
import android.system.StructStat;
import android.text.TextUtils;
import android.util.Log;
import android.util.Slog;
import android.webkit.MimeTypeMap;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.lang.System_Delegate;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.SizedInputStream;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import libcore.io.IoUtils;
import libcore.util.EmptyArray;

public class FileUtils {
    private static final String TAG = "FileUtils";
    public static final int S_IRWXU = 448;
    public static final int S_IRUSR = 256;
    public static final int S_IWUSR = 128;
    public static final int S_IXUSR = 64;
    public static final int S_IRWXG = 56;
    public static final int S_IRGRP = 32;
    public static final int S_IWGRP = 16;
    public static final int S_IXGRP = 8;
    public static final int S_IRWXO = 7;
    public static final int S_IROTH = 4;
    public static final int S_IWOTH = 2;
    public static final int S_IXOTH = 1;
    private static final String CAMERA_DIR_LOWER_CASE = "/storage/emulated/" + UserHandle.myUserId() + "/dcim/camera";
    private static boolean sEnableCopyOptimizations = true;
    private static volatile int sMediaProviderAppId = -1;
    private static final long COPY_CHECKPOINT_BYTES = 524288L;

    @UnsupportedAppUsage
    private FileUtils() {
    }

    @UnsupportedAppUsage
    public static int setPermissions(File path, int mode, int uid, int gid) {
        return FileUtils.setPermissions(path.getAbsolutePath(), mode, uid, gid);
    }

    @UnsupportedAppUsage
    public static int setPermissions(String path, int mode, int uid, int gid) {
        try {
            Os.chmod(path, mode);
        }
        catch (ErrnoException e) {
            Slog.w(TAG, "Failed to chmod(" + path + "): " + e);
            return e.errno;
        }
        if (uid >= 0 || gid >= 0) {
            try {
                Os.chown(path, uid, gid);
            }
            catch (ErrnoException e) {
                Slog.w(TAG, "Failed to chown(" + path + "): " + e);
                return e.errno;
            }
        }
        return 0;
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public static int setPermissions(FileDescriptor fd, int mode, int uid, int gid) {
        try {
            Os.fchmod(fd, mode);
        }
        catch (ErrnoException e) {
            Slog.w(TAG, "Failed to fchmod(): " + e);
            return e.errno;
        }
        if (uid >= 0 || gid >= 0) {
            try {
                Os.fchown(fd, uid, gid);
            }
            catch (ErrnoException e) {
                Slog.w(TAG, "Failed to fchown(): " + e);
                return e.errno;
            }
        }
        return 0;
    }

    public static void copyPermissions(File from, File to) throws IOException {
        try {
            StructStat stat = Os.stat(from.getAbsolutePath());
            Os.chmod(to.getAbsolutePath(), stat.st_mode);
            Os.chown(to.getAbsolutePath(), stat.st_uid, stat.st_gid);
        }
        catch (ErrnoException e) {
            throw e.rethrowAsIOException();
        }
    }

    @Deprecated
    public static int getUid(String path) {
        try {
            return Os.stat((String)path).st_uid;
        }
        catch (ErrnoException e) {
            return -1;
        }
    }

    @UnsupportedAppUsage
    public static boolean sync(FileOutputStream stream) {
        try {
            if (stream != null) {
                stream.getFD().sync();
            }
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    @Deprecated
    @UnsupportedAppUsage
    public static boolean copyFile(File srcFile, File destFile) {
        try {
            FileUtils.copyFileOrThrow(srcFile, destFile);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    @Deprecated
    public static void copyFileOrThrow(File srcFile, File destFile) throws IOException {
        try (FileInputStream in = new FileInputStream(srcFile);){
            FileUtils.copyToFileOrThrow(in, destFile);
        }
    }

    @Deprecated
    @UnsupportedAppUsage
    public static boolean copyToFile(InputStream inputStream, File destFile) {
        try {
            FileUtils.copyToFileOrThrow(inputStream, destFile);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    @Deprecated
    public static void copyToFileOrThrow(InputStream in, File destFile) throws IOException {
        if (destFile.exists()) {
            destFile.delete();
        }
        try (FileOutputStream out = new FileOutputStream(destFile);){
            FileUtils.copy(in, out);
            try {
                Os.fsync(out.getFD());
            }
            catch (ErrnoException e) {
                throw e.rethrowAsIOException();
            }
        }
    }

    public static long copy(File from, File to) throws IOException {
        return FileUtils.copy(from, to, null, null, null);
    }

    public static long copy(File from, File to, CancellationSignal signal, Executor executor, ProgressListener listener2) throws IOException {
        try (FileInputStream in = new FileInputStream(from);){
            long l;
            try (FileOutputStream out = new FileOutputStream(to);){
                l = FileUtils.copy(in, out, signal, executor, listener2);
            }
            return l;
        }
    }

    public static long copy(InputStream in, OutputStream out) throws IOException {
        return FileUtils.copy(in, out, null, null, null);
    }

    public static long copy(InputStream in, OutputStream out, CancellationSignal signal, Executor executor, ProgressListener listener2) throws IOException {
        if (sEnableCopyOptimizations && in instanceof FileInputStream && out instanceof FileOutputStream) {
            return FileUtils.copy(((FileInputStream)in).getFD(), ((FileOutputStream)out).getFD(), signal, executor, listener2);
        }
        return FileUtils.copyInternalUserspace(in, out, signal, executor, listener2);
    }

    public static long copy(FileDescriptor in, FileDescriptor out) throws IOException {
        return FileUtils.copy(in, out, null, null, null);
    }

    public static long copy(FileDescriptor in, FileDescriptor out, CancellationSignal signal, Executor executor, ProgressListener listener2) throws IOException {
        return FileUtils.copy(in, out, Long.MAX_VALUE, signal, executor, listener2);
    }

    public static long copy(FileDescriptor in, FileDescriptor out, long count, CancellationSignal signal, Executor executor, ProgressListener listener2) throws IOException {
        if (sEnableCopyOptimizations) {
            try {
                StructStat st_in = Os.fstat(in);
                StructStat st_out = Os.fstat(out);
                if (OsConstants.S_ISREG(st_in.st_mode) && OsConstants.S_ISREG(st_out.st_mode)) {
                    try {
                        return FileUtils.copyInternalSendfile(in, out, count, signal, executor, listener2);
                    }
                    catch (ErrnoException e) {
                        if (e.errno == OsConstants.EINVAL || e.errno == OsConstants.ENOSYS) {
                            return FileUtils.copyInternalUserspace(in, out, count, signal, executor, listener2);
                        }
                        throw e;
                    }
                }
                if (OsConstants.S_ISFIFO(st_in.st_mode) || OsConstants.S_ISFIFO(st_out.st_mode)) {
                    return FileUtils.copyInternalSplice(in, out, count, signal, executor, listener2);
                }
            }
            catch (ErrnoException e) {
                throw e.rethrowAsIOException();
            }
        }
        return FileUtils.copyInternalUserspace(in, out, count, signal, executor, listener2);
    }

    @VisibleForTesting
    public static long copyInternalSplice(FileDescriptor in, FileDescriptor out, long count, CancellationSignal signal, Executor executor, ProgressListener listener2) throws ErrnoException {
        long progressSnapshot;
        long t;
        long progress = 0L;
        long checkpoint = 0L;
        while ((t = Os.splice(in, null, out, null, Math.min(count, 524288L), OsConstants.SPLICE_F_MOVE | OsConstants.SPLICE_F_MORE)) != 0L) {
            progress += t;
            count -= t;
            if ((checkpoint += t) < 524288L) continue;
            if (signal != null) {
                signal.throwIfCanceled();
            }
            if (executor != null && listener2 != null) {
                progressSnapshot = progress;
                executor.execute(() -> listener2.onProgress(progressSnapshot));
            }
            checkpoint = 0L;
        }
        if (executor != null && listener2 != null) {
            progressSnapshot = progress;
            executor.execute(() -> listener2.onProgress(progressSnapshot));
        }
        return progress;
    }

    @VisibleForTesting
    public static long copyInternalSendfile(FileDescriptor in, FileDescriptor out, long count, CancellationSignal signal, Executor executor, ProgressListener listener2) throws ErrnoException {
        long progressSnapshot;
        long t;
        long progress = 0L;
        long checkpoint = 0L;
        while ((t = Os.sendfile(out, in, null, Math.min(count, 524288L))) != 0L) {
            progress += t;
            count -= t;
            if ((checkpoint += t) < 524288L) continue;
            if (signal != null) {
                signal.throwIfCanceled();
            }
            if (executor != null && listener2 != null) {
                progressSnapshot = progress;
                executor.execute(() -> listener2.onProgress(progressSnapshot));
            }
            checkpoint = 0L;
        }
        if (executor != null && listener2 != null) {
            progressSnapshot = progress;
            executor.execute(() -> listener2.onProgress(progressSnapshot));
        }
        return progress;
    }

    @Deprecated
    @VisibleForTesting
    public static long copyInternalUserspace(FileDescriptor in, FileDescriptor out, ProgressListener listener2, CancellationSignal signal, long count) throws IOException {
        return FileUtils.copyInternalUserspace(in, out, count, signal, Runnable::run, listener2);
    }

    @VisibleForTesting
    public static long copyInternalUserspace(FileDescriptor in, FileDescriptor out, long count, CancellationSignal signal, Executor executor, ProgressListener listener2) throws IOException {
        if (count != Long.MAX_VALUE) {
            return FileUtils.copyInternalUserspace(new SizedInputStream(new FileInputStream(in), count), new FileOutputStream(out), signal, executor, listener2);
        }
        return FileUtils.copyInternalUserspace(new FileInputStream(in), new FileOutputStream(out), signal, executor, listener2);
    }

    @VisibleForTesting
    public static long copyInternalUserspace(InputStream in, OutputStream out, CancellationSignal signal, Executor executor, ProgressListener listener2) throws IOException {
        long progressSnapshot;
        int t;
        long progress = 0L;
        long checkpoint = 0L;
        byte[] buffer = new byte[8192];
        while ((t = in.read(buffer)) != -1) {
            out.write(buffer, 0, t);
            progress += (long)t;
            if ((checkpoint += (long)t) < 524288L) continue;
            if (signal != null) {
                signal.throwIfCanceled();
            }
            if (executor != null && listener2 != null) {
                progressSnapshot = progress;
                executor.execute(() -> listener2.onProgress(progressSnapshot));
            }
            checkpoint = 0L;
        }
        if (executor != null && listener2 != null) {
            progressSnapshot = progress;
            executor.execute(() -> listener2.onProgress(progressSnapshot));
        }
        return progress;
    }

    @UnsupportedAppUsage
    public static boolean isFilenameSafe(File file2) {
        return NoImagePreloadHolder.SAFE_FILENAME_PATTERN.matcher(file2.getPath()).matches();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    public static String readTextFile(File file2, int max, String ellipsis) throws IOException {
        FileInputStream input = new FileInputStream(file2);
        BufferedInputStream bis = new BufferedInputStream(input);
        try {
            int len;
            long size = file2.length();
            if (max > 0 || size > 0L && max == 0) {
                byte[] data;
                int length;
                if (size > 0L && (max == 0 || size < (long)max)) {
                    max = (int)size;
                }
                if ((length = bis.read(data = new byte[max + 1])) <= 0) {
                    String string2 = "";
                    return string2;
                }
                if (length <= max) {
                    String string3 = new String(data, 0, length);
                    return string3;
                }
                if (ellipsis == null) {
                    String string4 = new String(data, 0, max);
                    return string4;
                }
                String string5 = new String(data, 0, max) + ellipsis;
                return string5;
            }
            if (max < 0) {
                String string6;
                int len2;
                boolean rolled = false;
                byte[] last = null;
                byte[] data = null;
                do {
                    if (last != null) {
                        rolled = true;
                    }
                    byte[] tmp = last;
                    last = data;
                    data = tmp;
                    if (data != null) continue;
                    data = new byte[-max];
                } while ((len2 = bis.read(data)) == data.length);
                if (last == null && len2 <= 0) {
                    string6 = "";
                    return string6;
                }
                if (last == null) {
                    string6 = new String(data, 0, len2);
                    return string6;
                }
                if (len2 > 0) {
                    rolled = true;
                    System.arraycopy(last, len2, last, 0, last.length - len2);
                    System.arraycopy(data, 0, last, last.length - len2, len2);
                }
                if (ellipsis == null || !rolled) {
                    string6 = new String(last);
                    return string6;
                }
                string6 = ellipsis + new String(last);
                return string6;
            }
            ByteArrayOutputStream contents = new ByteArrayOutputStream();
            byte[] data = new byte[1024];
            do {
                if ((len = bis.read(data)) <= 0) continue;
                contents.write(data, 0, len);
            } while (len == data.length);
            String string7 = contents.toString();
            return string7;
        }
        finally {
            bis.close();
            ((InputStream)input).close();
        }
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public static void stringToFile(File file2, String string2) throws IOException {
        FileUtils.stringToFile(file2.getAbsolutePath(), string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void bytesToFile(String filename, byte[] content2) throws IOException {
        block14: {
            if (filename.startsWith("/proc/")) {
                int oldMask = StrictMode.allowThreadDiskWritesMask();
                try (FileOutputStream fos = new FileOutputStream(filename);){
                    fos.write(content2);
                    break block14;
                }
                finally {
                    StrictMode.setThreadPolicyMask(oldMask);
                }
            }
            try (FileOutputStream fos = new FileOutputStream(filename);){
                fos.write(content2);
            }
        }
    }

    @UnsupportedAppUsage
    public static void stringToFile(String filename, String string2) throws IOException {
        FileUtils.bytesToFile(filename, string2.getBytes(StandardCharsets.UTF_8));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public static long checksumCrc32(File file2) throws FileNotFoundException, IOException {
        CRC32 checkSummer = new CRC32();
        FilterInputStream cis = null;
        try {
            cis = new CheckedInputStream(new FileInputStream(file2), checkSummer);
            byte[] buf = new byte[128];
            while (cis.read(buf) >= 0) {
            }
            long l = checkSummer.getValue();
            return l;
        }
        finally {
            if (cis != null) {
                try {
                    cis.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static byte[] digest(File file2, String algorithm) throws IOException, NoSuchAlgorithmException {
        try (FileInputStream in = new FileInputStream(file2);){
            byte[] byArray = FileUtils.digest(in, algorithm);
            return byArray;
        }
    }

    public static byte[] digest(InputStream in, String algorithm) throws IOException, NoSuchAlgorithmException {
        return FileUtils.digestInternalUserspace(in, algorithm);
    }

    public static byte[] digest(FileDescriptor fd, String algorithm) throws IOException, NoSuchAlgorithmException {
        return FileUtils.digestInternalUserspace(new FileInputStream(fd), algorithm);
    }

    private static byte[] digestInternalUserspace(InputStream in, String algorithm) throws IOException, NoSuchAlgorithmException {
        MessageDigest digest = MessageDigest.getInstance(algorithm);
        try (DigestInputStream digestStream = new DigestInputStream(in, digest);){
            byte[] buffer = new byte[8192];
            while (digestStream.read(buffer) != -1) {
            }
        }
        return digest.digest();
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public static boolean deleteOlderFiles(File dir, int minCount, long minAgeMs) {
        if (minCount < 0 || minAgeMs < 0L) {
            throw new IllegalArgumentException("Constraints must be positive or 0");
        }
        File[] files = dir.listFiles();
        if (files == null) {
            return false;
        }
        Arrays.sort(files, new Comparator<File>(){

            @Override
            public int compare(File lhs, File rhs) {
                return Long.compare(rhs.lastModified(), lhs.lastModified());
            }
        });
        boolean deleted = false;
        for (int i = minCount; i < files.length; ++i) {
            File file2 = files[i];
            long age = System_Delegate.currentTimeMillis() - file2.lastModified();
            if (age <= minAgeMs || !file2.delete()) continue;
            Log.d(TAG, "Deleted old file " + file2);
            deleted = true;
        }
        return deleted;
    }

    public static boolean contains(File[] dirs, File file2) {
        for (File dir : dirs) {
            if (!FileUtils.contains(dir, file2)) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(Collection<File> dirs, File file2) {
        for (File dir : dirs) {
            if (!FileUtils.contains(dir, file2)) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(File dir, File file2) {
        if (dir == null || file2 == null) {
            return false;
        }
        return FileUtils.contains(dir.getAbsolutePath(), file2.getAbsolutePath());
    }

    public static boolean contains(String dirPath, String filePath) {
        if (dirPath.equals(filePath)) {
            return true;
        }
        if (!dirPath.endsWith("/")) {
            dirPath = dirPath + "/";
        }
        return filePath.startsWith(dirPath);
    }

    public static boolean deleteContentsAndDir(File dir) {
        if (FileUtils.deleteContents(dir)) {
            return dir.delete();
        }
        return false;
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public static boolean deleteContents(File dir) {
        File[] files = dir.listFiles();
        boolean success = true;
        if (files != null) {
            for (File file2 : files) {
                if (file2.isDirectory()) {
                    success &= FileUtils.deleteContents(file2);
                }
                if (file2.delete()) continue;
                Log.w(TAG, "Failed to delete " + file2);
                success = false;
            }
        }
        return success;
    }

    private static boolean isValidExtFilenameChar(char c) {
        switch (c) {
            case '\u0000': 
            case '/': {
                return false;
            }
        }
        return true;
    }

    public static boolean isValidExtFilename(String name) {
        return name != null && name.equals(FileUtils.buildValidExtFilename(name));
    }

    public static String buildValidExtFilename(String name) {
        if (TextUtils.isEmpty(name) || ".".equals(name) || "..".equals(name)) {
            return "(invalid)";
        }
        StringBuilder res = new StringBuilder(name.length());
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (FileUtils.isValidExtFilenameChar(c)) {
                res.append(c);
                continue;
            }
            res.append('_');
        }
        FileUtils.trimFilename(res, 255);
        return res.toString();
    }

    private static boolean isValidFatFilenameChar(char c) {
        if ('\u0000' <= c && c <= '\u001f') {
            return false;
        }
        switch (c) {
            case '\"': 
            case '*': 
            case '/': 
            case ':': 
            case '<': 
            case '>': 
            case '?': 
            case '\\': 
            case '|': 
            case '\u007f': {
                return false;
            }
        }
        return true;
    }

    public static boolean isValidFatFilename(String name) {
        return name != null && name.equals(FileUtils.buildValidFatFilename(name));
    }

    public static String buildValidFatFilename(String name) {
        if (TextUtils.isEmpty(name) || ".".equals(name) || "..".equals(name)) {
            return "(invalid)";
        }
        StringBuilder res = new StringBuilder(name.length());
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (FileUtils.isValidFatFilenameChar(c)) {
                res.append(c);
                continue;
            }
            res.append('_');
        }
        FileUtils.trimFilename(res, 255);
        return res.toString();
    }

    @VisibleForTesting
    public static String trimFilename(String str, int maxBytes) {
        StringBuilder res = new StringBuilder(str);
        FileUtils.trimFilename(res, maxBytes);
        return res.toString();
    }

    private static void trimFilename(StringBuilder res, int maxBytes) {
        byte[] raw2 = res.toString().getBytes(StandardCharsets.UTF_8);
        if (raw2.length > maxBytes) {
            maxBytes -= 3;
            while (raw2.length > maxBytes) {
                res.deleteCharAt(res.length() / 2);
                raw2 = res.toString().getBytes(StandardCharsets.UTF_8);
            }
            res.insert(res.length() / 2, "...");
        }
    }

    public static String rewriteAfterRename(File beforeDir, File afterDir, String path) {
        if (path == null) {
            return null;
        }
        File result = FileUtils.rewriteAfterRename(beforeDir, afterDir, new File(path));
        return result != null ? result.getAbsolutePath() : null;
    }

    public static String[] rewriteAfterRename(File beforeDir, File afterDir, String[] paths) {
        if (paths == null) {
            return null;
        }
        String[] result = new String[paths.length];
        for (int i = 0; i < paths.length; ++i) {
            result[i] = FileUtils.rewriteAfterRename(beforeDir, afterDir, paths[i]);
        }
        return result;
    }

    public static File rewriteAfterRename(File beforeDir, File afterDir, File file2) {
        if (file2 == null || beforeDir == null || afterDir == null) {
            return null;
        }
        if (FileUtils.contains(beforeDir, file2)) {
            String splice = file2.getAbsolutePath().substring(beforeDir.getAbsolutePath().length());
            return new File(afterDir, splice);
        }
        return null;
    }

    private static File buildUniqueFileWithExtension(File parent, String name, String ext) throws FileNotFoundException {
        File file2 = FileUtils.buildFile(parent, name, ext);
        int n = 0;
        while (file2.exists()) {
            if (n++ >= 32) {
                throw new FileNotFoundException("Failed to create unique file");
            }
            file2 = FileUtils.buildFile(parent, name + " (" + n + ")", ext);
        }
        return file2;
    }

    public static File buildUniqueFile(File parent, String mimeType, String displayName) throws FileNotFoundException {
        String[] parts = FileUtils.splitFileName(mimeType, displayName);
        return FileUtils.buildUniqueFileWithExtension(parent, parts[0], parts[1]);
    }

    public static File buildNonUniqueFile(File parent, String mimeType, String displayName) {
        String[] parts = FileUtils.splitFileName(mimeType, displayName);
        return FileUtils.buildFile(parent, parts[0], parts[1]);
    }

    public static File buildUniqueFile(File parent, String displayName) throws FileNotFoundException {
        String ext;
        String name;
        int lastDot = displayName.lastIndexOf(46);
        if (lastDot >= 0) {
            name = displayName.substring(0, lastDot);
            ext = displayName.substring(lastDot + 1);
        } else {
            name = displayName;
            ext = null;
        }
        return FileUtils.buildUniqueFileWithExtension(parent, name, ext);
    }

    public static String[] splitFileName(String mimeType, String displayName) {
        String ext;
        String name;
        if ("vnd.android.document/directory".equals(mimeType)) {
            name = displayName;
            ext = null;
        } else {
            String mimeTypeFromExt;
            int lastDot = displayName.lastIndexOf(46);
            if (lastDot >= 0) {
                name = displayName.substring(0, lastDot);
                ext = displayName.substring(lastDot + 1);
                mimeTypeFromExt = MimeTypeMap.getSingleton().getMimeTypeFromExtension(ext.toLowerCase());
            } else {
                name = displayName;
                ext = null;
                mimeTypeFromExt = null;
            }
            if (mimeTypeFromExt == null) {
                mimeTypeFromExt = "application/octet-stream";
            }
            String extFromMimeType = "application/octet-stream".equals(mimeType) ? null : MimeTypeMap.getSingleton().getExtensionFromMimeType(mimeType);
            if (!Objects.equals(mimeType, mimeTypeFromExt) && !Objects.equals(ext, extFromMimeType)) {
                name = displayName;
                ext = extFromMimeType;
            }
        }
        if (ext == null) {
            ext = "";
        }
        return new String[]{name, ext};
    }

    private static File buildFile(File parent, String name, String ext) {
        if (TextUtils.isEmpty(ext)) {
            return new File(parent, name);
        }
        return new File(parent, name + "." + ext);
    }

    public static String[] listOrEmpty(File dir) {
        return dir != null ? ArrayUtils.defeatNullable(dir.list()) : EmptyArray.STRING;
    }

    public static File[] listFilesOrEmpty(File dir) {
        return dir != null ? ArrayUtils.defeatNullable(dir.listFiles()) : ArrayUtils.EMPTY_FILE;
    }

    public static File[] listFilesOrEmpty(File dir, FilenameFilter filter2) {
        return dir != null ? ArrayUtils.defeatNullable(dir.listFiles(filter2)) : ArrayUtils.EMPTY_FILE;
    }

    public static File newFileOrNull(String path) {
        return path != null ? new File(path) : null;
    }

    public static File createDir(File baseDir, String name) {
        File dir = new File(baseDir, name);
        return FileUtils.createDir(dir) ? dir : null;
    }

    public static boolean createDir(File dir) {
        if (dir.mkdir()) {
            return true;
        }
        if (dir.exists()) {
            return dir.isDirectory();
        }
        return false;
    }

    public static long roundStorageSize(long size) {
        long val = 1L;
        long pow = 1L;
        while (val * pow < size) {
            if ((val <<= 1) <= 512L) continue;
            val = 1L;
            pow *= 1000L;
        }
        return val * pow;
    }

    @Deprecated
    public static void closeQuietly(AutoCloseable closeable) {
        IoUtils.closeQuietly(closeable);
    }

    @Deprecated
    public static void closeQuietly(FileDescriptor fd) {
        IoUtils.closeQuietly(fd);
    }

    public static int translateModeStringToPosix(String mode) {
        block3: for (int i = 0; i < mode.length(); ++i) {
            switch (mode.charAt(i)) {
                case 'a': 
                case 'r': 
                case 't': 
                case 'w': {
                    continue block3;
                }
                default: {
                    throw new IllegalArgumentException("Bad mode: " + mode);
                }
            }
        }
        int res = 0;
        if (mode.startsWith("rw")) {
            res = OsConstants.O_RDWR | OsConstants.O_CREAT;
        } else if (mode.startsWith("w")) {
            res = OsConstants.O_WRONLY | OsConstants.O_CREAT;
        } else if (mode.startsWith("r")) {
            res = OsConstants.O_RDONLY;
        } else {
            throw new IllegalArgumentException("Bad mode: " + mode);
        }
        if (mode.indexOf(116) != -1) {
            res |= OsConstants.O_TRUNC;
        }
        if (mode.indexOf(97) != -1) {
            res |= OsConstants.O_APPEND;
        }
        return res;
    }

    public static String translateModePosixToString(int mode) {
        String res = "";
        if ((mode & OsConstants.O_ACCMODE) == OsConstants.O_RDWR) {
            res = "rw";
        } else if ((mode & OsConstants.O_ACCMODE) == OsConstants.O_WRONLY) {
            res = "w";
        } else if ((mode & OsConstants.O_ACCMODE) == OsConstants.O_RDONLY) {
            res = "r";
        } else {
            throw new IllegalArgumentException("Bad mode: " + mode);
        }
        if ((mode & OsConstants.O_TRUNC) == OsConstants.O_TRUNC) {
            res = res + "t";
        }
        if ((mode & OsConstants.O_APPEND) == OsConstants.O_APPEND) {
            res = res + "a";
        }
        return res;
    }

    public static int translateModePosixToPfd(int mode) {
        int res = 0;
        if ((mode & OsConstants.O_ACCMODE) == OsConstants.O_RDWR) {
            res = 0x30000000;
        } else if ((mode & OsConstants.O_ACCMODE) == OsConstants.O_WRONLY) {
            res = 0x20000000;
        } else if ((mode & OsConstants.O_ACCMODE) == OsConstants.O_RDONLY) {
            res = 0x10000000;
        } else {
            throw new IllegalArgumentException("Bad mode: " + mode);
        }
        if ((mode & OsConstants.O_CREAT) == OsConstants.O_CREAT) {
            res |= 0x8000000;
        }
        if ((mode & OsConstants.O_TRUNC) == OsConstants.O_TRUNC) {
            res |= 0x4000000;
        }
        if ((mode & OsConstants.O_APPEND) == OsConstants.O_APPEND) {
            res |= 0x2000000;
        }
        return res;
    }

    public static int translateModePfdToPosix(int mode) {
        int res = 0;
        if ((mode & 0x30000000) == 0x30000000) {
            res = OsConstants.O_RDWR;
        } else if ((mode & 0x20000000) == 0x20000000) {
            res = OsConstants.O_WRONLY;
        } else if ((mode & 0x10000000) == 0x10000000) {
            res = OsConstants.O_RDONLY;
        } else {
            throw new IllegalArgumentException("Bad mode: " + mode);
        }
        if ((mode & 0x8000000) == 0x8000000) {
            res |= OsConstants.O_CREAT;
        }
        if ((mode & 0x4000000) == 0x4000000) {
            res |= OsConstants.O_TRUNC;
        }
        if ((mode & 0x2000000) == 0x2000000) {
            res |= OsConstants.O_APPEND;
        }
        return res;
    }

    public static int translateModeAccessToPosix(int mode) {
        if (mode == OsConstants.F_OK) {
            return OsConstants.O_RDONLY;
        }
        if ((mode & (OsConstants.R_OK | OsConstants.W_OK)) == (OsConstants.R_OK | OsConstants.W_OK)) {
            return OsConstants.O_RDWR;
        }
        if ((mode & OsConstants.R_OK) == OsConstants.R_OK) {
            return OsConstants.O_RDONLY;
        }
        if ((mode & OsConstants.W_OK) == OsConstants.W_OK) {
            return OsConstants.O_WRONLY;
        }
        throw new IllegalArgumentException("Bad mode: " + mode);
    }

    @VisibleForTesting
    public static ParcelFileDescriptor convertToModernFd(FileDescriptor fd) {
        ParcelFileDescriptor parcelFileDescriptor;
        block9: {
            Application context = AppGlobals.getInitialApplication();
            if (UserHandle.getAppId(Process.myUid()) == FileUtils.getMediaProviderAppId(context)) {
                return null;
            }
            ParcelFileDescriptor dupFd = ParcelFileDescriptor.dup(fd);
            try {
                parcelFileDescriptor = MediaStore.getOriginalMediaFormatFileDescriptor(context, dupFd);
                if (dupFd == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (dupFd != null) {
                        try {
                            dupFd.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    return null;
                }
            }
            dupFd.close();
        }
        return parcelFileDescriptor;
    }

    private static int getMediaProviderAppId(Context context) {
        if (sMediaProviderAppId != -1) {
            return sMediaProviderAppId;
        }
        PackageManager pm = context.getPackageManager();
        ProviderInfo provider2 = context.getPackageManager().resolveContentProvider("media", 0x1C0000);
        if (provider2 == null) {
            return -1;
        }
        sMediaProviderAppId = UserHandle.getAppId(provider2.applicationInfo.uid);
        return sMediaProviderAppId;
    }

    @VisibleForTesting
    public static class MemoryPipe
    extends Thread
    implements AutoCloseable {
        private final FileDescriptor[] pipe;
        private final byte[] data;
        private final boolean sink;

        private MemoryPipe(byte[] data, boolean sink) throws IOException {
            try {
                this.pipe = Os.pipe();
            }
            catch (ErrnoException e) {
                throw e.rethrowAsIOException();
            }
            this.data = data;
            this.sink = sink;
        }

        private MemoryPipe startInternal() {
            super.start();
            return this;
        }

        public static MemoryPipe createSource(byte[] data) throws IOException {
            return new MemoryPipe(data, false).startInternal();
        }

        public static MemoryPipe createSink(byte[] data) throws IOException {
            return new MemoryPipe(data, true).startInternal();
        }

        public FileDescriptor getFD() {
            return this.sink ? this.pipe[1] : this.pipe[0];
        }

        public FileDescriptor getInternalFD() {
            return this.sink ? this.pipe[0] : this.pipe[1];
        }

        @Override
        public void run() {
            FileDescriptor fd = this.getInternalFD();
            try {
                int i = 0;
                while (i < this.data.length) {
                    if (this.sink) {
                        i += Os.read(fd, this.data, i, this.data.length - i);
                        continue;
                    }
                    i += Os.write(fd, this.data, i, this.data.length - i);
                }
            }
            catch (ErrnoException | IOException exception) {
            }
            finally {
                if (this.sink) {
                    SystemClock.sleep(TimeUnit.SECONDS.toMillis(1L));
                }
                IoUtils.closeQuietly(fd);
            }
        }

        @Override
        public void close() throws Exception {
            IoUtils.closeQuietly(this.getFD());
        }
    }

    public static interface ProgressListener {
        public void onProgress(long var1);
    }

    private static class NoImagePreloadHolder {
        public static final Pattern SAFE_FILENAME_PATTERN = Pattern.compile("[\\w%+,./=_-]+");

        private NoImagePreloadHolder() {
        }
    }
}

