/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.annotation.RequiresPermission;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.Context;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.os.RemoteException;
import android.os.TransactionTooLargeException;
import android.util.Log;
import com.android.internal.os.IDropBoxManagerService;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.nio.charset.StandardCharsets;
import java.util.zip.GZIPInputStream;

public class DropBoxManager {
    private static final String TAG = "DropBoxManager";
    private final Context mContext;
    @UnsupportedAppUsage
    private final IDropBoxManagerService mService;
    public static final int IS_EMPTY = 1;
    public static final int IS_TEXT = 2;
    public static final int IS_GZIPPED = 4;
    private static final int HAS_BYTE_ARRAY = 8;
    public static final String ACTION_DROPBOX_ENTRY_ADDED = "android.intent.action.DROPBOX_ENTRY_ADDED";
    public static final String EXTRA_TAG = "tag";
    public static final String EXTRA_TIME = "time";
    public static final String EXTRA_DROPPED_COUNT = "android.os.extra.DROPPED_COUNT";

    public DropBoxManager(Context context, IDropBoxManagerService service) {
        this.mContext = context;
        this.mService = service;
    }

    protected DropBoxManager() {
        this.mContext = null;
        this.mService = null;
    }

    public void addText(String tag, String data) {
        this.addData(tag, data.getBytes(StandardCharsets.UTF_8), 2);
    }

    public void addData(String tag, byte[] data, int flags) {
        if (data == null) {
            throw new NullPointerException("data == null");
        }
        try {
            this.mService.addData(tag, data, flags);
        }
        catch (RemoteException e) {
            if (e instanceof TransactionTooLargeException && this.mContext.getApplicationInfo().targetSdkVersion < 24) {
                Log.e(TAG, "App sent too much data, so it was ignored", e);
                return;
            }
            throw e.rethrowFromSystemServer();
        }
    }

    public void addFile(String tag, File file2, int flags) throws IOException {
        if (file2 == null) {
            throw new NullPointerException("file == null");
        }
        try (ParcelFileDescriptor pfd = ParcelFileDescriptor.open(file2, 0x10000000);){
            this.mService.addFile(tag, pfd, flags);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean isTagEnabled(String tag) {
        try {
            return this.mService.isTagEnabled(tag);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(allOf={"android.permission.READ_LOGS", "android.permission.PACKAGE_USAGE_STATS"})
    public Entry getNextEntry(String tag, long msec) {
        try {
            return this.mService.getNextEntryWithAttribution(tag, msec, this.mContext.getOpPackageName(), this.mContext.getAttributionTag());
        }
        catch (SecurityException e) {
            if (this.mContext.getApplicationInfo().targetSdkVersion >= 28) {
                throw e;
            }
            Log.w(TAG, e.getMessage());
            return null;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public static class Entry
    implements Parcelable,
    Closeable {
        private final String mTag;
        private final long mTimeMillis;
        private final byte[] mData;
        private final ParcelFileDescriptor mFileDescriptor;
        private final int mFlags;
        public static final Parcelable.Creator<Entry> CREATOR = new Parcelable.Creator(){

            public Entry[] newArray(int size) {
                return new Entry[size];
            }

            public Entry createFromParcel(Parcel in) {
                String tag = in.readString();
                long millis = in.readLong();
                int flags = in.readInt();
                if ((flags & 8) != 0) {
                    return new Entry(tag, millis, in.createByteArray(), flags & 0xFFFFFFF7);
                }
                ParcelFileDescriptor pfd = ParcelFileDescriptor.CREATOR.createFromParcel(in);
                return new Entry(tag, millis, pfd, flags);
            }
        };

        public Entry(String tag, long millis) {
            if (tag == null) {
                throw new NullPointerException("tag == null");
            }
            this.mTag = tag;
            this.mTimeMillis = millis;
            this.mData = null;
            this.mFileDescriptor = null;
            this.mFlags = 1;
        }

        public Entry(String tag, long millis, String text) {
            if (tag == null) {
                throw new NullPointerException("tag == null");
            }
            if (text == null) {
                throw new NullPointerException("text == null");
            }
            this.mTag = tag;
            this.mTimeMillis = millis;
            this.mData = text.getBytes(StandardCharsets.UTF_8);
            this.mFileDescriptor = null;
            this.mFlags = 2;
        }

        public Entry(String tag, long millis, byte[] data, int flags) {
            if (tag == null) {
                throw new NullPointerException("tag == null");
            }
            if ((flags & 1) != 0 != (data == null)) {
                throw new IllegalArgumentException("Bad flags: " + flags);
            }
            this.mTag = tag;
            this.mTimeMillis = millis;
            this.mData = data;
            this.mFileDescriptor = null;
            this.mFlags = flags;
        }

        public Entry(String tag, long millis, ParcelFileDescriptor data, int flags) {
            if (tag == null) {
                throw new NullPointerException("tag == null");
            }
            if ((flags & 1) != 0 != (data == null)) {
                throw new IllegalArgumentException("Bad flags: " + flags);
            }
            this.mTag = tag;
            this.mTimeMillis = millis;
            this.mData = null;
            this.mFileDescriptor = data;
            this.mFlags = flags;
        }

        public Entry(String tag, long millis, File data, int flags) throws IOException {
            if (tag == null) {
                throw new NullPointerException("tag == null");
            }
            if ((flags & 1) != 0) {
                throw new IllegalArgumentException("Bad flags: " + flags);
            }
            this.mTag = tag;
            this.mTimeMillis = millis;
            this.mData = null;
            this.mFileDescriptor = ParcelFileDescriptor.open(data, 0x10000000);
            this.mFlags = flags;
        }

        @Override
        public void close() {
            try {
                if (this.mFileDescriptor != null) {
                    this.mFileDescriptor.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public String getTag() {
            return this.mTag;
        }

        public long getTimeMillis() {
            return this.mTimeMillis;
        }

        public int getFlags() {
            return this.mFlags & 0xFFFFFFFB;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String getText(int maxBytes) {
            String string2;
            if ((this.mFlags & 2) == 0) {
                return null;
            }
            if (this.mData != null) {
                return new String(this.mData, 0, Math.min(maxBytes, this.mData.length));
            }
            InputStream is = null;
            try {
                is = this.getInputStream();
                if (is == null) {
                    String string3 = null;
                    return string3;
                }
                byte[] buf = new byte[maxBytes];
                int readBytes = 0;
                int n = 0;
                while (n >= 0 && (readBytes += n) < maxBytes) {
                    n = is.read(buf, readBytes, maxBytes - readBytes);
                }
                string2 = new String(buf, 0, readBytes);
            }
            catch (IOException e) {
                String string4 = null;
                return string4;
            }
            finally {
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException iOException) {}
            }
            return string2;
        }

        public InputStream getInputStream() throws IOException {
            InputStream is;
            if (this.mData != null) {
                is = new ByteArrayInputStream(this.mData);
            } else if (this.mFileDescriptor != null) {
                is = new ParcelFileDescriptor.AutoCloseInputStream(this.mFileDescriptor);
            } else {
                return null;
            }
            return (this.mFlags & 4) != 0 ? new GZIPInputStream(is) : is;
        }

        @Override
        public int describeContents() {
            return this.mFileDescriptor != null ? 1 : 0;
        }

        @Override
        public void writeToParcel(Parcel out, int flags) {
            out.writeString(this.mTag);
            out.writeLong(this.mTimeMillis);
            if (this.mFileDescriptor != null) {
                out.writeInt(this.mFlags & 0xFFFFFFF7);
                this.mFileDescriptor.writeToParcel(out, flags);
            } else {
                out.writeInt(this.mFlags | 8);
                out.writeByteArray(this.mData);
            }
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Flags {
    }
}

