/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.bluetooth.BluetoothUuid;
import android.net.MacAddress;
import android.os.ParcelUuid;
import android.text.TextUtils;
import android.util.Log;
import com.android.internal.util.HexDump;
import java.util.ArrayList;
import java.util.function.Predicate;

public class BytesMatcher
implements Predicate<byte[]> {
    private static final String TAG = "BytesMatcher";
    private static final char TYPE_EXACT_ACCEPT = '+';
    private static final char TYPE_EXACT_REJECT = '-';
    private static final char TYPE_PREFIX_ACCEPT = '\u2286';
    private static final char TYPE_PREFIX_REJECT = '\u2288';
    private final ArrayList<Rule> mRules = new ArrayList();

    public void addExactAcceptRule(byte[] value2, byte[] mask) {
        this.mRules.add(new Rule('+', value2, mask));
    }

    public void addExactRejectRule(byte[] value2, byte[] mask) {
        this.mRules.add(new Rule('-', value2, mask));
    }

    public void addPrefixAcceptRule(byte[] value2, byte[] mask) {
        this.mRules.add(new Rule('\u2286', value2, mask));
    }

    public void addPrefixRejectRule(byte[] value2, byte[] mask) {
        this.mRules.add(new Rule('\u2288', value2, mask));
    }

    public boolean testBluetoothUuid(ParcelUuid value2) {
        return this.test(BluetoothUuid.uuidToBytes(value2));
    }

    public boolean testMacAddress(MacAddress value2) {
        return this.test(value2.toByteArray());
    }

    @Override
    public boolean test(byte[] value2) {
        return this.test(value2, false);
    }

    public boolean test(byte[] value2, boolean defaultValue2) {
        int size = this.mRules.size();
        for (int i = 0; i < size; ++i) {
            Rule rule = this.mRules.get(i);
            if (!rule.test(value2)) continue;
            switch (rule.type) {
                case '+': 
                case '\u2286': {
                    return true;
                }
                case '-': 
                case '\u2288': {
                    return false;
                }
            }
        }
        return defaultValue2;
    }

    public static String encode(BytesMatcher matcher) {
        StringBuilder builder2 = new StringBuilder();
        int size = matcher.mRules.size();
        for (int i = 0; i < size; ++i) {
            Rule rule = matcher.mRules.get(i);
            rule.encode(builder2);
            builder2.append(',');
        }
        if (builder2.length() > 0) {
            builder2.deleteCharAt(builder2.length() - 1);
        }
        return builder2.toString();
    }

    public static BytesMatcher decode(String value2) {
        BytesMatcher matcher = new BytesMatcher();
        if (TextUtils.isEmpty(value2)) {
            return matcher;
        }
        int length = value2.length();
        int i = 0;
        while (i < length) {
            byte[] ruleMask;
            byte[] ruleValue;
            char type = value2.charAt(i);
            int nextRule = value2.indexOf(44, i);
            int nextMask = value2.indexOf(47, i);
            if (nextRule == -1) {
                nextRule = length;
            }
            if (nextMask > nextRule) {
                nextMask = -1;
            }
            if (nextMask >= 0) {
                ruleValue = HexDump.hexStringToByteArray(value2.substring(i + 1, nextMask));
                ruleMask = HexDump.hexStringToByteArray(value2.substring(nextMask + 1, nextRule));
            } else {
                ruleValue = HexDump.hexStringToByteArray(value2.substring(i + 1, nextRule));
                ruleMask = null;
            }
            switch (type) {
                case '+': {
                    matcher.addExactAcceptRule(ruleValue, ruleMask);
                    break;
                }
                case '-': {
                    matcher.addExactRejectRule(ruleValue, ruleMask);
                    break;
                }
                case '\u2286': {
                    matcher.addPrefixAcceptRule(ruleValue, ruleMask);
                    break;
                }
                case '\u2288': {
                    matcher.addPrefixRejectRule(ruleValue, ruleMask);
                    break;
                }
                default: {
                    Log.w(TAG, "Ignoring unknown type " + type);
                }
            }
            i = nextRule + 1;
        }
        return matcher;
    }

    private static class Rule {
        public final char type;
        public final byte[] value;
        public final byte[] mask;

        public Rule(char type, byte[] value2, byte[] mask) {
            if (mask != null && value2.length != mask.length) {
                throw new IllegalArgumentException("Expected length " + value2.length + " but found " + mask.length);
            }
            this.type = type;
            this.value = value2;
            this.mask = mask;
        }

        public String toString() {
            StringBuilder builder2 = new StringBuilder();
            this.encode(builder2);
            return builder2.toString();
        }

        public void encode(StringBuilder builder2) {
            builder2.append(this.type);
            builder2.append(HexDump.toHexString(this.value));
            if (this.mask != null) {
                builder2.append('/');
                builder2.append(HexDump.toHexString(this.mask));
            }
        }

        public boolean test(byte[] value2) {
            switch (this.type) {
                case '+': 
                case '-': {
                    if (value2.length == this.value.length) break;
                    return false;
                }
                case '\u2286': 
                case '\u2288': {
                    if (value2.length >= this.value.length) break;
                    return false;
                }
            }
            for (int i = 0; i < this.value.length; ++i) {
                byte local = this.value[i];
                byte remote = value2[i];
                if (this.mask != null) {
                    local = (byte)(local & this.mask[i]);
                    remote = (byte)(remote & this.mask[i]);
                }
                if (local == remote) continue;
                return false;
            }
            return true;
        }
    }
}

