/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.annotation.SystemApi;
import android.app.AppOpsManager;
import android.compat.annotation.UnsupportedAppUsage;
import android.os.BinderProxy;
import android.os.Binder_Delegate;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.os.ResultReceiver;
import android.os.ShellCallback;
import android.os.StrictMode;
import android.os.ThreadLocalWorkSource;
import android.os.Trace;
import android.os.TransactionTracker;
import android.os.UserHandle;
import android.util.ExceptionUtils;
import android.util.Log;
import android.util.Slog;
import com.android.internal.os.BinderCallHeavyHitterWatcher;
import com.android.internal.os.BinderInternal;
import com.android.internal.util.FastPrintWriter;
import com.android.internal.util.FunctionalUtils;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import com.android.tools.layoutlib.create.OverrideMethod;
import dalvik.annotation.optimization.CriticalNative;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import libcore.io.IoUtils;
import libcore.util.NativeAllocationRegistry;

public class Binder
implements IBinder {
    private static final boolean FIND_POTENTIAL_LEAKS = false;
    public static final boolean CHECK_PARCEL_SIZE = false;
    static final String TAG = "Binder";
    public static boolean LOG_RUNTIME_EXCEPTION = false;
    public static final int UNSET_WORKSOURCE = -1;
    private static volatile String sDumpDisabled = null;
    private static volatile TransactionTracker sTransactionTracker = null;
    private static BinderInternal.Observer sObserver = null;
    private static final int NATIVE_ALLOCATION_SIZE = 500;
    private static volatile BinderCallHeavyHitterWatcher sHeavyHitterWatcher = null;
    private static volatile boolean sTracingEnabled = false;
    static volatile boolean sWarnOnBlocking = false;
    static ThreadLocal<Boolean> sWarnOnBlockingOnCurrentThread = ThreadLocal.withInitial(() -> sWarnOnBlocking);
    @UnsupportedAppUsage
    private final long mObject = Binder.getNativeBBinderHolder();
    private IInterface mOwner;
    private String mDescriptor;
    private static volatile BinderInternal.WorkSourceProvider sWorkSourceProvider = x -> Binder.getCallingUid();

    @LayoutlibDelegate
    private static long getNativeFinalizer() {
        return Binder_Delegate.getNativeFinalizer();
    }

    public static void enableTracing() {
        sTracingEnabled = true;
    }

    public static void disableTracing() {
        sTracingEnabled = false;
    }

    public static boolean isTracingEnabled() {
        return sTracingEnabled;
    }

    public static synchronized TransactionTracker getTransactionTracker() {
        if (sTransactionTracker == null) {
            sTransactionTracker = new TransactionTracker();
        }
        return sTransactionTracker;
    }

    public static void setObserver(BinderInternal.Observer observer) {
        sObserver = observer;
    }

    public static void setWarnOnBlocking(boolean warnOnBlocking) {
        sWarnOnBlocking = warnOnBlocking;
    }

    public static IBinder allowBlocking(IBinder binder) {
        try {
            if (binder instanceof BinderProxy) {
                ((BinderProxy)binder).mWarnOnBlocking = false;
            } else if (binder != null && binder.getInterfaceDescriptor() != null && binder.queryLocalInterface(binder.getInterfaceDescriptor()) == null) {
                Log.w(TAG, "Unable to allow blocking on interface " + binder);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return binder;
    }

    public static IBinder defaultBlocking(IBinder binder) {
        if (binder instanceof BinderProxy) {
            ((BinderProxy)binder).mWarnOnBlocking = sWarnOnBlocking;
        }
        return binder;
    }

    public static void copyAllowBlocking(IBinder fromBinder, IBinder toBinder) {
        if (fromBinder instanceof BinderProxy && toBinder instanceof BinderProxy) {
            ((BinderProxy)toBinder).mWarnOnBlocking = ((BinderProxy)fromBinder).mWarnOnBlocking;
        }
    }

    public static void allowBlockingForCurrentThread() {
        sWarnOnBlockingOnCurrentThread.set(false);
    }

    public static void defaultBlockingForCurrentThread() {
        sWarnOnBlockingOnCurrentThread.set(sWarnOnBlocking);
    }

    @CriticalNative
    public static int getCallingPid() {
        return OverrideMethod.invokeI("android.os.Binder#getCallingPid()I", true, null);
    }

    @CriticalNative
    public static int getCallingUid() {
        return OverrideMethod.invokeI("android.os.Binder#getCallingUid()I", true, null);
    }

    @CriticalNative
    public static boolean isHandlingTransaction() {
        return OverrideMethod.invokeI("android.os.Binder#isHandlingTransaction()Z", true, null) != 0;
    }

    public static int getCallingUidOrThrow() {
        if (!Binder.isHandlingTransaction()) {
            throw new IllegalStateException("Thread is not in a binder transcation");
        }
        return Binder.getCallingUid();
    }

    public static UserHandle getCallingUserHandle() {
        return UserHandle.of(UserHandle.getUserId(Binder.getCallingUid()));
    }

    @CriticalNative
    public static long clearCallingIdentity() {
        return OverrideMethod.invokeL("android.os.Binder#clearCallingIdentity()J", true, null);
    }

    @CriticalNative
    public static void restoreCallingIdentity(long l) {
        OverrideMethod.invokeV("android.os.Binder#restoreCallingIdentity(J)V", true, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void withCleanCallingIdentity(FunctionalUtils.ThrowingRunnable action2) {
        Throwable throwableToPropagate = null;
        long callingIdentity = Binder.clearCallingIdentity();
        try {
            action2.runOrThrow();
        }
        catch (Throwable throwable) {
            throwableToPropagate = throwable;
        }
        finally {
            Binder.restoreCallingIdentity(callingIdentity);
            if (throwableToPropagate != null) {
                throw ExceptionUtils.propagate(throwableToPropagate);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T withCleanCallingIdentity(FunctionalUtils.ThrowingSupplier<T> action2) {
        Throwable throwableToPropagate = null;
        long callingIdentity = Binder.clearCallingIdentity();
        try {
            T t = action2.getOrThrow();
            return t;
        }
        catch (Throwable throwable) {
            throwableToPropagate = throwable;
            T t = null;
            return t;
        }
        finally {
            Binder.restoreCallingIdentity(callingIdentity);
            if (throwableToPropagate != null) {
                throw ExceptionUtils.propagate(throwableToPropagate);
            }
        }
    }

    @CriticalNative
    public static void setThreadStrictModePolicy(int n) {
        OverrideMethod.invokeV("android.os.Binder#setThreadStrictModePolicy(I)V", true, null);
    }

    @CriticalNative
    public static int getThreadStrictModePolicy() {
        return OverrideMethod.invokeI("android.os.Binder#getThreadStrictModePolicy()I", true, null);
    }

    @CriticalNative
    public static long setCallingWorkSourceUid(int n) {
        return OverrideMethod.invokeL("android.os.Binder#setCallingWorkSourceUid(I)J", true, null);
    }

    @CriticalNative
    public static int getCallingWorkSourceUid() {
        return OverrideMethod.invokeI("android.os.Binder#getCallingWorkSourceUid()I", true, null);
    }

    @CriticalNative
    public static long clearCallingWorkSource() {
        return OverrideMethod.invokeL("android.os.Binder#clearCallingWorkSource()J", true, null);
    }

    @CriticalNative
    public static void restoreCallingWorkSource(long l) {
        OverrideMethod.invokeV("android.os.Binder#restoreCallingWorkSource(J)V", true, null);
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public void markVintfStability() {
        OverrideMethod.invokeV("android.os.Binder#markVintfStability()V", true, this);
    }

    public void forceDowngradeToSystemStability() {
        OverrideMethod.invokeV("android.os.Binder#forceDowngradeToSystemStability()V", true, this);
    }

    public static void flushPendingCommands() {
        OverrideMethod.invokeV("android.os.Binder#flushPendingCommands()V", true, null);
    }

    public static void joinThreadPool() {
        BinderInternal.joinThreadPool();
    }

    public static boolean isProxy(IInterface iface) {
        return iface.asBinder() != iface;
    }

    public static void blockUntilThreadAvailable() {
        OverrideMethod.invokeV("android.os.Binder#blockUntilThreadAvailable()V", true, null);
    }

    public Binder() {
        this(null);
    }

    public Binder(String descriptor) {
        NoImagePreloadHolder.sRegistry.registerNativeAllocation(this, this.mObject);
        this.mDescriptor = descriptor;
    }

    public void attachInterface(IInterface owner, String descriptor) {
        this.mOwner = owner;
        this.mDescriptor = descriptor;
    }

    @Override
    public String getInterfaceDescriptor() {
        return this.mDescriptor;
    }

    @Override
    public boolean pingBinder() {
        return true;
    }

    @Override
    public boolean isBinderAlive() {
        return true;
    }

    @Override
    public IInterface queryLocalInterface(String descriptor) {
        if (this.mDescriptor != null && this.mDescriptor.equals(descriptor)) {
            return this.mOwner;
        }
        return null;
    }

    public static void setDumpDisabled(String msg) {
        sDumpDisabled = msg;
    }

    @SystemApi
    public static void setProxyTransactListener(ProxyTransactListener listener2) {
        BinderProxy.setTransactListener(listener2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
        if (code == 1598968902) {
            reply.writeString(this.getInterfaceDescriptor());
            return true;
        }
        if (code == 1598311760) {
            ParcelFileDescriptor fd = data.readFileDescriptor();
            String[] args = data.readStringArray();
            if (fd != null) {
                try {
                    this.dump(fd.getFileDescriptor(), args);
                }
                finally {
                    IoUtils.closeQuietly(fd);
                }
            }
            if (reply != null) {
                reply.writeNoException();
            } else {
                StrictMode.clearGatheredViolations();
            }
            return true;
        }
        if (code == 1598246212) {
            ParcelFileDescriptor in = data.readFileDescriptor();
            ParcelFileDescriptor out = data.readFileDescriptor();
            ParcelFileDescriptor err = data.readFileDescriptor();
            String[] args = data.readStringArray();
            ShellCallback shellCallback = ShellCallback.CREATOR.createFromParcel(data);
            ResultReceiver resultReceiver = ResultReceiver.CREATOR.createFromParcel(data);
            try {
                if (out != null) {
                    this.shellCommand(in != null ? in.getFileDescriptor() : null, out.getFileDescriptor(), err != null ? err.getFileDescriptor() : out.getFileDescriptor(), args, shellCallback, resultReceiver);
                }
            }
            finally {
                IoUtils.closeQuietly(in);
                IoUtils.closeQuietly(out);
                IoUtils.closeQuietly(err);
                if (reply != null) {
                    reply.writeNoException();
                } else {
                    StrictMode.clearGatheredViolations();
                }
            }
            return true;
        }
        return false;
    }

    public String getTransactionName(int transactionCode) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dump(FileDescriptor fd, String[] args) {
        FileOutputStream fout = new FileOutputStream(fd);
        FastPrintWriter pw = new FastPrintWriter(fout);
        try {
            this.doDump(fd, pw, args);
        }
        finally {
            ((PrintWriter)pw).flush();
        }
    }

    void doDump(FileDescriptor fd, PrintWriter pw, String[] args) {
        String disabled = sDumpDisabled;
        if (disabled == null) {
            try {
                this.dump(fd, pw, args);
            }
            catch (SecurityException e) {
                pw.println("Security exception: " + e.getMessage());
                throw e;
            }
            catch (Throwable e) {
                pw.println();
                pw.println("Exception occurred while dumping:");
                e.printStackTrace(pw);
            }
        } else {
            pw.println(sDumpDisabled);
        }
    }

    @Override
    public void dumpAsync(final FileDescriptor fd, final String[] args) {
        FileOutputStream fout = new FileOutputStream(fd);
        final FastPrintWriter pw = new FastPrintWriter(fout);
        Thread thr = new Thread("Binder.dumpAsync"){

            @Override
            public void run() {
                try {
                    Binder.this.dump(fd, pw, args);
                }
                finally {
                    pw.flush();
                }
            }
        };
        thr.start();
    }

    protected void dump(FileDescriptor fd, PrintWriter fout, String[] args) {
    }

    @Override
    public void shellCommand(FileDescriptor in, FileDescriptor out, FileDescriptor err, String[] args, ShellCallback callback2, ResultReceiver resultReceiver) throws RemoteException {
        this.onShellCommand(in, out, err, args, callback2, resultReceiver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onShellCommand(FileDescriptor in, FileDescriptor out, FileDescriptor err, String[] args, ShellCallback callback2, ResultReceiver resultReceiver) throws RemoteException {
        int callingUid = Binder.getCallingUid();
        if (callingUid != 0 && callingUid != 2000) {
            resultReceiver.send(-1, null);
            throw new SecurityException("Shell commands are only callable by ADB");
        }
        try {
            if (in == null) {
                in = new FileInputStream("/dev/null").getFD();
            }
            if (out == null) {
                out = new FileOutputStream("/dev/null").getFD();
            }
            if (err == null) {
                err = out;
            }
        }
        catch (IOException e) {
            FastPrintWriter pw = new FastPrintWriter(new FileOutputStream(err != null ? err : out));
            pw.println("Failed to open /dev/null: " + e.getMessage());
            ((PrintWriter)pw).flush();
            resultReceiver.send(-1, null);
            return;
        }
        if (args == null) {
            args = new String[]{};
        }
        int result = -1;
        try (ParcelFileDescriptor inPfd = ParcelFileDescriptor.dup(in);
             ParcelFileDescriptor outPfd = ParcelFileDescriptor.dup(out);
             ParcelFileDescriptor errPfd = ParcelFileDescriptor.dup(err);){
            result = this.handleShellCommand(inPfd, outPfd, errPfd, args);
        }
        catch (IOException e) {
            FastPrintWriter pw = new FastPrintWriter(new FileOutputStream(err));
            pw.println("dup() failed: " + e.getMessage());
            ((PrintWriter)pw).flush();
        }
        finally {
            resultReceiver.send(result, null);
        }
    }

    @SystemApi
    public int handleShellCommand(ParcelFileDescriptor in, ParcelFileDescriptor out, ParcelFileDescriptor err, String[] args) {
        FileOutputStream ferr = new FileOutputStream(err.getFileDescriptor());
        FastPrintWriter pw = new FastPrintWriter(ferr);
        pw.println("No shell command implementation.");
        ((PrintWriter)pw).flush();
        return 0;
    }

    @Override
    public IBinder getExtension() {
        return (IBinder)OverrideMethod.invokeA("android.os.Binder#getExtension()Landroid/os/IBinder;", true, this);
    }

    public void setExtension(IBinder iBinder) {
        OverrideMethod.invokeV("android.os.Binder#setExtension(Landroid/os/IBinder;)V", true, this);
    }

    @Override
    public boolean transact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
        if (data != null) {
            data.setDataPosition(0);
        }
        boolean r = this.onTransact(code, data, reply, flags);
        if (reply != null) {
            reply.setDataPosition(0);
        }
        return r;
    }

    @Override
    public void linkToDeath(IBinder.DeathRecipient recipient, int flags) {
    }

    @Override
    public boolean unlinkToDeath(IBinder.DeathRecipient recipient, int flags) {
        return true;
    }

    static void checkParcel(IBinder obj, int code, Parcel parcel, String msg) {
    }

    @LayoutlibDelegate
    private static long getNativeBBinderHolder() {
        return Binder_Delegate.getNativeBBinderHolder();
    }

    public static void setWorkSourceProvider(BinderInternal.WorkSourceProvider workSourceProvider) {
        if (workSourceProvider == null) {
            throw new IllegalArgumentException("workSourceProvider cannot be null");
        }
        sWorkSourceProvider = workSourceProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    private boolean execTransact(int code, long dataObj, long replyObj, int flags) {
        int callingUid = Binder.getCallingUid();
        long origWorkSource = ThreadLocalWorkSource.setUid(callingUid);
        try {
            boolean bl = this.execTransactInternal(code, dataObj, replyObj, flags, callingUid);
            return bl;
        }
        finally {
            ThreadLocalWorkSource.restore(origWorkSource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean execTransactInternal(int code, long dataObj, long replyObj, int flags, int callingUid) {
        boolean res;
        Parcel reply;
        Parcel data;
        block19: {
            BinderInternal.Observer observer = sObserver;
            BinderInternal.CallSession callSession = observer != null ? observer.callStarted(this, code, -1) : null;
            data = Parcel.obtain(dataObj);
            reply = Parcel.obtain(replyObj);
            boolean tracingEnabled = Binder.isTracingEnabled();
            try {
                BinderCallHeavyHitterWatcher heavyHitterWatcher = sHeavyHitterWatcher;
                if (heavyHitterWatcher != null) {
                    heavyHitterWatcher.onTransaction(callingUid, this.getClass(), code);
                }
                if (tracingEnabled) {
                    String transactionName = this.getTransactionName(code);
                    Trace.traceBegin(1L, this.getClass().getName() + ":" + (transactionName != null ? transactionName : Integer.valueOf(code)));
                }
                if ((flags & 2) != 0) {
                    AppOpsManager.startNotedAppOpsCollection(callingUid);
                    try {
                        res = this.onTransact(code, data, reply, flags);
                        break block19;
                    }
                    finally {
                        AppOpsManager.finishNotedAppOpsCollection();
                    }
                }
                res = this.onTransact(code, data, reply, flags);
            }
            catch (RemoteException | RuntimeException e) {
                if (observer != null) {
                    observer.callThrewException(callSession, e);
                }
                if (LOG_RUNTIME_EXCEPTION) {
                    Log.w(TAG, "Caught a RuntimeException from the binder stub implementation.", e);
                }
                if ((flags & 1) != 0) {
                    if (e instanceof RemoteException) {
                        Log.w(TAG, "Binder call failed.", e);
                    } else {
                        Log.w(TAG, "Caught a RuntimeException from the binder stub implementation.", e);
                    }
                } else {
                    reply.setDataSize(0);
                    reply.setDataPosition(0);
                    reply.writeException(e);
                }
                res = true;
            }
            finally {
                if (tracingEnabled) {
                    Trace.traceEnd(1L);
                }
                if (observer != null) {
                    int workSourceUid = sWorkSourceProvider.resolveWorkSourceUid(data.readCallingWorkSourceUid());
                    observer.callEnded(callSession, data.dataSize(), reply.dataSize(), workSourceUid);
                }
            }
        }
        Binder.checkParcel(this, code, reply, "Unreasonably large binder reply buffer");
        reply.recycle();
        data.recycle();
        StrictMode.clearGatheredViolations();
        return res;
    }

    public static synchronized void setHeavyHitterWatcherConfig(boolean enabled, int batchSize, float threshold, BinderCallHeavyHitterWatcher.BinderCallHeavyHitterListener listener2) {
        Slog.i(TAG, "Setting heavy hitter watcher config: " + enabled + ", " + batchSize + ", " + threshold);
        BinderCallHeavyHitterWatcher watcher = sHeavyHitterWatcher;
        if (enabled) {
            if (listener2 == null) {
                throw new IllegalArgumentException();
            }
            boolean newWatcher = false;
            if (watcher == null) {
                watcher = BinderCallHeavyHitterWatcher.getInstance();
                newWatcher = true;
            }
            watcher.setConfig(true, batchSize, threshold, listener2);
            if (newWatcher) {
                sHeavyHitterWatcher = watcher;
            }
        } else if (watcher != null) {
            watcher.setConfig(false, 0, 0.0f, null);
        }
    }

    static /* synthetic */ long access$000() {
        return Binder.getNativeFinalizer();
    }

    public static class PropagateWorkSourceTransactListener
    implements ProxyTransactListener {
        @Override
        public Object onTransactStarted(IBinder binder, int transactionCode) {
            int uid = ThreadLocalWorkSource.getUid();
            if (uid != -1) {
                return Binder.setCallingWorkSourceUid(uid);
            }
            return null;
        }

        @Override
        public void onTransactEnded(Object session) {
            if (session != null) {
                long token = (Long)session;
                Binder.restoreCallingWorkSource(token);
            }
        }
    }

    @SystemApi
    public static interface ProxyTransactListener {
        default public Object onTransactStarted(IBinder binder, int transactionCode, int flags) {
            return this.onTransactStarted(binder, transactionCode);
        }

        public Object onTransactStarted(IBinder var1, int var2);

        public void onTransactEnded(Object var1);
    }

    private static class NoImagePreloadHolder {
        public static final NativeAllocationRegistry sRegistry = new NativeAllocationRegistry(Binder.class.getClassLoader(), Binder.access$000(), 500L);

        private NoImagePreloadHolder() {
        }
    }
}

