/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.Parcel;
import android.os.Parcelable;
import android.os.UserHandle;
import android.util.IntArray;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class BatteryUsageStatsQuery
implements Parcelable {
    public static final BatteryUsageStatsQuery DEFAULT = new Builder().build();
    public static final int FLAG_BATTERY_USAGE_STATS_POWER_PROFILE_MODEL = 1;
    public static final int FLAG_BATTERY_USAGE_STATS_INCLUDE_HISTORY = 2;
    public static final int FLAG_BATTERY_USAGE_STATS_INCLUDE_POWER_MODELS = 4;
    private static final long DEFAULT_MAX_STATS_AGE_MS = 300000L;
    private final int mFlags;
    private final int[] mUserIds;
    private final long mMaxStatsAgeMs;
    private long mFromTimestamp;
    private long mToTimestamp;
    public static final Parcelable.Creator<BatteryUsageStatsQuery> CREATOR = new Parcelable.Creator<BatteryUsageStatsQuery>(){

        @Override
        public BatteryUsageStatsQuery createFromParcel(Parcel in) {
            return new BatteryUsageStatsQuery(in);
        }

        public BatteryUsageStatsQuery[] newArray(int size) {
            return new BatteryUsageStatsQuery[size];
        }
    };

    private BatteryUsageStatsQuery(Builder builder2) {
        int[] nArray;
        this.mFlags = builder2.mFlags;
        if (builder2.mUserIds != null) {
            nArray = builder2.mUserIds.toArray();
        } else {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = -1;
        }
        this.mUserIds = nArray;
        this.mMaxStatsAgeMs = builder2.mMaxStatsAgeMs;
        this.mFromTimestamp = builder2.mFromTimestamp;
        this.mToTimestamp = builder2.mToTimestamp;
    }

    public int getFlags() {
        return this.mFlags;
    }

    public int[] getUserIds() {
        return this.mUserIds;
    }

    public boolean shouldForceUsePowerProfileModel() {
        return (this.mFlags & 1) != 0;
    }

    public long getMaxStatsAge() {
        return this.mMaxStatsAgeMs;
    }

    public long getFromTimestamp() {
        return this.mFromTimestamp;
    }

    public long getToTimestamp() {
        return this.mToTimestamp;
    }

    private BatteryUsageStatsQuery(Parcel in) {
        this.mFlags = in.readInt();
        this.mUserIds = new int[in.readInt()];
        in.readIntArray(this.mUserIds);
        this.mMaxStatsAgeMs = in.readLong();
        this.mFromTimestamp = in.readLong();
        this.mToTimestamp = in.readLong();
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mFlags);
        dest.writeInt(this.mUserIds.length);
        dest.writeIntArray(this.mUserIds);
        dest.writeLong(this.mMaxStatsAgeMs);
        dest.writeLong(this.mFromTimestamp);
        dest.writeLong(this.mToTimestamp);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public static class Builder {
        private int mFlags;
        private IntArray mUserIds;
        private long mMaxStatsAgeMs = 300000L;
        private long mFromTimestamp;
        private long mToTimestamp;

        public BatteryUsageStatsQuery build() {
            return new BatteryUsageStatsQuery(this);
        }

        public Builder addUser(UserHandle userHandle) {
            if (this.mUserIds == null) {
                this.mUserIds = new IntArray(1);
            }
            this.mUserIds.add(userHandle.getIdentifier());
            return this;
        }

        public Builder includeBatteryHistory() {
            this.mFlags |= 2;
            return this;
        }

        public Builder powerProfileModeledOnly() {
            this.mFlags |= 1;
            return this;
        }

        public Builder includePowerModels() {
            this.mFlags |= 4;
            return this;
        }

        public Builder aggregateSnapshots(long fromTimestamp, long toTimestamp) {
            this.mFromTimestamp = fromTimestamp;
            this.mToTimestamp = toTimestamp;
            return this;
        }

        public Builder setMaxStatsAgeMs(long maxStatsAgeMs) {
            this.mMaxStatsAgeMs = maxStatsAgeMs;
            return this;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface BatteryUsageStatsFlags {
    }
}

