/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.compat.annotation.UnsupportedAppUsage;
import android.os.BadParcelableException;
import android.os.Bundle;
import android.os.Parcel;
import android.os.PersistableBundle;
import android.util.ArrayMap;
import android.util.Log;
import android.util.MathUtils;
import android.util.SparseArray;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.IndentingPrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Set;

public class BaseBundle {
    private static final String TAG = "Bundle";
    static final boolean DEBUG = false;
    private static final int BUNDLE_MAGIC = 1279544898;
    private static final int BUNDLE_MAGIC_NATIVE = 0x4C444E44;
    static final int FLAG_DEFUSABLE = 1;
    private static final boolean LOG_DEFUSABLE = false;
    private static volatile boolean sShouldDefuse = false;
    @UnsupportedAppUsage
    ArrayMap<String, Object> mMap = null;
    @UnsupportedAppUsage
    Parcel mParcelledData = null;
    private boolean mParcelledByNative;
    private ClassLoader mClassLoader;
    @VisibleForTesting
    public int mFlags;

    public static void setShouldDefuse(boolean shouldDefuse) {
        sShouldDefuse = shouldDefuse;
    }

    BaseBundle(ClassLoader loader, int capacity) {
        this.mMap = capacity > 0 ? new ArrayMap(capacity) : new ArrayMap();
        this.mClassLoader = loader == null ? this.getClass().getClassLoader() : loader;
    }

    BaseBundle() {
        this((ClassLoader)null, 0);
    }

    BaseBundle(Parcel parcelledData) {
        this.readFromParcelInner(parcelledData);
    }

    BaseBundle(Parcel parcelledData, int length) {
        this.readFromParcelInner(parcelledData, length);
    }

    BaseBundle(ClassLoader loader) {
        this(loader, 0);
    }

    BaseBundle(int capacity) {
        this((ClassLoader)null, capacity);
    }

    BaseBundle(BaseBundle b) {
        this.copyInternal(b, false);
    }

    BaseBundle(boolean doInit) {
    }

    public String getPairValue() {
        this.unparcel();
        int size = this.mMap.size();
        if (size > 1) {
            Log.w(TAG, "getPairValue() used on Bundle with multiple pairs.");
        }
        if (size == 0) {
            return null;
        }
        Object o = this.mMap.valueAt(0);
        try {
            return (String)o;
        }
        catch (ClassCastException e) {
            this.typeWarning("getPairValue()", o, "String", e);
            return null;
        }
    }

    void setClassLoader(ClassLoader loader) {
        this.mClassLoader = loader;
    }

    ClassLoader getClassLoader() {
        return this.mClassLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    void unparcel() {
        BaseBundle baseBundle = this;
        synchronized (baseBundle) {
            Parcel source = this.mParcelledData;
            if (source != null) {
                this.initializeFromParcelLocked(source, true, this.mParcelledByNative);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeFromParcelLocked(Parcel parcelledData, boolean recycleParcel, boolean parcelledByNative) {
        block15: {
            if (BaseBundle.isEmptyParcel(parcelledData)) {
                if (this.mMap == null) {
                    this.mMap = new ArrayMap(1);
                } else {
                    this.mMap.erase();
                }
                this.mParcelledData = null;
                this.mParcelledByNative = false;
                return;
            }
            int count = parcelledData.readInt();
            if (count < 0) {
                return;
            }
            ArrayMap<String, Object> map2 = this.mMap;
            if (map2 == null) {
                map2 = new ArrayMap(count);
            } else {
                map2.erase();
                map2.ensureCapacity(count);
            }
            try {
                if (parcelledByNative) {
                    parcelledData.readArrayMapSafelyInternal(map2, count, this.mClassLoader);
                } else {
                    parcelledData.readArrayMapInternal(map2, count, this.mClassLoader);
                }
            }
            catch (BadParcelableException e) {
                if (sShouldDefuse) {
                    Log.w(TAG, "Failed to parse Bundle, but defusing quietly", e);
                    map2.erase();
                    break block15;
                }
                throw e;
            }
            finally {
                this.mMap = map2;
                if (recycleParcel) {
                    BaseBundle.recycleParcel(parcelledData);
                }
                this.mParcelledData = null;
                this.mParcelledByNative = false;
            }
        }
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public boolean isParcelled() {
        return this.mParcelledData != null;
    }

    public boolean isEmptyParcel() {
        return BaseBundle.isEmptyParcel(this.mParcelledData);
    }

    private static boolean isEmptyParcel(Parcel p) {
        return p == NoImagePreloadHolder.EMPTY_PARCEL;
    }

    private static void recycleParcel(Parcel p) {
        if (p != null && !BaseBundle.isEmptyParcel(p)) {
            p.recycle();
        }
    }

    ArrayMap<String, Object> getMap() {
        this.unparcel();
        return this.mMap;
    }

    public int size() {
        this.unparcel();
        return this.mMap.size();
    }

    public boolean isEmpty() {
        this.unparcel();
        return this.mMap.isEmpty();
    }

    public boolean isDefinitelyEmpty() {
        if (this.isParcelled()) {
            return this.isEmptyParcel();
        }
        return this.isEmpty();
    }

    public static boolean kindofEquals(BaseBundle a, BaseBundle b) {
        return a == b || a != null && a.kindofEquals(b);
    }

    public boolean kindofEquals(BaseBundle other) {
        if (other == null) {
            return false;
        }
        if (this.isDefinitelyEmpty() && other.isDefinitelyEmpty()) {
            return true;
        }
        if (this.isParcelled() != other.isParcelled()) {
            return false;
        }
        if (this.isParcelled()) {
            return this.mParcelledData.compareData(other.mParcelledData) == 0;
        }
        return this.mMap.equals(other.mMap);
    }

    public void clear() {
        this.unparcel();
        this.mMap.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void copyInternal(BaseBundle from, boolean deep) {
        BaseBundle baseBundle = from;
        synchronized (baseBundle) {
            if (from.mParcelledData != null) {
                if (from.isEmptyParcel()) {
                    this.mParcelledData = NoImagePreloadHolder.EMPTY_PARCEL;
                    this.mParcelledByNative = false;
                } else {
                    this.mParcelledData = Parcel.obtain();
                    this.mParcelledData.appendFrom(from.mParcelledData, 0, from.mParcelledData.dataSize());
                    this.mParcelledData.setDataPosition(0);
                    this.mParcelledByNative = from.mParcelledByNative;
                }
            } else {
                this.mParcelledData = null;
                this.mParcelledByNative = false;
            }
            if (from.mMap != null) {
                if (!deep) {
                    this.mMap = new ArrayMap<String, Object>(from.mMap);
                } else {
                    ArrayMap<String, Object> fromMap = from.mMap;
                    int N = fromMap.size();
                    this.mMap = new ArrayMap(N);
                    for (int i = 0; i < N; ++i) {
                        this.mMap.append(fromMap.keyAt(i), this.deepCopyValue(fromMap.valueAt(i)));
                    }
                }
            } else {
                this.mMap = null;
            }
            this.mClassLoader = from.mClassLoader;
        }
    }

    Object deepCopyValue(Object value2) {
        if (value2 == null) {
            return null;
        }
        if (value2 instanceof Bundle) {
            return ((Bundle)value2).deepCopy();
        }
        if (value2 instanceof PersistableBundle) {
            return ((PersistableBundle)value2).deepCopy();
        }
        if (value2 instanceof ArrayList) {
            return this.deepcopyArrayList((ArrayList)value2);
        }
        if (value2.getClass().isArray()) {
            if (value2 instanceof int[]) {
                return ((int[])value2).clone();
            }
            if (value2 instanceof long[]) {
                return ((long[])value2).clone();
            }
            if (value2 instanceof float[]) {
                return ((float[])value2).clone();
            }
            if (value2 instanceof double[]) {
                return ((double[])value2).clone();
            }
            if (value2 instanceof Object[]) {
                return ((Object[])value2).clone();
            }
            if (value2 instanceof byte[]) {
                return ((byte[])value2).clone();
            }
            if (value2 instanceof short[]) {
                return ((short[])value2).clone();
            }
            if (value2 instanceof char[]) {
                return ((char[])value2).clone();
            }
        }
        return value2;
    }

    ArrayList deepcopyArrayList(ArrayList from) {
        int N = from.size();
        ArrayList<Object> out = new ArrayList<Object>(N);
        for (int i = 0; i < N; ++i) {
            out.add(this.deepCopyValue(from.get(i)));
        }
        return out;
    }

    public boolean containsKey(String key) {
        this.unparcel();
        return this.mMap.containsKey(key);
    }

    public Object get(String key) {
        this.unparcel();
        return this.mMap.get(key);
    }

    public void remove(String key) {
        this.unparcel();
        this.mMap.remove(key);
    }

    public void putAll(PersistableBundle bundle) {
        this.unparcel();
        bundle.unparcel();
        this.mMap.putAll(bundle.mMap);
    }

    void putAll(ArrayMap map2) {
        this.unparcel();
        this.mMap.putAll(map2);
    }

    public Set<String> keySet() {
        this.unparcel();
        return this.mMap.keySet();
    }

    public void putObject(String key, Object value2) {
        if (value2 == null) {
            this.putString(key, null);
        } else if (value2 instanceof Boolean) {
            this.putBoolean(key, (Boolean)value2);
        } else if (value2 instanceof Integer) {
            this.putInt(key, (Integer)value2);
        } else if (value2 instanceof Long) {
            this.putLong(key, (Long)value2);
        } else if (value2 instanceof Double) {
            this.putDouble(key, (Double)value2);
        } else if (value2 instanceof String) {
            this.putString(key, (String)value2);
        } else if (value2 instanceof boolean[]) {
            this.putBooleanArray(key, (boolean[])value2);
        } else if (value2 instanceof int[]) {
            this.putIntArray(key, (int[])value2);
        } else if (value2 instanceof long[]) {
            this.putLongArray(key, (long[])value2);
        } else if (value2 instanceof double[]) {
            this.putDoubleArray(key, (double[])value2);
        } else if (value2 instanceof String[]) {
            this.putStringArray(key, (String[])value2);
        } else {
            throw new IllegalArgumentException("Unsupported type " + value2.getClass());
        }
    }

    public void putBoolean(String key, boolean value2) {
        this.unparcel();
        this.mMap.put(key, value2);
    }

    void putByte(String key, byte value2) {
        this.unparcel();
        this.mMap.put(key, value2);
    }

    void putChar(String key, char value2) {
        this.unparcel();
        this.mMap.put(key, Character.valueOf(value2));
    }

    void putShort(String key, short value2) {
        this.unparcel();
        this.mMap.put(key, value2);
    }

    public void putInt(String key, int value2) {
        this.unparcel();
        this.mMap.put(key, value2);
    }

    public void putLong(String key, long value2) {
        this.unparcel();
        this.mMap.put(key, value2);
    }

    void putFloat(String key, float value2) {
        this.unparcel();
        this.mMap.put(key, Float.valueOf(value2));
    }

    public void putDouble(String key, double value2) {
        this.unparcel();
        this.mMap.put(key, value2);
    }

    public void putString(String key, String value2) {
        this.unparcel();
        this.mMap.put(key, value2);
    }

    void putCharSequence(String key, CharSequence value2) {
        this.unparcel();
        this.mMap.put(key, value2);
    }

    void putIntegerArrayList(String key, ArrayList<Integer> value2) {
        this.unparcel();
        this.mMap.put(key, value2);
    }

    void putStringArrayList(String key, ArrayList<String> value2) {
        this.unparcel();
        this.mMap.put(key, value2);
    }

    void putCharSequenceArrayList(String key, ArrayList<CharSequence> value2) {
        this.unparcel();
        this.mMap.put(key, value2);
    }

    void putSerializable(String key, Serializable value2) {
        this.unparcel();
        this.mMap.put(key, value2);
    }

    public void putBooleanArray(String key, boolean[] value2) {
        this.unparcel();
        this.mMap.put(key, value2);
    }

    void putByteArray(String key, byte[] value2) {
        this.unparcel();
        this.mMap.put(key, value2);
    }

    void putShortArray(String key, short[] value2) {
        this.unparcel();
        this.mMap.put(key, value2);
    }

    void putCharArray(String key, char[] value2) {
        this.unparcel();
        this.mMap.put(key, value2);
    }

    public void putIntArray(String key, int[] value2) {
        this.unparcel();
        this.mMap.put(key, value2);
    }

    public void putLongArray(String key, long[] value2) {
        this.unparcel();
        this.mMap.put(key, value2);
    }

    void putFloatArray(String key, float[] value2) {
        this.unparcel();
        this.mMap.put(key, value2);
    }

    public void putDoubleArray(String key, double[] value2) {
        this.unparcel();
        this.mMap.put(key, value2);
    }

    public void putStringArray(String key, String[] value2) {
        this.unparcel();
        this.mMap.put(key, value2);
    }

    void putCharSequenceArray(String key, CharSequence[] value2) {
        this.unparcel();
        this.mMap.put(key, value2);
    }

    public boolean getBoolean(String key) {
        this.unparcel();
        return this.getBoolean(key, false);
    }

    void typeWarning(String key, Object value2, String className2, Object defaultValue2, ClassCastException e) {
        StringBuilder sb = new StringBuilder();
        sb.append("Key ");
        sb.append(key);
        sb.append(" expected ");
        sb.append(className2);
        sb.append(" but value was a ");
        sb.append(value2.getClass().getName());
        sb.append(".  The default value ");
        sb.append(defaultValue2);
        sb.append(" was returned.");
        Log.w(TAG, sb.toString());
        Log.w(TAG, "Attempt to cast generated internal exception:", e);
    }

    void typeWarning(String key, Object value2, String className2, ClassCastException e) {
        this.typeWarning(key, value2, className2, "<null>", e);
    }

    public boolean getBoolean(String key, boolean defaultValue2) {
        this.unparcel();
        Object o = this.mMap.get(key);
        if (o == null) {
            return defaultValue2;
        }
        try {
            return (Boolean)o;
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "Boolean", defaultValue2, e);
            return defaultValue2;
        }
    }

    byte getByte(String key) {
        this.unparcel();
        return this.getByte(key, (byte)0);
    }

    Byte getByte(String key, byte defaultValue2) {
        this.unparcel();
        Object o = this.mMap.get(key);
        if (o == null) {
            return defaultValue2;
        }
        try {
            return (Byte)o;
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "Byte", defaultValue2, e);
            return defaultValue2;
        }
    }

    char getChar(String key) {
        this.unparcel();
        return this.getChar(key, '\u0000');
    }

    char getChar(String key, char defaultValue2) {
        this.unparcel();
        Object o = this.mMap.get(key);
        if (o == null) {
            return defaultValue2;
        }
        try {
            return ((Character)o).charValue();
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "Character", Character.valueOf(defaultValue2), e);
            return defaultValue2;
        }
    }

    short getShort(String key) {
        this.unparcel();
        return this.getShort(key, (short)0);
    }

    short getShort(String key, short defaultValue2) {
        this.unparcel();
        Object o = this.mMap.get(key);
        if (o == null) {
            return defaultValue2;
        }
        try {
            return (Short)o;
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "Short", defaultValue2, e);
            return defaultValue2;
        }
    }

    public int getInt(String key) {
        this.unparcel();
        return this.getInt(key, 0);
    }

    public int getInt(String key, int defaultValue2) {
        this.unparcel();
        Object o = this.mMap.get(key);
        if (o == null) {
            return defaultValue2;
        }
        try {
            return (Integer)o;
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "Integer", defaultValue2, e);
            return defaultValue2;
        }
    }

    public long getLong(String key) {
        this.unparcel();
        return this.getLong(key, 0L);
    }

    public long getLong(String key, long defaultValue2) {
        this.unparcel();
        Object o = this.mMap.get(key);
        if (o == null) {
            return defaultValue2;
        }
        try {
            return (Long)o;
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "Long", defaultValue2, e);
            return defaultValue2;
        }
    }

    float getFloat(String key) {
        this.unparcel();
        return this.getFloat(key, 0.0f);
    }

    float getFloat(String key, float defaultValue2) {
        this.unparcel();
        Object o = this.mMap.get(key);
        if (o == null) {
            return defaultValue2;
        }
        try {
            return ((Float)o).floatValue();
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "Float", Float.valueOf(defaultValue2), e);
            return defaultValue2;
        }
    }

    public double getDouble(String key) {
        this.unparcel();
        return this.getDouble(key, 0.0);
    }

    public double getDouble(String key, double defaultValue2) {
        this.unparcel();
        Object o = this.mMap.get(key);
        if (o == null) {
            return defaultValue2;
        }
        try {
            return (Double)o;
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "Double", defaultValue2, e);
            return defaultValue2;
        }
    }

    public String getString(String key) {
        this.unparcel();
        Object o = this.mMap.get(key);
        try {
            return (String)o;
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "String", e);
            return null;
        }
    }

    public String getString(String key, String defaultValue2) {
        String s = this.getString(key);
        return s == null ? defaultValue2 : s;
    }

    CharSequence getCharSequence(String key) {
        this.unparcel();
        Object o = this.mMap.get(key);
        try {
            return (CharSequence)o;
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "CharSequence", e);
            return null;
        }
    }

    CharSequence getCharSequence(String key, CharSequence defaultValue2) {
        CharSequence cs = this.getCharSequence(key);
        return cs == null ? defaultValue2 : cs;
    }

    Serializable getSerializable(String key) {
        this.unparcel();
        Object o = this.mMap.get(key);
        if (o == null) {
            return null;
        }
        try {
            return (Serializable)o;
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "Serializable", e);
            return null;
        }
    }

    ArrayList<Integer> getIntegerArrayList(String key) {
        this.unparcel();
        Object o = this.mMap.get(key);
        if (o == null) {
            return null;
        }
        try {
            return (ArrayList)o;
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "ArrayList<Integer>", e);
            return null;
        }
    }

    ArrayList<String> getStringArrayList(String key) {
        this.unparcel();
        Object o = this.mMap.get(key);
        if (o == null) {
            return null;
        }
        try {
            return (ArrayList)o;
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "ArrayList<String>", e);
            return null;
        }
    }

    ArrayList<CharSequence> getCharSequenceArrayList(String key) {
        this.unparcel();
        Object o = this.mMap.get(key);
        if (o == null) {
            return null;
        }
        try {
            return (ArrayList)o;
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "ArrayList<CharSequence>", e);
            return null;
        }
    }

    public boolean[] getBooleanArray(String key) {
        this.unparcel();
        Object o = this.mMap.get(key);
        if (o == null) {
            return null;
        }
        try {
            return (boolean[])o;
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "byte[]", e);
            return null;
        }
    }

    byte[] getByteArray(String key) {
        this.unparcel();
        Object o = this.mMap.get(key);
        if (o == null) {
            return null;
        }
        try {
            return (byte[])o;
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "byte[]", e);
            return null;
        }
    }

    short[] getShortArray(String key) {
        this.unparcel();
        Object o = this.mMap.get(key);
        if (o == null) {
            return null;
        }
        try {
            return (short[])o;
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "short[]", e);
            return null;
        }
    }

    char[] getCharArray(String key) {
        this.unparcel();
        Object o = this.mMap.get(key);
        if (o == null) {
            return null;
        }
        try {
            return (char[])o;
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "char[]", e);
            return null;
        }
    }

    public int[] getIntArray(String key) {
        this.unparcel();
        Object o = this.mMap.get(key);
        if (o == null) {
            return null;
        }
        try {
            return (int[])o;
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "int[]", e);
            return null;
        }
    }

    public long[] getLongArray(String key) {
        this.unparcel();
        Object o = this.mMap.get(key);
        if (o == null) {
            return null;
        }
        try {
            return (long[])o;
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "long[]", e);
            return null;
        }
    }

    float[] getFloatArray(String key) {
        this.unparcel();
        Object o = this.mMap.get(key);
        if (o == null) {
            return null;
        }
        try {
            return (float[])o;
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "float[]", e);
            return null;
        }
    }

    public double[] getDoubleArray(String key) {
        this.unparcel();
        Object o = this.mMap.get(key);
        if (o == null) {
            return null;
        }
        try {
            return (double[])o;
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "double[]", e);
            return null;
        }
    }

    public String[] getStringArray(String key) {
        this.unparcel();
        Object o = this.mMap.get(key);
        if (o == null) {
            return null;
        }
        try {
            return (String[])o;
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "String[]", e);
            return null;
        }
    }

    CharSequence[] getCharSequenceArray(String key) {
        this.unparcel();
        Object o = this.mMap.get(key);
        if (o == null) {
            return null;
        }
        try {
            return (CharSequence[])o;
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "CharSequence[]", e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeToParcelInner(Parcel parcel, int flags) {
        ArrayMap<String, Object> map2;
        if (parcel.hasReadWriteHelper()) {
            this.unparcel();
        }
        BaseBundle baseBundle = this;
        synchronized (baseBundle) {
            if (this.mParcelledData != null) {
                if (this.mParcelledData == NoImagePreloadHolder.EMPTY_PARCEL) {
                    parcel.writeInt(0);
                } else {
                    int length = this.mParcelledData.dataSize();
                    parcel.writeInt(length);
                    parcel.writeInt(this.mParcelledByNative ? 0x4C444E44 : 1279544898);
                    parcel.appendFrom(this.mParcelledData, 0, length);
                }
                return;
            }
            map2 = this.mMap;
        }
        if (map2 == null || map2.size() <= 0) {
            parcel.writeInt(0);
            return;
        }
        int lengthPos = parcel.dataPosition();
        parcel.writeInt(-1);
        parcel.writeInt(1279544898);
        int startPos = parcel.dataPosition();
        parcel.writeArrayMapInternal(map2);
        int endPos = parcel.dataPosition();
        parcel.setDataPosition(lengthPos);
        int length = endPos - startPos;
        parcel.writeInt(length);
        parcel.setDataPosition(endPos);
    }

    void readFromParcelInner(Parcel parcel) {
        int length = parcel.readInt();
        this.readFromParcelInner(parcel, length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readFromParcelInner(Parcel parcel, int length) {
        boolean isNativeBundle;
        if (length < 0) {
            throw new RuntimeException("Bad length in parcel: " + length);
        }
        if (length == 0) {
            this.mParcelledData = NoImagePreloadHolder.EMPTY_PARCEL;
            this.mParcelledByNative = false;
            return;
        }
        if (length % 4 != 0) {
            throw new IllegalStateException("Bundle length is not aligned by 4: " + length);
        }
        int magic = parcel.readInt();
        boolean isJavaBundle = magic == 1279544898;
        boolean bl = isNativeBundle = magic == 0x4C444E44;
        if (!isJavaBundle && !isNativeBundle) {
            throw new IllegalStateException("Bad magic number for Bundle: 0x" + Integer.toHexString(magic));
        }
        if (parcel.hasReadWriteHelper()) {
            BaseBundle baseBundle = this;
            synchronized (baseBundle) {
                this.initializeFromParcelLocked(parcel, false, isNativeBundle);
            }
            return;
        }
        int offset2 = parcel.dataPosition();
        parcel.setDataPosition(MathUtils.addOrThrow(offset2, length));
        Parcel p = Parcel.obtain();
        p.setDataPosition(0);
        p.appendFrom(parcel, offset2, length);
        p.adoptClassCookies(parcel);
        p.setDataPosition(0);
        this.mParcelledData = p;
        this.mParcelledByNative = isNativeBundle;
    }

    public static void dumpStats(IndentingPrintWriter pw, String key, Object value2) {
        Parcel tmp = Parcel.obtain();
        tmp.writeValue(value2);
        int size = tmp.dataPosition();
        tmp.recycle();
        if (size > 1024) {
            pw.println(key + " [size=" + size + "]");
            if (value2 instanceof BaseBundle) {
                BaseBundle.dumpStats(pw, (BaseBundle)value2);
            } else if (value2 instanceof SparseArray) {
                BaseBundle.dumpStats(pw, (SparseArray)value2);
            }
        }
    }

    public static void dumpStats(IndentingPrintWriter pw, SparseArray array2) {
        pw.increaseIndent();
        if (array2 == null) {
            pw.println("[null]");
            return;
        }
        for (int i = 0; i < array2.size(); ++i) {
            BaseBundle.dumpStats(pw, "0x" + Integer.toHexString(array2.keyAt(i)), array2.valueAt(i));
        }
        pw.decreaseIndent();
    }

    public static void dumpStats(IndentingPrintWriter pw, BaseBundle bundle) {
        pw.increaseIndent();
        if (bundle == null) {
            pw.println("[null]");
            return;
        }
        ArrayMap<String, Object> map2 = bundle.getMap();
        for (int i = 0; i < map2.size(); ++i) {
            BaseBundle.dumpStats(pw, map2.keyAt(i), map2.valueAt(i));
        }
        pw.decreaseIndent();
    }

    static class NoImagePreloadHolder {
        public static final Parcel EMPTY_PARCEL = Parcel.obtain();

        NoImagePreloadHolder() {
        }
    }
}

