/*
 * Decompiled with CFR 0.152.
 */
package android.nfc;

import android.app.Activity;
import android.app.Application;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.ContentProvider;
import android.net.Uri;
import android.nfc.BeamShareData;
import android.nfc.IAppCallback;
import android.nfc.NdefMessage;
import android.nfc.NfcAdapter;
import android.nfc.NfcEvent;
import android.nfc.Tag;
import android.os.Binder;
import android.os.Bundle;
import android.os.RemoteException;
import android.util.Log;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class NfcActivityManager
extends IAppCallback.Stub
implements Application.ActivityLifecycleCallbacks {
    static final String TAG = "NFC";
    static final Boolean DBG = false;
    @UnsupportedAppUsage
    final NfcAdapter mAdapter;
    final List<NfcApplicationState> mApps;
    final List<NfcActivityState> mActivities;

    NfcApplicationState findAppState(Application app) {
        for (NfcApplicationState appState : this.mApps) {
            if (appState.app != app) continue;
            return appState;
        }
        return null;
    }

    void registerApplication(Application app) {
        NfcApplicationState appState = this.findAppState(app);
        if (appState == null) {
            appState = new NfcApplicationState(app);
            this.mApps.add(appState);
        }
        appState.register();
    }

    void unregisterApplication(Application app) {
        NfcApplicationState appState = this.findAppState(app);
        if (appState == null) {
            Log.e(TAG, "app was not registered " + app);
            return;
        }
        appState.unregister();
    }

    synchronized NfcActivityState findActivityState(Activity activity) {
        for (NfcActivityState state : this.mActivities) {
            if (state.activity != activity) continue;
            return state;
        }
        return null;
    }

    synchronized NfcActivityState getActivityState(Activity activity) {
        NfcActivityState state = this.findActivityState(activity);
        if (state == null) {
            state = new NfcActivityState(activity);
            this.mActivities.add(state);
        }
        return state;
    }

    synchronized NfcActivityState findResumedActivityState() {
        for (NfcActivityState state : this.mActivities) {
            if (!state.resumed) continue;
            return state;
        }
        return null;
    }

    synchronized void destroyActivityState(Activity activity) {
        NfcActivityState activityState = this.findActivityState(activity);
        if (activityState != null) {
            activityState.destroy();
            this.mActivities.remove(activityState);
        }
    }

    public NfcActivityManager(NfcAdapter adapter) {
        this.mAdapter = adapter;
        this.mActivities = new LinkedList<NfcActivityState>();
        this.mApps = new ArrayList<NfcApplicationState>(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableReaderMode(Activity activity, NfcAdapter.ReaderCallback callback2, int flags, Bundle extras) {
        boolean isResumed;
        Binder token;
        NfcActivityManager nfcActivityManager = this;
        synchronized (nfcActivityManager) {
            NfcActivityState state = this.getActivityState(activity);
            state.readerCallback = callback2;
            state.readerModeFlags = flags;
            state.readerModeExtras = extras;
            token = state.token;
            isResumed = state.resumed;
        }
        if (isResumed) {
            this.setReaderMode(token, flags, extras);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disableReaderMode(Activity activity) {
        boolean isResumed;
        Binder token;
        NfcActivityManager nfcActivityManager = this;
        synchronized (nfcActivityManager) {
            NfcActivityState state = this.getActivityState(activity);
            state.readerCallback = null;
            state.readerModeFlags = 0;
            state.readerModeExtras = null;
            token = state.token;
            isResumed = state.resumed;
        }
        if (isResumed) {
            this.setReaderMode(token, 0, null);
        }
    }

    public void setReaderMode(Binder token, int flags, Bundle extras) {
        if (DBG.booleanValue()) {
            Log.d(TAG, "Setting reader mode");
        }
        try {
            NfcAdapter.sService.setReaderMode(token, this, flags, extras);
        }
        catch (RemoteException e) {
            this.mAdapter.attemptDeadServiceRecovery(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNdefPushContentUri(Activity activity, Uri[] uris) {
        boolean isResumed;
        NfcActivityManager nfcActivityManager = this;
        synchronized (nfcActivityManager) {
            NfcActivityState state = this.getActivityState(activity);
            state.uris = uris;
            isResumed = state.resumed;
        }
        if (isResumed) {
            this.requestNfcServiceCallback();
        } else {
            this.verifyNfcPermission();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNdefPushContentUriCallback(Activity activity, NfcAdapter.CreateBeamUrisCallback callback2) {
        boolean isResumed;
        NfcActivityManager nfcActivityManager = this;
        synchronized (nfcActivityManager) {
            NfcActivityState state = this.getActivityState(activity);
            state.uriCallback = callback2;
            isResumed = state.resumed;
        }
        if (isResumed) {
            this.requestNfcServiceCallback();
        } else {
            this.verifyNfcPermission();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNdefPushMessage(Activity activity, NdefMessage message, int flags) {
        boolean isResumed;
        NfcActivityManager nfcActivityManager = this;
        synchronized (nfcActivityManager) {
            NfcActivityState state = this.getActivityState(activity);
            state.ndefMessage = message;
            state.flags = flags;
            isResumed = state.resumed;
        }
        if (isResumed) {
            this.requestNfcServiceCallback();
        } else {
            this.verifyNfcPermission();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNdefPushMessageCallback(Activity activity, NfcAdapter.CreateNdefMessageCallback callback2, int flags) {
        boolean isResumed;
        NfcActivityManager nfcActivityManager = this;
        synchronized (nfcActivityManager) {
            NfcActivityState state = this.getActivityState(activity);
            state.ndefMessageCallback = callback2;
            state.flags = flags;
            isResumed = state.resumed;
        }
        if (isResumed) {
            this.requestNfcServiceCallback();
        } else {
            this.verifyNfcPermission();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOnNdefPushCompleteCallback(Activity activity, NfcAdapter.OnNdefPushCompleteCallback callback2) {
        boolean isResumed;
        NfcActivityManager nfcActivityManager = this;
        synchronized (nfcActivityManager) {
            NfcActivityState state = this.getActivityState(activity);
            state.onNdefPushCompleteCallback = callback2;
            isResumed = state.resumed;
        }
        if (isResumed) {
            this.requestNfcServiceCallback();
        } else {
            this.verifyNfcPermission();
        }
    }

    void requestNfcServiceCallback() {
        try {
            NfcAdapter.sService.setAppCallback(this);
        }
        catch (RemoteException e) {
            this.mAdapter.attemptDeadServiceRecovery(e);
        }
    }

    void verifyNfcPermission() {
        try {
            NfcAdapter.sService.verifyNfcPermission();
        }
        catch (RemoteException e) {
            this.mAdapter.attemptDeadServiceRecovery(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BeamShareData createBeamShareData(byte peerLlcpVersion) {
        Activity activity;
        int flags;
        Uri[] uris;
        NdefMessage message;
        NfcAdapter.CreateBeamUrisCallback urisCallback;
        NfcAdapter.CreateNdefMessageCallback ndefCallback;
        NfcEvent event = new NfcEvent(this.mAdapter, peerLlcpVersion);
        NfcActivityManager nfcActivityManager = this;
        synchronized (nfcActivityManager) {
            NfcActivityState state = this.findResumedActivityState();
            if (state == null) {
                return null;
            }
            ndefCallback = state.ndefMessageCallback;
            urisCallback = state.uriCallback;
            message = state.ndefMessage;
            uris = state.uris;
            flags = state.flags;
            activity = state.activity;
        }
        long ident = Binder.clearCallingIdentity();
        try {
            if (ndefCallback != null) {
                message = ndefCallback.createNdefMessage(event);
            }
            if (urisCallback != null && (uris = urisCallback.createBeamUris(event)) != null) {
                ArrayList<Uri> validUris = new ArrayList<Uri>();
                Uri[] uriArray = uris;
                int n = uriArray.length;
                for (int i = 0; i < n; ++i) {
                    Uri uri = uriArray[i];
                    if (uri == null) {
                        Log.e(TAG, "Uri not allowed to be null.");
                        continue;
                    }
                    String scheme = uri.getScheme();
                    if (scheme == null || !scheme.equalsIgnoreCase("file") && !scheme.equalsIgnoreCase("content")) {
                        Log.e(TAG, "Uri needs to have either scheme file or scheme content");
                        continue;
                    }
                    uri = ContentProvider.maybeAddUserId(uri, activity.getUserId());
                    validUris.add(uri);
                }
                uris = validUris.toArray(new Uri[validUris.size()]);
            }
            if (uris != null && uris.length > 0) {
                for (Uri uri : uris) {
                    activity.grantUriPermission("com.android.nfc", uri, 1);
                }
            }
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
        return new BeamShareData(message, uris, activity.getUser(), flags);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onNdefPushComplete(byte peerLlcpVersion) {
        NfcAdapter.OnNdefPushCompleteCallback callback2;
        NfcActivityManager nfcActivityManager = this;
        synchronized (nfcActivityManager) {
            NfcActivityState state = this.findResumedActivityState();
            if (state == null) {
                return;
            }
            callback2 = state.onNdefPushCompleteCallback;
        }
        NfcEvent event = new NfcEvent(this.mAdapter, peerLlcpVersion);
        if (callback2 != null) {
            callback2.onNdefPushComplete(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onTagDiscovered(Tag tag) throws RemoteException {
        NfcAdapter.ReaderCallback callback2;
        NfcActivityManager nfcActivityManager = this;
        synchronized (nfcActivityManager) {
            NfcActivityState state = this.findResumedActivityState();
            if (state == null) {
                return;
            }
            callback2 = state.readerCallback;
        }
        if (callback2 != null) {
            callback2.onTagDiscovered(tag);
        }
    }

    @Override
    public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
    }

    @Override
    public void onActivityStarted(Activity activity) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onActivityResumed(Activity activity) {
        Binder token;
        int readerModeFlags = 0;
        Bundle readerModeExtras = null;
        NfcActivityManager nfcActivityManager = this;
        synchronized (nfcActivityManager) {
            NfcActivityState state = this.findActivityState(activity);
            if (DBG.booleanValue()) {
                Log.d(TAG, "onResume() for " + activity + " " + state);
            }
            if (state == null) {
                return;
            }
            state.resumed = true;
            token = state.token;
            readerModeFlags = state.readerModeFlags;
            readerModeExtras = state.readerModeExtras;
        }
        if (readerModeFlags != 0) {
            this.setReaderMode(token, readerModeFlags, readerModeExtras);
        }
        this.requestNfcServiceCallback();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onActivityPaused(Activity activity) {
        boolean readerModeFlagsSet;
        Binder token;
        NfcActivityManager nfcActivityManager = this;
        synchronized (nfcActivityManager) {
            NfcActivityState state = this.findActivityState(activity);
            if (DBG.booleanValue()) {
                Log.d(TAG, "onPause() for " + activity + " " + state);
            }
            if (state == null) {
                return;
            }
            state.resumed = false;
            token = state.token;
            readerModeFlagsSet = state.readerModeFlags != 0;
        }
        if (readerModeFlagsSet) {
            this.setReaderMode(token, 0, null);
        }
    }

    @Override
    public void onActivityStopped(Activity activity) {
    }

    @Override
    public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onActivityDestroyed(Activity activity) {
        NfcActivityManager nfcActivityManager = this;
        synchronized (nfcActivityManager) {
            NfcActivityState state = this.findActivityState(activity);
            if (DBG.booleanValue()) {
                Log.d(TAG, "onDestroy() for " + activity + " " + state);
            }
            if (state != null) {
                this.destroyActivityState(activity);
            }
        }
    }

    class NfcActivityState {
        boolean resumed = false;
        Activity activity;
        NdefMessage ndefMessage = null;
        NfcAdapter.CreateNdefMessageCallback ndefMessageCallback = null;
        NfcAdapter.OnNdefPushCompleteCallback onNdefPushCompleteCallback = null;
        NfcAdapter.CreateBeamUrisCallback uriCallback = null;
        Uri[] uris = null;
        int flags = 0;
        int readerModeFlags = 0;
        NfcAdapter.ReaderCallback readerCallback = null;
        Bundle readerModeExtras = null;
        Binder token;

        public NfcActivityState(Activity activity) {
            if (activity.getWindow().isDestroyed()) {
                throw new IllegalStateException("activity is already destroyed");
            }
            this.resumed = activity.isResumed();
            this.activity = activity;
            this.token = new Binder();
            NfcActivityManager.this.registerApplication(activity.getApplication());
        }

        public void destroy() {
            NfcActivityManager.this.unregisterApplication(this.activity.getApplication());
            this.resumed = false;
            this.activity = null;
            this.ndefMessage = null;
            this.ndefMessageCallback = null;
            this.onNdefPushCompleteCallback = null;
            this.uriCallback = null;
            this.uris = null;
            this.readerModeFlags = 0;
            this.token = null;
        }

        public String toString() {
            StringBuilder s = new StringBuilder("[").append(" ");
            s.append(this.ndefMessage).append(" ").append(this.ndefMessageCallback).append(" ");
            s.append(this.uriCallback).append(" ");
            if (this.uris != null) {
                for (Uri uri : this.uris) {
                    s.append(this.onNdefPushCompleteCallback).append(" ").append(uri).append("]");
                }
            }
            return s.toString();
        }
    }

    class NfcApplicationState {
        int refCount = 0;
        final Application app;

        public NfcApplicationState(Application app) {
            this.app = app;
        }

        public void register() {
            ++this.refCount;
            if (this.refCount == 1) {
                this.app.registerActivityLifecycleCallbacks(NfcActivityManager.this);
            }
        }

        public void unregister() {
            --this.refCount;
            if (this.refCount == 0) {
                this.app.unregisterActivityLifecycleCallbacks(NfcActivityManager.this);
            } else if (this.refCount < 0) {
                Log.e(NfcActivityManager.TAG, "-ve refcount for " + this.app);
            }
        }
    }
}

