/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi.util;

public class HexEncoding {
    private static final char[] LOWER_CASE_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final char[] UPPER_CASE_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    private HexEncoding() {
    }

    public static String encodeToString(byte b, boolean upperCase) {
        char[] digits = upperCase ? UPPER_CASE_DIGITS : LOWER_CASE_DIGITS;
        char[] buf = new char[]{digits[b >> 4 & 0xF], digits[b & 0xF]};
        return new String(buf, 0, 2);
    }

    public static char[] encode(byte[] data) {
        return HexEncoding.encode(data, 0, data.length, true);
    }

    public static char[] encode(byte[] data, boolean upperCase) {
        return HexEncoding.encode(data, 0, data.length, upperCase);
    }

    public static char[] encode(byte[] data, int offset2, int len) {
        return HexEncoding.encode(data, offset2, len, true);
    }

    private static char[] encode(byte[] data, int offset2, int len, boolean upperCase) {
        char[] digits = upperCase ? UPPER_CASE_DIGITS : LOWER_CASE_DIGITS;
        char[] result = new char[len * 2];
        for (int i = 0; i < len; ++i) {
            byte b = data[offset2 + i];
            int resultIndex = 2 * i;
            result[resultIndex] = digits[b >> 4 & 0xF];
            result[resultIndex + 1] = digits[b & 0xF];
        }
        return result;
    }

    public static String encodeToString(byte[] data) {
        return HexEncoding.encodeToString(data, true);
    }

    public static String encodeToString(byte[] data, boolean upperCase) {
        return new String(HexEncoding.encode(data, upperCase));
    }

    public static byte[] decode(String encoded) throws IllegalArgumentException {
        return HexEncoding.decode(encoded.toCharArray());
    }

    public static byte[] decode(String encoded, boolean allowSingleChar) throws IllegalArgumentException {
        return HexEncoding.decode(encoded.toCharArray(), allowSingleChar);
    }

    public static byte[] decode(char[] encoded) throws IllegalArgumentException {
        return HexEncoding.decode(encoded, false);
    }

    public static byte[] decode(char[] encoded, boolean allowSingleChar) throws IllegalArgumentException {
        int encodedLength = encoded.length;
        int resultLengthBytes = (encodedLength + 1) / 2;
        byte[] result = new byte[resultLengthBytes];
        int resultOffset = 0;
        int i = 0;
        if (allowSingleChar) {
            if (encodedLength % 2 != 0) {
                result[resultOffset++] = (byte)HexEncoding.toDigit(encoded, i);
                ++i;
            }
        } else if (encodedLength % 2 != 0) {
            throw new IllegalArgumentException("Invalid input length: " + encodedLength);
        }
        while (i < encodedLength) {
            result[resultOffset++] = (byte)(HexEncoding.toDigit(encoded, i) << 4 | HexEncoding.toDigit(encoded, i + 1));
            i += 2;
        }
        return result;
    }

    private static int toDigit(char[] str, int offset2) throws IllegalArgumentException {
        char pseudoCodePoint = str[offset2];
        if ('0' <= pseudoCodePoint && pseudoCodePoint <= '9') {
            return pseudoCodePoint - 48;
        }
        if ('a' <= pseudoCodePoint && pseudoCodePoint <= 'f') {
            return 10 + (pseudoCodePoint - 97);
        }
        if ('A' <= pseudoCodePoint && pseudoCodePoint <= 'F') {
            return 10 + (pseudoCodePoint - 65);
        }
        throw new IllegalArgumentException("Illegal char: " + str[offset2] + " at offset " + offset2);
    }
}

