/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi.nl80211;

import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.app.AlarmManager;
import android.content.Context;
import android.net.wifi.nl80211.ChannelSettings;
import android.net.wifi.nl80211.DeviceWiphyCapabilities;
import android.net.wifi.nl80211.HiddenNetwork;
import android.net.wifi.nl80211.IApInterface;
import android.net.wifi.nl80211.IApInterfaceEventCallback;
import android.net.wifi.nl80211.IClientInterface;
import android.net.wifi.nl80211.IPnoScanEvent;
import android.net.wifi.nl80211.IScanEvent;
import android.net.wifi.nl80211.ISendMgmtFrameEvent;
import android.net.wifi.nl80211.IWifiScannerImpl;
import android.net.wifi.nl80211.IWificond;
import android.net.wifi.nl80211.IWificondEventCallback;
import android.net.wifi.nl80211.NativeScanResult;
import android.net.wifi.nl80211.NativeWifiClient;
import android.net.wifi.nl80211.PnoSettings;
import android.net.wifi.nl80211.SingleScanSettings;
import android.os.Binder;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.util.Log;
import com.android.internal.annotations.VisibleForTesting;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;

@SystemApi
public class WifiNl80211Manager {
    private static final String TAG = "WifiNl80211Manager";
    private boolean mVerboseLoggingEnabled = false;
    private static final int SEND_MGMT_FRAME_TIMEOUT_MS = 1000;
    private static final String TIMEOUT_ALARM_TAG = "WifiNl80211Manager Send Management Frame Timeout";
    public static final int SCAN_TYPE_SINGLE_SCAN = 0;
    public static final int SCAN_TYPE_PNO_SCAN = 1;
    public static final String SCANNING_PARAM_ENABLE_6GHZ_RNR = "android.net.wifi.nl80211.SCANNING_PARAM_ENABLE_6GHZ_RNR";
    private AlarmManager mAlarmManager;
    private Handler mEventHandler;
    private IWificond mWificond;
    private WificondEventHandler mWificondEventHandler = new WificondEventHandler();
    private HashMap<String, IClientInterface> mClientInterfaces = new HashMap();
    private HashMap<String, IApInterface> mApInterfaces = new HashMap();
    private HashMap<String, IWifiScannerImpl> mWificondScanners = new HashMap();
    private HashMap<String, IScanEvent> mScanEventHandlers = new HashMap();
    private HashMap<String, IPnoScanEvent> mPnoScanEventHandlers = new HashMap();
    private HashMap<String, IApInterfaceEventCallback> mApInterfaceListeners = new HashMap();
    private Runnable mDeathEventHandler;
    private AtomicBoolean mSendMgmtFrameInProgress = new AtomicBoolean(false);
    public static final int SEND_MGMT_FRAME_ERROR_UNKNOWN = 1;
    public static final int SEND_MGMT_FRAME_ERROR_MCS_UNSUPPORTED = 2;
    public static final int SEND_MGMT_FRAME_ERROR_NO_ACK = 3;
    public static final int SEND_MGMT_FRAME_ERROR_TIMEOUT = 4;
    public static final int SEND_MGMT_FRAME_ERROR_ALREADY_STARTED = 5;

    public WifiNl80211Manager(Context context) {
        this.mAlarmManager = context.getSystemService(AlarmManager.class);
        this.mEventHandler = new Handler(context.getMainLooper());
    }

    @VisibleForTesting
    public WifiNl80211Manager(Context context, IWificond wificond) {
        this(context);
        this.mWificond = wificond;
    }

    @VisibleForTesting
    public WificondEventHandler getWificondEventHandler() {
        return this.mWificondEventHandler;
    }

    @VisibleForTesting
    public void binderDied() {
        this.mEventHandler.post(() -> {
            Log.e(TAG, "Wificond died!");
            this.clearState();
            this.mWificond = null;
            if (this.mDeathEventHandler != null) {
                this.mDeathEventHandler.run();
            }
        });
    }

    public void enableVerboseLogging(boolean enable) {
        this.mVerboseLoggingEnabled = enable;
    }

    public void setOnServiceDeadCallback(Runnable deathEventHandler) {
        if (this.mDeathEventHandler != null) {
            Log.e(TAG, "Death handler already present");
        }
        this.mDeathEventHandler = deathEventHandler;
    }

    private boolean retrieveWificondAndRegisterForDeath() {
        if (this.mWificond != null) {
            if (this.mVerboseLoggingEnabled) {
                Log.d(TAG, "Wificond handle already retrieved");
            }
            return true;
        }
        IBinder binder = ServiceManager.getService("wifinl80211");
        this.mWificond = IWificond.Stub.asInterface(binder);
        if (this.mWificond == null) {
            Log.e(TAG, "Failed to get reference to wificond");
            return false;
        }
        try {
            this.mWificond.asBinder().linkToDeath(() -> this.binderDied(), 0);
            this.mWificond.registerWificondEventCallback(this.mWificondEventHandler);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Failed to register death notification for wificond");
            return false;
        }
        return true;
    }

    public boolean setupInterfaceForClientMode(String ifaceName, Executor executor, ScanEventCallback scanCallback, ScanEventCallback pnoScanCallback) {
        Log.d(TAG, "Setting up interface for client mode: " + ifaceName);
        if (!this.retrieveWificondAndRegisterForDeath()) {
            return false;
        }
        if (scanCallback == null || pnoScanCallback == null || executor == null) {
            Log.e(TAG, "setupInterfaceForClientMode invoked with null callbacks");
            return false;
        }
        IClientInterface clientInterface = null;
        try {
            clientInterface = this.mWificond.createClientInterface(ifaceName);
        }
        catch (RemoteException e1) {
            Log.e(TAG, "Failed to get IClientInterface due to remote exception");
            return false;
        }
        if (clientInterface == null) {
            Log.e(TAG, "Could not get IClientInterface instance from wificond");
            return false;
        }
        Binder.allowBlocking(clientInterface.asBinder());
        this.mClientInterfaces.put(ifaceName, clientInterface);
        try {
            IWifiScannerImpl wificondScanner = clientInterface.getWifiScannerImpl();
            if (wificondScanner == null) {
                Log.e(TAG, "Failed to get WificondScannerImpl");
                return false;
            }
            this.mWificondScanners.put(ifaceName, wificondScanner);
            Binder.allowBlocking(wificondScanner.asBinder());
            ScanEventHandler scanEventHandler = new ScanEventHandler(executor, scanCallback);
            this.mScanEventHandlers.put(ifaceName, scanEventHandler);
            wificondScanner.subscribeScanEvents(scanEventHandler);
            PnoScanEventHandler pnoScanEventHandler = new PnoScanEventHandler(executor, pnoScanCallback);
            this.mPnoScanEventHandlers.put(ifaceName, pnoScanEventHandler);
            wificondScanner.subscribePnoScanEvents(pnoScanEventHandler);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Failed to refresh wificond scanner due to remote exception");
        }
        return true;
    }

    public boolean tearDownClientInterface(String ifaceName) {
        boolean success;
        if (this.getClientInterface(ifaceName) == null) {
            Log.e(TAG, "No valid wificond client interface handler for iface=" + ifaceName);
            return false;
        }
        try {
            IWifiScannerImpl scannerImpl = this.mWificondScanners.get(ifaceName);
            if (scannerImpl != null) {
                scannerImpl.unsubscribeScanEvents();
                scannerImpl.unsubscribePnoScanEvents();
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Failed to unsubscribe wificond scanner due to remote exception");
            return false;
        }
        if (this.mWificond == null) {
            Log.e(TAG, "tearDownClientInterface: mWificond binder is null! Did wificond die?");
            return false;
        }
        try {
            success = this.mWificond.tearDownClientInterface(ifaceName);
        }
        catch (RemoteException e1) {
            Log.e(TAG, "Failed to teardown client interface due to remote exception");
            return false;
        }
        if (!success) {
            Log.e(TAG, "Failed to teardown client interface");
            return false;
        }
        this.mClientInterfaces.remove(ifaceName);
        this.mWificondScanners.remove(ifaceName);
        this.mScanEventHandlers.remove(ifaceName);
        this.mPnoScanEventHandlers.remove(ifaceName);
        return true;
    }

    public boolean setupInterfaceForSoftApMode(String ifaceName) {
        Log.d(TAG, "Setting up interface for soft ap mode for iface=" + ifaceName);
        if (!this.retrieveWificondAndRegisterForDeath()) {
            return false;
        }
        IApInterface apInterface = null;
        try {
            apInterface = this.mWificond.createApInterface(ifaceName);
        }
        catch (RemoteException e1) {
            Log.e(TAG, "Failed to get IApInterface due to remote exception");
            return false;
        }
        if (apInterface == null) {
            Log.e(TAG, "Could not get IApInterface instance from wificond");
            return false;
        }
        Binder.allowBlocking(apInterface.asBinder());
        this.mApInterfaces.put(ifaceName, apInterface);
        return true;
    }

    public boolean tearDownSoftApInterface(String ifaceName) {
        boolean success;
        if (this.getApInterface(ifaceName) == null) {
            Log.e(TAG, "No valid wificond ap interface handler for iface=" + ifaceName);
            return false;
        }
        if (this.mWificond == null) {
            Log.e(TAG, "tearDownSoftApInterface: mWificond binder is null! Did wificond die?");
            return false;
        }
        try {
            success = this.mWificond.tearDownApInterface(ifaceName);
        }
        catch (RemoteException e1) {
            Log.e(TAG, "Failed to teardown AP interface due to remote exception");
            return false;
        }
        if (!success) {
            Log.e(TAG, "Failed to teardown AP interface");
            return false;
        }
        this.mApInterfaces.remove(ifaceName);
        this.mApInterfaceListeners.remove(ifaceName);
        return true;
    }

    public boolean tearDownInterfaces() {
        Log.d(TAG, "tearing down interfaces in wificond");
        if (!this.retrieveWificondAndRegisterForDeath()) {
            return false;
        }
        try {
            for (Map.Entry<String, IWifiScannerImpl> entry : this.mWificondScanners.entrySet()) {
                entry.getValue().unsubscribeScanEvents();
                entry.getValue().unsubscribePnoScanEvents();
            }
            this.mWificond.tearDownInterfaces();
            this.clearState();
            return true;
        }
        catch (RemoteException e) {
            Log.e(TAG, "Failed to tear down interfaces due to remote exception");
            return false;
        }
    }

    private IClientInterface getClientInterface(String ifaceName) {
        return this.mClientInterfaces.get(ifaceName);
    }

    public SignalPollResult signalPoll(String ifaceName) {
        int[] resultArray;
        IClientInterface iface = this.getClientInterface(ifaceName);
        if (iface == null) {
            Log.e(TAG, "No valid wificond client interface handler for iface=" + ifaceName);
            return null;
        }
        try {
            resultArray = iface.signalPoll();
            if (resultArray == null || resultArray.length != 4) {
                Log.e(TAG, "Invalid signal poll result from wificond");
                return null;
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Failed to do signal polling due to remote exception");
            return null;
        }
        return new SignalPollResult(resultArray[0], resultArray[1], resultArray[3], resultArray[2]);
    }

    public TxPacketCounters getTxPacketCounters(String ifaceName) {
        int[] resultArray;
        IClientInterface iface = this.getClientInterface(ifaceName);
        if (iface == null) {
            Log.e(TAG, "No valid wificond client interface handler for iface=" + ifaceName);
            return null;
        }
        try {
            resultArray = iface.getPacketCounters();
            if (resultArray == null || resultArray.length != 2) {
                Log.e(TAG, "Invalid signal poll result from wificond");
                return null;
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Failed to do signal polling due to remote exception");
            return null;
        }
        return new TxPacketCounters(resultArray[0], resultArray[1]);
    }

    private IWifiScannerImpl getScannerImpl(String ifaceName) {
        return this.mWificondScanners.get(ifaceName);
    }

    public List<NativeScanResult> getScanResults(String ifaceName, int scanType) {
        IWifiScannerImpl scannerImpl = this.getScannerImpl(ifaceName);
        if (scannerImpl == null) {
            Log.e(TAG, "No valid wificond scanner interface handler for iface=" + ifaceName);
            return new ArrayList<NativeScanResult>();
        }
        List<NativeScanResult> results = null;
        try {
            results = scanType == 0 ? Arrays.asList(scannerImpl.getScanResults()) : Arrays.asList(scannerImpl.getPnoScanResults());
        }
        catch (RemoteException e1) {
            Log.e(TAG, "Failed to create ScanDetail ArrayList");
        }
        if (results == null) {
            results = new ArrayList<NativeScanResult>();
        }
        if (this.mVerboseLoggingEnabled) {
            Log.d(TAG, "get " + results.size() + " scan results from wificond");
        }
        return results;
    }

    private static int getScanType(int scanType) {
        switch (scanType) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
        }
        throw new IllegalArgumentException("Invalid scan type " + scanType);
    }

    @Deprecated
    public boolean startScan(String ifaceName, int scanType, Set<Integer> freqs, List<byte[]> hiddenNetworkSSIDs) {
        return this.startScan(ifaceName, scanType, freqs, hiddenNetworkSSIDs, null);
    }

    public boolean startScan(String ifaceName, int scanType, @SuppressLint(value={"NullableCollection"}) Set<Integer> freqs, @SuppressLint(value={"NullableCollection"}) List<byte[]> hiddenNetworkSSIDs, @SuppressLint(value={"NullableCollection"}) Bundle extraScanningParams) {
        IWifiScannerImpl scannerImpl = this.getScannerImpl(ifaceName);
        if (scannerImpl == null) {
            Log.e(TAG, "No valid wificond scanner interface handler for iface=" + ifaceName);
            return false;
        }
        SingleScanSettings settings = new SingleScanSettings();
        try {
            settings.scanType = WifiNl80211Manager.getScanType(scanType);
        }
        catch (IllegalArgumentException e) {
            Log.e(TAG, "Invalid scan type ", e);
            return false;
        }
        settings.channelSettings = new ArrayList();
        settings.hiddenNetworks = new ArrayList();
        if (extraScanningParams != null) {
            settings.enable6GhzRnr = extraScanningParams.getBoolean(SCANNING_PARAM_ENABLE_6GHZ_RNR);
        }
        if (freqs != null) {
            for (Integer freq : freqs) {
                ChannelSettings channel = new ChannelSettings();
                channel.frequency = freq;
                settings.channelSettings.add(channel);
            }
        }
        if (hiddenNetworkSSIDs != null) {
            for (byte[] ssid : hiddenNetworkSSIDs) {
                HiddenNetwork network = new HiddenNetwork();
                network.ssid = ssid;
                if (settings.hiddenNetworks.contains(network)) continue;
                settings.hiddenNetworks.add(network);
            }
        }
        try {
            return scannerImpl.scan(settings);
        }
        catch (RemoteException e1) {
            Log.e(TAG, "Failed to request scan due to remote exception");
            return false;
        }
    }

    public boolean startPnoScan(String ifaceName, PnoSettings pnoSettings, Executor executor, PnoScanRequestCallback callback2) {
        IWifiScannerImpl scannerImpl = this.getScannerImpl(ifaceName);
        if (scannerImpl == null) {
            Log.e(TAG, "No valid wificond scanner interface handler for iface=" + ifaceName);
            return false;
        }
        if (callback2 == null || executor == null) {
            Log.e(TAG, "startPnoScan called with a null callback");
            return false;
        }
        try {
            boolean success = scannerImpl.startPnoScan(pnoSettings);
            if (success) {
                executor.execute(callback2::onPnoRequestSucceeded);
            } else {
                executor.execute(callback2::onPnoRequestFailed);
            }
            return success;
        }
        catch (RemoteException e1) {
            Log.e(TAG, "Failed to start pno scan due to remote exception");
            return false;
        }
    }

    public boolean stopPnoScan(String ifaceName) {
        IWifiScannerImpl scannerImpl = this.getScannerImpl(ifaceName);
        if (scannerImpl == null) {
            Log.e(TAG, "No valid wificond scanner interface handler for iface=" + ifaceName);
            return false;
        }
        try {
            return scannerImpl.stopPnoScan();
        }
        catch (RemoteException e1) {
            Log.e(TAG, "Failed to stop pno scan due to remote exception");
            return false;
        }
    }

    public void abortScan(String ifaceName) {
        IWifiScannerImpl scannerImpl = this.getScannerImpl(ifaceName);
        if (scannerImpl == null) {
            Log.e(TAG, "No valid wificond scanner interface handler for iface=" + ifaceName);
            return;
        }
        try {
            scannerImpl.abortScan();
        }
        catch (RemoteException e1) {
            Log.e(TAG, "Failed to request abortScan due to remote exception");
        }
    }

    public int[] getChannelsMhzForBand(int band) {
        if (this.mWificond == null) {
            Log.e(TAG, "getChannelsMhzForBand: mWificond binder is null! Did wificond die?");
            return new int[0];
        }
        int[] result = null;
        try {
            switch (band) {
                case 1: {
                    result = this.mWificond.getAvailable2gChannels();
                    break;
                }
                case 2: {
                    result = this.mWificond.getAvailable5gNonDFSChannels();
                    break;
                }
                case 4: {
                    result = this.mWificond.getAvailableDFSChannels();
                    break;
                }
                case 8: {
                    result = this.mWificond.getAvailable6gChannels();
                    break;
                }
                case 16: {
                    result = this.mWificond.getAvailable60gChannels();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unsupported band " + band);
                }
            }
        }
        catch (RemoteException e1) {
            Log.e(TAG, "Failed to request getChannelsForBand due to remote exception");
        }
        if (result == null) {
            result = new int[]{};
        }
        return result;
    }

    private IApInterface getApInterface(String ifaceName) {
        return this.mApInterfaces.get(ifaceName);
    }

    public DeviceWiphyCapabilities getDeviceWiphyCapabilities(String ifaceName) {
        if (this.mWificond == null) {
            Log.e(TAG, "getDeviceWiphyCapabilities: mWificond binder is null! Did wificond die?");
            return null;
        }
        try {
            return this.mWificond.getDeviceWiphyCapabilities(ifaceName);
        }
        catch (RemoteException e) {
            return null;
        }
    }

    public boolean registerCountryCodeChangedListener(Executor executor, CountryCodeChangedListener listener2) {
        if (!this.retrieveWificondAndRegisterForDeath()) {
            return false;
        }
        Log.d(TAG, "registerCountryCodeEventListener called");
        this.mWificondEventHandler.registerCountryCodeChangedListener(executor, listener2);
        return true;
    }

    public void unregisterCountryCodeChangedListener(CountryCodeChangedListener listener2) {
        Log.d(TAG, "unregisterCountryCodeEventListener called");
        this.mWificondEventHandler.unregisterCountryCodeChangedListener(listener2);
    }

    @Deprecated
    public boolean registerApCallback(String ifaceName, Executor executor, SoftApCallback callback2) {
        IApInterface iface = this.getApInterface(ifaceName);
        if (iface == null) {
            Log.e(TAG, "No valid ap interface handler for iface=" + ifaceName);
            return false;
        }
        if (callback2 == null || executor == null) {
            Log.e(TAG, "registerApCallback called with a null callback");
            return false;
        }
        try {
            ApInterfaceEventCallback wificondCallback = new ApInterfaceEventCallback(executor, callback2);
            this.mApInterfaceListeners.put(ifaceName, wificondCallback);
            boolean success = iface.registerCallback(wificondCallback);
            if (!success) {
                Log.e(TAG, "Failed to register ap callback.");
                return false;
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Exception in registering AP callback: " + e);
            return false;
        }
        return true;
    }

    public void sendMgmtFrame(String ifaceName, byte[] frame, int mcs, Executor executor, SendMgmtFrameCallback callback2) {
        if (callback2 == null || executor == null) {
            Log.e(TAG, "callback cannot be null!");
            return;
        }
        if (frame == null) {
            Log.e(TAG, "frame cannot be null!");
            executor.execute(() -> callback2.onFailure(1));
            return;
        }
        IClientInterface clientInterface = this.getClientInterface(ifaceName);
        if (clientInterface == null) {
            Log.e(TAG, "No valid wificond client interface handler for iface=" + ifaceName);
            executor.execute(() -> callback2.onFailure(1));
            return;
        }
        if (!this.mSendMgmtFrameInProgress.compareAndSet(false, true)) {
            Log.e(TAG, "An existing management frame transmission is in progress!");
            executor.execute(() -> callback2.onFailure(5));
            return;
        }
        SendMgmtFrameEvent sendMgmtFrameEvent = new SendMgmtFrameEvent(executor, callback2);
        try {
            clientInterface.SendMgmtFrame(frame, sendMgmtFrameEvent, mcs);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Exception while starting link probe: " + e);
            sendMgmtFrameEvent.OnFailure(1);
        }
    }

    private void clearState() {
        this.mClientInterfaces.clear();
        this.mWificondScanners.clear();
        this.mPnoScanEventHandlers.clear();
        this.mScanEventHandlers.clear();
        this.mApInterfaces.clear();
        this.mApInterfaceListeners.clear();
        this.mSendMgmtFrameInProgress.set(false);
    }

    public static OemSecurityType parseOemSecurityTypeElement(int id2, int idExt, byte[] bytes) {
        return null;
    }

    public static class OemSecurityType {
        public final int protocol;
        public final List<Integer> keyManagement;
        public final List<Integer> pairwiseCipher;
        public final int groupCipher;

        public OemSecurityType(int protocol, List<Integer> keyManagement, List<Integer> pairwiseCipher, int groupCipher) {
            this.protocol = protocol;
            this.keyManagement = keyManagement != null ? keyManagement : new ArrayList();
            this.pairwiseCipher = pairwiseCipher != null ? pairwiseCipher : new ArrayList();
            this.groupCipher = groupCipher;
        }
    }

    private class SendMgmtFrameEvent
    extends ISendMgmtFrameEvent.Stub {
        private Executor mExecutor;
        private SendMgmtFrameCallback mCallback;
        private AlarmManager.OnAlarmListener mTimeoutCallback;
        private boolean mWasCalled;

        private void runIfFirstCall(Runnable r) {
            if (this.mWasCalled) {
                return;
            }
            this.mWasCalled = true;
            WifiNl80211Manager.this.mSendMgmtFrameInProgress.set(false);
            r.run();
        }

        SendMgmtFrameEvent(Executor executor, SendMgmtFrameCallback callback2) {
            this.mExecutor = executor;
            this.mCallback = callback2;
            this.mTimeoutCallback = () -> this.runIfFirstCall(() -> {
                if (WifiNl80211Manager.this.mVerboseLoggingEnabled) {
                    Log.e(WifiNl80211Manager.TAG, "Timed out waiting for ACK");
                }
                long token = Binder.clearCallingIdentity();
                try {
                    this.mExecutor.execute(() -> this.mCallback.onFailure(4));
                }
                finally {
                    Binder.restoreCallingIdentity(token);
                }
            });
            this.mWasCalled = false;
            WifiNl80211Manager.this.mAlarmManager.set(2, SystemClock.elapsedRealtime() + 1000L, WifiNl80211Manager.TIMEOUT_ALARM_TAG, this.mTimeoutCallback, WifiNl80211Manager.this.mEventHandler);
        }

        @Override
        public void OnAck(int elapsedTimeMs) {
            WifiNl80211Manager.this.mEventHandler.post(() -> this.runIfFirstCall(() -> {
                WifiNl80211Manager.this.mAlarmManager.cancel(this.mTimeoutCallback);
                long token = Binder.clearCallingIdentity();
                try {
                    this.mExecutor.execute(() -> this.mCallback.onAck(elapsedTimeMs));
                }
                finally {
                    Binder.restoreCallingIdentity(token);
                }
            }));
        }

        @Override
        public void OnFailure(int reason) {
            WifiNl80211Manager.this.mEventHandler.post(() -> this.runIfFirstCall(() -> {
                WifiNl80211Manager.this.mAlarmManager.cancel(this.mTimeoutCallback);
                long token = Binder.clearCallingIdentity();
                try {
                    this.mExecutor.execute(() -> this.mCallback.onFailure(reason));
                }
                finally {
                    Binder.restoreCallingIdentity(token);
                }
            }));
        }
    }

    private class ApInterfaceEventCallback
    extends IApInterfaceEventCallback.Stub {
        private Executor mExecutor;
        private SoftApCallback mSoftApListener;

        ApInterfaceEventCallback(Executor executor, SoftApCallback listener2) {
            this.mExecutor = executor;
            this.mSoftApListener = listener2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onConnectedClientsChanged(NativeWifiClient client, boolean isConnected) {
            if (WifiNl80211Manager.this.mVerboseLoggingEnabled) {
                Log.d(WifiNl80211Manager.TAG, "onConnectedClientsChanged called with " + client.getMacAddress() + " isConnected: " + isConnected);
            }
            long token = Binder.clearCallingIdentity();
            try {
                this.mExecutor.execute(() -> this.mSoftApListener.onConnectedClientsChanged(client, isConnected));
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onSoftApChannelSwitched(int frequency, int bandwidth) {
            long token = Binder.clearCallingIdentity();
            try {
                this.mExecutor.execute(() -> this.mSoftApListener.onSoftApChannelSwitched(frequency, this.toFrameworkBandwidth(bandwidth)));
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        private int toFrameworkBandwidth(int bandwidth) {
            switch (bandwidth) {
                case 0: {
                    return 0;
                }
                case 1: {
                    return 1;
                }
                case 2: {
                    return 2;
                }
                case 3: {
                    return 3;
                }
                case 4: {
                    return 4;
                }
                case 5: {
                    return 5;
                }
                case 6: {
                    return 6;
                }
            }
            return 0;
        }
    }

    private class PnoScanEventHandler
    extends IPnoScanEvent.Stub {
        private Executor mExecutor;
        private ScanEventCallback mCallback;

        PnoScanEventHandler(Executor executor, ScanEventCallback callback2) {
            this.mExecutor = executor;
            this.mCallback = callback2;
        }

        @Override
        public void OnPnoNetworkFound() {
            Log.d(WifiNl80211Manager.TAG, "Pno scan result event");
            long token = Binder.clearCallingIdentity();
            try {
                this.mExecutor.execute(() -> this.mCallback.onScanResultReady());
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        @Override
        public void OnPnoScanFailed() {
            Log.d(WifiNl80211Manager.TAG, "Pno Scan failed event");
            long token = Binder.clearCallingIdentity();
            try {
                this.mExecutor.execute(() -> this.mCallback.onScanFailed());
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SendMgmtFrameError {
    }

    public static interface SendMgmtFrameCallback {
        public void onAck(int var1);

        public void onFailure(int var1);
    }

    @Deprecated
    public static interface SoftApCallback {
        public void onFailure();

        public void onConnectedClientsChanged(NativeWifiClient var1, boolean var2);

        public void onSoftApChannelSwitched(int var1, int var2);
    }

    public static class TxPacketCounters {
        public final int txPacketSucceeded;
        public final int txPacketFailed;

        public TxPacketCounters(int txPacketSucceeded, int txPacketFailed) {
            this.txPacketSucceeded = txPacketSucceeded;
            this.txPacketFailed = txPacketFailed;
        }
    }

    public static class SignalPollResult {
        public final int currentRssiDbm;
        public final int txBitrateMbps;
        public final int rxBitrateMbps;
        public final int associationFrequencyMHz;

        public SignalPollResult(int currentRssiDbm, int txBitrateMbps, int rxBitrateMbps, int associationFrequencyMHz) {
            this.currentRssiDbm = currentRssiDbm;
            this.txBitrateMbps = txBitrateMbps;
            this.rxBitrateMbps = rxBitrateMbps;
            this.associationFrequencyMHz = associationFrequencyMHz;
        }
    }

    private class ScanEventHandler
    extends IScanEvent.Stub {
        private Executor mExecutor;
        private ScanEventCallback mCallback;

        ScanEventHandler(Executor executor, ScanEventCallback callback2) {
            this.mExecutor = executor;
            this.mCallback = callback2;
        }

        @Override
        public void OnScanResultReady() {
            Log.d(WifiNl80211Manager.TAG, "Scan result ready event");
            long token = Binder.clearCallingIdentity();
            try {
                this.mExecutor.execute(() -> this.mCallback.onScanResultReady());
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        @Override
        public void OnScanFailed() {
            Log.d(WifiNl80211Manager.TAG, "Scan failed event");
            long token = Binder.clearCallingIdentity();
            try {
                this.mExecutor.execute(() -> this.mCallback.onScanFailed());
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }
    }

    @VisibleForTesting
    public class WificondEventHandler
    extends IWificondEventCallback.Stub {
        private Map<CountryCodeChangedListener, Executor> mCountryCodeChangedListenerHolder = new HashMap<CountryCodeChangedListener, Executor>();

        public void registerCountryCodeChangedListener(Executor executor, CountryCodeChangedListener listener2) {
            this.mCountryCodeChangedListenerHolder.put(listener2, executor);
        }

        public void unregisterCountryCodeChangedListener(CountryCodeChangedListener listener2) {
            this.mCountryCodeChangedListenerHolder.remove(listener2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void OnRegDomainChanged(String countryCode) {
            Log.d(WifiNl80211Manager.TAG, "OnRegDomainChanged " + countryCode);
            long token = Binder.clearCallingIdentity();
            try {
                this.mCountryCodeChangedListenerHolder.forEach((listener2, executor) -> executor.execute(() -> listener2.onCountryCodeChanged(countryCode)));
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }
    }

    public static interface PnoScanRequestCallback {
        public void onPnoRequestSucceeded();

        public void onPnoRequestFailed();
    }

    public static interface ScanEventCallback {
        public void onScanResultReady();

        public void onScanFailed();
    }

    public static interface CountryCodeChangedListener {
        public void onCountryCodeChanged(String var1);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ScanResultType {
    }
}

