/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi.nl80211;

import android.net.wifi.nl80211.ISendMgmtFrameEvent;
import android.net.wifi.nl80211.IWifiScannerImpl;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface IClientInterface
extends IInterface {
    public static final String DESCRIPTOR = "android.net.wifi.nl80211.IClientInterface";

    public int[] getPacketCounters() throws RemoteException;

    public int[] signalPoll() throws RemoteException;

    public byte[] getMacAddress() throws RemoteException;

    public String getInterfaceName() throws RemoteException;

    public IWifiScannerImpl getWifiScannerImpl() throws RemoteException;

    public void SendMgmtFrame(byte[] var1, ISendMgmtFrameEvent var2, int var3) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IClientInterface {
        static final int TRANSACTION_getPacketCounters = 1;
        static final int TRANSACTION_signalPoll = 2;
        static final int TRANSACTION_getMacAddress = 3;
        static final int TRANSACTION_getInterfaceName = 4;
        static final int TRANSACTION_getWifiScannerImpl = 5;
        static final int TRANSACTION_SendMgmtFrame = 6;

        public Stub() {
            this.attachInterface(this, IClientInterface.DESCRIPTOR);
        }

        public static IClientInterface asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IClientInterface.DESCRIPTOR);
            if (iin != null && iin instanceof IClientInterface) {
                return (IClientInterface)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "getPacketCounters";
                }
                case 2: {
                    return "signalPoll";
                }
                case 3: {
                    return "getMacAddress";
                }
                case 4: {
                    return "getInterfaceName";
                }
                case 5: {
                    return "getWifiScannerImpl";
                }
                case 6: {
                    return "SendMgmtFrame";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IClientInterface.DESCRIPTOR;
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    data.enforceInterface(descriptor);
                    int[] _result = this.getPacketCounters();
                    reply.writeNoException();
                    reply.writeIntArray(_result);
                    return true;
                }
                case 2: {
                    data.enforceInterface(descriptor);
                    int[] _result = this.signalPoll();
                    reply.writeNoException();
                    reply.writeIntArray(_result);
                    return true;
                }
                case 3: {
                    data.enforceInterface(descriptor);
                    byte[] _result = this.getMacAddress();
                    reply.writeNoException();
                    reply.writeByteArray(_result);
                    return true;
                }
                case 4: {
                    data.enforceInterface(descriptor);
                    String _result = this.getInterfaceName();
                    reply.writeNoException();
                    reply.writeString(_result);
                    return true;
                }
                case 5: {
                    data.enforceInterface(descriptor);
                    IWifiScannerImpl _result = this.getWifiScannerImpl();
                    reply.writeNoException();
                    reply.writeStrongBinder(_result != null ? _result.asBinder() : null);
                    return true;
                }
                case 6: {
                    data.enforceInterface(descriptor);
                    byte[] _arg0 = data.createByteArray();
                    ISendMgmtFrameEvent _arg1 = ISendMgmtFrameEvent.Stub.asInterface(data.readStrongBinder());
                    int _arg2 = data.readInt();
                    this.SendMgmtFrame(_arg0, _arg1, _arg2);
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        public static boolean setDefaultImpl(IClientInterface impl) {
            if (Proxy.sDefaultImpl != null) {
                throw new IllegalStateException("setDefaultImpl() called twice");
            }
            if (impl != null) {
                Proxy.sDefaultImpl = impl;
                return true;
            }
            return false;
        }

        public static IClientInterface getDefaultImpl() {
            return Proxy.sDefaultImpl;
        }

        private static class Proxy
        implements IClientInterface {
            private IBinder mRemote;
            public static IClientInterface sDefaultImpl;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IClientInterface.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int[] getPacketCounters() throws RemoteException {
                int[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IClientInterface.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int[] nArray = Stub.getDefaultImpl().getPacketCounters();
                        return nArray;
                    }
                    _reply.readException();
                    _result = _reply.createIntArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int[] signalPoll() throws RemoteException {
                int[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IClientInterface.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int[] nArray = Stub.getDefaultImpl().signalPoll();
                        return nArray;
                    }
                    _reply.readException();
                    _result = _reply.createIntArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public byte[] getMacAddress() throws RemoteException {
                byte[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IClientInterface.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        byte[] byArray = Stub.getDefaultImpl().getMacAddress();
                        return byArray;
                    }
                    _reply.readException();
                    _result = _reply.createByteArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String getInterfaceName() throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IClientInterface.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        String string2 = Stub.getDefaultImpl().getInterfaceName();
                        return string2;
                    }
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IWifiScannerImpl getWifiScannerImpl() throws RemoteException {
                IWifiScannerImpl _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IClientInterface.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        IWifiScannerImpl iWifiScannerImpl = Stub.getDefaultImpl().getWifiScannerImpl();
                        return iWifiScannerImpl;
                    }
                    _reply.readException();
                    _result = IWifiScannerImpl.Stub.asInterface(_reply.readStrongBinder());
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void SendMgmtFrame(byte[] frame, ISendMgmtFrameEvent callback2, int mcs) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IClientInterface.DESCRIPTOR);
                    _data.writeByteArray(frame);
                    _data.writeStrongBinder(callback2 != null ? callback2.asBinder() : null);
                    _data.writeInt(mcs);
                    boolean _status = this.mRemote.transact(6, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().SendMgmtFrame(frame, callback2, mcs);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IClientInterface {
        @Override
        public int[] getPacketCounters() throws RemoteException {
            return null;
        }

        @Override
        public int[] signalPoll() throws RemoteException {
            return null;
        }

        @Override
        public byte[] getMacAddress() throws RemoteException {
            return null;
        }

        @Override
        public String getInterfaceName() throws RemoteException {
            return null;
        }

        @Override
        public IWifiScannerImpl getWifiScannerImpl() throws RemoteException {
            return null;
        }

        @Override
        public void SendMgmtFrame(byte[] frame, ISendMgmtFrameEvent callback2, int mcs) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

