/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi;

import android.annotation.RequiresPermission;
import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.app.ActivityManager;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.Context;
import android.net.DhcpInfo;
import android.net.MacAddress;
import android.net.Network;
import android.net.Uri;
import android.net.wifi.CoexUnsafeChannel;
import android.net.wifi.EasyConnectStatusCallback;
import android.net.wifi.IActionListener;
import android.net.wifi.ICoexCallback;
import android.net.wifi.IDppCallback;
import android.net.wifi.ILocalOnlyHotspotCallback;
import android.net.wifi.INetworkRequestMatchCallback;
import android.net.wifi.INetworkRequestUserSelectionCallback;
import android.net.wifi.IOnWifiActivityEnergyInfoListener;
import android.net.wifi.IOnWifiUsabilityStatsListener;
import android.net.wifi.IScanResultsCallback;
import android.net.wifi.IScoreUpdateObserver;
import android.net.wifi.ISoftApCallback;
import android.net.wifi.ISubsystemRestartCallback;
import android.net.wifi.ISuggestionConnectionStatusListener;
import android.net.wifi.ISuggestionUserApprovalStatusListener;
import android.net.wifi.ITrafficStateCallback;
import android.net.wifi.IWifiConnectedNetworkScorer;
import android.net.wifi.IWifiManager;
import android.net.wifi.IWifiVerboseLoggingStatusChangedListener;
import android.net.wifi.ScanResult;
import android.net.wifi.SoftApCapability;
import android.net.wifi.SoftApConfiguration;
import android.net.wifi.SoftApInfo;
import android.net.wifi.WifiAvailableChannel;
import android.net.wifi.WifiClient;
import android.net.wifi.WifiConfiguration;
import android.net.wifi.WifiConnectedSessionInfo;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiNetworkSuggestion;
import android.net.wifi.WifiUsabilityStatsEntry;
import android.net.wifi.WpsInfo;
import android.net.wifi.hotspot2.IProvisioningCallback;
import android.net.wifi.hotspot2.OsuProvider;
import android.net.wifi.hotspot2.PasspointConfiguration;
import android.net.wifi.hotspot2.ProvisioningCallback;
import android.os.Binder;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.os.WorkSource;
import android.os.connectivity.WifiActivityEnergyInfo;
import android.text.TextUtils;
import android.util.CloseGuard;
import android.util.Log;
import android.util.Pair;
import android.util.SparseArray;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import com.android.wifi.x.android.os.HandlerExecutor;
import com.android.wifi.x.androidx.annotation.RequiresApi;
import com.android.wifi.x.com.android.modules.utils.ParceledListSlice;
import com.android.wifi.x.com.android.modules.utils.build.SdkLevel;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.Executor;

public class WifiManager {
    private static final String TAG = "WifiManager";
    @Deprecated
    public static final int ERROR_AUTHENTICATING = 1;
    @Deprecated
    public static final int ERROR_AUTH_FAILURE_NONE = 0;
    @Deprecated
    public static final int ERROR_AUTH_FAILURE_TIMEOUT = 1;
    @Deprecated
    public static final int ERROR_AUTH_FAILURE_WRONG_PSWD = 2;
    @Deprecated
    public static final int ERROR_AUTH_FAILURE_EAP_FAILURE = 3;
    public static final int NETWORK_SUGGESTIONS_MAX_PER_APP_LOW_RAM = 256;
    public static final int NETWORK_SUGGESTIONS_MAX_PER_APP_HIGH_RAM = 1024;
    public static final int STATUS_NETWORK_SUGGESTIONS_SUCCESS = 0;
    public static final int STATUS_NETWORK_SUGGESTIONS_ERROR_INTERNAL = 1;
    public static final int STATUS_NETWORK_SUGGESTIONS_ERROR_APP_DISALLOWED = 2;
    public static final int STATUS_NETWORK_SUGGESTIONS_ERROR_ADD_DUPLICATE = 3;
    public static final int STATUS_NETWORK_SUGGESTIONS_ERROR_ADD_EXCEEDS_MAX_PER_APP = 4;
    public static final int STATUS_NETWORK_SUGGESTIONS_ERROR_REMOVE_INVALID = 5;
    public static final int STATUS_NETWORK_SUGGESTIONS_ERROR_ADD_NOT_ALLOWED = 6;
    public static final int STATUS_NETWORK_SUGGESTIONS_ERROR_ADD_INVALID = 7;
    public static final int STATUS_SUGGESTION_CONNECTION_FAILURE_UNKNOWN = 0;
    public static final int STATUS_SUGGESTION_CONNECTION_FAILURE_ASSOCIATION = 1;
    public static final int STATUS_SUGGESTION_CONNECTION_FAILURE_AUTHENTICATION = 2;
    public static final int STATUS_SUGGESTION_CONNECTION_FAILURE_IP_PROVISIONING = 3;
    public static final int STATUS_SUGGESTION_APPROVAL_UNKNOWN = 0;
    public static final int STATUS_SUGGESTION_APPROVAL_PENDING = 1;
    public static final int STATUS_SUGGESTION_APPROVAL_APPROVED_BY_USER = 2;
    public static final int STATUS_SUGGESTION_APPROVAL_REJECTED_BY_USER = 3;
    public static final int STATUS_SUGGESTION_APPROVAL_APPROVED_BY_CARRIER_PRIVILEGE = 4;
    public static final String ACTION_WIFI_SCAN_AVAILABILITY_CHANGED = "android.net.wifi.action.WIFI_SCAN_AVAILABILITY_CHANGED";
    public static final String EXTRA_SCAN_AVAILABLE = "android.net.wifi.extra.SCAN_AVAILABLE";
    @SystemApi
    public static final String WIFI_CREDENTIAL_CHANGED_ACTION = "android.net.wifi.WIFI_CREDENTIAL_CHANGED";
    @SystemApi
    public static final String EXTRA_WIFI_CREDENTIAL_EVENT_TYPE = "et";
    @SystemApi
    public static final String EXTRA_WIFI_CREDENTIAL_SSID = "ssid";
    @SystemApi
    public static final int WIFI_CREDENTIAL_SAVED = 0;
    @SystemApi
    public static final int WIFI_CREDENTIAL_FORGOT = 1;
    @SystemApi
    public static final int PASSPOINT_HOME_NETWORK = 0;
    @SystemApi
    public static final int PASSPOINT_ROAMING_NETWORK = 1;
    public static final String ACTION_PASSPOINT_ICON = "android.net.wifi.action.PASSPOINT_ICON";
    public static final String EXTRA_BSSID_LONG = "android.net.wifi.extra.BSSID_LONG";
    public static final String EXTRA_ICON = "android.net.wifi.extra.ICON";
    public static final String EXTRA_FILENAME = "android.net.wifi.extra.FILENAME";
    public static final String ACTION_PASSPOINT_OSU_PROVIDERS_LIST = "android.net.wifi.action.PASSPOINT_OSU_PROVIDERS_LIST";
    public static final String EXTRA_ANQP_ELEMENT_DATA = "android.net.wifi.extra.ANQP_ELEMENT_DATA";
    public static final String ACTION_PASSPOINT_DEAUTH_IMMINENT = "android.net.wifi.action.PASSPOINT_DEAUTH_IMMINENT";
    public static final String EXTRA_ESS = "android.net.wifi.extra.ESS";
    public static final String EXTRA_DELAY = "android.net.wifi.extra.DELAY";
    public static final String ACTION_PASSPOINT_SUBSCRIPTION_REMEDIATION = "android.net.wifi.action.PASSPOINT_SUBSCRIPTION_REMEDIATION";
    public static final String EXTRA_SUBSCRIPTION_REMEDIATION_METHOD = "android.net.wifi.extra.SUBSCRIPTION_REMEDIATION_METHOD";
    @SystemApi
    public static final String ACTION_PASSPOINT_LAUNCH_OSU_VIEW = "android.net.wifi.action.PASSPOINT_LAUNCH_OSU_VIEW";
    @SystemApi
    public static final String EXTRA_OSU_NETWORK = "android.net.wifi.extra.OSU_NETWORK";
    @SystemApi
    public static final String EXTRA_URL = "android.net.wifi.extra.URL";
    public static final String WIFI_STATE_CHANGED_ACTION = "android.net.wifi.WIFI_STATE_CHANGED";
    public static final String EXTRA_WIFI_STATE = "wifi_state";
    public static final String EXTRA_PREVIOUS_WIFI_STATE = "previous_wifi_state";
    public static final int WIFI_STATE_DISABLING = 0;
    public static final int WIFI_STATE_DISABLED = 1;
    public static final int WIFI_STATE_ENABLING = 2;
    public static final int WIFI_STATE_ENABLED = 3;
    public static final int WIFI_STATE_UNKNOWN = 4;
    @SystemApi
    public static final String WIFI_AP_STATE_CHANGED_ACTION = "android.net.wifi.WIFI_AP_STATE_CHANGED";
    @SystemApi
    public static final String EXTRA_WIFI_AP_STATE = "wifi_state";
    @SystemApi
    public static final String EXTRA_WIFI_AP_FAILURE_REASON = "android.net.wifi.extra.WIFI_AP_FAILURE_REASON";
    @SystemApi
    public static final String EXTRA_PREVIOUS_WIFI_AP_STATE = "previous_wifi_state";
    @SystemApi
    public static final String EXTRA_WIFI_AP_INTERFACE_NAME = "android.net.wifi.extra.WIFI_AP_INTERFACE_NAME";
    @SystemApi
    public static final String EXTRA_WIFI_AP_MODE = "android.net.wifi.extra.WIFI_AP_MODE";
    @SystemApi
    public static final int WIFI_AP_STATE_DISABLING = 10;
    @SystemApi
    public static final int WIFI_AP_STATE_DISABLED = 11;
    @SystemApi
    public static final int WIFI_AP_STATE_ENABLING = 12;
    @SystemApi
    public static final int WIFI_AP_STATE_ENABLED = 13;
    @SystemApi
    public static final int WIFI_AP_STATE_FAILED = 14;
    @SystemApi
    public static final int SAP_START_FAILURE_GENERAL = 0;
    @SystemApi
    public static final int SAP_START_FAILURE_NO_CHANNEL = 1;
    @SystemApi
    public static final int SAP_START_FAILURE_UNSUPPORTED_CONFIGURATION = 2;
    @SystemApi
    public static final int SAP_CLIENT_BLOCK_REASON_CODE_BLOCKED_BY_USER = 0;
    @SystemApi
    public static final int SAP_CLIENT_BLOCK_REASON_CODE_NO_MORE_STAS = 1;
    public static final int SAP_CLIENT_DISCONNECT_REASON_CODE_UNSPECIFIED = 2;
    @SystemApi
    public static final int IFACE_IP_MODE_UNSPECIFIED = -1;
    @SystemApi
    public static final int IFACE_IP_MODE_CONFIGURATION_ERROR = 0;
    @SystemApi
    public static final int IFACE_IP_MODE_TETHERED = 1;
    @SystemApi
    public static final int IFACE_IP_MODE_LOCAL_ONLY = 2;
    @SystemApi
    @RequiresPermission(value="android.permission.NETWORK_CARRIER_PROVISIONING")
    public static final String ACTION_NETWORK_SETTINGS_RESET = "android.net.wifi.action.NETWORK_SETTINGS_RESET";
    @SystemApi
    @RequiresPermission(value="android.permission.NETWORK_CARRIER_PROVISIONING")
    public static final String ACTION_REFRESH_USER_PROVISIONING = "android.net.wifi.action.REFRESH_USER_PROVISIONING";
    @Deprecated
    public static final String SUPPLICANT_CONNECTION_CHANGE_ACTION = "android.net.wifi.supplicant.CONNECTION_CHANGE";
    @Deprecated
    public static final String EXTRA_SUPPLICANT_CONNECTED = "connected";
    public static final String NETWORK_STATE_CHANGED_ACTION = "android.net.wifi.STATE_CHANGE";
    public static final String EXTRA_NETWORK_INFO = "networkInfo";
    @Deprecated
    public static final String EXTRA_BSSID = "bssid";
    @Deprecated
    public static final String EXTRA_WIFI_INFO = "wifiInfo";
    @Deprecated
    public static final String SUPPLICANT_STATE_CHANGED_ACTION = "android.net.wifi.supplicant.STATE_CHANGE";
    @Deprecated
    public static final String EXTRA_NEW_STATE = "newState";
    @Deprecated
    public static final String EXTRA_SUPPLICANT_ERROR = "supplicantError";
    @Deprecated
    public static final String EXTRA_SUPPLICANT_ERROR_REASON = "supplicantErrorReason";
    @SystemApi
    public static final String CONFIGURED_NETWORKS_CHANGED_ACTION = "android.net.wifi.CONFIGURED_NETWORKS_CHANGE";
    @Deprecated
    @SystemApi
    public static final String EXTRA_WIFI_CONFIGURATION = "wifiConfiguration";
    @Deprecated
    @SystemApi
    public static final String EXTRA_MULTIPLE_NETWORKS_CHANGED = "multipleChanges";
    @SystemApi
    public static final String EXTRA_CHANGE_REASON = "changeReason";
    @SystemApi
    public static final int CHANGE_REASON_ADDED = 0;
    @SystemApi
    public static final int CHANGE_REASON_REMOVED = 1;
    @SystemApi
    public static final int CHANGE_REASON_CONFIG_CHANGE = 2;
    public static final String SCAN_RESULTS_AVAILABLE_ACTION = "android.net.wifi.SCAN_RESULTS";
    public static final String EXTRA_RESULTS_UPDATED = "resultsUpdated";
    @Deprecated
    public static final String BATCHED_SCAN_RESULTS_AVAILABLE_ACTION = "android.net.wifi.BATCHED_RESULTS";
    public static final String RSSI_CHANGED_ACTION = "android.net.wifi.RSSI_CHANGED";
    public static final String EXTRA_NEW_RSSI = "newRssi";
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public static final String LINK_CONFIGURATION_CHANGED_ACTION = "android.net.wifi.LINK_CONFIGURATION_CHANGED";
    @SystemApi
    public static final String ACTION_LINK_CONFIGURATION_CHANGED = "android.net.wifi.LINK_CONFIGURATION_CHANGED";
    @Deprecated
    @SystemApi
    public static final String EXTRA_LINK_PROPERTIES = "android.net.wifi.extra.LINK_PROPERTIES";
    public static final String EXTRA_NETWORK_CAPABILITIES = "networkCapabilities";
    public static final String NETWORK_IDS_CHANGED_ACTION = "android.net.wifi.NETWORK_IDS_CHANGED";
    public static final String ACTION_REQUEST_SCAN_ALWAYS_AVAILABLE = "android.net.wifi.action.REQUEST_SCAN_ALWAYS_AVAILABLE";
    public static final String ACTION_PICK_WIFI_NETWORK = "android.net.wifi.PICK_WIFI_NETWORK";
    @SystemApi
    public static final String ACTION_REQUEST_ENABLE = "android.net.wifi.action.REQUEST_ENABLE";
    @SystemApi
    public static final String ACTION_REQUEST_DISABLE = "android.net.wifi.action.REQUEST_DISABLE";
    public static final String ACTION_WIFI_NETWORK_SUGGESTION_POST_CONNECTION = "android.net.wifi.action.WIFI_NETWORK_SUGGESTION_POST_CONNECTION";
    public static final String EXTRA_NETWORK_SUGGESTION = "android.net.wifi.extra.NETWORK_SUGGESTION";
    public static final int WIFI_MODE_NO_LOCKS_HELD = 0;
    @Deprecated
    public static final int WIFI_MODE_FULL = 1;
    @Deprecated
    public static final int WIFI_MODE_SCAN_ONLY = 2;
    public static final int WIFI_MODE_FULL_HIGH_PERF = 3;
    public static final int WIFI_MODE_FULL_LOW_LATENCY = 4;
    @UnsupportedAppUsage
    private static final int MIN_RSSI = -100;
    @UnsupportedAppUsage
    private static final int MAX_RSSI = -55;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public static final int RSSI_LEVELS = 5;
    @UnsupportedAppUsage
    public static final int WIFI_FREQUENCY_BAND_AUTO = 0;
    @UnsupportedAppUsage
    public static final int WIFI_FREQUENCY_BAND_5GHZ = 1;
    @UnsupportedAppUsage
    public static final int WIFI_FREQUENCY_BAND_2GHZ = 2;
    public static final boolean DEFAULT_POOR_NETWORK_AVOIDANCE_ENABLED = false;
    private static final int MAX_ACTIVE_LOCKS = 50;
    public static final String UNKNOWN_SSID = "<unknown ssid>";
    public static final MacAddress ALL_ZEROS_MAC_ADDRESS = MacAddress.fromString("00:00:00:00:00:00");
    @UnsupportedAppUsage
    private int mActiveLockCount;
    private Context mContext;
    @UnsupportedAppUsage
    IWifiManager mService;
    private final int mTargetSdkVersion;
    private Looper mLooper;
    private boolean mVerboseLoggingEnabled = false;
    private final Object mLock = new Object();
    @GuardedBy(value={"mLock"})
    private LocalOnlyHotspotCallbackProxy mLOHSCallbackProxy;
    @GuardedBy(value={"mLock"})
    private LocalOnlyHotspotObserverProxy mLOHSObserverProxy;
    private static final SparseArray<IOnWifiUsabilityStatsListener> sOnWifiUsabilityStatsListenerMap = new SparseArray();
    private static final SparseArray<ISuggestionConnectionStatusListener> sSuggestionConnectionStatusListenerMap = new SparseArray();
    private static final SparseArray<ISuggestionUserApprovalStatusListener> sSuggestionUserApprovalStatusListenerMap = new SparseArray();
    private static final SparseArray<IWifiVerboseLoggingStatusChangedListener> sWifiVerboseLoggingStatusChangedListenerMap = new SparseArray();
    private static final SparseArray<INetworkRequestMatchCallback> sNetworkRequestMatchCallbackMap = new SparseArray();
    private static final SparseArray<ITrafficStateCallback> sTrafficStateCallbackMap = new SparseArray();
    private static final SparseArray<ISoftApCallback> sSoftApCallbackMap = new SparseArray();
    public static final long WIFI_FEATURE_INFRA = 1L;
    public static final long WIFI_FEATURE_PASSPOINT = 4L;
    public static final long WIFI_FEATURE_P2P = 8L;
    public static final long WIFI_FEATURE_MOBILE_HOTSPOT = 16L;
    public static final long WIFI_FEATURE_SCANNER = 32L;
    public static final long WIFI_FEATURE_AWARE = 64L;
    public static final long WIFI_FEATURE_D2D_RTT = 128L;
    public static final long WIFI_FEATURE_D2AP_RTT = 256L;
    public static final long WIFI_FEATURE_BATCH_SCAN = 512L;
    public static final long WIFI_FEATURE_PNO = 1024L;
    public static final long WIFI_FEATURE_ADDITIONAL_STA = 2048L;
    public static final long WIFI_FEATURE_TDLS = 4096L;
    public static final long WIFI_FEATURE_TDLS_OFFCHANNEL = 8192L;
    public static final long WIFI_FEATURE_EPR = 16384L;
    public static final long WIFI_FEATURE_AP_STA = 32768L;
    public static final long WIFI_FEATURE_LINK_LAYER_STATS = 65536L;
    public static final long WIFI_FEATURE_LOGGER = 131072L;
    public static final long WIFI_FEATURE_HAL_EPNO = 262144L;
    public static final long WIFI_FEATURE_RSSI_MONITOR = 524288L;
    public static final long WIFI_FEATURE_MKEEP_ALIVE = 0x100000L;
    public static final long WIFI_FEATURE_CONFIG_NDO = 0x200000L;
    public static final long WIFI_FEATURE_TRANSMIT_POWER = 0x400000L;
    public static final long WIFI_FEATURE_CONTROL_ROAMING = 0x800000L;
    public static final long WIFI_FEATURE_IE_WHITELIST = 0x1000000L;
    public static final long WIFI_FEATURE_SCAN_RAND = 0x2000000L;
    public static final long WIFI_FEATURE_TX_POWER_LIMIT = 0x4000000L;
    public static final long WIFI_FEATURE_WPA3_SAE = 0x8000000L;
    public static final long WIFI_FEATURE_WPA3_SUITE_B = 0x10000000L;
    public static final long WIFI_FEATURE_OWE = 0x20000000L;
    public static final long WIFI_FEATURE_LOW_LATENCY = 0x40000000L;
    public static final long WIFI_FEATURE_DPP = 0x80000000L;
    public static final long WIFI_FEATURE_P2P_RAND_MAC = 0x100000000L;
    public static final long WIFI_FEATURE_CONNECTED_RAND_MAC = 0x200000000L;
    public static final long WIFI_FEATURE_AP_RAND_MAC = 0x400000000L;
    public static final long WIFI_FEATURE_MBO = 0x800000000L;
    public static final long WIFI_FEATURE_OCE = 0x1000000000L;
    public static final long WIFI_FEATURE_WAPI = 0x2000000000L;
    public static final long WIFI_FEATURE_FILS_SHA256 = 0x4000000000L;
    public static final long WIFI_FEATURE_FILS_SHA384 = 0x8000000000L;
    public static final long WIFI_FEATURE_SAE_PK = 0x10000000000L;
    public static final long WIFI_FEATURE_STA_BRIDGED_AP = 0x20000000000L;
    public static final long WIFI_FEATURE_BRIDGED_AP = 0x40000000000L;
    public static final long WIFI_FEATURE_INFRA_60G = 0x80000000000L;
    public static final long WIFI_FEATURE_ADDITIONAL_STA_LOCAL_ONLY = 0x100000000000L;
    public static final long WIFI_FEATURE_ADDITIONAL_STA_MBB = 0x200000000000L;
    public static final long WIFI_FEATURE_ADDITIONAL_STA_RESTRICTED = 0x400000000000L;
    public static final long WIFI_FEATURE_DPP_ENROLLEE_RESPONDER = 0x800000000000L;
    public static final long WIFI_FEATURE_PASSPOINT_TERMS_AND_CONDITIONS = 0x1000000000000L;
    public static final long WIFI_FEATURE_SAE_H2E = 0x2000000000000L;
    public static final long WIFI_FEATURE_WFD_R2 = 0x4000000000000L;
    public static final long WIFI_FEATURE_DECORATED_IDENTITY = 0x8000000000000L;
    @SystemApi
    @RequiresApi(value=31)
    public static final int COEX_RESTRICTION_WIFI_DIRECT = 1;
    @SystemApi
    @RequiresApi(value=31)
    public static final int COEX_RESTRICTION_SOFTAP = 2;
    @SystemApi
    @RequiresApi(value=31)
    public static final int COEX_RESTRICTION_WIFI_AWARE = 4;
    public static final int ERROR = 0;
    public static final int IN_PROGRESS = 1;
    public static final int BUSY = 2;
    public static final int WPS_OVERLAP_ERROR = 3;
    public static final int WPS_WEP_PROHIBITED = 4;
    public static final int WPS_TKIP_ONLY_PROHIBITED = 5;
    public static final int WPS_AUTH_FAILURE = 6;
    public static final int WPS_TIMED_OUT = 7;
    public static final int INVALID_ARGS = 8;
    public static final int NOT_AUTHORIZED = 9;
    @SystemApi
    public static final int DEVICE_MOBILITY_STATE_UNKNOWN = 0;
    @SystemApi
    public static final int DEVICE_MOBILITY_STATE_HIGH_MVMT = 1;
    @SystemApi
    public static final int DEVICE_MOBILITY_STATE_LOW_MVMT = 2;
    @SystemApi
    public static final int DEVICE_MOBILITY_STATE_STATIONARY = 3;
    @SystemApi
    public static final int EASY_CONNECT_NETWORK_ROLE_STA = 0;
    @SystemApi
    public static final int EASY_CONNECT_NETWORK_ROLE_AP = 1;
    private static final int EASY_CONNECT_DEVICE_INFO_MAXIMUM_LENGTH = 40;
    @SystemApi
    public static final int EASY_CONNECT_CRYPTOGRAPHY_CURVE_PRIME256V1 = 0;
    @SystemApi
    public static final int EASY_CONNECT_CRYPTOGRAPHY_CURVE_SECP384R1 = 1;
    @SystemApi
    public static final int EASY_CONNECT_CRYPTOGRAPHY_CURVE_SECP521R1 = 2;
    @SystemApi
    public static final int EASY_CONNECT_CRYPTOGRAPHY_CURVE_BRAINPOOLP256R1 = 3;
    @SystemApi
    public static final int EASY_CONNECT_CRYPTOGRAPHY_CURVE_BRAINPOOLP384R1 = 4;
    @SystemApi
    public static final int EASY_CONNECT_CRYPTOGRAPHY_CURVE_BRAINPOOLP512R1 = 5;
    @SystemApi
    public static final int VERBOSE_LOGGING_LEVEL_DISABLED = 0;
    @SystemApi
    public static final int VERBOSE_LOGGING_LEVEL_ENABLED = 1;
    @SystemApi
    public static final int VERBOSE_LOGGING_LEVEL_ENABLED_SHOW_KEY = 2;

    public WifiManager(Context context, IWifiManager service, Looper looper) {
        this.mContext = context;
        this.mService = service;
        this.mLooper = looper;
        this.mTargetSdkVersion = context.getApplicationInfo().targetSdkVersion;
        this.updateVerboseLoggingEnabledFromService();
    }

    @Deprecated
    @RequiresPermission(allOf={"android.permission.ACCESS_FINE_LOCATION", "android.permission.ACCESS_WIFI_STATE"})
    public List<WifiConfiguration> getConfiguredNetworks() {
        try {
            ParceledListSlice parceledList = this.mService.getConfiguredNetworks(this.mContext.getOpPackageName(), this.mContext.getAttributionTag(), false);
            if (parceledList == null) {
                return Collections.emptyList();
            }
            return parceledList.getList();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.ACCESS_WIFI_STATE")
    public List<WifiConfiguration> getCallerConfiguredNetworks() {
        try {
            ParceledListSlice parceledList = this.mService.getConfiguredNetworks(this.mContext.getOpPackageName(), this.mContext.getAttributionTag(), true);
            if (parceledList == null) {
                return Collections.emptyList();
            }
            return parceledList.getList();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.ACCESS_FINE_LOCATION", "android.permission.ACCESS_WIFI_STATE", "android.permission.READ_WIFI_CREDENTIAL"})
    public List<WifiConfiguration> getPrivilegedConfiguredNetworks() {
        try {
            ParceledListSlice parceledList = this.mService.getPrivilegedConfiguredNetworks(this.mContext.getOpPackageName(), this.mContext.getAttributionTag());
            if (parceledList == null) {
                return Collections.emptyList();
            }
            return parceledList.getList();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.NETWORK_SETTINGS", "android.permission.NETWORK_SETUP_WIZARD"})
    public List<Pair<WifiConfiguration, Map<Integer, List<ScanResult>>>> getAllMatchingWifiConfigs(List<ScanResult> scanResults) {
        ArrayList<Pair<WifiConfiguration, Map<Integer, List<ScanResult>>>> configs = new ArrayList<Pair<WifiConfiguration, Map<Integer, List<ScanResult>>>>();
        try {
            Map results = this.mService.getAllMatchingPasspointProfilesForScanResults(scanResults);
            if (results.isEmpty()) {
                return configs;
            }
            List<WifiConfiguration> wifiConfigurations = this.mService.getWifiConfigsForPasspointProfiles(new ArrayList<String>(results.keySet()));
            for (WifiConfiguration configuration : wifiConfigurations) {
                Map scanResultsPerNetworkType = (Map)results.get(configuration.getProfileKey());
                if (scanResultsPerNetworkType == null) continue;
                configs.add(Pair.create(configuration, scanResultsPerNetworkType));
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        return configs;
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.NETWORK_SETTINGS", "android.permission.NETWORK_SETUP_WIZARD"})
    public List<WifiConfiguration> getWifiConfigForMatchedNetworkSuggestionsSharedWithUser(List<ScanResult> scanResults) {
        try {
            return this.mService.getWifiConfigForMatchedNetworkSuggestionsSharedWithUser(scanResults);
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.NETWORK_SETTINGS", "android.permission.NETWORK_SETUP_WIZARD"})
    public Map<OsuProvider, List<ScanResult>> getMatchingOsuProviders(List<ScanResult> scanResults) {
        if (scanResults == null) {
            return new HashMap<OsuProvider, List<ScanResult>>();
        }
        try {
            return this.mService.getMatchingOsuProviders(scanResults);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.NETWORK_SETTINGS", "android.permission.NETWORK_SETUP_WIZARD"})
    public Map<OsuProvider, PasspointConfiguration> getMatchingPasspointConfigsForOsuProviders(Set<OsuProvider> osuProviders) {
        try {
            return this.mService.getMatchingPasspointConfigsForOsuProviders(new ArrayList<OsuProvider>(osuProviders));
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    public int addNetwork(WifiConfiguration config) {
        if (config == null) {
            return -1;
        }
        config.networkId = -1;
        return this.addOrUpdateNetwork(config);
    }

    @RequiresPermission(anyOf={"android.permission.NETWORK_SETTINGS", "android.permission.NETWORK_STACK", "android.permission.NETWORK_SETUP_WIZARD", "android.permission.NETWORK_MANAGED_PROVISIONING"})
    public AddNetworkResult addNetworkPrivileged(WifiConfiguration config) {
        if (config == null) {
            throw new IllegalArgumentException("config cannot be null");
        }
        config.networkId = -1;
        try {
            return this.mService.addOrUpdateNetworkPrivileged(config, this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    public int updateNetwork(WifiConfiguration config) {
        if (config == null || config.networkId < 0) {
            return -1;
        }
        return this.addOrUpdateNetwork(config);
    }

    private int addOrUpdateNetwork(WifiConfiguration config) {
        try {
            return this.mService.addOrUpdateNetwork(config, this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    @RequiresPermission(value="android.permission.NETWORK_SETTINGS")
    public void registerNetworkRequestMatchCallback(Executor executor, NetworkRequestMatchCallback callback2) {
        if (executor == null) {
            throw new IllegalArgumentException("executor cannot be null");
        }
        if (callback2 == null) {
            throw new IllegalArgumentException("callback cannot be null");
        }
        Log.v(TAG, "registerNetworkRequestMatchCallback: callback=" + callback2 + ", executor=" + executor);
        try {
            SparseArray<INetworkRequestMatchCallback> sparseArray = sNetworkRequestMatchCallbackMap;
            synchronized (sparseArray) {
                NetworkRequestMatchCallbackProxy binderCallback = new NetworkRequestMatchCallbackProxy(executor, callback2);
                sNetworkRequestMatchCallbackMap.put(System.identityHashCode(callback2), binderCallback);
                this.mService.registerNetworkRequestMatchCallback(binderCallback);
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    @RequiresPermission(value="android.permission.NETWORK_SETTINGS")
    public void unregisterNetworkRequestMatchCallback(NetworkRequestMatchCallback callback2) {
        if (callback2 == null) {
            throw new IllegalArgumentException("callback cannot be null");
        }
        Log.v(TAG, "unregisterNetworkRequestMatchCallback: callback=" + callback2);
        try {
            SparseArray<INetworkRequestMatchCallback> sparseArray = sNetworkRequestMatchCallbackMap;
            synchronized (sparseArray) {
                int callbackIdentifier = System.identityHashCode(callback2);
                if (!sNetworkRequestMatchCallbackMap.contains(callbackIdentifier)) {
                    Log.w(TAG, "Unknown external callback " + callbackIdentifier);
                    return;
                }
                this.mService.unregisterNetworkRequestMatchCallback(sNetworkRequestMatchCallbackMap.get(callbackIdentifier));
                sNetworkRequestMatchCallbackMap.remove(callbackIdentifier);
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.NETWORK_SETTINGS")
    public void removeAppState(int targetAppUid, String targetAppPackageName) {
        try {
            this.mService.removeAppState(targetAppUid, targetAppPackageName);
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
    }

    @RequiresPermission(value="android.permission.CHANGE_WIFI_STATE")
    public int addNetworkSuggestions(List<WifiNetworkSuggestion> networkSuggestions) {
        try {
            return this.mService.addNetworkSuggestions(networkSuggestions, this.mContext.getOpPackageName(), this.mContext.getAttributionTag());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.CHANGE_WIFI_STATE")
    public int removeNetworkSuggestions(List<WifiNetworkSuggestion> networkSuggestions) {
        try {
            return this.mService.removeNetworkSuggestions(networkSuggestions, this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.ACCESS_WIFI_STATE")
    public List<WifiNetworkSuggestion> getNetworkSuggestions() {
        try {
            return this.mService.getNetworkSuggestions(this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
    }

    public int getMaxNumberOfNetworkSuggestionsPerApp() {
        return WifiManager.getMaxNumberOfNetworkSuggestionsPerApp(this.mContext.getSystemService(ActivityManager.class).isLowRamDevice());
    }

    public static int getMaxNumberOfNetworkSuggestionsPerApp(boolean isLowRamDevice) {
        return isLowRamDevice ? 256 : 1024;
    }

    public void addOrUpdatePasspointConfiguration(PasspointConfiguration config) {
        try {
            if (!this.mService.addOrUpdatePasspointConfiguration(config, this.mContext.getOpPackageName())) {
                throw new IllegalArgumentException();
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    @RequiresPermission(anyOf={"android.permission.NETWORK_SETTINGS", "android.permission.NETWORK_CARRIER_PROVISIONING"})
    public void removePasspointConfiguration(String fqdn) {
        try {
            if (!this.mService.removePasspointConfiguration(fqdn, this.mContext.getOpPackageName())) {
                throw new IllegalArgumentException();
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    @RequiresPermission(anyOf={"android.permission.NETWORK_SETTINGS", "android.permission.NETWORK_SETUP_WIZARD"})
    public List<PasspointConfiguration> getPasspointConfigurations() {
        try {
            return this.mService.getPasspointConfigurations(this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void queryPasspointIcon(long bssid, String fileName) {
        try {
            this.mService.queryPasspointIcon(bssid, fileName);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public int matchProviderWithCurrentNetwork(String fqdn) {
        try {
            return this.mService.matchProviderWithCurrentNetwork(fqdn);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    public boolean removeNetwork(int netId) {
        try {
            return this.mService.removeNetwork(netId, this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.CHANGE_WIFI_STATE")
    public boolean removeNonCallerConfiguredNetworks() {
        try {
            return this.mService.removeNonCallerConfiguredNetworks(this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    public boolean enableNetwork(int netId, boolean attemptConnect) {
        try {
            return this.mService.enableNetwork(netId, attemptConnect, this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    public boolean disableNetwork(int netId) {
        try {
            return this.mService.disableNetwork(netId, this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    public boolean disconnect() {
        try {
            return this.mService.disconnect(this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    public boolean reconnect() {
        try {
            return this.mService.reconnect(this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    public boolean reassociate() {
        try {
            return this.mService.reassociate(this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    public boolean pingSupplicant() {
        return this.isWifiEnabled();
    }

    private long getSupportedFeatures() {
        try {
            return this.mService.getSupportedFeatures();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private boolean isFeatureSupported(long feature) {
        return (this.getSupportedFeatures() & feature) == feature;
    }

    public boolean isPasspointSupported() {
        return this.isFeatureSupported(4L);
    }

    public boolean isP2pSupported() {
        return this.isFeatureSupported(8L);
    }

    @SystemApi
    public boolean isPortableHotspotSupported() {
        return this.isFeatureSupported(16L);
    }

    @SystemApi
    public boolean isWifiScannerSupported() {
        return this.isFeatureSupported(32L);
    }

    public boolean isWifiAwareSupported() {
        return this.isFeatureSupported(64L);
    }

    public boolean isStaApConcurrencySupported() {
        return this.isFeatureSupported(32768L);
    }

    public boolean isStaConcurrencyForLocalOnlyConnectionsSupported() {
        return this.isFeatureSupported(0x100000000000L);
    }

    public boolean isMakeBeforeBreakWifiSwitchingSupported() {
        return this.isFeatureSupported(0x200000000000L);
    }

    @SystemApi
    public boolean isStaConcurrencyForRestrictedConnectionsSupported() {
        return this.isFeatureSupported(0x400000000000L);
    }

    @Deprecated
    @SystemApi
    public boolean isDeviceToDeviceRttSupported() {
        return this.isFeatureSupported(128L);
    }

    @Deprecated
    public boolean isDeviceToApRttSupported() {
        return this.isFeatureSupported(256L);
    }

    public boolean isPreferredNetworkOffloadSupported() {
        return this.isFeatureSupported(1024L);
    }

    public boolean isTdlsSupported() {
        return this.isFeatureSupported(4096L);
    }

    public boolean isOffChannelTdlsSupported() {
        return this.isFeatureSupported(8192L);
    }

    public boolean isEnhancedPowerReportingSupported() {
        return this.isFeatureSupported(65536L);
    }

    @SystemApi
    public boolean isConnectedMacRandomizationSupported() {
        return this.isFeatureSupported(0x200000000L);
    }

    @SystemApi
    public boolean isApMacRandomizationSupported() {
        return this.isFeatureSupported(0x400000000L);
    }

    public boolean is24GHzBandSupported() {
        try {
            return this.mService.is24GHzBandSupported();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean is5GHzBandSupported() {
        try {
            return this.mService.is5GHzBandSupported();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresApi(value=31)
    public boolean is60GHzBandSupported() {
        try {
            return this.mService.is60GHzBandSupported();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean is6GHzBandSupported() {
        try {
            return this.mService.is6GHzBandSupported();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean isWifiStandardSupported(int standard) {
        try {
            return this.mService.isWifiStandardSupported(standard);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean isStaBridgedApConcurrencySupported() {
        return this.isFeatureSupported(0x20000000000L);
    }

    public boolean isBridgedApConcurrencySupported() {
        return this.isFeatureSupported(0x40000000000L);
    }

    @SystemApi
    @RequiresPermission(value="android.permission.ACCESS_WIFI_STATE")
    public void getWifiActivityEnergyInfoAsync(Executor executor, OnWifiActivityEnergyInfoListener listener2) {
        Objects.requireNonNull(executor, "executor cannot be null");
        Objects.requireNonNull(listener2, "listener cannot be null");
        try {
            this.mService.getWifiActivityEnergyInfoAsync(new OnWifiActivityEnergyInfoProxy(executor, listener2));
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    public boolean startScan() {
        return this.startScan(null);
    }

    @SystemApi
    @RequiresPermission(value="android.permission.UPDATE_DEVICE_STATS")
    public boolean startScan(WorkSource workSource) {
        try {
            String packageName = this.mContext.getOpPackageName();
            String attributionTag = this.mContext.getAttributionTag();
            return this.mService.startScan(packageName, attributionTag);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public String getCurrentNetworkWpsNfcConfigurationToken() {
        return null;
    }

    @Deprecated
    public WifiInfo getConnectionInfo() {
        try {
            return this.mService.getConnectionInfo(this.mContext.getOpPackageName(), this.mContext.getAttributionTag());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public List<ScanResult> getScanResults() {
        try {
            return this.mService.getScanResults(this.mContext.getOpPackageName(), this.mContext.getAttributionTag());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.ACCESS_FINE_LOCATION", "android.permission.ACCESS_WIFI_STATE"})
    public Map<WifiNetworkSuggestion, List<ScanResult>> getMatchingScanResults(List<WifiNetworkSuggestion> networkSuggestionsToMatch, List<ScanResult> scanResults) {
        if (networkSuggestionsToMatch == null) {
            throw new IllegalArgumentException("networkSuggestions must not be null.");
        }
        try {
            return this.mService.getMatchingScanResults(networkSuggestionsToMatch, scanResults, this.mContext.getOpPackageName(), this.mContext.getAttributionTag());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.NETWORK_SETTINGS")
    public void setScanAlwaysAvailable(boolean isAvailable) {
        try {
            this.mService.setScanAlwaysAvailable(isAvailable, this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    public boolean isScanAlwaysAvailable() {
        try {
            return this.mService.isScanAlwaysAvailable();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    public boolean saveConfiguration() {
        return false;
    }

    @SystemApi
    @RequiresPermission(value="android.permission.NETWORK_SETTINGS")
    public String getCountryCode() {
        try {
            return this.mService.getCountryCode();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresApi(value=31)
    @RequiresPermission(value="android.permission.MANAGE_WIFI_COUNTRY_CODE")
    public void setOverrideCountryCode(String country) {
        try {
            this.mService.setOverrideCountryCode(country);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresApi(value=31)
    @RequiresPermission(value="android.permission.MANAGE_WIFI_COUNTRY_CODE")
    public void clearOverrideCountryCode() {
        try {
            this.mService.clearOverrideCountryCode();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresApi(value=31)
    @RequiresPermission(value="android.permission.MANAGE_WIFI_COUNTRY_CODE")
    public void setDefaultCountryCode(String country) {
        try {
            this.mService.setDefaultCountryCode(country);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    public DhcpInfo getDhcpInfo() {
        try {
            return this.mService.getDhcpInfo(this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    public boolean setWifiEnabled(boolean enabled) {
        try {
            return this.mService.setWifiEnabled(this.mContext.getOpPackageName(), enabled);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresApi(value=31)
    @RequiresPermission(value="android.permission.ACCESS_WIFI_STATE")
    public void registerSubsystemRestartTrackingCallback(Executor executor, SubsystemRestartTrackingCallback callback2) {
        if (executor == null) {
            throw new IllegalArgumentException("executor must not be null");
        }
        if (callback2 == null) {
            throw new IllegalArgumentException("callback must not be null");
        }
        SubsystemRestartTrackingCallback.SubsystemRestartCallbackProxy proxy = callback2.getProxy();
        proxy.initProxy(executor, callback2);
        try {
            this.mService.registerSubsystemRestartCallback(proxy);
        }
        catch (RemoteException e) {
            proxy.cleanUpProxy();
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresApi(value=31)
    @RequiresPermission(value="android.permission.ACCESS_WIFI_STATE")
    public void unregisterSubsystemRestartTrackingCallback(SubsystemRestartTrackingCallback callback2) {
        if (callback2 == null) {
            throw new IllegalArgumentException("callback must not be null");
        }
        SubsystemRestartTrackingCallback.SubsystemRestartCallbackProxy proxy = callback2.getProxy();
        try {
            this.mService.unregisterSubsystemRestartCallback(proxy);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        finally {
            proxy.cleanUpProxy();
        }
    }

    @SystemApi
    @RequiresApi(value=31)
    @RequiresPermission(value="android.permission.RESTART_WIFI_SUBSYSTEM")
    public void restartWifiSubsystem() {
        try {
            this.mService.restartWifiSubsystem();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public int getWifiState() {
        try {
            return this.mService.getWifiEnabledState();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean isWifiEnabled() {
        return this.getWifiState() == 3;
    }

    @Deprecated
    public static int calculateSignalLevel(int rssi, int numLevels) {
        if (rssi <= -100) {
            return 0;
        }
        if (rssi >= -55) {
            return numLevels - 1;
        }
        float inputRange = 45.0f;
        float outputRange = numLevels - 1;
        return (int)((float)(rssi - -100) * outputRange / inputRange);
    }

    public int calculateSignalLevel(int rssi) {
        try {
            return this.mService.calculateSignalLevel(rssi);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public int getMaxSignalLevel() {
        return this.calculateSignalLevel(Integer.MAX_VALUE);
    }

    public static int compareSignalLevel(int rssiA, int rssiB) {
        return rssiA - rssiB;
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.NETWORK_STACK", "android.permission.MAINLINE_NETWORK_STACK"})
    public void updateInterfaceIpState(String ifaceName, int mode) {
        try {
            this.mService.updateInterfaceIpState(ifaceName, mode);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean isDefaultCoexAlgorithmEnabled() {
        try {
            return this.mService.isDefaultCoexAlgorithmEnabled();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.WIFI_UPDATE_COEX_UNSAFE_CHANNELS")
    @RequiresApi(value=31)
    public void setCoexUnsafeChannels(List<CoexUnsafeChannel> unsafeChannels, int restrictions) {
        if (unsafeChannels == null) {
            throw new IllegalArgumentException("unsafeChannels must not be null");
        }
        try {
            this.mService.setCoexUnsafeChannels(unsafeChannels, restrictions);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.WIFI_ACCESS_COEX_UNSAFE_CHANNELS")
    @RequiresApi(value=31)
    public void registerCoexCallback(Executor executor, CoexCallback callback2) {
        if (executor == null) {
            throw new IllegalArgumentException("executor must not be null");
        }
        if (callback2 == null) {
            throw new IllegalArgumentException("callback must not be null");
        }
        CoexCallback.CoexCallbackProxy proxy = callback2.getProxy();
        proxy.initProxy(executor, callback2);
        try {
            this.mService.registerCoexCallback(proxy);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.WIFI_ACCESS_COEX_UNSAFE_CHANNELS")
    @RequiresApi(value=31)
    public void unregisterCoexCallback(CoexCallback callback2) {
        if (callback2 == null) {
            throw new IllegalArgumentException("callback must not be null");
        }
        CoexCallback.CoexCallbackProxy proxy = callback2.getProxy();
        try {
            this.mService.unregisterCoexCallback(proxy);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        finally {
            proxy.cleanUpProxy();
        }
    }

    @RequiresPermission(anyOf={"android.permission.NETWORK_STACK", "android.permission.MAINLINE_NETWORK_STACK"})
    public boolean startSoftAp(WifiConfiguration wifiConfig) {
        try {
            return this.mService.startSoftAp(wifiConfig, this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.NETWORK_STACK", "android.permission.MAINLINE_NETWORK_STACK"})
    public boolean startTetheredHotspot(SoftApConfiguration softApConfig) {
        try {
            return this.mService.startTetheredHotspot(softApConfig, this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.NETWORK_STACK", "android.permission.MAINLINE_NETWORK_STACK"})
    public boolean stopSoftAp() {
        try {
            return this.mService.stopSoftAp();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(allOf={"android.permission.CHANGE_WIFI_STATE", "android.permission.ACCESS_FINE_LOCATION"})
    public void startLocalOnlyHotspot(LocalOnlyHotspotCallback callback2, Handler handler) {
        HandlerExecutor executor = handler == null ? null : new HandlerExecutor(handler);
        this.startLocalOnlyHotspotInternal(null, executor, callback2);
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.NETWORK_SETTINGS", "android.permission.NETWORK_SETUP_WIZARD"})
    public void startLocalOnlyHotspot(SoftApConfiguration config, Executor executor, LocalOnlyHotspotCallback callback2) {
        Objects.requireNonNull(config);
        this.startLocalOnlyHotspotInternal(config, executor, callback2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startLocalOnlyHotspotInternal(SoftApConfiguration config, Executor executor, LocalOnlyHotspotCallback callback2) {
        if (executor == null) {
            executor = this.mContext.getMainExecutor();
        }
        Object object = this.mLock;
        synchronized (object) {
            LocalOnlyHotspotCallbackProxy proxy = new LocalOnlyHotspotCallbackProxy(this, executor, callback2);
            try {
                String packageName = this.mContext.getOpPackageName();
                String featureId = this.mContext.getAttributionTag();
                int returnCode = this.mService.startLocalOnlyHotspot(proxy, packageName, featureId, config);
                if (returnCode != 0) {
                    proxy.onHotspotFailed(returnCode);
                    return;
                }
                this.mLOHSCallbackProxy = proxy;
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    public void cancelLocalOnlyHotspotRequest() {
        Object object = this.mLock;
        synchronized (object) {
            this.stopLocalOnlyHotspot();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopLocalOnlyHotspot() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mLOHSCallbackProxy == null) {
                return;
            }
            this.mLOHSCallbackProxy = null;
            try {
                this.mService.stopLocalOnlyHotspot();
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void watchLocalOnlyHotspot(LocalOnlyHotspotObserver observer, Handler handler) {
        Executor executor = handler == null ? this.mContext.getMainExecutor() : new HandlerExecutor(handler);
        Object object = this.mLock;
        synchronized (object) {
            this.mLOHSObserverProxy = new LocalOnlyHotspotObserverProxy(this, executor, observer);
            try {
                this.mService.startWatchLocalOnlyHotspot(this.mLOHSObserverProxy);
                this.mLOHSObserverProxy.registered();
            }
            catch (RemoteException e) {
                this.mLOHSObserverProxy = null;
                throw e.rethrowFromSystemServer();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterLocalOnlyHotspotObserver() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mLOHSObserverProxy == null) {
                return;
            }
            this.mLOHSObserverProxy = null;
            try {
                this.mService.stopWatchLocalOnlyHotspot();
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.ACCESS_WIFI_STATE")
    public int getWifiApState() {
        try {
            return this.mService.getWifiApEnabledState();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.ACCESS_WIFI_STATE")
    public boolean isWifiApEnabled() {
        return this.getWifiApState() == 13;
    }

    @SystemApi
    @Deprecated
    @RequiresPermission(value="android.permission.ACCESS_WIFI_STATE")
    public WifiConfiguration getWifiApConfiguration() {
        try {
            return this.mService.getWifiApConfiguration();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.NETWORK_SETTINGS", "android.permission.OVERRIDE_WIFI_CONFIG"})
    public SoftApConfiguration getSoftApConfiguration() {
        try {
            return this.mService.getSoftApConfiguration();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @Deprecated
    @RequiresPermission(value="android.permission.CHANGE_WIFI_STATE")
    public boolean setWifiApConfiguration(WifiConfiguration wifiConfig) {
        try {
            return this.mService.setWifiApConfiguration(wifiConfig, this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.NETWORK_SETTINGS", "android.permission.OVERRIDE_WIFI_CONFIG"})
    public boolean setSoftApConfiguration(SoftApConfiguration softApConfig) {
        try {
            return this.mService.setSoftApConfiguration(softApConfig, this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void setTdlsEnabled(InetAddress remoteIPAddress, boolean enable) {
        try {
            this.mService.enableTdls(remoteIPAddress.getHostAddress(), enable);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void setTdlsEnabledWithMacAddress(String remoteMacAddress, boolean enable) {
        try {
            this.mService.enableTdlsWithMacAddress(remoteMacAddress, enable);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    @RequiresPermission(anyOf={"android.permission.NETWORK_SETTINGS", "android.permission.MAINLINE_NETWORK_STACK", "android.permission.OVERRIDE_WIFI_CONFIG"})
    public void registerSoftApCallback(Executor executor, SoftApCallback callback2) {
        if (executor == null) {
            throw new IllegalArgumentException("executor cannot be null");
        }
        if (callback2 == null) {
            throw new IllegalArgumentException("callback cannot be null");
        }
        Log.v(TAG, "registerSoftApCallback: callback=" + callback2 + ", executor=" + executor);
        try {
            SparseArray<ISoftApCallback> sparseArray = sSoftApCallbackMap;
            synchronized (sparseArray) {
                SoftApCallbackProxy binderCallback = new SoftApCallbackProxy(executor, callback2);
                sSoftApCallbackMap.put(System.identityHashCode(callback2), binderCallback);
                this.mService.registerSoftApCallback(binderCallback);
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    @RequiresPermission(anyOf={"android.permission.NETWORK_SETTINGS", "android.permission.MAINLINE_NETWORK_STACK", "android.permission.OVERRIDE_WIFI_CONFIG"})
    public void unregisterSoftApCallback(SoftApCallback callback2) {
        if (callback2 == null) {
            throw new IllegalArgumentException("callback cannot be null");
        }
        Log.v(TAG, "unregisterSoftApCallback: callback=" + callback2);
        try {
            SparseArray<ISoftApCallback> sparseArray = sSoftApCallbackMap;
            synchronized (sparseArray) {
                int callbackIdentifier = System.identityHashCode(callback2);
                if (!sSoftApCallbackMap.contains(callbackIdentifier)) {
                    Log.w(TAG, "Unknown external callback " + callbackIdentifier);
                    return;
                }
                this.mService.unregisterSoftApCallback(sSoftApCallbackMap.get(callbackIdentifier));
                sSoftApCallbackMap.remove(callbackIdentifier);
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private void connectInternal(WifiConfiguration config, int networkId, ActionListener listener2) {
        block5: {
            ActionListenerProxy listenerProxy = null;
            if (listener2 != null) {
                listenerProxy = new ActionListenerProxy("connect", this.mLooper, listener2);
            }
            try {
                this.mService.connect(config, networkId, listenerProxy);
            }
            catch (RemoteException e) {
                if (listenerProxy != null) {
                    listenerProxy.onFailure(0);
                }
            }
            catch (SecurityException e) {
                if (listenerProxy == null) break block5;
                listenerProxy.onFailure(9);
            }
        }
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.NETWORK_SETTINGS", "android.permission.NETWORK_SETUP_WIZARD", "android.permission.NETWORK_STACK"})
    public void connect(WifiConfiguration config, ActionListener listener2) {
        if (config == null) {
            throw new IllegalArgumentException("config cannot be null");
        }
        this.connectInternal(config, -1, listener2);
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.NETWORK_SETTINGS", "android.permission.NETWORK_SETUP_WIZARD", "android.permission.NETWORK_STACK"})
    public void connect(int networkId, ActionListener listener2) {
        if (networkId < 0) {
            throw new IllegalArgumentException("Network id cannot be negative");
        }
        this.connectInternal(null, networkId, listener2);
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.NETWORK_SETTINGS", "android.permission.NETWORK_SETUP_WIZARD"})
    @RequiresApi(value=31)
    public void startRestrictingAutoJoinToSubscriptionId(int subscriptionId) {
        try {
            this.mService.startRestrictingAutoJoinToSubscriptionId(subscriptionId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.NETWORK_SETTINGS", "android.permission.NETWORK_SETUP_WIZARD"})
    @RequiresApi(value=31)
    public void stopRestrictingAutoJoinToSubscriptionId() {
        try {
            this.mService.stopRestrictingAutoJoinToSubscriptionId();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.NETWORK_SETTINGS", "android.permission.NETWORK_SETUP_WIZARD", "android.permission.NETWORK_STACK"})
    public void save(WifiConfiguration config, ActionListener listener2) {
        block6: {
            if (config == null) {
                throw new IllegalArgumentException("config cannot be null");
            }
            ActionListenerProxy listenerProxy = null;
            if (listener2 != null) {
                listenerProxy = new ActionListenerProxy("save", this.mLooper, listener2);
            }
            try {
                this.mService.save(config, listenerProxy);
            }
            catch (RemoteException e) {
                if (listenerProxy != null) {
                    listenerProxy.onFailure(0);
                }
            }
            catch (SecurityException e) {
                if (listenerProxy == null) break block6;
                listenerProxy.onFailure(9);
            }
        }
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.NETWORK_SETTINGS", "android.permission.NETWORK_SETUP_WIZARD", "android.permission.NETWORK_STACK"})
    public void forget(int netId, ActionListener listener2) {
        block6: {
            if (netId < 0) {
                throw new IllegalArgumentException("Network id cannot be negative");
            }
            ActionListenerProxy listenerProxy = null;
            if (listener2 != null) {
                listenerProxy = new ActionListenerProxy("forget", this.mLooper, listener2);
            }
            try {
                this.mService.forget(netId, listenerProxy);
            }
            catch (RemoteException e) {
                if (listenerProxy != null) {
                    listenerProxy.onFailure(0);
                }
            }
            catch (SecurityException e) {
                if (listenerProxy == null) break block6;
                listenerProxy.onFailure(9);
            }
        }
    }

    @SystemApi
    @Deprecated
    @RequiresPermission(anyOf={"android.permission.NETWORK_SETTINGS", "android.permission.NETWORK_SETUP_WIZARD", "android.permission.NETWORK_STACK"})
    public void disable(int netId, ActionListener listener2) {
        if (netId < 0) {
            throw new IllegalArgumentException("Network id cannot be negative");
        }
        boolean status = this.disableNetwork(netId);
        if (listener2 != null) {
            if (status) {
                listener2.onSuccess();
            } else {
                listener2.onFailure(0);
            }
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.NETWORK_SETTINGS")
    public void allowAutojoinGlobal(boolean allowAutojoin) {
        try {
            this.mService.allowAutojoinGlobal(allowAutojoin);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.NETWORK_SETTINGS")
    public void allowAutojoin(int netId, boolean allowAutojoin) {
        try {
            this.mService.allowAutojoin(netId, allowAutojoin);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.NETWORK_SETTINGS")
    public void allowAutojoinPasspoint(String fqdn, boolean allowAutojoin) {
        try {
            this.mService.allowAutojoinPasspoint(fqdn, allowAutojoin);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.NETWORK_SETTINGS")
    public void setMacRandomizationSettingPasspointEnabled(String fqdn, boolean enable) {
        try {
            this.mService.setMacRandomizationSettingPasspointEnabled(fqdn, enable);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.NETWORK_SETTINGS")
    public void setPasspointMeteredOverride(String fqdn, int meteredOverride) {
        try {
            this.mService.setPasspointMeteredOverride(fqdn, meteredOverride);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.NETWORK_SETTINGS", "android.permission.NETWORK_STACK"})
    public void disableEphemeralNetwork(String network) {
        if (TextUtils.isEmpty(network)) {
            throw new IllegalArgumentException("SSID cannot be null or empty!");
        }
        try {
            this.mService.disableEphemeralNetwork(network, this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void startWps(WpsInfo config, WpsCallback listener2) {
        if (listener2 != null) {
            listener2.onFailed(0);
        }
    }

    public void cancelWps(WpsCallback listener2) {
        if (listener2 != null) {
            listener2.onFailed(0);
        }
    }

    public WifiLock createWifiLock(int lockType, String tag) {
        return new WifiLock(lockType, tag);
    }

    @Deprecated
    public WifiLock createWifiLock(String tag) {
        return new WifiLock(1, tag);
    }

    public MulticastLock createMulticastLock(String tag) {
        return new MulticastLock(tag);
    }

    public boolean isMulticastEnabled() {
        try {
            return this.mService.isMulticastEnabled();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @UnsupportedAppUsage
    public boolean initializeMulticastFiltering() {
        try {
            this.mService.initializeMulticastFiltering();
            return true;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.NETWORK_SETTINGS")
    public void setVerboseLoggingEnabled(boolean enable) {
        this.enableVerboseLogging(enable ? 1 : 0);
    }

    @SystemApi
    @RequiresPermission(value="android.permission.NETWORK_SETTINGS")
    public void setVerboseLoggingLevel(int verbose) {
        this.enableVerboseLogging(verbose);
    }

    @UnsupportedAppUsage(maxTargetSdk=29, publicAlternatives="Use {@code #setVerboseLoggingEnabled(boolean)} instead.")
    @RequiresPermission(value="android.permission.NETWORK_SETTINGS")
    public void enableVerboseLogging(int verbose) {
        try {
            this.mService.enableVerboseLogging(verbose);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    public boolean isVerboseLoggingEnabled() {
        return this.getVerboseLoggingLevel() > 0;
    }

    @SystemApi
    public int getVerboseLoggingLevel() {
        try {
            return this.mService.getVerboseLoggingLevel();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.NETWORK_SETTINGS")
    public void factoryReset() {
        try {
            this.mService.factoryReset(this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.NETWORK_SETTINGS", "android.permission.NETWORK_SETUP_WIZARD"})
    public Network getCurrentNetwork() {
        try {
            return this.mService.getCurrentNetwork();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean setEnableAutoJoinWhenAssociated(boolean enabled) {
        return false;
    }

    public boolean getEnableAutoJoinWhenAssociated() {
        return false;
    }

    @SystemApi
    @RequiresPermission(value="android.permission.NETWORK_SETTINGS")
    public byte[] retrieveBackupData() {
        try {
            return this.mService.retrieveBackupData();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.NETWORK_SETTINGS")
    public void restoreBackupData(byte[] data) {
        try {
            this.mService.restoreBackupData(data);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.NETWORK_SETTINGS")
    public byte[] retrieveSoftApBackupData() {
        try {
            return this.mService.retrieveSoftApBackupData();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.NETWORK_SETTINGS")
    public SoftApConfiguration restoreSoftApBackupData(byte[] data) {
        try {
            return this.mService.restoreSoftApBackupData(data);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.NETWORK_SETTINGS")
    public void restoreSupplicantBackupData(byte[] supplicantData, byte[] ipConfigData) {
        try {
            this.mService.restoreSupplicantBackupData(supplicantData, ipConfigData);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.NETWORK_SETTINGS", "android.permission.NETWORK_SETUP_WIZARD"})
    public void startSubscriptionProvisioning(OsuProvider provider2, Executor executor, ProvisioningCallback callback2) {
        if (executor == null) {
            throw new IllegalArgumentException("executor must not be null");
        }
        if (callback2 == null) {
            throw new IllegalArgumentException("callback must not be null");
        }
        try {
            this.mService.startSubscriptionProvisioning(provider2, new ProvisioningCallbackProxy(executor, callback2));
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    @RequiresPermission(value="android.permission.NETWORK_SETTINGS")
    public void registerTrafficStateCallback(Executor executor, TrafficStateCallback callback2) {
        if (executor == null) {
            throw new IllegalArgumentException("executor cannot be null");
        }
        if (callback2 == null) {
            throw new IllegalArgumentException("callback cannot be null");
        }
        Log.v(TAG, "registerTrafficStateCallback: callback=" + callback2 + ", executor=" + executor);
        try {
            SparseArray<ITrafficStateCallback> sparseArray = sTrafficStateCallbackMap;
            synchronized (sparseArray) {
                TrafficStateCallbackProxy binderCallback = new TrafficStateCallbackProxy(executor, callback2);
                sTrafficStateCallbackMap.put(System.identityHashCode(callback2), binderCallback);
                this.mService.registerTrafficStateCallback(binderCallback);
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    @RequiresPermission(value="android.permission.NETWORK_SETTINGS")
    public void unregisterTrafficStateCallback(TrafficStateCallback callback2) {
        if (callback2 == null) {
            throw new IllegalArgumentException("callback cannot be null");
        }
        Log.v(TAG, "unregisterTrafficStateCallback: callback=" + callback2);
        try {
            SparseArray<ITrafficStateCallback> sparseArray = sTrafficStateCallbackMap;
            synchronized (sparseArray) {
                int callbackIdentifier = System.identityHashCode(callback2);
                if (!sTrafficStateCallbackMap.contains(callbackIdentifier)) {
                    Log.w(TAG, "Unknown external callback " + callbackIdentifier);
                    return;
                }
                this.mService.unregisterTrafficStateCallback(sTrafficStateCallbackMap.get(callbackIdentifier));
                sTrafficStateCallbackMap.remove(callbackIdentifier);
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private void updateVerboseLoggingEnabledFromService() {
        this.mVerboseLoggingEnabled = this.isVerboseLoggingEnabled();
    }

    public boolean isWpa3SaeSupported() {
        return this.isFeatureSupported(0x8000000L);
    }

    public boolean isWpa3SuiteBSupported() {
        return this.isFeatureSupported(0x10000000L);
    }

    public boolean isEnhancedOpenSupported() {
        return this.isFeatureSupported(0x20000000L);
    }

    public boolean isEasyConnectSupported() {
        return this.isFeatureSupported(0x80000000L);
    }

    public boolean isEasyConnectEnrolleeResponderModeSupported() {
        return this.isFeatureSupported(0x800000000000L);
    }

    public boolean isWapiSupported() {
        return this.isFeatureSupported(0x2000000000L);
    }

    public boolean isWpa3SaePublicKeySupported() {
        return false;
    }

    public boolean isPasspointTermsAndConditionsSupported() {
        return this.isFeatureSupported(0x1000000000000L);
    }

    public boolean isWpa3SaeH2eSupported() {
        return this.isFeatureSupported(0x2000000000000L);
    }

    public boolean isWifiDisplayR2Supported() {
        return this.isFeatureSupported(0x4000000000000L);
    }

    public boolean isDecoratedIdentitySupported() {
        return this.isFeatureSupported(0x8000000000000L);
    }

    @SystemApi
    @RequiresPermission(value="android.permission.NETWORK_SETTINGS")
    public String[] getFactoryMacAddresses() {
        try {
            return this.mService.getFactoryMacAddresses();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.WIFI_SET_DEVICE_MOBILITY_STATE")
    public void setDeviceMobilityState(int state) {
        try {
            this.mService.setDeviceMobilityState(state);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.NETWORK_SETTINGS", "android.permission.NETWORK_SETUP_WIZARD"})
    public void startEasyConnectAsConfiguratorInitiator(String enrolleeUri, int selectedNetworkId, int enrolleeNetworkRole, Executor executor, EasyConnectStatusCallback callback2) {
        Binder binder = new Binder();
        try {
            this.mService.startDppAsConfiguratorInitiator(binder, this.mContext.getOpPackageName(), enrolleeUri, selectedNetworkId, enrolleeNetworkRole, new EasyConnectCallbackProxy(executor, callback2));
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.NETWORK_SETTINGS", "android.permission.NETWORK_SETUP_WIZARD"})
    public void startEasyConnectAsEnrolleeInitiator(String configuratorUri, Executor executor, EasyConnectStatusCallback callback2) {
        Binder binder = new Binder();
        try {
            this.mService.startDppAsEnrolleeInitiator(binder, configuratorUri, new EasyConnectCallbackProxy(executor, callback2));
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.NETWORK_SETTINGS", "android.permission.NETWORK_SETUP_WIZARD"})
    @RequiresApi(value=31)
    public void startEasyConnectAsEnrolleeResponder(String deviceInfo, int curve, Executor executor, EasyConnectStatusCallback callback2) {
        Binder binder = new Binder();
        try {
            this.mService.startDppAsEnrolleeResponder(binder, deviceInfo, curve, new EasyConnectCallbackProxy(executor, callback2));
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    public static int getEasyConnectMaxAllowedResponderDeviceInfoLength() {
        return 40;
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.NETWORK_SETTINGS", "android.permission.NETWORK_SETUP_WIZARD"})
    public void stopEasyConnectSession() {
        try {
            this.mService.stopDppSession();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    @RequiresPermission(value="android.permission.WIFI_UPDATE_USABILITY_STATS_SCORE")
    public void addOnWifiUsabilityStatsListener(final Executor executor, final OnWifiUsabilityStatsListener listener2) {
        if (executor == null) {
            throw new IllegalArgumentException("executor cannot be null");
        }
        if (listener2 == null) {
            throw new IllegalArgumentException("listener cannot be null");
        }
        if (this.mVerboseLoggingEnabled) {
            Log.v(TAG, "addOnWifiUsabilityStatsListener: listener=" + listener2);
        }
        try {
            SparseArray<IOnWifiUsabilityStatsListener> sparseArray = sOnWifiUsabilityStatsListenerMap;
            synchronized (sparseArray) {
                IOnWifiUsabilityStatsListener.Stub binderCallback = new IOnWifiUsabilityStatsListener.Stub(){

                    @Override
                    public void onWifiUsabilityStats(int seqNum, boolean isSameBssidAndFreq, WifiUsabilityStatsEntry stats) {
                        if (WifiManager.this.mVerboseLoggingEnabled) {
                            Log.v(WifiManager.TAG, "OnWifiUsabilityStatsListener: onWifiUsabilityStats: seqNum=" + seqNum);
                        }
                        Binder.clearCallingIdentity();
                        executor.execute(() -> listener2.onWifiUsabilityStats(seqNum, isSameBssidAndFreq, stats));
                    }
                };
                sOnWifiUsabilityStatsListenerMap.put(System.identityHashCode(listener2), binderCallback);
                this.mService.addOnWifiUsabilityStatsListener(binderCallback);
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    @RequiresPermission(value="android.permission.WIFI_UPDATE_USABILITY_STATS_SCORE")
    public void removeOnWifiUsabilityStatsListener(OnWifiUsabilityStatsListener listener2) {
        if (listener2 == null) {
            throw new IllegalArgumentException("listener cannot be null");
        }
        if (this.mVerboseLoggingEnabled) {
            Log.v(TAG, "removeOnWifiUsabilityStatsListener: listener=" + listener2);
        }
        try {
            SparseArray<IOnWifiUsabilityStatsListener> sparseArray = sOnWifiUsabilityStatsListenerMap;
            synchronized (sparseArray) {
                int listenerIdentifier = System.identityHashCode(listener2);
                if (!sOnWifiUsabilityStatsListenerMap.contains(listenerIdentifier)) {
                    Log.w(TAG, "Unknown external callback " + listenerIdentifier);
                    return;
                }
                this.mService.removeOnWifiUsabilityStatsListener(sOnWifiUsabilityStatsListenerMap.get(listenerIdentifier));
                sOnWifiUsabilityStatsListenerMap.remove(listenerIdentifier);
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.WIFI_UPDATE_USABILITY_STATS_SCORE")
    public void updateWifiUsabilityScore(int seqNum, int score, int predictionHorizonSec) {
        try {
            this.mService.updateWifiUsabilityScore(seqNum, score, predictionHorizonSec);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.ACCESS_WIFI_STATE")
    public void registerScanResultsCallback(Executor executor, ScanResultsCallback callback2) {
        if (executor == null) {
            throw new IllegalArgumentException("executor cannot be null");
        }
        if (callback2 == null) {
            throw new IllegalArgumentException("callback cannot be null");
        }
        Log.v(TAG, "registerScanResultsCallback: callback=" + callback2 + ", executor=" + executor);
        ScanResultsCallback.ScanResultsCallbackProxy proxy = callback2.getProxy();
        proxy.initProxy(executor, callback2);
        try {
            this.mService.registerScanResultsCallback(proxy);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.ACCESS_WIFI_STATE")
    public void unregisterScanResultsCallback(ScanResultsCallback callback2) {
        if (callback2 == null) {
            throw new IllegalArgumentException("callback cannot be null");
        }
        Log.v(TAG, "unregisterScanResultsCallback: Callback=" + callback2);
        ScanResultsCallback.ScanResultsCallbackProxy proxy = callback2.getProxy();
        try {
            this.mService.unregisterScanResultsCallback(proxy);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        finally {
            proxy.cleanUpProxy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    @RequiresPermission(value="android.permission.ACCESS_WIFI_STATE")
    public void addWifiVerboseLoggingStatusChangedListener(final Executor executor, final WifiVerboseLoggingStatusChangedListener listener2) {
        if (listener2 == null) {
            throw new IllegalArgumentException("Listener cannot be null");
        }
        if (executor == null) {
            throw new IllegalArgumentException("Executor cannot be null");
        }
        if (this.mVerboseLoggingEnabled) {
            Log.v(TAG, "addWifiVerboseLoggingStatusChangedListener listener=" + listener2 + ", executor=" + executor);
        }
        try {
            SparseArray<IWifiVerboseLoggingStatusChangedListener> sparseArray = sWifiVerboseLoggingStatusChangedListenerMap;
            synchronized (sparseArray) {
                IWifiVerboseLoggingStatusChangedListener.Stub binderCallback = new IWifiVerboseLoggingStatusChangedListener.Stub(){

                    @Override
                    public void onStatusChanged(boolean enabled) {
                        if (WifiManager.this.mVerboseLoggingEnabled) {
                            Log.v(WifiManager.TAG, "WifiVerboseLoggingStatusListener: onVerboseLoggingStatusChanged: enabled=" + enabled);
                        }
                        Binder.clearCallingIdentity();
                        executor.execute(() -> listener2.onWifiVerboseLoggingStatusChanged(enabled));
                    }
                };
                sWifiVerboseLoggingStatusChangedListenerMap.put(System.identityHashCode(listener2), binderCallback);
                this.mService.addWifiVerboseLoggingStatusChangedListener(binderCallback);
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    @RequiresPermission(value="android.permission.ACCESS_WIFI_STATE")
    public void removeWifiVerboseLoggingStatusChangedListener(WifiVerboseLoggingStatusChangedListener listener2) {
        if (listener2 == null) {
            throw new IllegalArgumentException("Listener cannot be null");
        }
        Log.v(TAG, "removeWifiVerboseLoggingStatusChangedListener: listener=" + listener2);
        try {
            SparseArray<IWifiVerboseLoggingStatusChangedListener> sparseArray = sWifiVerboseLoggingStatusChangedListenerMap;
            synchronized (sparseArray) {
                int listenerIdentifier = System.identityHashCode(listener2);
                if (!sWifiVerboseLoggingStatusChangedListenerMap.contains(listenerIdentifier)) {
                    Log.w(TAG, "Unknown external callback " + listenerIdentifier);
                    return;
                }
                this.mService.removeWifiVerboseLoggingStatusChangedListener(sWifiVerboseLoggingStatusChangedListenerMap.get(listenerIdentifier));
                sWifiVerboseLoggingStatusChangedListenerMap.remove(listenerIdentifier);
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(allOf={"android.permission.ACCESS_FINE_LOCATION", "android.permission.ACCESS_WIFI_STATE"})
    public void addSuggestionConnectionStatusListener(Executor executor, SuggestionConnectionStatusListener listener2) {
        if (listener2 == null) {
            throw new IllegalArgumentException("Listener cannot be null");
        }
        if (executor == null) {
            throw new IllegalArgumentException("Executor cannot be null");
        }
        Log.v(TAG, "addSuggestionConnectionStatusListener listener=" + listener2 + ", executor=" + executor);
        try {
            SparseArray<ISuggestionConnectionStatusListener> sparseArray = sSuggestionConnectionStatusListenerMap;
            synchronized (sparseArray) {
                SuggestionConnectionStatusListenerProxy binderCallback = new SuggestionConnectionStatusListenerProxy(executor, listener2);
                sSuggestionConnectionStatusListenerMap.put(System.identityHashCode(listener2), binderCallback);
                this.mService.registerSuggestionConnectionStatusListener(binderCallback, this.mContext.getOpPackageName(), this.mContext.getAttributionTag());
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(value="android.permission.ACCESS_WIFI_STATE")
    public void removeSuggestionConnectionStatusListener(SuggestionConnectionStatusListener listener2) {
        if (listener2 == null) {
            throw new IllegalArgumentException("Listener cannot be null");
        }
        Log.v(TAG, "removeSuggestionConnectionStatusListener: listener=" + listener2);
        try {
            SparseArray<ISuggestionConnectionStatusListener> sparseArray = sSuggestionConnectionStatusListenerMap;
            synchronized (sparseArray) {
                int listenerIdentifier = System.identityHashCode(listener2);
                if (!sSuggestionConnectionStatusListenerMap.contains(listenerIdentifier)) {
                    Log.w(TAG, "Unknown external callback " + listenerIdentifier);
                    return;
                }
                this.mService.unregisterSuggestionConnectionStatusListener(sSuggestionConnectionStatusListenerMap.get(listenerIdentifier), this.mContext.getOpPackageName());
                sSuggestionConnectionStatusListenerMap.remove(listenerIdentifier);
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @VisibleForTesting
    public static SparseArray<int[]> parseDppChannelList(String channelList) {
        SparseArray<int[]> channelListArray = new SparseArray<int[]>();
        if (TextUtils.isEmpty(channelList)) {
            return channelListArray;
        }
        StringTokenizer str = new StringTokenizer(channelList, ",");
        String classStr = null;
        ArrayList<Integer> channelsInClass = new ArrayList<Integer>();
        try {
            while (str.hasMoreElements()) {
                String cur = str.nextToken();
                int classDelim = cur.indexOf(47);
                if (classDelim != -1) {
                    if (classStr != null) {
                        int[] channelsArray = new int[channelsInClass.size()];
                        for (int i = 0; i < channelsInClass.size(); ++i) {
                            channelsArray[i] = (Integer)channelsInClass.get(i);
                        }
                        channelListArray.append(Integer.parseInt(classStr), channelsArray);
                        channelsInClass = new ArrayList();
                    }
                    classStr = cur.substring(0, classDelim);
                    String channelStr = cur.substring(classDelim + 1);
                    channelsInClass.add(Integer.parseInt(channelStr));
                    continue;
                }
                if (classStr == null) {
                    Log.e(TAG, "Cannot parse DPP channel list");
                    return new SparseArray<int[]>();
                }
                channelsInClass.add(Integer.parseInt(cur));
            }
            if (classStr != null) {
                int[] channelsArray = new int[channelsInClass.size()];
                for (int i = 0; i < channelsInClass.size(); ++i) {
                    channelsArray[i] = (Integer)channelsInClass.get(i);
                }
                channelListArray.append(Integer.parseInt(classStr), channelsArray);
            }
            return channelListArray;
        }
        catch (NumberFormatException e) {
            Log.e(TAG, "Cannot parse DPP channel list");
            return new SparseArray<int[]>();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.WIFI_UPDATE_USABILITY_STATS_SCORE")
    public boolean setWifiConnectedNetworkScorer(Executor executor, WifiConnectedNetworkScorer scorer) {
        if (executor == null) {
            throw new IllegalArgumentException("executor cannot be null");
        }
        if (scorer == null) {
            throw new IllegalArgumentException("scorer cannot be null");
        }
        if (this.mVerboseLoggingEnabled) {
            Log.v(TAG, "setWifiConnectedNetworkScorer: scorer=" + scorer);
        }
        try {
            return this.mService.setWifiConnectedNetworkScorer(new Binder(), new WifiConnectedNetworkScorerProxy(executor, scorer));
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.WIFI_UPDATE_USABILITY_STATS_SCORE")
    public void clearWifiConnectedNetworkScorer() {
        if (this.mVerboseLoggingEnabled) {
            Log.v(TAG, "clearWifiConnectedNetworkScorer");
        }
        try {
            this.mService.clearWifiConnectedNetworkScorer();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.NETWORK_SETTINGS")
    public void setScanThrottleEnabled(boolean enable) {
        try {
            this.mService.setScanThrottleEnabled(enable);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.ACCESS_WIFI_STATE")
    public boolean isScanThrottleEnabled() {
        try {
            return this.mService.isScanThrottleEnabled();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.NETWORK_SETTINGS")
    public void setAutoWakeupEnabled(boolean enable) {
        try {
            this.mService.setAutoWakeupEnabled(enable);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.ACCESS_WIFI_STATE")
    public boolean isAutoWakeupEnabled() {
        try {
            return this.mService.isAutoWakeupEnabled();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.NETWORK_SETTINGS", "android.permission.NETWORK_SETUP_WIZARD"})
    public void setCarrierNetworkOffloadEnabled(int subscriptionId, boolean merged, boolean enabled) {
        try {
            this.mService.setCarrierNetworkOffloadEnabled(subscriptionId, merged, enabled);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.ACCESS_WIFI_STATE")
    public boolean isCarrierNetworkOffloadEnabled(int subscriptionId, boolean merged) {
        try {
            return this.mService.isCarrierNetworkOffloadEnabled(subscriptionId, merged);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(value="android.permission.ACCESS_WIFI_STATE")
    public void addSuggestionUserApprovalStatusListener(Executor executor, SuggestionUserApprovalStatusListener listener2) {
        if (listener2 == null) {
            throw new NullPointerException("Listener cannot be null");
        }
        if (executor == null) {
            throw new NullPointerException("Executor cannot be null");
        }
        Log.v(TAG, "addSuggestionUserApprovalStatusListener listener=" + listener2 + ", executor=" + executor);
        try {
            SparseArray<ISuggestionUserApprovalStatusListener> sparseArray = sSuggestionUserApprovalStatusListenerMap;
            synchronized (sparseArray) {
                SuggestionUserApprovalStatusListenerProxy binderCallback = new SuggestionUserApprovalStatusListenerProxy(executor, listener2);
                sSuggestionUserApprovalStatusListenerMap.put(System.identityHashCode(listener2), binderCallback);
                this.mService.addSuggestionUserApprovalStatusListener(binderCallback, this.mContext.getOpPackageName());
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(value="android.permission.ACCESS_WIFI_STATE")
    public void removeSuggestionUserApprovalStatusListener(SuggestionUserApprovalStatusListener listener2) {
        if (listener2 == null) {
            throw new IllegalArgumentException("Listener cannot be null");
        }
        Log.v(TAG, "removeSuggestionUserApprovalStatusListener: listener=" + listener2);
        try {
            SparseArray<ISuggestionUserApprovalStatusListener> sparseArray = sSuggestionUserApprovalStatusListenerMap;
            synchronized (sparseArray) {
                int listenerIdentifier = System.identityHashCode(listener2);
                if (!sSuggestionUserApprovalStatusListenerMap.contains(listenerIdentifier)) {
                    Log.w(TAG, "Unknown external callback " + listenerIdentifier);
                    return;
                }
                this.mService.removeSuggestionUserApprovalStatusListener(sSuggestionUserApprovalStatusListenerMap.get(listenerIdentifier), this.mContext.getOpPackageName());
                sSuggestionUserApprovalStatusListenerMap.remove(listenerIdentifier);
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.NETWORK_STACK")
    public void setEmergencyScanRequestInProgress(boolean inProgress) {
        try {
            this.mService.setEmergencyScanRequestInProgress(inProgress);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.NETWORK_SETTINGS")
    public boolean setWifiScoringEnabled(boolean enabled) {
        if (this.mVerboseLoggingEnabled) {
            Log.v(TAG, "setWifiScoringEnabled: " + enabled);
        }
        try {
            return this.mService.setWifiScoringEnabled(enabled);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(anyOf={"android.permission.NETWORK_SETTINGS", "android.permission.NETWORK_MANAGED_PROVISIONING", "android.permission.NETWORK_CARRIER_PROVISIONING"})
    public void flushPasspointAnqpCache() {
        try {
            this.mService.flushPasspointAnqpCache(this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresApi(value=31)
    @RequiresPermission(value="android.permission.LOCATION_HARDWARE")
    public List<WifiAvailableChannel> getAllowedChannels(int band, int mode) {
        if (!SdkLevel.isAtLeastS()) {
            throw new UnsupportedOperationException();
        }
        try {
            return this.mService.getUsableChannels(band, mode, 0);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresApi(value=31)
    @RequiresPermission(value="android.permission.LOCATION_HARDWARE")
    public List<WifiAvailableChannel> getUsableChannels(int band, int mode) {
        if (!SdkLevel.isAtLeastS()) {
            throw new UnsupportedOperationException();
        }
        try {
            return this.mService.getUsableChannels(band, mode, WifiAvailableChannel.getUsableFilter());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private class SuggestionUserApprovalStatusListenerProxy
    extends ISuggestionUserApprovalStatusListener.Stub {
        private final Executor mExecutor;
        private final SuggestionUserApprovalStatusListener mListener;

        SuggestionUserApprovalStatusListenerProxy(Executor executor, SuggestionUserApprovalStatusListener listener2) {
            this.mExecutor = executor;
            this.mListener = listener2;
        }

        @Override
        public void onUserApprovalStatusChange(int status) {
            this.mExecutor.execute(() -> this.mListener.onUserApprovalStatusChange(status));
        }
    }

    public static interface SuggestionUserApprovalStatusListener {
        public void onUserApprovalStatusChange(int var1);
    }

    private class WifiConnectedNetworkScorerProxy
    extends IWifiConnectedNetworkScorer.Stub {
        private Executor mExecutor;
        private WifiConnectedNetworkScorer mScorer;

        WifiConnectedNetworkScorerProxy(Executor executor, WifiConnectedNetworkScorer scorer) {
            this.mExecutor = executor;
            this.mScorer = scorer;
        }

        @Override
        public void onStart(WifiConnectedSessionInfo sessionInfo) {
            if (WifiManager.this.mVerboseLoggingEnabled) {
                Log.v(WifiManager.TAG, "WifiConnectedNetworkScorer: onStart: sessionInfo=" + sessionInfo);
            }
            Binder.clearCallingIdentity();
            this.mExecutor.execute(() -> this.mScorer.onStart(sessionInfo));
        }

        @Override
        public void onStop(int sessionId) {
            if (WifiManager.this.mVerboseLoggingEnabled) {
                Log.v(WifiManager.TAG, "WifiConnectedNetworkScorer: onStop: sessionId=" + sessionId);
            }
            Binder.clearCallingIdentity();
            this.mExecutor.execute(() -> this.mScorer.onStop(sessionId));
        }

        @Override
        public void onSetScoreUpdateObserver(IScoreUpdateObserver observerImpl) {
            if (WifiManager.this.mVerboseLoggingEnabled) {
                Log.v(WifiManager.TAG, "WifiConnectedNetworkScorer: onSetScoreUpdateObserver: observerImpl=" + observerImpl);
            }
            Binder.clearCallingIdentity();
            this.mExecutor.execute(() -> this.mScorer.onSetScoreUpdateObserver(new ScoreUpdateObserverProxy(observerImpl)));
        }
    }

    @SystemApi
    public static interface WifiConnectedNetworkScorer {
        @Deprecated
        default public void onStart(int sessionId) {
        }

        default public void onStart(WifiConnectedSessionInfo sessionInfo) {
            this.onStart(sessionInfo.getSessionId());
        }

        public void onStop(int var1);

        public void onSetScoreUpdateObserver(ScoreUpdateObserver var1);
    }

    private class ScoreUpdateObserverProxy
    implements ScoreUpdateObserver {
        private final IScoreUpdateObserver mScoreUpdateObserver;

        private ScoreUpdateObserverProxy(IScoreUpdateObserver observer) {
            this.mScoreUpdateObserver = observer;
        }

        @Override
        public void notifyScoreUpdate(int sessionId, int score) {
            try {
                this.mScoreUpdateObserver.notifyScoreUpdate(sessionId, score);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }

        @Override
        public void triggerUpdateOfWifiUsabilityStats(int sessionId) {
            try {
                this.mScoreUpdateObserver.triggerUpdateOfWifiUsabilityStats(sessionId);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }

        @Override
        public void notifyStatusUpdate(int sessionId, boolean isUsable) {
            if (!SdkLevel.isAtLeastS()) {
                throw new UnsupportedOperationException();
            }
            try {
                this.mScoreUpdateObserver.notifyStatusUpdate(sessionId, isUsable);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }

        @Override
        public void requestNudOperation(int sessionId) {
            if (!SdkLevel.isAtLeastS()) {
                throw new UnsupportedOperationException();
            }
            try {
                this.mScoreUpdateObserver.requestNudOperation(sessionId);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }

        @Override
        public void blocklistCurrentBssid(int sessionId) {
            if (!SdkLevel.isAtLeastS()) {
                throw new UnsupportedOperationException();
            }
            try {
                this.mScoreUpdateObserver.blocklistCurrentBssid(sessionId);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    @SystemApi
    public static interface ScoreUpdateObserver {
        public void notifyScoreUpdate(int var1, int var2);

        public void triggerUpdateOfWifiUsabilityStats(int var1);

        @RequiresApi(value=31)
        default public void notifyStatusUpdate(int sessionId, boolean isUsable) {
        }

        @RequiresApi(value=31)
        default public void requestNudOperation(int sessionId) {
        }

        @RequiresApi(value=31)
        default public void blocklistCurrentBssid(int sessionId) {
        }
    }

    private class SuggestionConnectionStatusListenerProxy
    extends ISuggestionConnectionStatusListener.Stub {
        private final Executor mExecutor;
        private final SuggestionConnectionStatusListener mListener;

        SuggestionConnectionStatusListenerProxy(Executor executor, SuggestionConnectionStatusListener listener2) {
            this.mExecutor = executor;
            this.mListener = listener2;
        }

        @Override
        public void onConnectionStatus(WifiNetworkSuggestion wifiNetworkSuggestion, int failureReason) {
            this.mExecutor.execute(() -> this.mListener.onConnectionStatus(wifiNetworkSuggestion, failureReason));
        }
    }

    public static interface SuggestionConnectionStatusListener {
        public void onConnectionStatus(WifiNetworkSuggestion var1, int var2);
    }

    public static abstract class ScanResultsCallback {
        private final ScanResultsCallbackProxy mScanResultsCallbackProxy = new ScanResultsCallbackProxy();

        public abstract void onScanResultsAvailable();

        ScanResultsCallbackProxy getProxy() {
            return this.mScanResultsCallbackProxy;
        }

        private static class ScanResultsCallbackProxy
        extends IScanResultsCallback.Stub {
            private final Object mLock = new Object();
            @GuardedBy(value={"mLock"})
            private Executor mExecutor = null;
            @GuardedBy(value={"mLock"})
            private ScanResultsCallback mCallback = null;

            ScanResultsCallbackProxy() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            void initProxy(Executor executor, ScanResultsCallback callback2) {
                Object object = this.mLock;
                synchronized (object) {
                    this.mExecutor = executor;
                    this.mCallback = callback2;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            void cleanUpProxy() {
                Object object = this.mLock;
                synchronized (object) {
                    this.mExecutor = null;
                    this.mCallback = null;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onScanResultsAvailable() {
                ScanResultsCallback callback2;
                Executor executor;
                Object object = this.mLock;
                synchronized (object) {
                    executor = this.mExecutor;
                    callback2 = this.mCallback;
                }
                if (callback2 == null || executor == null) {
                    return;
                }
                Binder.clearCallingIdentity();
                executor.execute(callback2::onScanResultsAvailable);
            }
        }
    }

    @SystemApi
    public static interface WifiVerboseLoggingStatusChangedListener {
        public void onWifiVerboseLoggingStatusChanged(boolean var1);
    }

    @SystemApi
    public static interface OnWifiUsabilityStatsListener {
        public void onWifiUsabilityStats(int var1, boolean var2, WifiUsabilityStatsEntry var3);
    }

    private static class EasyConnectCallbackProxy
    extends IDppCallback.Stub {
        private final Executor mExecutor;
        private final EasyConnectStatusCallback mEasyConnectStatusCallback;

        EasyConnectCallbackProxy(Executor executor, EasyConnectStatusCallback easyConnectStatusCallback) {
            this.mExecutor = executor;
            this.mEasyConnectStatusCallback = easyConnectStatusCallback;
        }

        @Override
        public void onSuccessConfigReceived(int newNetworkId) {
            Log.d(WifiManager.TAG, "Easy Connect onSuccessConfigReceived callback");
            Binder.clearCallingIdentity();
            this.mExecutor.execute(() -> this.mEasyConnectStatusCallback.onEnrolleeSuccess(newNetworkId));
        }

        @Override
        public void onSuccess(int status) {
            Log.d(WifiManager.TAG, "Easy Connect onSuccess callback");
            Binder.clearCallingIdentity();
            this.mExecutor.execute(() -> this.mEasyConnectStatusCallback.onConfiguratorSuccess(status));
        }

        @Override
        public void onFailure(int status, String ssid, String channelList, int[] operatingClassArray) {
            Log.d(WifiManager.TAG, "Easy Connect onFailure callback");
            Binder.clearCallingIdentity();
            this.mExecutor.execute(() -> {
                SparseArray<int[]> channelListArray = WifiManager.parseDppChannelList(channelList);
                this.mEasyConnectStatusCallback.onFailure(status, ssid, channelListArray, operatingClassArray);
            });
        }

        @Override
        public void onProgress(int status) {
            Log.d(WifiManager.TAG, "Easy Connect onProgress callback");
            Binder.clearCallingIdentity();
            this.mExecutor.execute(() -> this.mEasyConnectStatusCallback.onProgress(status));
        }

        @Override
        public void onBootstrapUriGenerated(String uri) {
            Log.d(WifiManager.TAG, "Easy Connect onBootstrapUriGenerated callback");
            if (!SdkLevel.isAtLeastS()) {
                Log.e(WifiManager.TAG, "Easy Connect bootstrap URI callback supported only on S+");
                return;
            }
            Binder.clearCallingIdentity();
            this.mExecutor.execute(() -> this.mEasyConnectStatusCallback.onBootstrapUriGenerated(Uri.parse(uri)));
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface VerboseLoggingLevel {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface EasyConnectCryptographyCurve {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface EasyConnectNetworkRole {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface DeviceMobilityState {
    }

    private class TrafficStateCallbackProxy
    extends ITrafficStateCallback.Stub {
        private final Executor mExecutor;
        private final TrafficStateCallback mCallback;

        TrafficStateCallbackProxy(Executor executor, TrafficStateCallback callback2) {
            this.mExecutor = executor;
            this.mCallback = callback2;
        }

        @Override
        public void onStateChanged(int state) {
            if (WifiManager.this.mVerboseLoggingEnabled) {
                Log.v(WifiManager.TAG, "TrafficStateCallbackProxy: onStateChanged state=" + state);
            }
            Binder.clearCallingIdentity();
            this.mExecutor.execute(() -> this.mCallback.onStateChanged(state));
        }
    }

    @SystemApi
    public static interface TrafficStateCallback {
        public static final int DATA_ACTIVITY_NONE = 0;
        public static final int DATA_ACTIVITY_IN = 1;
        public static final int DATA_ACTIVITY_OUT = 2;
        public static final int DATA_ACTIVITY_INOUT = 3;

        public void onStateChanged(int var1);

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface DataActivity {
        }
    }

    private static class ProvisioningCallbackProxy
    extends IProvisioningCallback.Stub {
        private final Executor mExecutor;
        private final ProvisioningCallback mCallback;

        ProvisioningCallbackProxy(Executor executor, ProvisioningCallback callback2) {
            this.mExecutor = executor;
            this.mCallback = callback2;
        }

        @Override
        public void onProvisioningStatus(int status) {
            this.mExecutor.execute(() -> this.mCallback.onProvisioningStatus(status));
        }

        @Override
        public void onProvisioningFailure(int status) {
            this.mExecutor.execute(() -> this.mCallback.onProvisioningFailure(status));
        }

        @Override
        public void onProvisioningComplete() {
            this.mExecutor.execute(() -> this.mCallback.onProvisioningComplete());
        }
    }

    public class MulticastLock {
        private String mTag;
        private final IBinder mBinder;
        private int mRefCount;
        private boolean mRefCounted;
        private boolean mHeld;

        private MulticastLock(String tag) {
            this.mTag = tag;
            this.mBinder = new Binder();
            this.mRefCount = 0;
            this.mRefCounted = true;
            this.mHeld = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void acquire() {
            IBinder iBinder = this.mBinder;
            synchronized (iBinder) {
                if (this.mRefCounted ? ++this.mRefCount == 1 : !this.mHeld) {
                    try {
                        WifiManager.this.mService.acquireMulticastLock(this.mBinder, this.mTag);
                        WifiManager wifiManager = WifiManager.this;
                        synchronized (wifiManager) {
                            if (WifiManager.this.mActiveLockCount >= 50) {
                                WifiManager.this.mService.releaseMulticastLock(this.mTag);
                                throw new UnsupportedOperationException("Exceeded maximum number of wifi locks");
                            }
                            WifiManager.this.mActiveLockCount++;
                        }
                    }
                    catch (RemoteException e) {
                        throw e.rethrowFromSystemServer();
                    }
                    this.mHeld = true;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void release() {
            IBinder iBinder = this.mBinder;
            synchronized (iBinder) {
                if (this.mRefCounted ? --this.mRefCount == 0 : this.mHeld) {
                    try {
                        WifiManager.this.mService.releaseMulticastLock(this.mTag);
                        WifiManager wifiManager = WifiManager.this;
                        synchronized (wifiManager) {
                            WifiManager.this.mActiveLockCount--;
                        }
                    }
                    catch (RemoteException e) {
                        throw e.rethrowFromSystemServer();
                    }
                    this.mHeld = false;
                }
                if (this.mRefCount < 0) {
                    throw new RuntimeException("MulticastLock under-locked " + this.mTag);
                }
            }
        }

        public void setReferenceCounted(boolean refCounted) {
            this.mRefCounted = refCounted;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isHeld() {
            IBinder iBinder = this.mBinder;
            synchronized (iBinder) {
                return this.mHeld;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            IBinder iBinder = this.mBinder;
            synchronized (iBinder) {
                String s1 = Integer.toHexString(System.identityHashCode(this));
                String s2 = this.mHeld ? "held; " : "";
                String s3 = this.mRefCounted ? "refcounted: refcount = " + this.mRefCount : "not refcounted";
                return "MulticastLock{ " + s1 + "; " + s2 + s3 + " }";
            }
        }

        protected void finalize() throws Throwable {
            super.finalize();
            this.setReferenceCounted(false);
            this.release();
        }
    }

    public class WifiLock {
        private String mTag;
        private final IBinder mBinder;
        private int mRefCount;
        int mLockType;
        private boolean mRefCounted;
        private boolean mHeld;
        private WorkSource mWorkSource;

        private WifiLock(int lockType, String tag) {
            this.mTag = tag;
            this.mLockType = lockType;
            this.mBinder = new Binder();
            this.mRefCount = 0;
            this.mRefCounted = true;
            this.mHeld = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void acquire() {
            IBinder iBinder = this.mBinder;
            synchronized (iBinder) {
                if (this.mRefCounted ? ++this.mRefCount == 1 : !this.mHeld) {
                    try {
                        WifiManager.this.mService.acquireWifiLock(this.mBinder, this.mLockType, this.mTag, this.mWorkSource);
                        WifiManager wifiManager = WifiManager.this;
                        synchronized (wifiManager) {
                            if (WifiManager.this.mActiveLockCount >= 50) {
                                WifiManager.this.mService.releaseWifiLock(this.mBinder);
                                throw new UnsupportedOperationException("Exceeded maximum number of wifi locks");
                            }
                            WifiManager.this.mActiveLockCount++;
                        }
                    }
                    catch (RemoteException e) {
                        throw e.rethrowFromSystemServer();
                    }
                    this.mHeld = true;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void release() {
            IBinder iBinder = this.mBinder;
            synchronized (iBinder) {
                if (this.mRefCounted ? --this.mRefCount == 0 : this.mHeld) {
                    try {
                        WifiManager.this.mService.releaseWifiLock(this.mBinder);
                        WifiManager wifiManager = WifiManager.this;
                        synchronized (wifiManager) {
                            WifiManager.this.mActiveLockCount--;
                        }
                    }
                    catch (RemoteException e) {
                        throw e.rethrowFromSystemServer();
                    }
                    this.mHeld = false;
                }
                if (this.mRefCount < 0) {
                    throw new RuntimeException("WifiLock under-locked " + this.mTag);
                }
            }
        }

        public void setReferenceCounted(boolean refCounted) {
            this.mRefCounted = refCounted;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isHeld() {
            IBinder iBinder = this.mBinder;
            synchronized (iBinder) {
                return this.mHeld;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setWorkSource(WorkSource ws) {
            IBinder iBinder = this.mBinder;
            synchronized (iBinder) {
                if (ws != null && ws.isEmpty()) {
                    ws = null;
                }
                boolean changed = true;
                if (ws == null) {
                    this.mWorkSource = null;
                } else {
                    ws = ws.withoutNames();
                    if (this.mWorkSource == null) {
                        changed = this.mWorkSource != null;
                        this.mWorkSource = new WorkSource(ws);
                    } else {
                        boolean bl = changed = !this.mWorkSource.equals(ws);
                        if (changed) {
                            this.mWorkSource.set(ws);
                        }
                    }
                }
                if (changed && this.mHeld) {
                    try {
                        WifiManager.this.mService.updateWifiLockWorkSource(this.mBinder, this.mWorkSource);
                    }
                    catch (RemoteException e) {
                        throw e.rethrowFromSystemServer();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            IBinder iBinder = this.mBinder;
            synchronized (iBinder) {
                String s1 = Integer.toHexString(System.identityHashCode(this));
                String s2 = this.mHeld ? "held; " : "";
                String s3 = this.mRefCounted ? "refcounted: refcount = " + this.mRefCount : "not refcounted";
                return "WifiLock{ " + s1 + "; " + s2 + s3 + " }";
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void finalize() throws Throwable {
            super.finalize();
            IBinder iBinder = this.mBinder;
            synchronized (iBinder) {
                if (this.mHeld) {
                    try {
                        WifiManager.this.mService.releaseWifiLock(this.mBinder);
                        WifiManager wifiManager = WifiManager.this;
                        synchronized (wifiManager) {
                            WifiManager.this.mActiveLockCount--;
                        }
                    }
                    catch (RemoteException e) {
                        throw e.rethrowFromSystemServer();
                    }
                }
            }
        }
    }

    private class ActionListenerProxy
    extends IActionListener.Stub {
        private final String mActionTag;
        private final Handler mHandler;
        private final ActionListener mCallback;

        ActionListenerProxy(String actionTag, Looper looper, ActionListener callback2) {
            this.mActionTag = actionTag;
            this.mHandler = new Handler(looper);
            this.mCallback = callback2;
        }

        @Override
        public void onSuccess() {
            if (WifiManager.this.mVerboseLoggingEnabled) {
                Log.v(WifiManager.TAG, "ActionListenerProxy:" + this.mActionTag + ": onSuccess");
            }
            this.mHandler.post(() -> this.mCallback.onSuccess());
        }

        @Override
        public void onFailure(int reason) {
            if (WifiManager.this.mVerboseLoggingEnabled) {
                Log.v(WifiManager.TAG, "ActionListenerProxy:" + this.mActionTag + ": onFailure=" + reason);
            }
            this.mHandler.post(() -> this.mCallback.onFailure(reason));
        }
    }

    private static class LocalOnlyHotspotObserverProxy
    extends ILocalOnlyHotspotCallback.Stub {
        private final WeakReference<WifiManager> mWifiManager;
        private final Executor mExecutor;
        private final LocalOnlyHotspotObserver mObserver;

        LocalOnlyHotspotObserverProxy(WifiManager manager, Executor executor, LocalOnlyHotspotObserver observer) {
            this.mWifiManager = new WeakReference<WifiManager>(manager);
            this.mExecutor = executor;
            this.mObserver = observer;
        }

        public void registered() throws RemoteException {
            WifiManager manager = (WifiManager)this.mWifiManager.get();
            if (manager == null) {
                return;
            }
            this.mExecutor.execute(() -> this.mObserver.onRegistered(manager.new LocalOnlyHotspotSubscription()));
        }

        @Override
        public void onHotspotStarted(SoftApConfiguration config) {
            WifiManager manager = (WifiManager)this.mWifiManager.get();
            if (manager == null) {
                return;
            }
            if (config == null) {
                Log.e(WifiManager.TAG, "LocalOnlyHotspotObserverProxy: config cannot be null.");
                return;
            }
            this.mExecutor.execute(() -> this.mObserver.onStarted(config));
        }

        @Override
        public void onHotspotStopped() {
            WifiManager manager = (WifiManager)this.mWifiManager.get();
            if (manager == null) {
                return;
            }
            this.mExecutor.execute(() -> this.mObserver.onStopped());
        }

        @Override
        public void onHotspotFailed(int reason) {
        }
    }

    public static class LocalOnlyHotspotObserver {
        public void onRegistered(LocalOnlyHotspotSubscription subscription) {
        }

        public void onStarted(SoftApConfiguration config) {
        }

        public void onStopped() {
        }
    }

    public class LocalOnlyHotspotSubscription
    implements AutoCloseable {
        private final CloseGuard mCloseGuard = new CloseGuard();

        @VisibleForTesting
        public LocalOnlyHotspotSubscription() {
            this.mCloseGuard.open("close");
        }

        @Override
        public void close() {
            try {
                WifiManager.this.unregisterLocalOnlyHotspotObserver();
                this.mCloseGuard.close();
            }
            catch (Exception e) {
                Log.e(WifiManager.TAG, "Failed to unregister LocalOnlyHotspotObserver.");
            }
            finally {
                Reference.reachabilityFence(this);
            }
        }

        protected void finalize() throws Throwable {
            try {
                if (this.mCloseGuard != null) {
                    this.mCloseGuard.warnIfOpen();
                }
                this.close();
            }
            finally {
                super.finalize();
            }
        }
    }

    private static class LocalOnlyHotspotCallbackProxy
    extends ILocalOnlyHotspotCallback.Stub {
        private final WeakReference<WifiManager> mWifiManager;
        private final Executor mExecutor;
        private final LocalOnlyHotspotCallback mCallback;

        LocalOnlyHotspotCallbackProxy(WifiManager manager, Executor executor, LocalOnlyHotspotCallback callback2) {
            this.mWifiManager = new WeakReference<WifiManager>(manager);
            this.mExecutor = executor;
            this.mCallback = callback2;
        }

        @Override
        public void onHotspotStarted(SoftApConfiguration config) {
            WifiManager manager = (WifiManager)this.mWifiManager.get();
            if (manager == null) {
                return;
            }
            if (config == null) {
                Log.e(WifiManager.TAG, "LocalOnlyHotspotCallbackProxy: config cannot be null.");
                this.onHotspotFailed(2);
                return;
            }
            WifiManager wifiManager = manager;
            Objects.requireNonNull(wifiManager);
            LocalOnlyHotspotReservation reservation = wifiManager.new LocalOnlyHotspotReservation(config);
            if (this.mCallback == null) {
                return;
            }
            this.mExecutor.execute(() -> this.mCallback.onStarted(reservation));
        }

        @Override
        public void onHotspotStopped() {
            WifiManager manager = (WifiManager)this.mWifiManager.get();
            if (manager == null) {
                return;
            }
            Log.w(WifiManager.TAG, "LocalOnlyHotspotCallbackProxy: hotspot stopped");
            if (this.mCallback == null) {
                return;
            }
            this.mExecutor.execute(() -> this.mCallback.onStopped());
        }

        @Override
        public void onHotspotFailed(int reason) {
            WifiManager manager = (WifiManager)this.mWifiManager.get();
            if (manager == null) {
                return;
            }
            Log.w(WifiManager.TAG, "LocalOnlyHotspotCallbackProxy: failed to start.  reason: " + reason);
            if (this.mCallback == null) {
                return;
            }
            this.mExecutor.execute(() -> this.mCallback.onFailed(reason));
        }
    }

    public static class LocalOnlyHotspotCallback {
        public static final int REQUEST_REGISTERED = 0;
        public static final int ERROR_NO_CHANNEL = 1;
        public static final int ERROR_GENERIC = 2;
        public static final int ERROR_INCOMPATIBLE_MODE = 3;
        public static final int ERROR_TETHERING_DISALLOWED = 4;

        public void onStarted(LocalOnlyHotspotReservation reservation) {
        }

        public void onStopped() {
        }

        public void onFailed(int reason) {
        }
    }

    public class LocalOnlyHotspotReservation
    implements AutoCloseable {
        private final CloseGuard mCloseGuard = new CloseGuard();
        private final SoftApConfiguration mSoftApConfig;
        private final WifiConfiguration mWifiConfig;
        private boolean mClosed = false;

        @VisibleForTesting
        public LocalOnlyHotspotReservation(SoftApConfiguration config) {
            this.mSoftApConfig = config;
            this.mWifiConfig = config.toWifiConfiguration();
            this.mCloseGuard.open("close");
        }

        @Deprecated
        public WifiConfiguration getWifiConfiguration() {
            return this.mWifiConfig;
        }

        public SoftApConfiguration getSoftApConfiguration() {
            return this.mSoftApConfig;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            try {
                Object object = WifiManager.this.mLock;
                synchronized (object) {
                    if (!this.mClosed) {
                        this.mClosed = true;
                        WifiManager.this.stopLocalOnlyHotspot();
                        this.mCloseGuard.close();
                    }
                }
            }
            catch (Exception e) {
                Log.e(WifiManager.TAG, "Failed to stop Local Only Hotspot.");
            }
            finally {
                Reference.reachabilityFence(this);
            }
        }

        protected void finalize() throws Throwable {
            try {
                if (this.mCloseGuard != null) {
                    this.mCloseGuard.warnIfOpen();
                }
                this.close();
            }
            finally {
                super.finalize();
            }
        }
    }

    private class SoftApCallbackProxy
    extends ISoftApCallback.Stub {
        private final Executor mExecutor;
        private final SoftApCallback mCallback;
        private Map<String, List<WifiClient>> mCurrentClients = new HashMap<String, List<WifiClient>>();
        private Map<String, SoftApInfo> mCurrentInfos = new HashMap<String, SoftApInfo>();

        private List<WifiClient> getConnectedClientList(Map<String, List<WifiClient>> clientsMap) {
            ArrayList<WifiClient> connectedClientList = new ArrayList<WifiClient>();
            for (List<WifiClient> it : clientsMap.values()) {
                connectedClientList.addAll(it);
            }
            return connectedClientList;
        }

        SoftApCallbackProxy(Executor executor, SoftApCallback callback2) {
            this.mExecutor = executor;
            this.mCallback = callback2;
        }

        @Override
        public void onStateChanged(int state, int failureReason) {
            if (WifiManager.this.mVerboseLoggingEnabled) {
                Log.v(WifiManager.TAG, "SoftApCallbackProxy: onStateChanged: state=" + state + ", failureReason=" + failureReason);
            }
            Binder.clearCallingIdentity();
            this.mExecutor.execute(() -> this.mCallback.onStateChanged(state, failureReason));
        }

        @Override
        public void onConnectedClientsOrInfoChanged(Map<String, SoftApInfo> infos, Map<String, List<WifiClient>> clients, boolean isBridged, boolean isRegistration) {
            boolean isInfoChanged;
            if (WifiManager.this.mVerboseLoggingEnabled) {
                Log.v(WifiManager.TAG, "SoftApCallbackProxy: onConnectedClientsOrInfoChanged: clients: " + clients + ", infos: " + infos + ", isBridged is " + isBridged + ", isRegistration is " + isRegistration);
            }
            ArrayList<SoftApInfo> changedInfoList = new ArrayList<SoftApInfo>(infos.values());
            HashMap<SoftApInfo, List<WifiClient>> changedInfoClients = new HashMap<SoftApInfo, List<WifiClient>>();
            boolean areClientsChangedWithoutInfosChanged = infos.size() == 0 && this.getConnectedClientList(clients).size() != this.getConnectedClientList(this.mCurrentClients).size();
            boolean bl = isInfoChanged = infos.size() != this.mCurrentInfos.size();
            if (isRegistration) {
                for (SoftApInfo currentInfo : infos.values()) {
                    String instance = currentInfo.getApInstanceIdentifier();
                    if (clients.getOrDefault(instance, Collections.emptyList()).size() <= 0) continue;
                    changedInfoClients.put(currentInfo, clients.get(instance));
                }
            }
            for (SoftApInfo info : this.mCurrentInfos.values()) {
                String changedInstance = info.getApInstanceIdentifier();
                if (!changedInfoList.contains(info)) {
                    isInfoChanged = true;
                    if (this.mCurrentClients.getOrDefault(changedInstance, Collections.emptyList()).size() <= 0) continue;
                    Log.d(WifiManager.TAG, "SoftApCallbackProxy: info changed on client connected instance(Shut Down case)");
                    changedInfoClients.put(info, Collections.emptyList());
                    continue;
                }
                List changedClientList = clients.getOrDefault(changedInstance, Collections.emptyList());
                if (changedClientList.size() == this.mCurrentClients.getOrDefault(changedInstance, Collections.emptyList()).size()) continue;
                changedInfoClients.put(info, changedClientList);
            }
            this.mCurrentClients = clients;
            this.mCurrentInfos = infos;
            if (!isInfoChanged && changedInfoClients.isEmpty() && !isRegistration && !areClientsChangedWithoutInfosChanged) {
                Log.v(WifiManager.TAG, "SoftApCallbackProxy: No changed & Not Registration, don't need to notify the client");
                return;
            }
            Binder.clearCallingIdentity();
            for (SoftApInfo changedInfo : changedInfoClients.keySet()) {
                Log.v(WifiManager.TAG, "SoftApCallbackProxy: send onConnectedClientsChanged, changedInfo is " + changedInfo + " and clients are " + changedInfoClients.get(changedInfo));
                this.mExecutor.execute(() -> this.mCallback.onConnectedClientsChanged(changedInfo, (List)changedInfoClients.get(changedInfo)));
            }
            if (isInfoChanged || isRegistration) {
                if (!isBridged) {
                    SoftApInfo newInfo = changedInfoList.isEmpty() ? new SoftApInfo() : (SoftApInfo)changedInfoList.get(0);
                    Log.v(WifiManager.TAG, "SoftApCallbackProxy: send InfoChanged, newInfo: " + newInfo);
                    this.mExecutor.execute(() -> this.mCallback.onInfoChanged(newInfo));
                }
                Log.v(WifiManager.TAG, "SoftApCallbackProxy: send InfoChanged, changedInfoList: " + changedInfoList);
                this.mExecutor.execute(() -> this.mCallback.onInfoChanged(changedInfoList));
            }
            if (isRegistration || !changedInfoClients.isEmpty() || areClientsChangedWithoutInfosChanged) {
                Log.v(WifiManager.TAG, "SoftApCallbackProxy: send onConnectedClientsChanged(clients): " + this.getConnectedClientList(clients));
                this.mExecutor.execute(() -> this.mCallback.onConnectedClientsChanged(this.getConnectedClientList(clients)));
            }
        }

        @Override
        public void onCapabilityChanged(SoftApCapability capability) {
            if (WifiManager.this.mVerboseLoggingEnabled) {
                Log.v(WifiManager.TAG, "SoftApCallbackProxy: onCapabilityChanged: SoftApCapability=" + capability);
            }
            Binder.clearCallingIdentity();
            this.mExecutor.execute(() -> this.mCallback.onCapabilityChanged(capability));
        }

        @Override
        public void onBlockedClientConnecting(WifiClient client, int blockedReason) {
            if (WifiManager.this.mVerboseLoggingEnabled) {
                Log.v(WifiManager.TAG, "SoftApCallbackProxy: onBlockedClientConnecting: client=" + client + " with reason = " + blockedReason);
            }
            Binder.clearCallingIdentity();
            this.mExecutor.execute(() -> this.mCallback.onBlockedClientConnecting(client, blockedReason));
        }
    }

    @SystemApi
    public static interface SoftApCallback {
        default public void onStateChanged(int state, int failureReason) {
        }

        @Deprecated
        default public void onConnectedClientsChanged(List<WifiClient> clients) {
        }

        default public void onConnectedClientsChanged(SoftApInfo info, List<WifiClient> clients) {
        }

        @Deprecated
        default public void onInfoChanged(SoftApInfo softApInfo) {
        }

        default public void onInfoChanged(List<SoftApInfo> softApInfoList) {
        }

        default public void onCapabilityChanged(SoftApCapability softApCapability) {
        }

        default public void onBlockedClientConnecting(WifiClient client, int blockedReason) {
        }
    }

    public static abstract class WpsCallback {
        public abstract void onStarted(String var1);

        public abstract void onSucceeded();

        public abstract void onFailed(int var1);
    }

    @SystemApi
    public static interface ActionListener {
        public void onSuccess();

        public void onFailure(int var1);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ActionListenerFailureReason {
    }

    @SystemApi
    @RequiresApi(value=31)
    public static abstract class CoexCallback {
        private final CoexCallbackProxy mCoexCallbackProxy;

        public CoexCallback() {
            if (!SdkLevel.isAtLeastS()) {
                throw new UnsupportedOperationException();
            }
            this.mCoexCallbackProxy = new CoexCallbackProxy();
        }

        CoexCallbackProxy getProxy() {
            return this.mCoexCallbackProxy;
        }

        public abstract void onCoexUnsafeChannelsChanged(List<CoexUnsafeChannel> var1, int var2);

        private static class CoexCallbackProxy
        extends ICoexCallback.Stub {
            private final Object mLock = new Object();
            @GuardedBy(value={"mLock"})
            private Executor mExecutor = null;
            @GuardedBy(value={"mLock"})
            private CoexCallback mCallback = null;

            CoexCallbackProxy() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            void initProxy(Executor executor, CoexCallback callback2) {
                Object object = this.mLock;
                synchronized (object) {
                    this.mExecutor = executor;
                    this.mCallback = callback2;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            void cleanUpProxy() {
                Object object = this.mLock;
                synchronized (object) {
                    this.mExecutor = null;
                    this.mCallback = null;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCoexUnsafeChannelsChanged(List<CoexUnsafeChannel> unsafeChannels, int restrictions) {
                CoexCallback callback2;
                Executor executor;
                Object object = this.mLock;
                synchronized (object) {
                    executor = this.mExecutor;
                    callback2 = this.mCallback;
                }
                if (executor == null || callback2 == null) {
                    return;
                }
                Binder.clearCallingIdentity();
                executor.execute(() -> callback2.onCoexUnsafeChannelsChanged(unsafeChannels, restrictions));
            }
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RequiresApi(value=31)
    public static @interface CoexRestriction {
    }

    @RequiresApi(value=31)
    public static abstract class SubsystemRestartTrackingCallback {
        private final SubsystemRestartCallbackProxy mProxy = new SubsystemRestartCallbackProxy();

        SubsystemRestartCallbackProxy getProxy() {
            return this.mProxy;
        }

        public abstract void onSubsystemRestarting();

        public abstract void onSubsystemRestarted();

        private static class SubsystemRestartCallbackProxy
        extends ISubsystemRestartCallback.Stub {
            private final Object mLock = new Object();
            @GuardedBy(value={"mLock"})
            private Executor mExecutor = null;
            @GuardedBy(value={"mLock"})
            private SubsystemRestartTrackingCallback mCallback = null;

            SubsystemRestartCallbackProxy() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            void initProxy(Executor executor, SubsystemRestartTrackingCallback callback2) {
                Object object = this.mLock;
                synchronized (object) {
                    this.mExecutor = executor;
                    this.mCallback = callback2;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            void cleanUpProxy() {
                Object object = this.mLock;
                synchronized (object) {
                    this.mExecutor = null;
                    this.mCallback = null;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSubsystemRestarting() {
                SubsystemRestartTrackingCallback callback2;
                Executor executor;
                Object object = this.mLock;
                synchronized (object) {
                    executor = this.mExecutor;
                    callback2 = this.mCallback;
                }
                if (executor == null || callback2 == null) {
                    return;
                }
                Binder.clearCallingIdentity();
                executor.execute(callback2::onSubsystemRestarting);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSubsystemRestarted() {
                SubsystemRestartTrackingCallback callback2;
                Executor executor;
                Object object = this.mLock;
                synchronized (object) {
                    executor = this.mExecutor;
                    callback2 = this.mCallback;
                }
                if (executor == null || callback2 == null) {
                    return;
                }
                Binder.clearCallingIdentity();
                executor.execute(callback2::onSubsystemRestarted);
            }
        }
    }

    private static class OnWifiActivityEnergyInfoProxy
    extends IOnWifiActivityEnergyInfoListener.Stub {
        private final Object mLock = new Object();
        @GuardedBy(value={"mLock"})
        private Executor mExecutor;
        @GuardedBy(value={"mLock"})
        private OnWifiActivityEnergyInfoListener mListener;

        OnWifiActivityEnergyInfoProxy(Executor executor, OnWifiActivityEnergyInfoListener listener2) {
            this.mExecutor = executor;
            this.mListener = listener2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onWifiActivityEnergyInfo(WifiActivityEnergyInfo info) {
            OnWifiActivityEnergyInfoListener listener2;
            Executor executor;
            Object object = this.mLock;
            synchronized (object) {
                if (this.mExecutor == null || this.mListener == null) {
                    return;
                }
                executor = this.mExecutor;
                listener2 = this.mListener;
                this.mExecutor = null;
                this.mListener = null;
            }
            Binder.clearCallingIdentity();
            executor.execute(() -> listener2.onWifiActivityEnergyInfo(info));
        }
    }

    @SystemApi
    public static interface OnWifiActivityEnergyInfoListener {
        public void onWifiActivityEnergyInfo(WifiActivityEnergyInfo var1);
    }

    private class NetworkRequestMatchCallbackProxy
    extends INetworkRequestMatchCallback.Stub {
        private final Executor mExecutor;
        private final NetworkRequestMatchCallback mCallback;

        NetworkRequestMatchCallbackProxy(Executor executor, NetworkRequestMatchCallback callback2) {
            this.mExecutor = executor;
            this.mCallback = callback2;
        }

        @Override
        public void onUserSelectionCallbackRegistration(INetworkRequestUserSelectionCallback userSelectionCallback) {
            if (WifiManager.this.mVerboseLoggingEnabled) {
                Log.v(WifiManager.TAG, "NetworkRequestMatchCallbackProxy: onUserSelectionCallbackRegistration callback: " + userSelectionCallback);
            }
            Binder.clearCallingIdentity();
            this.mExecutor.execute(() -> this.mCallback.onUserSelectionCallbackRegistration(new NetworkRequestUserSelectionCallbackProxy(userSelectionCallback)));
        }

        @Override
        public void onAbort() {
            if (WifiManager.this.mVerboseLoggingEnabled) {
                Log.v(WifiManager.TAG, "NetworkRequestMatchCallbackProxy: onAbort");
            }
            Binder.clearCallingIdentity();
            this.mExecutor.execute(() -> this.mCallback.onAbort());
        }

        @Override
        public void onMatch(List<ScanResult> scanResults) {
            if (WifiManager.this.mVerboseLoggingEnabled) {
                Log.v(WifiManager.TAG, "NetworkRequestMatchCallbackProxy: onMatch scanResults: " + scanResults);
            }
            Binder.clearCallingIdentity();
            this.mExecutor.execute(() -> this.mCallback.onMatch(scanResults));
        }

        @Override
        public void onUserSelectionConnectSuccess(WifiConfiguration wifiConfiguration) {
            if (WifiManager.this.mVerboseLoggingEnabled) {
                Log.v(WifiManager.TAG, "NetworkRequestMatchCallbackProxy: onUserSelectionConnectSuccess  wificonfiguration: " + wifiConfiguration);
            }
            Binder.clearCallingIdentity();
            this.mExecutor.execute(() -> this.mCallback.onUserSelectionConnectSuccess(wifiConfiguration));
        }

        @Override
        public void onUserSelectionConnectFailure(WifiConfiguration wifiConfiguration) {
            if (WifiManager.this.mVerboseLoggingEnabled) {
                Log.v(WifiManager.TAG, "NetworkRequestMatchCallbackProxy: onUserSelectionConnectFailure wificonfiguration: " + wifiConfiguration);
            }
            Binder.clearCallingIdentity();
            this.mExecutor.execute(() -> this.mCallback.onUserSelectionConnectFailure(wifiConfiguration));
        }
    }

    private class NetworkRequestUserSelectionCallbackProxy
    implements NetworkRequestUserSelectionCallback {
        private final INetworkRequestUserSelectionCallback mCallback;

        NetworkRequestUserSelectionCallbackProxy(INetworkRequestUserSelectionCallback callback2) {
            this.mCallback = callback2;
        }

        @Override
        public void select(WifiConfiguration wifiConfiguration) {
            if (WifiManager.this.mVerboseLoggingEnabled) {
                Log.v(WifiManager.TAG, "NetworkRequestUserSelectionCallbackProxy: select wificonfiguration: " + wifiConfiguration);
            }
            try {
                this.mCallback.select(wifiConfiguration);
            }
            catch (RemoteException e) {
                Log.e(WifiManager.TAG, "Failed to invoke onSelected", e);
                throw e.rethrowFromSystemServer();
            }
        }

        @Override
        public void reject() {
            if (WifiManager.this.mVerboseLoggingEnabled) {
                Log.v(WifiManager.TAG, "NetworkRequestUserSelectionCallbackProxy: reject");
            }
            try {
                this.mCallback.reject();
            }
            catch (RemoteException e) {
                Log.e(WifiManager.TAG, "Failed to invoke onRejected", e);
                throw e.rethrowFromSystemServer();
            }
        }
    }

    @SystemApi
    public static interface NetworkRequestMatchCallback {
        default public void onUserSelectionCallbackRegistration(NetworkRequestUserSelectionCallback userSelectionCallback) {
        }

        default public void onAbort() {
        }

        default public void onMatch(List<ScanResult> scanResults) {
        }

        default public void onUserSelectionConnectSuccess(WifiConfiguration wifiConfiguration) {
        }

        default public void onUserSelectionConnectFailure(WifiConfiguration wifiConfiguration) {
        }
    }

    @SystemApi
    public static interface NetworkRequestUserSelectionCallback {
        @SuppressLint(value={"CallbackMethodName"})
        default public void select(WifiConfiguration wifiConfiguration) {
        }

        @SuppressLint(value={"CallbackMethodName"})
        default public void reject() {
        }
    }

    public static class AddNetworkResult
    implements Parcelable {
        public static final int STATUS_SUCCESS = 0;
        public static final int STATUS_FAILURE_UNKNOWN = 1;
        public static final int STATUS_NO_PERMISSION = 2;
        public static final int STATUS_ADD_PASSPOINT_FAILURE = 3;
        public static final int STATUS_ADD_WIFI_CONFIG_FAILURE = 4;
        public static final int STATUS_INVALID_CONFIGURATION = 5;
        public static final int STATUS_NO_PERMISSION_MODIFY_CONFIG = 6;
        public static final int STATUS_NO_PERMISSION_MODIFY_PROXY_SETTING = 7;
        public static final int STATUS_NO_PERMISSION_MODIFY_MAC_RANDOMIZATION = 8;
        public static final int STATUS_FAILURE_UPDATE_NETWORK_KEYS = 9;
        public static final int STATUS_INVALID_CONFIGURATION_ENTERPRISE = 10;
        public static final Parcelable.Creator<AddNetworkResult> CREATOR = new Parcelable.Creator<AddNetworkResult>(){

            @Override
            public AddNetworkResult createFromParcel(Parcel in) {
                return new AddNetworkResult(in.readInt(), in.readInt());
            }

            public AddNetworkResult[] newArray(int size) {
                return new AddNetworkResult[size];
            }
        };
        public final int statusCode;
        public final int networkId;

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.statusCode);
            dest.writeInt(this.networkId);
        }

        public AddNetworkResult(int statusCode, int networkId) {
            this.statusCode = statusCode;
            this.networkId = networkId;
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface AddNetworkStatusCode {
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface IfaceIpMode {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SapClientBlockedReason {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SapStartFailure {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface WifiApState {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SuggestionUserApprovalStatus {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SuggestionConnectionStatusCode {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface NetworkSuggestionsStatusCode {
    }
}

