/*
 * Decompiled with CFR 0.152.
 */
package android.net.lowpan;

import android.net.lowpan.LowpanCredential;
import android.net.lowpan.LowpanIdentity;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.Objects;

public class LowpanProvision
implements Parcelable {
    private LowpanIdentity mIdentity = new LowpanIdentity();
    private LowpanCredential mCredential = null;
    public static final Parcelable.Creator<LowpanProvision> CREATOR = new Parcelable.Creator<LowpanProvision>(){

        @Override
        public LowpanProvision createFromParcel(Parcel in) {
            Builder builder2 = new Builder();
            builder2.setLowpanIdentity(LowpanIdentity.CREATOR.createFromParcel(in));
            if (in.readBoolean()) {
                builder2.setLowpanCredential(LowpanCredential.CREATOR.createFromParcel(in));
            }
            return builder2.build();
        }

        public LowpanProvision[] newArray(int size) {
            return new LowpanProvision[size];
        }
    };

    private LowpanProvision() {
    }

    public LowpanIdentity getLowpanIdentity() {
        return this.mIdentity;
    }

    public LowpanCredential getLowpanCredential() {
        return this.mCredential;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("LowpanProvision { identity => ").append(this.mIdentity.toString());
        if (this.mCredential != null) {
            sb.append(", credential => ").append(this.mCredential.toString());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        return Objects.hash(this.mIdentity, this.mCredential);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof LowpanProvision)) {
            return false;
        }
        LowpanProvision rhs = (LowpanProvision)obj;
        if (!this.mIdentity.equals(rhs.mIdentity)) {
            return false;
        }
        return Objects.equals(this.mCredential, rhs.mCredential);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        this.mIdentity.writeToParcel(dest, flags);
        if (this.mCredential == null) {
            dest.writeBoolean(false);
        } else {
            dest.writeBoolean(true);
            this.mCredential.writeToParcel(dest, flags);
        }
    }

    public static class Builder {
        private final LowpanProvision provision = new LowpanProvision();

        public Builder setLowpanIdentity(LowpanIdentity identity) {
            this.provision.mIdentity = identity;
            return this;
        }

        public Builder setLowpanCredential(LowpanCredential credential) {
            this.provision.mCredential = credential;
            return this;
        }

        public LowpanProvision build() {
            return this.provision;
        }
    }
}

