/*
 * Decompiled with CFR 0.152.
 */
package android.net.lowpan;

import android.content.Context;
import android.net.IpPrefix;
import android.net.LinkAddress;
import android.net.lowpan.ILowpanInterface;
import android.net.lowpan.ILowpanInterfaceListener;
import android.net.lowpan.LowpanBeaconInfo;
import android.net.lowpan.LowpanChannelInfo;
import android.net.lowpan.LowpanCommissioningSession;
import android.net.lowpan.LowpanCredential;
import android.net.lowpan.LowpanException;
import android.net.lowpan.LowpanIdentity;
import android.net.lowpan.LowpanProvision;
import android.net.lowpan.LowpanScanner;
import android.os.DeadObjectException;
import android.os.Handler;
import android.os.Looper;
import android.os.RemoteException;
import android.os.ServiceSpecificException;
import android.util.Log;
import java.util.HashMap;

public class LowpanInterface {
    private static final String TAG = LowpanInterface.class.getSimpleName();
    public static final String ROLE_DETACHED = "detached";
    public static final String ROLE_END_DEVICE = "end-device";
    public static final String ROLE_ROUTER = "router";
    public static final String ROLE_SLEEPY_END_DEVICE = "sleepy-end-device";
    public static final String ROLE_SLEEPY_ROUTER = "sleepy-router";
    public static final String ROLE_LEADER = "leader";
    public static final String ROLE_COORDINATOR = "coordinator";
    public static final String STATE_OFFLINE = "offline";
    public static final String STATE_COMMISSIONING = "commissioning";
    public static final String STATE_ATTACHING = "attaching";
    public static final String STATE_ATTACHED = "attached";
    public static final String STATE_FAULT = "fault";
    public static final String NETWORK_TYPE_THREAD_V1 = "org.threadgroup.thread.v1";
    public static final String EMPTY_PARTITION_ID = "";
    private final ILowpanInterface mBinder;
    private final Looper mLooper;
    private final HashMap<Integer, ILowpanInterfaceListener> mListenerMap = new HashMap();

    public LowpanInterface(Context context, ILowpanInterface service, Looper looper) {
        this.mBinder = service;
        this.mLooper = looper;
    }

    public ILowpanInterface getService() {
        return this.mBinder;
    }

    public void form(LowpanProvision provision) throws LowpanException {
        try {
            this.mBinder.form(provision);
        }
        catch (RemoteException x) {
            throw x.rethrowAsRuntimeException();
        }
        catch (ServiceSpecificException x) {
            throw LowpanException.rethrowFromServiceSpecificException(x);
        }
    }

    public void join(LowpanProvision provision) throws LowpanException {
        try {
            this.mBinder.join(provision);
        }
        catch (RemoteException x) {
            throw x.rethrowAsRuntimeException();
        }
        catch (ServiceSpecificException x) {
            throw LowpanException.rethrowFromServiceSpecificException(x);
        }
    }

    public void attach(LowpanProvision provision) throws LowpanException {
        try {
            this.mBinder.attach(provision);
        }
        catch (RemoteException x) {
            throw x.rethrowAsRuntimeException();
        }
        catch (ServiceSpecificException x) {
            throw LowpanException.rethrowFromServiceSpecificException(x);
        }
    }

    public void leave() throws LowpanException {
        try {
            this.mBinder.leave();
        }
        catch (RemoteException x) {
            throw x.rethrowAsRuntimeException();
        }
        catch (ServiceSpecificException x) {
            throw LowpanException.rethrowFromServiceSpecificException(x);
        }
    }

    public LowpanCommissioningSession startCommissioningSession(LowpanBeaconInfo beaconInfo) throws LowpanException {
        try {
            this.mBinder.startCommissioningSession(beaconInfo);
            return new LowpanCommissioningSession(this.mBinder, beaconInfo, this.mLooper);
        }
        catch (RemoteException x) {
            throw x.rethrowAsRuntimeException();
        }
        catch (ServiceSpecificException x) {
            throw LowpanException.rethrowFromServiceSpecificException(x);
        }
    }

    public void reset() throws LowpanException {
        try {
            this.mBinder.reset();
        }
        catch (RemoteException x) {
            throw x.rethrowAsRuntimeException();
        }
        catch (ServiceSpecificException x) {
            throw LowpanException.rethrowFromServiceSpecificException(x);
        }
    }

    public String getName() {
        try {
            return this.mBinder.getName();
        }
        catch (DeadObjectException x) {
            return EMPTY_PARTITION_ID;
        }
        catch (RemoteException x) {
            throw x.rethrowAsRuntimeException();
        }
    }

    public boolean isEnabled() {
        try {
            return this.mBinder.isEnabled();
        }
        catch (DeadObjectException x) {
            return false;
        }
        catch (RemoteException x) {
            throw x.rethrowAsRuntimeException();
        }
    }

    public void setEnabled(boolean enabled) throws LowpanException {
        try {
            this.mBinder.setEnabled(enabled);
        }
        catch (RemoteException x) {
            throw x.rethrowAsRuntimeException();
        }
        catch (ServiceSpecificException x) {
            throw LowpanException.rethrowFromServiceSpecificException(x);
        }
    }

    public boolean isUp() {
        try {
            return this.mBinder.isUp();
        }
        catch (DeadObjectException x) {
            return false;
        }
        catch (RemoteException x) {
            throw x.rethrowAsRuntimeException();
        }
    }

    public boolean isConnected() {
        try {
            return this.mBinder.isConnected();
        }
        catch (DeadObjectException x) {
            return false;
        }
        catch (RemoteException x) {
            throw x.rethrowAsRuntimeException();
        }
    }

    public boolean isCommissioned() {
        try {
            return this.mBinder.isCommissioned();
        }
        catch (DeadObjectException x) {
            return false;
        }
        catch (RemoteException x) {
            throw x.rethrowAsRuntimeException();
        }
    }

    public String getState() {
        try {
            return this.mBinder.getState();
        }
        catch (DeadObjectException x) {
            return STATE_FAULT;
        }
        catch (RemoteException x) {
            throw x.rethrowAsRuntimeException();
        }
    }

    public String getPartitionId() {
        try {
            return this.mBinder.getPartitionId();
        }
        catch (DeadObjectException x) {
            return EMPTY_PARTITION_ID;
        }
        catch (RemoteException x) {
            throw x.rethrowAsRuntimeException();
        }
    }

    public LowpanIdentity getLowpanIdentity() {
        try {
            return this.mBinder.getLowpanIdentity();
        }
        catch (DeadObjectException x) {
            return new LowpanIdentity();
        }
        catch (RemoteException x) {
            throw x.rethrowAsRuntimeException();
        }
    }

    public String getRole() {
        try {
            return this.mBinder.getRole();
        }
        catch (DeadObjectException x) {
            return ROLE_DETACHED;
        }
        catch (RemoteException x) {
            throw x.rethrowAsRuntimeException();
        }
    }

    public LowpanCredential getLowpanCredential() {
        try {
            return this.mBinder.getLowpanCredential();
        }
        catch (RemoteException x) {
            throw x.rethrowAsRuntimeException();
        }
    }

    public String[] getSupportedNetworkTypes() throws LowpanException {
        try {
            return this.mBinder.getSupportedNetworkTypes();
        }
        catch (RemoteException x) {
            throw x.rethrowAsRuntimeException();
        }
        catch (ServiceSpecificException x) {
            throw LowpanException.rethrowFromServiceSpecificException(x);
        }
    }

    public LowpanChannelInfo[] getSupportedChannels() throws LowpanException {
        try {
            return this.mBinder.getSupportedChannels();
        }
        catch (RemoteException x) {
            throw x.rethrowAsRuntimeException();
        }
        catch (ServiceSpecificException x) {
            throw LowpanException.rethrowFromServiceSpecificException(x);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerCallback(final Callback cb, final Handler handler) {
        ILowpanInterfaceListener.Stub listenerBinder = new ILowpanInterfaceListener.Stub(){
            private Handler mHandler;
            {
                this.mHandler = handler != null ? handler : (LowpanInterface.this.mLooper != null ? new Handler(LowpanInterface.this.mLooper) : new Handler());
            }

            @Override
            public void onEnabledChanged(boolean value2) {
                this.mHandler.post(() -> cb.onEnabledChanged(value2));
            }

            @Override
            public void onConnectedChanged(boolean value2) {
                this.mHandler.post(() -> cb.onConnectedChanged(value2));
            }

            @Override
            public void onUpChanged(boolean value2) {
                this.mHandler.post(() -> cb.onUpChanged(value2));
            }

            @Override
            public void onRoleChanged(String value2) {
                this.mHandler.post(() -> cb.onRoleChanged(value2));
            }

            @Override
            public void onStateChanged(String value2) {
                this.mHandler.post(() -> cb.onStateChanged(value2));
            }

            @Override
            public void onLowpanIdentityChanged(LowpanIdentity value2) {
                this.mHandler.post(() -> cb.onLowpanIdentityChanged(value2));
            }

            @Override
            public void onLinkNetworkAdded(IpPrefix value2) {
                this.mHandler.post(() -> cb.onLinkNetworkAdded(value2));
            }

            @Override
            public void onLinkNetworkRemoved(IpPrefix value2) {
                this.mHandler.post(() -> cb.onLinkNetworkRemoved(value2));
            }

            @Override
            public void onLinkAddressAdded(String value2) {
                LinkAddress la;
                try {
                    la = new LinkAddress(value2);
                }
                catch (IllegalArgumentException x) {
                    Log.e(TAG, "onLinkAddressAdded: Bad LinkAddress \"" + value2 + "\", " + x);
                    return;
                }
                this.mHandler.post(() -> cb.onLinkAddressAdded(la));
            }

            @Override
            public void onLinkAddressRemoved(String value2) {
                LinkAddress la;
                try {
                    la = new LinkAddress(value2);
                }
                catch (IllegalArgumentException x) {
                    Log.e(TAG, "onLinkAddressRemoved: Bad LinkAddress \"" + value2 + "\", " + x);
                    return;
                }
                this.mHandler.post(() -> cb.onLinkAddressRemoved(la));
            }

            @Override
            public void onReceiveFromCommissioner(byte[] packet) {
            }
        };
        try {
            this.mBinder.addListener(listenerBinder);
        }
        catch (RemoteException x) {
            throw x.rethrowAsRuntimeException();
        }
        HashMap<Integer, ILowpanInterfaceListener> hashMap = this.mListenerMap;
        synchronized (hashMap) {
            this.mListenerMap.put(System.identityHashCode(cb), listenerBinder);
        }
    }

    public void registerCallback(Callback cb) {
        this.registerCallback(cb, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterCallback(Callback cb) {
        int hashCode = System.identityHashCode(cb);
        HashMap<Integer, ILowpanInterfaceListener> hashMap = this.mListenerMap;
        synchronized (hashMap) {
            ILowpanInterfaceListener listenerBinder = this.mListenerMap.get(hashCode);
            if (listenerBinder != null) {
                this.mListenerMap.remove(hashCode);
                try {
                    this.mBinder.removeListener(listenerBinder);
                }
                catch (DeadObjectException deadObjectException) {
                }
                catch (RemoteException x) {
                    throw x.rethrowAsRuntimeException();
                }
            }
        }
    }

    public LowpanScanner createScanner() {
        return new LowpanScanner(this.mBinder);
    }

    public LinkAddress[] getLinkAddresses() throws LowpanException {
        try {
            String[] linkAddressStrings = this.mBinder.getLinkAddresses();
            LinkAddress[] ret = new LinkAddress[linkAddressStrings.length];
            int i = 0;
            for (String str : linkAddressStrings) {
                ret[i++] = new LinkAddress(str);
            }
            return ret;
        }
        catch (RemoteException x) {
            throw x.rethrowAsRuntimeException();
        }
        catch (ServiceSpecificException x) {
            throw LowpanException.rethrowFromServiceSpecificException(x);
        }
    }

    public IpPrefix[] getLinkNetworks() throws LowpanException {
        try {
            return this.mBinder.getLinkNetworks();
        }
        catch (RemoteException x) {
            throw x.rethrowAsRuntimeException();
        }
        catch (ServiceSpecificException x) {
            throw LowpanException.rethrowFromServiceSpecificException(x);
        }
    }

    public void addOnMeshPrefix(IpPrefix prefix, int flags) throws LowpanException {
        try {
            this.mBinder.addOnMeshPrefix(prefix, flags);
        }
        catch (RemoteException x) {
            throw x.rethrowAsRuntimeException();
        }
        catch (ServiceSpecificException x) {
            throw LowpanException.rethrowFromServiceSpecificException(x);
        }
    }

    public void removeOnMeshPrefix(IpPrefix prefix) {
        try {
            this.mBinder.removeOnMeshPrefix(prefix);
        }
        catch (RemoteException x) {
            throw x.rethrowAsRuntimeException();
        }
        catch (ServiceSpecificException x) {
            Log.e(TAG, x.toString());
        }
    }

    public void addExternalRoute(IpPrefix prefix, int flags) throws LowpanException {
        try {
            this.mBinder.addExternalRoute(prefix, flags);
        }
        catch (RemoteException x) {
            throw x.rethrowAsRuntimeException();
        }
        catch (ServiceSpecificException x) {
            throw LowpanException.rethrowFromServiceSpecificException(x);
        }
    }

    public void removeExternalRoute(IpPrefix prefix) {
        try {
            this.mBinder.removeExternalRoute(prefix);
        }
        catch (RemoteException x) {
            throw x.rethrowAsRuntimeException();
        }
        catch (ServiceSpecificException x) {
            Log.e(TAG, x.toString());
        }
    }

    public static abstract class Callback {
        public void onConnectedChanged(boolean value2) {
        }

        public void onEnabledChanged(boolean value2) {
        }

        public void onUpChanged(boolean value2) {
        }

        public void onRoleChanged(String value2) {
        }

        public void onStateChanged(String state) {
        }

        public void onLowpanIdentityChanged(LowpanIdentity value2) {
        }

        public void onLinkNetworkAdded(IpPrefix prefix) {
        }

        public void onLinkNetworkRemoved(IpPrefix prefix) {
        }

        public void onLinkAddressAdded(LinkAddress address) {
        }

        public void onLinkAddressRemoved(LinkAddress address) {
        }
    }
}

