/*
 * Decompiled with CFR 0.152.
 */
package android.net.ipsec.ike;

import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.net.LinkAddress;
import android.net.ipsec.ike.ChildSaProposal;
import android.net.ipsec.ike.ChildSessionParams;
import android.net.ipsec.ike.IkeTrafficSelector;
import android.os.PersistableBundle;
import android.system.OsConstants;
import com.android.internal.net.ipsec.ike.message.IkeConfigPayload;
import com.android.internal.net.vcn.util.PersistableBundleUtils;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class TunnelModeChildSessionParams
extends ChildSessionParams {
    private static final String CONFIG_ATTRIBUTES_KEY = "mConfigRequests";
    private final IkeConfigPayload.TunnelModeChildConfigAttribute[] mConfigRequests;

    private TunnelModeChildSessionParams(IkeTrafficSelector[] inboundTs, IkeTrafficSelector[] outboundTs, ChildSaProposal[] proposals, IkeConfigPayload.TunnelModeChildConfigAttribute[] configRequests, int hardLifetimeSec, int softLifetimeSec) {
        super(inboundTs, outboundTs, proposals, hardLifetimeSec, softLifetimeSec, false);
        this.mConfigRequests = configRequests;
    }

    public static TunnelModeChildSessionParams fromPersistableBundle(PersistableBundle in) {
        Objects.requireNonNull(in, "PersistableBundle not provided");
        Builder builder2 = new Builder();
        for (ChildSaProposal p : TunnelModeChildSessionParams.getProposalsFromPersistableBundle(in)) {
            builder2.addSaProposal(p);
        }
        for (IkeTrafficSelector ts : TunnelModeChildSessionParams.getTsFromPersistableBundle(in, "mInboundTrafficSelectors")) {
            builder2.addInboundTrafficSelectors(ts);
        }
        for (IkeTrafficSelector ts : TunnelModeChildSessionParams.getTsFromPersistableBundle(in, "mOutboundTrafficSelectors")) {
            builder2.addOutboundTrafficSelectors(ts);
        }
        builder2.setLifetimeSeconds(in.getInt("mHardLifetimeSec"), in.getInt("mSoftLifetimeSec"));
        PersistableBundle configAttributeBundle = in.getPersistableBundle(CONFIG_ATTRIBUTES_KEY);
        List<IkeConfigPayload.ConfigAttribute> configReqList = PersistableBundleUtils.toList(configAttributeBundle, IkeConfigPayload.ConfigAttribute::fromPersistableBundle);
        for (IkeConfigPayload.ConfigAttribute a : configReqList) {
            builder2.addConfigRequest((IkeConfigPayload.TunnelModeChildConfigAttribute)a);
        }
        return builder2.build();
    }

    @Override
    public PersistableBundle toPersistableBundle() {
        PersistableBundle result = super.toPersistableBundle();
        PersistableBundle configAttributeBundle = PersistableBundleUtils.fromList(Arrays.asList(this.mConfigRequests), IkeConfigPayload.ConfigAttribute::toPersistableBundle);
        result.putPersistableBundle(CONFIG_ATTRIBUTES_KEY, configAttributeBundle);
        return result;
    }

    public IkeConfigPayload.TunnelModeChildConfigAttribute[] getConfigurationAttributesInternal() {
        return this.mConfigRequests;
    }

    public List<TunnelModeChildConfigRequest> getConfigurationRequests() {
        return Collections.unmodifiableList(Arrays.asList(this.mConfigRequests));
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), Arrays.hashCode(this.mConfigRequests));
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o) || !(o instanceof ChildSessionParams)) {
            return false;
        }
        TunnelModeChildSessionParams other = (TunnelModeChildSessionParams)o;
        return Arrays.equals(this.mConfigRequests, other.mConfigRequests);
    }

    public static class Builder
    extends ChildSessionParams.Builder {
        private static final int IPv4_DEFAULT_PREFIX_LEN = 32;
        private boolean mHasIp4AddressRequest;
        private boolean mHasIp4NetmaskRequest;
        private List<IkeConfigPayload.TunnelModeChildConfigAttribute> mConfigRequestList = new ArrayList<IkeConfigPayload.TunnelModeChildConfigAttribute>();

        public Builder() {
            this.mHasIp4AddressRequest = false;
            this.mHasIp4NetmaskRequest = false;
        }

        public Builder(TunnelModeChildSessionParams childParams) {
            super(childParams);
            this.mConfigRequestList.addAll(Arrays.asList(childParams.mConfigRequests));
            for (IkeConfigPayload.TunnelModeChildConfigAttribute config : this.mConfigRequestList) {
                if (config instanceof IkeConfigPayload.ConfigAttributeIpv4Address) {
                    this.mHasIp4AddressRequest = true;
                    continue;
                }
                if (!(config instanceof IkeConfigPayload.ConfigAttributeIpv4Netmask)) continue;
                this.mHasIp4NetmaskRequest = true;
            }
        }

        @Deprecated
        @SystemApi
        @SuppressLint(value={"MissingGetterMatchingBuilder"})
        public Builder addSaProposal(ChildSaProposal proposal) {
            return this.addChildSaProposal(proposal);
        }

        @SuppressLint(value={"MissingGetterMatchingBuilder"})
        public Builder addChildSaProposal(ChildSaProposal proposal) {
            if (proposal == null) {
                throw new NullPointerException("Required argument not provided");
            }
            this.addProposal(proposal);
            return this;
        }

        @SuppressLint(value={"MissingGetterMatchingBuilder"})
        public Builder addInboundTrafficSelectors(IkeTrafficSelector trafficSelector) {
            Objects.requireNonNull(trafficSelector, "Required argument not provided");
            this.addInboundTs(trafficSelector);
            return this;
        }

        @SuppressLint(value={"MissingGetterMatchingBuilder"})
        public Builder addOutboundTrafficSelectors(IkeTrafficSelector trafficSelector) {
            Objects.requireNonNull(trafficSelector, "Required argument not provided");
            this.addOutboundTs(trafficSelector);
            return this;
        }

        @SuppressLint(value={"MissingGetterMatchingBuilder"})
        public Builder setLifetimeSeconds(int hardLifetimeSeconds, int softLifetimeSeconds) {
            this.validateAndSetLifetime(hardLifetimeSeconds, softLifetimeSeconds);
            this.mHardLifetimeSec = hardLifetimeSeconds;
            this.mSoftLifetimeSec = softLifetimeSeconds;
            return this;
        }

        @SuppressLint(value={"MissingGetterMatchingBuilder"})
        public Builder addInternalAddressRequest(int addressFamily) {
            if (addressFamily == OsConstants.AF_INET) {
                this.mHasIp4AddressRequest = true;
                this.mConfigRequestList.add(new IkeConfigPayload.ConfigAttributeIpv4Address());
                return this;
            }
            if (addressFamily == OsConstants.AF_INET6) {
                this.mConfigRequestList.add(new IkeConfigPayload.ConfigAttributeIpv6Address());
                return this;
            }
            throw new IllegalArgumentException("Invalid address family: " + addressFamily);
        }

        @SuppressLint(value={"MissingGetterMatchingBuilder"})
        public Builder addInternalAddressRequest(Inet4Address address) {
            if (address == null) {
                throw new NullPointerException("Required argument not provided");
            }
            this.mHasIp4AddressRequest = true;
            this.mConfigRequestList.add(new IkeConfigPayload.ConfigAttributeIpv4Address(address));
            return this;
        }

        @SuppressLint(value={"MissingGetterMatchingBuilder"})
        public Builder addInternalAddressRequest(Inet6Address address, int prefixLen) {
            if (address == null) {
                throw new NullPointerException("Required argument not provided");
            }
            this.mConfigRequestList.add(new IkeConfigPayload.ConfigAttributeIpv6Address(new LinkAddress(address, prefixLen)));
            return this;
        }

        @SuppressLint(value={"MissingGetterMatchingBuilder"})
        public Builder addInternalDnsServerRequest(int addressFamily) {
            if (addressFamily == OsConstants.AF_INET) {
                this.mConfigRequestList.add(new IkeConfigPayload.ConfigAttributeIpv4Dns());
                return this;
            }
            if (addressFamily == OsConstants.AF_INET6) {
                this.mConfigRequestList.add(new IkeConfigPayload.ConfigAttributeIpv6Dns());
                return this;
            }
            throw new IllegalArgumentException("Invalid address family: " + addressFamily);
        }

        public Builder addInternalDnsServerRequest(InetAddress address) {
            if (address == null) {
                throw new NullPointerException("Required argument not provided");
            }
            if (address instanceof Inet4Address) {
                this.mConfigRequestList.add(new IkeConfigPayload.ConfigAttributeIpv4Dns((Inet4Address)address));
                return this;
            }
            if (address instanceof Inet6Address) {
                this.mConfigRequestList.add(new IkeConfigPayload.ConfigAttributeIpv6Dns((Inet6Address)address));
                return this;
            }
            throw new IllegalArgumentException("Invalid address " + address);
        }

        @SuppressLint(value={"MissingGetterMatchingBuilder"})
        public Builder addInternalDhcpServerRequest(int addressFamily) {
            if (addressFamily == OsConstants.AF_INET) {
                this.mConfigRequestList.add(new IkeConfigPayload.ConfigAttributeIpv4Dhcp());
                return this;
            }
            throw new IllegalArgumentException("Invalid address family: " + addressFamily);
        }

        public Builder addInternalDhcpServerRequest(InetAddress address) {
            if (address == null) {
                throw new NullPointerException("Required argument not provided");
            }
            if (address instanceof Inet4Address) {
                this.mConfigRequestList.add(new IkeConfigPayload.ConfigAttributeIpv4Dhcp((Inet4Address)address));
                return this;
            }
            throw new IllegalArgumentException("Invalid address " + address);
        }

        public Builder addConfigRequest(IkeConfigPayload.TunnelModeChildConfigAttribute attribute) {
            if (attribute instanceof IkeConfigPayload.ConfigAttributeIpv4Address) {
                this.mHasIp4AddressRequest = true;
            } else if (attribute instanceof IkeConfigPayload.ConfigAttributeIpv4Netmask) {
                if (((IkeConfigPayload.ConfigAttributeIpv4Netmask)attribute).address != null) {
                    throw new IllegalArgumentException("Requesting specific a netmask is disallowed");
                }
                this.mHasIp4NetmaskRequest = true;
            }
            this.mConfigRequestList.add(attribute);
            return this;
        }

        public TunnelModeChildSessionParams build() {
            this.addDefaultTsIfNotConfigured();
            this.validateOrThrow();
            if (!this.mHasIp4AddressRequest && this.mHasIp4NetmaskRequest) {
                throw new IllegalArgumentException("Requesting netmask without IPv4 address is disallowed");
            }
            if (this.mHasIp4AddressRequest && !this.mHasIp4NetmaskRequest) {
                this.mConfigRequestList.add(new IkeConfigPayload.ConfigAttributeIpv4Netmask());
            }
            return new TunnelModeChildSessionParams(this.mInboundTsList.toArray(new IkeTrafficSelector[0]), this.mOutboundTsList.toArray(new IkeTrafficSelector[0]), this.mSaProposalList.toArray(new ChildSaProposal[0]), this.mConfigRequestList.toArray(new IkeConfigPayload.TunnelModeChildConfigAttribute[0]), this.mHardLifetimeSec, this.mSoftLifetimeSec);
        }
    }

    public static interface ConfigRequestIpv6DnsServer
    extends TunnelModeChildConfigRequest {
    }

    public static interface ConfigRequestIpv6Address
    extends TunnelModeChildConfigRequest {
        public Inet6Address getAddress();

        public int getPrefixLength();
    }

    public static interface ConfigRequestIpv4Netmask
    extends TunnelModeChildConfigRequest {
    }

    public static interface ConfigRequestIpv4DnsServer
    extends TunnelModeChildConfigRequest {
    }

    public static interface ConfigRequestIpv4DhcpServer
    extends TunnelModeChildConfigRequest {
    }

    public static interface ConfigRequestIpv4Address
    extends TunnelModeChildConfigRequest {
        public Inet4Address getAddress();
    }

    public static interface TunnelModeChildConfigRequest {
    }
}

