/*
 * Decompiled with CFR 0.152.
 */
package android.net.connectivity.framework.util;

import android.net.LinkAddress;
import android.net.LinkProperties;
import android.net.RouteInfo;
import android.text.TextUtils;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

public class LinkPropertiesUtils {
    public static CompareResult<LinkAddress> compareAddresses(LinkProperties left, LinkProperties right2) {
        return new CompareResult<LinkAddress>(left != null ? left.getLinkAddresses() : null, right2 != null ? right2.getLinkAddresses() : null);
    }

    public static boolean isIdenticalAddresses(LinkProperties left, LinkProperties right2) {
        List<InetAddress> leftAddresses = left.getAddresses();
        List<InetAddress> rightAddresses = right2.getAddresses();
        return leftAddresses.size() == rightAddresses.size() ? leftAddresses.containsAll(rightAddresses) : false;
    }

    public static boolean isIdenticalDnses(LinkProperties left, LinkProperties right2) {
        List<InetAddress> leftDnses = left.getDnsServers();
        List<InetAddress> rightDnses = right2.getDnsServers();
        String leftDomains = left.getDomains();
        String rightDomains = right2.getDomains();
        if (leftDomains == null ? rightDomains != null : !leftDomains.equals(rightDomains)) {
            return false;
        }
        return leftDnses.size() == rightDnses.size() ? leftDnses.containsAll(rightDnses) : false;
    }

    public static boolean isIdenticalHttpProxy(LinkProperties left, LinkProperties right2) {
        return Objects.equals(left.getHttpProxy(), right2.getHttpProxy());
    }

    public static boolean isIdenticalInterfaceName(LinkProperties left, LinkProperties right2) {
        return TextUtils.equals(left.getInterfaceName(), right2.getInterfaceName());
    }

    public static boolean isIdenticalRoutes(LinkProperties left, LinkProperties right2) {
        List<RouteInfo> leftRoutes = left.getRoutes();
        List<RouteInfo> rightRoutes = right2.getRoutes();
        return leftRoutes.size() == rightRoutes.size() ? leftRoutes.containsAll(rightRoutes) : false;
    }

    public static class CompareOrUpdateResult<K, T> {
        public final List<T> added = new ArrayList<T>();
        public final List<T> removed = new ArrayList<T>();
        public final List<T> updated = new ArrayList<T>();

        public CompareOrUpdateResult(Collection<T> oldItems, Collection<T> newItems, Function<T, K> keyCalculator) {
            HashMap<K, T> updateTracker = new HashMap<K, T>();
            if (oldItems != null) {
                for (T oldItem : oldItems) {
                    updateTracker.put(keyCalculator.apply(oldItem), oldItem);
                }
            }
            if (newItems != null) {
                for (T newItem : newItems) {
                    Object oldItem = updateTracker.remove(keyCalculator.apply(newItem));
                    if (oldItem != null) {
                        if (oldItem.equals(newItem)) continue;
                        this.updated.add(newItem);
                        continue;
                    }
                    this.added.add(newItem);
                }
            }
            this.removed.addAll(updateTracker.values());
        }

        public String toString() {
            return "removed=[" + TextUtils.join((CharSequence)",", this.removed) + "] added=[" + TextUtils.join((CharSequence)",", this.added) + "] updated=[" + TextUtils.join((CharSequence)",", this.updated) + "]";
        }
    }

    public static class CompareResult<T> {
        public final List<T> removed = new ArrayList<T>();
        public final List<T> added = new ArrayList<T>();

        public CompareResult() {
        }

        public CompareResult(Collection<T> oldItems, Collection<T> newItems) {
            if (oldItems != null) {
                this.removed.addAll(oldItems);
            }
            if (newItems != null) {
                for (T newItem : newItems) {
                    if (this.removed.remove(newItem)) continue;
                    this.added.add(newItem);
                }
            }
        }

        public String toString() {
            return "removed=[" + TextUtils.join((CharSequence)",", this.removed) + "] added=[" + TextUtils.join((CharSequence)",", this.added) + "]";
        }
    }
}

