/*
 * Decompiled with CFR 0.152.
 */
package android.net.connectivity.framework.util;

import android.system.OsConstants;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.nio.ShortBuffer;

public class IpUtils {
    private static int intAbs(short v) {
        return v & 0xFFFF;
    }

    private static int checksum(ByteBuffer buf, int seed, int start, int end) {
        int sum = seed;
        int bufPosition = buf.position();
        buf.position(start);
        ShortBuffer shortBuf = buf.asShortBuffer();
        buf.position(bufPosition);
        int numShorts = (end - start) / 2;
        for (int i = 0; i < numShorts; ++i) {
            sum += IpUtils.intAbs(shortBuf.get(i));
        }
        if (end != (start += numShorts * 2)) {
            short b = buf.get(start);
            if (b < 0) {
                b = (short)(b + 256);
            }
            sum += b * 256;
        }
        sum = (sum >> 16 & 0xFFFF) + (sum & 0xFFFF);
        sum = sum + (sum >> 16 & 0xFFFF) & 0xFFFF;
        int negated = ~sum;
        return IpUtils.intAbs((short)negated);
    }

    private static int pseudoChecksumIPv4(ByteBuffer buf, int headerOffset, int protocol, int transportLen) {
        int partial = protocol + transportLen;
        partial += IpUtils.intAbs(buf.getShort(headerOffset + 12));
        partial += IpUtils.intAbs(buf.getShort(headerOffset + 14));
        partial += IpUtils.intAbs(buf.getShort(headerOffset + 16));
        return partial += IpUtils.intAbs(buf.getShort(headerOffset + 18));
    }

    private static int pseudoChecksumIPv6(ByteBuffer buf, int headerOffset, int protocol, int transportLen) {
        int partial = protocol + transportLen;
        for (int offset2 = 8; offset2 < 40; offset2 += 2) {
            partial += IpUtils.intAbs(buf.getShort(headerOffset + offset2));
        }
        return partial;
    }

    private static byte ipversion(ByteBuffer buf, int headerOffset) {
        return (byte)((buf.get(headerOffset) & 0xFFFFFFF0) >> 4);
    }

    public static short ipChecksum(ByteBuffer buf, int headerOffset) {
        byte ihl = (byte)(buf.get(headerOffset) & 0xF);
        return (short)IpUtils.checksum(buf, 0, headerOffset, headerOffset + ihl * 4);
    }

    private static short transportChecksum(ByteBuffer buf, int protocol, int ipOffset, int transportOffset, int transportLen) {
        int sum;
        if (transportLen < 0) {
            throw new IllegalArgumentException("Transport length < 0: " + transportLen);
        }
        byte ver = IpUtils.ipversion(buf, ipOffset);
        if (ver == 4) {
            sum = IpUtils.pseudoChecksumIPv4(buf, ipOffset, protocol, transportLen);
        } else if (ver == 6) {
            sum = IpUtils.pseudoChecksumIPv6(buf, ipOffset, protocol, transportLen);
        } else {
            throw new UnsupportedOperationException("Checksum must be IPv4 or IPv6");
        }
        sum = IpUtils.checksum(buf, sum, transportOffset, transportOffset + transportLen);
        if (protocol == OsConstants.IPPROTO_UDP && sum == 0) {
            sum = -1;
        }
        return (short)sum;
    }

    public static short udpChecksum(ByteBuffer buf, int ipOffset, int transportOffset) {
        int transportLen = IpUtils.intAbs(buf.getShort(transportOffset + 4));
        return IpUtils.transportChecksum(buf, OsConstants.IPPROTO_UDP, ipOffset, transportOffset, transportLen);
    }

    public static short tcpChecksum(ByteBuffer buf, int ipOffset, int transportOffset, int transportLen) {
        return IpUtils.transportChecksum(buf, OsConstants.IPPROTO_TCP, ipOffset, transportOffset, transportLen);
    }

    public static short icmpv6Checksum(ByteBuffer buf, int ipOffset, int transportOffset, int transportLen) {
        return IpUtils.transportChecksum(buf, OsConstants.IPPROTO_ICMPV6, ipOffset, transportOffset, transportLen);
    }

    public static String addressAndPortToString(InetAddress address, int port) {
        return String.format(address instanceof Inet6Address ? "[%s]:%d" : "%s:%d", address.getHostAddress(), port);
    }

    public static boolean isValidUdpOrTcpPort(int port) {
        return port > 0 && port < 65536;
    }
}

