/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.net.ITestNetworkManager;
import android.net.LinkAddress;
import android.net.LinkProperties;
import android.net.Network;
import android.net.TestNetworkInterface;
import android.os.IBinder;
import android.os.RemoteException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;

@SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
public class TestNetworkManager {
    public static final String TEST_TUN_PREFIX = "testtun";
    public static final String TEST_TAP_PREFIX = "testtap";
    private static final String TAG = TestNetworkManager.class.getSimpleName();
    private final ITestNetworkManager mService;

    public TestNetworkManager(ITestNetworkManager service) {
        this.mService = Objects.requireNonNull(service, "missing ITestNetworkManager");
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    @RequiresPermission(value="android.permission.MANAGE_TEST_NETWORKS")
    public void teardownTestNetwork(Network network) {
        try {
            this.mService.teardownTestNetwork(network.netId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private void setupTestNetwork(String iface, LinkProperties lp, boolean isMetered, int[] administratorUids, IBinder binder) {
        try {
            this.mService.setupTestNetwork(iface, lp, isMetered, administratorUids, binder);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void setupTestNetwork(LinkProperties lp, boolean isMetered, IBinder binder) {
        Objects.requireNonNull(lp, "Invalid LinkProperties");
        this.setupTestNetwork(lp.getInterfaceName(), lp, isMetered, new int[0], binder);
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    @RequiresPermission(value="android.permission.MANAGE_TEST_NETWORKS")
    public void setupTestNetwork(String iface, IBinder binder) {
        this.setupTestNetwork(iface, null, true, new int[0], binder);
    }

    public void setupTestNetwork(String iface, int[] administratorUids, IBinder binder) {
        this.setupTestNetwork(iface, null, true, administratorUids, binder);
    }

    @Deprecated
    public TestNetworkInterface createTunInterface(LinkAddress[] linkAddrs) {
        return this.createTunInterface(Arrays.asList(linkAddrs));
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    @RequiresPermission(value="android.permission.MANAGE_TEST_NETWORKS")
    public TestNetworkInterface createTunInterface(Collection<LinkAddress> linkAddrs) {
        try {
            LinkAddress[] arr = new LinkAddress[linkAddrs.size()];
            return this.mService.createTunInterface(linkAddrs.toArray(arr));
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    @RequiresPermission(value="android.permission.MANAGE_TEST_NETWORKS")
    public TestNetworkInterface createTapInterface() {
        try {
            return this.mService.createTapInterface();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }
}

