/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.annotation.SystemApi;
import android.net.NetworkKey;
import android.net.RssiCurve;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.Objects;
import java.util.Set;

@SystemApi
public class ScoredNetwork
implements Parcelable {
    public static final String ATTRIBUTES_KEY_BADGING_CURVE = "android.net.attributes.key.BADGING_CURVE";
    public static final String ATTRIBUTES_KEY_HAS_CAPTIVE_PORTAL = "android.net.attributes.key.HAS_CAPTIVE_PORTAL";
    public static final String ATTRIBUTES_KEY_RANKING_SCORE_OFFSET = "android.net.attributes.key.RANKING_SCORE_OFFSET";
    public final NetworkKey networkKey;
    public final RssiCurve rssiCurve;
    public final boolean meteredHint;
    public final Bundle attributes;
    public static final Parcelable.Creator<ScoredNetwork> CREATOR = new Parcelable.Creator<ScoredNetwork>(){

        @Override
        public ScoredNetwork createFromParcel(Parcel in) {
            return new ScoredNetwork(in);
        }

        public ScoredNetwork[] newArray(int size) {
            return new ScoredNetwork[size];
        }
    };

    public ScoredNetwork(NetworkKey networkKey, RssiCurve rssiCurve) {
        this(networkKey, rssiCurve, false);
    }

    public ScoredNetwork(NetworkKey networkKey, RssiCurve rssiCurve, boolean meteredHint) {
        this(networkKey, rssiCurve, meteredHint, null);
    }

    public ScoredNetwork(NetworkKey networkKey, RssiCurve rssiCurve, boolean meteredHint, Bundle attributes) {
        this.networkKey = networkKey;
        this.rssiCurve = rssiCurve;
        this.meteredHint = meteredHint;
        this.attributes = attributes;
    }

    private ScoredNetwork(Parcel in) {
        this.networkKey = NetworkKey.CREATOR.createFromParcel(in);
        this.rssiCurve = in.readByte() == 1 ? RssiCurve.CREATOR.createFromParcel(in) : null;
        this.meteredHint = in.readByte() == 1;
        this.attributes = in.readBundle();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        this.networkKey.writeToParcel(out, flags);
        if (this.rssiCurve != null) {
            out.writeByte((byte)1);
            this.rssiCurve.writeToParcel(out, flags);
        } else {
            out.writeByte((byte)0);
        }
        out.writeByte((byte)(this.meteredHint ? 1 : 0));
        out.writeBundle(this.attributes);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScoredNetwork that = (ScoredNetwork)o;
        return Objects.equals(this.networkKey, that.networkKey) && Objects.equals(this.rssiCurve, that.rssiCurve) && Objects.equals(this.meteredHint, that.meteredHint) && this.bundleEquals(this.attributes, that.attributes);
    }

    private boolean bundleEquals(Bundle bundle1, Bundle bundle2) {
        if (bundle1 == bundle2) {
            return true;
        }
        if (bundle1 == null || bundle2 == null) {
            return false;
        }
        if (bundle1.size() != bundle2.size()) {
            return false;
        }
        Set<String> keys = bundle1.keySet();
        for (String key : keys) {
            Object value2;
            Object value1 = bundle1.get(key);
            if (Objects.equals(value1, value2 = bundle2.get(key))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.networkKey, this.rssiCurve, this.meteredHint, this.attributes);
    }

    public String toString() {
        StringBuilder out = new StringBuilder("ScoredNetwork{networkKey=" + this.networkKey + ", rssiCurve=" + this.rssiCurve + ", meteredHint=" + this.meteredHint);
        if (this.attributes != null && !this.attributes.isEmpty()) {
            out.append(", attributes=" + this.attributes);
        }
        out.append('}');
        return out.toString();
    }

    public boolean hasRankingScore() {
        return this.rssiCurve != null || this.attributes != null && this.attributes.containsKey(ATTRIBUTES_KEY_RANKING_SCORE_OFFSET);
    }

    public int calculateRankingScore(int rssi) throws UnsupportedOperationException {
        if (!this.hasRankingScore()) {
            throw new UnsupportedOperationException("Either rssiCurve or rankingScoreOffset is required to calculate the ranking score");
        }
        int offset2 = 0;
        if (this.attributes != null) {
            offset2 += this.attributes.getInt(ATTRIBUTES_KEY_RANKING_SCORE_OFFSET, 0);
        }
        int score = this.rssiCurve == null ? 0 : this.rssiCurve.lookupScore(rssi) << 8;
        try {
            return Math.addExact(score, offset2);
        }
        catch (ArithmeticException e) {
            return score < 0 ? Integer.MIN_VALUE : Integer.MAX_VALUE;
        }
    }

    public int calculateBadge(int rssi) {
        if (this.attributes != null && this.attributes.containsKey(ATTRIBUTES_KEY_BADGING_CURVE)) {
            RssiCurve badgingCurve = (RssiCurve)this.attributes.getParcelable(ATTRIBUTES_KEY_BADGING_CURVE);
            return badgingCurve.lookupScore(rssi);
        }
        return 0;
    }
}

